import { CoordNodeSizeAccessor } from ".";
import { SugiNode } from "../utils";
/** solve for node positions */
export declare function solve(Q: number[][], c: number[], A: number[][], b: number[], meq?: number): number[];
/** compute indices used to index arrays */
export declare function indices(layers: SugiNode[][]): Map<SugiNode, number>;
/** Compute constraint arrays for layer separation */
export declare function init<N, L>(layers: SugiNode<N, L>[][], inds: Map<SugiNode, number>, nodeSize: CoordNodeSizeAccessor<N, L>): [number[][], number[], number[][], number[]];
/** update Q that minimizes edge distance squared */
export declare function minDist(Q: number[][], pind: number, cind: number, coef: number): void;
/**
 * update Q that minimizes curve of edges through a node where curve is
 * calculates as the squared distance of the middle node from the midpoint of
 * the first and last, multiplied by four for some reason
 */
export declare function minBend(Q: number[][], pind: number, nind: number, cind: number, coef: number): void;
/**
 * Assign nodes x based off of solution, and return the width of the final
 * layout.
 */
export declare function layout<N, L>(layers: SugiNode<N, L>[][], nodeSize: CoordNodeSizeAccessor<N, L>, inds: Map<SugiNode, number>, solution: number[]): number;
/**
 * Compute a map from node ids to a connected component index. This is useful
 * to quickly compare if two nodes are in the same connected component.
 *
 * @internal
 */
export declare function componentMap(layers: SugiNode[][]): Map<SugiNode, number>;
/**
 * If disconnected components exist in the same layer, then we can minimize the
 * distance between them to make a reasonable objective. If, however, layers
 * share no common components then they are truly independent in assignment of
 * x coordinates and should be solved separately.
 *
 * @internal
 */
export declare function splitComponentLayers<N, L>(layers: SugiNode<N, L>[][], compMap: Map<SugiNode, number>): SugiNode<N, L>[][][];
