/**
 * The {@link CenterOperator} centers all of the nodes as compactly as
 * possible. It produces generally poor layouts, but is very fast.
 *
 * @packageDocumentation
 */
import { CoordOperator } from ".";
/**
 * A {@link CoordOperator} that spaces every node out by node size, and then
 * centers them.
 *
 * This is a very fast operator, but doesn't produce very pleasing layouts.
 *
 * Create with {@link center}.
 *
 * <img alt="center example" src="media://sugi-simplex-opt-center.png" width="400">
 */
export declare type CenterOperator = CoordOperator<unknown, unknown>;
/**
 * Create a {@link CenterOperator}. Bundled as {@link coordCenter}.
 */
export declare function center(...args: never[]): CenterOperator;
