var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { Solve } from "javascript-lp-solver";
/** solve an lp with a better interface */
export function solve(optimize, opType, variables, constraints, ints = {}) {
    // NOTE bundling sets `this` to undefined, and we need it to be settable
    const _a = Solve.call({}, {
        optimize,
        opType,
        constraints,
        variables,
        ints,
    }), { feasible } = _a, assignment = __rest(_a, ["feasible"]);
    if (!feasible) {
        throw new Error("could not find a feasible simplex solution");
    }
    return assignment;
}
