import type { Edge } from '../types';
/**
 * This hook returns an array of the current edges. Components that use this hook
 * will re-render **whenever any edge changes**.
 *
 * @public
 * @returns An array of edges
 *
 * @example
 * ```tsx
 *import { useEdges } from '@xyflow/react';
 *
 *export default function () {
 *  const edges = useEdges();
 *
 *  return <div>There are currently {edges.length} edges!</div>;
 *}
 *```
 */
export declare function useEdges<EdgeType extends Edge = Edge>(): EdgeType[];
//# sourceMappingURL=useEdges.d.ts.map