import { jsxs, jsx, Fragment } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import { isString } from 'lodash';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import '../../utils/dom.js';
import 'react';
import '../../utils/colors.js';
import 'slate';
import { getCellLinks } from '../../utils/table.js';
import '../../utils/logger.js';
import { clearLinkButtonStyles, Button } from '../Button/Button.js';
import '../Button/ButtonGroup.js';
import { DataLinksContextMenu } from '../DataLinks/DataLinksContextMenu.js';
import { CellActions } from './CellActions.js';
import { TableCellInspectorMode } from './TableCellInspector.js';

function JSONViewCell(props) {
  var _a, _b;
  const { cell, tableStyles, cellProps, field, row, actions } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const txt = css({
    cursor: "pointer",
    fontFamily: "monospace"
  });
  let value = cell.value;
  let displayValue = value;
  if (isString(value)) {
    try {
      value = JSON.parse(value);
    } catch (e) {
    }
  } else {
    displayValue = JSON.stringify(value, null, " ");
  }
  const hasLinks = Boolean((_b = getCellLinks(field, row)) == null ? void 0 : _b.length);
  const hasActions = Boolean(actions == null ? void 0 : actions.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  return /* @__PURE__ */ jsxs("div", { ...cellProps, className: inspectEnabled ? tableStyles.cellContainerNoOverflow : tableStyles.cellContainer, children: [
    /* @__PURE__ */ jsx("div", { className: cx(tableStyles.cellText, txt), children: hasLinks || hasActions ? /* @__PURE__ */ jsx(DataLinksContextMenu, { links: () => getCellLinks(field, row) || [], actions, children: (api) => {
      if (api.openMenu) {
        return /* @__PURE__ */ jsx(Button, { className: cx(clearButtonStyle), onClick: api.openMenu, children: displayValue });
      } else {
        return /* @__PURE__ */ jsx(Fragment, { children: displayValue });
      }
    } }) : /* @__PURE__ */ jsx("div", { className: tableStyles.cellText, children: displayValue }) }),
    inspectEnabled && /* @__PURE__ */ jsx(CellActions, { ...props, previewMode: TableCellInspectorMode.code })
  ] });
}

export { JSONViewCell };
//# sourceMappingURL=JSONViewCell.js.map
