import { Meta } from '@grafana/faro-core';
import type { FaroUserSession } from './types';
type CreateUserSessionObjectParams = {
    sessionId?: string;
    started?: number;
    lastActivity?: number;
    isSampled?: boolean;
};
export declare function createUserSessionObject({ sessionId, started, lastActivity, isSampled, }?: CreateUserSessionObjectParams): FaroUserSession;
export declare function isUserSessionValid(session: FaroUserSession | null): boolean;
type GetUserSessionUpdaterParams = {
    storeUserSession: (session: FaroUserSession) => void;
    fetchUserSession: () => FaroUserSession | null;
};
type UpdateSessionParams = {
    forceSessionExtend: boolean;
};
export declare function getUserSessionUpdater({ fetchUserSession, storeUserSession, }: GetUserSessionUpdaterParams): (options?: UpdateSessionParams) => void;
export declare function addSessionMetadataToNextSession(newSession: FaroUserSession, previousSession: FaroUserSession | null): Required<FaroUserSession>;
type GetUserSessionMetaUpdateHandlerParams = {
    storeUserSession: (session: FaroUserSession) => void;
    fetchUserSession: () => FaroUserSession | null;
};
export declare function getSessionMetaUpdateHandler({ fetchUserSession, storeUserSession, }: GetUserSessionMetaUpdateHandlerParams): (meta: Meta) => void;
export {};
