import { onCLS, onFCP, onFID, onINP, onLCP, onTTFB } from 'web-vitals';
export class WebVitalsBasic {
    constructor(pushMeasurement, webVitalConfig) {
        this.pushMeasurement = pushMeasurement;
        this.webVitalConfig = webVitalConfig;
    }
    initialize() {
        Object.entries(WebVitalsBasic.mapping).forEach(([indicator, executor]) => {
            var _a;
            executor((metric) => {
                this.pushMeasurement({
                    type: 'web-vitals',
                    values: {
                        [indicator]: metric.value,
                    },
                });
            }, { reportAllChanges: (_a = this.webVitalConfig) === null || _a === void 0 ? void 0 : _a.reportAllChanges });
        });
    }
}
WebVitalsBasic.mapping = {
    cls: onCLS,
    fcp: onFCP,
    fid: onFID,
    inp: onINP,
    lcp: onLCP,
    ttfb: onTTFB,
};
//# sourceMappingURL=webVitalsBasic.js.map