import { BaseInstrumentation, VERSION } from '@grafana/faro-core';
import { WebVitalsBasic } from './webVitalsBasic';
import { WebVitalsWithAttribution } from './webVitalsWithAttribution';
export class WebVitalsInstrumentation extends BaseInstrumentation {
    constructor() {
        super(...arguments);
        this.name = '@grafana/faro-web-sdk:instrumentation-web-vitals';
        this.version = VERSION;
    }
    initialize() {
        this.logDebug('Initializing');
        const webVitals = this.intializeWebVitalsInstrumentation();
        webVitals.initialize();
    }
    intializeWebVitalsInstrumentation() {
        var _a;
        if ((_a = this.config) === null || _a === void 0 ? void 0 : _a.trackWebVitalsAttribution) {
            return new WebVitalsWithAttribution(this.api.pushMeasurement, this.config.webVitalsInstrumentation);
        }
        return new WebVitalsBasic(this.api.pushMeasurement, this.config.webVitalsInstrumentation);
    }
}
//# sourceMappingURL=instrumentation.js.map