"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerOnerror = void 0;
var getErrorDetails_1 = require("./getErrorDetails");
function registerOnerror(api) {
    var oldOnerror = window.onerror;
    window.onerror = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        try {
            var _a = (0, getErrorDetails_1.getDetailsFromErrorArgs)(args), value = _a.value, type = _a.type, stackFrames = _a.stackFrames;
            if (value) {
                api.pushError(new Error(value), { type: type, stackFrames: stackFrames });
            }
        }
        finally {
            oldOnerror === null || oldOnerror === void 0 ? void 0 : oldOnerror.apply(window, args);
        }
    };
}
exports.registerOnerror = registerOnerror;
//# sourceMappingURL=registerOnerror.js.map