import type { Config } from '../config';
import type { Metas } from '../metas';
import type { Extension } from './types';
export declare abstract class BaseExtension implements Extension {
    abstract readonly name: string;
    abstract readonly version: string;
    unpatchedConsole: Console;
    internalLogger: import("../internalLogger").InternalLogger;
    config: Config<import("..").APIEvent>;
    metas: Metas;
    logDebug(...args: unknown[]): void;
    logInfo(...args: unknown[]): void;
    logWarn(...args: unknown[]): void;
    logError(...args: unknown[]): void;
}
