"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var initialize_1 = require("../initialize");
var testUtils_1 = require("../testUtils");
describe('metas', function () {
    it('can set listeners and they will be notified on meta changes', function () {
        var metas = (0, initialize_1.initializeFaro)((0, testUtils_1.mockConfig)()).metas;
        var listener = jest.fn(function () { });
        metas.addListener(listener);
        metas.add({ user: { id: 'foo' } });
        expect(listener).toHaveBeenCalledTimes(1);
        expect(listener).toHaveBeenLastCalledWith(metas.value);
        metas.add({ session: { id: '1' } });
        expect(listener).toHaveBeenCalledTimes(2);
        metas.removeListener(listener);
        metas.add({ session: { id: '2' } });
        expect(listener).toHaveBeenCalledTimes(2);
    });
});
//# sourceMappingURL=initialize.test.js.map