.\"
.\" rpc.gssd(8)
.\"
.\" Copyright (C) 2003 J. Bruce Fields <bfields@umich.edu>
.\"
.TH rpc.gssd 8 "20 Feb 2013"
.SH NAME
rpc.gssd \- RPCSEC_GSS daemon
.SH SYNOPSIS
.B rpc.gssd
.RB [ \-DfMnlvrHC ]
.RB [ \-k
.IR keytab ]
.RB [ \-p
.IR pipefsdir ]
.RB [ \-d
.IR ccachedir ]
.RB [ \-t
.IR timeout ]
.RB [ \-T
.IR timeout ]
.RB [ \-U
.IR timeout ]
.RB [ \-R
.IR realm ]
.SH INTRODUCTION
The RPCSEC_GSS protocol, defined in RFC 5403, is used to provide
strong security for RPC-based protocols such as NFS.
.P
Before exchanging RPC requests using RPCSEC_GSS, an RPC client must
establish a GSS
.IR "security context" .
A security context is shared state on each
end of a network transport that enables GSS-API security services.
.P
Security contexts are established using
.IR "security credentials" .
A credential grants temporary access to a secure network service,
much as a railway ticket grants temporary access to use a rail service.
.P
A user typically obtains a credential by providing a password to the
.BR kinit (1)
command, or via a PAM library at login time.
A credential acquired with a
.I user principal
is known as a
.I user credential
(see
.BR kerberos (1)
for more on principals).
.P
Certain operations require a credential that
represents no particular user
or
represents the host itself.
This kind of credential is called a
.IR "machine credential" .
.P
A host establishes its machine credential using a
.I "service principal"
whose encrypted password is stored in a local file known as a
.IR keytab .
A machine credential remains effective
without user intervention
as long as the host can renew it.
.P
Once obtained, credentials are typically stored in local temporary files
with well-known pathnames.
.SH DESCRIPTION
To establish GSS security contexts using these credential files,
the Linux kernel RPC client depends on a userspace daemon called
.BR rpc.gssd .
The
.B rpc.gssd
daemon uses the rpc_pipefs filesystem to communicate with the kernel.
.SS User Credentials
When a user authenticates using a command such as
.BR kinit (1),
the resulting credential is stored in a file with a well-known name
constructed using the user's UID.
.P
To interact with an NFS server
on behalf of a particular Kerberos-authenticated user,
the Linux kernel RPC client requests that
.B rpc.gssd
initialize a security context with the credential
in that user's credential file.
.P
Typically, credential files are placed in
.IR /tmp .
However,
.B rpc.gssd
can search for credential files in more than one directory.
See the description of the
.B -d
option for details.
.SS Machine Credentials
.B rpc.gssd
searches the default keytab,
.IR /etc/krb5.keytab ,
in the following order for a principal and password to use
when establishing the machine credential.
For the search, rpc.gssd replaces <hostname> and <REALM> with the local
system's hostname and Kerberos realm.
.sp
   <HOSTNAME>$@<REALM>
.br
   root/<hostname>@<REALM>
.br
   nfs/<hostname>@<REALM>
.br
   host/<hostname>@<REALM>
.br
   root/<anyname>@<REALM>
.br
   nfs/<anyname>@<REALM>
.br
   host/<anyname>@<REALM>
.sp
rpc.gssd selects one of the <anyname> entries if it does not find
a service principal matching the local hostname,
e.g. if DHCP assigns the local hostname dynamically.
The <anyname> facility enables the use of the same keytab on multiple systems.
However, using the same service principal to establish a machine credential
on multiple hosts can create unwanted security exposures
and is therefore not recommended.
.P
Note that <HOSTNAME>$@<REALM> is a user principal
that enables Kerberized NFS when the local system is joined
to an Active Directory domain using Samba.
The keytab provides the password for this principal.
.P
You can specify a different keytab by using the
.B -k
option if
.I /etc/krb5.keytab
does not exist or does not provide one of these principals.
.SS Credentials for UID 0
UID 0 is a special case.
By default
.B rpc.gssd
uses the system's machine credentials for UID 0 accesses
that require GSS authentication.
This limits the privileges of the root user
when accessing network resources that require authentication.
.P
Specify the
.B -n
option when starting
.B rpc.gssd
if you'd like to force the root user to obtain a user credential
rather than use the local system's machine credential.
.P
When
.B -n
is specified,
the kernel continues to request a GSS context established
with a machine credential for NFSv4 operations,
such as SETCLIENTID or RENEW, that manage state.
If
.B rpc.gssd
cannot obtain a machine credential (say, the local system has
no keytab), NFSv4 operations that require machine credentials will fail.
.SS Encryption types
A realm administrator can choose to add keys encoded in a number of different
encryption types to the local system's keytab.
For instance, a host/ principal might have keys for the
.BR aes256-cts-hmac-sha1-96 ,
.BR aes128-cts-hmac-sha1-96 ,
.BR des3-cbc-sha1 ", and"
.BR arcfour-hmac " encryption types."
This permits
.B rpc.gssd
to choose an appropriate encryption type that the target NFS server
supports.
.P
These encryption types are stronger than legacy single-DES encryption types.
To interoperate in environments where servers support
only weak encryption types,
you can restrict your client to use only single-DES encryption types
by specifying the
.B -l
option when starting
.BR rpc.gssd .
.SH OPTIONS
.TP
.B \-D
The server name passed to GSSAPI for authentication is normally the
name exactly as requested.  e.g. for NFS
it is the server name in the "servername:/path" mount request.  Only if this
servername appears to be an IP address (IPv4 or IPv6) or an
unqualified name (no dots) will a reverse DNS lookup
will be performed to get the canoncial server name.

If
.B \-D
is present, a reverse DNS lookup will
.I always
be used, even if the server name looks like a canonical name.  So it
is needed if partially qualified, or non canonical names are regularly
used.

Using
.B \-D
can introduce a security vulnerability, so it is recommended that
.B \-D
not be used, and that canonical names always be used when requesting
services.
.TP
.B -f
Runs
.B rpc.gssd
in the foreground and sends output to stderr (as opposed to syslogd)
.TP
.B -n
When specified, UID 0 is forced to obtain user credentials
which are used instead of the local system's machine credentials.
.TP
.BI "-k " keytab
Tells
.B rpc.gssd
to use the keys found in
.I keytab
to obtain machine credentials.
The default value is
.IR /etc/krb5.keytab .
.TP
.B -l
When specified, restricts
.B rpc.gssd
to sessions to weak encryption types such as
.BR des-cbc-crc .
This option is available only when the local system's Kerberos library
supports settable encryption types.
.TP
.BI "-p " path
Tells
.B rpc.gssd
where to look for the rpc_pipefs filesystem.  The default value is
.IR /var/lib/nfs/rpc_pipefs .
.TP
.BI "-d " search-path
This option specifies a colon separated list of directories that
.B rpc.gssd
searches for credential files.  The default value is
.IR /tmp:/run/user/%U .
The literal sequence "%U" can be specified to substitue the UID
of the user for whom credentials are being searched.
.TP
.B -M
By default, machine credentials are stored in files in the first
directory in the credential directory search path (see the
.B -d
option).  When
.B -M
is set,
.B rpc.gssd
stores machine credentials in memory instead.
.TP
.B -v
Increases the verbosity of the output (can be specified multiple times).
.TP
.B -r
If the RPCSEC_GSS library supports setting debug level,
increases the verbosity of the output (can be specified multiple times).
.TP
.BI "-R " realm
Kerberos tickets from this
.I realm
will be preferred when scanning available credentials cache files to be
used to create a context.  By default, the default realm, as configured
in the Kerberos configuration file, is preferred.
.TP
.BI "-t " timeout
Timeout, in seconds, for kernel GSS contexts. This option allows you to force 
new kernel contexts to be negotiated after
.I timeout
seconds, which allows changing Kerberos tickets and identities frequently.
The default is no explicit timeout, which means the kernel context will live
the lifetime of the Kerberos service ticket used in its creation.
.TP
.BI "-T " timeout
Timeout, in seconds, to create an RPC connection with a server while
establishing an authenticated gss context for a user.
The default timeout is set to 5 seconds.
If you get messages like "WARNING: can't create tcp rpc_clnt to server
%servername% for user with uid %uid%: RPC: Remote system error -
Connection timed out", you should consider an increase of this timeout.
.TP
.BI "-U " timeout
Timeout, in seconds, for upcall threads.  Threads executing longer than
.I timeout
seconds will cause an error message to be logged.  The default
.I timeout
is 30 seconds.  The minimum is 5 seconds.  The maximum is 600 seconds.
.TP
.B -C
In addition to logging an error message for threads that have timed out,
the thread will be canceled and an error of -ETIMEDOUT will be reported
to the kernel.
.TP
.B -H
Avoids setting $HOME to "/". This allows rpc.gssd to read per user k5identity
files versus trying to read /.k5identity for each user.

If
.B \-H
is not set, rpc.gssd will use the first match found in
/var/kerberos/krb5/user/$EUID/client.keytab and will not use a principal based on
host and/or service parameters listed in $HOME/.k5identity.
.SH CONFIGURATION FILE
Many of the options that can be set on the command line can also be
controlled through values set in the
.B [gssd]
section of the
.I /etc/nfs.conf
configuration file.  Values recognized include:
.TP
.B verbosity
Value which is equivalent to the number of
.BR -v .
.TP
.B rpc-verbosity
Value which is equivalent to the number of
.BR -r .
.TP
.B use-memcache
A Boolean flag equivalent to
.BR -M .
.TP
.B use-machine-creds
A Boolean flag. Setting to
.B false
is equivalent to giving the
.B -n
flag.
.TP
.B avoid-dns
Setting to
.B false
is equivalent to providing the
.B -D
flag.
.TP
.B limit-to-legacy-enctypes
Equivalent to
.BR -l .
.TP
.B allowed-enctypes
Allows you to restrict
.B rpc.gssd
to using a subset of the encryption types permitted by the kernel and the krb5
libraries.  This is useful if you need to interoperate with an NFS server that
does not have support for the newer SHA2 and Camellia encryption types, for
example.  This configuration file option does not have an equivalent
command-line option.
.TP
.B context-timeout
Equivalent to
.BR -t .
.TP
.B rpc-timeout
Equivalent to
.BR -T .
.TP
.B keytab-file
Equivalent to
.BR -k .
.TP
.BR cred-cache-directory
Equivalent to
.BR -d .
.TP
.B preferred-realm
Equivalent to
.BR -R .
.TP
.B upcall-timeout
Equivalent to
.BR -U .
.TP
.B cancel-timed-out-upcalls
Setting to
.B true
is equivalent to providing the
.B -C
flag.
.TP
.B set-home
Setting to
.B false
is equivalent to providing the
.B -H
flag.
.P
In addtion, the following value is recognized from the
.B [general]
section:
.TP
.B pipefs-directory
Equivalent to
.BR -p .

.SH SEE ALSO
.BR rpc.svcgssd (8),
.BR kerberos (1),
.BR kinit (1),
.BR krb5.conf (5)
.SH AUTHORS
.br
Dug Song <dugsong@umich.edu>
.br
Andy Adamson <andros@umich.edu>
.br
Marius Aamodt Eriksen <marius@umich.edu>
.br
J. Bruce Fields <bfields@umich.edu>
