/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.Timestamper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NonstrictReadWriteCache
implements CacheConcurrencyStrategy {
    private static final long TIMEOUT = 10000L;
    private final Cache cache;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cache$ReadWriteCache == null ? (class$net$sf$hibernate$cache$ReadWriteCache = NonstrictReadWriteCache.class$("net.sf.hibernate.cache.ReadWriteCache")) : class$net$sf$hibernate$cache$ReadWriteCache));
    static /* synthetic */ Class class$net$sf$hibernate$cache$ReadWriteCache;

    public NonstrictReadWriteCache(Cache cache) {
        this.cache = cache;
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        Object result = this.cache.get(key);
        if (result != null && !(result instanceof Long)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache hit: " + key));
            }
            return result;
        }
        return null;
    }

    public void lock(Object key) throws CacheException {
        this.cache.put(key, new Long(10000L + Timestamper.next() / 4096L));
    }

    public boolean put(Object key, Object value, long txTimestamp) throws CacheException {
        Object result = this.cache.get(key);
        if (result == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caching new: " + key));
            }
        } else if (result instanceof Long && (Long)result < txTimestamp / 4096L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caching invalidated: " + key));
            }
        } else {
            return false;
        }
        this.cache.put(key, value);
        return true;
    }

    public void release(Object key) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invalidating: " + key));
        }
        this.cache.put(key, new Long(Timestamper.next() / 4096L));
    }

    public void remove(Object key) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing: " + key));
        }
        this.cache.remove(key);
    }

    public void clear() throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Clearing");
        }
        this.cache.clear();
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn((Object)"could not destroy cache", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

