sys.version_info(major=3, minor=7, micro=16, releaselevel='final', serial=0)

### Timing comparison of `int` functions

| Input type        | builtin (ms)       | fastnumbers (ms)   |
| ----------------: | -----------------: | -----------------: |
|  Small Int String |   18.492 ± 1.558   | **13.443 ± 2.873** |
|        Int String |   18.950 ± 1.178   | **14.832 ± 1.002** |
| Medium Int String |   20.554 ± 0.431   | **15.571 ± 2.192** |
|  Large Int String |   26.547 ± 0.755   | **26.061 ± 2.948** |
|               Int |   10.772 ± 0.438   | **10.484 ± 0.548** |
|             Float | **22.680 ± 0.944** |   24.013 ± 0.891   |

### Timing comparison of `float` functions

| Input type         | builtin (ms)       | fastnumbers (ms)   |
| -----------------: | -----------------: | -----------------: |
|   Small Int String |   15.585 ± 1.017   | **13.691 ± 0.410** |
|         Int String |   16.137 ± 1.180   | **13.899 ± 0.280** |
|  Medium Int String |   16.784 ± 0.512   | **14.746 ± 0.385** |
|   Large Int String |   39.173 ± 1.027   | **19.613 ± 0.893** |
| Small Float String | **16.671 ± 3.250** |   16.785 ± 2.395   |
|       Float String |   44.336 ± 2.605   | **19.556 ± 0.994** |
| Large Float String |   72.683 ± 5.371   | **20.614 ± 2.126** |
|                Int | **12.105 ± 0.379** |   14.045 ± 0.374   |
|              Float | **11.232 ± 0.462** |   12.465 ± 0.638   |

### Timing comparison of `int` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |  181.248 ± 10.504  |  40.104 ± 0.699 | **29.361 ± 0.597** |
|   Small Int String |   31.774 ± 0.496   |  65.478 ± 0.636 | **28.557 ± 0.920** |
|         Int String |   32.852 ± 0.565   |  74.666 ± 2.992 | **32.476 ± 0.299** |
|  Medium Int String |   36.822 ± 1.238   |  84.148 ± 0.957 | **31.932 ± 0.767** |
|   Large Int String | **43.944 ± 2.517** | 112.196 ± 3.438 |   47.543 ± 1.731   |
| Small Float String |  166.168 ± 4.919   |  51.944 ± 3.238 | **32.968 ± 1.646** |
|       Float String |  175.452 ± 3.866   |  54.230 ± 0.733 | **30.191 ± 0.292** |
| Large Float String |  176.572 ± 3.389   |  57.476 ± 1.427 | **32.707 ± 0.968** |
|                Int | **24.987 ± 0.665** | 102.499 ± 1.835 |   26.025 ± 0.887   |
|              Float | **37.035 ± 0.802** | 111.166 ± 1.799 |   41.496 ± 2.037   |

### Timing comparison of `float` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |   95.111 ± 3.735   |  55.494 ± 2.576 | **35.130 ± 0.507** |
|   Small Int String | **29.882 ± 0.323** |  82.469 ± 1.202 |   31.334 ± 0.450   |
|         Int String | **30.897 ± 0.175** |  97.082 ± 2.160 |   35.200 ± 0.918   |
|  Medium Int String |   34.836 ± 0.600   | 105.789 ± 2.380 | **33.603 ± 0.621** |
|   Large Int String |   58.773 ± 0.161   | 144.883 ± 2.560 | **38.455 ± 1.023** |
| Small Float String | **28.763 ± 0.434** |  79.134 ± 0.885 |   30.725 ± 0.253   |
|       Float String |   51.571 ± 1.572   | 131.249 ± 4.888 | **34.240 ± 0.509** |
| Large Float String |   83.568 ± 4.289   | 165.976 ± 5.053 | **35.263 ± 0.367** |
|                Int | **23.409 ± 0.369** | 104.484 ± 2.531 |   29.419 ± 0.229   |
|              Float | **21.641 ± 0.223** |  97.685 ± 0.570 |   26.933 ± 0.342   |

### Timing comparison of `float` (but coerce to `int` if possible) functions with error handling

| Input type         | try/except (ms)  | regex (ms)       | fastnumbers (ms)   |
| -----------------: | ---------------: | ---------------: | -----------------: |
|  Non-number String |  97.024 ± 2.848  |  85.273 ± 1.053  | **34.931 ± 2.575** |
|   Small Int String |  56.887 ± 0.598  |  73.155 ± 4.604  | **31.803 ± 0.453** |
|         Int String |  60.894 ± 2.876  |  78.413 ± 2.697  | **37.186 ± 0.595** |
|  Medium Int String |  70.703 ± 4.991  |  86.057 ± 1.662  | **33.614 ± 0.732** |
|   Large Int String | 102.731 ± 5.338  | 112.028 ± 3.845  | **45.225 ± 0.789** |
| Small Float String |  53.630 ± 1.232  | 119.587 ± 5.978  | **32.088 ± 0.530** |
|       Float String | 108.208 ± 14.258 | 181.574 ± 14.667 | **43.376 ± 0.915** |
| Large Float String | 163.967 ± 5.809  | 206.731 ± 7.002  | **58.475 ± 0.582** |
|                Int |  47.026 ± 0.489  | 101.903 ± 1.523  | **25.980 ± 0.369** |
|              Float |  74.574 ± 1.088  | 116.164 ± 6.403  | **44.735 ± 2.882** |

### Timing comparison of forced `int` functions with error handling

| Input type         | try/except (ms)    | regex (ms)       | fastnumbers (ms)   |
| -----------------: | -----------------: | ---------------: | -----------------: |
|  Non-number String |  280.455 ± 15.342  |  73.340 ± 1.544  | **32.370 ± 0.729** |
|   Small Int String |   31.666 ± 0.268   |  65.351 ± 2.319  | **31.459 ± 1.717** |
|         Int String |   33.905 ± 0.255   |  74.778 ± 8.272  | **31.145 ± 0.912** |
|  Medium Int String |   34.297 ± 0.800   | 145.180 ± 4.695  | **31.286 ± 0.403** |
|   Large Int String | **40.254 ± 0.432** | 181.170 ± 6.953  |   42.179 ± 1.042   |
| Small Float String |  189.084 ± 3.688   | 123.072 ± 4.071  | **34.565 ± 0.535** |
|       Float String |  237.215 ± 3.797   | 178.502 ± 3.473  | **43.137 ± 0.322** |
| Large Float String |  299.875 ± 3.639   | 249.003 ± 14.838 | **66.648 ± 2.127** |
|                Int | **22.433 ± 0.367** |  96.230 ± 2.930  |   24.248 ± 0.194   |
|              Float | **34.520 ± 0.475** | 107.538 ± 2.271  |   39.348 ± 0.690   |

### Timing comparison to check if value can be converted to `int`

| Input type         | try/except (ms)  | regex (ms)      | fastnumbers (ms)   |
| -----------------: | ---------------: | --------------: | -----------------: |
|  Non-number String | 167.191 ± 3.509  |  80.446 ± 2.440 | **15.665 ± 0.518** |
|   Small Int String |  44.787 ± 0.740  |  79.697 ± 1.120 | **17.040 ± 1.068** |
|         Int String |  49.429 ± 0.928  |  91.809 ± 7.419 | **16.855 ± 0.418** |
|  Medium Int String |  49.653 ± 0.694  |  96.347 ± 3.921 | **17.963 ± 0.979** |
|   Large Int String |  59.494 ± 0.779  | 120.027 ± 3.064 | **17.975 ± 0.118** |
| Small Float String | 181.434 ± 18.632 |  96.831 ± 7.084 | **19.762 ± 3.148** |
|       Float String | 179.713 ± 7.931  | 100.555 ± 4.323 | **20.960 ± 3.773** |
| Large Float String | 187.430 ± 3.820  | 104.069 ± 4.713 | **21.572 ± 3.280** |
|                Int |  40.318 ± 2.594  |  40.800 ± 2.210 | **15.614 ± 1.768** |
|              Float |  54.958 ± 0.960  |  37.148 ± 1.588 | **14.975 ± 0.062** |

### Timing comparison to check if value can be converted to `float`

| Input type         | try/except (ms) | regex (ms)       | fastnumbers (ms)   |
| -----------------: | --------------: | ---------------: | -----------------: |
|  Non-number String | 100.437 ± 2.149 |  85.398 ± 10.305 | **17.936 ± 0.548** |
|   Small Int String |  45.351 ± 0.772 |  94.174 ± 4.119  | **17.206 ± 0.071** |
|         Int String |  43.862 ± 0.562 | 112.023 ± 22.924 | **20.747 ± 3.827** |
|  Medium Int String |  49.095 ± 0.653 | 101.393 ± 1.863  | **16.791 ± 0.007** |
|   Large Int String |  78.826 ± 3.151 | 123.459 ± 7.120  | **18.056 ± 1.290** |
| Small Float String |  45.409 ± 1.793 |  85.398 ± 1.184  | **17.781 ± 0.031** |
|       Float String |  65.984 ± 2.799 | 123.243 ± 11.227 | **19.456 ± 0.327** |
| Large Float String |  94.924 ± 2.485 | 112.418 ± 2.626  | **20.462 ± 0.985** |
|                Int |  37.291 ± 0.909 |  34.940 ± 0.586  | **14.436 ± 0.027** |
|              Float |  34.362 ± 0.600 |  32.155 ± 0.677  | **14.308 ± 0.169** |

### Timing comparison to check if value can be converted to `float` or `int`

| Input type         | try/except (ms) | regex (ms)      | fastnumbers (ms)   |
| -----------------: | --------------: | --------------: | -----------------: |
|  Non-number String |  99.365 ± 2.416 |  84.396 ± 2.536 | **19.400 ± 1.396** |
|   Small Int String |  30.614 ± 0.531 |  90.333 ± 1.440 | **16.776 ± 0.305** |
|         Int String |  29.965 ± 1.010 | 103.955 ± 3.801 | **18.529 ± 0.806** |
|  Medium Int String |  33.165 ± 1.213 | 107.222 ± 7.073 | **17.756 ± 0.672** |
|   Large Int String |  61.291 ± 2.660 | 117.750 ± 3.387 | **16.945 ± 0.221** |
| Small Float String |  29.293 ± 0.476 |  89.788 ± 1.568 | **18.208 ± 0.233** |
|       Float String |  51.701 ± 0.819 | 104.643 ± 1.845 | **17.642 ± 0.116** |
| Large Float String |  76.931 ± 2.209 | 113.059 ± 1.234 | **17.745 ± 0.013** |
|                Int |  21.649 ± 0.250 |  29.873 ± 0.160 | **14.299 ± 0.270** |
|              Float |  20.913 ± 0.199 |  28.431 ± 0.294 | **14.102 ± 0.249** |

### Timing comparison to check if value can be coerced losslessly to `int`

| Input type         | try/except (ms) | regex (ms)      | fastnumbers (ms)   |
| -----------------: | --------------: | --------------: | -----------------: |
|  Non-number String | 258.167 ± 8.754 |  70.654 ± 0.816 | **16.161 ± 0.325** |
|   Small Int String |  62.746 ± 0.528 |  45.058 ± 1.185 | **16.485 ± 0.188** |
|         Int String |  63.423 ± 0.855 |  49.169 ± 0.630 | **16.516 ± 0.034** |
|  Medium Int String |  67.605 ± 0.881 |  54.139 ± 0.380 | **15.840 ± 0.233** |
|   Large Int String | 104.735 ± 1.392 |  70.060 ± 0.756 | **16.039 ± 0.330** |
| Small Float String | 192.902 ± 5.763 | 110.261 ± 2.496 | **16.244 ± 0.232** |
|       Float String | 229.026 ± 4.354 | 161.774 ± 2.021 | **17.377 ± 0.253** |
| Large Float String | 265.513 ± 3.916 | 197.812 ± 2.809 | **18.097 ± 1.274** |
|                Int |  43.850 ± 1.171 |  98.423 ± 5.141 | **13.802 ± 0.897** |
|              Float |  72.895 ± 0.955 | 132.667 ± 3.314 | **13.337 ± 0.152** |

### Timing comparison of `map` option vs. iterating over `try_float` for a 50 element list

| Input type         | [try_float(x) for x in iterable] (ms) | list(map(try_float, iterable)) (ms) | list(try_float(iterable, map=True)) (ms) | try_float(iterable, map=list) (ms) |
| -----------------: | ------------------------------------: | ----------------------------------: | ---------------------------------------: | ---------------------------------: |
|  Non-number String |                     1675.566 ± 26.121 |                   1595.255 ± 39.520 |                         631.079 ± 7.283  |               **563.415 ± 21.733** |
|   Small Int String |                     1613.768 ± 18.402 |                   1501.392 ± 57.648 |                         504.206 ± 3.518  |               **442.391 ± 0.797**  |
|         Int String |                     1442.778 ± 15.334 |                   1373.616 ± 16.840 |                         514.956 ± 7.282  |               **458.830 ± 4.594**  |
|  Medium Int String |                     1462.945 ± 11.640 |                   1412.144 ± 18.371 |                         551.913 ± 6.763  |               **520.005 ± 16.900** |
|   Large Int String |                     1980.722 ± 36.741 |                   1862.050 ± 29.796 |                         867.686 ± 24.647 |               **772.653 ± 5.732**  |
| Small Float String |                     1648.982 ± 4.386  |                   1602.074 ± 43.868 |                         599.790 ± 7.464  |               **522.700 ± 4.994**  |
|       Float String |                     1745.643 ± 3.224  |                   1683.681 ± 9.725  |                         659.025 ± 3.175  |               **602.141 ± 19.670** |
| Large Float String |                     1766.833 ± 8.167  |                   1692.317 ± 4.062  |                         669.112 ± 2.019  |               **597.568 ± 8.448**  |
|                Int |                     1466.055 ± 3.302  |                   1393.419 ± 24.103 |                         452.565 ± 4.473  |               **387.288 ± 1.464**  |
|              Float |                     1416.448 ± 10.795 |                   1370.934 ± 67.480 |                         420.926 ± 2.786  |               **349.819 ± 2.130**  |

### Timing comparison of `try_array` vs. `map` option for a 50 element list to a numpy array

| Input type         | np.array(try_float(iterable, map=True)) (ms) | try_array(iterable) (ms) | try_array(iterable, output) (ms) |
| -----------------: | -------------------------------------------: | -----------------------: | -------------------------------: |
|   Small Int String |                             816.455 ± 12.503 |         430.329 ± 9.079  |              **337.951 ± 1.485** |
|         Int String |                             805.692 ± 6.858  |         436.277 ± 4.390  |              **354.996 ± 4.282** |
|  Medium Int String |                             821.827 ± 6.694  |         451.937 ± 4.328  |              **367.192 ± 2.760** |
|   Large Int String |                            1063.477 ± 4.983  |         697.205 ± 2.071  |              **621.098 ± 3.495** |
| Small Float String |                             827.969 ± 10.856 |         455.198 ± 10.985 |              **360.429 ± 4.520** |
|       Float String |                             901.801 ± 11.906 |         535.390 ± 7.637  |              **448.186 ± 5.311** |
| Large Float String |                             876.733 ± 33.624 |         491.299 ± 6.308  |              **408.396 ± 4.583** |
|                Int |                             603.832 ± 4.818  |         392.439 ± 18.852 |              **313.024 ± 2.858** |
|              Float |                             569.313 ± 4.290  |         336.981 ± 1.757  |              **266.090 ± 1.708** |

