/*
 * Decompiled with CFR 0.152.
 */
package antlr.preprocessor;

import antlr.collections.impl.Vector;
import antlr.preprocessor.GrammarFile;
import antlr.preprocessor.Hierarchy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;

public class Tool {
    protected Hierarchy theHierarchy;
    protected String grammarFileName;
    protected String[] args;
    protected int nargs;
    protected Vector grammars;
    protected antlr.Tool antlrTool;

    public Tool(antlr.Tool tool, String[] stringArray) {
        this.antlrTool = tool;
        this.processArguments(stringArray);
    }

    public static void main(String[] stringArray) {
        antlr.Tool tool = new antlr.Tool();
        Tool tool2 = new Tool(tool, stringArray);
        tool2.preprocess();
        String[] stringArray2 = tool2.preprocessedArgList();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.print(" " + stringArray2[n]);
            ++n;
        }
        System.out.println();
    }

    public boolean preprocess() {
        boolean bl;
        Object object;
        if (this.grammarFileName == null) {
            antlr.Tool.toolError("no grammar file specified");
            return false;
        }
        if (this.grammars != null) {
            this.theHierarchy = new Hierarchy();
            Enumeration enumeration = this.grammars.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                try {
                    this.theHierarchy.readGrammarFile((String)object);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    antlr.Tool.toolError("file " + (String)object + " not found");
                    return false;
                }
            }
        }
        if (!(bl = this.theHierarchy.verifyThatHierarchyIsComplete())) {
            return false;
        }
        this.theHierarchy.expandGrammarsInFile(this.grammarFileName);
        object = this.theHierarchy.getFile(this.grammarFileName);
        String string = ((GrammarFile)object).nameForExpandedGrammarFile(this.grammarFileName);
        if (string.equals(this.grammarFileName)) {
            this.args[this.nargs++] = this.grammarFileName;
        } else {
            try {
                ((GrammarFile)object).generateExpandedFile();
                this.args[this.nargs++] = antlr.Tool.getOutputDirectory() + System.getProperty("file.separator") + string;
            }
            catch (IOException iOException) {
                antlr.Tool.toolError("cannot write expanded grammar file " + string);
                return false;
            }
        }
        return true;
    }

    public String[] preprocessedArgList() {
        String[] stringArray = new String[this.nargs];
        System.arraycopy(this.args, 0, stringArray, 0, this.nargs);
        this.args = stringArray;
        return this.args;
    }

    private void processArguments(String[] stringArray) {
        this.nargs = 0;
        this.args = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-glib")) {
                if (File.separator.equals("\\") && stringArray[n].indexOf(47) != -1) {
                    antlr.Tool.warning("-glib cannot deal with '/' on a PC: use '\\'; ignoring...");
                } else {
                    this.grammars = antlr.Tool.parseSeparatedList(stringArray[n + 1], ';');
                    ++n;
                }
            } else if (stringArray[n].equals("-o")) {
                this.args[this.nargs++] = stringArray[n];
                if (n + 1 >= stringArray.length) {
                    this.antlrTool.error("missing output directory with -o option; ignoring");
                } else {
                    this.args[this.nargs++] = stringArray[++n];
                    antlr.Tool.setOutputDirectory(stringArray[n]);
                }
            } else if (stringArray[n].charAt(0) == '-') {
                this.args[this.nargs++] = stringArray[n];
            } else {
                this.grammarFileName = stringArray[n];
                if (this.grammars == null) {
                    this.grammars = new Vector(10);
                }
                this.grammars.appendElement(this.grammarFileName);
                if (n + 1 < stringArray.length) {
                    antlr.Tool.warning("grammar file must be last; ignoring other arguments...");
                    break;
                }
            }
            ++n;
        }
    }
}

