/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.ActionTransInfo;
import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.AlternativeElement;
import antlr.BlockEndElement;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.CodeGenerator;
import antlr.Grammar;
import antlr.GrammarAtom;
import antlr.GrammarSymbol;
import antlr.JavaCharFormatter;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.MakeGrammar;
import antlr.OneOrMoreBlock;
import antlr.ParserGrammar;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.RuleSymbol;
import antlr.StringLiteralElement;
import antlr.SynPredBlock;
import antlr.TokenManager;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;

public class HTMLCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel = 0;
    protected boolean doingLexRules = false;
    protected boolean firstElementInAlt;
    protected AlternativeElement prevAltElem = null;

    public HTMLCodeGenerator() {
        this.charFormatter = new JavaCharFormatter();
    }

    public void gen() {
        try {
            Enumeration enumeration = this.behavior.grammars.elements();
            while (enumeration.hasMoreElements()) {
                Grammar grammar = (Grammar)enumeration.nextElement();
                grammar.setCodeGenerator(this);
                grammar.generate();
                if (!this.tool.hasError) continue;
                System.out.println("Exiting due to errors.");
                System.exit(1);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public void gen(ActionElement actionElement) {
    }

    public void gen(AlternativeBlock alternativeBlock) {
        this.genGenericBlock(alternativeBlock, "");
    }

    public void gen(BlockEndElement blockEndElement) {
    }

    public void gen(CharLiteralElement charLiteralElement) {
        if (charLiteralElement.not) {
            this._print("~");
        }
        this._print(charLiteralElement.atomText + " ");
    }

    public void gen(CharRangeElement charRangeElement) {
        this.print(charRangeElement.beginText + ".." + charRangeElement.endText + " ");
    }

    public void gen(LexerGrammar lexerGrammar) throws IOException {
        this.setGrammar(lexerGrammar);
        System.out.println("Generating " + this.grammar.getClassName() + CodeGenerator.TokenTypesFileExt);
        this.currentOutput = Tool.openOutputFile(this.grammar.getClassName() + CodeGenerator.TokenTypesFileExt);
        this.tabs = 0;
        this.doingLexRules = true;
        this.genHeader();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("class " + this.grammar.getClassName() + " extends " + this.grammar.getSuperClass() + " {");
        this.genNextToken();
        Enumeration enumeration = this.grammar.rules.elements();
        while (enumeration.hasMoreElements()) {
            RuleSymbol ruleSymbol = (RuleSymbol)enumeration.nextElement();
            if (ruleSymbol.id.equals("mnextToken")) continue;
            this.genRule(ruleSymbol);
        }
        this.currentOutput.close();
        this.currentOutput = null;
        this.doingLexRules = false;
    }

    public void gen(OneOrMoreBlock oneOrMoreBlock) {
        this.genGenericBlock(oneOrMoreBlock, "+");
    }

    public void gen(ParserGrammar parserGrammar) throws IOException {
        this.setGrammar(parserGrammar);
        System.out.println("Generating " + this.grammar.getClassName() + ".html");
        this.currentOutput = Tool.openOutputFile(this.grammar.getClassName() + ".html");
        this.tabs = 0;
        this.genHeader();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("class " + this.grammar.getClassName() + " extends " + this.grammar.getSuperClass());
        Enumeration enumeration = this.grammar.rules.elements();
        while (enumeration.hasMoreElements()) {
            this.println("");
            GrammarSymbol grammarSymbol = (GrammarSymbol)enumeration.nextElement();
            if (!(grammarSymbol instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)grammarSymbol);
        }
        --this.tabs;
        this.println("");
        this.genTail();
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(RuleRefElement ruleRefElement) {
        RuleSymbol ruleSymbol = (RuleSymbol)this.grammar.getSymbol(ruleRefElement.targetRule);
        this._print("<a href=" + this.grammar.getClassName() + ".html#" + ruleRefElement.targetRule + ">");
        this._print(ruleRefElement.targetRule);
        this._print("</a>");
        if (ruleRefElement.args != null) {
            this._print("[" + ruleRefElement.args + "]");
        }
        this._print(" ");
    }

    public void gen(StringLiteralElement stringLiteralElement) {
        if (stringLiteralElement.not) {
            this._print("~");
        }
        this._print(stringLiteralElement.atomText);
        this._print(" ");
    }

    public void gen(TokenRangeElement tokenRangeElement) {
        this.print(tokenRangeElement.beginText + ".." + tokenRangeElement.endText + " ");
    }

    public void gen(TokenRefElement tokenRefElement) {
        if (tokenRefElement.not) {
            this._print("~");
        }
        this._print(tokenRefElement.atomText);
        this._print(" ");
    }

    public void gen(TreeElement treeElement) {
        this.print(treeElement + " ");
    }

    public void gen(TreeWalkerGrammar treeWalkerGrammar) throws IOException {
        this.setGrammar(treeWalkerGrammar);
        System.out.println("Generating " + this.grammar.getClassName() + ".txt");
        this.currentOutput = Tool.openOutputFile(this.grammar.getClassName() + ".txt");
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("*** Tree-walker Preamble Action.");
        this.println("This action will appear before the declaration of your tree-walker class:");
        ++this.tabs;
        this.println(this.grammar.preambleAction.getText());
        --this.tabs;
        this.println("*** End of tree-walker Preamble Action");
        this.println("");
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("class " + this.grammar.getClassName() + " extends " + this.grammar.getSuperClass() + "{");
        this.println("");
        this.println("*** User-defined tree-walker class members:");
        this.println("These are the member declarations that you defined for your class:");
        ++this.tabs;
        this.printAction(this.grammar.classMemberAction.getText());
        --this.tabs;
        this.println("*** End of user-defined tree-walker class members");
        this.println("");
        this.println("*** tree-walker rules:");
        ++this.tabs;
        Enumeration enumeration = this.grammar.rules.elements();
        while (enumeration.hasMoreElements()) {
            this.println("");
            GrammarSymbol grammarSymbol = (GrammarSymbol)enumeration.nextElement();
            if (!(grammarSymbol instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)grammarSymbol);
        }
        --this.tabs;
        this.println("");
        this.println("*** End of tree-walker rules");
        this.println("");
        this.println("*** End of tree-walker");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(WildcardElement wildcardElement) {
        this._print(". ");
    }

    public void gen(ZeroOrMoreBlock zeroOrMoreBlock) {
        this.genGenericBlock(zeroOrMoreBlock, "*");
    }

    protected void genAlt(Alternative alternative) {
        if (alternative.getTreeSpecifier() != null) {
            this._print(alternative.getTreeSpecifier().getText());
        }
        this.prevAltElem = null;
        AlternativeElement alternativeElement = alternative.head;
        while (!(alternativeElement instanceof BlockEndElement)) {
            alternativeElement.generate();
            this.firstElementInAlt = false;
            this.prevAltElem = alternativeElement;
            alternativeElement = alternativeElement.next;
        }
    }

    protected void genBlockPreamble(AlternativeBlock alternativeBlock) {
        if (alternativeBlock.initAction != null) {
            this.printAction("{" + alternativeBlock.initAction + "}");
        }
    }

    public void genCommonBlock(AlternativeBlock alternativeBlock) {
        int n = 0;
        while (n < alternativeBlock.alternatives.size()) {
            Alternative alternative = alternativeBlock.getAlternativeAt(n);
            AlternativeElement alternativeElement = alternative.head;
            if (n > 0 && alternativeBlock.alternatives.size() > 1) {
                this._println("");
                this.print("|\t");
            }
            boolean bl = this.firstElementInAlt;
            this.firstElementInAlt = true;
            ++this.tabs;
            if (alternative.semPred != null) {
                this.println("{" + alternative.semPred + "}?");
            }
            if (alternative.synPred != null) {
                this.genSynPred(alternative.synPred);
            }
            this.genAlt(alternative);
            --this.tabs;
            this.firstElementInAlt = bl;
            ++n;
        }
    }

    public void genFollowSetForRuleBlock(RuleBlock ruleBlock) {
        Lookahead lookahead = this.grammar.theLLkAnalyzer.FOLLOW(1, ruleBlock.endNode);
        this.printSet(this.grammar.maxk, 1, lookahead);
    }

    protected void genGenericBlock(AlternativeBlock alternativeBlock, String string) {
        if (alternativeBlock.alternatives.size() > 1) {
            if (!this.firstElementInAlt) {
                if (this.prevAltElem == null || !(this.prevAltElem instanceof AlternativeBlock) || ((AlternativeBlock)this.prevAltElem).alternatives.size() == 1) {
                    this._println("");
                    this.print("(\t");
                } else {
                    this._print("(\t");
                }
            } else {
                this._print("(\t");
            }
        } else {
            this._print("( ");
        }
        this.genBlockPreamble(alternativeBlock);
        this.genCommonBlock(alternativeBlock);
        if (alternativeBlock.alternatives.size() > 1) {
            this._println("");
            this.print(")" + string + " ");
            if (!(alternativeBlock.next instanceof BlockEndElement)) {
                this._println("");
                this.print("");
            }
        } else {
            this._print(")" + string + " ");
        }
    }

    protected void genHeader() {
        this.println("<HTML>");
        this.println("<HEAD>");
        this.println("<TITLE>Grammar " + this.tool.grammarFile + "</TITLE>");
        this.println("</HEAD>");
        this.println("<BODY>");
        this.println("<table border=1 cellpadding=5>");
        this.println("<tr>");
        this.println("<td>");
        this.println("<font size=+2>Grammar " + this.grammar.getClassName() + "</font><br>");
        this.println("<a href=http://www.ANTLR.org>ANTLR</a>-generated HTML file from " + this.tool.grammarFile);
        this.println("<p>");
        this.println("Terence Parr, <a href=http://www.magelang.com>MageLang Institute</a>");
        this.println("<br>ANTLR Version 2.7.1; 1989-1999");
        this.println("</td>");
        this.println("</tr>");
        this.println("</table>");
        this.println("<PRE>");
        ++this.tabs;
        this.printAction(this.behavior.getHeaderAction(""));
        --this.tabs;
    }

    protected void genLookaheadSetForAlt(Alternative alternative) {
        if (this.doingLexRules && alternative.cache[1].containsEpsilon()) {
            this.println("MATCHES ALL");
            return;
        }
        int n = alternative.lookaheadDepth;
        if (n == Integer.MAX_VALUE) {
            n = this.grammar.maxk;
        }
        int n2 = 1;
        while (n2 <= n) {
            Lookahead lookahead = alternative.cache[n2];
            this.printSet(n, n2, lookahead);
            ++n2;
        }
    }

    public void genLookaheadSetForBlock(AlternativeBlock alternativeBlock) {
        int n = 0;
        int n2 = 0;
        while (n2 < alternativeBlock.alternatives.size()) {
            Alternative alternative = alternativeBlock.getAlternativeAt(n2);
            if (alternative.lookaheadDepth == Integer.MAX_VALUE) {
                n = this.grammar.maxk;
                break;
            }
            if (n < alternative.lookaheadDepth) {
                n = alternative.lookaheadDepth;
            }
            ++n2;
        }
        int n3 = 1;
        while (n3 <= n) {
            Lookahead lookahead = this.grammar.theLLkAnalyzer.look(n3, alternativeBlock);
            this.printSet(n, n3, lookahead);
            ++n3;
        }
    }

    public void genNextToken() {
        this.println("");
        this.println("/** Lexer nextToken rule:");
        this.println(" *  The lexer nextToken rule is synthesized from all of the user-defined");
        this.println(" *  lexer rules.  It logically consists of one big alternative block with");
        this.println(" *  each user-defined rule being an alternative.");
        this.println(" */");
        RuleBlock ruleBlock = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol ruleSymbol = new RuleSymbol("mnextToken");
        ruleSymbol.setDefined();
        ruleSymbol.setBlock(ruleBlock);
        ruleSymbol.access = "private";
        this.grammar.define(ruleSymbol);
        this.genCommonBlock(ruleBlock);
    }

    public void genRule(RuleSymbol ruleSymbol) {
        if (ruleSymbol == null || !ruleSymbol.isDefined()) {
            return;
        }
        this.println("");
        if (ruleSymbol.comment != null) {
            this._println(ruleSymbol.comment);
        }
        if (ruleSymbol.access.length() != 0 && !ruleSymbol.access.equals("public")) {
            this._print(ruleSymbol.access + " ");
        }
        this._print("<a name=" + ruleSymbol.getId() + ">");
        this._print(ruleSymbol.getId());
        this._print("</a>");
        RuleBlock ruleBlock = ruleSymbol.getBlock();
        if (ruleBlock.returnAction != null) {
            this._print("[" + ruleBlock.returnAction + "]");
        }
        if (ruleBlock.argAction != null) {
            this._print(" returns [" + ruleBlock.argAction + "]");
        }
        this._println("");
        ++this.tabs;
        this.print(":\t");
        this.genCommonBlock(ruleBlock);
        this._println("");
        this.println(";");
        --this.tabs;
    }

    protected void genSynPred(SynPredBlock synPredBlock) {
        ++this.syntacticPredLevel;
        this.genGenericBlock(synPredBlock, " =>");
        --this.syntacticPredLevel;
    }

    public void genTail() {
        this.println("</PRE>");
        this.println("</BODY>");
        this.println("</HTML>");
    }

    protected void genTokenTypes(TokenManager tokenManager) throws IOException {
        System.out.println("Generating " + tokenManager.getName() + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt);
        this.currentOutput = Tool.openOutputFile(tokenManager.getName() + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt);
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("*** Tokens used by the parser");
        this.println("This is a list of the token numeric values and the corresponding");
        this.println("token identifiers.  Some tokens are literals, and because of that");
        this.println("they have no identifiers.  Literals are double-quoted.");
        ++this.tabs;
        Vector vector = tokenManager.getVocabulary();
        int n = 4;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (string != null) {
                this.println(string + " = " + n);
            }
            ++n;
        }
        --this.tabs;
        this.println("*** End of tokens used by the parser");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public String getASTCreateString(Vector vector) {
        return null;
    }

    public String getASTCreateString(GrammarAtom grammarAtom, String string) {
        return null;
    }

    public String mapTreeId(String string, ActionTransInfo actionTransInfo) {
        return string;
    }

    public void printSet(int n, int n2, Lookahead lookahead) {
        int n3 = 5;
        int[] nArray = lookahead.fset.toArray();
        if (n != 1) {
            this.print("k==" + n2 + ": {");
        } else {
            this.print("{ ");
        }
        if (nArray.length > n3) {
            this._println("");
            ++this.tabs;
            this.print("");
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            if (++n4 > n3) {
                this._println("");
                this.print("");
                n4 = 0;
            }
            if (this.doingLexRules) {
                this._print(this.charFormatter.literalChar(nArray[n5]));
            } else {
                this._print((String)this.grammar.tokenManager.getVocabulary().elementAt(nArray[n5]));
            }
            if (n5 != nArray.length - 1) {
                this._print(", ");
            }
            ++n5;
        }
        if (nArray.length > n3) {
            this._println("");
            --this.tabs;
            this.print("");
        }
        this._println(" }");
    }
}

