package vfilter

import (
	"context"

	"github.com/Velocidex/ordereddict"
	"github.com/alecthomas/participle"
	"www.velocidex.com/golang/vfilter/types"
)

var (
	lambdaParser = participle.MustBuild(
		&Lambda{},
		participle.Lexer(vqlLexer),
		participle.Elide("Comment", "MLineComment", "VQLComment"))
)

type Lambda struct {
	Parameters  *_ParameterList ` @@ `
	LetOperator string          ` @"=>" `
	Expression  *_AndExpression ` @@ `
}

func (self *Lambda) GetParameters() []string {
	result := []string{}

	if self.Parameters != nil {
		visitor(self.Parameters, &result)
	}

	return result
}

func (self *Lambda) Reduce(ctx context.Context, scope types.Scope, parameters []Any) Any {
	my_parameters := self.GetParameters()
	if len(my_parameters) != len(parameters) {
		scope.Log("ERROR:Incorrect number of parameters in Lambda call")
		return Null{}
	}

	vars := ordereddict.NewDict()
	for idx, name := range my_parameters {
		vars.Set(name, parameters[idx])
	}

	subscope := scope.Copy().AppendVars(vars)
	defer subscope.Close()

	return self.Expression.Reduce(ctx, subscope)
}

func ParseLambda(expression string) (*Lambda, error) {
	lambda := &Lambda{}
	err := lambdaParser.ParseString(expression, lambda)
	return lambda, err
}
