Generating schema templates for commands without JSON implementation
====================================================================

All commands without current JSON support share a similar schema template.
To generate these call generate_unsupported.sh in this directory.
It creates JSON schema template files in ./ for all commands listed in the 
variable `UNSUPPORTED_COMMANDS` at the top of the script.

As default generate_unsupported.sh will refuse to work until the environment variable 
FORCE is set to 1 or 2.
This should be prevent inadvertent changes. Therefore to update the schema files run:

FORCE=1 ./generate_unsupported.sh 

With FORCE=1 the script will not override existing templates. To do so use FORCE=2.

!!! Update `UNSUPPORTED_COMMANDS` first, if the list of supported commands has changed. !!!
!!! See also table below.                                                               !!!

After creating the templates, the schemas can be generated with build.py (see next section).


Generating schema files from templates
======================================

All JSON schema files in ../ are generated by the build.py script in this directory.
It will load all files of the pattern "saptune*.template" of the current directory 
and render them (jinja2), resolve all references and put them with the suffix '.template.' 
removed into the parent directory.

Existing files will be overwritten!

As default build.py will refuse to work until the environment variable FORCE is set to 1.
This should be prevent inadvertent changes. Therefore to update the schema files run:

FORCE=1 ./build.py 

Jinja (https://jinja.palletsprojects.com/en/3.0.x/) is used as template engine.



Overview about implemented commands and their schema
====================================================

"JSON?"  --> explicit JSON output implemented
"Schema" --> Schema implemented (requires a yes for "JSON?")

| saptune command                   |JSON?|Schema?|
|:----------------------------------|:---:|:-----:|
| invalid saptune command           | yes |  yes  |  
| saptune daemon start	            | no  |  no   |
| saptune daemon status	            | yes |  yes  |
| saptune daemon stop               | no  |  no   |
| saptune service status            | yes |  yes  |
| saptune service start             | no  |  no   |
| saptune service reload            | no  |  no   |
| saptune service restart           | no  |  no   |
| saptune service stop              | no  |  no   |
| saptune service enable            | no  |  no   |
| saptune service disable           | no  |  no   |
| saptune service enablestart       | no  |  no   |
| saptune service disablestop       | no  |  no   |
| saptune service apply    	        | no  |  no   |
| saptune service revert            | no  |  no   |
| saptune service takeover          | no  |  no   |
| saptune note list                 | yes |  yes  |
| saptune note verify 	            | yes |  yes  |
| saptune note enabled    	        | yes |  yes  |  
| saptune note applied	            | yes |  yes  |
| saptune note apply                | no  |  no   |
| saptune note simulate   	        | no |  no    |
| saptune note customise|customize  | no  |  no   | 
| saptune note create	              | no  |  no   |
| saptune note edit 	              | no  |  no   |
| saptune note show	                | no  |  no   |
| saptune note revert	              | no  |  no   |
| saptune note delete	              | no  |  no   |
| saptune note rename	              | no  |  no   |
| saptune note revertall|revert all |	no  |  no   |
| saptune solution list  	          | yes |  yes  |   
| saptune solution verify	          | yes |  yes  |
| saptune solution enabled	        | yes |  yes  |
| saptune solution applied          | yes |  yes  |
| saptune solution apply	          | no  |  no   |
| saptune solution change	          | no  |  no   |
| saptune solution simulate	        | no |  no  |
| saptune solution revert           | no  |  no   | 
| saptune solution create	          | no  |  no   |
| saptune solution edit	            | no  |  no   |
| saptune solution delete	          | no  |  no   |
| saptune solution rename	          | no  |  no   |
| saptune staging status	          | no  |  no   |
| saptune staging is-enabled      	| no  |  no   |
| saptune staging enable|disable    | no  |  no   |
| saptune staging list	            | no  |  no   |
| saptune staging diff	            | no  |  no   |
| saptune staging analysis	        | no  |  no   |
| saptune staging release           | no  |  no   |
| saptune log status	              | no  |  no   | 
| saptune log set                 	| no  |  no   |
| saptune lock remove    	          | no  |  no   |
| saptune status                    | yes |  yes  | 
| saptune version          	        | yes |  yes  |
| saptune help   	                  | no  |  no   |



Overview of the properties used in the JSON output
==================================================

| Property                | Part Of  | Mandatory | Data Type          | Description                                             | Commnand | Example                                                                                     |
| :---------------------- | :------: | :-------: | :----------------: | :-------------------------------------------------------| :------- | :------------------------------------------------------------------------------------------ |
| `$schema`               | `{}`     | yes       | string             | URI to the schema definition.                           |  _all_   | `file:///usr/share/saptune/schemas/1.0/saptune_note_applied.schema.json`
| `publish time`          | `{}`     | yes       | string             | The timestamp of the time this JSON object was created. |  _all_   |  `2022-02-16 10:51:41.163661`
| `argv`                  | `{}`     | yes       | string             | The entire saptune command as it was called.            |  _all_   |  `saptune --format=json note list` 
| `pid`                   | `{}`     | yes       | integer            | PID of the saptune process creating this object.        |  _all_   |  `1502`
| `command`               | `{}`     | yes       | string             | The saptune command (classifier), which was executed.   |  _all_   |  `note list`
| `exit code`             | `{}`     | yes       | integer            | The return code the saptune command terminated with.    |  _all_   |  `1`
| `result`                | `{}`     | yes       | object             | The result (output) of the command.                     |  _all_   |  `{}`
| `messages`              | `{}`     | yes       | array of objects   | Contains all log messages normally printed on the screen in the order they were created. | _all_             |   `[{ "priority": "WARNING", "message": "section.go:293: You are still using the old ..."}]`
| `implemented`           | `result` | yes       | boolean            | Indicates that JSON output has not yet been implemented yet.                             | _invalid command_ |  `false` 
| `Notes available`       | `result` | yes       | array of objects   | List of the available Notes.                            | `saptune note list`                                |  `[ {"Note ID": "1410736", ...}, ... ]`
| `Notes enabled`         | `result` | yes       | array of strings   | List of the enabled Notes.                              | `saptune note list`,</br> `saptune note verify`,</br> `saptune solution verify`,</br> `saptune [daemon\|service] status`</br>, `saptune note enabled` | `[ "941735", "1771258" ]`
| `Notes applied`         | `result` | yes       | array of strings   | List of the applied Notes.                              | `saptune [daemon\|service} status`,</br> `saptune note applied`     | `[ "941735", "1771258"]`
| `Notes applied by Solution` | `result` | yes       | array of strings   | List of the applied Notes.                              | `saptune [daemon\|service} status`,</br> `saptune note applied`     | `[ "941735", "1771258"]`
| `Notes enabled additionally` | `result` | yes    | array of strings   | List of additional (to a Solution) applied Notes.                              | `saptune [daemon\|service} status` | `[ "941735", "1771258"]`
| `Solutions available`   | `result` | yes       | array of objects   | List of the available Solutions.                        | `saptune solution list`                                             | `[ { "Solution name": "BOBJ", ... }, ... ]`
| `Solution enabled`      | `result` | yes       | array of strings   | The enabled Solution.                                   | `saptune [daemon\|service} status`,</br> `saptune solution enabled` | `[ "MAXDB" ]`
| `Solution applied`      | `result` | yes       | array of strings   | The applied Solution.                                   | `saptune [daemon\|service} status`,</br> `saptune solution applied` | `[ "MAXDB" ]`
| `remember message`      | `result` | yes       | string             | The remember message.                                   | `saptune [daemon\|service] status`,</br> `saptune note list`,</br> `saptune solution list` |  `"\nRemember: ..."` 
| `verifications`         | `result` | yes       | list of objects    | List of verifications (lines of the table output of `saptune note verify`). | `saptune note verify`,</br> `saptune solution verify` | `[ { "Note ID": "1771258", ... }, ...]`
| `attentions`            | `result` | yes       | array of objects   | Attentions printed for a Note.                                             | `saptune note verify`,</br> `saptune solution verify` | `[ { "Note ID": "2382421", ...}, ... ]`
| `system compliance`     | `result` | yes       | boolean            | Overall compliance of all currently applied SAP Notes.                     | `saptune note verify`,</br> `saptune solution verify` | `false`
| `services`              | `result` | yes       | object             | The states of various systemd services related to saptune.                 | `saptune [daemon\|service} status` | `{ "saptune": [ "disabled", "inactive" ], ... }`
| `systemd system state`  | `result` | yes       | string             | Possible systemd system states reported by `systemctl is-system-running`.  | `saptune [daemon\|service} status` | `"running"`
| `tuning state`          | `result` | yes       | string             | Tuning state reported by 'saptune note verify'. One of: "not-present", "not tuned", "not compliant", "compliant", "unknown (checking disabled)" | `saptune [daemon\|service} status`  | "compliant"
| `virtualization`        | `result` | yes       | string             | The virtualization technology of the system (see `systemd-detect-virt --list`). | `saptune [daemon\|service} status` | `"amazon"`
| `configured version`    | `result` | yes       | string             | The configured saptune version (SAPTUNE_VERSION of /etc/sysconfig/saptune).     | `saptune [daemon\|service} status` |  `"1"`
| `package version`       | `result` | yes       | string             | The version string of the installed saptune package.    | `saptune [daemon\|service} status` | `"3.0.1"`
| `staging`               | `result` | yes       | object             | Details about staging.                                  | `saptune [daemon\|service} status` | `{ "enabled": false, "Notes staged": [], "Solutions staged": [] }`
| `configured version`    | `result` | yes       | string             | The configured saptune version.                              | `saptune version`                  |  `"3"`
| `Note ID`               | `Notes available`, </br>`verifications`,</br> `attentions` | yes       | string   | ID of the Note. | `saptune note list`,</br> `saptune note verify`,</br> `saptune solution verify` |  `"1656250"` 
| `Note description`      | `Notes available`    | yes       | string   | Description of the Note. | `saptune note list` |  `"Linux Kernel Settings for NetApp NFS"` 
| `Note reference`        | `Notes available`    | yes       | array of strings | References (URL) for the Note. | `saptune note list` |  `["https://launchpad.support.sap.com/#/notes/1410736"]` 
| `Note version`          | `Notes available`, </br>`verifications`   | yes       | string   | The Note version (defined in `man 5 saptune-note`). | `saptune note list`,</br> `saptune note verify`,</br> `saptune solution verify` |  `"7"` 
| `Note release date`     | `Notes available`    | yes       | string   | Release date of the Note. | `saptune note list` | `"18.10.2017"`
| `Note enabled manually`     | `Notes available`   | yes    | boolean   | States if the Note was enabled manually. | `saptune note list` | `true`
| `Notes enabled by Solution`  | `Notes available`   | yes    | boolean   | States if the Note was enabled by a Solution. | `saptune note list` | `true`
| `Note reverted manually`    | `Notes available`   | yes    | boolean   | States if the Note was reverted manually. | `saptune note list` | `true`
| `Note override exists`      | `Notes available`   | yes    | boolean   | States if an override file exists for the Note. | `saptune note list` | `true`
| `custom Note`               | `Notes available`   | yes    | boolean   | States if the Note is a custom Note. | `saptune note list` | `true`
| `parameter`               | `verifications`   | yes      | string   | Name of the parameter. | `saptune note verify`,</br> `saptune solution verify` | `"kernel.shmall"`
| `expected value`          | `verifications`   | no       | string   | Value of a parameter.  | `saptune note verify`,</br> `saptune solution verify` | `"18446744073709551615"`
| `override value`          | `verifications`   | no       | string   | Value of a parameter.  | `saptune note verify`,</br> `saptune solution verify` | `"-nobarrier"`
| `actual value`            | `verifications`   | no       | string   | Value of a parameter.  | `saptune note verify`,</br> `saptune solution verify` | `"never"`
| `compliant`               | `verifications`   | no       | string   | States if the parameter is compliant or not. | `saptune note verify`,</br> `saptune solution verify` | `true`
| `amendments`              | `verifications`, `simulations`   | yes      | array of objects  | Optional amendments (footnotes). | `saptune note verify`,</br> `saptune solution verify` | `[ { "index": 11, ...}, ... ]`
| `index`                   | `amendments`      | yes      | integer  | Index of the amendment (footnote).                 | `saptune note verify`,</br> `saptune solution verify` | `15`
| `amendment`              | `amendments`      | yes      | string   | Describes the meaning of the amendment (footnote). | `saptune note verify`,</br> `saptune solution verify` | `the parameter is only used to calculate the size of tmpfs (/dev/shm)`
| `attention`               | `attentions`      | yes      | string   | Attentions printed for a Note.                     | `saptune note verify`,</br> `saptune solution verify` | `Attention for SAP Note 2382421:\nHints or values not yet handled...`
| `Solution ID`               | `Solutions available`  | yes     | string      | The Solution ID. | `saptune solution list` | `Remember: if you wish to automatically activate the solution's ...`
| `Note list`                 | `Solutions available`  | yes     | array of strings   | List of Notes belonging to the Solution. | `saptune solution list` | `[ "941735", "1410736" ]`
| `Solution enabled`          | `Solutions available`  | yes     | boolean     | States if the Solution is enabled. | `saptune solution list` | `true`
| `Solution override exists`  | `Solutions available`  | yes     | boolean     | States if an override file exists for the Solution. | `saptune solution list` | `true`
| `custom Solution`           | `Solutions available`  | yes     | boolean     | States if the Note is a custom Solution. | `saptune solution list` | `true`
| `Solution deprecated`       | `Solutions available`  | yes     | boolean     | States if the Solution is deprecated. | `saptune solution list` | `true`
| `saptune`                 | `services`       | yes       | array of strings | Possible systemd states for 'is-active' and 'is-enabled' of a service plus a 'not-available' option for missing packages. | `saptune [daemon\|service} status` | `["disabled", "inactive" ]`
| `sapconf`                 | `services`       | yes       | array of strings | Possible systemd states for 'is-active' and 'is-enabled' of a service plus a 'not-available' option for missing packages. | `saptune [daemon\|service} status` | `["disabled", "inactive" ]` 
| `tuned`                   | `services`       | yes       | array of strings | Possible systemd states for 'is-active' and 'is-enabled' of a service plus a 'not-available' option for missing packages. | `saptune [daemon\|service} status` | `["disabled", "inactive" ]`
| `tuned profile`           | `services`       | no        | string           | The currently set tuned profile, if `tuned.service` is active.                                                            | `saptune [daemon\|service} status` | `"powersave"`
| `staging enabled`         | `staging`        | yes       | boolean          | States if staging is enabled or not. | `saptune [daemon\|service} status` | `true`
| `Notes staged`            | `staging`        | yes       | list of strings  | List of the staged Notes. | `saptune [daemon\|service} status` | `["941735", "1771258"]`
| `Solutions staged`        | `staging`        | yes       | list of strings  | List of staged Solutions. | `saptune [daemon\|service} status` | `["MAXDB", "HANA"]`
| `priority`                | `messages`       | yes       | string           | Priority of the log messages as defined at https://confluence.suse.com/display/SAP/Logging+Guide". | _all_ |  `"INFO"` 
| `message`                 | `messages`       | yes       | string           | The log message itself. | _all_ |   `main.go:57: saptune (3.0.2) started with 'saptune status'"`


RULES
=====
- undefined scalars will not be part of the JSON output
- lists can be empty



ToDo
====
