"use strict";
/**
 * npm_install_proxy -- localhost NPM registry to `npm install` without network
 *
 * Copyright (C) 2020  SUSE LLC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.DirRegistryBackend = void 0;
const fs = require("fs");
const util_1 = require("util");
const fs_registry_1 = require("./fs_registry");
const readdir = (0, util_1.promisify)(fs.readdir);
const concurrent_processes = 100;
class DirRegistryBackend {
    constructor() {
        this.tarball_registry = new fs_registry_1.TarballRegistryBackend;
    }
    static direntToPath(path, dirent) {
        if (path === '.')
            return dirent.name;
        return path + '/' + dirent.name;
    }
    direntToPkgJson(path, dirent) {
        const p = DirRegistryBackend.direntToPath(path, dirent);
        const pkg_json_promise = this.tarball_registry.extractPkgJson(p);
        return pkg_json_promise.catch(() => []);
    }
    extractPkgJson(path) {
        return new Promise((accept, reject) => {
            readdir(path, { withFileTypes: true })
                .then((files) => {
                files = files.filter(dirent => dirent.isFile());
                const promises = [];
                const max_pos = Math.min(concurrent_processes, files.length);
                for (let i = 0; i < max_pos; ++i) {
                    promises.push(this.direntToPkgJson(path, files.shift()));
                }
                let i = 0;
                while (files.length > 0) {
                    i = (i + 1) % concurrent_processes;
                    const filename = files.shift();
                    promises[i] = promises[i].then(old_vals => {
                        return this.direntToPkgJson(path, filename).then(new_vals => old_vals.concat(new_vals));
                    });
                }
                Promise.all(promises)
                    .then(jsons_array => {
                    let ret_data = [];
                    jsons_array.forEach(data => {
                        data.forEach(data => ret_data.push(data));
                    });
                    accept(ret_data);
                });
            })
                .catch(err => {
                reject(err);
            });
        });
    }
}
exports.DirRegistryBackend = DirRegistryBackend;
//# sourceMappingURL=dir_registry.js.map