; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vbmi,+avx512vbmi2 | FileCheck %s --check-prefixes=AVX512VBMI2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512VLBW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vbmi,+avx512vbmi2,+avx512vl | FileCheck %s --check-prefixes=AVX512VLVBMI2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx | FileCheck %s --check-prefixes=XOPAVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx2 | FileCheck %s --check-prefixes=XOPAVX2

declare <4 x i64> @llvm.fshr.v4i64(<4 x i64>, <4 x i64>, <4 x i64>)
declare <8 x i32> @llvm.fshr.v8i32(<8 x i32>, <8 x i32>, <8 x i32>)
declare <16 x i16> @llvm.fshr.v16i16(<16 x i16>, <16 x i16>, <16 x i16>)
declare <32 x i8> @llvm.fshr.v32i8(<32 x i8>, <32 x i8>, <32 x i8>)

;
; Variable Shifts
;

define <4 x i64> @var_funnnel_v4i64(<4 x i64> %x, <4 x i64> %y, <4 x i64> %amt) nounwind {
; AVX1-LABEL: var_funnnel_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastsd {{.*#+}} ymm3 = [63,63,63,63]
; AVX1-NEXT:    vandps %ymm3, %ymm2, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm6
; AVX1-NEXT:    vpsrlq %xmm5, %xmm6, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,3,2,3]
; AVX1-NEXT:    vpsrlq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm7[0,1,2,3],xmm5[4,5,6,7]
; AVX1-NEXT:    vpsrlq %xmm4, %xmm1, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,3,2,3]
; AVX1-NEXT:    vpsrlq %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm6[0,1,2,3],xmm1[4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX1-NEXT:    vandnps %ymm3, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[2,3,2,3]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpaddq %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpsllq %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpsllq %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3],xmm4[4,5,6,7]
; AVX1-NEXT:    vshufps {{.*#+}} xmm4 = xmm2[2,3,2,3]
; AVX1-NEXT:    vpaddq %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpsllq %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpsllq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm4[4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_funnnel_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [63,63,63,63]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX2-NEXT:    vpsrlvq %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpaddq %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpsllvq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: var_funnnel_v4i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [63,63,63,63]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512F-NEXT:    vpsrlvq %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpaddq %ymm0, %ymm0, %ymm0
; AVX512F-NEXT:    vpsllvq %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [63,63,63,63]
; AVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512VL-NEXT:    vpsrlvq %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsllvq %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v4i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [63,63,63,63]
; AVX512BW-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512BW-NEXT:    vpsrlvq %ymm4, %ymm1, %ymm1
; AVX512BW-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512BW-NEXT:    vpaddq %ymm0, %ymm0, %ymm0
; AVX512BW-NEXT:    vpsllvq %ymm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v4i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vpshrdvq %zmm2, %zmm0, %zmm1
; AVX512VBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v4i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [63,63,63,63]
; AVX512VLBW-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512VLBW-NEXT:    vpsrlvq %ymm4, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vpaddq %ymm0, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpsllvq %ymm2, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v4i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdvq %ymm2, %ymm0, %ymm1
; AVX512VLVBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: var_funnnel_v4i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vbroadcastsd {{.*#+}} ymm3 = [63,63,63,63]
; XOPAVX1-NEXT:    vandps %ymm3, %ymm2, %ymm4
; XOPAVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; XOPAVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpsubq %xmm5, %xmm6, %xmm5
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm7
; XOPAVX1-NEXT:    vpshlq %xmm5, %xmm7, %xmm5
; XOPAVX1-NEXT:    vpsubq %xmm4, %xmm6, %xmm4
; XOPAVX1-NEXT:    vpshlq %xmm4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; XOPAVX1-NEXT:    vandnps %ymm3, %ymm2, %ymm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOPAVX1-NEXT:    vpaddq %xmm4, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpshlq %xmm3, %xmm4, %xmm3
; XOPAVX1-NEXT:    vpaddq %xmm0, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpshlq %xmm2, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; XOPAVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_funnnel_v4i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [63,63,63,63]
; XOPAVX2-NEXT:    vpand %ymm3, %ymm2, %ymm4
; XOPAVX2-NEXT:    vpsrlvq %ymm4, %ymm1, %ymm1
; XOPAVX2-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; XOPAVX2-NEXT:    vpaddq %ymm0, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpsllvq %ymm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %res = call <4 x i64> @llvm.fshr.v4i64(<4 x i64> %x, <4 x i64> %y, <4 x i64> %amt)
  ret <4 x i64> %res
}

define <8 x i32> @var_funnnel_v8i32(<8 x i32> %x, <8 x i32> %y, <8 x i32> %amt) nounwind {
; AVX1-LABEL: var_funnnel_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm5 = xmm4[12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpsrld %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlq $32, %xmm4, %xmm6
; AVX1-NEXT:    vpsrld %xmm6, %xmm3, %xmm6
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0,1,2,3],xmm5[4,5,6,7]
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm7 = xmm4[2],xmm6[2],xmm4[3],xmm6[3]
; AVX1-NEXT:    vpsrld %xmm7, %xmm3, %xmm7
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm4[0],zero,xmm4[1],zero
; AVX1-NEXT:    vpsrld %xmm8, %xmm3, %xmm3
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3],xmm7[4,5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm5[2,3],xmm3[4,5],xmm5[6,7]
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [31,31,31,31]
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpslld $23, %xmm4, %xmm4
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm7 = [1065353216,1065353216,1065353216,1065353216]
; AVX1-NEXT:    vpaddd %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vcvttps2dq %xmm4, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm8
; AVX1-NEXT:    vpaddd %xmm8, %xmm8, %xmm8
; AVX1-NEXT:    vpmulld %xmm4, %xmm8, %xmm4
; AVX1-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm4 = xmm2[12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpsrld %xmm4, %xmm1, %xmm4
; AVX1-NEXT:    vpsrlq $32, %xmm2, %xmm8
; AVX1-NEXT:    vpsrld %xmm8, %xmm1, %xmm8
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm8[0,1,2,3],xmm4[4,5,6,7]
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm6 = xmm2[2],xmm6[2],xmm2[3],xmm6[3]
; AVX1-NEXT:    vpsrld %xmm6, %xmm1, %xmm6
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm2[0],zero,xmm2[1],zero
; AVX1-NEXT:    vpsrld %xmm8, %xmm1, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm6[4,5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm4[2,3],xmm1[4,5],xmm4[6,7]
; AVX1-NEXT:    vpxor %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpslld $23, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vcvttps2dq %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpmulld %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_funnnel_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [31,31,31,31,31,31,31,31]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX2-NEXT:    vpsrlvd %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpsllvd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: var_funnnel_v8i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [31,31,31,31,31,31,31,31]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512F-NEXT:    vpsrlvd %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; AVX512F-NEXT:    vpsllvd %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [31,31,31,31,31,31,31,31]
; AVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512VL-NEXT:    vpsrlvd %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsllvd %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v8i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [31,31,31,31,31,31,31,31]
; AVX512BW-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512BW-NEXT:    vpsrlvd %ymm4, %ymm1, %ymm1
; AVX512BW-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512BW-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; AVX512BW-NEXT:    vpsllvd %ymm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v8i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vpshrdvd %zmm2, %zmm0, %zmm1
; AVX512VBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v8i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [31,31,31,31,31,31,31,31]
; AVX512VLBW-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512VLBW-NEXT:    vpsrlvd %ymm4, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpsllvd %ymm2, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v8i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdvd %ymm2, %ymm0, %ymm1
; AVX512VLVBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: var_funnnel_v8i32:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; XOPAVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpsubd %xmm3, %xmm4, %xmm5
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm6
; XOPAVX1-NEXT:    vpshld %xmm5, %xmm6, %xmm5
; XOPAVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [31,31,31,31]
; XOPAVX1-NEXT:    vpxor %xmm6, %xmm3, %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm7
; XOPAVX1-NEXT:    vpaddd %xmm7, %xmm7, %xmm7
; XOPAVX1-NEXT:    vpshld %xmm3, %xmm7, %xmm3
; XOPAVX1-NEXT:    vpor %xmm5, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpshld %xmm4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpxor %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpshld %xmm2, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_funnnel_v8i32:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [31,31,31,31,31,31,31,31]
; XOPAVX2-NEXT:    vpand %ymm3, %ymm2, %ymm4
; XOPAVX2-NEXT:    vpsrlvd %ymm4, %ymm1, %ymm1
; XOPAVX2-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; XOPAVX2-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpsllvd %ymm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %res = call <8 x i32> @llvm.fshr.v8i32(<8 x i32> %x, <8 x i32> %y, <8 x i32> %amt)
  ret <8 x i32> %res
}

define <16 x i16> @var_funnnel_v16i16(<16 x i16> %x, <16 x i16> %y, <16 x i16> %amt) nounwind {
; AVX1-LABEL: var_funnnel_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vpsllw $12, %xmm3, %xmm4
; AVX1-NEXT:    vpsllw $4, %xmm3, %xmm5
; AVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpaddw %xmm4, %xmm4, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm6
; AVX1-NEXT:    vpsrlw $8, %xmm6, %xmm7
; AVX1-NEXT:    vpblendvb %xmm4, %xmm7, %xmm6, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm4, %xmm6
; AVX1-NEXT:    vpblendvb %xmm5, %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpsrlw $2, %xmm4, %xmm6
; AVX1-NEXT:    vpaddw %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpblendvb %xmm5, %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpsrlw $1, %xmm4, %xmm6
; AVX1-NEXT:    vpaddw %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpblendvb %xmm5, %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm6
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm6[4,4,5,5,6,6,7,7]
; AVX1-NEXT:    vpslld $23, %xmm3, %xmm7
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [1065353216,1065353216,1065353216,1065353216]
; AVX1-NEXT:    vpaddd %xmm3, %xmm7, %xmm7
; AVX1-NEXT:    vcvttps2dq %xmm7, %xmm7
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero
; AVX1-NEXT:    vpslld $23, %xmm6, %xmm6
; AVX1-NEXT:    vpaddd %xmm3, %xmm6, %xmm6
; AVX1-NEXT:    vcvttps2dq %xmm6, %xmm6
; AVX1-NEXT:    vpackusdw %xmm7, %xmm6, %xmm6
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm7
; AVX1-NEXT:    vpaddw %xmm7, %xmm7, %xmm7
; AVX1-NEXT:    vpmullw %xmm6, %xmm7, %xmm6
; AVX1-NEXT:    vpor %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vpsllw $12, %xmm2, %xmm6
; AVX1-NEXT:    vpsllw $4, %xmm2, %xmm7
; AVX1-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX1-NEXT:    vpaddw %xmm6, %xmm6, %xmm7
; AVX1-NEXT:    vpsrlw $8, %xmm1, %xmm8
; AVX1-NEXT:    vpblendvb %xmm6, %xmm8, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm6
; AVX1-NEXT:    vpblendvb %xmm7, %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $2, %xmm1, %xmm6
; AVX1-NEXT:    vpaddw %xmm7, %xmm7, %xmm7
; AVX1-NEXT:    vpblendvb %xmm7, %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm6
; AVX1-NEXT:    vpaddw %xmm7, %xmm7, %xmm7
; AVX1-NEXT:    vpblendvb %xmm7, %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm2[4,4,5,5,6,6,7,7]
; AVX1-NEXT:    vpslld $23, %xmm5, %xmm5
; AVX1-NEXT:    vpaddd %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vcvttps2dq %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero
; AVX1-NEXT:    vpslld $23, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vcvttps2dq %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpmullw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_funnnel_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm3 = ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15]
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpunpckhwd {{.*#+}} ymm5 = ymm2[4],ymm4[4],ymm2[5],ymm4[5],ymm2[6],ymm4[6],ymm2[7],ymm4[7],ymm2[12],ymm4[12],ymm2[13],ymm4[13],ymm2[14],ymm4[14],ymm2[15],ymm4[15]
; AVX2-NEXT:    vpsrlvd %ymm5, %ymm3, %ymm3
; AVX2-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[3],ymm3[4],ymm4[5],ymm3[6],ymm4[7],ymm3[8],ymm4[9],ymm3[10],ymm4[11],ymm3[12],ymm4[13],ymm3[14],ymm4[15]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm2[0],ymm4[0],ymm2[1],ymm4[1],ymm2[2],ymm4[2],ymm2[3],ymm4[3],ymm2[8],ymm4[8],ymm2[9],ymm4[9],ymm2[10],ymm4[10],ymm2[11],ymm4[11]
; AVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm4[1],ymm0[2],ymm4[3],ymm0[4],ymm4[5],ymm0[6],ymm4[7],ymm0[8],ymm4[9],ymm0[10],ymm4[11],ymm0[12],ymm4[13],ymm0[14],ymm4[15]
; AVX2-NEXT:    vpackusdw %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: var_funnnel_v16i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpslld $16, %zmm0, %zmm0
; AVX512F-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm1
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512F-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v16i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpslld $16, %zmm0, %zmm0
; AVX512VL-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm2, %ymm1
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v16i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512BW-NEXT:    vpsrlvw %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512BW-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; AVX512BW-NEXT:    vpsllvw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v16i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vpshrdvw %zmm2, %zmm0, %zmm1
; AVX512VBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v16i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VLBW-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512VLBW-NEXT:    vpsrlvw %ymm4, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpsllvw %ymm2, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v16i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdvw %ymm2, %ymm0, %ymm1
; AVX512VLVBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: var_funnnel_v16i16:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; XOPAVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpsubw %xmm3, %xmm4, %xmm5
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm6
; XOPAVX1-NEXT:    vpshlw %xmm5, %xmm6, %xmm5
; XOPAVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [15,15,15,15,15,15,15,15]
; XOPAVX1-NEXT:    vpxor %xmm6, %xmm3, %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm7
; XOPAVX1-NEXT:    vpaddw %xmm7, %xmm7, %xmm7
; XOPAVX1-NEXT:    vpshlw %xmm3, %xmm7, %xmm3
; XOPAVX1-NEXT:    vpor %xmm5, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpshlw %xmm4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpxor %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddw %xmm0, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpshlw %xmm2, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_funnnel_v16i16:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; XOPAVX2-NEXT:    vpand %ymm3, %ymm2, %ymm4
; XOPAVX2-NEXT:    vextracti128 $1, %ymm4, %xmm5
; XOPAVX2-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; XOPAVX2-NEXT:    vpsubw %xmm5, %xmm6, %xmm5
; XOPAVX2-NEXT:    vextracti128 $1, %ymm1, %xmm7
; XOPAVX2-NEXT:    vpshlw %xmm5, %xmm7, %xmm5
; XOPAVX2-NEXT:    vpsubw %xmm4, %xmm6, %xmm4
; XOPAVX2-NEXT:    vpshlw %xmm4, %xmm1, %xmm1
; XOPAVX2-NEXT:    vinserti128 $1, %xmm5, %ymm1, %ymm1
; XOPAVX2-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; XOPAVX2-NEXT:    vextracti128 $1, %ymm2, %xmm3
; XOPAVX2-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm4
; XOPAVX2-NEXT:    vpshlw %xmm3, %xmm4, %xmm3
; XOPAVX2-NEXT:    vpshlw %xmm2, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %res = call <16 x i16> @llvm.fshr.v16i16(<16 x i16> %x, <16 x i16> %y, <16 x i16> %amt)
  ret <16 x i16> %res
}

define <32 x i8> @var_funnnel_v32i8(<32 x i8> %x, <32 x i8> %y, <32 x i8> %amt) nounwind {
; AVX1-LABEL: var_funnnel_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddb %xmm3, %xmm3, %xmm5
; AVX1-NEXT:    vpsllw $4, %xmm5, %xmm4
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX1-NEXT:    vpand %xmm3, %xmm4, %xmm6
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm7
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX1-NEXT:    vpxor %xmm4, %xmm7, %xmm8
; AVX1-NEXT:    vpsllw $5, %xmm8, %xmm8
; AVX1-NEXT:    vpblendvb %xmm8, %xmm6, %xmm5, %xmm6
; AVX1-NEXT:    vpsllw $2, %xmm6, %xmm9
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX1-NEXT:    vpand %xmm5, %xmm9, %xmm9
; AVX1-NEXT:    vpaddb %xmm8, %xmm8, %xmm8
; AVX1-NEXT:    vpblendvb %xmm8, %xmm9, %xmm6, %xmm6
; AVX1-NEXT:    vpaddb %xmm6, %xmm6, %xmm9
; AVX1-NEXT:    vpaddb %xmm8, %xmm8, %xmm8
; AVX1-NEXT:    vpblendvb %xmm8, %xmm9, %xmm6, %xmm6
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm8
; AVX1-NEXT:    vpsrlw $4, %xmm8, %xmm9
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm10 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm10, %xmm9, %xmm9
; AVX1-NEXT:    vpsllw $5, %xmm7, %xmm7
; AVX1-NEXT:    vpblendvb %xmm7, %xmm9, %xmm8, %xmm8
; AVX1-NEXT:    vpsrlw $2, %xmm8, %xmm9
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm11 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX1-NEXT:    vpand %xmm11, %xmm9, %xmm9
; AVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm7
; AVX1-NEXT:    vpblendvb %xmm7, %xmm9, %xmm8, %xmm8
; AVX1-NEXT:    vpsrlw $1, %xmm8, %xmm9
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm12 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm12, %xmm9, %xmm9
; AVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm7
; AVX1-NEXT:    vpblendvb %xmm7, %xmm9, %xmm8, %xmm7
; AVX1-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $4, %xmm0, %xmm7
; AVX1-NEXT:    vpand %xmm3, %xmm7, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm2, %xmm4
; AVX1-NEXT:    vpsllw $5, %xmm4, %xmm4
; AVX1-NEXT:    vpblendvb %xmm4, %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $2, %xmm0, %xmm3
; AVX1-NEXT:    vpand %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpblendvb %xmm4, %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm3
; AVX1-NEXT:    vpaddb %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpblendvb %xmm4, %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm10, %xmm3
; AVX1-NEXT:    vpsllw $5, %xmm2, %xmm2
; AVX1-NEXT:    vpblendvb %xmm2, %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $2, %xmm1, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm11, %xmm3
; AVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendvb %xmm2, %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm12, %xmm3
; AVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendvb %xmm2, %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_funnnel_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX2-NEXT:    vpsllw $5, %ymm4, %ymm4
; AVX2-NEXT:    vpaddb %ymm4, %ymm4, %ymm5
; AVX2-NEXT:    vpsrlw $4, %ymm1, %ymm6
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm6, %ymm6
; AVX2-NEXT:    vpblendvb %ymm4, %ymm6, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $2, %ymm1, %ymm4
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm4
; AVX2-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm4
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm4
; AVX2-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX2-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpsllw $5, %ymm2, %ymm2
; AVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm3
; AVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $4, %ymm0, %ymm4
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm4
; AVX2-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $2, %ymm0, %ymm2
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; AVX2-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; AVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: var_funnnel_v32i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastb {{.*#+}} ymm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512F-NEXT:    vpsllw $5, %ymm4, %ymm4
; AVX512F-NEXT:    vpaddb %ymm4, %ymm4, %ymm5
; AVX512F-NEXT:    vpsrlw $4, %ymm1, %ymm6
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm4, %ymm6, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $2, %ymm1, %ymm4
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm4
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm4
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm4
; AVX512F-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsllw $5, %ymm2, %ymm2
; AVX512F-NEXT:    vpaddb %ymm2, %ymm2, %ymm3
; AVX512F-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm4
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm4
; AVX512F-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vpsllw $2, %ymm0, %ymm2
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; AVX512F-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; AVX512F-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v32i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512VL-NEXT:    vpsllw $5, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm4, %ymm4, %ymm5
; AVX512VL-NEXT:    vpsrlw $4, %ymm1, %ymm6
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm4, %ymm6, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $2, %ymm1, %ymm4
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm4, %ymm4
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $1, %ymm1, %ymm4
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllw $5, %ymm2, %ymm2
; AVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm3
; AVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm4
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm4, %ymm4
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsllw $2, %ymm0, %ymm2
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm2, %ymm2
; AVX512VL-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; AVX512VL-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; AVX512VL-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpsllw $8, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm1
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v32i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,64,1,65,2,66,3,67,4,68,5,69,6,70,7,71,8,72,9,73,10,74,11,75,12,76,13,77,14,78,15,79,16,80,17,81,18,82,19,83,20,84,21,85,22,86,23,87,24,88,25,89,26,90,27,91,28,92,29,93,30,94,31,95]
; AVX512VBMI2-NEXT:    vpermi2b %zmm0, %zmm1, %zmm3
; AVX512VBMI2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm0
; AVX512VBMI2-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512VBMI2-NEXT:    vpsrlvw %zmm0, %zmm3, %zmm0
; AVX512VBMI2-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v32i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512VLBW-NEXT:    vpsllw $8, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm2, %ymm1
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512VLBW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v32i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VLVBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VLVBMI2-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,64,1,65,2,66,3,67,4,68,5,69,6,70,7,71,8,72,9,73,10,74,11,75,12,76,13,77,14,78,15,79,16,80,17,81,18,82,19,83,20,84,21,85,22,86,23,87,24,88,25,89,26,90,27,91,28,92,29,93,30,94,31,95]
; AVX512VLVBMI2-NEXT:    vpermi2b %zmm0, %zmm1, %zmm3
; AVX512VLVBMI2-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm2, %ymm0
; AVX512VLVBMI2-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512VLVBMI2-NEXT:    vpsrlvw %zmm0, %zmm3, %zmm0
; AVX512VLVBMI2-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: var_funnnel_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; XOPAVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpsubb %xmm3, %xmm4, %xmm5
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm6
; XOPAVX1-NEXT:    vpshlb %xmm5, %xmm6, %xmm5
; XOPAVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; XOPAVX1-NEXT:    vpxor %xmm6, %xmm3, %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm7
; XOPAVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm7
; XOPAVX1-NEXT:    vpshlb %xmm3, %xmm7, %xmm3
; XOPAVX1-NEXT:    vpor %xmm5, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpshlb %xmm4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpxor %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpshlb %xmm2, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_funnnel_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; XOPAVX2-NEXT:    vextracti128 $1, %ymm2, %xmm3
; XOPAVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; XOPAVX2-NEXT:    vpsubb %xmm3, %xmm4, %xmm5
; XOPAVX2-NEXT:    vextracti128 $1, %ymm1, %xmm6
; XOPAVX2-NEXT:    vpshlb %xmm5, %xmm6, %xmm5
; XOPAVX2-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; XOPAVX2-NEXT:    vpshlb %xmm4, %xmm1, %xmm1
; XOPAVX2-NEXT:    vinserti128 $1, %xmm5, %ymm1, %ymm1
; XOPAVX2-NEXT:    vpbroadcastb {{.*#+}} xmm4 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; XOPAVX2-NEXT:    vpxor %xmm4, %xmm3, %xmm3
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm5
; XOPAVX2-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; XOPAVX2-NEXT:    vpshlb %xmm3, %xmm5, %xmm3
; XOPAVX2-NEXT:    vpxor %xmm4, %xmm2, %xmm2
; XOPAVX2-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpshlb %xmm2, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %res = call <32 x i8> @llvm.fshr.v32i8(<32 x i8> %x, <32 x i8> %y, <32 x i8> %amt)
  ret <32 x i8> %res
}

;
; Uniform Variable Shifts
;

define <4 x i64> @splatvar_funnnel_v4i64(<4 x i64> %x, <4 x i64> %y, <4 x i64> %amt) nounwind {
; AVX1-LABEL: splatvar_funnnel_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm3 = [63,63]
; AVX1-NEXT:    # xmm3 = mem[0,0]
; AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpsrlq %xmm4, %xmm5, %xmm5
; AVX1-NEXT:    vpsrlq %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX1-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddq %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpsllq %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpaddq %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpsllq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_funnnel_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [63,63]
; AVX2-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX2-NEXT:    vpsrlq %xmm4, %ymm1, %ymm1
; AVX2-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpaddq %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpsllq %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: splatvar_funnnel_v4i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [63,63]
; AVX512F-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX512F-NEXT:    vpsrlq %xmm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpaddq %ymm0, %ymm0, %ymm0
; AVX512F-NEXT:    vpsllq %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [63,63]
; AVX512VL-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX512VL-NEXT:    vpsrlq %xmm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsllq %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v4i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [63,63]
; AVX512BW-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX512BW-NEXT:    vpsrlq %xmm4, %ymm1, %ymm1
; AVX512BW-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vpaddq %ymm0, %ymm0, %ymm0
; AVX512BW-NEXT:    vpsllq %xmm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v4i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vpbroadcastq %xmm2, %ymm2
; AVX512VBMI2-NEXT:    vpshrdvq %zmm2, %zmm0, %zmm1
; AVX512VBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v4i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [63,63]
; AVX512VLBW-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX512VLBW-NEXT:    vpsrlq %xmm4, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpaddq %ymm0, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpsllq %xmm2, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v4i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastq %xmm2, %ymm2
; AVX512VLVBMI2-NEXT:    vpshrdvq %ymm2, %ymm0, %ymm1
; AVX512VLVBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_funnnel_v4i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vmovddup {{.*#+}} xmm3 = [63,63]
; XOPAVX1-NEXT:    # xmm3 = mem[0,0]
; XOPAVX1-NEXT:    vpand %xmm3, %xmm2, %xmm4
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; XOPAVX1-NEXT:    vpsrlq %xmm4, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpsrlq %xmm4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; XOPAVX1-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpaddq %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsllq %xmm2, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpaddq %xmm0, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpsllq %xmm2, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; XOPAVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_funnnel_v4i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [63,63]
; XOPAVX2-NEXT:    vpand %xmm3, %xmm2, %xmm4
; XOPAVX2-NEXT:    vpsrlq %xmm4, %ymm1, %ymm1
; XOPAVX2-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; XOPAVX2-NEXT:    vpaddq %ymm0, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpsllq %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %splat = shufflevector <4 x i64> %amt, <4 x i64> undef, <4 x i32> zeroinitializer
  %res = call <4 x i64> @llvm.fshr.v4i64(<4 x i64> %x, <4 x i64> %y, <4 x i64> %splat)
  ret <4 x i64> %res
}

define <8 x i32> @splatvar_funnnel_v8i32(<8 x i32> %x, <8 x i32> %y, <8 x i32> %amt) nounwind {
; AVX1-LABEL: splatvar_funnnel_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vpsrlq %xmm2, %xmm5, %xmm5
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm6 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-NEXT:    vpsrlq %xmm2, %xmm6, %xmm6
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX1-NEXT:    vpsrlq %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-NEXT:    vpsrlq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm5[0,2],ymm0[4,6],ymm5[4,6]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_funnnel_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX2-NEXT:    vpsrlq %xmm2, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[4],ymm0[4],ymm1[5],ymm0[5]
; AVX2-NEXT:    vpsrlq %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm3[0,2],ymm0[4,6],ymm3[4,6]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: splatvar_funnnel_v8i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX512F-NEXT:    vpsrlq %xmm2, %ymm3, %ymm3
; AVX512F-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[4],ymm0[4],ymm1[5],ymm0[5]
; AVX512F-NEXT:    vpsrlq %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm3[0,2],ymm0[4,6],ymm3[4,6]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX512VL-NEXT:    vpsrlq %xmm2, %ymm3, %ymm3
; AVX512VL-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[4],ymm0[4],ymm1[5],ymm0[5]
; AVX512VL-NEXT:    vpsrlq %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm3[0,2],ymm0[4,6],ymm3[4,6]
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v8i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX512BW-NEXT:    vpsrlq %xmm2, %ymm3, %ymm3
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[4],ymm0[4],ymm1[5],ymm0[5]
; AVX512BW-NEXT:    vpsrlq %xmm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm3[0,2],ymm0[4,6],ymm3[4,6]
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v8i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vpbroadcastd %xmm2, %ymm2
; AVX512VBMI2-NEXT:    vpshrdvd %zmm2, %zmm0, %zmm1
; AVX512VBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v8i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; AVX512VLBW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsrlq %xmm2, %ymm3, %ymm3
; AVX512VLBW-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[4],ymm0[4],ymm1[5],ymm0[5]
; AVX512VLBW-NEXT:    vpsrlq %xmm2, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm3[0,2],ymm0[4,6],ymm3[4,6]
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v8i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastd %xmm2, %ymm2
; AVX512VLVBMI2-NEXT:    vpshrdvd %ymm2, %ymm0, %ymm1
; AVX512VLVBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_funnnel_v8i32:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; XOPAVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; XOPAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq %xmm2, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpunpckhdq {{.*#+}} xmm6 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; XOPAVX1-NEXT:    vpsrlq %xmm2, %xmm6, %xmm6
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; XOPAVX1-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; XOPAVX1-NEXT:    vpsrlq %xmm2, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; XOPAVX1-NEXT:    vpsrlq %xmm2, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; XOPAVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm5[0,2],ymm0[4,6],ymm5[4,6]
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_funnnel_v8i32:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[6],ymm0[6],ymm1[7],ymm0[7]
; XOPAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; XOPAVX2-NEXT:    vpsrlq %xmm2, %ymm3, %ymm3
; XOPAVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[4],ymm0[4],ymm1[5],ymm0[5]
; XOPAVX2-NEXT:    vpsrlq %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm3[0,2],ymm0[4,6],ymm3[4,6]
; XOPAVX2-NEXT:    retq
  %splat = shufflevector <8 x i32> %amt, <8 x i32> undef, <8 x i32> zeroinitializer
  %res = call <8 x i32> @llvm.fshr.v8i32(<8 x i32> %x, <8 x i32> %y, <8 x i32> %splat)
  ret <8 x i32> %res
}

define <16 x i16> @splatvar_funnnel_v16i16(<16 x i16> %x, <16 x i16> %y, <16 x i16> %amt) nounwind {
; AVX1-LABEL: splatvar_funnnel_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [15,0,0,0]
; AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpsrlw %xmm4, %xmm5, %xmm5
; AVX1-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpsllw %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_funnnel_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [15,0,0,0,15,0,0,0]
; AVX2-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX2-NEXT:    vpsrlw %xmm4, %ymm1, %ymm1
; AVX2-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: splatvar_funnnel_v16i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [15,0,0,0,15,0,0,0]
; AVX512F-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX512F-NEXT:    vpsrlw %xmm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; AVX512F-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v16i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [15,0,0,0,15,0,0,0]
; AVX512VL-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX512VL-NEXT:    vpsrlw %xmm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v16i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [15,0,0,0,15,0,0,0]
; AVX512BW-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX512BW-NEXT:    vpsrlw %xmm4, %ymm1, %ymm1
; AVX512BW-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; AVX512BW-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v16i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vpbroadcastw %xmm2, %ymm2
; AVX512VBMI2-NEXT:    vpshrdvw %zmm2, %zmm0, %zmm1
; AVX512VBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v16i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [15,0,0,0,15,0,0,0]
; AVX512VLBW-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX512VLBW-NEXT:    vpsrlw %xmm4, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v16i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastw %xmm2, %ymm2
; AVX512VLVBMI2-NEXT:    vpshrdvw %ymm2, %ymm0, %ymm1
; AVX512VLVBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_funnnel_v16i16:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [15,0,0,0]
; XOPAVX1-NEXT:    vpand %xmm3, %xmm2, %xmm4
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; XOPAVX1-NEXT:    vpsrlw %xmm4, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsllw %xmm2, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpor %xmm5, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsrlw %xmm4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpaddw %xmm0, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpsllw %xmm2, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_funnnel_v16i16:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastq {{.*#+}} xmm3 = [15,0,0,0,15,0,0,0]
; XOPAVX2-NEXT:    vpand %xmm3, %xmm2, %xmm4
; XOPAVX2-NEXT:    vpsrlw %xmm4, %ymm1, %ymm1
; XOPAVX2-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; XOPAVX2-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %splat = shufflevector <16 x i16> %amt, <16 x i16> undef, <16 x i32> zeroinitializer
  %res = call <16 x i16> @llvm.fshr.v16i16(<16 x i16> %x, <16 x i16> %y, <16 x i16> %splat)
  ret <16 x i16> %res
}

define <32 x i8> @splatvar_funnnel_v32i8(<32 x i8> %x, <32 x i8> %y, <32 x i8> %amt) nounwind {
; AVX1-LABEL: splatvar_funnnel_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm4[8],xmm3[8],xmm4[9],xmm3[9],xmm4[10],xmm3[10],xmm4[11],xmm3[11],xmm4[12],xmm3[12],xmm4[13],xmm3[13],xmm4[14],xmm3[14],xmm4[15],xmm3[15]
; AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw %xmm2, %xmm5, %xmm5
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3],xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX1-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpackuswb %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; AVX1-NEXT:    vpsrlw %xmm2, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX1-NEXT:    vpsrlw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_funnnel_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX2-NEXT:    vpsrlw %xmm2, %ymm3, %ymm3
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX2-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: splatvar_funnnel_v32i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX512F-NEXT:    vpsrlw %xmm2, %ymm3, %ymm3
; AVX512F-NEXT:    vpbroadcastw {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512F-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v32i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX512VL-NEXT:    vpsrlw %xmm2, %ymm3, %ymm3
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512VL-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512VL-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX512BW-NEXT:    vpsrlw %xmm2, %ymm3, %ymm3
; AVX512BW-NEXT:    vpbroadcastw {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512BW-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512BW-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX512BW-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v32i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,2,4,6,8,10,12,14,64,66,68,70,72,74,76,78,16,18,20,22,24,26,28,30,80,82,84,86,88,90,92,94]
; AVX512VBMI2-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512VBMI2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpsrlw %xmm2, %ymm4, %ymm4
; AVX512VBMI2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512VBMI2-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; AVX512VBMI2-NEXT:    vpermt2b %zmm4, %zmm3, %zmm0
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v32i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512VLBW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsrlw %xmm2, %ymm3, %ymm3
; AVX512VLBW-NEXT:    vpbroadcastw {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512VLBW-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VLBW-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512VLBW-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v32i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512VLVBMI2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX512VLVBMI2-NEXT:    vpsrlw %xmm2, %ymm3, %ymm3
; AVX512VLVBMI2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512VLVBMI2-NEXT:    vpsrlw %xmm2, %ymm0, %ymm1
; AVX512VLVBMI2-NEXT:    vmovdqa {{.*#+}} ymm0 = [0,2,4,6,8,10,12,14,32,34,36,38,40,42,44,46,16,18,20,22,24,26,28,30,48,50,52,54,56,58,60,62]
; AVX512VLVBMI2-NEXT:    vpermi2b %ymm3, %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_funnnel_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm4[8],xmm3[8],xmm4[9],xmm3[9],xmm4[10],xmm3[10],xmm4[11],xmm3[11],xmm4[12],xmm3[12],xmm4[13],xmm3[13],xmm4[14],xmm3[14],xmm4[15],xmm3[15]
; XOPAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlw %xmm2, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3],xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; XOPAVX1-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; XOPAVX1-NEXT:    vpperm %xmm4, %xmm5, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; XOPAVX1-NEXT:    vpsrlw %xmm2, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; XOPAVX1-NEXT:    vpsrlw %xmm2, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpperm %xmm4, %xmm5, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_funnnel_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm3
; XOPAVX2-NEXT:    vextracti128 $1, %ymm1, %xmm4
; XOPAVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm4[8],xmm3[8],xmm4[9],xmm3[9],xmm4[10],xmm3[10],xmm4[11],xmm3[11],xmm4[12],xmm3[12],xmm4[13],xmm3[13],xmm4[14],xmm3[14],xmm4[15],xmm3[15]
; XOPAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; XOPAVX2-NEXT:    vpsrlw %xmm2, %xmm5, %xmm5
; XOPAVX2-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3],xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; XOPAVX2-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; XOPAVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; XOPAVX2-NEXT:    vpperm %xmm4, %xmm5, %xmm3, %xmm3
; XOPAVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; XOPAVX2-NEXT:    vpsrlw %xmm2, %xmm5, %xmm5
; XOPAVX2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; XOPAVX2-NEXT:    vpsrlw %xmm2, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpperm %xmm4, %xmm5, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %splat = shufflevector <32 x i8> %amt, <32 x i8> undef, <32 x i32> zeroinitializer
  %res = call <32 x i8> @llvm.fshr.v32i8(<32 x i8> %x, <32 x i8> %y, <32 x i8> %splat)
  ret <32 x i8> %res
}

;
; Constant Shifts
;

define <4 x i64> @constant_funnnel_v4i64(<4 x i64> %x, <4 x i64> %y) nounwind {
; AVX1-LABEL: constant_funnnel_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpsrlq $60, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlq $50, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm3[4,5,6,7]
; AVX1-NEXT:    vpsrlq $14, %xmm1, %xmm3
; AVX1-NEXT:    vpsrlq $4, %xmm1, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm3[4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsllq $4, %xmm2, %xmm3
; AVX1-NEXT:    vpsllq $14, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm3[4,5,6,7]
; AVX1-NEXT:    vpsllq $50, %xmm0, %xmm3
; AVX1-NEXT:    vpsllq $60, %xmm0, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm3[4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_funnnel_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrlvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: constant_funnnel_v4i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512VL-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v4i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512BW-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v4i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} ymm2 = [4,14,50,60]
; AVX512VBMI2-NEXT:    vpshrdvq %zmm2, %zmm0, %zmm1
; AVX512VBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v4i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v4i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1
; AVX512VLVBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_funnnel_v4i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshlq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOPAVX1-NEXT:    vpshlq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; XOPAVX1-NEXT:    vpshlq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpshlq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; XOPAVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_funnnel_v4i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsrlvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; XOPAVX2-NEXT:    vpsllvq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %res = call <4 x i64> @llvm.fshr.v4i64(<4 x i64> %x, <4 x i64> %y, <4 x i64> <i64 4, i64 14, i64 50, i64 60>)
  ret <4 x i64> %res
}

define <8 x i32> @constant_funnnel_v8i32(<8 x i32> %x, <8 x i32> %y) nounwind {
; AVX1-LABEL: constant_funnnel_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpsrld $11, %xmm2, %xmm3
; AVX1-NEXT:    vpsrld $9, %xmm2, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1,2,3],xmm3[4,5,6,7]
; AVX1-NEXT:    vpsrld $10, %xmm2, %xmm4
; AVX1-NEXT:    vpsrld $8, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm4[4,5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3, %xmm3
; AVX1-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrld $7, %xmm1, %xmm3
; AVX1-NEXT:    vpsrld $5, %xmm1, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1,2,3],xmm3[4,5,6,7]
; AVX1-NEXT:    vpsrld $6, %xmm1, %xmm4
; AVX1-NEXT:    vpsrld $4, %xmm1, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm4[4,5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3],xmm1[4,5],xmm3[6,7]
; AVX1-NEXT:    vpmulld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_funnnel_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrlvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: constant_funnnel_v8i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512VL-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v8i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512BW-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v8i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} ymm2 = [4,5,6,7,8,9,10,11]
; AVX512VBMI2-NEXT:    vpshrdvd %zmm2, %zmm0, %zmm1
; AVX512VBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v8i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v8i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1
; AVX512VLVBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_funnnel_v8i32:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vpshld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpshld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3, %xmm3
; XOPAVX1-NEXT:    vpor %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpshld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vpshld {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_funnnel_v8i32:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsrlvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; XOPAVX2-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %res = call <8 x i32> @llvm.fshr.v8i32(<8 x i32> %x, <8 x i32> %y, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>)
  ret <8 x i32> %res
}

define <16 x i16> @constant_funnnel_v16i16(<16 x i16> %x, <16 x i16> %y) nounwind {
; AVX1-LABEL: constant_funnnel_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmulhuw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3,4,5,6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpmulhuw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vpaddw %xmm0, %xmm0, %xmm2
; AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpaddw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_funnnel_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmulhuw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; AVX2-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: constant_funnnel_v16i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmulhuw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1,2,3,4,5,6,7]
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; AVX512F-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v16i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmulhuw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; AVX512VL-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX512VL-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v16i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
; AVX512BW-NEXT:    vpsrlvw %zmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm2 = [15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0]
; AVX512BW-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; AVX512BW-NEXT:    vpsllvw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v16i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
; AVX512VBMI2-NEXT:    vpshrdvw %zmm2, %zmm0, %zmm1
; AVX512VBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v16i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v16i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1
; AVX512VLVBMI2-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_funnnel_v16i16:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshlw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOPAVX1-NEXT:    vpshlw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; XOPAVX1-NEXT:    vpaddw %xmm0, %xmm0, %xmm2
; XOPAVX1-NEXT:    vpshlw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpaddw %xmm0, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpshlw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; XOPAVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_funnnel_v16i16:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpmulhuw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; XOPAVX2-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1,2,3,4,5,6,7]
; XOPAVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; XOPAVX2-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %res = call <16 x i16> @llvm.fshr.v16i16(<16 x i16> %x, <16 x i16> %y, <16 x i16> <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>)
  ret <16 x i16> %res
}

define <32 x i8> @constant_funnnel_v32i8(<32 x i8> %x, <32 x i8> %y) nounwind {
; AVX1-LABEL: constant_funnnel_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm3[8],xmm2[9],xmm3[9],xmm2[10],xmm3[10],xmm2[11],xmm3[11],xmm2[12],xmm3[12],xmm2[13],xmm3[13],xmm2[14],xmm3[14],xmm2[15],xmm3[15]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [256,2,4,8,16,32,64,128]
; AVX1-NEXT:    vpmullw %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [256,128,64,32,16,8,4,2]
; AVX1-NEXT:    vpmullw %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vpackuswb %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpaddb %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm4[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm8 = [128,1,2,4,8,16,32,64]
; AVX1-NEXT:    vpmullw %xmm7, %xmm8, %xmm7
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm9 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm7, %xmm9, %xmm7
; AVX1-NEXT:    vpmovzxbw {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm10 = [128,64,32,16,8,4,2,1]
; AVX1-NEXT:    vpmullw %xmm4, %xmm10, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm9, %xmm4
; AVX1-NEXT:    vpackuswb %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vpor %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8],xmm3[8],xmm1[9],xmm3[9],xmm1[10],xmm3[10],xmm1[11],xmm3[11],xmm1[12],xmm3[12],xmm1[13],xmm3[13],xmm1[14],xmm3[14],xmm1[15],xmm3[15]
; AVX1-NEXT:    vpmullw %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; AVX1-NEXT:    vpmullw %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX1-NEXT:    vpmullw %xmm3, %xmm8, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm9, %xmm3
; AVX1-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX1-NEXT:    vpmullw %xmm0, %xmm10, %xmm0
; AVX1-NEXT:    vpand %xmm0, %xmm9, %xmm0
; AVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_funnnel_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15],ymm1[24],ymm2[24],ymm1[25],ymm2[25],ymm1[26],ymm2[26],ymm1[27],ymm2[27],ymm1[28],ymm2[28],ymm1[29],ymm2[29],ymm1[30],ymm2[30],ymm1[31],ymm2[31]
; AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[16],ymm2[16],ymm1[17],ymm2[17],ymm1[18],ymm2[18],ymm1[19],ymm2[19],ymm1[20],ymm2[20],ymm1[21],ymm2[21],ymm1[22],ymm2[22],ymm1[23],ymm2[23]
; AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: constant_funnnel_v32i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15],ymm1[24],ymm2[24],ymm1[25],ymm2[25],ymm1[26],ymm2[26],ymm1[27],ymm2[27],ymm1[28],ymm2[28],ymm1[29],ymm2[29],ymm1[30],ymm2[30],ymm1[31],ymm2[31]
; AVX512F-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX512F-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[16],ymm2[16],ymm1[17],ymm2[17],ymm1[18],ymm2[18],ymm1[19],ymm2[19],ymm1[20],ymm2[20],ymm1[21],ymm2[21],ymm1[22],ymm2[22],ymm1[23],ymm2[23]
; AVX512F-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512F-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX512F-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX512F-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512F-NEXT:    vpand %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v32i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm2[8],ymm1[9],ymm2[9],ymm1[10],ymm2[10],ymm1[11],ymm2[11],ymm1[12],ymm2[12],ymm1[13],ymm2[13],ymm1[14],ymm2[14],ymm1[15],ymm2[15],ymm1[24],ymm2[24],ymm1[25],ymm2[25],ymm1[26],ymm2[26],ymm1[27],ymm2[27],ymm1[28],ymm2[28],ymm1[29],ymm2[29],ymm1[30],ymm2[30],ymm1[31],ymm2[31]
; AVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX512VL-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[4],ymm2[4],ymm1[5],ymm2[5],ymm1[6],ymm2[6],ymm1[7],ymm2[7],ymm1[16],ymm2[16],ymm1[17],ymm2[17],ymm1[18],ymm2[18],ymm1[19],ymm2[19],ymm1[20],ymm2[20],ymm1[21],ymm2[21],ymm1[22],ymm2[22],ymm1[23],ymm2[23]
; AVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VL-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-NEXT:    vpsllw $8, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v32i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,64,1,65,2,66,3,67,4,68,5,69,6,70,7,71,8,72,9,73,10,74,11,75,12,76,13,77,14,78,15,79,16,80,17,81,18,82,19,83,20,84,21,85,22,86,23,87,24,88,25,89,26,90,27,91,28,92,29,93,30,94,31,95]
; AVX512VBMI2-NEXT:    vpermi2b %zmm0, %zmm1, %zmm2
; AVX512VBMI2-NEXT:    vpsrlvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm0
; AVX512VBMI2-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v32i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512VLBW-NEXT:    vpsllw $8, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpsrlvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v32i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VLVBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VLVBMI2-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,64,1,65,2,66,3,67,4,68,5,69,6,70,7,71,8,72,9,73,10,74,11,75,12,76,13,77,14,78,15,79,16,80,17,81,18,82,19,83,20,84,21,85,22,86,23,87,24,88,25,89,26,90,27,91,28,92,29,93,30,94,31,95]
; AVX512VLVBMI2-NEXT:    vpermi2b %zmm0, %zmm1, %zmm2
; AVX512VLVBMI2-NEXT:    vpsrlvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm0
; AVX512VLVBMI2-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_funnnel_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,255,254,253,252,251,250,249,0,249,250,251,252,253,254,255]
; XOPAVX1-NEXT:    vpshlb %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOPAVX1-NEXT:    vpaddb %xmm4, %xmm4, %xmm4
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [7,6,5,4,3,2,1,0,7,0,1,2,3,4,5,6]
; XOPAVX1-NEXT:    vpshlb %xmm5, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpor %xmm2, %xmm4, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm3, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpshlb %xmm5, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_funnnel_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; XOPAVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,255,254,253,252,251,250,249,0,249,250,251,252,253,254,255]
; XOPAVX2-NEXT:    vpshlb %xmm3, %xmm2, %xmm2
; XOPAVX2-NEXT:    vpshlb %xmm3, %xmm1, %xmm1
; XOPAVX2-NEXT:    vinserti128 $1, %xmm2, %ymm1, %ymm1
; XOPAVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; XOPAVX2-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; XOPAVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [7,6,5,4,3,2,1,0,7,0,1,2,3,4,5,6]
; XOPAVX2-NEXT:    vpshlb %xmm3, %xmm2, %xmm2
; XOPAVX2-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpshlb %xmm3, %xmm0, %xmm0
; XOPAVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %res = call <32 x i8> @llvm.fshr.v32i8(<32 x i8> %x, <32 x i8> %y, <32 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <32 x i8> %res
}

;
; Uniform Constant Shifts
;

define <4 x i64> @splatconstant_funnnel_v4i64(<4 x i64> %x, <4 x i64> %y) nounwind {
; AVX1-LABEL: splatconstant_funnnel_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrlq $14, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpsrlq $14, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vpsllq $50, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsllq $50, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatconstant_funnnel_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrlq $14, %ymm1, %ymm1
; AVX2-NEXT:    vpsllq $50, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: splatconstant_funnnel_v4i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlq $14, %ymm1, %ymm1
; AVX512F-NEXT:    vpsllq $50, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlq $14, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsllq $50, %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v4i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlq $14, %ymm1, %ymm1
; AVX512BW-NEXT:    vpsllq $50, %ymm0, %ymm0
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v4i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vpshrdq $14, %zmm0, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v4i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlq $14, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsllq $50, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v4i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdq $14, %ymm0, %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: splatconstant_funnnel_v4i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpsrlq $14, %xmm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOPAVX1-NEXT:    vpsrlq $14, %xmm1, %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; XOPAVX1-NEXT:    vpsllq $50, %xmm0, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpsllq $50, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; XOPAVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatconstant_funnnel_v4i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsrlq $14, %ymm1, %ymm1
; XOPAVX2-NEXT:    vpsllq $50, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %res = call <4 x i64> @llvm.fshr.v4i64(<4 x i64> %x, <4 x i64> %y, <4 x i64> <i64 14, i64 14, i64 14, i64 14>)
  ret <4 x i64> %res
}

define <8 x i32> @splatconstant_funnnel_v8i32(<8 x i32> %x, <8 x i32> %y) nounwind {
; AVX1-LABEL: splatconstant_funnnel_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrld $4, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpsrld $4, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vpslld $28, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpslld $28, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatconstant_funnnel_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrld $4, %ymm1, %ymm1
; AVX2-NEXT:    vpslld $28, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: splatconstant_funnnel_v8i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrld $4, %ymm1, %ymm1
; AVX512F-NEXT:    vpslld $28, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrld $4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpslld $28, %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v8i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrld $4, %ymm1, %ymm1
; AVX512BW-NEXT:    vpslld $28, %ymm0, %ymm0
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v8i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vpshrdd $4, %zmm0, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v8i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrld $4, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpslld $28, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v8i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdd $4, %ymm0, %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: splatconstant_funnnel_v8i32:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpsrld $4, %xmm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOPAVX1-NEXT:    vpsrld $4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; XOPAVX1-NEXT:    vpslld $28, %xmm0, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpslld $28, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; XOPAVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatconstant_funnnel_v8i32:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsrld $4, %ymm1, %ymm1
; XOPAVX2-NEXT:    vpslld $28, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %res = call <8 x i32> @llvm.fshr.v8i32(<8 x i32> %x, <8 x i32> %y, <8 x i32> <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>)
  ret <8 x i32> %res
}

define <16 x i16> @splatconstant_funnnel_v16i16(<16 x i16> %x, <16 x i16> %y) nounwind {
; AVX1-LABEL: splatconstant_funnnel_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrlw $7, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpsrlw $7, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vpsllw $9, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsllw $9, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatconstant_funnnel_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrlw $7, %ymm1, %ymm1
; AVX2-NEXT:    vpsllw $9, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: splatconstant_funnnel_v16i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlw $7, %ymm1, %ymm1
; AVX512F-NEXT:    vpsllw $9, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v16i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlw $7, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsllw $9, %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v16i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlw $7, %ymm1, %ymm1
; AVX512BW-NEXT:    vpsllw $9, %ymm0, %ymm0
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v16i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VBMI2-NEXT:    vpshrdw $7, %zmm0, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v16i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlw $7, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsllw $9, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v16i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdw $7, %ymm0, %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: splatconstant_funnnel_v16i16:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpsrlw $7, %xmm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; XOPAVX1-NEXT:    vpsrlw $7, %xmm1, %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; XOPAVX1-NEXT:    vpsllw $9, %xmm0, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; XOPAVX1-NEXT:    vpsllw $9, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; XOPAVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatconstant_funnnel_v16i16:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsrlw $7, %ymm1, %ymm1
; XOPAVX2-NEXT:    vpsllw $9, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %res = call <16 x i16> @llvm.fshr.v16i16(<16 x i16> %x, <16 x i16> %y, <16 x i16> <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>)
  ret <16 x i16> %res
}

define <32 x i8> @splatconstant_funnnel_v32i8(<32 x i8> %x, <32 x i8> %y) nounwind {
; AVX1-LABEL: splatconstant_funnnel_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm2, %xmm2
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsllw $4, %xmm2, %xmm2
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsllw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatconstant_funnnel_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpsllw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: splatconstant_funnnel_v32i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX512F-NEXT:    vpsrlw $4, %ymm1, %ymm0
; AVX512F-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm2, %zmm0
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v32i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm1, %ymm0
; AVX512VL-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX512BW-NEXT:    vpsrlw $4, %ymm1, %ymm0
; AVX512BW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm2, %zmm0
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v32i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX512VBMI2-NEXT:    vpsrlw $4, %ymm1, %ymm0
; AVX512VBMI2-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm2, %zmm0
; AVX512VBMI2-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v32i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpsrlw $4, %ymm1, %ymm0
; AVX512VLBW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm2, %ymm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v32i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX512VLVBMI2-NEXT:    vpsrlw $4, %ymm1, %ymm0
; AVX512VLVBMI2-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm2, %ymm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: splatconstant_funnnel_v32i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; XOPAVX1-NEXT:    vpshlb %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm3, %xmm1, %xmm1
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; XOPAVX1-NEXT:    vpshlb %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm3, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatconstant_funnnel_v32i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsrlw $4, %ymm1, %ymm1
; XOPAVX2-NEXT:    vpsllw $4, %ymm0, %ymm0
; XOPAVX2-NEXT:    vpcmov {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm0, %ymm0
; XOPAVX2-NEXT:    retq
  %res = call <32 x i8> @llvm.fshr.v32i8(<32 x i8> %x, <32 x i8> %y, <32 x i8> <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>)
  ret <32 x i8> %res
}
