; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mattr=+complxnum,+neon,+fullfp16 -o - | FileCheck %s

target triple = "aarch64"

; Expected to transform
define <2 x float> @complex_mul_v2f32(<2 x float> %a, <2 x float> %b) {
; CHECK-LABEL: complex_mul_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d2, #0000000000000000
; CHECK-NEXT:    fcmla v2.2s, v0.2s, v1.2s, #0
; CHECK-NEXT:    fcmla v2.2s, v0.2s, v1.2s, #90
; CHECK-NEXT:    fmov d0, d2
; CHECK-NEXT:    ret
entry:
  %a.real   = shufflevector <2 x float> %a, <2 x float> poison, <1 x i32> <i32 0>
  %a.imag = shufflevector <2 x float> %a, <2 x float> poison, <1 x i32> <i32 1>
  %b.real = shufflevector <2 x float> %b, <2 x float> poison, <1 x i32> <i32 0>
  %b.imag = shufflevector <2 x float> %b, <2 x float> poison, <1 x i32> <i32 1>
  %0 = fmul fast <1 x float> %b.imag, %a.real
  %1 = fmul fast <1 x float> %b.real, %a.imag
  %2 = fadd fast <1 x float> %1, %0
  %3 = fmul fast <1 x float> %b.real, %a.real
  %4 = fmul fast <1 x float> %a.imag, %b.imag
  %5 = fsub fast <1 x float> %3, %4
  %interleaved.vec = shufflevector <1 x float> %5, <1 x float> %2, <2 x i32> <i32 0, i32 1>
  ret <2 x float> %interleaved.vec
}

; Expected to transform
define <4 x float> @complex_mul_v4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: complex_mul_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v2.2d, #0000000000000000
; CHECK-NEXT:    fcmla v2.4s, v0.4s, v1.4s, #0
; CHECK-NEXT:    fcmla v2.4s, v0.4s, v1.4s, #90
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
entry:
  %a.real   = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %a.imag = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %b.real = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %b.imag = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul fast <2 x float> %b.imag, %a.real
  %1 = fmul fast <2 x float> %b.real, %a.imag
  %2 = fadd fast <2 x float> %1, %0
  %3 = fmul fast <2 x float> %b.real, %a.real
  %4 = fmul fast <2 x float> %a.imag, %b.imag
  %5 = fsub fast <2 x float> %3, %4
  %interleaved.vec = shufflevector <2 x float> %5, <2 x float> %2, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x float> %interleaved.vec
}

; Expected to transform
define <8 x float> @complex_mul_v8f32(<8 x float> %a, <8 x float> %b) {
; CHECK-LABEL: complex_mul_v8f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v4.2d, #0000000000000000
; CHECK-NEXT:    movi v5.2d, #0000000000000000
; CHECK-NEXT:    fcmla v4.4s, v0.4s, v2.4s, #0
; CHECK-NEXT:    fcmla v5.4s, v1.4s, v3.4s, #0
; CHECK-NEXT:    fcmla v4.4s, v0.4s, v2.4s, #90
; CHECK-NEXT:    fcmla v5.4s, v1.4s, v3.4s, #90
; CHECK-NEXT:    mov v0.16b, v4.16b
; CHECK-NEXT:    mov v1.16b, v5.16b
; CHECK-NEXT:    ret
entry:
  %a.real   = shufflevector <8 x float> %a, <8 x float> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %a.imag = shufflevector <8 x float> %a, <8 x float> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %b.real = shufflevector <8 x float> %b, <8 x float> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %b.imag = shufflevector <8 x float> %b, <8 x float> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %0 = fmul fast <4 x float> %b.imag, %a.real
  %1 = fmul fast <4 x float> %b.real, %a.imag
  %2 = fadd fast <4 x float> %1, %0
  %3 = fmul fast <4 x float> %b.real, %a.real
  %4 = fmul fast <4 x float> %a.imag, %b.imag
  %5 = fsub fast <4 x float> %3, %4
  %interleaved.vec = shufflevector <4 x float> %5, <4 x float> %2, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  ret <8 x float> %interleaved.vec
}

; Expected to transform
define <16 x float> @complex_mul_v16f32(<16 x float> %a, <16 x float> %b) {
; CHECK-LABEL: complex_mul_v16f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v16.2d, #0000000000000000
; CHECK-NEXT:    movi v17.2d, #0000000000000000
; CHECK-NEXT:    movi v18.2d, #0000000000000000
; CHECK-NEXT:    movi v19.2d, #0000000000000000
; CHECK-NEXT:    fcmla v16.4s, v0.4s, v4.4s, #0
; CHECK-NEXT:    fcmla v17.4s, v1.4s, v5.4s, #0
; CHECK-NEXT:    fcmla v18.4s, v2.4s, v6.4s, #0
; CHECK-NEXT:    fcmla v19.4s, v3.4s, v7.4s, #0
; CHECK-NEXT:    fcmla v16.4s, v0.4s, v4.4s, #90
; CHECK-NEXT:    fcmla v17.4s, v1.4s, v5.4s, #90
; CHECK-NEXT:    fcmla v18.4s, v2.4s, v6.4s, #90
; CHECK-NEXT:    fcmla v19.4s, v3.4s, v7.4s, #90
; CHECK-NEXT:    mov v0.16b, v16.16b
; CHECK-NEXT:    mov v1.16b, v17.16b
; CHECK-NEXT:    mov v2.16b, v18.16b
; CHECK-NEXT:    mov v3.16b, v19.16b
; CHECK-NEXT:    ret
entry:
  %a.real   = shufflevector <16 x float> %a, <16 x float> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %a.imag = shufflevector <16 x float> %a, <16 x float> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %b.real = shufflevector <16 x float> %b, <16 x float> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %b.imag = shufflevector <16 x float> %b, <16 x float> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %0 = fmul fast <8 x float> %b.imag, %a.real
  %1 = fmul fast <8 x float> %b.real, %a.imag
  %2 = fadd fast <8 x float> %1, %0
  %3 = fmul fast <8 x float> %b.real, %a.real
  %4 = fmul fast <8 x float> %a.imag, %b.imag
  %5 = fsub fast <8 x float> %3, %4
  %interleaved.vec = shufflevector <8 x float> %5, <8 x float> %2, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  ret <16 x float> %interleaved.vec
}
