/* Generated by JTB 1.5.1 */
package grammars.a.sgtree;

import java.util.ArrayList;
import java.util.List;
import grammars.a.sgvis.IVis2Visitor;
import grammars.a.sgvis.IVoidVisitor;

@SuppressWarnings("javadoc")
public class NodeOptional implements INode {

  public INode node;

  private INode parent;

  private static final long serialVersionUID = 151L;

  public NodeOptional() {
    node = null;
  }

  public NodeOptional(final INode n) {
    addNode(n);
  }

  public void addNode(final INode n) {
    if (node != null)
      throw new Error("Attempt to set optional node twice"); //$NON-NLS-1$
    node = n;
    if (n != null)
      n.setParent(this);
  }

  public boolean present() {
    return (node != null); }

  /*
   * Visitors accept methods (no -novis option, visitors specification : Void,void,None;Vis2,R,A,int[],short...)
   */

  @Override
  public <R, A> R accept(final IVis2Visitor<R, A> vis, final A argu, final int[] argu1, final short... argu2) {
    return vis.visit(this, argu, argu1, argu2);
  }

  @Override
  public void accept(final IVoidVisitor vis) {
    vis.visit(this);
  }

  /*
   * Parent pointer getter and setter (-pp option)
   */

  @Override
  public INode getParent() {
    return parent;
  }

  @Override
  public void setParent(final INode n) {
    parent = n;
  }

  /*
   * Children methods (-chm option)
   */

  private List<INode> lac = null;

  private List<INode> lbc = null;

  private List<INode> luc = null;

  private int nbLbc = -1;

  private int nbLuc = -1;

  @Override
  public int getNbAllChildren() {
    return node == null ? 0 : 1;
  }

  @Override
  public int getNbBaseChildren() {
    if (lbc == null)
      getBaseChildren();
    return nbLbc;
  }

  @Override
  public int getNbUserChildren() {
    if (luc == null)
      getUserChildren();
    return nbLuc;
  }

  @Override
  public List<INode> getAllChildren() {
    if (lac == null) {
      if (node == null) {
        lac = new ArrayList<>(0);
      } else {
        lac = new ArrayList<>(1);
        lac.add(node);
      }
    }
    return lac;
  }

  @Override
  public List<INode> getBaseChildren() {
    if (lbc == null) {
      nbLbc = 0;
      if (node != null && node.isBaseNode())
        nbLbc++;
      lbc = new ArrayList<>(nbLbc);
      if (node != null && node.isBaseNode())
        lbc.add(node);
    }
    return lbc;
  }

  @Override
  public List<INode> getUserChildren() {
    if (luc == null) {
      nbLuc = 0;
      if (node != null && !node.isBaseNode())
        nbLuc++;
      luc = new ArrayList<>(nbLuc);
      if (node != null && !node.isBaseNode())
        luc.add(node);
    }
    return luc;
  }

  @Override
  public boolean isBaseNode() {
    return true;
  }

}
