/* Generated by JTB 1.5.1 */
package examples.java.ex3jtb.syntaxtree;

import java.util.ArrayList;
import java.util.List;
import examples.java.ex3jtb.visitor.IGenVisitor;

/**
 * Represents a grammar optional node (? or []), e.g. ' ( A )? ' or ' [ A ] '.<br>
 * The class stores the node.
 */
public class NodeOptional implements INode {

  /** The node (if null there is no node) */
  public INode node;

  /** The parent node */
  private INode parent;

  /** The serial version UID */
  private static final long serialVersionUID = 151L;

  /**
   * Initializes an empty {@link NodeOptional}.
   */
  public NodeOptional() {
    node = null;
  }

  /**
   * Initializes a {@link NodeOptional} with a node.
   *
   * @param n - the node
   */
  public NodeOptional(final INode n) {
    addNode(n);
  }

  /**
   * Adds a node to the {@link NodeOptional}.
   *
   * @param n - the node to add
   */
  public void addNode(final INode n) {
    if (node != null)
      throw new Error("Attempt to set optional node twice"); //$NON-NLS-1$
    node = n;
    if (n != null)
      n.setParent(this);
  }

  /**
   * @return true if the node exists, false otherwise
   */
  public boolean present() {
    return (node != null); }

  /*
   * Visitors accept methods (no -novis option, visitors specification : Gen,void,java.lang.String)
   */

  /**
   * Accepts a {@link IGenVisitor} visitor with user argument data.
   *
   * @param vis - the visitor
   * @param argu - the user Argument data
   */
  @Override
  public void accept(final IGenVisitor vis, final String argu) {
    vis.visit(this, argu);
  }

  /*
   * Parent pointer getter and setter (-pp option)
   */

  /**
   * Gets the parent node.
   *
   * @return the parent node
   */
  @Override
  public INode getParent() {
    return parent;
  }

  /**
   * Sets the parent node.
   *
   * @param n - the parent node
   */
  @Override
  public void setParent(final INode n) {
    parent = n;
  }

  /*
   * Children methods (-chm option)
   */

  /** The list of all direct children (base + user nodes) */
  private List<INode> lac = null;

  /** The list of direct base nodes children */
  private List<INode> lbc = null;

  /** The list of direct user nodes children */
  private List<INode> luc = null;

  /** The number of direct base nodes children */
  private int nbLbc = -1;

  /** The number of direct user nodes children */
  private int nbLuc = -1;

  /**
   * @return the number of all direct children (base + user nodes) (0 or 1)
   */
  @Override
  public int getNbAllChildren() {
    return node == null ? 0 : 1;
  }

  /**
   * @return the number of direct base nodes children (0 or 1)
   */
  @Override
  public int getNbBaseChildren() {
    if (lbc == null)
      getBaseChildren();
    return nbLbc;
  }

  /**
   * @return the number of direct user nodes children (0 or 1)
   */
  @Override
  public int getNbUserChildren() {
    if (luc == null)
      getUserChildren();
    return nbLuc;
  }

  /**
   * @return the list of all direct children (base + user nodes) (0 or 1)
   */
  @Override
  public List<INode> getAllChildren() {
    if (lac == null) {
      if (node == null) {
        lac = new ArrayList<>(0);
      } else {
        lac = new ArrayList<>(1);
        lac.add(node);
      }
    }
    return lac;
  }

  /**
   * @return the list of direct base nodes children (0 or 1)
   */
  @Override
  public List<INode> getBaseChildren() {
    if (lbc == null) {
      nbLbc = 0;
      if (node != null && node.isBaseNode())
        nbLbc++;
      lbc = new ArrayList<>(nbLbc);
      if (node != null && node.isBaseNode())
        lbc.add(node);
    }
    return lbc;
  }

  /**
   * @return the list of direct user nodes children (0 or 1)
   */
  @Override
  public List<INode> getUserChildren() {
    if (luc == null) {
      nbLuc = 0;
      if (node != null && !node.isBaseNode())
        nbLuc++;
      luc = new ArrayList<>(nbLuc);
      if (node != null && !node.isBaseNode())
        luc.add(node);
    }
    return luc;
  }

  /**
   * @return true if the node is a base node, false otherwise (always true : the node is a base node)
   */
  @Override
  public boolean isBaseNode() {
    return true;
  }

}
