// Copyright (c) 2011 Jan Kokemüller
// Copyright (c) 2020 Sebastian Dröge <sebastian@centricular.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// DO NOT EDIT: This file is autogenerated by `examples/generate_histogram_bins.rs`

/// Histogram energies, i.e. energy at the center of each histogram bin.
pub static ENERGIES: [f64; 1000] = [
    0.000000118604181294802408330460116465,
    0.000000121366827574167330221758436329,
    0.000000124193824151992231012031240797,
    0.000000127086669939281845165938186586,
    0.000000130046898761164506108813478449,
    0.000000133076080170144241639272435218,
    0.000000136175820278300083164500495873,
    0.000000139347762608868109276901185375,
    0.000000142593588967656765790703522929,
    0.000000145915020334765644933593814470,
    0.000000149313817777069356649625423046,
    0.000000152791783381960179872757765729,
    0.000000156350761212839396451892742985,
    0.000000159992638286859704144248807423,
    0.000000163719345575453265876128940495,
    0.000000167532859028152318020234634241,
    0.000000171435200620267652772479318422,
    0.000000175428439424965355178869875000,
    0.000000179514692710315368466645409747,
    0.000000183696127061899357968153341687,
    0.000000187974959531556132442641480519,
    0.000000192353458812899659278390402002,
    0.000000196833946444205190676665097847,
    0.000000201418798039320321928522406624,
    0.000000206110444547249306096258587503,
    0.000000210911373541070649053865348685,
    0.000000215824130536885966504811475673,
    0.000000220851320343482467425502203430,
    0.000000225995608443437459329495827290,
    0.000000231259722406395123632129166326,
    0.000000236646453335256529655942180079,
    0.000000242158657346061866420800076302,
    0.000000247799257082341859659361518395,
    0.000000253571243264737311415610949636,
    0.000000259477676276724477811289537241,
    0.000000265521687787266133463828093886,
    0.000000271706482411267039829219508210,
    0.000000278035339408704514400048901646,
    0.000000284511614423327614638916391657,
    0.000000291138741261875572311867803321,
    0.000000297920233714716721277711904831,
    0.000000304859687418913929176766258733,
    0.000000311960781764676327227389217994,
    0.000000319227281846218118710857905573,
    0.000000326663040458069387164148763766,
    0.000000334272000137866037608284919269,
    0.000000342058195256749448038598041336,
    0.000000350025754158434145904939737912,
    0.000000358178901348111515076546966518,
    0.000000366521959732342609830570579615,
    0.000000375059352911114010589602261320,
    0.000000383795607523297042340776168146,
    0.000000392735355646725159801485550634,
    0.000000401883337254183342158645299638,
    0.000000411244402726609375318180547923,
    0.000000420823515424823416743892916594,
    0.000000430625754321172594639037306194,
    0.000000440656316692470246383449674135,
    0.000000450920520875653288033645853597,
    0.000000461423809087644204768763507574,
    0.000000472171750310878688237242479381,
    0.000000483170043246059843707355604958,
    0.000000494424519333682790447079356128,
    0.000000505941145845936529773804925941,
    0.000000517726029050642630075797744060,
    0.000000529785417448864496541981357336,
    0.000000542125705087956677426859909003,
    0.000000554753434951769766206124395030,
    0.000000567675302429821750185053984977,
    0.000000580898158867295254637172410156,
    0.000000594429015197695144078675420080,
    0.000000608275045660152243544348607540,
    0.000000622443591603289274270783236476,
    0.000000636942165377709199672849344626,
    0.000000651778454319138754807718035000,
    0.000000666960324824355964881119826493,
    0.000000682495826522059998624561427683,
    0.000000698393196540884901052533267202,
    0.000000714660863876842606370518289766,
    0.000000731307453862482643507862255933,
    0.000000748341792740160555318551689752,
    0.000000765772912341822404965114602649,
    0.000000783610054877810681185385400377,
    0.000000801862677837200514031901210643,
    0.000000820540459002286815143616029861,
    0.000000839653301579874826224259530549,
    0.000000859211339452084157642080663314,
    0.000000879224942549479419447925991615,
    0.000000899704722349328582768222730554,
    0.000000920661537501970945184556847224,
    0.000000942106499588191129262982302650,
    0.000000964050979010746688665058415357,
    0.000000986506611023098958088086048168,
    0.000001009485301898570425036200451374,
    0.000001032999235243230146092481211428,
    0.000001057060878455775272560823209445,
    0.000001081682989337934354241396207874,
    0.000001106878622858805328842417455004,
    0.000001132661138076786744085665444015,
    0.000001159044205222719043190510689045,
    0.000001186041812948024056834821562956,
    0.000001213668275741675949195544532977,
    0.000001241938241519922204241194001184,
    0.000001270866699392818504598941069250,
    0.000001300468987611642414110174614805,
    0.000001330760801701442628150961165756,
    0.000001361758202783003849199879552179,
    0.000001393477626088681198648130260542,
    0.000001425935889676567816725712839476,
    0.000001459150203347653484720622754645,
    0.000001493138177770693513556695027067,
    0.000001527917833819604975101129860915,
    0.000001563507612128393911579368226461,
    0.000001599926382868596829684251260650,
    0.000001637193455754532552882170998165,
    0.000001675328590281523286081464749198,
    0.000001714352006202676580664352387617,
    0.000001754284394249653657667817156784,
    0.000001795146927103153843485131707647,
    0.000001836961270618989926851948382702,
    0.000001879749595315561271486855601798,
    0.000001923534588129000563250844274554,
    0.000001968339464442051959706210181866,
    0.000002014187980393203431043460879812,
    0.000002061104445472488931676968010320,
    0.000002109113735410706596417771893637,
    0.000002158241305368863953152410231628,
    0.000002208513203434824621315462830906,
    0.000002259956084434374487415839866111,
    0.000002312597224063946524700522561213,
    0.000002366464533352565296559421800793,
    0.000002421586573460623852284802695611,
    0.000002477992570823418702472733590736,
    0.000002535712432647373220035227903146,
    0.000002594776762767239801794330253393,
    0.000002655216877872661334638280938858,
    0.000002717064824112675798127233828261,
    0.000002780353394087045567516962643606,
    0.000002845116144233276464026519136929,
    0.000002911387412618755299602204406062,
    0.000002979202337147167424535355861881,
    0.000003048596874189139715284136214479,
    0.000003119607817646763060515655366367,
    0.000003192272818462181610625052682884,
    0.000003266630404580687201257028010049,
    0.000003342720001378660376082849192692,
    0.000003420581952567501150770440040971,
    0.000003500257541584341141412042158754,
    0.000003581789013481115150765469665184,
    0.000003665219597323418686767417321026,
    0.000003750593529111139894137785799622,
    0.000003837956075232978470220760597309,
    0.000003927353556467251703893973913129,
    0.000004018833372541833315707334589595,
    0.000004112444027266085600489688156589,
    0.000004208235154248234061559810759157,
    0.000004306257543211734099082490384580,
    0.000004406563166924702357955378334564,
    0.000004509205208756532774457340129182,
    0.000004614238090876433153841688905583,
    0.000004721717503108786670614187980233,
    0.000004831700432460599284106503303882,
    0.000004944245193336827692712556747701,
    0.000005059411458459365509496286072988,
    0.000005177260290506426724274451067753,
    0.000005297854174488644541903339946209,
    0.000005421257050879567409543309530751,
    0.000005547534349517697873819480763879,
    0.000005676753024298216866575829409047,
    0.000005808981588672951911097013660834,
    0.000005944290151976951229028517387221,
    0.000006082750456601522435443486075402,
    0.000006224435916032892319191358737607,
    0.000006369421653777092632003203886981,
    0.000006517784543191387124560706722853,
    0.000006669603248243559648811198264928,
    0.000006824958265220599986245614276825,
    0.000006983931965408849222283569485592,
    0.000007146608638768426275463419711231,
    0.000007313074538624825799803912118602,
    0.000007483417927401605129669043270368,
    0.000007657729123418223626134672399335,
    0.000007836100548778107447128564444494,
    0.000008018626778372005140319012106431,
    0.000008205404590022868363194397112181,
    0.000008396533015798748685759068932644,
    0.000008592113394520842635211990701016,
    0.000008792249425494794617995733543303,
    0.000008997047223493286039440464119110,
    0.000009206615375019709240087331658664,
    0.000009421064995881911716146296653651,
    0.000009640509790107467733683531407873,
    0.000009865066110230990851430281363132,
    0.000010094853018985705097394951768042,
    0.000010329992352432302307957759368584,
    0.000010570608784557752302091758467295,
    0.000010816829893379344812963382960191,
    0.000011068786228588054558973595431492,
    0.000011326611380767868711406075321602,
    0.000011590442052227190855421580517604,
    0.000011860418129480239721315268375257,
    0.000012136682757416759068438971702619,
    0.000012419382415199222465928413638991,
    0.000012708666993928185469505884319652,
    0.000013004689876116424141101746148053,
    0.000013307608017014425010960190776110,
    0.000013617582027830037221449374640336,
    0.000013934776260886811986481302605423,
    0.000014259358896765678167257128394763,
    0.000014591502033476535694239174800746,
    0.000014931381777706936406116371152120,
    0.000015279178338196048480461877727699,
    0.000015635076121283940386343103146061,
    0.000015999263828685969567391933487954,
    0.000016371934557545327222887604490253,
    0.000016753285902815233707847594746276,
    0.000017143520062026766653676471130474,
    0.000017542843942496537000194645194995,
    0.000017951469271031536740785422567868,
    0.000018369612706189898421486536572722,
    0.000018797495953155615255967397780879,
    0.000019235345881290003938442548236942,
    0.000019683394644420517055963260055762,
    0.000020141879803932031769335767035223,
    0.000020611044454724887622703785594602,
    0.000021091137354107066811210666190668,
    0.000021582413053688642072622944079185,
    0.000022085132034348247060187575563361,
    0.000022599560844343743180092504152512,
    0.000023125972240639466941071120120732,
    0.000023664645333525650424495376245027,
    0.000024215865734606237675815079701813,
    0.000024779925708234186177694388653059,
    0.000025357124326473732200352279031463,
    0.000025947767627672395476844460771026,
    0.000026552168778726613346382809388579,
    0.000027170648241126757981272338282608,
    0.000027803533940870454828136679181760,
    0.000028451161442332761252133402352094,
    0.000029113874126187554690087938569221,
    0.000029792023371471674245353558618810,
    0.000030485968741891396305808414890492,
    0.000031196078176467629758123606409370,
    0.000031922728184621816953283474083136,
    0.000032666304045806871165537332846185,
    0.000033427200013786603760828491926915,
    0.000034205819525675012354737347664013,
    0.000035002575415843413108186316096138,
    0.000035817890134811148966555854888938,
    0.000036652195973234189408773014973164,
    0.000037505935291111398941377857996216,
    0.000038379560752329783008141711464489,
    0.000039273535564672513650807950114086,
    0.000040188333725418334851139240404549,
    0.000041124440272660852616765092548690,
    0.000042082351542482340615598107591566,
    0.000043062575432117342684890798354402,
    0.000044065631669247025273619677854242,
    0.000045092052087565327744573401291817,
    0.000046142380908764328150285100038630,
    0.000047217175031087868400207774310928,
    0.000048317004324605986064801455004414,
    0.000049442451933368276927125567477006,
    0.000050594114584593655094962860729879,
    0.000051772602905064263854612721660331,
    0.000052978541744886445419033399462094,
    0.000054212570508795670707301306290304,
    0.000055475343495176977044128913130194,
    0.000056767530242982172053890083107675,
    0.000058089815886729520805036031116941,
    0.000059442901519769512290285173872206,
    0.000060827504566015229436632544279817,
    0.000062244359160328928274111270901869,
    0.000063694216537770926320032038869812,
    0.000065177845431913878021870645262936,
    0.000066696032482435591405914299123481,
    0.000068249582652205999862456142768252,
    0.000069839319654088497305033378381722,
    0.000071466086387684261060568302603713,
    0.000073130745386248261386170910203219,
    0.000074834179274016051296690432703684,
    0.000076577291234182246425742091044953,
    0.000078361005487781077859417433462141,
    0.000080186267783720051403190121064313,
    0.000082054045900228683631943971121814,
    0.000083965330157987483469458900309235,
    0.000085921133945208419575856328975760,
    0.000087922494254947939403693757398628,
    0.000089970472234932860394404641191102,
    0.000092066153750197099177136894621043,
    0.000094210649958819113773331177519310,
    0.000096405097901074667172439947027129,
    0.000098650661102309911902434602648526,
    0.000100948530189857142453507821144854,
    0.000103299923524323016303314015651438,
    0.000105706087845577512856522217621347,
    0.000108168298933793326156889424982666,
    0.000110687862285880548977867743332126,
    0.000113266113807678568529448137613969,
    0.000115904420522271905166084016158834,
    0.000118604181294802525962160666406220,
    0.000121366827574167590684389717026193,
    0.000124193824151992238211811292458719,
    0.000127086669939281861471322421230923,
    0.000130046898761164241411017461480526,
    0.000133076080170144107808066769038646,
    0.000136175820278300378990757324437766,
    0.000139347762608868258778216375759484,
    0.000142593588967656785060703072964827,
    0.000145915020334765516184585831815923,
    0.000149313817777069353896768344469592,
    0.000152791783381960505133409511380194,
    0.000156350761212839241233105158634942,
    0.000159992638286859695673919334879542,
    0.000163719345575453096046023016008064,
    0.000167532859028152316749685213359555,
    0.000171435200620267849495881318233614,
    0.000175428439424965370001946451949948,
    0.000179514692710315570695761566710758,
    0.000183696127061898990991128943761623,
    0.000187974959531556139007146821739980,
    0.000192353458812899842872781719371744,
    0.000196833946444205197664686912695231,
    0.000201418798039320121181713907354549,
    0.000206110444547248883003301433980425,
    0.000210911373541070864623750424904358,
    0.000215824130536886407173702284723049,
    0.000220851320343482470601875755633614,
    0.000225995608443437445353452197593924,
    0.000231259722406394649081920467104112,
    0.000236646453335256267075728531246170,
    0.000242158657346062369981887218983729,
    0.000247799257082342112498696273803489,
    0.000253571243264737362661104258521050,
    0.000259477676276724219042724151051971,
    0.000265521687787266113135037359782586,
    0.000271706482411267593365250538894884,
    0.000278035339408704256902032936338287,
    0.000284511614423327632850124757624144,
    0.000291138741261875262297809108247293,
    0.000297920233714716762782326320291304,
    0.000304859687418914261213681582418644,
    0.000311960781764676338238817532300118,
    0.000319227281846218454135905018276276,
    0.000326663040458068738760427640599460,
    0.000334272000137866051160812075337958,
    0.000342058195256749798286721730988802,
    0.000350025754158434117529336004892571,
    0.000358178901348111123747325335031633,
    0.000366521959732341853430148681525225,
    0.000375059352911114409542120418095124,
    0.000383795607523297816528889958576087,
    0.000392735355646725136508079501140855,
    0.000401883337254183362063919560114300,
    0.000411244402726608526167650925486896,
    0.000420823515424823013132693549920305,
    0.000430625754321173467506489451750440,
    0.000440656316692470686417065772744195,
    0.000450920520875653263893206856849361,
    0.000461423809087643755841301462794490,
    0.000472171750310878656897023430971672,
    0.000483170043246059887753068862181749,
    0.000494424519333682213617642275949038,
    0.000505941145845936550949628607298791,
    0.000517726029050642137102622442057509,
    0.000529785417448864494847915462827359,
    0.000542125705087957276279153617792872,
    0.000554753434951769756888761975233137,
    0.000567675302429822303297568542035378,
    0.000580898158867295235155414623307024,
    0.000594429015197695150007906050859674,
    0.000608275045660151684502603419701927,
    0.000622443591603289228531004084743472,
    0.000636942165377707989262767718230407,
    0.000651778454319138075487294337051480,
    0.000666960324824355968269251615510029,
    0.000682495826522059320998203624242251,
    0.000698393196540884864630116535266779,
    0.000714660863876841905874270910459245,
    0.000731307453862482586756654789894583,
    0.000748341792740159022188917159468247,
    0.000765772912341821624000737234183589,
    0.000783610054877810751489120022483803,
    0.000801862677837199646670163222239580,
    0.000820540459002286836319439711218138,
    0.000839653301579874021542959638964021,
    0.000859211339452084195758563289757603,
    0.000879224942549477550893244348628741,
    0.000899704722349328658154155036186239,
    0.000920661537501969067312512784440059,
    0.000942106499588190216161465162514332,
    0.000964050979010746753039562406684126,
    0.000986506611023098061927227853118438,
    0.001009485301898570448753122974494545,
    0.001032999235243229133041076295285166,
    0.001057060878455775209880385112626300,
    0.001081682989337932150261667452184611,
    0.001106878622858804405576504947816829,
    0.001132661138076784465567037329947198,
    0.001159044205222717859038450427533462,
    0.001186041812948024094104271242144932,
    0.001213668275741674714221507436207048,
    0.001241938241519922273697895676036751,
    0.001270866699392817367880725853979129,
    0.001300468987611642359900065990530038,
    0.001330760801701439885458277956331585,
    0.001361758202783002434654857637497116,
    0.001393477626088681286739556774989524,
    0.001425935889676566278513880625666843,
    0.001459150203347653589752708214177801,
    0.001493138177770692021084641964989714,
    0.001527917833819604888703769240976271,
    0.001563507612128390731817684233817545,
    0.001599926382868596848318976100244981,
    0.001637193455754529279946862807548769,
    0.001675328590281521595403702029614124,
    0.001714352006202676543394902708428162,
    0.001754284394249651856875771294141941,
    0.001795146927103153646973487944649150,
    0.001836961270618987958347378963708252,
    0.001879749595315561390071468217399797,
    0.001923534588128996422953798095534239,
    0.001968339464442049862452632780218664,
    0.002014187980393199097622902726811844,
    0.002061104445472486824258995241621051,
    0.002109113735410706423623050653759492,
    0.002158241305368861686492243379120737,
    0.002208513203434824597598540307785697,
    0.002259956084434372285130177004930374,
    0.002312597224063946653449530543866786,
    0.002366464533352560448142831717177614,
    0.002421586573460621314574092721727538,
    0.002477992570823418522901748772824249,
    0.002535712432647370916105611371449413,
    0.002594776762767239588342027545309065,
    0.002655216877872658420844942384064780,
    0.002717064824112676042072722637499282,
    0.002780353394087039641674463652520899,
    0.002845116144233276328501247576241440,
    0.002911387412618749587212008123060514,
    0.002979202337147164158376311249298851,
    0.003048596874189139684790950113324470,
    0.003119607817646760129781657866487876,
    0.003192272818462181614013184471900786,
    0.003266630404580684026577541700930851,
    0.003342720001378660186347469007728250,
    0.003420581952567494296579830859172944,
    0.003500257541584337814266625343861961,
    0.003581789013481107442765649651050808,
    0.003665219597323415064854534861638058,
    0.003750593529111139867032731487483943,
    0.003837956075232974370581295886495354,
    0.003927353556467251365080795011408554,
    0.004018833372541829283830505659125265,
    0.004112444027266085044836074757768074,
    0.004208235154248225577677811060084423,
    0.004306257543211729904575335581284889,
    0.004406563166924702852622619531075543,
    0.004509205208756528193703161377925426,
    0.004614238090876432787923455691725394,
    0.004721717503108781473220023627845876,
    0.004831700432460598985950905870367933,
    0.004944245193336817799367732817472643,
    0.005059411458459365726336720570088801,
    0.005177260290506416166855796490153807,
    0.005297854174488639093787423206549647,
    0.005421257050879567558621108247507436,
    0.005547534349517691497355453833506544,
    0.005676753024298217611964822992831614,
    0.005808981588672946713702849308447185,
    0.005944290151976951500079060508596740,
    0.006082750456601510556653433781093554,
    0.006224435916032886213777874928609890,
    0.006369421653777079458946808188102295,
    0.006517784543191380321192074376313030,
    0.006669603248243559899532950652201180,
    0.006824958265220592776301167248220736,
    0.006983931965408848863141599849768681,
    0.007146608638768418841902274607491563,
    0.007313074538624826301247416893147602,
    0.007483417927401590438729606091783353,
    0.007657729123418216890528675833138550,
    0.007836100548778106647529462236434483,
    0.008018626778371996249861197725294915,
    0.008205404590022868580034831609282264,
    0.008396533015798740215429596389640210,
    0.008592113394520841523904763903374260,
    0.008792249425494775075251574492085638,
    0.008997047223493285714179812373458844,
    0.009206615375019691974167734827005916,
    0.009421064995881902812135955116445984,
    0.009640509790107467530395624066841265,
    0.009865066110230981052953147525386157,
    0.010094853018985704487531229744945449,
    0.010329992352432291330410762952851655,
    0.010570608784557745593590816213236394,
    0.010816829893379327140467971446469164,
    0.011068786228588043188403311489764747,
    0.011326611380767849859840801229893259,
    0.011590442052227178590384504275334621,
    0.011860418129480240073680974433045776,
    0.012136682757416746708534205367868708,
    0.012419382415199216665446790841542679,
    0.012708666993928172811445520551387744,
    0.013004689876116417093787624992273777,
    0.013307608017014405793476683470544231,
    0.013617582027830024346548576374971162,
    0.013934776260886811566352960767289915,
    0.014259358896765663218819675250870205,
    0.014591502033476535030165344153374463,
    0.014931381777706920210846419649897143,
    0.015279178338196041514462919508332561,
    0.015635076121283914690751615239605599,
    0.015999263828685959809572381118414341,
    0.016371934557545299304681662988514290,
    0.016753285902815214652994413313535915,
    0.017143520062026768036034241049492266,
    0.017542843942496517267715105958814092,
    0.017951469271031538638139224417500373,
    0.018369612706189881318197265613889613,
    0.018797495953155603926054695307357179,
    0.019235345881289975938921443798790278,
    0.019683394644420499491888065790590190,
    0.020141879803932002251931621117364557,
    0.020611044454724867375228214427806961,
    0.021091137354107065970953982514402014,
    0.021582413053688617732284171779610915,
    0.022085132034348236435006285205417953,
    0.022599560844343721116578294072496647,
    0.023125972240639454391430973601018195,
    0.023664645333525614889769173032618710,
    0.024215865734606212278379189228871837,
    0.024779925708234187831102701693453128,
    0.025357124326473721304120445552143792,
    0.025947767627672410628569821255950956,
    0.026552168778726584208449423840647796,
    0.027170648241126759553365488386589277,
    0.027803533940870425039681990142526047,
    0.028451161442332763285012475762414397,
    0.029113874126187523627695696859518648,
    0.029792023371471659798359610249463003,
    0.030485968741891411593059046936105005,
    0.031196078176467599563093102688071667,
    0.031922728184621829150557914545061067,
    0.032666304045806837663690203044097871,
    0.033427200013786600996112952088878956,
    0.034205819525674974190820876174257137,
    0.035002575415843395489901013206690550,
    0.035817890134811111724211230011860607,
    0.036652195973234165393694894419240882,
    0.037505935291111416884923812631313922,
    0.038379560752329740236366006911339355,
    0.039273535564672515385531426090892637,
    0.040188333725418294573028532568059745,
    0.041124440272660857387254651484909118,
    0.042082351542482299144865010021021590,
    0.043062575432117319862435067534534028,
    0.044065631669247047608184431055633468,
    0.045092052087565302753713325500939391,
    0.046142380908764352165363220592553262,
    0.047217175031087819936370664208880044,
    0.048317004324605991594232534680486424,
    0.049442451933368228300658131502132164,
    0.050594114584593653793920253747273819,
    0.051772602905064211975538768228943809,
    0.052978541744886420428173323671217076,
    0.054212570508795701607063222127180779,
    0.055475343495176916708278014311872539,
    0.056767530242982200405776893603615463,
    0.058089815886729463667581541130857659,
    0.059442901519769511531343653132353211,
    0.060827504566015162812409045045569655,
    0.062244359160328895097524792845433694,
    0.063694216537770853570066265092464164,
    0.065177845431913836171666787322465098,
    0.066696032482435635424522502034960780,
    0.068249582652205931232458624435821548,
    0.069839319654088488631415998497686815,
    0.071466086387684188419022746074915631,
    0.073130745386248266481921120885090204,
    0.074834179274015977245682051943731494,
    0.076577291234182207069203229821141576,
    0.078361005487781118516998901668557664,
    0.080186267783720011070869304603547789,
    0.082054045900228730903158691489807097,
    0.083965330157987405623742915850016288,
    0.085921133945208422177941542940970976,
    0.087922494254947844427583447668439476,
    0.089970472234932860611245075688202633,
    0.092066153750196999538957243203185499,
    0.094210649958819073224169926561444299,
    0.096405097901074723876213568019011291,
    0.098650661102309800121190619393019006,
    0.100948530189857096917016576753667323,
    0.103299923524322947998577149064658443,
    0.105706087845577514916506345343805151,
    0.108168298933793302629702282047219342,
    0.110687862285880483925737394201860297,
    0.113266113807678536762324483788688667,
    0.115904420522271844884443225964787416,
    0.118604181294802463186854879495513160,
    0.121366827574167487902023765400372213,
    0.124193824151992232573959995534096379,
    0.127086669939281748931136917235562578,
    0.130046898761164236857368337041407358,
    0.133076080170144078751448546427127440,
    0.136175820278300302446083946961152833,
    0.139347762608868191991362550652411301,
    0.142593588967656698107688839627371635,
    0.145915020334765443976721144281327724,
    0.149313817777069257619615427756798454,
    0.152791783381960505350249945877294522,
    0.156350761212839195479773479746654630,
    0.159992638286859639729087234627513681,
    0.163719345575453006924604437699599657,
    0.167532859028152236735564883929328062,
    0.171435200620267708115918026123836171,
    0.175428439424965193493832771309826057,
    0.179514692710315421075861763711145613,
    0.183696127061898806243078752231667750,
    0.187974959531556101710592088238627184,
    0.192353458812899752450320534080674406,
    0.196833946444205071246713600885414053,
    0.201418798039320029458210115080873948,
    0.206110444547248777835690702886495274,
    0.210911373541070701342903248587390408,
    0.215824130536886177322841717796109151,
    0.220851320343482399044532371590321418,
    0.225995608443437218104676844632194843,
    0.231259722406394585547673159453552216,
    0.236646453335256162775479538140643854,
    0.242158657346062233806094354804372415,
    0.247799257082341933822178248192358296,
    0.253571243264737233857886167243123055,
    0.259477676276724023018971365672769025,
    0.265521687787265869840069854035391472,
    0.271706482411267546961397556515294127,
    0.278035339408704118557835727187921293,
    0.284511614423327563461185718551860191,
    0.291138741261875111376866698265075684,
    0.297920233714716597983596102494630031,
    0.304859687418913505307926925524952821,
    0.311960781764676009508718834695173427,
    0.319227281846218235994427914192783646,
    0.326663040458068931748414343019248918,
    0.334272000137865954449978289630962536,
    0.342058195256749075774393986648647115,
    0.350025754158433899387858900809078477,
    0.358178901348110978464234221974038519,
    0.366521959732342250681824680214049295,
    0.375059352911114085582511279426398687,
    0.383795607523296777863208717462839559,
    0.392735355646725070588587414022185840,
    0.401883337254182959608073133495054208,
    0.411244402726609115106271019612904638,
    0.420823515424822824915196406436734833,
    0.430625754321172449223809053364675492,
    0.440656316692470351181754040226223879,
    0.450920520875652985903769831566023640,
    0.461423809087644132276295749761629850,
    0.472171750310878157730343218645430170,
    0.483170043246059000008330031050718389,
    0.494424519333682088717552005618927069,
    0.505941145845936413039112267142627388,
    0.517726029050642799766990265197819099,
    0.529785417448864093259430774196516722,
    0.542125705087955989114334443002007902,
    0.554753434951769208716143566562095657,
    0.567675302429821782013164011004846543,
    0.580898158867295566487598534877179191,
    0.594429015197694976535558453178964555,
    0.608275045660150448512126786226872355,
    0.622443591603288881586308889382053167,
    0.636942165377708313656057725893333554,
    0.651778454319139388672965651494450867,
    0.666960324824356076689468864060472697,
    0.682495826522058202101561619201675057,
    0.698393196540884830803008753719041124,
    0.714660863876841911945803076378069818,
    0.731307453862483636264357755862874910,
    0.748341792740159439389913131890352815,
    0.765772912341820766179978363652480766,
    0.783610054877810879858657244767528027,
    0.801862677837199999686390583519823849,
    0.820540459002288335987884693167870864,
    0.839653301579874056237429158500162885,
    0.859211339452082611956029722932726145,
    0.879224942549478138964502704766346142,
    0.899704722349328411823421447479631752,
    0.920661537501971216634899519704049453,
    0.942106499588190593463821187469875440,
    0.964050979010745323627418201795080677,
    0.986506611023098112234208656445844099,
    1.009485301898570774881136458134278655,
    1.032999235243230895520127887721173465,
    1.057060878455774899364882912777829915,
    1.081682989337931166673456573334988207,
    1.106878622858804783746222710760775954,
    1.132661138076785256600942375371232629,
    1.159044205222720336223574122413992882,
    1.186041812948024354312792638665996492,
    1.213668275741672797352066481835208833,
    1.241938241519922048183843799051828682,
    1.270866699392817267266764247324317694,
    1.300468987611644200441674001922365278,
    1.330760801701440732003334233013447374,
    1.361758202783000637481336525524966419,
    1.393477626088681420313264425203669816,
    1.425935889676566814543434702500235289,
    1.459150203347656216124050843063741922,
    1.493138177770692021084641964989714324,
    1.527917833819602000389181739592459053,
    1.563507612128391732753129872435238212,
    1.599926382868596563824326040048617870,
    1.637193455754532900314757171145174652,
    1.675328590281522256333346376777626574,
    1.714352006202674250090467467089183629,
    1.754284394249651990449478944356087595,
    1.795146927103154155247466405853629112,
    1.836961270618991060032954010239336640,
    1.879749595315560961594769651128444821,
    1.923534588128994471389887621626257896,
    1.968339464442050656955984777596313506,
    2.014187980393200572137857307097874582,
    2.061104445472491164537132135592401028,
    2.109113735410707235473637410905212164,
    2.158241305368858053981284683686681092,
    2.208513203434824045956474947161041200,
    2.259956084434372236557919677579775453,
    2.312597224063949852279620245099067688,
    2.366464533352561794288249075179919600,
    2.421586573460618119213449972448870540,
    2.477992570823419171688328788150101900,
    2.535712432647371894489651822368614376,
    2.594776762767244449037207232322543859,
    2.655216877872658365333791152806952596,
    2.717064824112671139744179527042433619,
    2.780353394087041518645264659426175058,
    2.845116144233275523589554723002947867,
    2.911387412618755998749975333339534700,
    2.979202337147165646769053637399338186,
    3.048596874189135164101571717765182257,
    3.119607817646759873042583421920426190,
    3.192272818462182026877371754380874336,
    3.266630404580689095439538505161181092,
    3.342720001378659322455177971278317273,
    3.420581952567490535699334941455163062,
    3.500257541584339548990101320669054985,
    3.581789013481109673620039757224731147,
    3.665219597323422284773641877109184861,
    3.750593529111140966847415256779640913,
    3.837956075232968444765901949722319841,
    3.927353556467250594863571677706204355,
    4.018833372541829263013823947403579950,
    4.112444027266091595151920046191662550,
    4.208235154248227694040451751789078116,
    4.306257543211724936327300383709371090,
    4.406563166924703622839842864777892828,
    4.509205208756530858238420478301122785,
    4.614238090876440878673747647553682327,
    4.721717503108782132414944499032571912,
    4.831700432460590555194812623085454106,
    4.944245193336819887974797893548384309,
    5.059411458459363686301912821363657713,
    5.177260290506427331536087876884266734,
    5.297854174488642264861937292153015733,
    5.421257050879559002964924729894846678,
    5.547534349517691865116830740589648485,
    5.676753024298218264220849960111081600,
    5.808981588672954998742170573677867651,
    5.944290151976949765355584531789645553,
    6.082750456601504041032058012206107378,
    6.224435916032889259952298743883147836,
    6.369421653777084024738996959058567882,
    6.517784543191395663086495915194973350,
    6.669603248243562987340737890917807817,
    6.824958265220582909194035892141982913,
    6.983931965408848974163902312284335494,
    7.146608638768420895814870164031162858,
    7.313074538624837472866602183785289526,
    7.483417927401595726166760869091376662,
    7.657729123418208772022808261681348085,
    7.836100548778111019032621697988361120,
    8.018626778372000885042325535323470831,
    8.205404590022885358280291256960481405,
    8.396533015798741672597316210158169270,
    8.592113394520829672273976029828190804,
    8.792249425494782499868051672820001841,
    8.997047223493286338680263725109398365,
    9.206615375019714164750439522322267294,
    9.421064995881906156682816799730062485,
    9.640509790107454790586416493169963360,
    9.865066110230982232565111189614981413,
    10.094853018985709525168203981593251228,
    10.329992352432313396093377377837896347,
    10.570608784557752102273298078216612339,
    10.816829893379310334466936183162033558,
    11.068786228588049169729856657795608044,
    11.326611380767856118723102554213255644,
    11.590442052227201585878901823889464140,
    11.860418129480246207663185487035661936,
    12.136682757416727085342245118226855993,
    12.419382415199223146373697090893983841,
    12.708666993928172672667642473243176937,
    13.004689876116444224862789269536733627,
    13.307608017014411316836230980698019266,
    13.617582027830009039348624355625361204,
    13.934776260886819088113952602725476027,
    14.259358896765670365880396275315433741,
    14.591502033476565713954187231138348579,
    14.931381777706921099024839350022375584,
    15.279178338196025777051545446738600731,
    15.635076121283923100691026775166392326,
    15.999263828685968746867729350924491882,
    16.371934557545333888128880062140524387,
    16.753285902815225227868722868151962757,
    17.143520062026748718153612571768462658,
    17.542843942496517684048740193247795105,
    17.951469271031545105188342859037220478,
    18.369612706189919038024527253583073616,
    18.797495953155614500929004861973226070,
    19.235345881289944713898876216262578964,
    19.683394644420509678184316726401448250,
    20.141879803932013714984350372105836868,
    20.611044454724911645371321355924010277,
    21.091137354107075907450052909553050995,
    21.582413053688586757061784737743437290,
    22.085132034348244900456847972236573696,
    22.599560844343720589222357375547289848,
    23.125972240639502075509881251491606236,
    23.664645333525626824666687753051519394,
    24.215865734606186521205017925240099430,
    24.779925708234198822310645482502877712,
    25.357124326473719833074937923811376095,
    25.947767627672448043085751123726367950,
    26.552168778726585429694750928319990635,
    27.170648241126716726512313471175730228,
    27.803533940870426732772102695889770985,
    28.451161442332761453144485130906105042,
    29.113874126187567981105530634522438049,
    29.792023371471657355868956074118614197,
    30.485968741891365851870432379655539989,
    31.196078176467601394961093319579958916,
    31.922728184621831815093173645436763763,
    32.666304045806903388893260853365063667,
    33.427200013786602994514396414160728455,
    34.205819525674904468814929714426398277,
    35.002575415843395489901013206690549850,
    35.817890134811115387947211274877190590,
    36.652195973234228176806936971843242645,
    37.505935291111420326615188969299197197,
    38.379560752329680894945340696722269058,
    39.273535564672513942241494078189134598,
    40.188333725418296182851918274536728859,
    41.124440272660898187950806459411978722,
    42.082351542482278716761356918141245842,
    43.062575432117235152418288635089993477,
    44.065631669247025570257392246276140213,
    45.092052087565285489745292579755187035,
    46.142380908764401681310118874534964561,
    47.217175031087819547792605590075254440,
    48.317004324605889564736571628600358963,
    49.442451933368204208818497136235237122,
    50.594114584593626204878091812133789062,
    51.772602905064260880863002967089414597,
    52.978541744886392450553103117272257805,
    54.212570508795586476935568498447537422,
    55.475343495176915098454628605395555496,
    56.767530242982175536781142000108957291,
    58.089815886729553540135384537279605865,
    59.442901519769485219057969516143202782,
    60.827504566015043963034258922562003136,
    62.244359160328862401456717634573578835,
    63.694216537770827812892093788832426071,
    65.177845431913937090939725749194622040,
    66.696032482435597898984269704669713974,
    68.249582652205788235733052715659141541,
    69.839319654088455990859074518084526062,
    71.466086387684185865509789437055587769,
    73.130745386248335648815555032342672348,
    74.834179274015937721742375288158655167,
    76.577291234182041534950258210301399231,
    78.361005487781071110475750174373388290,
    80.186267783719969770572788547724485397,
    82.054045900228814502952445764094591141,
    83.965330157987395409691089298576116562,
    85.921133945208239879320899490267038345,
    87.922494254947807235112122725695371628,
    89.970472234932813648811134044080972672,
    92.066153750197102567653928417712450027,
    94.210649958819018934264022391289472580,
    96.405097901074526589582092128694057465,
    98.650661102309797456655360292643308640,
    100.948530189857052619117894209921360016,
    103.299923524323020274096052162349224091,
    105.706087845577513917305623181164264679,
    108.168298933793110450096719432622194290,
    110.687862285880427748452348168939352036,
    113.266113807678451053106982726603746414,
    115.904420522272019411502697039395570755,
    118.604181294802401680499315261840820312,
    121.366827574167217562717269174754619598,
    124.193824151992231463736970908939838409,
    127.086669939281733832103782333433628082,
    130.046898761164356983499601483345031738,
    133.076080170143967507101478986442089081,
    136.175820278300108157054637558758258820,
    139.347762608868123379579628817737102509,
    142.593588967656614840961992740631103516,
    145.915020334765642928687157109379768372,
    149.313817777069203884821035899221897125,
    152.791783381960186716241878457367420197,
    156.350761212839074687508400529623031616,
    159.992638286859687468677293509244918823,
    163.719345575453246510733151808381080627,
    167.532859028152159908131579868495464325,
    171.435200620267323756706900894641876221,
    175.428439424965176840487401932477951050,
    179.514692710315387103037210181355476379,
    183.696127061898977217424544505774974823,
    187.974959531556123693007975816726684570,
    192.353458812899447138988762162625789642,
    196.833946444204997305860160849988460541,
    201.418798039319909776168060488998889923,
    206.110444547249102242858498357236385345,
    210.911373541070645387662807479500770569,
    215.824130536885746778352768160402774811,
    220.851320343482456109995837323367595673,
    225.995608443437220103078288957476615906,
    231.259722406394899962833733297884464264,
    236.646453335256040872991434298455715179,
    242.158657346061886528332252055406570435,
    247.799257082341853219986660405993461609,
    253.571243264737091749339015223085880280,
    259.477676276724480430857511237263679504,
    265.521687787265875613229582086205482483,
    271.706482411267018051148625090718269348,
    278.035339408703976005199365317821502686,
    284.511614423327614531444851309061050415,
    291.138741261875566124217584729194641113,
    297.920233714716459871851839125156402588,
    304.859687418913324563618516549468040466,
    311.960781764676028160465648397803306580,
    319.227281846218147620675154030323028564,
    326.663040458068735460983589291572570801,
    334.272000137866029945143964141607284546,
    342.058195256749058899004012346267700195,
    350.025754158433755947044119238853454590,
    358.178901348110741764685371890664100647,
    366.521959732342224924650508910417556763,
    375.059352911113990103331161662936210632,
    383.795607523296666840906254947185516357,
    392.735355646725167844124371185898780823,
    401.883337254182947617664467543363571167,
    411.244402726608939246943918988108634949,
    420.823515424822574004792841151356697083,
    430.625754321172564687003614380955696106,
    440.656316692470227280864492058753967285,
    450.920520875652812264888780191540718079,
    461.423809087644258397631347179412841797,
    472.171750310878167056216625496745109558,
    483.170043246058924069075146690011024475,
    494.424519333681757871090667322278022766,
    505.941145845936546265875222161412239075,
    517.726029050642637230339460074901580811,
    529.785417448863995559804607182741165161,
    542.125705087955566341406665742397308350,
    554.753434951769236249674577265977859497,
    567.675302429821726946101989597082138062,
    580.898158867295251184259541332721710205,
    594.429015197695093775109853595495223999,
    608.275045660150453841197304427623748779,
    622.443591603288609803712461143732070923,
    636.942165377707965490117203444242477417,
    651.778454319139427752816118299961090088,
    666.960324824356007411552127450704574585,
    682.495826522057882357330527156591415405,
    698.393196540884900969103910028934478760,
    714.660863876841858655097894370555877686,
    731.307453862483384909864980727434158325,
    748.341792740159007735201157629489898682,
    765.772912341820870096853468567132949829,
    783.610054877810739526466932147741317749,
    801.862677837199726127437315881252288818,
    820.540459002288571355165913701057434082,
    839.653301579873982518620323389768600464,
    859.211339452082484058337286114692687988,
    879.224942549477532338642049580812454224,
    899.704722349328562813752796500921249390,
    920.661537501970997254829853773117065430,
    942.106499588190217764349654316902160645,
    964.050979010744754305051174014806747437,
    986.506611023098002988263033330440521240,
    1009.485301898570469347760081291198730469,
    1032.999235243230259584379382431507110596,
    1057.060878455775082329637371003627777100,
    1081.682989337931076079257763922214508057,
    1106.878622858804192219395190477371215820,
    1132.661138076784482109360396862030029297,
    1159.044205222720165693317539989948272705,
];

/// Histogram boundaries, i.e. the energies between each histogram bin.
pub static BOUNDARIES: [f64; 1001] = [
    0.000000117246530458229809506033624374,
    0.000000119977552987138238648411828896,
    0.000000122772189202731624903326321761,
    0.000000125631920858122061636786680888,
    0.000000128558264220886826936283519988,
    0.000000131552770877011031067698658241,
    0.000000134617028553560716729739434212,
    0.000000137752661960517353352702590169,
    0.000000140961333652216670733422522466,
    0.000000144244744908862782325077288997,
    0.000000147604636638564196303292203570,
    0.000000151042790300389716841967342395,
    0.000000154561028848920506343202294769,
    0.000000158161217700803431425457339608,
    0.000000161845265723823494498519442314,
    0.000000165615126249004708894148525135,
    0.000000169472798106298803404726671315,
    0.000000173420326684386890187428327537,
    0.000000177459805015172090141294157853,
    0.000000181593374883534915936164405234,
    0.000000185823227962932715523304626030,
    0.000000190151606977458016168312012611,
    0.000000194580806890957241808191662512,
    0.000000199113176123851113552792706229,
    0.000000203751117798300743068313578901,
    0.000000208497091012371475393584636937,
    0.000000213353612143881795486265780942,
    0.000000218323256184620589389597288335,
    0.000000223408658105637967887852264083,
    0.000000228612514254346571314601950856,
    0.000000233937583784156748120528672777,
    0.000000239386690117418762993172377113,
    0.000000244962722442440002244194805631,
    0.000000250668637245363620085907311805,
    0.000000256507459877747426642860496468,
    0.000000262482286160635496429990864975,
    0.000000268596284026009764309573385477,
    0.000000274852695196467265445694960410,
    0.000000281254836904022356487996064586,
    0.000000287806103648953531067602703078,
    0.000000294509968999601790133521230994,
    0.000000301369987434114507353539753193,
    0.000000308389796225068802222661580245,
    0.000000315573117368002507118800647676,
    0.000000322923759554869379600680872472,
    0.000000330445620193452257780944913632,
    0.000000338142687473827148913785604553,
    0.000000346019042482949006721547899681,
    0.000000354078861368498086197443945611,
    0.000000362326417553133334978489972153,
    0.000000370766084000311562360508886235,
    0.000000379402335532895289772796964742,
    0.000000388239751205763716200580499410,
    0.000000397283016733681254350146012586,
    0.000000406536926975734262223842463424,
    0.000000416006388477621342602413845313,
    0.000000425696422073173903671746429525,
    0.000000435612165546470545020432468472,
    0.000000445758876355945943865553750957,
    0.000000456141934421983378367517272811,
    0.000000466766844979402627259219924621,
    0.000000477639241496419574104382449464,
    0.000000488764888661581740820257901275,
    0.000000500149685440278313394420282162,
    0.000000511799668202461074510169463520,
    0.000000523721013923193334855979257092,
    0.000000535920043457775774396831952595,
    0.000000548403224893138918458093244296,
    0.000000561177176977315216766406969634,
    0.000000574248672628782941284881352617,
    0.000000587624642527558186699853434026,
    0.000000601312178789934444943449456944,
    0.000000615318538728811576783521691131,
    0.000000629651148701626307247164286707,
    0.000000644317608047901030325220646244,
    0.000000659325693118515693952590844829,
    0.000000674683361398827865049881730847,
    0.000000690398755727843683805734515541,
    0.000000706480208615654274840426219556,
    0.000000722936246661443874207881622740,
    0.000000739775595074407377291399179331,
    0.000000757007182299965516987874398352,
    0.000000774640144753755243551239517696,
    0.000000792683831665864724773720977752,
    0.000000811147810037937603971100550965,
    0.000000830041869715701484778254317515,
    0.000000849376028579691605162793523881,
    0.000000869160537856857336198445219272,
    0.000000889405887555890971795605898231,
    0.000000910122812029189002837597111811,
    0.000000931322295664322717248853871624,
    0.000000953015578708127478065297976534,
    0.000000975214163226413834821386383833,
    0.000000997929819202528193178465543145,
    0.000001021174590777946616126686980863,
    0.000001044960802638239172451784485263,
    0.000001069301066547783964530665516690,
    0.000001094208288036683129990588557445,
    0.000001119695673243458155005536532045,
    0.000001145776735917111260244934632657,
    0.000001172465304582298015650997438653,
    0.000001199775529871384927582960051862,
    0.000001227721892027316301972822421007,
    0.000001256319208581220828126103622457,
    0.000001285582642208865569445315826802,
    0.000001315527708770110363616545785803,
    0.000001346170285535609867214913715205,
    0.000001377526619605173533527025901690,
    0.000001409613336522166707334225224657,
    0.000001442447449088627823250772889974,
    0.000001476046366385642015972481239094,
    0.000001510427903003897274298791830738,
    0.000001545610288489205063432022947689,
    0.000001581612177008034367194132599477,
    0.000001618452657238231556853405405938,
    0.000001656151262490047036001926047954,
    0.000001694727981062991528058174137139,
    0.000001734203266843868901874283275366,
    0.000001774598050151720795533823171741,
    0.000001815933748835345453592499814777,
    0.000001858232279629326996414368650123,
    0.000001901516069774584185089619584041,
    0.000001945808068909572471021475828512,
    0.000001991131761238511135527927062294,
    0.000002037511177983003089639281110723,
    0.000002084970910123714753935846369370,
    0.000002133536121438822401785630894500,
    0.000002183232561846205788016854476563,
    0.000002234086581056379625938963437437,
    0.000002286125142543460948585691203117,
    0.000002339375837841567375326168320981,
    0.000002393866901174192923887644110503,
    0.000002449627224424399810683711242731,
    0.000002506686372453636306738191524834,
    0.000002565074598777474372307723371467,
    0.000002624822861606355387816382276900,
    0.000002685962840260097643095733854768,
    0.000002748526951964672760336068010889,
    0.000002812548369040223670759079052650,
    0.000002878061036489529699082751471040,
    0.000002945099689996018007214330716725,
    0.000003013699874341151214524265125605,
    0.000003083897962250687704589260582089,
    0.000003155731173680025177067124883545,
    0.000003229237595548687231501467503891,
    0.000003304456201934522260172093915953,
    0.000003381426874738278371280552486722,
    0.000003460190424829489961336360590027,
    0.000003540788613684981285490913083258,
    0.000003623264175531325832367492839614,
    0.000003707660840003115729484207269140,
    0.000003794023355328960626903613342908,
    0.000003882397512057636950247568180528,
    0.000003972830167336812649380578532643,
    0.000004065369269757334151908952091237,
    0.000004160063884776213426024138453130,
    0.000004256964220731747824684292058617,
    0.000004356121655464705979599916718659,
    0.000004457588763559459650413774323141,
    0.000004561419344219833783675172728111,
    0.000004667668449794026060833962432639,
    0.000004776392414964195741043824494643,
    0.000004887648886615816772927868572030,
    0.000005001496854402782922185966008044,
    0.000005117996682024610956859931448770,
    0.000005237210139231932925043318943770,
    0.000005359200434577758591001266780252,
    0.000005484032248931389396339169256533,
    0.000005611771769773151955905832882765,
    0.000005742486726287829412848813526171,
    0.000005876246425275582078756771153838,
    0.000006013121787899344449434494569440,
    0.000006153185387288115132560506470583,
    0.000006296511487016263495988116494217,
    0.000006443176080479009879735732835293,
    0.000006593256931185157786558855702586,
    0.000006746833613988278438740580494892,
    0.000006903987557278436626299108341831,
    0.000007064802086156542536646025381986,
    0.000007229362466614439165595289854549,
    0.000007397755950744073772913991793310,
    0.000007570071822999654958120507169950,
    0.000007746401447537552435512395176964,
    0.000007926838316658646612462499336793,
    0.000008111478100379375827952768696072,
    0.000008300418697157015059540779988723,
    0.000008493760285796916263386172052385,
    0.000008691605378568573997259162633444,
    0.000008894058875558909717956058982313,
    0.000009101228120291890663650681558838,
    0.000009313222956643226537213828275519,
    0.000009530155787081274145378269324613,
    0.000009752141632264138348213863838332,
    0.000009979298192025283625850549940051,
    0.000010211745907779465737750396181482,
    0.000010449608026382390453968423971176,
    0.000010693010665477838374757234285450,
    0.000010942082880366830029356464693002,
    0.000011196956732434581126538891693301,
    0.000011457767359171113025965819953722,
    0.000011724653045822981003542921640825,
    0.000011997755298713848852313126891467,
    0.000012277218920273161325662329701469,
    0.000012563192085812206587195141715974,
    0.000012855826422088656541486105522321,
    0.000013155277087701103212648984230881,
    0.000013461702855356098672149137152054,
    0.000013775266196051735758786732644054,
    0.000014096133365221666226309304992270,
    0.000014424474490886278656024202526886,
    0.000014760463663856420159724812390944,
    0.000015104279030038972742987918307378,
    0.000015456102884892051904869650358343,
    0.000015816121770080342824908378740467,
    0.000016184526572382315992050527686530,
    0.000016561512624900471207052207733845,
    0.000016947279810629916127614688625691,
    0.000017342032668438688171709885499361,
    0.000017745980501517207955338231717413,
    0.000018159337488353452841859103639166,
    0.000018582322796293271658209581009835,
    0.000019015160697745841003863248586114,
    0.000019458080689095723863181811030820,
    0.000019911317612385112202312217877243,
    0.000020375111779830031743425758361532,
    0.000020849709101237150080457305456605,
    0.000021335361214388225711922203453597,
    0.000021832325618462057880168544765631,
    0.000022340865810563797106422581628671,
    0.000022861251425434610332889859285466,
    0.000023393758378415673753261683209814,
    0.000023938669011741926697777599342132,
    0.000024496272244243998106837112427314,
    0.000025066863724536361373316020739743,
    0.000025650745987774743723077233714669,
    0.000026248228616063553031130875514698,
    0.000026859628402600976430957338547678,
    0.000027485269519646728450393627363191,
    0.000028125483690402234166491948763600,
    0.000028780610364895296143794567456098,
    0.000029450996899960179225110359912954,
    0.000030136998743411511298209704001749,
    0.000030838979622506877892925553075187,
    0.000031557311736800249229572407072553,
    0.000032292375955486870620948780530313,
    0.000033044562019345224295786833668132,
    0.000033814268747382785406871419375818,
    0.000034601904248294903848528342171775,
    0.000035407886136849812854909130832581,
    0.000036232641755313260017740822904742,
    0.000037076608400031155600776178182798,
    0.000037940233553289608810134975191986,
    0.000038823975120576371196541576313876,
    0.000039728301673368126493805785326430,
    0.000040653692697573344907221309929568,
    0.000041600638847762134260241384531298,
    0.000042569642207317474858711131568967,
    0.000043561216554647056407867378169385,
    0.000044575887635594596504137743231411,
    0.000045614193442198336142685832772514,
    0.000046676684497940267384603202360793,
    0.000047763924149641960798570033963628,
    0.000048876488866158171117410474737497,
    0.000050014968544027829221859660080440,
    0.000051179966820246114650796998013504,
    0.000052372101392319330944499083946297,
    0.000053592004345777580827814984276714,
    0.000054840322489313895657457587073935,
    0.000056117717697731524641256012353452,
    0.000057424867262878290740356346244511,
    0.000058762464252755817399435922521178,
    0.000060131217878993442800279051185797,
    0.000061531853872881151325605064705826,
    0.000062965114870162634959881164942175,
    0.000064431760804790105573620906387333,
    0.000065932569311851572783390873500053,
    0.000067468336139882786081471699457524,
    0.000069039875572784361180793399892508,
    0.000070648020861565423672394359311255,
    0.000072293624666144393350018793054090,
    0.000073977559507440744505403495967499,
    0.000075700718229996551275270966208097,
    0.000077464014475375531131387529804044,
    0.000079268383166586472900888571402334,
    0.000081114781003793751503264108926317,
    0.000083004186971570150595407799887226,
    0.000084937602857969155857598142489451,
    0.000086916053785685736584459837317240,
    0.000088940588755589093791428800805932,
    0.000091012281202918903248375026571182,
    0.000093132229566432272148401860789591,
    0.000095301557870812751618178060297737,
    0.000097521416322641376705875060348916,
    0.000099792981920252826094110132348902,
    0.000102117459077794670930031117883630,
    0.000104496080263824012959901488262204,
    0.000106930106654778387135704131871705,
    0.000109420828803668307069828224964425,
    0.000111969567324345811265388916933006,
    0.000114577673591711133647789988554422,
    0.000117246530458229677898289444737401,
    0.000119977552987138495299394846949070,
    0.000122772189202731738617499490651142,
    0.000125631920858122086200742151262943,
    0.000128558264220886704328264404928461,
    0.000131552770877011018573962686240009,
    0.000134617028553561007050282105623751,
    0.000137752661960517235615122921821296,
    0.000140961333652216662263093049922702,
    0.000144244744908862644258706886546406,
    0.000147604636638564204985379912926646,
    0.000151042790300389876507677899830639,
    0.000154561028848920512272432925549026,
    0.000158161217700803597655673238264740,
    0.000161845265723823159920505276865299,
    0.000165615126249004691741731343235244,
    0.000169472798106298978317030279328037,
    0.000173420326684386902045889589096817,
    0.000177459805015171910146792866314058,
    0.000181593374883534528418591036391661,
    0.000185823227962932899541212417027225,
    0.000190151606977458396486105329792338,
    0.000194580806890957258960608844411411,
    0.000199113176123851128799385756806828,
    0.000203751117798300337763048317718528,
    0.000208497091012371283964138557465162,
    0.000213353612143882243566694878467160,
    0.000218323256184620829523437834929211,
    0.000223408658105637964287962238252305,
    0.000228612514254346354050650980127557,
    0.000233937583784156764637671144235753,
    0.000239386690117419280530303149490123,
    0.000244962722442439737122882315034644,
    0.000250668637245363634061950941500641,
    0.000256507459877747159403965637736178,
    0.000262482286160635523535045177112579,
    0.000268596284026010028583852928818487,
    0.000274852695196467304832727007735116,
    0.000281254836904022633044253343115315,
    0.000287806103648952961437945674560979,
    0.000294509968999601785474840021095133,
    0.000301369987434114841931553918641384,
    0.000308389796225068792481782686820679,
    0.000315573117368002180587599481143002,
    0.000322923759554868733314542117440737,
    0.000330445620193452595323574394470256,
    0.000338142687473827854068714193758183,
    0.000346019042482948997827701953511337,
    0.000354078861368498087891509840119397,
    0.000362326417553132586624881072978610,
    0.000370766084000311176537001411901429,
    0.000379402335532896047443768283713439,
    0.000388239751205764118541230445202928,
    0.000397283016733681292043112165401908,
    0.000406536926975733842095500625291038,
    0.000416006388477621342602413845312981,
    0.000425696422073174789244692783896085,
    0.000435612165546470130397804787492078,
    0.000445758876355945965041377432314107,
    0.000456141934421982900640935021385758,
    0.000466766844979402660293504867539127,
    0.000477639241496420055219096489906860,
    0.000488764888661581751831686215581385,
    0.000500149685440278834319682843556620,
    0.000511799668202461092297861355859823,
    0.000523721013923193322997517995531780,
    0.000535920043457775306834645068221334,
    0.000548403224893138983679630182876963,
    0.000561177176977314690758946724713496,
    0.000574248672628782934508617774582717,
    0.000587624642527558851620717028652052,
    0.000601312178789934468660371980064383,
    0.000615318538728811567466159271333481,
    0.000629651148701626376703865961559359,
    0.000644317608047901028631154751735721,
    0.000659325693118514399686247440257603,
    0.000674683361398827128978250566859742,
    0.000690398755727843638912988311062691,
    0.000706480208615653504887477165397058,
    0.000722936246661443852185024994128071,
    0.000739775595074406659007459907684279,
    0.000757007182299965458542601037805753,
    0.000774640144753753630800507945508571,
    0.000792683831665864729008885714023336,
    0.000811147810037935942939490985281736,
    0.000830041869715700611487285698331107,
    0.000849376028579691558575981424894508,
    0.000869160537856856390062643136218412,
    0.000889405887555890992124396632334538,
    0.000910122812029188110911903653033050,
    0.000931322295664322721484018607895905,
    0.000953015578708125456197652880518945,
    0.000975214163226412818381849678672779,
    0.000997929819202526173851919288892987,
    0.001021174590777945570888030069056640,
    0.001044960802638239018291788084979999,
    0.001069301066547782841364977457487839,
    0.001094208288036682989383119313231418,
    0.001119695673243457055556770995963234,
    0.001145776735917111363582954197681829,
    0.001172465304582295721885776274007185,
    0.001199775529871383679056395799022994,
    0.001227721892027316139342496548181316,
    0.001256319208581219452544597281473671,
    0.001285582642208865688029928442404071,
    0.001315527708770108938907128504069988,
    0.001346170285535609962082603807687065,
    0.001377526619605170784058079114231532,
    0.001409613336522166785261256372052685,
    0.001442447449088624924704027385757854,
    0.001476046366385640531970757649560255,
    0.001510427903003897301403846142875409,
    0.001545610288489203442210961902958388,
    0.001581612177008034350253473654390746,
    0.001618452657238230027111902664671561,
    0.001656151262490047080047639305178109,
    0.001694727981062988048446826816473276,
    0.001734203266843867231525311289885849,
    0.001774598050151717258324235437783045,
    0.001815933748835343603672543011384732,
    0.001858232279629327098058322320639490,
    0.001901516069774582175927468696841061,
    0.001945808068909572535395979819838885,
    0.001991131761238509011169295348508967,
    0.002037511177983003431840591801460505,
    0.002084970910123710562816823355092311,
    0.002133536121438820050422169316561849,
    0.002183232561846206072619924754008025,
    0.002234086581056377203424734290138076,
    0.002286125142543460938421295836064928,
    0.002339375837841565098501606101422112,
    0.002393866901174192696882814246350790,
    0.002449627224424394660723391936585358,
    0.002506686372453636232199292166455962,
    0.002565074598777469100374659660701582,
    0.002624822861606352416424803308814262,
    0.002685962840260097683753315322974231,
    0.002748526951964670120981404366489187,
    0.002812548369040223511516884968841623,
    0.002878061036489526578613373786197371,
    0.002945099689996017854748400210951331,
    0.003013699874341144949868587232799655,
    0.003083897962250684889051743908794379,
    0.003155731173680018444849260106366273,
    0.003229237595548683972118686469343629,
    0.003304456201934522375368574742537930,
    0.003381426874738275179660407232518082,
    0.003460190424829490303537671280764698,
    0.003540788613684977409468146447579784,
    0.003623264175531325757828593481235657,
    0.003707660840003108079082627668299210,
    0.003794023355328956896570513634969757,
    0.003882397512057637282284483504213313,
    0.003972830167336808583622431712001344,
    0.004065369269757334626247402553644861,
    0.004160063884776209197635665759662515,
    0.004256964220731747350345841596208629,
    0.004356121655464696533488488938701266,
    0.004457588763559459758833991571691513,
    0.004561419344219824235919791277638069,
    0.004667668449794021290344403496419545,
    0.004776392414964195781701405962849094,
    0.004887648886615812530986868722493455,
    0.005001496854402783139026400505144920,
    0.005117996682024605718808185628176943,
    0.005237210139231933229975179955317799,
    0.005359200434577747647335588254691174,
    0.005484032248931383982104570407045685,
    0.005611771769773140836057301328310132,
    0.005742486726287823924075315318305002,
    0.005876246425275582010994135373493918,
    0.006013121787899338398231119384718113,
    0.006153185387288115024140289222032152,
    0.006296511487016257478666059199667870,
    0.006443176080479009852630678523155439,
    0.006593256931185144213702908899676913,
    0.006746833613988271506622940165698310,
    0.006903987557278436389129883110626906,
    0.007064802086156535265715206151071470,
    0.007229362466614438521850249941280708,
    0.007397755950744066590074599076842787,
    0.007570071822999654802266444875158413,
    0.007746401447537536524845513952186593,
    0.007926838316658647506929291637334245,
    0.008111478100379359429394909852817364,
    0.008300418697157006114872856983311067,
    0.008493760285796916886802421231550397,
    0.008691605378568563466945562367982347,
    0.008894058875558909921243966323345376,
    0.009101228120291880024916864044826070,
    0.009313222956643227648521055073160824,
    0.009530155787081254561976528805189446,
    0.009752141632264128834339800278030452,
    0.009979298192025263039561799871535186,
    0.010211745907779455275199431696364627,
    0.010449608026382390182917880849799985,
    0.010693010665477828413649774574878393,
    0.010942082880366825123341634196094674,
    0.011196956732434570555567709959632339,
    0.011457767359171106696935638069589913,
    0.011724653045822961555666452682089584,
    0.011997755298713837224244826984431711,
    0.012277218920273162694467572464418481,
    0.012563192085812194959126841808938480,
    0.012855826422088656446618415429838933,
    0.013155277087701089389071285040699877,
    0.013461702855356092248251265175440494,
    0.013775266196051716080517302032149018,
    0.014096133365221660480037790819096699,
    0.014424474490886256619615046759008692,
    0.014760463663856405319707576495602552,
    0.015104279030038973014038461428754090,
    0.015456102884892033988428750035382109,
    0.015816121770080342201492129561302136,
    0.016184526572382298970076419664110290,
    0.016561512624900461693178144173543842,
    0.016947279810629888724404779054566461,
    0.017342032668438672748933981893060263,
    0.017745980501517183425264079232874792,
    0.018159337488353435169363692125443777,
    0.018582322796293269245859747229587811,
    0.019015160697745822626636424956814153,
    0.019458080689095713644576335354940966,
    0.019911317612385091846416429461896769,
    0.020375111779830021307979848188551841,
    0.020849709101237116903870827400169219,
    0.021335361214388202238945169142425584,
    0.021832325618462058991475771563273156,
    0.022340865810563773768970818878187856,
    0.022861251425434610251574696349052829,
    0.023393758378415650117654323025817575,
    0.023938669011741915693125548614261788,
    0.024496272244243961352383465168713883,
    0.025066863724536349311566851838506409,
    0.025650745987774715289875260282315139,
    0.026248228616063538909397578891002922,
    0.026859628402600990715320961044199066,
    0.027485269519646700342452305676488322,
    0.028125483690402248992956657502872986,
    0.028780610364895264918771999873570167,
    0.029450996899960179414845740097916860,
    0.030136998743411483325793653875734890,
    0.030838979622506864503028722879207635,
    0.031557311736800215673515168646190432,
    0.032292375955486854466336410496296594,
    0.033044562019345240233558769205046701,
    0.033814268747382754398689286290391465,
    0.034601904248294901300653236830839887,
    0.035407886136849774094681464475797839,
    0.036232641755313259313009410789163667,
    0.037076608400031116352657534207537537,
    0.037940233553289584578216420140961418,
    0.038823975120576392772164808775414713,
    0.039728301673368104918182552864891477,
    0.040653692697573365344432261281326646,
    0.041600638847762091976356657596625155,
    0.042569642207317480442352319869314670,
    0.043561216554647008702971788807190023,
    0.044575887635594599323063391693722224,
    0.045614193442198289196731764150172239,
    0.046676684497940240659019650593108963,
    0.047763924149641985572589675257404451,
    0.048876488866158120105698259294513264,
    0.050014968544027857411116144703555619,
    0.051179966820246058922805332258576527,
    0.052372101392319334034475275529985083,
    0.053592004345777530249783637827931670,
    0.054840322489313864107174367745756172,
    0.056117717697731467341171196494542528,
    0.057424867262878265261605292835156433,
    0.058762464252755851334963921317466884,
    0.060131217878993385717034669823988224,
    0.061531853872881153710849844173935708,
    0.062965114870162569582490164066257421,
    0.064431760804790100261030261208361480,
    0.065932569311851513260691604045860004,
    0.067468336139882748025975445216317894,
    0.069039875572784403789938778572832234,
    0.070648020861565394290515484954084968,
    0.072293624666144432056036350786598632,
    0.073977559507440671104916418698849156,
    0.075700718229996549757387924728391226,
    0.077464014475375445045735034454992274,
    0.079268383166586478538739868326956639,
    0.081114781003793670621782041507685790,
    0.083004186971570109720985897183709312,
    0.084937602857969210501387635758874239,
    0.086916053785685648547243431494280230,
    0.088940588755589133906909182769595645,
    0.091012281202918807188062544355489081,
    0.093132229566432273015763598777994048,
    0.095301557870812653172620798613934312,
    0.097521416322641329976761426223674789,
    0.099792981920252724070685701462934958,
    0.102117459077794611732592500175087480,
    0.104496080263823967748670895616669441,
    0.106930106654778311892073361377697438,
    0.109420828803668310214014525172387948,
    0.111969567324345736780699667178851087,
    0.114577673591711129419401515860954532,
    0.117246530458229650251134046357037732,
    0.119977552987138427753599501102144131,
    0.122772189202731682455826955902011832,
    0.125631920858121998163525745439983439,
    0.128558264220886619977335385556216352,
    0.131552770877010921646288466035912279,
    0.134617028553561002279792546687531285,
    0.137752661960517192030195587904017884,
    0.140961333652216663780976091402408201,
    0.144244744908862604360066939079842996,
    0.147604636638564129524908707935537677,
    0.151042790300389806468217557267053053,
    0.154561028848920395395438731611648109,
    0.158161217700803519159435950314218644,
    0.161845265723822989700764196641102899,
    0.165615126249004651626250961271580309,
    0.169472798106298894182941694452892989,
    0.173420326684386810756066665817343164,
    0.177459805015171806497065176699834410,
    0.181593374883534441899257672048406675,
    0.185823227962932768786430415275390260,
    0.190151606977458226266364249568141531,
    0.194580806890957191956914584807236679,
    0.199113176123850932341952102433424443,
    0.203751117798300268590949713143345434,
    0.208497091012371155160920466187235434,
    0.213353612143882126472860250032681506,
    0.218323256184620645425908946890558582,
    0.223408658105637841773116747390304226,
    0.228612514254346171904686002562812064,
    0.233937583784156521993224941979860887,
    0.239386690117419198564618909585988149,
    0.244962722442439606584940747779910453,
    0.250668637245363534749031941828434356,
    0.256507459877747034937556236400268972,
    0.262482286160635402971763596724485978,
    0.268596284026009823886482763555250131,
    0.274852695196466989546735248950426467,
    0.281254836904022420540627535956446081,
    0.287806103648952649187719998735701665,
    0.294509968999601745576200073628569953,
    0.301369987434114194879697379292338155,
    0.308389796225068624213605517070391215,
    0.315573117368002031835061416131793521,
    0.322923759554869072019300801912322640,
    0.330445620193452305191073037349269725,
    0.338142687473826974997592742511187680,
    0.346019042482948901984229905792744830,
    0.354078861368497754824602452572435141,
    0.362326417553133106608242997026536614,
    0.370766084000311024748697263930807821,
    0.379402335532895207403925041944603436,
    0.388239751205763816699345625238493085,
    0.397283016733681049181825528648914769,
    0.406536926975734180800259309762623161,
    0.416006388477620892007990960337338038,
    0.425696422073173985634042537640198134,
    0.435612165546469976007415425556246191,
    0.445758876355945854452755838792654686,
    0.456141934421983474834405569708906114,
    0.466766844979402351079045274673262611,
    0.477639241496418898158538013376528397,
    0.488764888661581187179194785130675882,
    0.500149685440278490844434600148815662,
    0.511799668202461477406473022710997611,
    0.523721013923193146055723445897456259,
    0.535920043457774220030387368751689792,
    0.548403224893138641071743677457561716,
    0.561177176977314395855955808656290174,
    0.574248672628783540794472628476796672,
    0.587624642527558305182822095957817510,
    0.601312178789932816336261112155625597,
    0.615318538728811370575044747965876013,
    0.629651148701625751336052871920401230,
    0.644317608047901946299873543466674164,
    0.659325693118514855051159884169464931,
    0.674683361398826342281154211377725005,
    0.690398755727843815854782860697014257,
    0.706480208615653748616125540138455108,
    0.722936246661445180983207592362305149,
    0.739775595074406711049164186988491565,
    0.757007182299964109795098465838236734,
    0.774640144753754089634867341374047101,
    0.792683831665864535587218142609344795,
    0.811147810037937788685269424604484811,
    0.830041869715701041698707740579266101,
    0.849376028579690411923763804225018248,
    0.869160537856856429961283083684975281,
    0.889405887555891117024486902664648369,
    0.910122812029189542926133071887306869,
    0.931322295664322563624182294006459415,
    0.953015578708124588835914892115397379,
    0.975214163226413299767614262236747891,
    0.997929819202526879884374011453473940,
    1.021174590777947699393735092598944902,
    1.044960802638239316664225952990818769,
    1.069301066547781120519289288495201617,
    1.094208288036682796828813479805830866,
    1.119695673243457090251240515499375761,
    1.145776735917112931772976480715442449,
    1.172465304582296363733462385425809771,
    1.199775529871382362401277532626409084,
    1.227721892027316519246937787102069706,
    1.256319208581220037146408685657661408,
    1.285582642208868087152495718328282237,
    1.315527708770108938907128504069987684,
    1.346170285535607469284968829015269876,
    1.377526619605171642746199722751043737,
    1.409613336522166360254004757734946907,
    1.442447449088628097513264947338029742,
    1.476046366385641128715633385581895709,
    1.510427903003895178102311547263525426,
    1.545610288489203565376328697311691940,
    1.581612177008034469949393496790435165,
    1.618452657238232728076354760560207069,
    1.656151262490046738307114537747111171,
    1.694727981062986277294157844153232872,
    1.734203266843867830004910501884296536,
    1.774598050151718453548710385803133249,
    1.815933748835347305572440745891071856,
    1.858232279629327576842001690238248557,
    1.901516069774578987505719851469621062,
    1.945808068909572030591448310588020831,
    1.991131761238509323419521024334244430,
    2.037511177983005961067419775645248592,
    2.084970910123711718142658355645835400,
    2.133536121438817545481470006052404642,
    2.183232561846206731814845625194720924,
    2.234086581056378140175411317613907158,
    2.286125142543465216249387594871222973,
    2.339375837841564997887644494767300785,
    2.393866901174188210887905370327644050,
    2.449627224424396398916314865346066654,
    2.506686372453635680557226805831305683,
    2.565074598777474790267660864628851414,
    2.624822861606353363583821192150935531,
    2.685962840260093908995031597441993654,
    2.748526951964670228534259877051226795,
    2.812548369040224205406275359564460814,
    2.878061036489531154813903413014486432,
    2.945099689996017122695093348738737404,
    3.013699874341142059819276255439035594,
    3.083897962250685687024542858125641942,
    3.155731173680020429372916623833589256,
    3.229237595548690720193008019123226404,
    3.304456201934523384977637761039659381,
    3.381426874738270083042834812658838928,
    3.460190424829489241886903982958756387,
    3.540788613684977548246024525724351406,
    3.623264175531331066082429970265366137,
    3.707660840003109914420065251761116087,
    3.794023355328952185061552881961688399,
    3.882397512057638166993456252384930849,
    3.972830167336810713862860211520455778,
    4.065369269757341363913383247563615441,
    4.160063884776208809057607140857726336,
    4.256964220731740411451937688980251551,
    4.356121655464699315984944405499845743,
    4.457588763559458655549860850442200899,
    4.561419344219834748344055697089061141,
    4.667668449794024176924267521826550364,
    4.776392414964188759540775208733975887,
    4.887648886615812315881157701369374990,
    5.001496854402784464355136151425540447,
    5.117996682024613441797100676922127604,
    5.237210139231931904646444309037178755,
    5.359200434577742200303873687516897917,
    5.484032248931386632762041699606925249,
    5.611771769773143958559558086562901735,
    5.742486726287835629989331209799274802,
    5.876246425275583717962035734672099352,
    6.013121787899328829496425896650180221,
    6.153185387288114149839657329721376300,
    6.296511487016257291315923794172704220,
    6.443176080479020129132550209760665894,
    6.593256931185148772556203766725957394,
    6.746833613988265199168381514027714729,
    6.903987557278440156949272932251915336,
    7.064802086156539040473489876603707671,
    7.229362466614453808233520248904824257,
    7.397755950744068442759271420072764158,
    7.570071822999643096352428983664140105,
    7.746401447537542672705512813990935683,
    7.926838316658646910184415901312604547,
    8.111478100379379441164928721264004707,
    8.300418697157009972897867555730044842,
    8.493760285796904341282242967281490564,
    8.691605378568565853925065312068909407,
    8.894058875558913612735523201990872622,
    9.101228120291896317439750418998301029,
    9.313222956643226524420242640189826488,
    9.530155787081246998582173546310514212,
    9.752141632264132553586932772304862738,
    9.979298192025270353155974589753895998,
    10.211745907779476993937350925989449024,
    10.449608026382396275266728480346500874,
    10.693010665477812537460522435139864683,
    10.942082880366831076912603748496621847,
    11.196956732434570014333985454868525267,
    11.457767359171130649997394357342272997,
    11.724653045822968522315932204946875572,
    11.997755298713824956280404876451939344,
    12.277218920273169189272266521584242582,
    12.563192085812200815553296706639230251,
    12.855826422088682647881796583533287048,
    13.155277087701088944982075190637260675,
    13.461702855356078245563367090653628111,
    13.775266196051722644710935128387063742,
    14.096133365221666267075306677725166082,
    14.424474490886286304203167674131691456,
    14.760463663856413063513173256069421768,
    15.104279030038956221915213973261415958,
    15.456102884892034765584867272991687059,
    15.816121770080350472653663018718361855,
    16.184526572382331721655646106228232384,
    16.561512624900469603517194627784192562,
    16.947279810629861884763158741407096386,
    17.342032668438680076405944419093430042,
    17.745980501517191640914461459033191204,
    18.159337488353472167545987758785486221,
    18.582322796293279765222905552946031094,
    19.015160697745791651414037914946675301,
    19.458080689095723414538952056318521500,
    19.911317612385090569659951142966747284,
    20.375111779830064051566296257078647614,
    20.849709101237127839567619957961142063,
    21.335361214388179007528378861024975777,
    21.832325618462071759040554752573370934,
    22.340865810563784066289372276514768600,
    22.861251425434659267921233549714088440,
    23.393758378415650867054864647798240185,
    23.938669011741890102484831004403531551,
    24.496272244243971982768925954587757587,
    25.066863724536361246464366558939218521,
    25.650745987774755008103966247290372849,
    26.248228616063538964908730122260749340,
    26.859628402600950636269772076047956944,
    27.485269519646699620807339670136570930,
    28.125483690402248271311691496521234512,
    28.780610364895323982636909931898117065,
    29.450996899960180996913550188764929771,
    30.136998743411421486371182254515588284,
    30.838979622506862199315946782007813454,
    31.557311736800215840048622339963912964,
    32.292375955486903649216401390731334686,
    33.044562019345242731560574611648917198,
    33.814268747382698165893089026212692261,
    34.601904248294900412474817130714654922,
    35.407886136849775482460245257243514061,
    36.232641755313309772645880002528429031,
    37.076608400031119572304305620491504669,
    37.940233553289530732399725820869207382,
    38.823975120576392328075598925352096558,
    39.728301673368108026807021815329790115,
    40.653692697573404757349635474383831024,
    41.600638847762091643289750209078192711,
    42.569642207317393456378340488299727440,
    43.561216554646989607135765254497528076,
    44.575887635594575897357572102919220924,
    45.614193442198335048942681169137358665,
    46.676684497940215123890084214508533478,
    47.763924149641887595407752087339758873,
    48.876488866158119606097898213192820549,
    50.014968544027830432696646312251687050,
    51.179966820246136194327846169471740723,
    52.372101392319308388323406688868999481,
    53.592004345777418450325058074668049812,
    54.840322489313841458624665392562747002,
    56.117717697731436032881902065128087997,
    57.424867262878350970822793897241353989,
    58.762464252755819416051963344216346741,
    60.131217878993261649611667962744832039,
    61.531853872881121958471339894458651543,
    62.965114870162572913159237941727042198,
    64.431760804790158658761356491595506668,
    65.932569311851466409279964864253997803,
    67.468336139882609359119669534265995026,
    69.039875572784367818712780717760324478,
    70.648020861565356653954950161278247833,
    72.293624666144495449771056883037090302,
    73.977559507440659558596962597221136093,
    75.700718229996397212744341231882572174,
    77.464014475375407187129894737154245377,
    79.268383166586431798350531607866287231,
    81.114781003793751779085141606628894806,
    83.004186971570064201841887552291154861,
    84.937602857969025649254035670310258865,
    86.916053785685647881109616719186306000,
    88.940588755589089942077407613396644592,
    91.012281202918941858115431386977434158,
    93.132229566432215506210923194885253906,
    95.301557870812459327680699061602354050,
    97.521416322641286456018860917538404465,
    99.792981920252671557136636693030595779,
    102.117459077794762833946151658892631531,
    104.496080263823913014675781596451997757,
    106.930106654778057873045327141880989075,
    109.420828803668300110985001083463430405,
    111.969567324345703696053533349186182022,
    114.577673591711246103841403964906930923,
    117.246530458229557325466885231435298920,
    119.977552987138253115517727565020322800,
    122.772189202731624391162768006324768066,
    125.631920858121944206686748657375574112,
    128.558264220886826478817965835332870483,
    131.552770877010885897107073105871677399,
    134.617028553560714954073773697018623352,
    137.752661960517087891275878064334392548,
    140.961333652216666223466745577752590179,
    144.244744908862799093185458332300186157,
    147.604636638564045370003441348671913147,
    151.042790300389413005177630111575126648,
    154.561028848920358313989709131419658661,
    158.161217700803433672263054177165031433,
    161.845265723823160897154593840241432190,
    165.615126249004703140599303878843784332,
    169.472798106298625953058945015072822571,
    173.420326684386708393503795377910137177,
    177.459805015171724562605959363281726837,
    181.593374883534721675459877587854862213,
    185.823227962932719492528121918439865112,
    190.151606977457817038157372735440731049,
    194.580806890957234145389520563185214996,
    199.113176123850934118308941833674907684,
    203.751117798300526828825240954756736755,
    208.497091012371072338282829150557518005,
    213.353612143881804286138503812253475189,
    218.323256184620589692713110707700252533,
    223.408658105637726976056001149117946625,
    228.612514254346592679212335497140884399,
    233.937583784156515775976004078984260559,
    239.386690117418794443437946029007434845,
    244.962722442439485348586458712816238403,
    250.668637245363612464643665589392185211,
    256.507459877747407972492510452866554260,
    262.482286160635226224258076399564743042,
    268.596284026009243461885489523410797119,
    274.852695196466981997218681499361991882,
    281.254836904022340604569762945175170898,
    287.806103648952955609274795278906822205,
    294.509968999601767336571356281638145447,
    301.369987434114193547429749742150306702,
    308.389796225068494095467031002044677734,
    315.573117368001874183391919359564781189,
    322.923759554869093335582874715328216553,
    330.445620193452214152785018086433410645,
    338.142687473826811128674307838082313538,
    346.019042482949032546457601711153984070,
    354.078861368497769035457167774438858032,
    362.326417553132955617911648005247116089,
    370.766084000310797819111030548810958862,
    379.402335532895278902287827804684638977,
    388.239751205763695907080546021461486816,
    397.283016733680881316104205325245857239,
    406.536926975734274947171797975897789001,
    416.006388477620930643752217292785644531,
    425.696422073173891931219259276986122131,
    435.612165546469668697682209312915802002,
    445.758876355945972136396449059247970581,
    456.141934421983364700281526893377304077,
    466.766844979402151238900842145085334778,
    477.639241496418605947837932035326957703,
    488.764888661581210271833697333931922913,
    500.149685440278346959530608728528022766,
    511.799668202461134569603018462657928467,
    523.721013923193368100328370928764343262,
    535.920043457774227135814726352691650391,
    548.403224893138371953682508319616317749,
    561.177176977314047690015286207199096680,
    574.248672628783538129937369376420974731,
    587.624642527558194160519633442163467407,
    601.312178789932659128680825233459472656,
    615.318538728811518012662418186664581299,
    629.651148701625743342447094619274139404,
    644.317608047901671852741856127977371216,
    659.325693118514436719124205410480499268,
    674.683361398826491495128720998764038086,
    690.398755727843649765418376773595809937,
    706.480208615653509696130640804767608643,
    722.936246661445352401642594486474990845,
    739.775595074406624007679056376218795776,
    757.007182299963915284024551510810852051,
    774.640144753753702389076352119445800781,
    792.683831665864772730856202542781829834,
    811.147810037937574634270276874303817749,
    830.041869715700613596709445118904113770,
    849.376028579689887010317761451005935669,
    869.160537856856421967677306383848190308,
    889.405887555890899420774076133966445923,
    910.122812029189049098931718617677688599,
    931.322295664322723496297840029001235962,
    953.015578708124508011678699404001235962,
    975.214163226412779295060317963361740112,
    997.929819202526232402306050062179565430,
    1021.174590777947742026299238204956054688,
    1044.960802638239101725048385560512542725,
    1069.301066547780692417290993034839630127,
    1094.208288036683143218397162854671478271,
    1119.695673243457122225663624703884124756,
    1145.776735917112546303542330861091613770,
    1172.465304582295630098087713122367858887,
];
