// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct UpdateParallelDataInput {
    /// <p>The name of the parallel data resource being updated.</p>
    pub name: ::std::option::Option<::std::string::String>,
    /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
    pub description: ::std::option::Option<::std::string::String>,
    /// <p>Specifies the format and S3 location of the parallel data input file.</p>
    pub parallel_data_config: ::std::option::Option<crate::types::ParallelDataConfig>,
    /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
    pub client_token: ::std::option::Option<::std::string::String>,
}
impl UpdateParallelDataInput {
    /// <p>The name of the parallel data resource being updated.</p>
    pub fn name(&self) -> ::std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
    pub fn description(&self) -> ::std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the format and S3 location of the parallel data input file.</p>
    pub fn parallel_data_config(&self) -> ::std::option::Option<&crate::types::ParallelDataConfig> {
        self.parallel_data_config.as_ref()
    }
    /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
    pub fn client_token(&self) -> ::std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl UpdateParallelDataInput {
    /// Creates a new builder-style object to manufacture [`UpdateParallelDataInput`](crate::operation::update_parallel_data::UpdateParallelDataInput).
    pub fn builder() -> crate::operation::update_parallel_data::builders::UpdateParallelDataInputBuilder {
        crate::operation::update_parallel_data::builders::UpdateParallelDataInputBuilder::default()
    }
}

/// A builder for [`UpdateParallelDataInput`](crate::operation::update_parallel_data::UpdateParallelDataInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct UpdateParallelDataInputBuilder {
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) description: ::std::option::Option<::std::string::String>,
    pub(crate) parallel_data_config: ::std::option::Option<crate::types::ParallelDataConfig>,
    pub(crate) client_token: ::std::option::Option<::std::string::String>,
}
impl UpdateParallelDataInputBuilder {
    /// <p>The name of the parallel data resource being updated.</p>
    /// This field is required.
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the parallel data resource being updated.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the parallel data resource being updated.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
    pub fn description(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.description = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
    pub fn set_description(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.description = input;
        self
    }
    /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
    pub fn get_description(&self) -> &::std::option::Option<::std::string::String> {
        &self.description
    }
    /// <p>Specifies the format and S3 location of the parallel data input file.</p>
    /// This field is required.
    pub fn parallel_data_config(mut self, input: crate::types::ParallelDataConfig) -> Self {
        self.parallel_data_config = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the format and S3 location of the parallel data input file.</p>
    pub fn set_parallel_data_config(mut self, input: ::std::option::Option<crate::types::ParallelDataConfig>) -> Self {
        self.parallel_data_config = input;
        self
    }
    /// <p>Specifies the format and S3 location of the parallel data input file.</p>
    pub fn get_parallel_data_config(&self) -> &::std::option::Option<crate::types::ParallelDataConfig> {
        &self.parallel_data_config
    }
    /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
    /// This field is required.
    pub fn client_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.client_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
    pub fn set_client_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.client_token = input;
        self
    }
    /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
    pub fn get_client_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.client_token
    }
    /// Consumes the builder and constructs a [`UpdateParallelDataInput`](crate::operation::update_parallel_data::UpdateParallelDataInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::update_parallel_data::UpdateParallelDataInput, ::aws_smithy_types::error::operation::BuildError>
    {
        ::std::result::Result::Ok(crate::operation::update_parallel_data::UpdateParallelDataInput {
            name: self.name,
            description: self.description,
            parallel_data_config: self.parallel_data_config,
            client_token: self.client_token,
        })
    }
}
