// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The <code>Transcript</code> associated with a <code></code>.</p>
/// <p><code>Transcript</code> contains <code>Results</code>, which contains a set of transcription results from one or more audio segments, along with additional information per your request parameters.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Transcript {
    /// <p>Contains a set of transcription results from one or more audio segments, along with additional information per your request parameters. This can include information relating to alternative transcriptions, channel identification, partial result stabilization, language identification, and other transcription-related data.</p>
    pub results: ::std::option::Option<::std::vec::Vec<crate::types::Result>>,
}
impl Transcript {
    /// <p>Contains a set of transcription results from one or more audio segments, along with additional information per your request parameters. This can include information relating to alternative transcriptions, channel identification, partial result stabilization, language identification, and other transcription-related data.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.results.is_none()`.
    pub fn results(&self) -> &[crate::types::Result] {
        self.results.as_deref().unwrap_or_default()
    }
}
impl Transcript {
    /// Creates a new builder-style object to manufacture [`Transcript`](crate::types::Transcript).
    pub fn builder() -> crate::types::builders::TranscriptBuilder {
        crate::types::builders::TranscriptBuilder::default()
    }
}

/// A builder for [`Transcript`](crate::types::Transcript).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct TranscriptBuilder {
    pub(crate) results: ::std::option::Option<::std::vec::Vec<crate::types::Result>>,
}
impl TranscriptBuilder {
    /// Appends an item to `results`.
    ///
    /// To override the contents of this collection use [`set_results`](Self::set_results).
    ///
    /// <p>Contains a set of transcription results from one or more audio segments, along with additional information per your request parameters. This can include information relating to alternative transcriptions, channel identification, partial result stabilization, language identification, and other transcription-related data.</p>
    pub fn results(mut self, input: crate::types::Result) -> Self {
        let mut v = self.results.unwrap_or_default();
        v.push(input);
        self.results = ::std::option::Option::Some(v);
        self
    }
    /// <p>Contains a set of transcription results from one or more audio segments, along with additional information per your request parameters. This can include information relating to alternative transcriptions, channel identification, partial result stabilization, language identification, and other transcription-related data.</p>
    pub fn set_results(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Result>>) -> Self {
        self.results = input;
        self
    }
    /// <p>Contains a set of transcription results from one or more audio segments, along with additional information per your request parameters. This can include information relating to alternative transcriptions, channel identification, partial result stabilization, language identification, and other transcription-related data.</p>
    pub fn get_results(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Result>> {
        &self.results
    }
    /// Consumes the builder and constructs a [`Transcript`](crate::types::Transcript).
    pub fn build(self) -> crate::types::Transcript {
        crate::types::Transcript { results: self.results }
    }
}
