// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains the timestamp range (start time through end time) of a matched category.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct TimestampRange {
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the category match.</p>
    pub begin_offset_millis: ::std::option::Option<i64>,
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the end of the category match.</p>
    pub end_offset_millis: ::std::option::Option<i64>,
}
impl TimestampRange {
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the category match.</p>
    pub fn begin_offset_millis(&self) -> ::std::option::Option<i64> {
        self.begin_offset_millis
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the end of the category match.</p>
    pub fn end_offset_millis(&self) -> ::std::option::Option<i64> {
        self.end_offset_millis
    }
}
impl TimestampRange {
    /// Creates a new builder-style object to manufacture [`TimestampRange`](crate::types::TimestampRange).
    pub fn builder() -> crate::types::builders::TimestampRangeBuilder {
        crate::types::builders::TimestampRangeBuilder::default()
    }
}

/// A builder for [`TimestampRange`](crate::types::TimestampRange).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct TimestampRangeBuilder {
    pub(crate) begin_offset_millis: ::std::option::Option<i64>,
    pub(crate) end_offset_millis: ::std::option::Option<i64>,
}
impl TimestampRangeBuilder {
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the category match.</p>
    pub fn begin_offset_millis(mut self, input: i64) -> Self {
        self.begin_offset_millis = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the category match.</p>
    pub fn set_begin_offset_millis(mut self, input: ::std::option::Option<i64>) -> Self {
        self.begin_offset_millis = input;
        self
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the category match.</p>
    pub fn get_begin_offset_millis(&self) -> &::std::option::Option<i64> {
        &self.begin_offset_millis
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the end of the category match.</p>
    pub fn end_offset_millis(mut self, input: i64) -> Self {
        self.end_offset_millis = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the end of the category match.</p>
    pub fn set_end_offset_millis(mut self, input: ::std::option::Option<i64>) -> Self {
        self.end_offset_millis = input;
        self
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the end of the category match.</p>
    pub fn get_end_offset_millis(&self) -> &::std::option::Option<i64> {
        &self.end_offset_millis
    }
    /// Consumes the builder and constructs a [`TimestampRange`](crate::types::TimestampRange).
    pub fn build(self) -> crate::types::TimestampRange {
        crate::types::TimestampRange {
            begin_offset_millis: self.begin_offset_millis,
            end_offset_millis: self.end_offset_millis,
        }
    }
}
