// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A wrapper for your audio chunks</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/event-stream.html">Event stream encoding</a>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MedicalScribeAudioEvent {
    /// <p>An audio blob containing the next segment of audio from your application, with a maximum duration of 1 second. The maximum size in bytes varies based on audio properties.</p>
    /// <p>Find recommended size in <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing streaming best practices</a>.</p>
    /// <p>Size calculation: <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code></p>
    /// <p>For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.</p>
    /// <p>For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.</p>
    pub audio_chunk: ::aws_smithy_types::Blob,
}
impl MedicalScribeAudioEvent {
    /// <p>An audio blob containing the next segment of audio from your application, with a maximum duration of 1 second. The maximum size in bytes varies based on audio properties.</p>
    /// <p>Find recommended size in <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing streaming best practices</a>.</p>
    /// <p>Size calculation: <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code></p>
    /// <p>For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.</p>
    /// <p>For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.</p>
    pub fn audio_chunk(&self) -> &::aws_smithy_types::Blob {
        &self.audio_chunk
    }
}
impl MedicalScribeAudioEvent {
    /// Creates a new builder-style object to manufacture [`MedicalScribeAudioEvent`](crate::types::MedicalScribeAudioEvent).
    pub fn builder() -> crate::types::builders::MedicalScribeAudioEventBuilder {
        crate::types::builders::MedicalScribeAudioEventBuilder::default()
    }
}

/// A builder for [`MedicalScribeAudioEvent`](crate::types::MedicalScribeAudioEvent).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MedicalScribeAudioEventBuilder {
    pub(crate) audio_chunk: ::std::option::Option<::aws_smithy_types::Blob>,
}
impl MedicalScribeAudioEventBuilder {
    /// <p>An audio blob containing the next segment of audio from your application, with a maximum duration of 1 second. The maximum size in bytes varies based on audio properties.</p>
    /// <p>Find recommended size in <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing streaming best practices</a>.</p>
    /// <p>Size calculation: <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code></p>
    /// <p>For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.</p>
    /// <p>For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.</p>
    /// This field is required.
    pub fn audio_chunk(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.audio_chunk = ::std::option::Option::Some(input);
        self
    }
    /// <p>An audio blob containing the next segment of audio from your application, with a maximum duration of 1 second. The maximum size in bytes varies based on audio properties.</p>
    /// <p>Find recommended size in <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing streaming best practices</a>.</p>
    /// <p>Size calculation: <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code></p>
    /// <p>For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.</p>
    /// <p>For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.</p>
    pub fn set_audio_chunk(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.audio_chunk = input;
        self
    }
    /// <p>An audio blob containing the next segment of audio from your application, with a maximum duration of 1 second. The maximum size in bytes varies based on audio properties.</p>
    /// <p>Find recommended size in <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing streaming best practices</a>.</p>
    /// <p>Size calculation: <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code></p>
    /// <p>For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.</p>
    /// <p>For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.</p>
    pub fn get_audio_chunk(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.audio_chunk
    }
    /// Consumes the builder and constructs a [`MedicalScribeAudioEvent`](crate::types::MedicalScribeAudioEvent).
    /// This method will fail if any of the following fields are not set:
    /// - [`audio_chunk`](crate::types::builders::MedicalScribeAudioEventBuilder::audio_chunk)
    pub fn build(self) -> ::std::result::Result<crate::types::MedicalScribeAudioEvent, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::MedicalScribeAudioEvent {
            audio_chunk: self.audio_chunk.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "audio_chunk",
                    "audio_chunk was not specified but it is required when building MedicalScribeAudioEvent",
                )
            })?,
        })
    }
}
