// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A word, phrase, or punctuation mark in your transcription output, along with various associated attributes, such as confidence score, type, and start and end times.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Item {
    /// <p>The start time, in milliseconds, of the transcribed item.</p>
    pub start_time: f64,
    /// <p>The end time, in milliseconds, of the transcribed item.</p>
    pub end_time: f64,
    /// <p>The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.</p>
    pub r#type: ::std::option::Option<crate::types::ItemType>,
    /// <p>The word or punctuation that was transcribed.</p>
    pub content: ::std::option::Option<::std::string::String>,
    /// <p>Indicates whether the specified item matches a word in the vocabulary filter included in your request. If <code>true</code>, there is a vocabulary filter match.</p>
    pub vocabulary_filter_match: bool,
    /// <p>If speaker partitioning is enabled, <code>Speaker</code> labels the speaker of the specified item.</p>
    pub speaker: ::std::option::Option<::std::string::String>,
    /// <p>The confidence score associated with a word or phrase in your transcript.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.</p>
    pub confidence: ::std::option::Option<f64>,
    /// <p>If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item is stable (<code>true</code>) or if it may change when the segment is complete (<code>false</code>).</p>
    pub stable: ::std::option::Option<bool>,
}
impl Item {
    /// <p>The start time, in milliseconds, of the transcribed item.</p>
    pub fn start_time(&self) -> f64 {
        self.start_time
    }
    /// <p>The end time, in milliseconds, of the transcribed item.</p>
    pub fn end_time(&self) -> f64 {
        self.end_time
    }
    /// <p>The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.</p>
    pub fn r#type(&self) -> ::std::option::Option<&crate::types::ItemType> {
        self.r#type.as_ref()
    }
    /// <p>The word or punctuation that was transcribed.</p>
    pub fn content(&self) -> ::std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>Indicates whether the specified item matches a word in the vocabulary filter included in your request. If <code>true</code>, there is a vocabulary filter match.</p>
    pub fn vocabulary_filter_match(&self) -> bool {
        self.vocabulary_filter_match
    }
    /// <p>If speaker partitioning is enabled, <code>Speaker</code> labels the speaker of the specified item.</p>
    pub fn speaker(&self) -> ::std::option::Option<&str> {
        self.speaker.as_deref()
    }
    /// <p>The confidence score associated with a word or phrase in your transcript.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.</p>
    pub fn confidence(&self) -> ::std::option::Option<f64> {
        self.confidence
    }
    /// <p>If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item is stable (<code>true</code>) or if it may change when the segment is complete (<code>false</code>).</p>
    pub fn stable(&self) -> ::std::option::Option<bool> {
        self.stable
    }
}
impl Item {
    /// Creates a new builder-style object to manufacture [`Item`](crate::types::Item).
    pub fn builder() -> crate::types::builders::ItemBuilder {
        crate::types::builders::ItemBuilder::default()
    }
}

/// A builder for [`Item`](crate::types::Item).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ItemBuilder {
    pub(crate) start_time: ::std::option::Option<f64>,
    pub(crate) end_time: ::std::option::Option<f64>,
    pub(crate) r#type: ::std::option::Option<crate::types::ItemType>,
    pub(crate) content: ::std::option::Option<::std::string::String>,
    pub(crate) vocabulary_filter_match: ::std::option::Option<bool>,
    pub(crate) speaker: ::std::option::Option<::std::string::String>,
    pub(crate) confidence: ::std::option::Option<f64>,
    pub(crate) stable: ::std::option::Option<bool>,
}
impl ItemBuilder {
    /// <p>The start time, in milliseconds, of the transcribed item.</p>
    pub fn start_time(mut self, input: f64) -> Self {
        self.start_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The start time, in milliseconds, of the transcribed item.</p>
    pub fn set_start_time(mut self, input: ::std::option::Option<f64>) -> Self {
        self.start_time = input;
        self
    }
    /// <p>The start time, in milliseconds, of the transcribed item.</p>
    pub fn get_start_time(&self) -> &::std::option::Option<f64> {
        &self.start_time
    }
    /// <p>The end time, in milliseconds, of the transcribed item.</p>
    pub fn end_time(mut self, input: f64) -> Self {
        self.end_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The end time, in milliseconds, of the transcribed item.</p>
    pub fn set_end_time(mut self, input: ::std::option::Option<f64>) -> Self {
        self.end_time = input;
        self
    }
    /// <p>The end time, in milliseconds, of the transcribed item.</p>
    pub fn get_end_time(&self) -> &::std::option::Option<f64> {
        &self.end_time
    }
    /// <p>The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.</p>
    pub fn r#type(mut self, input: crate::types::ItemType) -> Self {
        self.r#type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.</p>
    pub fn set_type(mut self, input: ::std::option::Option<crate::types::ItemType>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.</p>
    pub fn get_type(&self) -> &::std::option::Option<crate::types::ItemType> {
        &self.r#type
    }
    /// <p>The word or punctuation that was transcribed.</p>
    pub fn content(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The word or punctuation that was transcribed.</p>
    pub fn set_content(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content = input;
        self
    }
    /// <p>The word or punctuation that was transcribed.</p>
    pub fn get_content(&self) -> &::std::option::Option<::std::string::String> {
        &self.content
    }
    /// <p>Indicates whether the specified item matches a word in the vocabulary filter included in your request. If <code>true</code>, there is a vocabulary filter match.</p>
    pub fn vocabulary_filter_match(mut self, input: bool) -> Self {
        self.vocabulary_filter_match = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the specified item matches a word in the vocabulary filter included in your request. If <code>true</code>, there is a vocabulary filter match.</p>
    pub fn set_vocabulary_filter_match(mut self, input: ::std::option::Option<bool>) -> Self {
        self.vocabulary_filter_match = input;
        self
    }
    /// <p>Indicates whether the specified item matches a word in the vocabulary filter included in your request. If <code>true</code>, there is a vocabulary filter match.</p>
    pub fn get_vocabulary_filter_match(&self) -> &::std::option::Option<bool> {
        &self.vocabulary_filter_match
    }
    /// <p>If speaker partitioning is enabled, <code>Speaker</code> labels the speaker of the specified item.</p>
    pub fn speaker(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.speaker = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>If speaker partitioning is enabled, <code>Speaker</code> labels the speaker of the specified item.</p>
    pub fn set_speaker(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.speaker = input;
        self
    }
    /// <p>If speaker partitioning is enabled, <code>Speaker</code> labels the speaker of the specified item.</p>
    pub fn get_speaker(&self) -> &::std::option::Option<::std::string::String> {
        &self.speaker
    }
    /// <p>The confidence score associated with a word or phrase in your transcript.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.</p>
    pub fn confidence(mut self, input: f64) -> Self {
        self.confidence = ::std::option::Option::Some(input);
        self
    }
    /// <p>The confidence score associated with a word or phrase in your transcript.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.</p>
    pub fn set_confidence(mut self, input: ::std::option::Option<f64>) -> Self {
        self.confidence = input;
        self
    }
    /// <p>The confidence score associated with a word or phrase in your transcript.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.</p>
    pub fn get_confidence(&self) -> &::std::option::Option<f64> {
        &self.confidence
    }
    /// <p>If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item is stable (<code>true</code>) or if it may change when the segment is complete (<code>false</code>).</p>
    pub fn stable(mut self, input: bool) -> Self {
        self.stable = ::std::option::Option::Some(input);
        self
    }
    /// <p>If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item is stable (<code>true</code>) or if it may change when the segment is complete (<code>false</code>).</p>
    pub fn set_stable(mut self, input: ::std::option::Option<bool>) -> Self {
        self.stable = input;
        self
    }
    /// <p>If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item is stable (<code>true</code>) or if it may change when the segment is complete (<code>false</code>).</p>
    pub fn get_stable(&self) -> &::std::option::Option<bool> {
        &self.stable
    }
    /// Consumes the builder and constructs a [`Item`](crate::types::Item).
    pub fn build(self) -> crate::types::Item {
        crate::types::Item {
            start_time: self.start_time.unwrap_or_default(),
            end_time: self.end_time.unwrap_or_default(),
            r#type: self.r#type,
            content: self.content,
            vocabulary_filter_match: self.vocabulary_filter_match.unwrap_or_default(),
            speaker: self.speaker,
            confidence: self.confidence,
            stable: self.stable,
        }
    }
}
