// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum Error {
    /// <p>One or more arguments to the <code>StartStreamTranscription</code>, <code>StartMedicalStreamTranscription</code>, or <code>StartCallAnalyticsStreamTranscription</code> operation was not valid. For example, <code>MediaEncoding</code> or <code>LanguageCode</code> used unsupported values. Check the specified parameters and try your request again.</p>
    BadRequestException(crate::types::error::BadRequestException),
    /// <p>A new stream started with the same session ID. The current stream has been terminated.</p>
    ConflictException(crate::types::error::ConflictException),
    /// <p>A problem occurred while processing the audio. Amazon Transcribe terminated processing.</p>
    InternalFailureException(crate::types::error::InternalFailureException),
    /// <p>Your client has exceeded one of the Amazon Transcribe limits. This is typically the audio length limit. Break your audio stream into smaller chunks and try your request again.</p>
    LimitExceededException(crate::types::error::LimitExceededException),
    /// <p>The request references a resource which doesn't exist.</p>
    ResourceNotFoundException(crate::types::error::ResourceNotFoundException),
    /// <p>The service is currently unavailable. Try your request later.</p>
    ServiceUnavailableException(crate::types::error::ServiceUnavailableException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-Error) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl ::std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::BadRequestException(inner) => inner.fmt(f),
            Error::ConflictException(inner) => inner.fmt(f),
            Error::InternalFailureException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ServiceUnavailableException(inner) => inner.fmt(f),
            Error::Unhandled(_) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl From<::aws_smithy_types::error::operation::BuildError> for Error {
    fn from(value: ::aws_smithy_types::error::operation::BuildError) -> Self {
        Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: value.into(),
            meta: ::std::default::Default::default(),
        })
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for Error {
    fn meta(&self) -> &::aws_smithy_types::error::metadata::ErrorMetadata {
        match self {
            Self::BadRequestException(inner) => inner.meta(),
            Self::ConflictException(inner) => inner.meta(),
            Self::InternalFailureException(inner) => inner.meta(),
            Self::LimitExceededException(inner) => inner.meta(),
            Self::ResourceNotFoundException(inner) => inner.meta(),
            Self::ServiceUnavailableException(inner) => inner.meta(),
            Self::Unhandled(inner) => &inner.meta,
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError> for Error {
    fn from(err: crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError) -> Self {
        match err {
            crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError::BadRequestException(inner) => Error::BadRequestException(inner),
            crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError::InternalFailureException(inner) => {
                Error::InternalFailureException(inner)
            }
            crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionError> for Error {
    fn from(err: crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionError) -> Self {
        match err {
            crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionError::ServiceUnavailableException(
                inner,
            ) => Error::ServiceUnavailableException(inner),
            crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionError::BadRequestException(inner) => {
                Error::BadRequestException(inner)
            }
            crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionError::InternalFailureException(
                inner,
            ) => Error::InternalFailureException(inner),
            crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionError::ConflictException(inner) => {
                Error::ConflictException(inner)
            }
            crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionError::LimitExceededException(
                inner,
            ) => Error::LimitExceededException(inner),
            crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamError> for Error {
    fn from(err: crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamError) -> Self {
        match err {
            crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamError::ServiceUnavailableException(inner) => {
                Error::ServiceUnavailableException(inner)
            }
            crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamError::BadRequestException(inner) => {
                Error::BadRequestException(inner)
            }
            crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamError::InternalFailureException(inner) => {
                Error::InternalFailureException(inner)
            }
            crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamError::ConflictException(inner) => Error::ConflictException(inner),
            crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionError> for Error {
    fn from(err: crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionError) -> Self {
        match err {
            crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionError::ServiceUnavailableException(inner) => {
                Error::ServiceUnavailableException(inner)
            }
            crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionError::BadRequestException(inner) => {
                Error::BadRequestException(inner)
            }
            crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionError::InternalFailureException(inner) => {
                Error::InternalFailureException(inner)
            }
            crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionError::ConflictException(inner) => {
                Error::ConflictException(inner)
            }
            crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_stream_transcription::StartStreamTranscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_stream_transcription::StartStreamTranscriptionError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_stream_transcription::StartStreamTranscriptionError> for Error {
    fn from(err: crate::operation::start_stream_transcription::StartStreamTranscriptionError) -> Self {
        match err {
            crate::operation::start_stream_transcription::StartStreamTranscriptionError::ServiceUnavailableException(inner) => {
                Error::ServiceUnavailableException(inner)
            }
            crate::operation::start_stream_transcription::StartStreamTranscriptionError::BadRequestException(inner) => {
                Error::BadRequestException(inner)
            }
            crate::operation::start_stream_transcription::StartStreamTranscriptionError::InternalFailureException(inner) => {
                Error::InternalFailureException(inner)
            }
            crate::operation::start_stream_transcription::StartStreamTranscriptionError::ConflictException(inner) => Error::ConflictException(inner),
            crate::operation::start_stream_transcription::StartStreamTranscriptionError::LimitExceededException(inner) => {
                Error::LimitExceededException(inner)
            }
            crate::operation::start_stream_transcription::StartStreamTranscriptionError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::AudioStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::AudioStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::types::error::AudioStreamError> for Error {
    fn from(err: crate::types::error::AudioStreamError) -> Self {
        match err {
            crate::types::error::AudioStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::CallAnalyticsTranscriptResultStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::CallAnalyticsTranscriptResultStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::types::error::CallAnalyticsTranscriptResultStreamError> for Error {
    fn from(err: crate::types::error::CallAnalyticsTranscriptResultStreamError) -> Self {
        match err {
            crate::types::error::CallAnalyticsTranscriptResultStreamError::BadRequestException(inner) => Error::BadRequestException(inner),
            crate::types::error::CallAnalyticsTranscriptResultStreamError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::types::error::CallAnalyticsTranscriptResultStreamError::InternalFailureException(inner) => Error::InternalFailureException(inner),
            crate::types::error::CallAnalyticsTranscriptResultStreamError::ConflictException(inner) => Error::ConflictException(inner),
            crate::types::error::CallAnalyticsTranscriptResultStreamError::ServiceUnavailableException(inner) => {
                Error::ServiceUnavailableException(inner)
            }
            crate::types::error::CallAnalyticsTranscriptResultStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::MedicalScribeInputStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::MedicalScribeInputStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::types::error::MedicalScribeInputStreamError> for Error {
    fn from(err: crate::types::error::MedicalScribeInputStreamError) -> Self {
        match err {
            crate::types::error::MedicalScribeInputStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::MedicalScribeResultStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::MedicalScribeResultStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::types::error::MedicalScribeResultStreamError> for Error {
    fn from(err: crate::types::error::MedicalScribeResultStreamError) -> Self {
        match err {
            crate::types::error::MedicalScribeResultStreamError::BadRequestException(inner) => Error::BadRequestException(inner),
            crate::types::error::MedicalScribeResultStreamError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::types::error::MedicalScribeResultStreamError::InternalFailureException(inner) => Error::InternalFailureException(inner),
            crate::types::error::MedicalScribeResultStreamError::ConflictException(inner) => Error::ConflictException(inner),
            crate::types::error::MedicalScribeResultStreamError::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
            crate::types::error::MedicalScribeResultStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::MedicalTranscriptResultStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::MedicalTranscriptResultStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::types::error::MedicalTranscriptResultStreamError> for Error {
    fn from(err: crate::types::error::MedicalTranscriptResultStreamError) -> Self {
        match err {
            crate::types::error::MedicalTranscriptResultStreamError::BadRequestException(inner) => Error::BadRequestException(inner),
            crate::types::error::MedicalTranscriptResultStreamError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::types::error::MedicalTranscriptResultStreamError::InternalFailureException(inner) => Error::InternalFailureException(inner),
            crate::types::error::MedicalTranscriptResultStreamError::ConflictException(inner) => Error::ConflictException(inner),
            crate::types::error::MedicalTranscriptResultStreamError::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
            crate::types::error::MedicalTranscriptResultStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::TranscriptResultStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::TranscriptResultStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::types::error::TranscriptResultStreamError> for Error {
    fn from(err: crate::types::error::TranscriptResultStreamError) -> Self {
        match err {
            crate::types::error::TranscriptResultStreamError::BadRequestException(inner) => Error::BadRequestException(inner),
            crate::types::error::TranscriptResultStreamError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::types::error::TranscriptResultStreamError::InternalFailureException(inner) => Error::InternalFailureException(inner),
            crate::types::error::TranscriptResultStreamError::ConflictException(inner) => Error::ConflictException(inner),
            crate::types::error::TranscriptResultStreamError::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
            crate::types::error::TranscriptResultStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl ::std::error::Error for Error {
    fn source(&self) -> std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Error::BadRequestException(inner) => inner.source(),
            Error::ConflictException(inner) => inner.source(),
            Error::InternalFailureException(inner) => inner.source(),
            Error::LimitExceededException(inner) => inner.source(),
            Error::ResourceNotFoundException(inner) => inner.source(),
            Error::ServiceUnavailableException(inner) => inner.source(),
            Error::Unhandled(inner) => ::std::option::Option::Some(&*inner.source),
        }
    }
}
impl ::aws_types::request_id::RequestId for Error {
    fn request_id(&self) -> Option<&str> {
        match self {
            Self::BadRequestException(e) => e.request_id(),
            Self::ConflictException(e) => e.request_id(),
            Self::InternalFailureException(e) => e.request_id(),
            Self::LimitExceededException(e) => e.request_id(),
            Self::ResourceNotFoundException(e) => e.request_id(),
            Self::ServiceUnavailableException(e) => e.request_id(),
            Self::Unhandled(e) => e.meta.request_id(),
        }
    }
}
