// Code generated by ifacemaker; DO NOT EDIT.

package hcloud

import (
	"context"
)

// IActionClient ...
type IActionClient interface {
	// GetByID retrieves an action by its ID. If the action does not exist, nil is returned.
	GetByID(ctx context.Context, id int64) (*Action, *Response, error)
	// List returns a list of actions for a specific page.
	//
	// Please note that filters specified in opts are not taken into account
	// when their value corresponds to their zero value or when they are empty.
	List(ctx context.Context, opts ActionListOpts) ([]*Action, *Response, error)
	// All returns all actions.
	All(ctx context.Context) ([]*Action, error)
	// AllWithOpts returns all actions for the given options.
	AllWithOpts(ctx context.Context, opts ActionListOpts) ([]*Action, error)
	// WatchOverallProgress watches several actions' progress until they complete
	// with success or error. This watching happens in a goroutine and updates are
	// provided through the two returned channels:
	//
	//   - The first channel receives percentage updates of the progress, based on
	//     the number of completed versus total watched actions. The return value
	//     is an int between 0 and 100.
	//   - The second channel returned receives errors for actions that did not
	//     complete successfully, as well as any errors that happened while
	//     querying the API.
	//
	// By default, the method keeps watching until all actions have finished
	// processing. If you want to be able to cancel the method or configure a
	// timeout, use the [context.Context]. Once the method has stopped watching,
	// both returned channels are closed.
	//
	// WatchOverallProgress uses the [WithPollBackoffFunc] of the [Client] to wait
	// until sending the next request.
	//
	// Deprecated: WatchOverallProgress is deprecated, use [WaitForFunc] instead.
	WatchOverallProgress(ctx context.Context, actions []*Action) (<-chan int, <-chan error)
	// WatchProgress watches one action's progress until it completes with success
	// or error. This watching happens in a goroutine and updates are provided
	// through the two returned channels:
	//
	//   - The first channel receives percentage updates of the progress, based on
	//     the progress percentage indicated by the API. The return value is an int
	//     between 0 and 100.
	//   - The second channel receives any errors that happened while querying the
	//     API, as well as the error of the action if it did not complete
	//     successfully, or nil if it did.
	//
	// By default, the method keeps watching until the action has finished
	// processing. If you want to be able to cancel the method or configure a
	// timeout, use the [context.Context]. Once the method has stopped watching,
	// both returned channels are closed.
	//
	// WatchProgress uses the [WithPollBackoffFunc] of the [Client] to wait until
	// sending the next request.
	//
	// Deprecated: WatchProgress is deprecated, use [WaitForFunc] instead.
	WatchProgress(ctx context.Context, action *Action) (<-chan int, <-chan error)
	// WaitForFunc waits until all actions are completed by polling the API at the interval
	// defined by [WithPollBackoffFunc]. An action is considered as complete when its status is
	// either [ActionStatusSuccess] or [ActionStatusError].
	//
	// The handleUpdate callback is called every time an action is updated.
	WaitForFunc(ctx context.Context, handleUpdate func(update *Action) error, actions ...*Action) error
	// WaitFor waits until all actions succeed by polling the API at the interval defined by
	// [WithPollBackoffFunc]. An action is considered as succeeded when its status is either
	// [ActionStatusSuccess].
	//
	// If a single action fails, the function will stop waiting and the error set in the
	// action will be returned as an [ActionError].
	//
	// For more flexibility, see the [ActionClient.WaitForFunc] function.
	WaitFor(ctx context.Context, actions ...*Action) error
}
