/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.Iterator;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.Constraint;
import net.sf.hibernate.mapping.Table;

public class ForeignKey
extends Constraint {
    private Table referencedTable;
    private Class referencedClass;

    public String sqlConstraintString(Dialect dialect, String constraintName) {
        String[] cols = new String[this.getColumnSpan()];
        String[] refcols = new String[this.getColumnSpan()];
        int i = 0;
        Iterator refiter = this.referencedTable.getPrimaryKey().getColumnIterator();
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            cols[i] = ((Column)iter.next()).getQuotedName(dialect);
            refcols[i] = ((Column)refiter.next()).getQuotedName(dialect);
            ++i;
        }
        return dialect.getAddForeignKeyConstraintString(constraintName, cols, this.referencedTable.getQualifiedName(dialect), refcols);
    }

    public Table getReferencedTable() {
        return this.referencedTable;
    }

    public void setReferencedTable(Table referencedTable) throws MappingException {
        if (referencedTable.getPrimaryKey().getColumnSpan() != this.getColumnSpan()) {
            throw new MappingException("Foreign key must have same number of columns as referenced primary key");
        }
        Iterator fkCols = this.getColumnIterator();
        Iterator pkCols = referencedTable.getPrimaryKey().getColumnIterator();
        while (pkCols.hasNext()) {
            ((Column)fkCols.next()).setLength(((Column)pkCols.next()).getLength());
        }
        this.referencedTable = referencedTable;
    }

    public Class getReferencedClass() {
        return this.referencedClass;
    }

    public void setReferencedClass(Class referencedClass) {
        this.referencedClass = referencedClass;
    }
}

