package backend

import (
	"io"
)

// FakeTPM is a wrapper for fake TPM devices
type FakeTPM struct {
	io.ReadWriteCloser
}

var fixedLog = []byte{0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x21, 0x0, 0x0, 0x0, 0x53, 0x70, 0x65, 0x63, 0x20, 0x49, 0x44,
	0x20, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x30, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x2, 0x0, 0x2, 0x1, 0x0, 0x0, 0x0, 0xb, 0x0, 0x20, 0x0, 0x0}

// MeasurementLog returns static log data to comply to TPM interface
func (*FakeTPM) MeasurementLog() ([]byte, error) { return fixedLog, nil }

// Fake returns a fake TPM-satisfying interface from a ReadWriteCloser
func Fake(rw io.ReadWriteCloser) *FakeTPM {
	return &FakeTPM{ReadWriteCloser: rw}
}
