# How to Contribute

We welcome any and all contributions to `ghw`! Filing [bug reports][gh-issues],
asking questions and submitting patches are all encouraged.

[gh-issues]: https://github.com/jaypipes/ghw/issues

## Submitting patches via pull requests

We use GitHub pull requests to review code submissions.

Consult [GitHub Help][pr-help] for more information on using pull requests.

[pr-help]: https://help.github.com/articles/about-pull-requests/

We ask that contributors submitting a pull request sign their commits and
attest to the Developer Certificate of Origin (DCO).

## Developer Certificate of Origin

The DCO is a lightweight way for contributors to certify that they wrote or
otherwise have the right to submit the code they are contributing to the
project. Here is the [full text of the DCO][dco], reformatted for readability:

> By making a contribution to this project, I certify that:
> 
> a. The contribution was created in whole or in part by me and I have the
> right to submit it under the open source license indicated in the file; or
> 
> b. The contribution is based upon previous work that, to the best of my
> knowledge, is covered under an appropriate open source license and I have the
> right under that license to submit that work with modifications, whether
> created in whole or in part by me, under the same open source license (unless
> I am permitted to submit under a different license), as indicated in the
> file; or
> 
> c. The contribution was provided directly to me by some other person who
> certified (a), (b) or (c) and I have not modified it.
> 
> d. I understand and agree that this project and the contribution are public
> and that a record of the contribution (including all personal information I
> submit with it, including my sign-off) is maintained indefinitely and may be
> redistributed consistent with this project or the open source license(s)
> involved.

[dco]: https://developercertificate.org/

You can sign your commits using `git commit -s` before pushing commits to
Github and creating a pull request.

## Community Guidelines

1. Be kind.
2. Seriously, that's it.
