# Hacking on rust-zmq

This file is intended to collect useful knowledge when hacking on the
rust-zmq crate.

If you intend to provide a contribution, please check the
[contribution guidelines].

[contribution guidelines]: ./CONTRIBUTING.md

## Regenerating the C bindings

The C low-level, unsafe C binding is provided by the `zmq-sys` crate,
also hosted in this repository. The bindings are only partially
auto-generated, to allow getting some platform-specific details
right.

The autogenerated part produced by the `bindgen` crate is stored in
the [`ffi.rs`] file inside the `zmq-sys` crate, and is created using
the `zmq.h` header file; using the following command:

```sh
bindgen \
   --with-derive-default \
   --whitelist-function "^zmq_.*" \
   --whitelist-type "^zmq_.*" \
   --whitelist-var "^ZMQ_.*" ~/src/zeromq-4.1.6/include/zmq.h
   > zmq-sys/src/ffi.rs
```

[`ffi.rs`]: ./zmq-sys/src/ffi.rs
