/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	"github.com/rancher/lasso/pkg/client"
	"github.com/rancher/lasso/pkg/controller"
	"github.com/rancher/wrangler/pkg/apply"
	"github.com/rancher/wrangler/pkg/condition"
	"github.com/rancher/wrangler/pkg/generic"
	"github.com/rancher/wrangler/pkg/kv"
	v1 "k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/api/equality"
	"k8s.io/apimachinery/pkg/api/errors"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
	"k8s.io/apimachinery/pkg/types"
	utilruntime "k8s.io/apimachinery/pkg/util/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

type NamespaceHandler func(string, *v1.Namespace) (*v1.Namespace, error)

type NamespaceController interface {
	generic.ControllerMeta
	NamespaceClient

	OnChange(ctx context.Context, name string, sync NamespaceHandler)
	OnRemove(ctx context.Context, name string, sync NamespaceHandler)
	Enqueue(name string)
	EnqueueAfter(name string, duration time.Duration)

	Cache() NamespaceCache
}

type NamespaceClient interface {
	Create(*v1.Namespace) (*v1.Namespace, error)
	Update(*v1.Namespace) (*v1.Namespace, error)
	UpdateStatus(*v1.Namespace) (*v1.Namespace, error)
	Delete(name string, options *metav1.DeleteOptions) error
	Get(name string, options metav1.GetOptions) (*v1.Namespace, error)
	List(opts metav1.ListOptions) (*v1.NamespaceList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Namespace, err error)
}

type NamespaceCache interface {
	Get(name string) (*v1.Namespace, error)
	List(selector labels.Selector) ([]*v1.Namespace, error)

	AddIndexer(indexName string, indexer NamespaceIndexer)
	GetByIndex(indexName, key string) ([]*v1.Namespace, error)
}

type NamespaceIndexer func(obj *v1.Namespace) ([]string, error)

type namespaceController struct {
	controller    controller.SharedController
	client        *client.Client
	gvk           schema.GroupVersionKind
	groupResource schema.GroupResource
}

func NewNamespaceController(gvk schema.GroupVersionKind, resource string, namespaced bool, controller controller.SharedControllerFactory) NamespaceController {
	c := controller.ForResourceKind(gvk.GroupVersion().WithResource(resource), gvk.Kind, namespaced)
	return &namespaceController{
		controller: c,
		client:     c.Client(),
		gvk:        gvk,
		groupResource: schema.GroupResource{
			Group:    gvk.Group,
			Resource: resource,
		},
	}
}

func FromNamespaceHandlerToHandler(sync NamespaceHandler) generic.Handler {
	return func(key string, obj runtime.Object) (ret runtime.Object, err error) {
		var v *v1.Namespace
		if obj == nil {
			v, err = sync(key, nil)
		} else {
			v, err = sync(key, obj.(*v1.Namespace))
		}
		if v == nil {
			return nil, err
		}
		return v, err
	}
}

func (c *namespaceController) Updater() generic.Updater {
	return func(obj runtime.Object) (runtime.Object, error) {
		newObj, err := c.Update(obj.(*v1.Namespace))
		if newObj == nil {
			return nil, err
		}
		return newObj, err
	}
}

func UpdateNamespaceDeepCopyOnChange(client NamespaceClient, obj *v1.Namespace, handler func(obj *v1.Namespace) (*v1.Namespace, error)) (*v1.Namespace, error) {
	if obj == nil {
		return obj, nil
	}

	copyObj := obj.DeepCopy()
	newObj, err := handler(copyObj)
	if newObj != nil {
		copyObj = newObj
	}
	if obj.ResourceVersion == copyObj.ResourceVersion && !equality.Semantic.DeepEqual(obj, copyObj) {
		return client.Update(copyObj)
	}

	return copyObj, err
}

func (c *namespaceController) AddGenericHandler(ctx context.Context, name string, handler generic.Handler) {
	c.controller.RegisterHandler(ctx, name, controller.SharedControllerHandlerFunc(handler))
}

func (c *namespaceController) AddGenericRemoveHandler(ctx context.Context, name string, handler generic.Handler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), handler))
}

func (c *namespaceController) OnChange(ctx context.Context, name string, sync NamespaceHandler) {
	c.AddGenericHandler(ctx, name, FromNamespaceHandlerToHandler(sync))
}

func (c *namespaceController) OnRemove(ctx context.Context, name string, sync NamespaceHandler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), FromNamespaceHandlerToHandler(sync)))
}

func (c *namespaceController) Enqueue(name string) {
	c.controller.Enqueue("", name)
}

func (c *namespaceController) EnqueueAfter(name string, duration time.Duration) {
	c.controller.EnqueueAfter("", name, duration)
}

func (c *namespaceController) Informer() cache.SharedIndexInformer {
	return c.controller.Informer()
}

func (c *namespaceController) GroupVersionKind() schema.GroupVersionKind {
	return c.gvk
}

func (c *namespaceController) Cache() NamespaceCache {
	return &namespaceCache{
		indexer:  c.Informer().GetIndexer(),
		resource: c.groupResource,
	}
}

func (c *namespaceController) Create(obj *v1.Namespace) (*v1.Namespace, error) {
	result := &v1.Namespace{}
	return result, c.client.Create(context.TODO(), "", obj, result, metav1.CreateOptions{})
}

func (c *namespaceController) Update(obj *v1.Namespace) (*v1.Namespace, error) {
	result := &v1.Namespace{}
	return result, c.client.Update(context.TODO(), "", obj, result, metav1.UpdateOptions{})
}

func (c *namespaceController) UpdateStatus(obj *v1.Namespace) (*v1.Namespace, error) {
	result := &v1.Namespace{}
	return result, c.client.UpdateStatus(context.TODO(), "", obj, result, metav1.UpdateOptions{})
}

func (c *namespaceController) Delete(name string, options *metav1.DeleteOptions) error {
	if options == nil {
		options = &metav1.DeleteOptions{}
	}
	return c.client.Delete(context.TODO(), "", name, *options)
}

func (c *namespaceController) Get(name string, options metav1.GetOptions) (*v1.Namespace, error) {
	result := &v1.Namespace{}
	return result, c.client.Get(context.TODO(), "", name, result, options)
}

func (c *namespaceController) List(opts metav1.ListOptions) (*v1.NamespaceList, error) {
	result := &v1.NamespaceList{}
	return result, c.client.List(context.TODO(), "", result, opts)
}

func (c *namespaceController) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	return c.client.Watch(context.TODO(), "", opts)
}

func (c *namespaceController) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (*v1.Namespace, error) {
	result := &v1.Namespace{}
	return result, c.client.Patch(context.TODO(), "", name, pt, data, result, metav1.PatchOptions{}, subresources...)
}

type namespaceCache struct {
	indexer  cache.Indexer
	resource schema.GroupResource
}

func (c *namespaceCache) Get(name string) (*v1.Namespace, error) {
	obj, exists, err := c.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(c.resource, name)
	}
	return obj.(*v1.Namespace), nil
}

func (c *namespaceCache) List(selector labels.Selector) (ret []*v1.Namespace, err error) {

	err = cache.ListAll(c.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Namespace))
	})

	return ret, err
}

func (c *namespaceCache) AddIndexer(indexName string, indexer NamespaceIndexer) {
	utilruntime.Must(c.indexer.AddIndexers(map[string]cache.IndexFunc{
		indexName: func(obj interface{}) (strings []string, e error) {
			return indexer(obj.(*v1.Namespace))
		},
	}))
}

func (c *namespaceCache) GetByIndex(indexName, key string) (result []*v1.Namespace, err error) {
	objs, err := c.indexer.ByIndex(indexName, key)
	if err != nil {
		return nil, err
	}
	result = make([]*v1.Namespace, 0, len(objs))
	for _, obj := range objs {
		result = append(result, obj.(*v1.Namespace))
	}
	return result, nil
}

type NamespaceStatusHandler func(obj *v1.Namespace, status v1.NamespaceStatus) (v1.NamespaceStatus, error)

type NamespaceGeneratingHandler func(obj *v1.Namespace, status v1.NamespaceStatus) ([]runtime.Object, v1.NamespaceStatus, error)

func RegisterNamespaceStatusHandler(ctx context.Context, controller NamespaceController, condition condition.Cond, name string, handler NamespaceStatusHandler) {
	statusHandler := &namespaceStatusHandler{
		client:    controller,
		condition: condition,
		handler:   handler,
	}
	controller.AddGenericHandler(ctx, name, FromNamespaceHandlerToHandler(statusHandler.sync))
}

func RegisterNamespaceGeneratingHandler(ctx context.Context, controller NamespaceController, apply apply.Apply,
	condition condition.Cond, name string, handler NamespaceGeneratingHandler, opts *generic.GeneratingHandlerOptions) {
	statusHandler := &namespaceGeneratingHandler{
		NamespaceGeneratingHandler: handler,
		apply:                      apply,
		name:                       name,
		gvk:                        controller.GroupVersionKind(),
	}
	if opts != nil {
		statusHandler.opts = *opts
	}
	controller.OnChange(ctx, name, statusHandler.Remove)
	RegisterNamespaceStatusHandler(ctx, controller, condition, name, statusHandler.Handle)
}

type namespaceStatusHandler struct {
	client    NamespaceClient
	condition condition.Cond
	handler   NamespaceStatusHandler
}

func (a *namespaceStatusHandler) sync(key string, obj *v1.Namespace) (*v1.Namespace, error) {
	if obj == nil {
		return obj, nil
	}

	origStatus := obj.Status.DeepCopy()
	obj = obj.DeepCopy()
	newStatus, err := a.handler(obj, obj.Status)
	if err != nil {
		// Revert to old status on error
		newStatus = *origStatus.DeepCopy()
	}

	if a.condition != "" {
		if errors.IsConflict(err) {
			a.condition.SetError(&newStatus, "", nil)
		} else {
			a.condition.SetError(&newStatus, "", err)
		}
	}
	if !equality.Semantic.DeepEqual(origStatus, &newStatus) {
		if a.condition != "" {
			// Since status has changed, update the lastUpdatedTime
			a.condition.LastUpdated(&newStatus, time.Now().UTC().Format(time.RFC3339))
		}

		var newErr error
		obj.Status = newStatus
		newObj, newErr := a.client.UpdateStatus(obj)
		if err == nil {
			err = newErr
		}
		if newErr == nil {
			obj = newObj
		}
	}
	return obj, err
}

type namespaceGeneratingHandler struct {
	NamespaceGeneratingHandler
	apply apply.Apply
	opts  generic.GeneratingHandlerOptions
	gvk   schema.GroupVersionKind
	name  string
}

func (a *namespaceGeneratingHandler) Remove(key string, obj *v1.Namespace) (*v1.Namespace, error) {
	if obj != nil {
		return obj, nil
	}

	obj = &v1.Namespace{}
	obj.Namespace, obj.Name = kv.RSplit(key, "/")
	obj.SetGroupVersionKind(a.gvk)

	return nil, generic.ConfigureApplyForObject(a.apply, obj, &a.opts).
		WithOwner(obj).
		WithSetID(a.name).
		ApplyObjects()
}

func (a *namespaceGeneratingHandler) Handle(obj *v1.Namespace, status v1.NamespaceStatus) (v1.NamespaceStatus, error) {
	if !obj.DeletionTimestamp.IsZero() {
		return status, nil
	}

	objs, newStatus, err := a.NamespaceGeneratingHandler(obj, status)
	if err != nil {
		return newStatus, err
	}

	return newStatus, generic.ConfigureApplyForObject(a.apply, obj, &a.opts).
		WithOwner(obj).
		WithSetID(a.name).
		ApplyObjects(objs...)
}
