/* This file is generated by venus-protocol git-e05ae158. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_DEVICE_H
#define VN_PROTOCOL_RENDERER_DEVICE_H

#include "vn_protocol_renderer_structs.h"

/*
 * These structs/unions/commands are not included
 *
 *   vkGetDeviceProcAddr
 */

/* struct VkPhysicalDeviceLimits */

static inline void
vn_encode_VkPhysicalDeviceLimits(struct vn_cs_encoder *enc, const VkPhysicalDeviceLimits *val)
{
    vn_encode_uint32_t(enc, &val->maxImageDimension1D);
    vn_encode_uint32_t(enc, &val->maxImageDimension2D);
    vn_encode_uint32_t(enc, &val->maxImageDimension3D);
    vn_encode_uint32_t(enc, &val->maxImageDimensionCube);
    vn_encode_uint32_t(enc, &val->maxImageArrayLayers);
    vn_encode_uint32_t(enc, &val->maxTexelBufferElements);
    vn_encode_uint32_t(enc, &val->maxUniformBufferRange);
    vn_encode_uint32_t(enc, &val->maxStorageBufferRange);
    vn_encode_uint32_t(enc, &val->maxPushConstantsSize);
    vn_encode_uint32_t(enc, &val->maxMemoryAllocationCount);
    vn_encode_uint32_t(enc, &val->maxSamplerAllocationCount);
    vn_encode_VkDeviceSize(enc, &val->bufferImageGranularity);
    vn_encode_VkDeviceSize(enc, &val->sparseAddressSpaceSize);
    vn_encode_uint32_t(enc, &val->maxBoundDescriptorSets);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorSamplers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorSampledImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorStorageImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorInputAttachments);
    vn_encode_uint32_t(enc, &val->maxPerStageResources);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetSamplers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUniformBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetStorageBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetSampledImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetStorageImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetInputAttachments);
    vn_encode_uint32_t(enc, &val->maxVertexInputAttributes);
    vn_encode_uint32_t(enc, &val->maxVertexInputBindings);
    vn_encode_uint32_t(enc, &val->maxVertexInputAttributeOffset);
    vn_encode_uint32_t(enc, &val->maxVertexInputBindingStride);
    vn_encode_uint32_t(enc, &val->maxVertexOutputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationGenerationLevel);
    vn_encode_uint32_t(enc, &val->maxTessellationPatchSize);
    vn_encode_uint32_t(enc, &val->maxTessellationControlPerVertexInputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationControlPerVertexOutputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationControlPerPatchOutputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationControlTotalOutputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationEvaluationInputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationEvaluationOutputComponents);
    vn_encode_uint32_t(enc, &val->maxGeometryShaderInvocations);
    vn_encode_uint32_t(enc, &val->maxGeometryInputComponents);
    vn_encode_uint32_t(enc, &val->maxGeometryOutputComponents);
    vn_encode_uint32_t(enc, &val->maxGeometryOutputVertices);
    vn_encode_uint32_t(enc, &val->maxGeometryTotalOutputComponents);
    vn_encode_uint32_t(enc, &val->maxFragmentInputComponents);
    vn_encode_uint32_t(enc, &val->maxFragmentOutputAttachments);
    vn_encode_uint32_t(enc, &val->maxFragmentDualSrcAttachments);
    vn_encode_uint32_t(enc, &val->maxFragmentCombinedOutputResources);
    vn_encode_uint32_t(enc, &val->maxComputeSharedMemorySize);
    vn_encode_array_size(enc, 3);
    vn_encode_uint32_t_array(enc, val->maxComputeWorkGroupCount, 3);
    vn_encode_uint32_t(enc, &val->maxComputeWorkGroupInvocations);
    vn_encode_array_size(enc, 3);
    vn_encode_uint32_t_array(enc, val->maxComputeWorkGroupSize, 3);
    vn_encode_uint32_t(enc, &val->subPixelPrecisionBits);
    vn_encode_uint32_t(enc, &val->subTexelPrecisionBits);
    vn_encode_uint32_t(enc, &val->mipmapPrecisionBits);
    vn_encode_uint32_t(enc, &val->maxDrawIndexedIndexValue);
    vn_encode_uint32_t(enc, &val->maxDrawIndirectCount);
    vn_encode_float(enc, &val->maxSamplerLodBias);
    vn_encode_float(enc, &val->maxSamplerAnisotropy);
    vn_encode_uint32_t(enc, &val->maxViewports);
    vn_encode_array_size(enc, 2);
    vn_encode_uint32_t_array(enc, val->maxViewportDimensions, 2);
    vn_encode_array_size(enc, 2);
    vn_encode_float_array(enc, val->viewportBoundsRange, 2);
    vn_encode_uint32_t(enc, &val->viewportSubPixelBits);
    vn_encode_size_t(enc, &val->minMemoryMapAlignment);
    vn_encode_VkDeviceSize(enc, &val->minTexelBufferOffsetAlignment);
    vn_encode_VkDeviceSize(enc, &val->minUniformBufferOffsetAlignment);
    vn_encode_VkDeviceSize(enc, &val->minStorageBufferOffsetAlignment);
    vn_encode_int32_t(enc, &val->minTexelOffset);
    vn_encode_uint32_t(enc, &val->maxTexelOffset);
    vn_encode_int32_t(enc, &val->minTexelGatherOffset);
    vn_encode_uint32_t(enc, &val->maxTexelGatherOffset);
    vn_encode_float(enc, &val->minInterpolationOffset);
    vn_encode_float(enc, &val->maxInterpolationOffset);
    vn_encode_uint32_t(enc, &val->subPixelInterpolationOffsetBits);
    vn_encode_uint32_t(enc, &val->maxFramebufferWidth);
    vn_encode_uint32_t(enc, &val->maxFramebufferHeight);
    vn_encode_uint32_t(enc, &val->maxFramebufferLayers);
    vn_encode_VkFlags(enc, &val->framebufferColorSampleCounts);
    vn_encode_VkFlags(enc, &val->framebufferDepthSampleCounts);
    vn_encode_VkFlags(enc, &val->framebufferStencilSampleCounts);
    vn_encode_VkFlags(enc, &val->framebufferNoAttachmentsSampleCounts);
    vn_encode_uint32_t(enc, &val->maxColorAttachments);
    vn_encode_VkFlags(enc, &val->sampledImageColorSampleCounts);
    vn_encode_VkFlags(enc, &val->sampledImageIntegerSampleCounts);
    vn_encode_VkFlags(enc, &val->sampledImageDepthSampleCounts);
    vn_encode_VkFlags(enc, &val->sampledImageStencilSampleCounts);
    vn_encode_VkFlags(enc, &val->storageImageSampleCounts);
    vn_encode_uint32_t(enc, &val->maxSampleMaskWords);
    vn_encode_VkBool32(enc, &val->timestampComputeAndGraphics);
    vn_encode_float(enc, &val->timestampPeriod);
    vn_encode_uint32_t(enc, &val->maxClipDistances);
    vn_encode_uint32_t(enc, &val->maxCullDistances);
    vn_encode_uint32_t(enc, &val->maxCombinedClipAndCullDistances);
    vn_encode_uint32_t(enc, &val->discreteQueuePriorities);
    vn_encode_array_size(enc, 2);
    vn_encode_float_array(enc, val->pointSizeRange, 2);
    vn_encode_array_size(enc, 2);
    vn_encode_float_array(enc, val->lineWidthRange, 2);
    vn_encode_float(enc, &val->pointSizeGranularity);
    vn_encode_float(enc, &val->lineWidthGranularity);
    vn_encode_VkBool32(enc, &val->strictLines);
    vn_encode_VkBool32(enc, &val->standardSampleLocations);
    vn_encode_VkDeviceSize(enc, &val->optimalBufferCopyOffsetAlignment);
    vn_encode_VkDeviceSize(enc, &val->optimalBufferCopyRowPitchAlignment);
    vn_encode_VkDeviceSize(enc, &val->nonCoherentAtomSize);
}

static inline void
vn_decode_VkPhysicalDeviceLimits_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLimits *val)
{
    /* skip val->maxImageDimension1D */
    /* skip val->maxImageDimension2D */
    /* skip val->maxImageDimension3D */
    /* skip val->maxImageDimensionCube */
    /* skip val->maxImageArrayLayers */
    /* skip val->maxTexelBufferElements */
    /* skip val->maxUniformBufferRange */
    /* skip val->maxStorageBufferRange */
    /* skip val->maxPushConstantsSize */
    /* skip val->maxMemoryAllocationCount */
    /* skip val->maxSamplerAllocationCount */
    /* skip val->bufferImageGranularity */
    /* skip val->sparseAddressSpaceSize */
    /* skip val->maxBoundDescriptorSets */
    /* skip val->maxPerStageDescriptorSamplers */
    /* skip val->maxPerStageDescriptorUniformBuffers */
    /* skip val->maxPerStageDescriptorStorageBuffers */
    /* skip val->maxPerStageDescriptorSampledImages */
    /* skip val->maxPerStageDescriptorStorageImages */
    /* skip val->maxPerStageDescriptorInputAttachments */
    /* skip val->maxPerStageResources */
    /* skip val->maxDescriptorSetSamplers */
    /* skip val->maxDescriptorSetUniformBuffers */
    /* skip val->maxDescriptorSetUniformBuffersDynamic */
    /* skip val->maxDescriptorSetStorageBuffers */
    /* skip val->maxDescriptorSetStorageBuffersDynamic */
    /* skip val->maxDescriptorSetSampledImages */
    /* skip val->maxDescriptorSetStorageImages */
    /* skip val->maxDescriptorSetInputAttachments */
    /* skip val->maxVertexInputAttributes */
    /* skip val->maxVertexInputBindings */
    /* skip val->maxVertexInputAttributeOffset */
    /* skip val->maxVertexInputBindingStride */
    /* skip val->maxVertexOutputComponents */
    /* skip val->maxTessellationGenerationLevel */
    /* skip val->maxTessellationPatchSize */
    /* skip val->maxTessellationControlPerVertexInputComponents */
    /* skip val->maxTessellationControlPerVertexOutputComponents */
    /* skip val->maxTessellationControlPerPatchOutputComponents */
    /* skip val->maxTessellationControlTotalOutputComponents */
    /* skip val->maxTessellationEvaluationInputComponents */
    /* skip val->maxTessellationEvaluationOutputComponents */
    /* skip val->maxGeometryShaderInvocations */
    /* skip val->maxGeometryInputComponents */
    /* skip val->maxGeometryOutputComponents */
    /* skip val->maxGeometryOutputVertices */
    /* skip val->maxGeometryTotalOutputComponents */
    /* skip val->maxFragmentInputComponents */
    /* skip val->maxFragmentOutputAttachments */
    /* skip val->maxFragmentDualSrcAttachments */
    /* skip val->maxFragmentCombinedOutputResources */
    /* skip val->maxComputeSharedMemorySize */
    /* skip val->maxComputeWorkGroupCount */
    /* skip val->maxComputeWorkGroupInvocations */
    /* skip val->maxComputeWorkGroupSize */
    /* skip val->subPixelPrecisionBits */
    /* skip val->subTexelPrecisionBits */
    /* skip val->mipmapPrecisionBits */
    /* skip val->maxDrawIndexedIndexValue */
    /* skip val->maxDrawIndirectCount */
    /* skip val->maxSamplerLodBias */
    /* skip val->maxSamplerAnisotropy */
    /* skip val->maxViewports */
    /* skip val->maxViewportDimensions */
    /* skip val->viewportBoundsRange */
    /* skip val->viewportSubPixelBits */
    /* skip val->minMemoryMapAlignment */
    /* skip val->minTexelBufferOffsetAlignment */
    /* skip val->minUniformBufferOffsetAlignment */
    /* skip val->minStorageBufferOffsetAlignment */
    /* skip val->minTexelOffset */
    /* skip val->maxTexelOffset */
    /* skip val->minTexelGatherOffset */
    /* skip val->maxTexelGatherOffset */
    /* skip val->minInterpolationOffset */
    /* skip val->maxInterpolationOffset */
    /* skip val->subPixelInterpolationOffsetBits */
    /* skip val->maxFramebufferWidth */
    /* skip val->maxFramebufferHeight */
    /* skip val->maxFramebufferLayers */
    /* skip val->framebufferColorSampleCounts */
    /* skip val->framebufferDepthSampleCounts */
    /* skip val->framebufferStencilSampleCounts */
    /* skip val->framebufferNoAttachmentsSampleCounts */
    /* skip val->maxColorAttachments */
    /* skip val->sampledImageColorSampleCounts */
    /* skip val->sampledImageIntegerSampleCounts */
    /* skip val->sampledImageDepthSampleCounts */
    /* skip val->sampledImageStencilSampleCounts */
    /* skip val->storageImageSampleCounts */
    /* skip val->maxSampleMaskWords */
    /* skip val->timestampComputeAndGraphics */
    /* skip val->timestampPeriod */
    /* skip val->maxClipDistances */
    /* skip val->maxCullDistances */
    /* skip val->maxCombinedClipAndCullDistances */
    /* skip val->discreteQueuePriorities */
    /* skip val->pointSizeRange */
    /* skip val->lineWidthRange */
    /* skip val->pointSizeGranularity */
    /* skip val->lineWidthGranularity */
    /* skip val->strictLines */
    /* skip val->standardSampleLocations */
    /* skip val->optimalBufferCopyOffsetAlignment */
    /* skip val->optimalBufferCopyRowPitchAlignment */
    /* skip val->nonCoherentAtomSize */
}

/* struct VkPhysicalDeviceSparseProperties */

static inline void
vn_encode_VkPhysicalDeviceSparseProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceSparseProperties *val)
{
    vn_encode_VkBool32(enc, &val->residencyStandard2DBlockShape);
    vn_encode_VkBool32(enc, &val->residencyStandard2DMultisampleBlockShape);
    vn_encode_VkBool32(enc, &val->residencyStandard3DBlockShape);
    vn_encode_VkBool32(enc, &val->residencyAlignedMipSize);
    vn_encode_VkBool32(enc, &val->residencyNonResidentStrict);
}

static inline void
vn_decode_VkPhysicalDeviceSparseProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSparseProperties *val)
{
    /* skip val->residencyStandard2DBlockShape */
    /* skip val->residencyStandard2DMultisampleBlockShape */
    /* skip val->residencyStandard3DBlockShape */
    /* skip val->residencyAlignedMipSize */
    /* skip val->residencyNonResidentStrict */
}

/* struct VkPhysicalDeviceProperties */

static inline void
vn_encode_VkPhysicalDeviceProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties *val)
{
    vn_encode_uint32_t(enc, &val->apiVersion);
    vn_encode_uint32_t(enc, &val->driverVersion);
    vn_encode_uint32_t(enc, &val->vendorID);
    vn_encode_uint32_t(enc, &val->deviceID);
    vn_encode_VkPhysicalDeviceType(enc, &val->deviceType);
    vn_encode_array_size(enc, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE);
    vn_encode_blob_array(enc, val->deviceName, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE);
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->pipelineCacheUUID, VK_UUID_SIZE);
    vn_encode_VkPhysicalDeviceLimits(enc, &val->limits);
    vn_encode_VkPhysicalDeviceSparseProperties(enc, &val->sparseProperties);
}

static inline void
vn_decode_VkPhysicalDeviceProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties *val)
{
    /* skip val->apiVersion */
    /* skip val->driverVersion */
    /* skip val->vendorID */
    /* skip val->deviceID */
    /* skip val->deviceType */
    /* skip val->deviceName */
    /* skip val->pipelineCacheUUID */
    vn_decode_VkPhysicalDeviceLimits_partial_temp(dec, &val->limits);
    vn_decode_VkPhysicalDeviceSparseProperties_partial_temp(dec, &val->sparseProperties);
}

/* struct VkQueueFamilyProperties */

static inline void
vn_encode_VkQueueFamilyProperties(struct vn_cs_encoder *enc, const VkQueueFamilyProperties *val)
{
    vn_encode_VkFlags(enc, &val->queueFlags);
    vn_encode_uint32_t(enc, &val->queueCount);
    vn_encode_uint32_t(enc, &val->timestampValidBits);
    vn_encode_VkExtent3D(enc, &val->minImageTransferGranularity);
}

static inline void
vn_decode_VkQueueFamilyProperties_partial_temp(struct vn_cs_decoder *dec, VkQueueFamilyProperties *val)
{
    /* skip val->queueFlags */
    /* skip val->queueCount */
    /* skip val->timestampValidBits */
    vn_decode_VkExtent3D_partial_temp(dec, &val->minImageTransferGranularity);
}

/* struct VkMemoryType */

static inline void
vn_encode_VkMemoryType(struct vn_cs_encoder *enc, const VkMemoryType *val)
{
    vn_encode_VkFlags(enc, &val->propertyFlags);
    vn_encode_uint32_t(enc, &val->heapIndex);
}

static inline void
vn_decode_VkMemoryType_partial_temp(struct vn_cs_decoder *dec, VkMemoryType *val)
{
    /* skip val->propertyFlags */
    /* skip val->heapIndex */
}

/* struct VkMemoryHeap */

static inline void
vn_encode_VkMemoryHeap(struct vn_cs_encoder *enc, const VkMemoryHeap *val)
{
    vn_encode_VkDeviceSize(enc, &val->size);
    vn_encode_VkFlags(enc, &val->flags);
}

static inline void
vn_decode_VkMemoryHeap_partial_temp(struct vn_cs_decoder *dec, VkMemoryHeap *val)
{
    /* skip val->size */
    /* skip val->flags */
}

/* struct VkPhysicalDeviceMemoryProperties */

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties *val)
{
    vn_encode_uint32_t(enc, &val->memoryTypeCount);
    vn_encode_array_size(enc, VK_MAX_MEMORY_TYPES);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_TYPES; i++)
        vn_encode_VkMemoryType(enc, &val->memoryTypes[i]);
    vn_encode_uint32_t(enc, &val->memoryHeapCount);
    vn_encode_array_size(enc, VK_MAX_MEMORY_HEAPS);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; i++)
        vn_encode_VkMemoryHeap(enc, &val->memoryHeaps[i]);
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties *val)
{
    /* skip val->memoryTypeCount */
    {
        vn_decode_array_size(dec, VK_MAX_MEMORY_TYPES);
        for (uint32_t i = 0; i < VK_MAX_MEMORY_TYPES; i++)
            vn_decode_VkMemoryType_partial_temp(dec, &val->memoryTypes[i]);
    }
    /* skip val->memoryHeapCount */
    {
        vn_decode_array_size(dec, VK_MAX_MEMORY_HEAPS);
        for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; i++)
            vn_decode_VkMemoryHeap_partial_temp(dec, &val->memoryHeaps[i]);
    }
}

/* struct VkPhysicalDeviceFeatures */

static inline void
vn_encode_VkPhysicalDeviceFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures *val)
{
    vn_encode_VkBool32(enc, &val->robustBufferAccess);
    vn_encode_VkBool32(enc, &val->fullDrawIndexUint32);
    vn_encode_VkBool32(enc, &val->imageCubeArray);
    vn_encode_VkBool32(enc, &val->independentBlend);
    vn_encode_VkBool32(enc, &val->geometryShader);
    vn_encode_VkBool32(enc, &val->tessellationShader);
    vn_encode_VkBool32(enc, &val->sampleRateShading);
    vn_encode_VkBool32(enc, &val->dualSrcBlend);
    vn_encode_VkBool32(enc, &val->logicOp);
    vn_encode_VkBool32(enc, &val->multiDrawIndirect);
    vn_encode_VkBool32(enc, &val->drawIndirectFirstInstance);
    vn_encode_VkBool32(enc, &val->depthClamp);
    vn_encode_VkBool32(enc, &val->depthBiasClamp);
    vn_encode_VkBool32(enc, &val->fillModeNonSolid);
    vn_encode_VkBool32(enc, &val->depthBounds);
    vn_encode_VkBool32(enc, &val->wideLines);
    vn_encode_VkBool32(enc, &val->largePoints);
    vn_encode_VkBool32(enc, &val->alphaToOne);
    vn_encode_VkBool32(enc, &val->multiViewport);
    vn_encode_VkBool32(enc, &val->samplerAnisotropy);
    vn_encode_VkBool32(enc, &val->textureCompressionETC2);
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_LDR);
    vn_encode_VkBool32(enc, &val->textureCompressionBC);
    vn_encode_VkBool32(enc, &val->occlusionQueryPrecise);
    vn_encode_VkBool32(enc, &val->pipelineStatisticsQuery);
    vn_encode_VkBool32(enc, &val->vertexPipelineStoresAndAtomics);
    vn_encode_VkBool32(enc, &val->fragmentStoresAndAtomics);
    vn_encode_VkBool32(enc, &val->shaderTessellationAndGeometryPointSize);
    vn_encode_VkBool32(enc, &val->shaderImageGatherExtended);
    vn_encode_VkBool32(enc, &val->shaderStorageImageExtendedFormats);
    vn_encode_VkBool32(enc, &val->shaderStorageImageMultisample);
    vn_encode_VkBool32(enc, &val->shaderStorageImageReadWithoutFormat);
    vn_encode_VkBool32(enc, &val->shaderStorageImageWriteWithoutFormat);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderClipDistance);
    vn_encode_VkBool32(enc, &val->shaderCullDistance);
    vn_encode_VkBool32(enc, &val->shaderFloat64);
    vn_encode_VkBool32(enc, &val->shaderInt64);
    vn_encode_VkBool32(enc, &val->shaderInt16);
    vn_encode_VkBool32(enc, &val->shaderResourceResidency);
    vn_encode_VkBool32(enc, &val->shaderResourceMinLod);
    vn_encode_VkBool32(enc, &val->sparseBinding);
    vn_encode_VkBool32(enc, &val->sparseResidencyBuffer);
    vn_encode_VkBool32(enc, &val->sparseResidencyImage2D);
    vn_encode_VkBool32(enc, &val->sparseResidencyImage3D);
    vn_encode_VkBool32(enc, &val->sparseResidency2Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency4Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency8Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency16Samples);
    vn_encode_VkBool32(enc, &val->sparseResidencyAliased);
    vn_encode_VkBool32(enc, &val->variableMultisampleRate);
    vn_encode_VkBool32(enc, &val->inheritedQueries);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures *val)
{
    vn_decode_VkBool32(dec, &val->robustBufferAccess);
    vn_decode_VkBool32(dec, &val->fullDrawIndexUint32);
    vn_decode_VkBool32(dec, &val->imageCubeArray);
    vn_decode_VkBool32(dec, &val->independentBlend);
    vn_decode_VkBool32(dec, &val->geometryShader);
    vn_decode_VkBool32(dec, &val->tessellationShader);
    vn_decode_VkBool32(dec, &val->sampleRateShading);
    vn_decode_VkBool32(dec, &val->dualSrcBlend);
    vn_decode_VkBool32(dec, &val->logicOp);
    vn_decode_VkBool32(dec, &val->multiDrawIndirect);
    vn_decode_VkBool32(dec, &val->drawIndirectFirstInstance);
    vn_decode_VkBool32(dec, &val->depthClamp);
    vn_decode_VkBool32(dec, &val->depthBiasClamp);
    vn_decode_VkBool32(dec, &val->fillModeNonSolid);
    vn_decode_VkBool32(dec, &val->depthBounds);
    vn_decode_VkBool32(dec, &val->wideLines);
    vn_decode_VkBool32(dec, &val->largePoints);
    vn_decode_VkBool32(dec, &val->alphaToOne);
    vn_decode_VkBool32(dec, &val->multiViewport);
    vn_decode_VkBool32(dec, &val->samplerAnisotropy);
    vn_decode_VkBool32(dec, &val->textureCompressionETC2);
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_LDR);
    vn_decode_VkBool32(dec, &val->textureCompressionBC);
    vn_decode_VkBool32(dec, &val->occlusionQueryPrecise);
    vn_decode_VkBool32(dec, &val->pipelineStatisticsQuery);
    vn_decode_VkBool32(dec, &val->vertexPipelineStoresAndAtomics);
    vn_decode_VkBool32(dec, &val->fragmentStoresAndAtomics);
    vn_decode_VkBool32(dec, &val->shaderTessellationAndGeometryPointSize);
    vn_decode_VkBool32(dec, &val->shaderImageGatherExtended);
    vn_decode_VkBool32(dec, &val->shaderStorageImageExtendedFormats);
    vn_decode_VkBool32(dec, &val->shaderStorageImageMultisample);
    vn_decode_VkBool32(dec, &val->shaderStorageImageReadWithoutFormat);
    vn_decode_VkBool32(dec, &val->shaderStorageImageWriteWithoutFormat);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderClipDistance);
    vn_decode_VkBool32(dec, &val->shaderCullDistance);
    vn_decode_VkBool32(dec, &val->shaderFloat64);
    vn_decode_VkBool32(dec, &val->shaderInt64);
    vn_decode_VkBool32(dec, &val->shaderInt16);
    vn_decode_VkBool32(dec, &val->shaderResourceResidency);
    vn_decode_VkBool32(dec, &val->shaderResourceMinLod);
    vn_decode_VkBool32(dec, &val->sparseBinding);
    vn_decode_VkBool32(dec, &val->sparseResidencyBuffer);
    vn_decode_VkBool32(dec, &val->sparseResidencyImage2D);
    vn_decode_VkBool32(dec, &val->sparseResidencyImage3D);
    vn_decode_VkBool32(dec, &val->sparseResidency2Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency4Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency8Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency16Samples);
    vn_decode_VkBool32(dec, &val->sparseResidencyAliased);
    vn_decode_VkBool32(dec, &val->variableMultisampleRate);
    vn_decode_VkBool32(dec, &val->inheritedQueries);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures *val)
{
    /* skip val->robustBufferAccess */
    /* skip val->fullDrawIndexUint32 */
    /* skip val->imageCubeArray */
    /* skip val->independentBlend */
    /* skip val->geometryShader */
    /* skip val->tessellationShader */
    /* skip val->sampleRateShading */
    /* skip val->dualSrcBlend */
    /* skip val->logicOp */
    /* skip val->multiDrawIndirect */
    /* skip val->drawIndirectFirstInstance */
    /* skip val->depthClamp */
    /* skip val->depthBiasClamp */
    /* skip val->fillModeNonSolid */
    /* skip val->depthBounds */
    /* skip val->wideLines */
    /* skip val->largePoints */
    /* skip val->alphaToOne */
    /* skip val->multiViewport */
    /* skip val->samplerAnisotropy */
    /* skip val->textureCompressionETC2 */
    /* skip val->textureCompressionASTC_LDR */
    /* skip val->textureCompressionBC */
    /* skip val->occlusionQueryPrecise */
    /* skip val->pipelineStatisticsQuery */
    /* skip val->vertexPipelineStoresAndAtomics */
    /* skip val->fragmentStoresAndAtomics */
    /* skip val->shaderTessellationAndGeometryPointSize */
    /* skip val->shaderImageGatherExtended */
    /* skip val->shaderStorageImageExtendedFormats */
    /* skip val->shaderStorageImageMultisample */
    /* skip val->shaderStorageImageReadWithoutFormat */
    /* skip val->shaderStorageImageWriteWithoutFormat */
    /* skip val->shaderUniformBufferArrayDynamicIndexing */
    /* skip val->shaderSampledImageArrayDynamicIndexing */
    /* skip val->shaderStorageBufferArrayDynamicIndexing */
    /* skip val->shaderStorageImageArrayDynamicIndexing */
    /* skip val->shaderClipDistance */
    /* skip val->shaderCullDistance */
    /* skip val->shaderFloat64 */
    /* skip val->shaderInt64 */
    /* skip val->shaderInt16 */
    /* skip val->shaderResourceResidency */
    /* skip val->shaderResourceMinLod */
    /* skip val->sparseBinding */
    /* skip val->sparseResidencyBuffer */
    /* skip val->sparseResidencyImage2D */
    /* skip val->sparseResidencyImage3D */
    /* skip val->sparseResidency2Samples */
    /* skip val->sparseResidency4Samples */
    /* skip val->sparseResidency8Samples */
    /* skip val->sparseResidency16Samples */
    /* skip val->sparseResidencyAliased */
    /* skip val->variableMultisampleRate */
    /* skip val->inheritedQueries */
}

static inline void
vn_replace_VkPhysicalDeviceFeatures_handle(VkPhysicalDeviceFeatures *val)
{
    /* skip val->robustBufferAccess */
    /* skip val->fullDrawIndexUint32 */
    /* skip val->imageCubeArray */
    /* skip val->independentBlend */
    /* skip val->geometryShader */
    /* skip val->tessellationShader */
    /* skip val->sampleRateShading */
    /* skip val->dualSrcBlend */
    /* skip val->logicOp */
    /* skip val->multiDrawIndirect */
    /* skip val->drawIndirectFirstInstance */
    /* skip val->depthClamp */
    /* skip val->depthBiasClamp */
    /* skip val->fillModeNonSolid */
    /* skip val->depthBounds */
    /* skip val->wideLines */
    /* skip val->largePoints */
    /* skip val->alphaToOne */
    /* skip val->multiViewport */
    /* skip val->samplerAnisotropy */
    /* skip val->textureCompressionETC2 */
    /* skip val->textureCompressionASTC_LDR */
    /* skip val->textureCompressionBC */
    /* skip val->occlusionQueryPrecise */
    /* skip val->pipelineStatisticsQuery */
    /* skip val->vertexPipelineStoresAndAtomics */
    /* skip val->fragmentStoresAndAtomics */
    /* skip val->shaderTessellationAndGeometryPointSize */
    /* skip val->shaderImageGatherExtended */
    /* skip val->shaderStorageImageExtendedFormats */
    /* skip val->shaderStorageImageMultisample */
    /* skip val->shaderStorageImageReadWithoutFormat */
    /* skip val->shaderStorageImageWriteWithoutFormat */
    /* skip val->shaderUniformBufferArrayDynamicIndexing */
    /* skip val->shaderSampledImageArrayDynamicIndexing */
    /* skip val->shaderStorageBufferArrayDynamicIndexing */
    /* skip val->shaderStorageImageArrayDynamicIndexing */
    /* skip val->shaderClipDistance */
    /* skip val->shaderCullDistance */
    /* skip val->shaderFloat64 */
    /* skip val->shaderInt64 */
    /* skip val->shaderInt16 */
    /* skip val->shaderResourceResidency */
    /* skip val->shaderResourceMinLod */
    /* skip val->sparseBinding */
    /* skip val->sparseResidencyBuffer */
    /* skip val->sparseResidencyImage2D */
    /* skip val->sparseResidencyImage3D */
    /* skip val->sparseResidency2Samples */
    /* skip val->sparseResidency4Samples */
    /* skip val->sparseResidency8Samples */
    /* skip val->sparseResidency16Samples */
    /* skip val->sparseResidencyAliased */
    /* skip val->variableMultisampleRate */
    /* skip val->inheritedQueries */
}

/* struct VkFormatProperties */

static inline void
vn_encode_VkFormatProperties(struct vn_cs_encoder *enc, const VkFormatProperties *val)
{
    vn_encode_VkFlags(enc, &val->linearTilingFeatures);
    vn_encode_VkFlags(enc, &val->optimalTilingFeatures);
    vn_encode_VkFlags(enc, &val->bufferFeatures);
}

static inline void
vn_decode_VkFormatProperties_partial_temp(struct vn_cs_decoder *dec, VkFormatProperties *val)
{
    /* skip val->linearTilingFeatures */
    /* skip val->optimalTilingFeatures */
    /* skip val->bufferFeatures */
}

/* struct VkImageFormatProperties */

static inline void
vn_encode_VkImageFormatProperties(struct vn_cs_encoder *enc, const VkImageFormatProperties *val)
{
    vn_encode_VkExtent3D(enc, &val->maxExtent);
    vn_encode_uint32_t(enc, &val->maxMipLevels);
    vn_encode_uint32_t(enc, &val->maxArrayLayers);
    vn_encode_VkFlags(enc, &val->sampleCounts);
    vn_encode_VkDeviceSize(enc, &val->maxResourceSize);
}

static inline void
vn_decode_VkImageFormatProperties_partial_temp(struct vn_cs_decoder *dec, VkImageFormatProperties *val)
{
    vn_decode_VkExtent3D_partial_temp(dec, &val->maxExtent);
    /* skip val->maxMipLevels */
    /* skip val->maxArrayLayers */
    /* skip val->sampleCounts */
    /* skip val->maxResourceSize */
}

/* struct VkDeviceQueueCreateInfo chain */

static inline void *
vn_decode_VkDeviceQueueCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceQueueCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceQueueCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->queueFamilyIndex);
    vn_decode_uint32_t(dec, &val->queueCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->queueCount);
        val->pQueuePriorities = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pQueuePriorities) * array_size);
        if (!val->pQueuePriorities) return;
        vn_decode_float_array(dec, (float *)val->pQueuePriorities, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pQueuePriorities = NULL;
    }
}

static inline void
vn_decode_VkDeviceQueueCreateInfo_temp(struct vn_cs_decoder *dec, VkDeviceQueueCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceQueueCreateInfo_pnext_temp(dec);
    vn_decode_VkDeviceQueueCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceQueueCreateInfo_handle_self(VkDeviceQueueCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->queueFamilyIndex */
    /* skip val->queueCount */
    /* skip val->pQueuePriorities */
}

static inline void
vn_replace_VkDeviceQueueCreateInfo_handle(VkDeviceQueueCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO:
            vn_replace_VkDeviceQueueCreateInfo_handle_self((VkDeviceQueueCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVariablePointersFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->variablePointersStorageBuffer);
    vn_encode_VkBool32(enc, &val->variablePointers);
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES });
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->variablePointersStorageBuffer);
    vn_decode_VkBool32(dec, &val->variablePointers);
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle_self(VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
}

static inline void
vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle(VkPhysicalDeviceVariablePointersFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle_self((VkPhysicalDeviceVariablePointersFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMultiviewFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->multiview);
    vn_encode_VkBool32(enc, &val->multiviewGeometryShader);
    vn_encode_VkBool32(enc, &val->multiviewTessellationShader);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES });
    vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiviewFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->multiview);
    vn_decode_VkBool32(dec, &val->multiviewGeometryShader);
    vn_decode_VkBool32(dec, &val->multiviewTessellationShader);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMultiviewFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMultiviewFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMultiviewFeatures_handle_self(VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
}

static inline void
vn_replace_VkPhysicalDeviceMultiviewFeatures_handle(VkPhysicalDeviceMultiviewFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_replace_VkPhysicalDeviceMultiviewFeatures_handle_self((VkPhysicalDeviceMultiviewFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevice16BitStorageFeatures chain */

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant16);
    vn_encode_VkBool32(enc, &val->storageInputOutput16);
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice16BitStorageFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant16);
    vn_decode_VkBool32(dec, &val->storageInputOutput16);
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDevice16BitStorageFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevice16BitStorageFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevice16BitStorageFeatures_handle_self(VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
}

static inline void
vn_replace_VkPhysicalDevice16BitStorageFeatures_handle(VkPhysicalDevice16BitStorageFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice16BitStorageFeatures_handle_self((VkPhysicalDevice16BitStorageFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderSubgroupExtendedTypes);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES });
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderSubgroupExtendedTypes);
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupExtendedTypes */
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle_self(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderSubgroupExtendedTypes */
}

static inline void
vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle_self((VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceSamplerYcbcrConversionFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->samplerYcbcrConversion);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES });
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->samplerYcbcrConversion);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->samplerYcbcrConversion */
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle_self(VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->samplerYcbcrConversion */
}

static inline void
vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle(VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle_self((VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceProtectedMemoryFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->protectedMemory);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->protectedMemory);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->protectedMemory */
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle_self(VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->protectedMemory */
}

static inline void
vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle(VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle_self((VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderDrawParametersFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderDrawParameters);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderDrawParameters);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle_self(VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle(VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle_self((VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderFloat16Int8Features chain */

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderFloat16);
    vn_encode_VkBool32(enc, &val->shaderInt8);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES });
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderFloat16);
    vn_decode_VkBool32(dec, &val->shaderInt8);
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle_self(VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
}

static inline void
vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle(VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle_self((VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceHostQueryResetFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->hostQueryReset);
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES });
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->hostQueryReset);
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->hostQueryReset */
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle_self(VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->hostQueryReset */
}

static inline void
vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle(VkPhysicalDeviceHostQueryResetFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle_self((VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDescriptorIndexingFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_encode_VkBool32(enc, &val->descriptorBindingPartiallyBound);
    vn_encode_VkBool32(enc, &val->descriptorBindingVariableDescriptorCount);
    vn_encode_VkBool32(enc, &val->runtimeDescriptorArray);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES });
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_decode_VkBool32(dec, &val->descriptorBindingPartiallyBound);
    vn_decode_VkBool32(dec, &val->descriptorBindingVariableDescriptorCount);
    vn_decode_VkBool32(dec, &val->runtimeDescriptorArray);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle_self(VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
}

static inline void
vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle(VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle_self((VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceTimelineSemaphoreFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->timelineSemaphore);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES });
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->timelineSemaphore);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->timelineSemaphore */
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle_self(VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->timelineSemaphore */
}

static inline void
vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle(VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle_self((VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevice8BitStorageFeatures chain */

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant8);
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice8BitStorageFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant8);
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDevice8BitStorageFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevice8BitStorageFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevice8BitStorageFeatures_handle_self(VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
}

static inline void
vn_replace_VkPhysicalDevice8BitStorageFeatures_handle(VkPhysicalDevice8BitStorageFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice8BitStorageFeatures_handle_self((VkPhysicalDevice8BitStorageFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVulkanMemoryModelFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->vulkanMemoryModel);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelDeviceScope);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelAvailabilityVisibilityChains);
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES });
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->vulkanMemoryModel);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelDeviceScope);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelAvailabilityVisibilityChains);
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle_self(VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
}

static inline void
vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle(VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle_self((VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderAtomicInt64Features chain */

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderBufferInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedInt64Atomics);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES });
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderBufferInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedInt64Atomics);
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle_self(VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
}

static inline void
vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle(VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle_self((VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceTransformFeedbackFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->transformFeedback);
    vn_encode_VkBool32(enc, &val->geometryStreams);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->transformFeedback);
    vn_decode_VkBool32(dec, &val->geometryStreams);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->transformFeedback */
    /* skip val->geometryStreams */
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle_self(VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->transformFeedback */
    /* skip val->geometryStreams */
}

static inline void
vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle(VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle_self((VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceScalarBlockLayoutFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->scalarBlockLayout);
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->scalarBlockLayout);
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->scalarBlockLayout */
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle_self(VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->scalarBlockLayout */
}

static inline void
vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle(VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle_self((VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->uniformBufferStandardLayout);
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->uniformBufferStandardLayout);
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->uniformBufferStandardLayout */
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle_self(VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->uniformBufferStandardLayout */
}

static inline void
vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle(VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle_self((VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceBufferDeviceAddressFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->bufferDeviceAddress);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressCaptureReplay);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressMultiDevice);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES });
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->bufferDeviceAddress);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressCaptureReplay);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressMultiDevice);
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle_self(VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
}

static inline void
vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle(VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle_self((VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImagelessFramebufferFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->imagelessFramebuffer);
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES });
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->imagelessFramebuffer);
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->imagelessFramebuffer */
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle_self(VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->imagelessFramebuffer */
}

static inline void
vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle(VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle_self((VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->separateDepthStencilLayouts);
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES });
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->separateDepthStencilLayouts);
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->separateDepthStencilLayouts */
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle_self(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->separateDepthStencilLayouts */
}

static inline void
vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle_self((VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVulkan11Features chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant16);
    vn_encode_VkBool32(enc, &val->storageInputOutput16);
    vn_encode_VkBool32(enc, &val->multiview);
    vn_encode_VkBool32(enc, &val->multiviewGeometryShader);
    vn_encode_VkBool32(enc, &val->multiviewTessellationShader);
    vn_encode_VkBool32(enc, &val->variablePointersStorageBuffer);
    vn_encode_VkBool32(enc, &val->variablePointers);
    vn_encode_VkBool32(enc, &val->protectedMemory);
    vn_encode_VkBool32(enc, &val->samplerYcbcrConversion);
    vn_encode_VkBool32(enc, &val->shaderDrawParameters);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan11Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan11Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan11Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant16);
    vn_decode_VkBool32(dec, &val->storageInputOutput16);
    vn_decode_VkBool32(dec, &val->multiview);
    vn_decode_VkBool32(dec, &val->multiviewGeometryShader);
    vn_decode_VkBool32(dec, &val->multiviewTessellationShader);
    vn_decode_VkBool32(dec, &val->variablePointersStorageBuffer);
    vn_decode_VkBool32(dec, &val->variablePointers);
    vn_decode_VkBool32(dec, &val->protectedMemory);
    vn_decode_VkBool32(dec, &val->samplerYcbcrConversion);
    vn_decode_VkBool32(dec, &val->shaderDrawParameters);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan11Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan11Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan11Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
    /* skip val->protectedMemory */
    /* skip val->samplerYcbcrConversion */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan11Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan11Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVulkan11Features_handle_self(VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
    /* skip val->protectedMemory */
    /* skip val->samplerYcbcrConversion */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_replace_VkPhysicalDeviceVulkan11Features_handle(VkPhysicalDeviceVulkan11Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan11Features_handle_self((VkPhysicalDeviceVulkan11Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVulkan12Features chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->samplerMirrorClampToEdge);
    vn_encode_VkBool32(enc, &val->drawIndirectCount);
    vn_encode_VkBool32(enc, &val->storageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant8);
    vn_encode_VkBool32(enc, &val->shaderBufferInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderFloat16);
    vn_encode_VkBool32(enc, &val->shaderInt8);
    vn_encode_VkBool32(enc, &val->descriptorIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_encode_VkBool32(enc, &val->descriptorBindingPartiallyBound);
    vn_encode_VkBool32(enc, &val->descriptorBindingVariableDescriptorCount);
    vn_encode_VkBool32(enc, &val->runtimeDescriptorArray);
    vn_encode_VkBool32(enc, &val->samplerFilterMinmax);
    vn_encode_VkBool32(enc, &val->scalarBlockLayout);
    vn_encode_VkBool32(enc, &val->imagelessFramebuffer);
    vn_encode_VkBool32(enc, &val->uniformBufferStandardLayout);
    vn_encode_VkBool32(enc, &val->shaderSubgroupExtendedTypes);
    vn_encode_VkBool32(enc, &val->separateDepthStencilLayouts);
    vn_encode_VkBool32(enc, &val->hostQueryReset);
    vn_encode_VkBool32(enc, &val->timelineSemaphore);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddress);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressCaptureReplay);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressMultiDevice);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModel);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelDeviceScope);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelAvailabilityVisibilityChains);
    vn_encode_VkBool32(enc, &val->shaderOutputViewportIndex);
    vn_encode_VkBool32(enc, &val->shaderOutputLayer);
    vn_encode_VkBool32(enc, &val->subgroupBroadcastDynamicId);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan12Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan12Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan12Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->samplerMirrorClampToEdge);
    vn_decode_VkBool32(dec, &val->drawIndirectCount);
    vn_decode_VkBool32(dec, &val->storageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant8);
    vn_decode_VkBool32(dec, &val->shaderBufferInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderFloat16);
    vn_decode_VkBool32(dec, &val->shaderInt8);
    vn_decode_VkBool32(dec, &val->descriptorIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_decode_VkBool32(dec, &val->descriptorBindingPartiallyBound);
    vn_decode_VkBool32(dec, &val->descriptorBindingVariableDescriptorCount);
    vn_decode_VkBool32(dec, &val->runtimeDescriptorArray);
    vn_decode_VkBool32(dec, &val->samplerFilterMinmax);
    vn_decode_VkBool32(dec, &val->scalarBlockLayout);
    vn_decode_VkBool32(dec, &val->imagelessFramebuffer);
    vn_decode_VkBool32(dec, &val->uniformBufferStandardLayout);
    vn_decode_VkBool32(dec, &val->shaderSubgroupExtendedTypes);
    vn_decode_VkBool32(dec, &val->separateDepthStencilLayouts);
    vn_decode_VkBool32(dec, &val->hostQueryReset);
    vn_decode_VkBool32(dec, &val->timelineSemaphore);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddress);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressCaptureReplay);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressMultiDevice);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModel);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelDeviceScope);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelAvailabilityVisibilityChains);
    vn_decode_VkBool32(dec, &val->shaderOutputViewportIndex);
    vn_decode_VkBool32(dec, &val->shaderOutputLayer);
    vn_decode_VkBool32(dec, &val->subgroupBroadcastDynamicId);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan12Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan12Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan12Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->samplerMirrorClampToEdge */
    /* skip val->drawIndirectCount */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
    /* skip val->descriptorIndexing */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
    /* skip val->samplerFilterMinmax */
    /* skip val->scalarBlockLayout */
    /* skip val->imagelessFramebuffer */
    /* skip val->uniformBufferStandardLayout */
    /* skip val->shaderSubgroupExtendedTypes */
    /* skip val->separateDepthStencilLayouts */
    /* skip val->hostQueryReset */
    /* skip val->timelineSemaphore */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
    /* skip val->shaderOutputViewportIndex */
    /* skip val->shaderOutputLayer */
    /* skip val->subgroupBroadcastDynamicId */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan12Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan12Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVulkan12Features_handle_self(VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->samplerMirrorClampToEdge */
    /* skip val->drawIndirectCount */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
    /* skip val->descriptorIndexing */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
    /* skip val->samplerFilterMinmax */
    /* skip val->scalarBlockLayout */
    /* skip val->imagelessFramebuffer */
    /* skip val->uniformBufferStandardLayout */
    /* skip val->shaderSubgroupExtendedTypes */
    /* skip val->separateDepthStencilLayouts */
    /* skip val->hostQueryReset */
    /* skip val->timelineSemaphore */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
    /* skip val->shaderOutputViewportIndex */
    /* skip val->shaderOutputLayer */
    /* skip val->subgroupBroadcastDynamicId */
}

static inline void
vn_replace_VkPhysicalDeviceVulkan12Features_handle(VkPhysicalDeviceVulkan12Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan12Features_handle_self((VkPhysicalDeviceVulkan12Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceFeatures2 chain */

static inline void
vn_encode_VkPhysicalDeviceFeatures2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(enc, (const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewFeatures_self(enc, (const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice16BitStorageFeatures_self(enc, (const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(enc, (const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(enc, (const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(enc, (const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(enc, (const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(enc, (const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(enc, (const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(enc, (const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(enc, (const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice8BitStorageFeatures_self(enc, (const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(enc, (const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(enc, (const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(enc, (const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(enc, (const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(enc, (const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(enc, (const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(enc, (const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(enc, (const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Features_self(enc, (const VkPhysicalDeviceVulkan11Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Features_self(enc, (const VkPhysicalDeviceVulkan12Features *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceFeatures(enc, &val->features);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2 });
    vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFeatures2_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVariablePointersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_temp(dec, (VkPhysicalDeviceVariablePointersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiviewFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMultiviewFeatures_self_temp(dec, (VkPhysicalDeviceMultiviewFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice16BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevice16BitStorageFeatures_self_temp(dec, (VkPhysicalDevice16BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_temp(dec, (VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSamplerYcbcrConversionFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_temp(dec, (VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProtectedMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_temp(dec, (VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDrawParametersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_temp(dec, (VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderFloat16Int8Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_temp(dec, (VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceHostQueryResetFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_temp(dec, (VkPhysicalDeviceHostQueryResetFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDescriptorIndexingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_temp(dec, (VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTimelineSemaphoreFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_temp(dec, (VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice8BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevice8BitStorageFeatures_self_temp(dec, (VkPhysicalDevice8BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkanMemoryModelFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_temp(dec, (VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicInt64Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_temp(dec, (VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTransformFeedbackFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_temp(dec, (VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceScalarBlockLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_temp(dec, (VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceUniformBufferStandardLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_temp(dec, (VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBufferDeviceAddressFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_temp(dec, (VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImagelessFramebufferFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_temp(dec, (VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_temp(dec, (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan11Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan11Features_self_temp(dec, (VkPhysicalDeviceVulkan11Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan12Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan12Features_self_temp(dec, (VkPhysicalDeviceVulkan12Features *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceFeatures_temp(dec, &val->features);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceFeatures2_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVariablePointersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_partial_temp(dec, (VkPhysicalDeviceVariablePointersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiviewFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMultiviewFeatures_self_partial_temp(dec, (VkPhysicalDeviceMultiviewFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice16BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevice16BitStorageFeatures_self_partial_temp(dec, (VkPhysicalDevice16BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSamplerYcbcrConversionFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial_temp(dec, (VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProtectedMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial_temp(dec, (VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDrawParametersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderFloat16Int8Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial_temp(dec, (VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceHostQueryResetFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_partial_temp(dec, (VkPhysicalDeviceHostQueryResetFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDescriptorIndexingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial_temp(dec, (VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTimelineSemaphoreFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial_temp(dec, (VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice8BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevice8BitStorageFeatures_self_partial_temp(dec, (VkPhysicalDevice8BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkanMemoryModelFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial_temp(dec, (VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicInt64Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial_temp(dec, (VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTransformFeedbackFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceScalarBlockLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial_temp(dec, (VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceUniformBufferStandardLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial_temp(dec, (VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBufferDeviceAddressFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial_temp(dec, (VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImagelessFramebufferFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial_temp(dec, (VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial_temp(dec, (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan11Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan11Features_self_partial_temp(dec, (VkPhysicalDeviceVulkan11Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan12Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan12Features_self_partial_temp(dec, (VkPhysicalDeviceVulkan12Features *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceFeatures_partial_temp(dec, &val->features);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceFeatures2_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceFeatures2_handle_self(VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkPhysicalDeviceFeatures_handle(&val->features);
}

static inline void
vn_replace_VkPhysicalDeviceFeatures2_handle(VkPhysicalDeviceFeatures2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
            vn_replace_VkPhysicalDeviceFeatures2_handle_self((VkPhysicalDeviceFeatures2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle_self((VkPhysicalDeviceVariablePointersFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_replace_VkPhysicalDeviceMultiviewFeatures_handle_self((VkPhysicalDeviceMultiviewFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice16BitStorageFeatures_handle_self((VkPhysicalDevice16BitStorageFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle_self((VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle_self((VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle_self((VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle_self((VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle_self((VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle_self((VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle_self((VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle_self((VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice8BitStorageFeatures_handle_self((VkPhysicalDevice8BitStorageFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle_self((VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle_self((VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle_self((VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle_self((VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle_self((VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle_self((VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle_self((VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle_self((VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan11Features_handle_self((VkPhysicalDeviceVulkan11Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan12Features_handle_self((VkPhysicalDeviceVulkan12Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDeviceGroupDeviceCreateInfo chain */

static inline void *
vn_decode_VkDeviceGroupDeviceCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceGroupDeviceCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceGroupDeviceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->physicalDeviceCount);
    if (vn_peek_array_size(dec)) {
        val->pPhysicalDevices = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pPhysicalDevices) * val->physicalDeviceCount);
        if (!val->pPhysicalDevices) return;
        vn_decode_array_size(dec, val->physicalDeviceCount);
        for (uint32_t i = 0; i < val->physicalDeviceCount; i++)
            vn_decode_VkPhysicalDevice_lookup(dec, &((VkPhysicalDevice *)val->pPhysicalDevices)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pPhysicalDevices = NULL;
    }
}

static inline void
vn_decode_VkDeviceGroupDeviceCreateInfo_temp(struct vn_cs_decoder *dec, VkDeviceGroupDeviceCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceGroupDeviceCreateInfo_pnext_temp(dec);
    vn_decode_VkDeviceGroupDeviceCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceGroupDeviceCreateInfo_handle_self(VkDeviceGroupDeviceCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->physicalDeviceCount */
    if (val->pPhysicalDevices) {
       for (uint32_t i = 0; i < val->physicalDeviceCount; i++)
            vn_replace_VkPhysicalDevice_handle(&((VkPhysicalDevice *)val->pPhysicalDevices)[i]);
    }
}

static inline void
vn_replace_VkDeviceGroupDeviceCreateInfo_handle(VkDeviceGroupDeviceCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
            vn_replace_VkDeviceGroupDeviceCreateInfo_handle_self((VkDeviceGroupDeviceCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDeviceCreateInfo chain */

static inline void *
vn_decode_VkDeviceCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFeatures2));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceFeatures2_self_temp(dec, (VkPhysicalDeviceFeatures2 *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVariablePointersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_temp(dec, (VkPhysicalDeviceVariablePointersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiviewFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMultiviewFeatures_self_temp(dec, (VkPhysicalDeviceMultiviewFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDeviceGroupDeviceCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkDeviceGroupDeviceCreateInfo_self_temp(dec, (VkDeviceGroupDeviceCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice16BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevice16BitStorageFeatures_self_temp(dec, (VkPhysicalDevice16BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_temp(dec, (VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSamplerYcbcrConversionFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_temp(dec, (VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProtectedMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_temp(dec, (VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDrawParametersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_temp(dec, (VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderFloat16Int8Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_temp(dec, (VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceHostQueryResetFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_temp(dec, (VkPhysicalDeviceHostQueryResetFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDescriptorIndexingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_temp(dec, (VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTimelineSemaphoreFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_temp(dec, (VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice8BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevice8BitStorageFeatures_self_temp(dec, (VkPhysicalDevice8BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkanMemoryModelFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_temp(dec, (VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicInt64Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_temp(dec, (VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTransformFeedbackFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_temp(dec, (VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceScalarBlockLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_temp(dec, (VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceUniformBufferStandardLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_temp(dec, (VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBufferDeviceAddressFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_temp(dec, (VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImagelessFramebufferFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_temp(dec, (VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_temp(dec, (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan11Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan11Features_self_temp(dec, (VkPhysicalDeviceVulkan11Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan12Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan12Features_self_temp(dec, (VkPhysicalDeviceVulkan12Features *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkDeviceCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->queueCreateInfoCount);
    if (vn_peek_array_size(dec)) {
        val->pQueueCreateInfos = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pQueueCreateInfos) * val->queueCreateInfoCount);
        if (!val->pQueueCreateInfos) return;
        vn_decode_array_size(dec, val->queueCreateInfoCount);
        for (uint32_t i = 0; i < val->queueCreateInfoCount; i++)
            vn_decode_VkDeviceQueueCreateInfo_temp(dec, &((VkDeviceQueueCreateInfo *)val->pQueueCreateInfos)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pQueueCreateInfos = NULL;
    }
    vn_decode_uint32_t(dec, &val->enabledLayerCount);
    if (vn_peek_array_size(dec)) {
        val->ppEnabledLayerNames = vn_cs_decoder_alloc_temp(dec, sizeof(*val->ppEnabledLayerNames) * val->enabledLayerCount);
        if (!val->ppEnabledLayerNames) return;
        vn_decode_array_size(dec, val->enabledLayerCount);
        for (uint32_t i = 0; i < val->enabledLayerCount; i++) {
            const size_t string_size = vn_decode_array_size(dec, UINT64_MAX);
            ((char **)val->ppEnabledLayerNames)[i] = vn_cs_decoder_alloc_temp(dec, sizeof(*val->ppEnabledLayerNames[i]) * string_size);
            if (!val->ppEnabledLayerNames[i]) return;
            vn_decode_blob_array(dec, ((char **)val->ppEnabledLayerNames)[i], string_size);
        }
    } else {
        vn_decode_array_size(dec, 0);
        val->ppEnabledLayerNames = NULL;
    }
    vn_decode_uint32_t(dec, &val->enabledExtensionCount);
    if (vn_peek_array_size(dec)) {
        val->ppEnabledExtensionNames = vn_cs_decoder_alloc_temp(dec, sizeof(*val->ppEnabledExtensionNames) * val->enabledExtensionCount);
        if (!val->ppEnabledExtensionNames) return;
        vn_decode_array_size(dec, val->enabledExtensionCount);
        for (uint32_t i = 0; i < val->enabledExtensionCount; i++) {
            const size_t string_size = vn_decode_array_size(dec, UINT64_MAX);
            ((char **)val->ppEnabledExtensionNames)[i] = vn_cs_decoder_alloc_temp(dec, sizeof(*val->ppEnabledExtensionNames[i]) * string_size);
            if (!val->ppEnabledExtensionNames[i]) return;
            vn_decode_blob_array(dec, ((char **)val->ppEnabledExtensionNames)[i], string_size);
        }
    } else {
        vn_decode_array_size(dec, 0);
        val->ppEnabledExtensionNames = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pEnabledFeatures = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pEnabledFeatures));
        if (!val->pEnabledFeatures) return;
        vn_decode_VkPhysicalDeviceFeatures_temp(dec, (VkPhysicalDeviceFeatures *)val->pEnabledFeatures);
    } else {
        val->pEnabledFeatures = NULL;
    }
}

static inline void
vn_decode_VkDeviceCreateInfo_temp(struct vn_cs_decoder *dec, VkDeviceCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
    vn_decode_VkDeviceCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceCreateInfo_handle_self(VkDeviceCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->queueCreateInfoCount */
    if (val->pQueueCreateInfos) {
       for (uint32_t i = 0; i < val->queueCreateInfoCount; i++)
            vn_replace_VkDeviceQueueCreateInfo_handle(&((VkDeviceQueueCreateInfo *)val->pQueueCreateInfos)[i]);
    }
    /* skip val->enabledLayerCount */
    /* skip val->ppEnabledLayerNames */
    /* skip val->enabledExtensionCount */
    /* skip val->ppEnabledExtensionNames */
    if (val->pEnabledFeatures)
        vn_replace_VkPhysicalDeviceFeatures_handle((VkPhysicalDeviceFeatures *)val->pEnabledFeatures);
}

static inline void
vn_replace_VkDeviceCreateInfo_handle(VkDeviceCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO:
            vn_replace_VkDeviceCreateInfo_handle_self((VkDeviceCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
            vn_replace_VkPhysicalDeviceFeatures2_handle_self((VkPhysicalDeviceFeatures2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle_self((VkPhysicalDeviceVariablePointersFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_replace_VkPhysicalDeviceMultiviewFeatures_handle_self((VkPhysicalDeviceMultiviewFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
            vn_replace_VkDeviceGroupDeviceCreateInfo_handle_self((VkDeviceGroupDeviceCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice16BitStorageFeatures_handle_self((VkPhysicalDevice16BitStorageFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle_self((VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle_self((VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle_self((VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle_self((VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle_self((VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle_self((VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle_self((VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle_self((VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice8BitStorageFeatures_handle_self((VkPhysicalDevice8BitStorageFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle_self((VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle_self((VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle_self((VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle_self((VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle_self((VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle_self((VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle_self((VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle_self((VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan11Features_handle_self((VkPhysicalDeviceVulkan11Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan12Features_handle_self((VkPhysicalDeviceVulkan12Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkConformanceVersion */

static inline void
vn_encode_VkConformanceVersion(struct vn_cs_encoder *enc, const VkConformanceVersion *val)
{
    vn_encode_uint8_t(enc, &val->major);
    vn_encode_uint8_t(enc, &val->minor);
    vn_encode_uint8_t(enc, &val->subminor);
    vn_encode_uint8_t(enc, &val->patch);
}

static inline void
vn_decode_VkConformanceVersion_partial_temp(struct vn_cs_decoder *dec, VkConformanceVersion *val)
{
    /* skip val->major */
    /* skip val->minor */
    /* skip val->subminor */
    /* skip val->patch */
}

/* struct VkPhysicalDeviceDriverProperties chain */

static inline void
vn_encode_VkPhysicalDeviceDriverProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDriverProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDriverProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDriverId(enc, &val->driverID);
    vn_encode_array_size(enc, VK_MAX_DRIVER_NAME_SIZE);
    vn_encode_blob_array(enc, val->driverName, VK_MAX_DRIVER_NAME_SIZE);
    vn_encode_array_size(enc, VK_MAX_DRIVER_INFO_SIZE);
    vn_encode_blob_array(enc, val->driverInfo, VK_MAX_DRIVER_INFO_SIZE);
    vn_encode_VkConformanceVersion(enc, &val->conformanceVersion);
}

static inline void
vn_encode_VkPhysicalDeviceDriverProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceDriverProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES });
    vn_encode_VkPhysicalDeviceDriverProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDriverProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDriverProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDriverProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDriverProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    vn_decode_VkConformanceVersion_partial_temp(dec, &val->conformanceVersion);
}

static inline void
vn_decode_VkPhysicalDeviceDriverProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDriverProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDriverProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDriverProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceIDProperties chain */

static inline void
vn_encode_VkPhysicalDeviceIDProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceIDProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceIDProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->deviceUUID, VK_UUID_SIZE);
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->driverUUID, VK_UUID_SIZE);
    vn_encode_array_size(enc, VK_LUID_SIZE);
    vn_encode_uint8_t_array(enc, val->deviceLUID, VK_LUID_SIZE);
    vn_encode_uint32_t(enc, &val->deviceNodeMask);
    vn_encode_VkBool32(enc, &val->deviceLUIDValid);
}

static inline void
vn_encode_VkPhysicalDeviceIDProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceIDProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES });
    vn_encode_VkPhysicalDeviceIDProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceIDProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceIDProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceIDProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIDProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
}

static inline void
vn_decode_VkPhysicalDeviceIDProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIDProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceIDProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceIDProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMultiviewProperties chain */

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxMultiviewViewCount);
    vn_encode_uint32_t(enc, &val->maxMultiviewInstanceIndex);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES });
    vn_encode_VkPhysicalDeviceMultiviewProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiviewProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiviewProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiviewProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMultiviewProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceSubgroupProperties chain */

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->subgroupSize);
    vn_encode_VkFlags(enc, &val->supportedStages);
    vn_encode_VkFlags(enc, &val->supportedOperations);
    vn_encode_VkBool32(enc, &val->quadOperationsInAllStages);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES });
    vn_encode_VkPhysicalDeviceSubgroupProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSubgroupProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSize */
    /* skip val->supportedStages */
    /* skip val->supportedOperations */
    /* skip val->quadOperationsInAllStages */
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSubgroupProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSubgroupProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDevicePointClippingProperties chain */

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePointClippingProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPointClippingBehavior(enc, &val->pointClippingBehavior);
}

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties(struct vn_cs_encoder *enc, const VkPhysicalDevicePointClippingProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES });
    vn_encode_VkPhysicalDevicePointClippingProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePointClippingProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePointClippingProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePointClippingProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePointClippingProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pointClippingBehavior */
}

static inline void
vn_decode_VkPhysicalDevicePointClippingProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePointClippingProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePointClippingProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePointClippingProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceProtectedMemoryProperties chain */

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->protectedNoFault);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES });
    vn_encode_VkPhysicalDeviceProtectedMemoryProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->protectedNoFault */
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceSamplerFilterMinmaxProperties chain */

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->filterMinmaxSingleComponentFormats);
    vn_encode_VkBool32(enc, &val->filterMinmaxImageComponentMapping);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES });
    vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
}

static inline void
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMaintenance3Properties chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance3Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxPerSetDescriptors);
    vn_encode_VkDeviceSize(enc, &val->maxMemoryAllocationSize);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance3Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES });
    vn_encode_VkPhysicalDeviceMaintenance3Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance3Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance3Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance3Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance3Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance3Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance3Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance3Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance3Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceFloatControlsProperties chain */

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFloatControlsProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkShaderFloatControlsIndependence(enc, &val->denormBehaviorIndependence);
    vn_encode_VkShaderFloatControlsIndependence(enc, &val->roundingModeIndependence);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat16);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat32);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat64);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat16);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat32);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat64);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat16);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat32);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat64);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat16);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat32);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat64);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat16);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat32);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat64);
}

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceFloatControlsProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES });
    vn_encode_VkPhysicalDeviceFloatControlsProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFloatControlsProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFloatControlsProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFloatControlsProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFloatControlsProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
}

static inline void
vn_decode_VkPhysicalDeviceFloatControlsProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFloatControlsProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFloatControlsProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceFloatControlsProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceDescriptorIndexingProperties chain */

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxUpdateAfterBindDescriptorsInAllPools);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->robustBufferAccessUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->quadDivergentImplicitLod);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindSamplers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    vn_encode_uint32_t(enc, &val->maxPerStageUpdateAfterBindResources);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindSamplers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindSampledImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindInputAttachments);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES });
    vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceTimelineSemaphoreProperties chain */

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint64_t(enc, &val->maxTimelineSemaphoreValueDifference);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES });
    vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxTimelineSemaphoreValueDifference */
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceDepthStencilResolveProperties chain */

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->supportedDepthResolveModes);
    vn_encode_VkFlags(enc, &val->supportedStencilResolveModes);
    vn_encode_VkBool32(enc, &val->independentResolveNone);
    vn_encode_VkBool32(enc, &val->independentResolve);
}

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES });
    vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
}

static inline void
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceTransformFeedbackPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackStreams);
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackBuffers);
    vn_encode_VkDeviceSize(enc, &val->maxTransformFeedbackBufferSize);
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackStreamDataSize);
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackBufferDataSize);
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackBufferDataStride);
    vn_encode_VkBool32(enc, &val->transformFeedbackQueries);
    vn_encode_VkBool32(enc, &val->transformFeedbackStreamsLinesTriangles);
    vn_encode_VkBool32(enc, &val->transformFeedbackRasterizationStreamSelect);
    vn_encode_VkBool32(enc, &val->transformFeedbackDraw);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxTransformFeedbackStreams */
    /* skip val->maxTransformFeedbackBuffers */
    /* skip val->maxTransformFeedbackBufferSize */
    /* skip val->maxTransformFeedbackStreamDataSize */
    /* skip val->maxTransformFeedbackBufferDataSize */
    /* skip val->maxTransformFeedbackBufferDataStride */
    /* skip val->transformFeedbackQueries */
    /* skip val->transformFeedbackStreamsLinesTriangles */
    /* skip val->transformFeedbackRasterizationStreamSelect */
    /* skip val->transformFeedbackDraw */
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceVulkan11Properties chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->deviceUUID, VK_UUID_SIZE);
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->driverUUID, VK_UUID_SIZE);
    vn_encode_array_size(enc, VK_LUID_SIZE);
    vn_encode_uint8_t_array(enc, val->deviceLUID, VK_LUID_SIZE);
    vn_encode_uint32_t(enc, &val->deviceNodeMask);
    vn_encode_VkBool32(enc, &val->deviceLUIDValid);
    vn_encode_uint32_t(enc, &val->subgroupSize);
    vn_encode_VkFlags(enc, &val->subgroupSupportedStages);
    vn_encode_VkFlags(enc, &val->subgroupSupportedOperations);
    vn_encode_VkBool32(enc, &val->subgroupQuadOperationsInAllStages);
    vn_encode_VkPointClippingBehavior(enc, &val->pointClippingBehavior);
    vn_encode_uint32_t(enc, &val->maxMultiviewViewCount);
    vn_encode_uint32_t(enc, &val->maxMultiviewInstanceIndex);
    vn_encode_VkBool32(enc, &val->protectedNoFault);
    vn_encode_uint32_t(enc, &val->maxPerSetDescriptors);
    vn_encode_VkDeviceSize(enc, &val->maxMemoryAllocationSize);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan11Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan11Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan11Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
    /* skip val->subgroupSize */
    /* skip val->subgroupSupportedStages */
    /* skip val->subgroupSupportedOperations */
    /* skip val->subgroupQuadOperationsInAllStages */
    /* skip val->pointClippingBehavior */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
    /* skip val->protectedNoFault */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan11Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan11Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceVulkan12Properties chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDriverId(enc, &val->driverID);
    vn_encode_array_size(enc, VK_MAX_DRIVER_NAME_SIZE);
    vn_encode_blob_array(enc, val->driverName, VK_MAX_DRIVER_NAME_SIZE);
    vn_encode_array_size(enc, VK_MAX_DRIVER_INFO_SIZE);
    vn_encode_blob_array(enc, val->driverInfo, VK_MAX_DRIVER_INFO_SIZE);
    vn_encode_VkConformanceVersion(enc, &val->conformanceVersion);
    vn_encode_VkShaderFloatControlsIndependence(enc, &val->denormBehaviorIndependence);
    vn_encode_VkShaderFloatControlsIndependence(enc, &val->roundingModeIndependence);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat16);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat32);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat64);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat16);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat32);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat64);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat16);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat32);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat64);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat16);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat32);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat64);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat16);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat32);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat64);
    vn_encode_uint32_t(enc, &val->maxUpdateAfterBindDescriptorsInAllPools);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->robustBufferAccessUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->quadDivergentImplicitLod);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindSamplers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    vn_encode_uint32_t(enc, &val->maxPerStageUpdateAfterBindResources);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindSamplers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindSampledImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindInputAttachments);
    vn_encode_VkFlags(enc, &val->supportedDepthResolveModes);
    vn_encode_VkFlags(enc, &val->supportedStencilResolveModes);
    vn_encode_VkBool32(enc, &val->independentResolveNone);
    vn_encode_VkBool32(enc, &val->independentResolve);
    vn_encode_VkBool32(enc, &val->filterMinmaxSingleComponentFormats);
    vn_encode_VkBool32(enc, &val->filterMinmaxImageComponentMapping);
    vn_encode_uint64_t(enc, &val->maxTimelineSemaphoreValueDifference);
    vn_encode_VkFlags(enc, &val->framebufferIntegerColorSampleCounts);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan12Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan12Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan12Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    vn_decode_VkConformanceVersion_partial_temp(dec, &val->conformanceVersion);
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
    /* skip val->maxTimelineSemaphoreValueDifference */
    /* skip val->framebufferIntegerColorSampleCounts */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan12Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan12Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceProperties2 chain */

static inline void
vn_encode_VkPhysicalDeviceProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDriverProperties_self(enc, (const VkPhysicalDeviceDriverProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceIDProperties_self(enc, (const VkPhysicalDeviceIDProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewProperties_self(enc, (const VkPhysicalDeviceMultiviewProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupProperties_self(enc, (const VkPhysicalDeviceSubgroupProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePointClippingProperties_self(enc, (const VkPhysicalDevicePointClippingProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self(enc, (const VkPhysicalDeviceProtectedMemoryProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(enc, (const VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance3Properties_self(enc, (const VkPhysicalDeviceMaintenance3Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFloatControlsProperties_self(enc, (const VkPhysicalDeviceFloatControlsProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self(enc, (const VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self(enc, (const VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self(enc, (const VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(enc, (const VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Properties_self(enc, (const VkPhysicalDeviceVulkan11Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Properties_self(enc, (const VkPhysicalDeviceVulkan12Properties *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProperties2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceProperties(enc, &val->properties);
}

static inline void
vn_encode_VkPhysicalDeviceProperties2(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2 });
    vn_encode_VkPhysicalDeviceProperties2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProperties2_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDriverProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDriverProperties_self_partial_temp(dec, (VkPhysicalDeviceDriverProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceIDProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceIDProperties_self_partial_temp(dec, (VkPhysicalDeviceIDProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiviewProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMultiviewProperties_self_partial_temp(dec, (VkPhysicalDeviceMultiviewProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSubgroupProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSubgroupProperties_self_partial_temp(dec, (VkPhysicalDeviceSubgroupProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePointClippingProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePointClippingProperties_self_partial_temp(dec, (VkPhysicalDevicePointClippingProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProtectedMemoryProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self_partial_temp(dec, (VkPhysicalDeviceProtectedMemoryProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSamplerFilterMinmaxProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial_temp(dec, (VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance3Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance3Properties_self_partial_temp(dec, (VkPhysicalDeviceMaintenance3Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFloatControlsProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceFloatControlsProperties_self_partial_temp(dec, (VkPhysicalDeviceFloatControlsProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDescriptorIndexingProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial_temp(dec, (VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTimelineSemaphoreProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial_temp(dec, (VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthStencilResolveProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial_temp(dec, (VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTransformFeedbackPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan11Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan11Properties_self_partial_temp(dec, (VkPhysicalDeviceVulkan11Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan12Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan12Properties_self_partial_temp(dec, (VkPhysicalDeviceVulkan12Properties *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceProperties2_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceProperties_partial_temp(dec, &val->properties);
}

static inline void
vn_decode_VkPhysicalDeviceProperties2_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceProperties2_self_partial_temp(dec, val);
}

/* struct VkDrmFormatModifierPropertiesEXT */

static inline void
vn_encode_VkDrmFormatModifierPropertiesEXT(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesEXT *val)
{
    vn_encode_uint64_t(enc, &val->drmFormatModifier);
    vn_encode_uint32_t(enc, &val->drmFormatModifierPlaneCount);
    vn_encode_VkFlags(enc, &val->drmFormatModifierTilingFeatures);
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesEXT *val)
{
    /* skip val->drmFormatModifier */
    /* skip val->drmFormatModifierPlaneCount */
    /* skip val->drmFormatModifierTilingFeatures */
}

/* struct VkDrmFormatModifierPropertiesListEXT chain */

static inline void
vn_encode_VkDrmFormatModifierPropertiesListEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesListEXT_self(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesListEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->drmFormatModifierCount);
    if (val->pDrmFormatModifierProperties) {
        vn_encode_array_size(enc, val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            vn_encode_VkDrmFormatModifierPropertiesEXT(enc, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesListEXT(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesListEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT });
    vn_encode_VkDrmFormatModifierPropertiesListEXT_pnext(enc, val->pNext);
    vn_encode_VkDrmFormatModifierPropertiesListEXT_self(enc, val);
}

static inline void *
vn_decode_VkDrmFormatModifierPropertiesListEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesListEXT_self_partial_temp(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesListEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->drmFormatModifierCount */
    if (vn_peek_array_size(dec)) {
        val->pDrmFormatModifierProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDrmFormatModifierProperties) * val->drmFormatModifierCount);
        if (!val->pDrmFormatModifierProperties) return;
        vn_decode_array_size(dec, val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            vn_decode_VkDrmFormatModifierPropertiesEXT_partial_temp(dec, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pDrmFormatModifierProperties = NULL;
    }
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesListEXT_partial_temp(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesListEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT);

    val->sType = stype;
    val->pNext = vn_decode_VkDrmFormatModifierPropertiesListEXT_pnext_partial_temp(dec);
    vn_decode_VkDrmFormatModifierPropertiesListEXT_self_partial_temp(dec, val);
}

/* struct VkFormatProperties2 chain */

static inline void
vn_encode_VkFormatProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkFormatProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkDrmFormatModifierPropertiesListEXT_self(enc, (const VkDrmFormatModifierPropertiesListEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkFormatProperties2_self(struct vn_cs_encoder *enc, const VkFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFormatProperties(enc, &val->formatProperties);
}

static inline void
vn_encode_VkFormatProperties2(struct vn_cs_encoder *enc, const VkFormatProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2 });
    vn_encode_VkFormatProperties2_pnext(enc, val->pNext);
    vn_encode_VkFormatProperties2_self(enc, val);
}

static inline void *
vn_decode_VkFormatProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDrmFormatModifierPropertiesListEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkFormatProperties2_pnext_partial_temp(dec);
            vn_decode_VkDrmFormatModifierPropertiesListEXT_self_partial_temp(dec, (VkDrmFormatModifierPropertiesListEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkFormatProperties2_self_partial_temp(struct vn_cs_decoder *dec, VkFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFormatProperties_partial_temp(dec, &val->formatProperties);
}

static inline void
vn_decode_VkFormatProperties2_partial_temp(struct vn_cs_decoder *dec, VkFormatProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2);

    val->sType = stype;
    val->pNext = vn_decode_VkFormatProperties2_pnext_partial_temp(dec);
    vn_decode_VkFormatProperties2_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceExternalImageFormatInfo chain */

static inline void *
vn_decode_VkPhysicalDeviceExternalImageFormatInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExternalImageFormatInfo_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalImageFormatInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalMemoryHandleTypeFlagBits(dec, &val->handleType);
}

static inline void
vn_decode_VkPhysicalDeviceExternalImageFormatInfo_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalImageFormatInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExternalImageFormatInfo_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExternalImageFormatInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExternalImageFormatInfo_handle_self(VkPhysicalDeviceExternalImageFormatInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->handleType */
}

static inline void
vn_replace_VkPhysicalDeviceExternalImageFormatInfo_handle(VkPhysicalDeviceExternalImageFormatInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
            vn_replace_VkPhysicalDeviceExternalImageFormatInfo_handle_self((VkPhysicalDeviceExternalImageFormatInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT chain */

static inline void *
vn_decode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint64_t(dec, &val->drmFormatModifier);
    vn_decode_VkSharingMode(dec, &val->sharingMode);
    vn_decode_uint32_t(dec, &val->queueFamilyIndexCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->queueFamilyIndexCount);
        val->pQueueFamilyIndices = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pQueueFamilyIndices) * array_size);
        if (!val->pQueueFamilyIndices) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pQueueFamilyIndices, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pQueueFamilyIndices = NULL;
    }
}

static inline void
vn_decode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_handle_self(VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->drmFormatModifier */
    /* skip val->sharingMode */
    /* skip val->queueFamilyIndexCount */
    /* skip val->pQueueFamilyIndices */
}

static inline void
vn_replace_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_handle(VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
            vn_replace_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_handle_self((VkPhysicalDeviceImageDrmFormatModifierInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImageFormatInfo2 chain */

static inline void *
vn_decode_VkPhysicalDeviceImageFormatInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExternalImageFormatInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceImageFormatInfo2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceExternalImageFormatInfo_self_temp(dec, (VkPhysicalDeviceExternalImageFormatInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkImageFormatListCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceImageFormatInfo2_pnext_temp(dec);
            vn_decode_VkImageFormatListCreateInfo_self_temp(dec, (VkImageFormatListCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageDrmFormatModifierInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceImageFormatInfo2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self_temp(dec, (VkPhysicalDeviceImageDrmFormatModifierInfoEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkImageStencilUsageCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceImageFormatInfo2_pnext_temp(dec);
            vn_decode_VkImageStencilUsageCreateInfo_self_temp(dec, (VkImageStencilUsageCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceImageFormatInfo2_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageFormatInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFormat(dec, &val->format);
    vn_decode_VkImageType(dec, &val->type);
    vn_decode_VkImageTiling(dec, &val->tiling);
    vn_decode_VkFlags(dec, &val->usage);
    vn_decode_VkFlags(dec, &val->flags);
}

static inline void
vn_decode_VkPhysicalDeviceImageFormatInfo2_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageFormatInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageFormatInfo2_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImageFormatInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImageFormatInfo2_handle_self(VkPhysicalDeviceImageFormatInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->format */
    /* skip val->type */
    /* skip val->tiling */
    /* skip val->usage */
    /* skip val->flags */
}

static inline void
vn_replace_VkPhysicalDeviceImageFormatInfo2_handle(VkPhysicalDeviceImageFormatInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2:
            vn_replace_VkPhysicalDeviceImageFormatInfo2_handle_self((VkPhysicalDeviceImageFormatInfo2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
            vn_replace_VkPhysicalDeviceExternalImageFormatInfo_handle_self((VkPhysicalDeviceExternalImageFormatInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
            vn_replace_VkImageFormatListCreateInfo_handle_self((VkImageFormatListCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
            vn_replace_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_handle_self((VkPhysicalDeviceImageDrmFormatModifierInfoEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
            vn_replace_VkImageStencilUsageCreateInfo_handle_self((VkImageStencilUsageCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkExternalMemoryProperties */

static inline void
vn_encode_VkExternalMemoryProperties(struct vn_cs_encoder *enc, const VkExternalMemoryProperties *val)
{
    vn_encode_VkFlags(enc, &val->externalMemoryFeatures);
    vn_encode_VkFlags(enc, &val->exportFromImportedHandleTypes);
    vn_encode_VkFlags(enc, &val->compatibleHandleTypes);
}

static inline void
vn_decode_VkExternalMemoryProperties_partial_temp(struct vn_cs_decoder *dec, VkExternalMemoryProperties *val)
{
    /* skip val->externalMemoryFeatures */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
}

/* struct VkExternalImageFormatProperties chain */

static inline void
vn_encode_VkExternalImageFormatProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalImageFormatProperties_self(struct vn_cs_encoder *enc, const VkExternalImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalMemoryProperties(enc, &val->externalMemoryProperties);
}

static inline void
vn_encode_VkExternalImageFormatProperties(struct vn_cs_encoder *enc, const VkExternalImageFormatProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES });
    vn_encode_VkExternalImageFormatProperties_pnext(enc, val->pNext);
    vn_encode_VkExternalImageFormatProperties_self(enc, val);
}

static inline void *
vn_decode_VkExternalImageFormatProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkExternalImageFormatProperties_self_partial_temp(struct vn_cs_decoder *dec, VkExternalImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalMemoryProperties_partial_temp(dec, &val->externalMemoryProperties);
}

static inline void
vn_decode_VkExternalImageFormatProperties_partial_temp(struct vn_cs_decoder *dec, VkExternalImageFormatProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkExternalImageFormatProperties_pnext_partial_temp(dec);
    vn_decode_VkExternalImageFormatProperties_self_partial_temp(dec, val);
}

/* struct VkSamplerYcbcrConversionImageFormatProperties chain */

static inline void
vn_encode_VkSamplerYcbcrConversionImageFormatProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSamplerYcbcrConversionImageFormatProperties_self(struct vn_cs_encoder *enc, const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->combinedImageSamplerDescriptorCount);
}

static inline void
vn_encode_VkSamplerYcbcrConversionImageFormatProperties(struct vn_cs_encoder *enc, const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES });
    vn_encode_VkSamplerYcbcrConversionImageFormatProperties_pnext(enc, val->pNext);
    vn_encode_VkSamplerYcbcrConversionImageFormatProperties_self(enc, val);
}

static inline void *
vn_decode_VkSamplerYcbcrConversionImageFormatProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkSamplerYcbcrConversionImageFormatProperties_self_partial_temp(struct vn_cs_decoder *dec, VkSamplerYcbcrConversionImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->combinedImageSamplerDescriptorCount */
}

static inline void
vn_decode_VkSamplerYcbcrConversionImageFormatProperties_partial_temp(struct vn_cs_decoder *dec, VkSamplerYcbcrConversionImageFormatProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkSamplerYcbcrConversionImageFormatProperties_pnext_partial_temp(dec);
    vn_decode_VkSamplerYcbcrConversionImageFormatProperties_self_partial_temp(dec, val);
}

/* struct VkImageFormatProperties2 chain */

static inline void
vn_encode_VkImageFormatProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageFormatProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkExternalImageFormatProperties_self(enc, (const VkExternalImageFormatProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageFormatProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkSamplerYcbcrConversionImageFormatProperties_self(enc, (const VkSamplerYcbcrConversionImageFormatProperties *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageFormatProperties2_self(struct vn_cs_encoder *enc, const VkImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageFormatProperties(enc, &val->imageFormatProperties);
}

static inline void
vn_encode_VkImageFormatProperties2(struct vn_cs_encoder *enc, const VkImageFormatProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2 });
    vn_encode_VkImageFormatProperties2_pnext(enc, val->pNext);
    vn_encode_VkImageFormatProperties2_self(enc, val);
}

static inline void *
vn_decode_VkImageFormatProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkExternalImageFormatProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkImageFormatProperties2_pnext_partial_temp(dec);
            vn_decode_VkExternalImageFormatProperties_self_partial_temp(dec, (VkExternalImageFormatProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkSamplerYcbcrConversionImageFormatProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkImageFormatProperties2_pnext_partial_temp(dec);
            vn_decode_VkSamplerYcbcrConversionImageFormatProperties_self_partial_temp(dec, (VkSamplerYcbcrConversionImageFormatProperties *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkImageFormatProperties2_self_partial_temp(struct vn_cs_decoder *dec, VkImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageFormatProperties_partial_temp(dec, &val->imageFormatProperties);
}

static inline void
vn_decode_VkImageFormatProperties2_partial_temp(struct vn_cs_decoder *dec, VkImageFormatProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2);

    val->sType = stype;
    val->pNext = vn_decode_VkImageFormatProperties2_pnext_partial_temp(dec);
    vn_decode_VkImageFormatProperties2_self_partial_temp(dec, val);
}

/* struct VkQueueFamilyProperties2 chain */

static inline void
vn_encode_VkQueueFamilyProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkQueueFamilyProperties2_self(struct vn_cs_encoder *enc, const VkQueueFamilyProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkQueueFamilyProperties(enc, &val->queueFamilyProperties);
}

static inline void
vn_encode_VkQueueFamilyProperties2(struct vn_cs_encoder *enc, const VkQueueFamilyProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2 });
    vn_encode_VkQueueFamilyProperties2_pnext(enc, val->pNext);
    vn_encode_VkQueueFamilyProperties2_self(enc, val);
}

static inline void *
vn_decode_VkQueueFamilyProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkQueueFamilyProperties2_self_partial_temp(struct vn_cs_decoder *dec, VkQueueFamilyProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkQueueFamilyProperties_partial_temp(dec, &val->queueFamilyProperties);
}

static inline void
vn_decode_VkQueueFamilyProperties2_partial_temp(struct vn_cs_decoder *dec, VkQueueFamilyProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2);

    val->sType = stype;
    val->pNext = vn_decode_VkQueueFamilyProperties2_pnext_partial_temp(dec);
    vn_decode_VkQueueFamilyProperties2_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMemoryProperties2 chain */

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceMemoryProperties(enc, &val->memoryProperties);
}

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties2(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2 });
    vn_encode_VkPhysicalDeviceMemoryProperties2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMemoryProperties2_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMemoryProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties2_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceMemoryProperties_partial_temp(dec, &val->memoryProperties);
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties2_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMemoryProperties2_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMemoryProperties2_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceSparseImageFormatInfo2 chain */

static inline void *
vn_decode_VkPhysicalDeviceSparseImageFormatInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSparseImageFormatInfo2_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFormat(dec, &val->format);
    vn_decode_VkImageType(dec, &val->type);
    vn_decode_VkSampleCountFlagBits(dec, &val->samples);
    vn_decode_VkFlags(dec, &val->usage);
    vn_decode_VkImageTiling(dec, &val->tiling);
}

static inline void
vn_decode_VkPhysicalDeviceSparseImageFormatInfo2_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSparseImageFormatInfo2_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceSparseImageFormatInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceSparseImageFormatInfo2_handle_self(VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->format */
    /* skip val->type */
    /* skip val->samples */
    /* skip val->usage */
    /* skip val->tiling */
}

static inline void
vn_replace_VkPhysicalDeviceSparseImageFormatInfo2_handle(VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2:
            vn_replace_VkPhysicalDeviceSparseImageFormatInfo2_handle_self((VkPhysicalDeviceSparseImageFormatInfo2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSparseImageFormatProperties2 chain */

static inline void
vn_encode_VkSparseImageFormatProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSparseImageFormatProperties2_self(struct vn_cs_encoder *enc, const VkSparseImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkSparseImageFormatProperties(enc, &val->properties);
}

static inline void
vn_encode_VkSparseImageFormatProperties2(struct vn_cs_encoder *enc, const VkSparseImageFormatProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2 });
    vn_encode_VkSparseImageFormatProperties2_pnext(enc, val->pNext);
    vn_encode_VkSparseImageFormatProperties2_self(enc, val);
}

static inline void *
vn_decode_VkSparseImageFormatProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkSparseImageFormatProperties2_self_partial_temp(struct vn_cs_decoder *dec, VkSparseImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkSparseImageFormatProperties_partial_temp(dec, &val->properties);
}

static inline void
vn_decode_VkSparseImageFormatProperties2_partial_temp(struct vn_cs_decoder *dec, VkSparseImageFormatProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2);

    val->sType = stype;
    val->pNext = vn_decode_VkSparseImageFormatProperties2_pnext_partial_temp(dec);
    vn_decode_VkSparseImageFormatProperties2_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceExternalBufferInfo chain */

static inline void *
vn_decode_VkPhysicalDeviceExternalBufferInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExternalBufferInfo_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalBufferInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkFlags(dec, &val->usage);
    vn_decode_VkExternalMemoryHandleTypeFlagBits(dec, &val->handleType);
}

static inline void
vn_decode_VkPhysicalDeviceExternalBufferInfo_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalBufferInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExternalBufferInfo_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExternalBufferInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExternalBufferInfo_handle_self(VkPhysicalDeviceExternalBufferInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->usage */
    /* skip val->handleType */
}

static inline void
vn_replace_VkPhysicalDeviceExternalBufferInfo_handle(VkPhysicalDeviceExternalBufferInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO:
            vn_replace_VkPhysicalDeviceExternalBufferInfo_handle_self((VkPhysicalDeviceExternalBufferInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkExternalBufferProperties chain */

static inline void
vn_encode_VkExternalBufferProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalBufferProperties_self(struct vn_cs_encoder *enc, const VkExternalBufferProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalMemoryProperties(enc, &val->externalMemoryProperties);
}

static inline void
vn_encode_VkExternalBufferProperties(struct vn_cs_encoder *enc, const VkExternalBufferProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES });
    vn_encode_VkExternalBufferProperties_pnext(enc, val->pNext);
    vn_encode_VkExternalBufferProperties_self(enc, val);
}

static inline void *
vn_decode_VkExternalBufferProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkExternalBufferProperties_self_partial_temp(struct vn_cs_decoder *dec, VkExternalBufferProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalMemoryProperties_partial_temp(dec, &val->externalMemoryProperties);
}

static inline void
vn_decode_VkExternalBufferProperties_partial_temp(struct vn_cs_decoder *dec, VkExternalBufferProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkExternalBufferProperties_pnext_partial_temp(dec);
    vn_decode_VkExternalBufferProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceExternalSemaphoreInfo chain */

static inline void *
vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkSemaphoreTypeCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_pnext_temp(dec);
            vn_decode_VkSemaphoreTypeCreateInfo_self_temp(dec, (VkSemaphoreTypeCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalSemaphoreHandleTypeFlagBits(dec, &val->handleType);
}

static inline void
vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExternalSemaphoreInfo_handle_self(VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->handleType */
}

static inline void
vn_replace_VkPhysicalDeviceExternalSemaphoreInfo_handle(VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO:
            vn_replace_VkPhysicalDeviceExternalSemaphoreInfo_handle_self((VkPhysicalDeviceExternalSemaphoreInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
            vn_replace_VkSemaphoreTypeCreateInfo_handle_self((VkSemaphoreTypeCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkExternalSemaphoreProperties chain */

static inline void
vn_encode_VkExternalSemaphoreProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalSemaphoreProperties_self(struct vn_cs_encoder *enc, const VkExternalSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->exportFromImportedHandleTypes);
    vn_encode_VkFlags(enc, &val->compatibleHandleTypes);
    vn_encode_VkFlags(enc, &val->externalSemaphoreFeatures);
}

static inline void
vn_encode_VkExternalSemaphoreProperties(struct vn_cs_encoder *enc, const VkExternalSemaphoreProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES });
    vn_encode_VkExternalSemaphoreProperties_pnext(enc, val->pNext);
    vn_encode_VkExternalSemaphoreProperties_self(enc, val);
}

static inline void *
vn_decode_VkExternalSemaphoreProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkExternalSemaphoreProperties_self_partial_temp(struct vn_cs_decoder *dec, VkExternalSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    /* skip val->externalSemaphoreFeatures */
}

static inline void
vn_decode_VkExternalSemaphoreProperties_partial_temp(struct vn_cs_decoder *dec, VkExternalSemaphoreProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkExternalSemaphoreProperties_pnext_partial_temp(dec);
    vn_decode_VkExternalSemaphoreProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceExternalFenceInfo chain */

static inline void *
vn_decode_VkPhysicalDeviceExternalFenceInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExternalFenceInfo_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalFenceInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalFenceHandleTypeFlagBits(dec, &val->handleType);
}

static inline void
vn_decode_VkPhysicalDeviceExternalFenceInfo_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalFenceInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExternalFenceInfo_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExternalFenceInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExternalFenceInfo_handle_self(VkPhysicalDeviceExternalFenceInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->handleType */
}

static inline void
vn_replace_VkPhysicalDeviceExternalFenceInfo_handle(VkPhysicalDeviceExternalFenceInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO:
            vn_replace_VkPhysicalDeviceExternalFenceInfo_handle_self((VkPhysicalDeviceExternalFenceInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkExternalFenceProperties chain */

static inline void
vn_encode_VkExternalFenceProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalFenceProperties_self(struct vn_cs_encoder *enc, const VkExternalFenceProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->exportFromImportedHandleTypes);
    vn_encode_VkFlags(enc, &val->compatibleHandleTypes);
    vn_encode_VkFlags(enc, &val->externalFenceFeatures);
}

static inline void
vn_encode_VkExternalFenceProperties(struct vn_cs_encoder *enc, const VkExternalFenceProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES });
    vn_encode_VkExternalFenceProperties_pnext(enc, val->pNext);
    vn_encode_VkExternalFenceProperties_self(enc, val);
}

static inline void *
vn_decode_VkExternalFenceProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkExternalFenceProperties_self_partial_temp(struct vn_cs_decoder *dec, VkExternalFenceProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    /* skip val->externalFenceFeatures */
}

static inline void
vn_decode_VkExternalFenceProperties_partial_temp(struct vn_cs_decoder *dec, VkExternalFenceProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkExternalFenceProperties_pnext_partial_temp(dec);
    vn_decode_VkExternalFenceProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceGroupProperties chain */

static inline void
vn_encode_VkPhysicalDeviceGroupProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceGroupProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceGroupProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->physicalDeviceCount);
    vn_encode_array_size(enc, VK_MAX_DEVICE_GROUP_SIZE);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; i++)
        vn_encode_VkPhysicalDevice(enc, &val->physicalDevices[i]);
    vn_encode_VkBool32(enc, &val->subsetAllocation);
}

static inline void
vn_encode_VkPhysicalDeviceGroupProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceGroupProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES });
    vn_encode_VkPhysicalDeviceGroupProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceGroupProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceGroupProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceGroupProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGroupProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->physicalDeviceCount */
    {
        vn_decode_array_size(dec, VK_MAX_DEVICE_GROUP_SIZE);
        for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; i++)
            vn_decode_VkPhysicalDevice_temp(dec, &val->physicalDevices[i]);
    }
    /* skip val->subsetAllocation */
}

static inline void
vn_decode_VkPhysicalDeviceGroupProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGroupProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceGroupProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceGroupProperties_self_partial_temp(dec, val);
}

/* struct VkDeviceQueueInfo2 chain */

static inline void *
vn_decode_VkDeviceQueueInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceQueueInfo2_self_temp(struct vn_cs_decoder *dec, VkDeviceQueueInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->queueFamilyIndex);
    vn_decode_uint32_t(dec, &val->queueIndex);
}

static inline void
vn_decode_VkDeviceQueueInfo2_temp(struct vn_cs_decoder *dec, VkDeviceQueueInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceQueueInfo2_pnext_temp(dec);
    vn_decode_VkDeviceQueueInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceQueueInfo2_handle_self(VkDeviceQueueInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->queueFamilyIndex */
    /* skip val->queueIndex */
}

static inline void
vn_replace_VkDeviceQueueInfo2_handle(VkDeviceQueueInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2:
            vn_replace_VkDeviceQueueInfo2_handle_self((VkDeviceQueueInfo2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkEnumeratePhysicalDevices_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkEnumeratePhysicalDevices *args)
{
    vn_decode_VkInstance_lookup(dec, &args->instance);
    if (vn_decode_simple_pointer(dec)) {
        args->pPhysicalDeviceCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPhysicalDeviceCount));
        if (!args->pPhysicalDeviceCount) return;
        vn_decode_uint32_t(dec, args->pPhysicalDeviceCount);
    } else {
        args->pPhysicalDeviceCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        args->pPhysicalDevices = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPhysicalDevices) * *args->pPhysicalDeviceCount);
        if (!args->pPhysicalDevices) return;
        vn_decode_array_size(dec, *args->pPhysicalDeviceCount);
        for (uint32_t i = 0; i < *args->pPhysicalDeviceCount; i++)
            vn_decode_VkPhysicalDevice_temp(dec, &args->pPhysicalDevices[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pPhysicalDevices = NULL;
    }
}

static inline void vn_replace_vkEnumeratePhysicalDevices_args_handle(struct vn_command_vkEnumeratePhysicalDevices *args)
{
    vn_replace_VkInstance_handle(&args->instance);
    /* skip args->pPhysicalDeviceCount */
    /* skip args->pPhysicalDevices */
}

static inline void vn_encode_vkEnumeratePhysicalDevices_reply(struct vn_cs_encoder *enc, const struct vn_command_vkEnumeratePhysicalDevices *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkEnumeratePhysicalDevices_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->instance */
    if (vn_encode_simple_pointer(enc, args->pPhysicalDeviceCount))
        vn_encode_uint32_t(enc, args->pPhysicalDeviceCount);
    if (args->pPhysicalDevices) {
        vn_encode_array_size(enc, *args->pPhysicalDeviceCount);
        for (uint32_t i = 0; i < *args->pPhysicalDeviceCount; i++)
            vn_encode_VkPhysicalDevice(enc, &args->pPhysicalDevices[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetPhysicalDeviceProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pProperties));
        if (!args->pProperties) return;
        vn_decode_VkPhysicalDeviceProperties_partial_temp(dec, args->pProperties);
    } else {
        args->pProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceProperties_args_handle(struct vn_command_vkGetPhysicalDeviceProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pProperties))
        vn_encode_VkPhysicalDeviceProperties(enc, args->pProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceQueueFamilyProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pQueueFamilyPropertyCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pQueueFamilyPropertyCount));
        if (!args->pQueueFamilyPropertyCount) return;
        vn_decode_uint32_t(dec, args->pQueueFamilyPropertyCount);
    } else {
        args->pQueueFamilyPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        args->pQueueFamilyProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pQueueFamilyProperties) * *args->pQueueFamilyPropertyCount);
        if (!args->pQueueFamilyProperties) return;
        vn_decode_array_size(dec, *args->pQueueFamilyPropertyCount);
        for (uint32_t i = 0; i < *args->pQueueFamilyPropertyCount; i++)
            vn_decode_VkQueueFamilyProperties_partial_temp(dec, &args->pQueueFamilyProperties[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pQueueFamilyProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceQueueFamilyProperties_args_handle(struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pQueueFamilyPropertyCount */
    /* skip args->pQueueFamilyProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceQueueFamilyProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pQueueFamilyPropertyCount))
        vn_encode_uint32_t(enc, args->pQueueFamilyPropertyCount);
    if (args->pQueueFamilyProperties) {
        vn_encode_array_size(enc, *args->pQueueFamilyPropertyCount);
        for (uint32_t i = 0; i < *args->pQueueFamilyPropertyCount; i++)
            vn_encode_VkQueueFamilyProperties(enc, &args->pQueueFamilyProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetPhysicalDeviceMemoryProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceMemoryProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pMemoryProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pMemoryProperties));
        if (!args->pMemoryProperties) return;
        vn_decode_VkPhysicalDeviceMemoryProperties_partial_temp(dec, args->pMemoryProperties);
    } else {
        args->pMemoryProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceMemoryProperties_args_handle(struct vn_command_vkGetPhysicalDeviceMemoryProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pMemoryProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceMemoryProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceMemoryProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pMemoryProperties))
        vn_encode_VkPhysicalDeviceMemoryProperties(enc, args->pMemoryProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceFeatures_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceFeatures *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pFeatures = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFeatures));
        if (!args->pFeatures) return;
        vn_decode_VkPhysicalDeviceFeatures_partial_temp(dec, args->pFeatures);
    } else {
        args->pFeatures = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceFeatures_args_handle(struct vn_command_vkGetPhysicalDeviceFeatures *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pFeatures */
}

static inline void vn_encode_vkGetPhysicalDeviceFeatures_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceFeatures *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pFeatures))
        vn_encode_VkPhysicalDeviceFeatures(enc, args->pFeatures);
}

static inline void vn_decode_vkGetPhysicalDeviceFormatProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceFormatProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    vn_decode_VkFormat(dec, &args->format);
    if (vn_decode_simple_pointer(dec)) {
        args->pFormatProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFormatProperties));
        if (!args->pFormatProperties) return;
        vn_decode_VkFormatProperties_partial_temp(dec, args->pFormatProperties);
    } else {
        args->pFormatProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceFormatProperties_args_handle(struct vn_command_vkGetPhysicalDeviceFormatProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->format */
    /* skip args->pFormatProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceFormatProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceFormatProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties_EXT});

    /* skip args->physicalDevice */
    /* skip args->format */
    if (vn_encode_simple_pointer(enc, args->pFormatProperties))
        vn_encode_VkFormatProperties(enc, args->pFormatProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceImageFormatProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceImageFormatProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    vn_decode_VkFormat(dec, &args->format);
    vn_decode_VkImageType(dec, &args->type);
    vn_decode_VkImageTiling(dec, &args->tiling);
    vn_decode_VkFlags(dec, &args->usage);
    vn_decode_VkFlags(dec, &args->flags);
    if (vn_decode_simple_pointer(dec)) {
        args->pImageFormatProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pImageFormatProperties));
        if (!args->pImageFormatProperties) return;
        vn_decode_VkImageFormatProperties_partial_temp(dec, args->pImageFormatProperties);
    } else {
        args->pImageFormatProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceImageFormatProperties_args_handle(struct vn_command_vkGetPhysicalDeviceImageFormatProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->format */
    /* skip args->type */
    /* skip args->tiling */
    /* skip args->usage */
    /* skip args->flags */
    /* skip args->pImageFormatProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceImageFormatProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceImageFormatProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->physicalDevice */
    /* skip args->format */
    /* skip args->type */
    /* skip args->tiling */
    /* skip args->usage */
    /* skip args->flags */
    if (vn_encode_simple_pointer(enc, args->pImageFormatProperties))
        vn_encode_VkImageFormatProperties(enc, args->pImageFormatProperties);
}

static inline void vn_decode_vkCreateDevice_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateDevice *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pCreateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCreateInfo));
        if (!args->pCreateInfo) return;
        vn_decode_VkDeviceCreateInfo_temp(dec, (VkDeviceCreateInfo *)args->pCreateInfo);
    } else {
        args->pCreateInfo = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        assert(false);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pDevice = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDevice));
        if (!args->pDevice) return;
        vn_decode_VkDevice_temp(dec, args->pDevice);
    } else {
        args->pDevice = NULL;
    }
}

static inline void vn_replace_vkCreateDevice_args_handle(struct vn_command_vkCreateDevice *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    if (args->pCreateInfo)
        vn_replace_VkDeviceCreateInfo_handle((VkDeviceCreateInfo *)args->pCreateInfo);
    /* skip args->pAllocator */
    /* skip args->pDevice */
}

static inline void vn_encode_vkCreateDevice_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateDevice *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateDevice_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->physicalDevice */
    /* skip args->pCreateInfo */
    /* skip args->pAllocator */
    if (vn_encode_simple_pointer(enc, args->pDevice))
        vn_encode_VkDevice(enc, args->pDevice);
}

static inline void vn_decode_vkDestroyDevice_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkDestroyDevice *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        assert(false);
    } else {
        args->pAllocator = NULL;
    }
}

static inline void vn_replace_vkDestroyDevice_args_handle(struct vn_command_vkDestroyDevice *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->pAllocator */
}

static inline void vn_encode_vkDestroyDevice_reply(struct vn_cs_encoder *enc, const struct vn_command_vkDestroyDevice *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkDestroyDevice_EXT});

    /* skip args->device */
    /* skip args->pAllocator */
}

static inline void vn_decode_vkEnumerateDeviceLayerProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkEnumerateDeviceLayerProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pPropertyCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPropertyCount));
        if (!args->pPropertyCount) return;
        vn_decode_uint32_t(dec, args->pPropertyCount);
    } else {
        args->pPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        args->pProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pProperties) * *args->pPropertyCount);
        if (!args->pProperties) return;
        vn_decode_array_size(dec, *args->pPropertyCount);
        for (uint32_t i = 0; i < *args->pPropertyCount; i++)
            vn_decode_VkLayerProperties_partial_temp(dec, &args->pProperties[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pProperties = NULL;
    }
}

static inline void vn_replace_vkEnumerateDeviceLayerProperties_args_handle(struct vn_command_vkEnumerateDeviceLayerProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pPropertyCount */
    /* skip args->pProperties */
}

static inline void vn_encode_vkEnumerateDeviceLayerProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkEnumerateDeviceLayerProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkEnumerateDeviceLayerProperties_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pPropertyCount))
        vn_encode_uint32_t(enc, args->pPropertyCount);
    if (args->pProperties) {
        vn_encode_array_size(enc, *args->pPropertyCount);
        for (uint32_t i = 0; i < *args->pPropertyCount; i++)
            vn_encode_VkLayerProperties(enc, &args->pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkEnumerateDeviceExtensionProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkEnumerateDeviceExtensionProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_peek_array_size(dec)) {
        const size_t string_size = vn_decode_array_size(dec, UINT64_MAX);
        args->pLayerName = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pLayerName) * string_size);
        if (!args->pLayerName) return;
        vn_decode_blob_array(dec, (char *)args->pLayerName, string_size);
    } else {
        vn_decode_array_size(dec, 0);
        args->pLayerName = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pPropertyCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPropertyCount));
        if (!args->pPropertyCount) return;
        vn_decode_uint32_t(dec, args->pPropertyCount);
    } else {
        args->pPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        args->pProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pProperties) * *args->pPropertyCount);
        if (!args->pProperties) return;
        vn_decode_array_size(dec, *args->pPropertyCount);
        for (uint32_t i = 0; i < *args->pPropertyCount; i++)
            vn_decode_VkExtensionProperties_partial_temp(dec, &args->pProperties[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pProperties = NULL;
    }
}

static inline void vn_replace_vkEnumerateDeviceExtensionProperties_args_handle(struct vn_command_vkEnumerateDeviceExtensionProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pLayerName */
    /* skip args->pPropertyCount */
    /* skip args->pProperties */
}

static inline void vn_encode_vkEnumerateDeviceExtensionProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkEnumerateDeviceExtensionProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkEnumerateDeviceExtensionProperties_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->physicalDevice */
    /* skip args->pLayerName */
    if (vn_encode_simple_pointer(enc, args->pPropertyCount))
        vn_encode_uint32_t(enc, args->pPropertyCount);
    if (args->pProperties) {
        vn_encode_array_size(enc, *args->pPropertyCount);
        for (uint32_t i = 0; i < *args->pPropertyCount; i++)
            vn_encode_VkExtensionProperties(enc, &args->pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetDeviceQueue_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetDeviceQueue *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_uint32_t(dec, &args->queueFamilyIndex);
    vn_decode_uint32_t(dec, &args->queueIndex);
    if (vn_decode_simple_pointer(dec)) {
        args->pQueue = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pQueue));
        if (!args->pQueue) return;
        vn_decode_VkQueue_temp(dec, args->pQueue);
    } else {
        args->pQueue = NULL;
    }
}

static inline void vn_replace_vkGetDeviceQueue_args_handle(struct vn_command_vkGetDeviceQueue *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->queueFamilyIndex */
    /* skip args->queueIndex */
    /* skip args->pQueue */
}

static inline void vn_encode_vkGetDeviceQueue_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetDeviceQueue *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetDeviceQueue_EXT});

    /* skip args->device */
    /* skip args->queueFamilyIndex */
    /* skip args->queueIndex */
    if (vn_encode_simple_pointer(enc, args->pQueue))
        vn_encode_VkQueue(enc, args->pQueue);
}

static inline void vn_decode_vkDeviceWaitIdle_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkDeviceWaitIdle *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
}

static inline void vn_replace_vkDeviceWaitIdle_args_handle(struct vn_command_vkDeviceWaitIdle *args)
{
    vn_replace_VkDevice_handle(&args->device);
}

static inline void vn_encode_vkDeviceWaitIdle_reply(struct vn_cs_encoder *enc, const struct vn_command_vkDeviceWaitIdle *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkDeviceWaitIdle_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
}

static inline void vn_decode_vkGetPhysicalDeviceSparseImageFormatProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    vn_decode_VkFormat(dec, &args->format);
    vn_decode_VkImageType(dec, &args->type);
    vn_decode_VkSampleCountFlagBits(dec, &args->samples);
    vn_decode_VkFlags(dec, &args->usage);
    vn_decode_VkImageTiling(dec, &args->tiling);
    if (vn_decode_simple_pointer(dec)) {
        args->pPropertyCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPropertyCount));
        if (!args->pPropertyCount) return;
        vn_decode_uint32_t(dec, args->pPropertyCount);
    } else {
        args->pPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        args->pProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pProperties) * *args->pPropertyCount);
        if (!args->pProperties) return;
        vn_decode_array_size(dec, *args->pPropertyCount);
        for (uint32_t i = 0; i < *args->pPropertyCount; i++)
            vn_decode_VkSparseImageFormatProperties_partial_temp(dec, &args->pProperties[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceSparseImageFormatProperties_args_handle(struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->format */
    /* skip args->type */
    /* skip args->samples */
    /* skip args->usage */
    /* skip args->tiling */
    /* skip args->pPropertyCount */
    /* skip args->pProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceSparseImageFormatProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties_EXT});

    /* skip args->physicalDevice */
    /* skip args->format */
    /* skip args->type */
    /* skip args->samples */
    /* skip args->usage */
    /* skip args->tiling */
    if (vn_encode_simple_pointer(enc, args->pPropertyCount))
        vn_encode_uint32_t(enc, args->pPropertyCount);
    if (args->pProperties) {
        vn_encode_array_size(enc, *args->pPropertyCount);
        for (uint32_t i = 0; i < *args->pPropertyCount; i++)
            vn_encode_VkSparseImageFormatProperties(enc, &args->pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetPhysicalDeviceFeatures2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceFeatures2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pFeatures = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFeatures));
        if (!args->pFeatures) return;
        vn_decode_VkPhysicalDeviceFeatures2_partial_temp(dec, args->pFeatures);
    } else {
        args->pFeatures = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceFeatures2_args_handle(struct vn_command_vkGetPhysicalDeviceFeatures2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pFeatures */
}

static inline void vn_encode_vkGetPhysicalDeviceFeatures2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceFeatures2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures2_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pFeatures))
        vn_encode_VkPhysicalDeviceFeatures2(enc, args->pFeatures);
}

static inline void vn_decode_vkGetPhysicalDeviceProperties2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceProperties2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pProperties));
        if (!args->pProperties) return;
        vn_decode_VkPhysicalDeviceProperties2_partial_temp(dec, args->pProperties);
    } else {
        args->pProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceProperties2_args_handle(struct vn_command_vkGetPhysicalDeviceProperties2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceProperties2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceProperties2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties2_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pProperties))
        vn_encode_VkPhysicalDeviceProperties2(enc, args->pProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceFormatProperties2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceFormatProperties2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    vn_decode_VkFormat(dec, &args->format);
    if (vn_decode_simple_pointer(dec)) {
        args->pFormatProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFormatProperties));
        if (!args->pFormatProperties) return;
        vn_decode_VkFormatProperties2_partial_temp(dec, args->pFormatProperties);
    } else {
        args->pFormatProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceFormatProperties2_args_handle(struct vn_command_vkGetPhysicalDeviceFormatProperties2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->format */
    /* skip args->pFormatProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceFormatProperties2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceFormatProperties2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties2_EXT});

    /* skip args->physicalDevice */
    /* skip args->format */
    if (vn_encode_simple_pointer(enc, args->pFormatProperties))
        vn_encode_VkFormatProperties2(enc, args->pFormatProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceImageFormatProperties2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceImageFormatProperties2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pImageFormatInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pImageFormatInfo));
        if (!args->pImageFormatInfo) return;
        vn_decode_VkPhysicalDeviceImageFormatInfo2_temp(dec, (VkPhysicalDeviceImageFormatInfo2 *)args->pImageFormatInfo);
    } else {
        args->pImageFormatInfo = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pImageFormatProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pImageFormatProperties));
        if (!args->pImageFormatProperties) return;
        vn_decode_VkImageFormatProperties2_partial_temp(dec, args->pImageFormatProperties);
    } else {
        args->pImageFormatProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceImageFormatProperties2_args_handle(struct vn_command_vkGetPhysicalDeviceImageFormatProperties2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    if (args->pImageFormatInfo)
        vn_replace_VkPhysicalDeviceImageFormatInfo2_handle((VkPhysicalDeviceImageFormatInfo2 *)args->pImageFormatInfo);
    /* skip args->pImageFormatProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceImageFormatProperties2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceImageFormatProperties2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties2_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->physicalDevice */
    /* skip args->pImageFormatInfo */
    if (vn_encode_simple_pointer(enc, args->pImageFormatProperties))
        vn_encode_VkImageFormatProperties2(enc, args->pImageFormatProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceQueueFamilyProperties2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pQueueFamilyPropertyCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pQueueFamilyPropertyCount));
        if (!args->pQueueFamilyPropertyCount) return;
        vn_decode_uint32_t(dec, args->pQueueFamilyPropertyCount);
    } else {
        args->pQueueFamilyPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        args->pQueueFamilyProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pQueueFamilyProperties) * *args->pQueueFamilyPropertyCount);
        if (!args->pQueueFamilyProperties) return;
        vn_decode_array_size(dec, *args->pQueueFamilyPropertyCount);
        for (uint32_t i = 0; i < *args->pQueueFamilyPropertyCount; i++)
            vn_decode_VkQueueFamilyProperties2_partial_temp(dec, &args->pQueueFamilyProperties[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pQueueFamilyProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceQueueFamilyProperties2_args_handle(struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pQueueFamilyPropertyCount */
    /* skip args->pQueueFamilyProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceQueueFamilyProperties2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties2_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pQueueFamilyPropertyCount))
        vn_encode_uint32_t(enc, args->pQueueFamilyPropertyCount);
    if (args->pQueueFamilyProperties) {
        vn_encode_array_size(enc, *args->pQueueFamilyPropertyCount);
        for (uint32_t i = 0; i < *args->pQueueFamilyPropertyCount; i++)
            vn_encode_VkQueueFamilyProperties2(enc, &args->pQueueFamilyProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetPhysicalDeviceMemoryProperties2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceMemoryProperties2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pMemoryProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pMemoryProperties));
        if (!args->pMemoryProperties) return;
        vn_decode_VkPhysicalDeviceMemoryProperties2_partial_temp(dec, args->pMemoryProperties);
    } else {
        args->pMemoryProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceMemoryProperties2_args_handle(struct vn_command_vkGetPhysicalDeviceMemoryProperties2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pMemoryProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceMemoryProperties2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceMemoryProperties2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties2_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pMemoryProperties))
        vn_encode_VkPhysicalDeviceMemoryProperties2(enc, args->pMemoryProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceSparseImageFormatProperties2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pFormatInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFormatInfo));
        if (!args->pFormatInfo) return;
        vn_decode_VkPhysicalDeviceSparseImageFormatInfo2_temp(dec, (VkPhysicalDeviceSparseImageFormatInfo2 *)args->pFormatInfo);
    } else {
        args->pFormatInfo = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pPropertyCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPropertyCount));
        if (!args->pPropertyCount) return;
        vn_decode_uint32_t(dec, args->pPropertyCount);
    } else {
        args->pPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        args->pProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pProperties) * *args->pPropertyCount);
        if (!args->pProperties) return;
        vn_decode_array_size(dec, *args->pPropertyCount);
        for (uint32_t i = 0; i < *args->pPropertyCount; i++)
            vn_decode_VkSparseImageFormatProperties2_partial_temp(dec, &args->pProperties[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceSparseImageFormatProperties2_args_handle(struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    if (args->pFormatInfo)
        vn_replace_VkPhysicalDeviceSparseImageFormatInfo2_handle((VkPhysicalDeviceSparseImageFormatInfo2 *)args->pFormatInfo);
    /* skip args->pPropertyCount */
    /* skip args->pProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceSparseImageFormatProperties2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties2_EXT});

    /* skip args->physicalDevice */
    /* skip args->pFormatInfo */
    if (vn_encode_simple_pointer(enc, args->pPropertyCount))
        vn_encode_uint32_t(enc, args->pPropertyCount);
    if (args->pProperties) {
        vn_encode_array_size(enc, *args->pPropertyCount);
        for (uint32_t i = 0; i < *args->pPropertyCount; i++)
            vn_encode_VkSparseImageFormatProperties2(enc, &args->pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetPhysicalDeviceExternalBufferProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceExternalBufferProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pExternalBufferInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pExternalBufferInfo));
        if (!args->pExternalBufferInfo) return;
        vn_decode_VkPhysicalDeviceExternalBufferInfo_temp(dec, (VkPhysicalDeviceExternalBufferInfo *)args->pExternalBufferInfo);
    } else {
        args->pExternalBufferInfo = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pExternalBufferProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pExternalBufferProperties));
        if (!args->pExternalBufferProperties) return;
        vn_decode_VkExternalBufferProperties_partial_temp(dec, args->pExternalBufferProperties);
    } else {
        args->pExternalBufferProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceExternalBufferProperties_args_handle(struct vn_command_vkGetPhysicalDeviceExternalBufferProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    if (args->pExternalBufferInfo)
        vn_replace_VkPhysicalDeviceExternalBufferInfo_handle((VkPhysicalDeviceExternalBufferInfo *)args->pExternalBufferInfo);
    /* skip args->pExternalBufferProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceExternalBufferProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceExternalBufferProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalBufferProperties_EXT});

    /* skip args->physicalDevice */
    /* skip args->pExternalBufferInfo */
    if (vn_encode_simple_pointer(enc, args->pExternalBufferProperties))
        vn_encode_VkExternalBufferProperties(enc, args->pExternalBufferProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceExternalSemaphoreProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceExternalSemaphoreProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pExternalSemaphoreInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pExternalSemaphoreInfo));
        if (!args->pExternalSemaphoreInfo) return;
        vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_temp(dec, (VkPhysicalDeviceExternalSemaphoreInfo *)args->pExternalSemaphoreInfo);
    } else {
        args->pExternalSemaphoreInfo = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pExternalSemaphoreProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pExternalSemaphoreProperties));
        if (!args->pExternalSemaphoreProperties) return;
        vn_decode_VkExternalSemaphoreProperties_partial_temp(dec, args->pExternalSemaphoreProperties);
    } else {
        args->pExternalSemaphoreProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceExternalSemaphoreProperties_args_handle(struct vn_command_vkGetPhysicalDeviceExternalSemaphoreProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    if (args->pExternalSemaphoreInfo)
        vn_replace_VkPhysicalDeviceExternalSemaphoreInfo_handle((VkPhysicalDeviceExternalSemaphoreInfo *)args->pExternalSemaphoreInfo);
    /* skip args->pExternalSemaphoreProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceExternalSemaphoreProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceExternalSemaphoreProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalSemaphoreProperties_EXT});

    /* skip args->physicalDevice */
    /* skip args->pExternalSemaphoreInfo */
    if (vn_encode_simple_pointer(enc, args->pExternalSemaphoreProperties))
        vn_encode_VkExternalSemaphoreProperties(enc, args->pExternalSemaphoreProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceExternalFenceProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceExternalFenceProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pExternalFenceInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pExternalFenceInfo));
        if (!args->pExternalFenceInfo) return;
        vn_decode_VkPhysicalDeviceExternalFenceInfo_temp(dec, (VkPhysicalDeviceExternalFenceInfo *)args->pExternalFenceInfo);
    } else {
        args->pExternalFenceInfo = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pExternalFenceProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pExternalFenceProperties));
        if (!args->pExternalFenceProperties) return;
        vn_decode_VkExternalFenceProperties_partial_temp(dec, args->pExternalFenceProperties);
    } else {
        args->pExternalFenceProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceExternalFenceProperties_args_handle(struct vn_command_vkGetPhysicalDeviceExternalFenceProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    if (args->pExternalFenceInfo)
        vn_replace_VkPhysicalDeviceExternalFenceInfo_handle((VkPhysicalDeviceExternalFenceInfo *)args->pExternalFenceInfo);
    /* skip args->pExternalFenceProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceExternalFenceProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceExternalFenceProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalFenceProperties_EXT});

    /* skip args->physicalDevice */
    /* skip args->pExternalFenceInfo */
    if (vn_encode_simple_pointer(enc, args->pExternalFenceProperties))
        vn_encode_VkExternalFenceProperties(enc, args->pExternalFenceProperties);
}

static inline void vn_decode_vkEnumeratePhysicalDeviceGroups_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkEnumeratePhysicalDeviceGroups *args)
{
    vn_decode_VkInstance_lookup(dec, &args->instance);
    if (vn_decode_simple_pointer(dec)) {
        args->pPhysicalDeviceGroupCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPhysicalDeviceGroupCount));
        if (!args->pPhysicalDeviceGroupCount) return;
        vn_decode_uint32_t(dec, args->pPhysicalDeviceGroupCount);
    } else {
        args->pPhysicalDeviceGroupCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        args->pPhysicalDeviceGroupProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPhysicalDeviceGroupProperties) * *args->pPhysicalDeviceGroupCount);
        if (!args->pPhysicalDeviceGroupProperties) return;
        vn_decode_array_size(dec, *args->pPhysicalDeviceGroupCount);
        for (uint32_t i = 0; i < *args->pPhysicalDeviceGroupCount; i++)
            vn_decode_VkPhysicalDeviceGroupProperties_partial_temp(dec, &args->pPhysicalDeviceGroupProperties[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pPhysicalDeviceGroupProperties = NULL;
    }
}

static inline void vn_replace_vkEnumeratePhysicalDeviceGroups_args_handle(struct vn_command_vkEnumeratePhysicalDeviceGroups *args)
{
    vn_replace_VkInstance_handle(&args->instance);
    /* skip args->pPhysicalDeviceGroupCount */
    /* skip args->pPhysicalDeviceGroupProperties */
}

static inline void vn_encode_vkEnumeratePhysicalDeviceGroups_reply(struct vn_cs_encoder *enc, const struct vn_command_vkEnumeratePhysicalDeviceGroups *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkEnumeratePhysicalDeviceGroups_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->instance */
    if (vn_encode_simple_pointer(enc, args->pPhysicalDeviceGroupCount))
        vn_encode_uint32_t(enc, args->pPhysicalDeviceGroupCount);
    if (args->pPhysicalDeviceGroupProperties) {
        vn_encode_array_size(enc, *args->pPhysicalDeviceGroupCount);
        for (uint32_t i = 0; i < *args->pPhysicalDeviceGroupCount; i++)
            vn_encode_VkPhysicalDeviceGroupProperties(enc, &args->pPhysicalDeviceGroupProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetDeviceGroupPeerMemoryFeatures_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetDeviceGroupPeerMemoryFeatures *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_uint32_t(dec, &args->heapIndex);
    vn_decode_uint32_t(dec, &args->localDeviceIndex);
    vn_decode_uint32_t(dec, &args->remoteDeviceIndex);
    if (vn_decode_simple_pointer(dec)) {
        args->pPeerMemoryFeatures = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPeerMemoryFeatures));
        if (!args->pPeerMemoryFeatures) return;
    } else {
        args->pPeerMemoryFeatures = NULL;
    }
}

static inline void vn_replace_vkGetDeviceGroupPeerMemoryFeatures_args_handle(struct vn_command_vkGetDeviceGroupPeerMemoryFeatures *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->heapIndex */
    /* skip args->localDeviceIndex */
    /* skip args->remoteDeviceIndex */
    /* skip args->pPeerMemoryFeatures */
}

static inline void vn_encode_vkGetDeviceGroupPeerMemoryFeatures_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetDeviceGroupPeerMemoryFeatures *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetDeviceGroupPeerMemoryFeatures_EXT});

    /* skip args->device */
    /* skip args->heapIndex */
    /* skip args->localDeviceIndex */
    /* skip args->remoteDeviceIndex */
    if (vn_encode_simple_pointer(enc, args->pPeerMemoryFeatures))
        vn_encode_VkFlags(enc, args->pPeerMemoryFeatures);
}

static inline void vn_decode_vkGetDeviceQueue2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetDeviceQueue2 *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pQueueInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pQueueInfo));
        if (!args->pQueueInfo) return;
        vn_decode_VkDeviceQueueInfo2_temp(dec, (VkDeviceQueueInfo2 *)args->pQueueInfo);
    } else {
        args->pQueueInfo = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pQueue = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pQueue));
        if (!args->pQueue) return;
        vn_decode_VkQueue_temp(dec, args->pQueue);
    } else {
        args->pQueue = NULL;
    }
}

static inline void vn_replace_vkGetDeviceQueue2_args_handle(struct vn_command_vkGetDeviceQueue2 *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pQueueInfo)
        vn_replace_VkDeviceQueueInfo2_handle((VkDeviceQueueInfo2 *)args->pQueueInfo);
    /* skip args->pQueue */
}

static inline void vn_encode_vkGetDeviceQueue2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetDeviceQueue2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetDeviceQueue2_EXT});

    /* skip args->device */
    /* skip args->pQueueInfo */
    if (vn_encode_simple_pointer(enc, args->pQueue))
        vn_encode_VkQueue(enc, args->pQueue);
}

static inline void vn_dispatch_vkEnumeratePhysicalDevices(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkEnumeratePhysicalDevices args;

    if (!ctx->dispatch_vkEnumeratePhysicalDevices) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkEnumeratePhysicalDevices_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkEnumeratePhysicalDevices(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkEnumeratePhysicalDevices returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkEnumeratePhysicalDevices_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceProperties_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceProperties(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceQueueFamilyProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceQueueFamilyProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceQueueFamilyProperties_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceQueueFamilyProperties(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceQueueFamilyProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceMemoryProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceMemoryProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceMemoryProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceMemoryProperties_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceMemoryProperties(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceMemoryProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceFeatures(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceFeatures args;

    if (!ctx->dispatch_vkGetPhysicalDeviceFeatures) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceFeatures_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceFeatures(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceFeatures_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceFormatProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceFormatProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceFormatProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceFormatProperties_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceFormatProperties(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceFormatProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceImageFormatProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceImageFormatProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceImageFormatProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceImageFormatProperties_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceImageFormatProperties(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkGetPhysicalDeviceImageFormatProperties returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceImageFormatProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCreateDevice(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateDevice args;

    if (!ctx->dispatch_vkCreateDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateDevice_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateDevice(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkCreateDevice returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCreateDevice_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkDestroyDevice(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkDestroyDevice args;

    if (!ctx->dispatch_vkDestroyDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkDestroyDevice_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkDestroyDevice(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkDestroyDevice_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkEnumerateDeviceLayerProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkEnumerateDeviceLayerProperties args;

    if (!ctx->dispatch_vkEnumerateDeviceLayerProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkEnumerateDeviceLayerProperties_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkEnumerateDeviceLayerProperties(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkEnumerateDeviceLayerProperties returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkEnumerateDeviceLayerProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkEnumerateDeviceExtensionProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkEnumerateDeviceExtensionProperties args;

    if (!ctx->dispatch_vkEnumerateDeviceExtensionProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkEnumerateDeviceExtensionProperties_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkEnumerateDeviceExtensionProperties(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkEnumerateDeviceExtensionProperties returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkEnumerateDeviceExtensionProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetDeviceQueue(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetDeviceQueue args;

    if (!ctx->dispatch_vkGetDeviceQueue) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetDeviceQueue_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetDeviceQueue(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetDeviceQueue_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkDeviceWaitIdle(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkDeviceWaitIdle args;

    if (!ctx->dispatch_vkDeviceWaitIdle) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkDeviceWaitIdle_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkDeviceWaitIdle(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkDeviceWaitIdle returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkDeviceWaitIdle_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceSparseImageFormatProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceSparseImageFormatProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceSparseImageFormatProperties_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceSparseImageFormatProperties(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceSparseImageFormatProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceFeatures2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceFeatures2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceFeatures2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceFeatures2_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceFeatures2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceFeatures2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceProperties2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceProperties2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceProperties2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceProperties2_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceProperties2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceProperties2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceFormatProperties2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceFormatProperties2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceFormatProperties2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceFormatProperties2_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceFormatProperties2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceFormatProperties2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceImageFormatProperties2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceImageFormatProperties2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceImageFormatProperties2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceImageFormatProperties2_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceImageFormatProperties2(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkGetPhysicalDeviceImageFormatProperties2 returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceImageFormatProperties2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceQueueFamilyProperties2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceQueueFamilyProperties2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceQueueFamilyProperties2_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceQueueFamilyProperties2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceQueueFamilyProperties2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceMemoryProperties2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceMemoryProperties2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceMemoryProperties2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceMemoryProperties2_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceMemoryProperties2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceMemoryProperties2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceSparseImageFormatProperties2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceSparseImageFormatProperties2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceSparseImageFormatProperties2_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceSparseImageFormatProperties2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceSparseImageFormatProperties2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceExternalBufferProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceExternalBufferProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceExternalBufferProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceExternalBufferProperties_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceExternalBufferProperties(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceExternalBufferProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceExternalSemaphoreProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceExternalSemaphoreProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceExternalSemaphoreProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceExternalSemaphoreProperties_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceExternalSemaphoreProperties(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceExternalSemaphoreProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceExternalFenceProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceExternalFenceProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceExternalFenceProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceExternalFenceProperties_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceExternalFenceProperties(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetPhysicalDeviceExternalFenceProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkEnumeratePhysicalDeviceGroups(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkEnumeratePhysicalDeviceGroups args;

    if (!ctx->dispatch_vkEnumeratePhysicalDeviceGroups) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkEnumeratePhysicalDeviceGroups_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkEnumeratePhysicalDeviceGroups(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkEnumeratePhysicalDeviceGroups returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkEnumeratePhysicalDeviceGroups_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetDeviceGroupPeerMemoryFeatures(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetDeviceGroupPeerMemoryFeatures args;

    if (!ctx->dispatch_vkGetDeviceGroupPeerMemoryFeatures) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetDeviceGroupPeerMemoryFeatures_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetDeviceGroupPeerMemoryFeatures(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetDeviceGroupPeerMemoryFeatures_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetDeviceQueue2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetDeviceQueue2 args;

    if (!ctx->dispatch_vkGetDeviceQueue2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetDeviceQueue2_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetDeviceQueue2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetDeviceQueue2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#endif /* VN_PROTOCOL_RENDERER_DEVICE_H */
