/******************************************************************************
*
*   Copyright (c) 2020 Intel.
*
*   Licensed under the Apache License, Version 2.0 (the "License");
*   you may not use this file except in compliance with the License.
*   You may obtain a copy of the License at
*
*       http://www.apache.org/licenses/LICENSE-2.0
*
*   Unless required by applicable law or agreed to in writing, software
*   distributed under the License is distributed on an "AS IS" BASIS,
*   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*   See the License for the specific language governing permissions and
*   limitations under the License.
*
*******************************************************************************/

#ifndef _VRB1_PF_ENUM_H_
#define _VRB1_PF_ENUM_H_

/*
 * VRB1 Register mapping on PF BAR0
 * This is automatically generated from RDL, format may change with new RDL
 * Release.
 * Variable names are as is
 */
enum {
	HWPfQmgrEgressQueuesTemplate		=	0x0007FC00,
	HWPfQmgrIngressAq                       =	0x00080000,
	HWPfAramControlStatus                   =	0x00810000,
	HWPfQmgrArbQAvail                       =	0x00A00010,
	HWPfQmgrArbQBlock                       =	0x00A00020,
	HWPfQmgrAqueueDropNotifEn               =	0x00A00024,
	HWPfQmgrAqueueDisableNotifEn            =	0x00A00028,
	HWPfQmgrSoftReset                       =	0x00A00038,
	HWPfQmgrInitStatus                      =	0x00A0003C,
	HWPfQmgrAramWatchdogCount               =	0x00A00040,
	HWPfQmgrAramWatchdogCounterEn           =	0x00A00044,
	HWPfQmgrAxiWatchdogCount                =	0x00A00048,
	HWPfQmgrAxiWatchdogCounterEn            =	0x00A0004C,
	HWPfQmgrProcessWatchdogCount            =	0x00A00050,
	HWPfQmgrProcessWatchdogCounterEn        =	0x00A00054,
	HWPfQmgrProcessWatchdogCounterFunc      =	0x00A00060,
	HWPfQmgrMsiOverflowUpperVf              =	0x00A00080,
	HWPfQmgrMsiOverflowLowerVf              =	0x00A00084,
	HWPfQmgrMsiWatchdogOverflow             =	0x00A00088,
	HWPfQmgrMsiOverflowEnable               =	0x00A0008C,
	HWPfQmgrDebugAqPointerMemGrp            =	0x00A00100,
	HWPfQmgrDebugOutputArbQFifoGrp          =	0x00A00140,
	HWPfQmgrDebugMsiFifoGrp                 =	0x00A00180,
	HWPfQmgrDebugAxiWdTimeoutMsiFifo        =	0x00A001C0,
	HWPfQmgrDebugProcessWdTimeoutMsiFifo    =	0x00A001C4,
	HWPfQmgrDepthLog2Grp                    =	0x00A00200,
	HWPfQmgrTholdGrp                        =	0x00A00300,
	HWPfQmgrGrpTmplateReg0Indx              =	0x00A00600,
	HWPfQmgrGrpTmplateReg1Indx              =	0x00A00700,
	HWPfQmgrGrpTmplateReg2Indx              =	0x00A00800,
	HWPfQmgrGrpTmplateReg3Indx              =	0x00A00900,
	HWPfQmgrGrpTmplateReg4Indx              =	0x00A00A00,
	HWPfQmgrVfBaseAddr                      =	0x00A01000,
	HWPfQmgrUl4gWeightRrVf                  =	0x00A02000,
	HWPfQmgrDl4gWeightRrVf                  =	0x00A02100,
	HWPfQmgrUl5gWeightRrVf                  =	0x00A02200,
	HWPfQmgrDl5gWeightRrVf                  =	0x00A02300,
	HWPfQmgrMldWeightRrVf                   =	0x00A02400,
	HWPfQmgrArbQDepthGrp                    =	0x00A02F00,
	HWPfQmgrGrpFunction0                    =	0x00A02F40,
	HWPfQmgrGrpFunction1                    =	0x00A02F44,
	HWPfQmgrGrpPriority                     =	0x00A02F48,
	HWPfQmgrWeightSync                      =	0x00A03000,
	HWPfQmgrAqEnableVf                      =	0x00A10000,
	HWPfQmgrAqResetVf                       =	0x00A20000,
	HWPfQmgrRingSizeVf                      =	0x00A20004,
	HWPfQmgrGrpDepthLog20Vf                 =	0x00A20008,
	HWPfQmgrGrpDepthLog21Vf                 =	0x00A2000C,
	HWPfQmgrGrpFunction0Vf                  =	0x00A20010,
	HWPfQmgrGrpFunction1Vf                  =	0x00A20014,
	HWPfFabricM2iBufferReg                  =	0x00B30000,
	HWPfFabricI2Mcore_reg_g0                =       0x00B31000,
	HWPfFabricI2Mcore_weight_g0             =       0x00B31004,
	HWPfFabricI2Mbuffer_g0                  =       0x00B31008,
	HWPfFabricI2Mcore_reg_g1                =       0x00B31010,
	HWPfFabricI2Mcore_weight_g1             =       0x00B31014,
	HWPfFabricI2Mbuffer_g1                  =       0x00B31018,
	HWPfFabricI2Mcore_reg_g2                =       0x00B31020,
	HWPfFabricI2Mcore_weight_g2             =       0x00B31024,
	HWPfFabricI2Mbuffer_g2                  =       0x00B31028,
	HWPfFabricI2Mcore_reg_g3                =       0x00B31030,
	HWPfFabricI2Mcore_weight_g3             =       0x00B31034,
	HWPfFabricI2Mbuffer_g3                  =       0x00B31038,
	HWPfFabricI2Mdma_weight                 =       0x00B31044,
	HWPfFecUl5gCntrlReg                     =	0x00B40000,
	HWPfFecUl5gI2mThreshReg                 =	0x00B40004,
	HWPfFecUl5gVersionReg                   =	0x00B40100,
	HWPfFecUl5gFcwStatusReg                 =	0x00B40104,
	HWPfFecUl5gWarnReg                      =	0x00B40108,
	HWPfFecUl5gIbDebugReg                   =	0x00B40200,
	HWPfFecUl5gObLlrDebugReg                =	0x00B40204,
	HWPfFecUl5gObHarqDebugReg               =	0x00B40208,
	HWPfFecUl5g1CntrlReg                    =	0x00B41000,
	HWPfFecUl5g1I2mThreshReg                =	0x00B41004,
	HWPfFecUl5g1VersionReg                  =	0x00B41100,
	HWPfFecUl5g1FcwStatusReg                =	0x00B41104,
	HWPfFecUl5g1WarnReg                     =	0x00B41108,
	HWPfFecUl5g1IbDebugReg                  =	0x00B41200,
	HWPfFecUl5g1ObLlrDebugReg               =	0x00B41204,
	HWPfFecUl5g1ObHarqDebugReg              =	0x00B41208,
	HWPfFecUl5g2CntrlReg                    =	0x00B42000,
	HWPfFecUl5g2I2mThreshReg                =	0x00B42004,
	HWPfFecUl5g2VersionReg                  =	0x00B42100,
	HWPfFecUl5g2FcwStatusReg                =	0x00B42104,
	HWPfFecUl5g2WarnReg                     =	0x00B42108,
	HWPfFecUl5g2IbDebugReg                  =	0x00B42200,
	HWPfFecUl5g2ObLlrDebugReg               =	0x00B42204,
	HWPfFecUl5g2ObHarqDebugReg              =	0x00B42208,
	HWPfFecUl5g3CntrlReg                    =	0x00B43000,
	HWPfFecUl5g3I2mThreshReg                =	0x00B43004,
	HWPfFecUl5g3VersionReg                  =	0x00B43100,
	HWPfFecUl5g3FcwStatusReg                =	0x00B43104,
	HWPfFecUl5g3WarnReg                     =	0x00B43108,
	HWPfFecUl5g3IbDebugReg                  =	0x00B43200,
	HWPfFecUl5g3ObLlrDebugReg               =	0x00B43204,
	HWPfFecUl5g3ObHarqDebugReg              =	0x00B43208,
	HWPfFecUl5g4CntrlReg                    =	0x00B44000,
	HWPfFecUl5g4I2mThreshReg                =	0x00B44004,
	HWPfFecUl5g4VersionReg                  =	0x00B44100,
	HWPfFecUl5g4FcwStatusReg                =	0x00B44104,
	HWPfFecUl5g4WarnReg                     =	0x00B44108,
	HWPfFecUl5g4IbDebugReg                  =	0x00B44200,
	HWPfFecUl5g4ObLlrDebugReg               =	0x00B44204,
	HWPfFecUl5g4ObHarqDebugReg              =	0x00B44208,
	HWPfFecUl5g5CntrlReg                    =	0x00B45000,
	HWPfFecUl5g5I2mThreshReg                =	0x00B45004,
	HWPfFecUl5g5VersionReg                  =	0x00B45100,
	HWPfFecUl5g5FcwStatusReg                =	0x00B45104,
	HWPfFecUl5g5WarnReg                     =	0x00B45108,
	HWPfFecUl5g5IbDebugReg                  =	0x00B45200,
	HWPfFecUl5g5ObLlrDebugReg               =	0x00B45204,
	HWPfFecUl5g5ObHarqDebugReg              =	0x00B45208,
	HWPfFecUl5g6CntrlReg                    =	0x00B46000,
	HWPfFecUl5g6I2mThreshReg                =	0x00B46004,
	HWPfFecUl5g6VersionReg                  =	0x00B46100,
	HWPfFecUl5g6FcwStatusReg                =	0x00B46104,
	HWPfFecUl5g6WarnReg                     =	0x00B46108,
	HWPfFecUl5g6IbDebugReg                  =	0x00B46200,
	HWPfFecUl5g6ObLlrDebugReg               =	0x00B46204,
	HWPfFecUl5g6ObHarqDebugReg              =	0x00B46208,
	HWPfFecUl5g7CntrlReg                    =	0x00B47000,
	HWPfFecUl5g7I2mThreshReg                =	0x00B47004,
	HWPfFecUl5g7VersionReg                  =	0x00B47100,
	HWPfFecUl5g7FcwStatusReg                =	0x00B47104,
	HWPfFecUl5g7WarnReg                     =	0x00B47108,
	HWPfFecUl5g7IbDebugReg                  =	0x00B47200,
	HWPfFecUl5g7ObLlrDebugReg               =	0x00B47204,
	HWPfFecUl5g7ObHarqDebugReg              =	0x00B47208,
	HWPfFecUl5g8CntrlReg                    =	0x00B48000,
	HWPfFecUl5g8I2mThreshReg                =	0x00B48004,
	HWPfFecUl5g8VersionReg                  =	0x00B48100,
	HWPfFecUl5g8FcwStatusReg                =	0x00B48104,
	HWPfFecUl5g8WarnReg                     =	0x00B48108,
	HWPfFecUl5g8IbDebugReg                  =	0x00B48200,
	HWPfFecUl5g8ObLlrDebugReg               =	0x00B48204,
	HWPfFecUl5g8ObHarqDebugReg              =	0x00B48208,
	HWPfFecDl5gCntrlReg                     =	0x00B4F000,
	HWPfFecDl5gI2mThreshReg                 =	0x00B4F004,
	HWPfFecDl5gVersionReg                   =	0x00B4F100,
	HWPfFecDl5gFcwStatusReg                 =	0x00B4F104,
	HWPfFecDl5gWarnReg                      =	0x00B4F108,
	HWPfFecUlVersionReg                     =	0x00B50000,
	HWPfFecUlControlReg                     =	0x00B50004,
	HWPfFecUlStatusReg                      =	0x00B50008,
	HWPfFftVersion                          =	0x00B58000,
	HWPfFftConfig0                          =	0x00B58004,
	HWPfFftConfig1                          =	0x00B58008,
	HWPfFftRamPageAccess                    =	0x00B5800C,
	HwPfFftParityMaskBuffer	                =	0x00B5801C,
	HwPfFftParityMaskReg0	                =	0x00B58020,
	HwPfFftParityMaskReg1	                =	0x00B58024,
	HwPfFftParityMaskReg2	                =	0x00B58028,
	HwPfFftParityMaskReg3	                =	0x00B5802C,
	HwPfFftParityMaskReg4	                =	0x00B58030,
	HwPfFftParityMaskReg5	                =	0x00B58034,
	HwPfFftParityMaskReg6	                =	0x00B58038,
	HwPfFftParityMaskReg7	                =	0x00B5803C,
	HwPfFftStatusReg0	                =	0x00B58040,
	HwPfFftStatusReg1	                =	0x00B58044,
	HwPfFftStatusReg2	                =	0x00B58048,
	HwPfFftStatusReg3	                =	0x00B5804C,
	HwPfFftStatusReg4	                =	0x00B58050,
	HwPfFftStatusReg5	                =	0x00B58054,
	HwPfFftStatusReg6	                =	0x00B58058,
	HwPfFftStatusReg7	                =	0x00B5805C,
	HwPfFftStatusReg8	                =	0x00B58060,
	HwPfFftStatusReg9	                =	0x00B58064,
	HwPfFftStatusReg10	                =	0x00B58068,
	HwPfFftStatusReg11	                =	0x00B5806C,
	HwPfFftStatusReg12	                =	0x00B58070,
	HwPfFftStatusReg13	                =	0x00B58074,
	HwPfFftStatusReg14	                =	0x00B58078,
	HwPfFftStatusReg15	                =	0x00B5807C,
	HwPfFftParityStatusReg0	                =	0x00B58080,
	HwPfFftParityStatusReg1	                =	0x00B58084,
	HwPfFftParityStatusReg2	                =	0x00B58088,
	HwPfFftParityStatusReg3	                =	0x00B5808C,
	HwPfFftParityStatusReg4	                =	0x00B58090,
	HwPfFftParityStatusReg5	                =	0x00B58094,
	HwPfFftParityStatusReg6	                =	0x00B58098,
	HwPfFftParityStatusReg7	                =	0x00B5809C,
	HwPfFftParityStatusReg8	                =	0x00B580A0,
	HWPfFftRamOff                           =	0x00B58800,
	HWPfFecDlVersionReg                     =	0x00B5F000,
	HWPfFecDlClusterConfigReg               =	0x00B5F004,
	HWPfFecDlBurstThres                     =	0x00B5F00C,
	HWPfFecDlClusterStatusReg0              =	0x00B5F040,
	HWPfFecDlClusterStatusReg1              =	0x00B5F044,
	HWPfFecDlClusterStatusReg2              =	0x00B5F048,
	HWPfFecDlClusterStatusReg3              =	0x00B5F04C,
	HWPfFecDlClusterStatusReg4              =	0x00B5F050,
	HWPfFecDlClusterStatusReg5              =	0x00B5F054,
	HWPfDmaConfig0Reg                       =	0x00B80000,
	HWPfDmaConfig1Reg                       =	0x00B80004,
	HWPfDmaQmgrAddrReg                      =	0x00B80008,
	HWPfDmaSoftResetReg                     =	0x00B8000C,
	HWPfDmaAxcacheReg                       =	0x00B80010,
	HWPfDmaVersionReg                       =	0x00B80014,
	HWPfDmaFrameThreshold                   =	0x00B80018,
	HWPfDmaTimestampLo                      =	0x00B8001C,
	HWPfDmaTimestampHi                      =	0x00B80020,
	HWPfDmaAxiStatus                        =	0x00B80028,
	HWPfDmaAxiControl                       =	0x00B8002C,
	HWPfDmaNoQmgr                           =	0x00B80030,
	HWPfDmaQosScale                         =	0x00B80034,
	HWPfDmaQmanen                           =	0x00B80040,
	HWPfDmaFftModeThld                      =       0x00B80054,
	HWPfDmaQmgrQosBase                      =	0x00B80060,
	HWPfDmaFecClkGatingEnable               =	0x00B80080,
	HWPfDmaPmEnable                         =	0x00B80084,
	HWPfDmaQosEnable                        =	0x00B80088,
	HWPfDmaHarqWeightedRrFrameThreshold     =	0x00B800B0,
	HWPfDmaDataSmallWeightedRrFrameThresh   =	0x00B800B4,
	HWPfDmaDataLargeWeightedRrFrameThresh   =	0x00B800B8,
	HWPfDmaInboundCbMaxSize                 =	0x00B800BC,
	HWPfDmaInboundDrainDataSize             =	0x00B800C0,
	HWPfDmaEngineTypeSmall                  =       0x00B800C4,
	HWPfDma5gdlIbThld                       =       0x00B800C8,
	HWPfDma4gdlIbThld                       =       0x00B800CC,
	HWPfDmafftIbThld                        =       0x00B800D0,
	HWPfDmaVfDdrBaseRw                      =	0x00B80400,
	HWPfDmaCmplTmOutCnt                     =	0x00B80800,
	HWPfDmaProcTmOutCnt                     =	0x00B80804,
	HWPfDmaStatusRrespBresp                 =	0x00B80810,
	HWPfDmaCfgRrespBresp                    =	0x00B80814,
	HWPfDmaStatusMemParErr                  =	0x00B80818,
	HWPfDmaCfgMemParErrEn                   =	0x00B8081C,
	HWPfDmaStatusDmaHwErr                   =	0x00B80820,
	HWPfDmaCfgDmaHwErrEn                    =	0x00B80824,
	HWPfDmaStatusFecCoreErr                 =	0x00B80828,
	HWPfDmaCfgFecCoreErrEn                  =	0x00B8082C,
	HWPfDmaStatusFcwDescrErr                =	0x00B80830,
	HWPfDmaCfgFcwDescrErrEn                 =	0x00B80834,
	HWPfDmaStatusBlockTransmit              =	0x00B80838,
	HWPfDmaBlockOnErrEn                     =	0x00B8083C,
	HWPfDmaStatusFlushDma                   =	0x00B80840,
	HWPfDmaFlushDmaOnErrEn                  =	0x00B80844,
	HWPfDmaStatusSdoneFifoFull              =	0x00B80848,
	HWPfDmaStatusDescriptorErrLoVf          =	0x00B8084C,
	HWPfDmaStatusDescriptorErrHiVf          =	0x00B80850,
	HWPfDmaStatusFcwErrLoVf                 =	0x00B80854,
	HWPfDmaStatusFcwErrHiVf                 =	0x00B80858,
	HWPfDmaStatusDataErrLoVf                =	0x00B8085C,
	HWPfDmaStatusDataErrHiVf                =	0x00B80860,
	HWPfDmaCfgMsiEnSoftwareErr              =	0x00B80864,
	HWPfDmaDescriptorSignatuture            =	0x00B80868,
	HWPfDmaFcwSignature                     =	0x00B8086C,
	HWPfDmaErrorDetectionEn                 =	0x00B80870,
	HWPfDmaErrCntrlFifoDebug                =	0x00B8087C,
	HWPfDmaStatusToutData                   =	0x00B80880,
	HWPfDmaStatusToutDesc                   =	0x00B80884,
	HWPfDmaStatusToutUnexpData              =	0x00B80888,
	HWPfDmaStatusToutUnexpDesc              =	0x00B8088C,
	HWPfDmaStatusToutProcess                =	0x00B80890,
	HWPfDmaConfigCtoutOutDataEn             =	0x00B808A0,
	HWPfDmaConfigCtoutOutDescrEn            =	0x00B808A4,
	HWPfDmaConfigUnexpComplDataEn           =	0x00B808A8,
	HWPfDmaConfigUnexpComplDescrEn          =	0x00B808AC,
	HWPfDmaConfigPtoutOutEn                 =	0x00B808B0,
	HWPfDmaFec5gulDescBaseLoRegVf           =	0x00B88020,
	HWPfDmaFec5gulDescBaseHiRegVf           =	0x00B88024,
	HWPfDmaFec5gulRespPtrLoRegVf            =	0x00B88028,
	HWPfDmaFec5gulRespPtrHiRegVf            =	0x00B8802C,
	HWPfDmaFec5gdlDescBaseLoRegVf           =	0x00B88040,
	HWPfDmaFec5gdlDescBaseHiRegVf           =	0x00B88044,
	HWPfDmaFec5gdlRespPtrLoRegVf            =	0x00B88048,
	HWPfDmaFec5gdlRespPtrHiRegVf            =	0x00B8804C,
	HWPfDmaFec4gulDescBaseLoRegVf           =	0x00B88060,
	HWPfDmaFec4gulDescBaseHiRegVf           =	0x00B88064,
	HWPfDmaFec4gulRespPtrLoRegVf            =	0x00B88068,
	HWPfDmaFec4gulRespPtrHiRegVf            =	0x00B8806C,
	HWPfDmaFec4gdlDescBaseLoRegVf           =	0x00B88080,
	HWPfDmaFec4gdlDescBaseHiRegVf           =	0x00B88084,
	HWPfDmaFec4gdlRespPtrLoRegVf            =	0x00B88088,
	HWPfDmaFec4gdlRespPtrHiRegVf            =	0x00B8808C,
	HWPfDmaFftDescBaseLoRegVf               =	0x00B880A0,
	HWPfDmaFftDescBaseHiRegVf               =	0x00B880A4,
	HWPfDmaFftRespPtrLoRegVf                =	0x00B880A8,
	HWPfDmaFftRespPtrHiRegVf                =	0x00B880AC,
	HWPfQosmonACntrlReg                     =	0x00B90000,
	HWPfQosmonAEvalOverflow0                =	0x00B90008,
	HWPfQosmonAEvalOverflow1                =	0x00B9000C,
	HWPfQosmonADivTerm                      =	0x00B90010,
	HWPfQosmonATickTerm                     =	0x00B90014,
	HWPfQosmonAEvalTerm                     =	0x00B90018,
	HWPfQosmonAAveTerm                      =	0x00B9001C,
	HWPfQosmonAForceEccErr                  =	0x00B90020,
	HWPfQosmonAEccErrDetect                 =	0x00B90024,
	HWPfQosmonAIterationConfig0Low          =	0x00B90060,
	HWPfQosmonAIterationConfig0High         =	0x00B90064,
	HWPfQosmonAIterationConfig1Low          =	0x00B90068,
	HWPfQosmonAIterationConfig1High         =	0x00B9006C,
	HWPfQosmonAIterationConfig2Low          =	0x00B90070,
	HWPfQosmonAIterationConfig2High         =	0x00B90074,
	HWPfQosmonAIterationConfig3Low          =	0x00B90078,
	HWPfQosmonAIterationConfig3High         =	0x00B9007C,
	HWPfQosmonAEvalMemAddr                  =	0x00B90080,
	HWPfQosmonAEvalMemData                  =	0x00B90084,
	HWPfQosmonAXaction                      =	0x00B900C0,
	HWPfQosmonARemThres1Vf                  =	0x00B90400,
	HWPfQosmonAThres2Vf                     =	0x00B90404,
	HWPfQosmonAWeiFracVf                    =	0x00B90408,
	HWPfQosmonARrWeiVf                      =	0x00B9040C,
	HWPfPermonACntrlRegVf                   =	0x00B98000,
	HWPfPermonACountVf                      =	0x00B98008,
	HWPfPermonAKCntLoVf                     =	0x00B98010,
	HWPfPermonAKCntHiVf                     =	0x00B98014,
	HWPfPermonADeltaCntLoVf                 =	0x00B98020,
	HWPfPermonADeltaCntHiVf                 =	0x00B98024,
	HWPfPermonAVersionReg                   =	0x00B9C000,
	HWPfPermonACbControlFec                 =	0x00B9C0F0,
	HWPfPermonADltTimerLoFec                =	0x00B9C0F4,
	HWPfPermonADltTimerHiFec                =	0x00B9C0F8,
	HWPfPermonACbCountFec                   =	0x00B9C100,
	HWPfPermonAAccExecTimerLoFec            =	0x00B9C104,
	HWPfPermonAAccExecTimerHiFec            =	0x00B9C108,
	HWPfPermonAExecTimerMinFec              =	0x00B9C200,
	HWPfPermonAExecTimerMaxFec              =	0x00B9C204,
	HWPfPermonAControlBusMon                =	0x00B9C400,
	HWPfPermonAConfigBusMon                 =	0x00B9C404,
	HWPfPermonASkipCountBusMon              =	0x00B9C408,
	HWPfPermonAMinLatBusMon                 =	0x00B9C40C,
	HWPfPermonAMaxLatBusMon                 =	0x00B9C500,
	HWPfPermonATotalLatLowBusMon            =	0x00B9C504,
	HWPfPermonATotalLatUpperBusMon          =	0x00B9C508,
	HWPfPermonATotalReqCntBusMon            =	0x00B9C50C,
	HWPfQosmonBCntrlReg                     =	0x00BA0000,
	HWPfQosmonBEvalOverflow0                =	0x00BA0008,
	HWPfQosmonBEvalOverflow1                =	0x00BA000C,
	HWPfQosmonBDivTerm                      =	0x00BA0010,
	HWPfQosmonBTickTerm                     =	0x00BA0014,
	HWPfQosmonBEvalTerm                     =	0x00BA0018,
	HWPfQosmonBAveTerm                      =	0x00BA001C,
	HWPfQosmonBForceEccErr                  =	0x00BA0020,
	HWPfQosmonBEccErrDetect                 =	0x00BA0024,
	HWPfQosmonBIterationConfig0Low          =	0x00BA0060,
	HWPfQosmonBIterationConfig0High         =	0x00BA0064,
	HWPfQosmonBIterationConfig1Low          =	0x00BA0068,
	HWPfQosmonBIterationConfig1High         =	0x00BA006C,
	HWPfQosmonBIterationConfig2Low          =	0x00BA0070,
	HWPfQosmonBIterationConfig2High         =	0x00BA0074,
	HWPfQosmonBIterationConfig3Low          =	0x00BA0078,
	HWPfQosmonBIterationConfig3High         =	0x00BA007C,
	HWPfQosmonBEvalMemAddr                  =	0x00BA0080,
	HWPfQosmonBEvalMemData                  =	0x00BA0084,
	HWPfQosmonBXaction                      =	0x00BA00C0,
	HWPfQosmonBRemThres1Vf                  =	0x00BA0400,
	HWPfQosmonBThres2Vf                     =	0x00BA0404,
	HWPfQosmonBWeiFracVf                    =	0x00BA0408,
	HWPfQosmonBRrWeiVf                      =	0x00BA040C,
	HWPfPermonBCntrlRegVf                   =	0x00BA8000,
	HWPfPermonBCountVf                      =	0x00BA8008,
	HWPfPermonBKCntLoVf                     =	0x00BA8010,
	HWPfPermonBKCntHiVf                     =	0x00BA8014,
	HWPfPermonBDeltaCntLoVf                 =	0x00BA8020,
	HWPfPermonBDeltaCntHiVf                 =	0x00BA8024,
	HWPfPermonBVersionReg                   =	0x00BAC000,
	HWPfPermonBCbControlFec                 =	0x00BAC0F0,
	HWPfPermonBDltTimerLoFec                =	0x00BAC0F4,
	HWPfPermonBDltTimerHiFec                =	0x00BAC0F8,
	HWPfPermonBCbCountFec                   =	0x00BAC100,
	HWPfPermonBAccExecTimerLoFec            =	0x00BAC104,
	HWPfPermonBAccExecTimerHiFec            =	0x00BAC108,
	HWPfPermonBExecTimerMinFec              =	0x00BAC200,
	HWPfPermonBExecTimerMaxFec              =	0x00BAC204,
	HWPfPermonBControlBusMon                =	0x00BAC400,
	HWPfPermonBConfigBusMon                 =	0x00BAC404,
	HWPfPermonBSkipCountBusMon              =	0x00BAC408,
	HWPfPermonBMinLatBusMon                 =	0x00BAC40C,
	HWPfPermonBMaxLatBusMon                 =	0x00BAC500,
	HWPfPermonBTotalLatLowBusMon            =	0x00BAC504,
	HWPfPermonBTotalLatUpperBusMon          =	0x00BAC508,
	HWPfPermonBTotalReqCntBusMon            =	0x00BAC50C,
	HWPfQosmonCCntrlReg                     =	0x00BB0000,
	HWPfQosmonCEvalOverflow0                =	0x00BB0008,
	HWPfQosmonCEvalOverflow1                =	0x00BB000C,
	HWPfQosmonCDivTerm                      =	0x00BB0010,
	HWPfQosmonCTickTerm                     =	0x00BB0014,
	HWPfQosmonCEvalTerm                     =	0x00BB0018,
	HWPfQosmonCAveTerm                      =	0x00BB001C,
	HWPfQosmonCForceEccErr                  =	0x00BB0020,
	HWPfQosmonCEccErrDetect                 =	0x00BB0024,
	HWPfQosmonCIterationConfig0Low          =	0x00BB0060,
	HWPfQosmonCIterationConfig0High         =	0x00BB0064,
	HWPfQosmonCIterationConfig1Low          =	0x00BB0068,
	HWPfQosmonCIterationConfig1High         =	0x00BB006C,
	HWPfQosmonCIterationConfig2Low          =	0x00BB0070,
	HWPfQosmonCIterationConfig2High         =	0x00BB0074,
	HWPfQosmonCIterationConfig3Low          =	0x00BB0078,
	HWPfQosmonCIterationConfig3High         =	0x00BB007C,
	HWPfQosmonCEvalMemAddr                  =	0x00BB0080,
	HWPfQosmonCEvalMemData                  =	0x00BB0084,
	HWPfQosmonCXaction                      =	0x00BB00C0,
	HWPfQosmonCRemThres1Vf                  =	0x00BB0400,
	HWPfQosmonCThres2Vf                     =	0x00BB0404,
	HWPfQosmonCWeiFracVf                    =	0x00BB0408,
	HWPfQosmonCRrWeiVf                      =	0x00BB040C,
	HWPfPermonCCntrlRegVf                   =	0x00BB8000,
	HWPfPermonCCountVf                      =	0x00BB8008,
	HWPfPermonCKCntLoVf                     =	0x00BB8010,
	HWPfPermonCKCntHiVf                     =	0x00BB8014,
	HWPfPermonCDeltaCntLoVf                 =	0x00BB8020,
	HWPfPermonCDeltaCntHiVf                 =	0x00BB8024,
	HWPfPermonCVersionReg                   =	0x00BBC000,
	HWPfPermonCCbControlFec                 =	0x00BBC0F0,
	HWPfPermonCDltTimerLoFec                =	0x00BBC0F4,
	HWPfPermonCDltTimerHiFec                =	0x00BBC0F8,
	HWPfPermonCCbCountFec                   =	0x00BBC100,
	HWPfPermonCAccExecTimerLoFec            =	0x00BBC104,
	HWPfPermonCAccExecTimerHiFec            =	0x00BBC108,
	HWPfPermonCExecTimerMinFec              =	0x00BBC200,
	HWPfPermonCExecTimerMaxFec              =	0x00BBC204,
	HWPfPermonCControlBusMon                =	0x00BBC400,
	HWPfPermonCConfigBusMon                 =	0x00BBC404,
	HWPfPermonCSkipCountBusMon              =	0x00BBC408,
	HWPfPermonCMinLatBusMon                 =	0x00BBC40C,
	HWPfPermonCMaxLatBusMon                 =	0x00BBC500,
	HWPfPermonCTotalLatLowBusMon            =	0x00BBC504,
	HWPfPermonCTotalLatUpperBusMon          =	0x00BBC508,
	HWPfPermonCTotalReqCntBusMon            =	0x00BBC50C,
	HWPfHiVfToPfDbellVf                     =	0x00C80000,
	HWPfHiPfToVfDbellVf                     =	0x00C80008,
	HWPfHiInfoRingBaseLoVf                  =	0x00C80010,
	HWPfHiInfoRingBaseHiVf                  =	0x00C80014,
	HWPfHiInfoRingPointerVf                 =	0x00C80018,
	HWPfHiInfoRingIntWrEnVf                 =	0x00C80020,
	HWPfHiInfoRingPf2vfWrEnVf               =	0x00C80024,
	HWPfHiMsixVectorMapperVf                =	0x00C80060,
	HWPfHiModuleVersionReg                  =	0x00C84000,
	HWPfHiIosf2axiErrLogReg                 =	0x00C84004,
	HWPfHiHardResetReg                      =	0x00C84008,
	HWPfHi5GHardResetReg                    =	0x00C8400C,
	HWPfHiCoresHardResetReg                 =	0x00C84010,
	HWPfHiInfoRingBaseLoRegPf               =	0x00C84014,
	HWPfHiInfoRingBaseHiRegPf               =	0x00C84018,
	HWPfHiOcodeMailBox                      =	0x00C84018,
	HWPfHiInfoRingPointerRegPf              =	0x00C8401C,
	HWPfHiInfoRingIntWrEnRegPf              =	0x00C84020,
	HWPfHiInfoRingVf2pfLoWrEnReg            =	0x00C84024,
	HWPfHiInfoRingVf2pfHiWrEnReg            =	0x00C84028,
	HWPfHiLogParityErrStatusReg             =	0x00C8402C,
	HWPfHiLogDataParityErrorVfStatusLo      =	0x00C84030,
	HWPfHiLogDataParityErrorVfStatusHi      =	0x00C84034,
	HWPfHiBlockTransmitOnErrorEn            =	0x00C84038,
	HWPfHiCfgMsiIntWrEnRegPf                =	0x00C84040,
	HWPfHiCfgMsiVf2pfLoWrEnReg              =	0x00C84044,
	HWPfHiCfgMsiVf2pfHighWrEnReg            =	0x00C84048,
	HWPfHiMsixVectorMapperPf                =	0x00C84060,
	HWPfHiApbWrWaitTime                     =	0x00C84100,
	HWPfHiXCounterMaxValue                  =	0x00C84104,
	HWPfHiPfMode                            =	0x00C84108,
	HWPfHiClkGateHystReg                    =	0x00C8410C,
	HWPfHiSnoopBitsReg                      =	0x00C84110,
	HWPfHiMsiDropEnableReg                  =	0x00C84114,
	HWPfHiMsiStatReg                        =	0x00C84120,
	HWPfHiFifoOflStatReg                    =	0x00C84124,
	HWPfHiSectionPowerGatingReq             =	0x00C84128,
	HWPfHiSectionPowerGatingAck             =	0x00C8412C,
	HWPfHiSectionPowerGatingWaitCounter     =	0x00C84130,
	HWPfHiHiDebugReg                        =	0x00C841F4,
	HWPfHiDebugMemSnoopMsiFifo              =	0x00C841F8,
	HWPfHiDebugMemSnoopInputFifo            =	0x00C841FC,
	HWPfHiMsixMappingConfig                 =	0x00C84200,
	HWPfHiErrInjectReg                      =	0x00C84204,
	HWPfHiErrStatusReg                      =	0x00C84208,
	HWPfHiErrMaskReg                        =	0x00C8420C,
	HWPfHiErrFatalReg                       =	0x00C84210,
	HWPfHiJunkReg                           =	0x00C8FF00,
	HWPfHiMsixBaseLoRegPf                   =	0x00D20000,
	HWPfHiMsixBaseHiRegPf                   =	0x00D20004,
	HWPfHiMsixBaseDataRegPf                 =	0x00D20008,
	HWPfHiMsixBaseMaskRegPf                 =	0x00D2000c,
	HWPfHiMsixPbaBaseLoRegPf                =	0x00E01000,
};

/* VRB1 PF Interrupt numbers */
enum {
	VRB1_PF_INT_QMGR_AQ_OVERFLOW = 0,
	VRB1_PF_INT_DOORBELL_VF_2_PF = 1,
	VRB1_PF_INT_DMA_DL_DESC_IRQ = 2,
	VRB1_PF_INT_DMA_UL_DESC_IRQ = 3,
	VRB1_PF_INT_ILLEGAL_FORMAT = 4,
	VRB1_PF_INT_QMGR_DISABLED_ACCESS = 5,
	VRB1_PF_INT_QMGR_AQ_OVERTHRESHOLD = 6,
	VRB1_PF_INT_ARAM_ACCESS_ERR = 8,
	VRB1_PF_INT_ARAM_ECC_1BIT_ERR = 9,
	VRB1_PF_INT_PARITY_ERR = 10,
	VRB1_PF_INT_QMGR_ERR = 13,
	VRB1_PF_INT_INT_REQ_OVERFLOW = 14,
	VRB1_PF_INT_APB_TIMEOUT = 15,
	VRB1_PF_INT_FEC_DL_EXTRA_READ = 16,
	VRB1_PF_INT_FEC_DL_READ_TIMEOUT = 17,
	VRB1_PF_INT_FEC_DL_ERR = 18,
	VRB1_PF_INT_FEC_UL_EXTRA_READ = 20,
	VRB1_PF_INT_FEC_UL_READ_TIMEOUT = 21,
	VRB1_PF_INT_FEC_UL_ERR = 22,
};

enum {
	VRB1_QMGR_AQ_OVERFLOW = 0,
	VRB1_DOORBELL_VFTOPF = 1,
	VRB1_ILLEGAL_FORMAT = 2,
	VRB1_QMGR_DISABLED_ACCESS = 3,
	VRB1_QMGR_AQ_OVER_THRESHOLD = 4,
	VRB1_4G_DMA_DL_DESC_IRQ = 5,
	VRB1_4G_DMA_UL_DESC_IRQ = 6,
	VRB1_FFT_DESC_IRQ = 7,
	VRB1_5G_DMA_UL_DESC_IRQ = 8,
	VRB1_5G_DMA_DL_DESC_IRQ = 9,
	VRB1_ARAM_ACCESS_ERROR = 11,
	VRB1_ARAM_ECC_1BIT_ERROR = 12,
	VRB1_ARAM_MBIT_PARITY_ERR = 13,
	VRB1_QMGR_INTREQ_FIFO_OVERFLOW = 14,
	VRB1_QMGR_ERROR_DETECTED = 15,
	VRB1_5G_EXTRA_COMPLETION_RECVD = 24,
	VRB1_5G_COMPLETION_READ_TIMEOUT = 25,
	VRB1_5G_ERROR_DETECTED = 26,
	VRB1_ITR_UNDEFINED = 31
};

#endif /* _VRB1_PF_ENUM_H_ */
