; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=hawaii < %s | FileCheck -check-prefixes=CI,CI-SAFE %s
; RUN: llc -march=amdgcn -mcpu=fiji < %s | FileCheck -check-prefixes=VI,VI-SAFE %s
; RUN: llc -march=amdgcn -mcpu=gfx906 < %s | FileCheck -check-prefixes=GFX9,GFX9-SAFE %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 < %s | FileCheck -check-prefixes=GFX11,GFX11-SAFE %s

; RUN: llc -march=amdgcn -mcpu=hawaii -enable-no-signed-zeros-fp-math < %s | FileCheck -check-prefixes=CI,CI-NSZ %s
; RUN: llc -march=amdgcn -mcpu=fiji -enable-no-signed-zeros-fp-math < %s | FileCheck -check-prefixes=VI,VI-NSZ %s
; RUN: llc -march=amdgcn -mcpu=gfx906 -enable-no-signed-zeros-fp-math < %s | FileCheck -check-prefixes=GFX9,GFX9-NSZ %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -enable-no-signed-zeros-fp-math < %s | FileCheck -check-prefixes=GFX11,GFX11-NSZ %s

define <2 x half> @add_select_fabs_fabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; CI-LABEL: add_select_fabs_fabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e64 v5, |v5|
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e64 v4, |v4|
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v6
; CI-NEXT:    v_add_f32_e32 v1, v1, v7
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_fabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v4
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fabs_fabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_fabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fabs.y = call <2 x half> @llvm.fabs.v2f16(<2 x half> %y)
  %select = select <2 x i1> %cmp, <2 x half> %fabs.x, <2 x half> %fabs.y
  %add = fadd <2 x half> %select, %z
  ret <2 x half> %add
}

define { <2 x half>, <2 x half> } @add_select_multi_use_lhs_fabs_fabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %w, <2 x half> %z) {
; CI-LABEL: add_select_multi_use_lhs_fabs_fabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; CI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e64 v5, |v5|
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e64 v4, |v4|
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v8
; CI-NEXT:    v_add_f32_e32 v1, v1, v9
; CI-NEXT:    v_add_f32_e32 v2, v2, v6
; CI-NEXT:    v_add_f32_e32 v3, v3, v7
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_multi_use_lhs_fabs_fabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v6, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v5
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_f16_sdwa v1, v6, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v2, v2, v4
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_multi_use_lhs_fabs_fabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v6, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v5
; GFX9-NEXT:    v_pk_add_f16 v1, v2, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_multi_use_lhs_fabs_fabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v1, v2, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fabs.y = call <2 x half> @llvm.fabs.v2f16(<2 x half> %y)
  %select = select <2 x i1> %cmp, <2 x half> %fabs.x, <2 x half> %fabs.y
  %add0 = fadd <2 x half> %select, %z
  %add1 = fadd <2 x half> %fabs.x, %w
  %insert.0 = insertvalue { <2 x half>, <2 x half> } poison, <2 x half> %add0, 0
  %insert.1 = insertvalue { <2 x half>, <2 x half> } %insert.0, <2 x half> %add1, 1
  ret { <2 x half>, <2 x half> } %insert.1
}

define { <2 x half>, <2 x half> } @add_select_multi_store_use_lhs_fabs_fabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; CI-LABEL: add_select_multi_store_use_lhs_fabs_fabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e64 v5, |v5|
; CI-NEXT:    v_cvt_f32_f16_e64 v4, |v4|
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v6
; CI-NEXT:    v_add_f32_e32 v1, v1, v7
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_multi_store_use_lhs_fabs_fabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v5, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v4
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_multi_store_use_lhs_fabs_fabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v5, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX9-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_multi_store_use_lhs_fabs_fabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_mov_b32_e32 v1, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fabs.y = call <2 x half> @llvm.fabs.v2f16(<2 x half> %y)
  %select = select <2 x i1> %cmp, <2 x half> %fabs.x, <2 x half> %fabs.y
  %add0 = fadd <2 x half> %select, %z
  %insert.0 = insertvalue { <2 x half>, <2 x half> } poison, <2 x half> %add0, 0
  %insert.1 = insertvalue { <2 x half>, <2 x half> } %insert.0, <2 x half> %fabs.x, 1
  ret { <2 x half>, <2 x half> } %insert.1
}

define { <2 x half>, <2 x half> } @add_select_multi_use_rhs_fabs_fabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z, <2 x half> %w) {
; CI-LABEL: add_select_multi_use_rhs_fabs_fabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; CI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e64 v5, |v5|
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e64 v4, |v4|
; CI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v6
; CI-NEXT:    v_add_f32_e32 v1, v1, v7
; CI-NEXT:    v_add_f32_e32 v2, v4, v8
; CI-NEXT:    v_add_f32_e32 v3, v5, v9
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_multi_use_rhs_fabs_fabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v6, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v4
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_f16_sdwa v1, v6, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v2, v3, v5
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_multi_use_rhs_fabs_fabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v6, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX9-NEXT:    v_pk_add_f16 v1, v3, v5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_multi_use_rhs_fabs_fabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v1, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fabs.y = call <2 x half> @llvm.fabs.v2f16(<2 x half> %y)
  %select = select <2 x i1> %cmp, <2 x half> %fabs.x, <2 x half> %fabs.y
  %add0 = fadd <2 x half> %select, %z
  %add1 = fadd <2 x half> %fabs.y, %w
  %insert.0 = insertvalue { <2 x half>, <2 x half> } poison, <2 x half> %add0, 0
  %insert.1 = insertvalue { <2 x half>, <2 x half> } %insert.0, <2 x half> %add1, 1
  ret { <2 x half>, <2 x half> } %insert.1
}

define <2 x half> @add_select_fabs_var_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; CI-LABEL: add_select_fabs_var_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v6
; CI-NEXT:    v_add_f32_e32 v1, v1, v7
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_var_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v6, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v4
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fabs_var_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v6, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_var_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v5, v6, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %select = select <2 x i1> %cmp, <2 x half> %fabs.x, <2 x half> %y
  %add = fadd <2 x half> %select, %z
  ret <2 x half> %add
}

define <2 x half> @add_select_fabs_negk_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: add_select_fabs_negk_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, -1.0, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, -1.0, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v4
; CI-NEXT:    v_add_f32_e32 v1, v1, v5
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_negk_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_mov_b32_e32 v4, 0xbc00
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fabs_negk_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xbc00
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_negk_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xbc00, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %select = select <2 x i1> %cmp, <2 x half> %fabs, <2 x half> <half -1.0, half -1.0>
  %add = fadd <2 x half> %select, %y
  ret <2 x half> %add
}

; FIXME: fabs should fold away
define <2 x half> @add_select_fabs_negk_negk_v2f16(<2 x i32> %c, <2 x half> %x) {
; CI-LABEL: add_select_fabs_negk_negk_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e64 v0, -1.0, -2.0, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e64 v1, -1.0, -2.0, vcc
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e64 v0, |v0|
; CI-NEXT:    v_cvt_f32_f16_e64 v1, |v1|
; CI-NEXT:    v_add_f32_e32 v0, v0, v2
; CI-NEXT:    v_add_f32_e32 v1, v1, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_negk_negk_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0xbc00
; VI-NEXT:    v_mov_b32_e32 v4, 0xc000
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    v_add_f16_sdwa v1, |v1|, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e64 v0, |v0|, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fabs_negk_negk_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xbc00
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xc000
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_negk_negk_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, 0xc000
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xbc00, v3, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v3, vcc_lo
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %select = select <2 x i1> %cmp, <2 x half> <half -2.0, half -2.0>, <2 x half> <half -1.0, half -1.0>
  %fabs = call <2 x half> @llvm.fabs.v2f16(<2 x half> %select)
  %add = fadd <2 x half> %fabs, %x
  ret <2 x half> %add
}

define <2 x half> @add_select_posk_posk_v2f16(<2 x i32> %c, <2 x half> %x) {
; CI-LABEL: add_select_posk_posk_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e64 v1, 1.0, 2.0, vcc
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e64 v0, 1.0, 2.0, vcc
; CI-NEXT:    v_add_f32_e32 v1, v1, v3
; CI-NEXT:    v_add_f32_e32 v0, v0, v2
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_posk_posk_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0x3c00
; VI-NEXT:    v_mov_b32_e32 v4, 0x4000
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_posk_posk_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, 0x3c00
; GFX9-NEXT:    v_mov_b32_e32 v4, 0x4000
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_posk_posk_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, 0x4000
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x3c00, v3, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v3, vcc_lo
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %select = select <2 x i1> %cmp, <2 x half> <half 2.0, half 2.0>, <2 x half> <half 1.0, half 1.0>
  %add = fadd <2 x half> %select, %x
  ret <2 x half> %add
}

define <2 x half> @add_select_negk_fabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: add_select_negk_fabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, -1.0, v3, vcc
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, -1.0, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v4
; CI-NEXT:    v_add_f32_e32 v1, v1, v5
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negk_fabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_mov_b32_e32 v4, 0xbc00
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_negk_fabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xbc00
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negk_fabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v2, vcc_lo
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xbc00, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %select = select <2 x i1> %cmp, <2 x half> <half -1.0, half -1.0>, <2 x half> %fabs
  %add = fadd <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @add_select_negliteralk_fabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: add_select_negliteralk_fabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_mov_b32_e32 v6, 0xc4800000
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v6, v3, vcc
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v6, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v4
; CI-NEXT:    v_add_f32_e32 v1, v1, v5
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negliteralk_fabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_mov_b32_e32 v4, 0xe400
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_negliteralk_fabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xe400
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negliteralk_fabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xe400, v2, vcc_lo
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xe400, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %select = select <2 x i1> %cmp, <2 x half> <half -1024.0, half -1024.0>, <2 x half> %fabs
  %add = fadd <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @add_select_fabs_posk_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: add_select_fabs_posk_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, 1.0, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, 1.0, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v4
; CI-NEXT:    v_add_f32_e32 v1, v1, v5
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_posk_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_mov_b32_e32 v4, 0x3c00
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fabs_posk_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_mov_b32_e32 v4, 0x3c00
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_posk_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x3c00, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %select = select <2 x i1> %cmp, <2 x half> %fabs, <2 x half> <half 1.0, half 1.0>
  %add = fadd <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @add_select_posk_fabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: add_select_posk_fabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, 1.0, v3, vcc
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, 1.0, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v4
; CI-NEXT:    v_add_f32_e32 v1, v1, v5
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_posk_fabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_mov_b32_e32 v4, 0x3c00
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_posk_fabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_mov_b32_e32 v4, 0x3c00
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_posk_fabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v2, vcc_lo
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x3c00, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %select = select <2 x i1> %cmp, <2 x half> <half 1.0, half 1.0>, <2 x half> %fabs
  %add = fadd <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @add_select_fneg_fneg_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; CI-LABEL: add_select_fneg_fneg_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v6, v0
; CI-NEXT:    v_sub_f32_e32 v1, v7, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_fneg_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v4, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fneg_fneg_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v4, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_fneg_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v4, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %fneg.y = fneg <2 x half> %y
  %select = select <2 x i1> %cmp, <2 x half> %fneg.x, <2 x half> %fneg.y
  %add = fadd <2 x half> %select, %z
  ret <2 x half> %add
}

define { <2 x half>, <2 x half> } @add_select_multi_use_lhs_fneg_fneg_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z, <2 x half> %w) {
; CI-LABEL: add_select_multi_use_lhs_fneg_fneg_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; CI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v6, v0
; CI-NEXT:    v_sub_f32_e32 v1, v7, v1
; CI-NEXT:    v_sub_f32_e32 v2, v8, v2
; CI-NEXT:    v_sub_f32_e32 v3, v9, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_multi_use_lhs_fneg_fneg_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v4, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_sub_f16_sdwa v1, v5, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v2, v5, v2
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_multi_use_lhs_fneg_fneg_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v4, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    v_pk_add_f16 v1, v5, v2 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_multi_use_lhs_fneg_fneg_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v1, v5, v2 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_pk_add_f16 v0, v4, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %fneg.y = fneg <2 x half> %y
  %select = select <2 x i1> %cmp, <2 x half> %fneg.x, <2 x half> %fneg.y
  %add0 = fadd <2 x half> %select, %z
  %add1 = fadd <2 x half> %fneg.x, %w
  %insert.0 = insertvalue { <2 x half>, <2 x half> } poison, <2 x half> %add0, 0
  %insert.1 = insertvalue { <2 x half>, <2 x half> } %insert.0, <2 x half> %add1, 1
  ret { <2 x half>, <2 x half> } %insert.1
}

define { <2 x half>, <2 x half> } @add_select_multi_store_use_lhs_fneg_fneg_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; CI-LABEL: add_select_multi_store_use_lhs_fneg_fneg_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_cvt_f32_f16_e32 v8, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v9, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cvt_f32_f16_e64 v2, -v2
; CI-NEXT:    v_cvt_f32_f16_e64 v3, -v3
; CI-NEXT:    v_cndmask_b32_e32 v1, v5, v8, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v9, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v6, v0
; CI-NEXT:    v_sub_f32_e32 v1, v7, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_multi_store_use_lhs_fneg_fneg_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_xor_b32_e32 v5, 0x80008000, v2
; VI-NEXT:    v_sub_f16_sdwa v1, v4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v4, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_mov_b32_e32 v1, v5
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_multi_store_use_lhs_fneg_fneg_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_xor_b32_e32 v5, 0x80008000, v2
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v4, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_multi_store_use_lhs_fneg_fneg_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80008000, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_pk_add_f16 v0, v4, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %fneg.y = fneg <2 x half> %y
  %select = select <2 x i1> %cmp, <2 x half> %fneg.x, <2 x half> %fneg.y
  %add0 = fadd <2 x half> %select, %z
  %insert.0 = insertvalue { <2 x half>, <2 x half> } poison, <2 x half> %add0, 0
  %insert.1 = insertvalue { <2 x half>, <2 x half> } %insert.0, <2 x half> %fneg.x, 1
  ret { <2 x half>, <2 x half> } %insert.1
}

define { <2 x half>, <2 x half> } @add_select_multi_use_rhs_fneg_fneg_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z, <2 x half> %w) {
; CI-LABEL: add_select_multi_use_rhs_fneg_fneg_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; CI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v6, v0
; CI-NEXT:    v_sub_f32_e32 v1, v7, v1
; CI-NEXT:    v_sub_f32_e32 v2, v8, v4
; CI-NEXT:    v_sub_f32_e32 v3, v9, v5
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_multi_use_rhs_fneg_fneg_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v4, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_sub_f16_sdwa v1, v5, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v2, v5, v3
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_multi_use_rhs_fneg_fneg_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v4, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    v_pk_add_f16 v1, v5, v3 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_multi_use_rhs_fneg_fneg_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v1, v5, v3 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_pk_add_f16 v0, v4, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %fneg.y = fneg <2 x half> %y
  %select = select <2 x i1> %cmp, <2 x half> %fneg.x, <2 x half> %fneg.y
  %add0 = fadd <2 x half> %select, %z
  %add1 = fadd <2 x half> %fneg.y, %w
  %insert.0 = insertvalue { <2 x half>, <2 x half> } poison, <2 x half> %add0, 0
  %insert.1 = insertvalue { <2 x half>, <2 x half> } %insert.0, <2 x half> %add1, 1
  ret { <2 x half>, <2 x half> } %insert.1
}

define <2 x half> @add_select_fneg_var_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; CI-LABEL: add_select_fneg_var_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_or_b32_e32 v2, v2, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v7
; CI-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v3, v7, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v6
; CI-NEXT:    v_add_f32_e32 v1, v1, v5
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_var_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v6, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v4
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fneg_var_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v6, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_var_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v5, v6, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %select = select <2 x i1> %cmp, <2 x half> %fneg.x, <2 x half> %y
  %add = fadd <2 x half> %select, %z
  ret <2 x half> %add
}

define <2 x half> @add_select_fneg_negk_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: add_select_fneg_negk_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, 1.0, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, 1.0, v2, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v4, v0
; CI-NEXT:    v_sub_f32_e32 v1, v5, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_negk_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; VI-NEXT:    v_mov_b32_e32 v5, 0x3c00
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v3, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fneg_negk_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_mov_b32_e32 v5, 0x3c00
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_negk_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x3c00, v4, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v2, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %select = select <2 x i1> %cmp, <2 x half> %fneg.x, <2 x half> <half -1.0, half -1.0>
  %add = fadd <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @add_select_fneg_inv2pi_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: add_select_fneg_inv2pi_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_mov_b32_e32 v6, 0xbe230000
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v6, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v6, v2, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v4, v0
; CI-NEXT:    v_sub_f32_e32 v1, v5, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_inv2pi_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; VI-NEXT:    v_mov_b32_e32 v5, 0xb118
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v3, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fneg_inv2pi_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_mov_b32_e32 v5, 0xb118
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_inv2pi_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xb118, v4, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xb118, v2, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %select = select <2 x i1> %cmp, <2 x half> %fneg.x, <2 x half> <half 0xH3118, half 0xH3118>
  %add = fadd <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @add_select_fneg_neginv2pi_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: add_select_fneg_neginv2pi_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_mov_b32_e32 v6, 0x3e230000
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v6, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v6, v2, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v4, v0
; CI-NEXT:    v_sub_f32_e32 v1, v5, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_neginv2pi_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; VI-NEXT:    v_mov_b32_e32 v5, 0x3118
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v3, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fneg_neginv2pi_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_mov_b32_e32 v5, 0x3118
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_neginv2pi_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x3118, v4, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x3118, v2, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %select = select <2 x i1> %cmp, <2 x half> %fneg.x, <2 x half> <half 0xHB118, half 0xHB118>
  %add = fadd <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @add_select_negk_negk_v2f16(<2 x i32> %c, <2 x half> %x) {
; CI-LABEL: add_select_negk_negk_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e64 v1, -1.0, -2.0, vcc
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e64 v0, -1.0, -2.0, vcc
; CI-NEXT:    v_add_f32_e32 v1, v1, v3
; CI-NEXT:    v_add_f32_e32 v0, v0, v2
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negk_negk_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0xbc00
; VI-NEXT:    v_mov_b32_e32 v4, 0xc000
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_negk_negk_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xbc00
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xc000
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negk_negk_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, 0xc000
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xbc00, v3, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v3, vcc_lo
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %select = select <2 x i1> %cmp, <2 x half> <half -2.0, half -2.0>, <2 x half> <half -1.0, half -1.0>
  %add = fadd <2 x half> %select, %x
  ret <2 x half> %add
}

define <2 x half> @add_select_negliteralk_negliteralk_v2f16(<2 x i32> %c, <2 x half> %x) {
; CI-LABEL: add_select_negliteralk_negliteralk_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_mov_b32_e32 v4, 0xc5800000
; CI-NEXT:    v_mov_b32_e32 v5, 0xc5000000
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v2
; CI-NEXT:    v_add_f32_e32 v1, v1, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negliteralk_negliteralk_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0xec00
; VI-NEXT:    v_mov_b32_e32 v4, 0xe800
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_negliteralk_negliteralk_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xec00
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xe800
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negliteralk_negliteralk_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, 0xe800
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xec00, v3, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xec00, v3, vcc_lo
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %select = select <2 x i1> %cmp, <2 x half> <half -2048.0, half -2048.0>, <2 x half> <half -4096.0, half -4096.0>
  %add = fadd <2 x half> %select, %x
  ret <2 x half> %add
}

define <2 x half> @add_select_fneg_negk_negk_v2f16(<2 x i32> %c, <2 x half> %x) {
; CI-LABEL: add_select_fneg_negk_negk_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e64 v1, -1.0, -2.0, vcc
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e64 v0, -1.0, -2.0, vcc
; CI-NEXT:    v_sub_f32_e32 v1, v3, v1
; CI-NEXT:    v_sub_f32_e32 v0, v2, v0
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_negk_negk_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0xbc00
; VI-NEXT:    v_mov_b32_e32 v4, 0xc000
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v2, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fneg_negk_negk_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xbc00
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xc000
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-NEXT:    v_pk_add_f16 v0, v2, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_negk_negk_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, 0xc000
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xbc00, v3, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v3, vcc_lo
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v2, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %select = select <2 x i1> %cmp, <2 x half> <half -2.0, half -2.0>, <2 x half> <half -1.0, half -1.0>
  %fneg.x = fneg <2 x half> %select
  %add = fadd <2 x half> %fneg.x, %x
  ret <2 x half> %add
}

define <2 x half> @add_select_negk_fneg_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: add_select_negk_fneg_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, 1.0, v3, vcc
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, 1.0, v2, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v4, v0
; CI-NEXT:    v_sub_f32_e32 v1, v5, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negk_fneg_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; VI-NEXT:    v_mov_b32_e32 v5, 0x3c00
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v3, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_negk_fneg_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_mov_b32_e32 v5, 0x3c00
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negk_fneg_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x3c00, v4, vcc_lo
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v2, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %select = select <2 x i1> %cmp, <2 x half> <half -1.0, half -1.0>, <2 x half> %fneg.x
  %add = fadd <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @add_select_fneg_posk_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: add_select_fneg_posk_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, -1.0, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, -1.0, v2, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v4, v0
; CI-NEXT:    v_sub_f32_e32 v1, v5, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_posk_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; VI-NEXT:    v_mov_b32_e32 v5, 0xbc00
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v3, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fneg_posk_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_mov_b32_e32 v5, 0xbc00
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_posk_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xbc00, v4, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v2, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %select = select <2 x i1> %cmp, <2 x half> %fneg.x, <2 x half> <half 1.0, half 1.0>
  %add = fadd <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @add_select_posk_fneg_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: add_select_posk_fneg_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, -1.0, v3, vcc
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, -1.0, v2, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v4, v0
; CI-NEXT:    v_sub_f32_e32 v1, v5, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_posk_fneg_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; VI-NEXT:    v_mov_b32_e32 v5, 0xbc00
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v3, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_posk_fneg_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_mov_b32_e32 v5, 0xbc00
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_posk_fneg_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xbc00, v4, vcc_lo
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v2, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v3, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %select = select <2 x i1> %cmp, <2 x half> <half 1.0, half 1.0>, <2 x half> %fneg.x
  %add = fadd <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @add_select_negfabs_fabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; CI-LABEL: add_select_negfabs_fabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_or_b32_e32 v2, v2, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v7
; CI-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e64 v5, |v5|
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e64 v4, |v4|
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v5, v7, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v6
; CI-NEXT:    v_add_f32_e32 v1, v1, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negfabs_fabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; VI-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v4
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_negfabs_fabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; GFX9-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negfabs_fabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fneg.fabs.x = fneg <2 x half> %fabs.x
  %fabs.y = call <2 x half> @llvm.fabs.v2f16(<2 x half> %y)
  %select = select <2 x i1> %cmp, <2 x half> %fneg.fabs.x, <2 x half> %fabs.y
  %add = fadd <2 x half> %select, %z
  ret <2 x half> %add
}

define <2 x half> @add_select_fabs_negfabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; CI-LABEL: add_select_fabs_negfabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; CI-NEXT:    v_or_b32_e32 v4, v4, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_or_b32_e32 v4, 0x80008000, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v7
; CI-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v7, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v6
; CI-NEXT:    v_add_f32_e32 v1, v1, v5
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_negfabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x80008000, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v4
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fabs_negfabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x80008000, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_negfabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_or_b32_e32 v3, 0x80008000, v3
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fabs.y = call <2 x half> @llvm.fabs.v2f16(<2 x half> %y)
  %fneg.fabs.y = fneg <2 x half> %fabs.y
  %select = select <2 x i1> %cmp, <2 x half> %fabs.x, <2 x half> %fneg.fabs.y
  %add = fadd <2 x half> %select, %z
  ret <2 x half> %add
}

define <2 x half> @add_select_neg_fabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; CI-LABEL: add_select_neg_fabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_or_b32_e32 v2, v2, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v7
; CI-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e64 v5, |v5|
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e64 v4, |v4|
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v5, v7, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v6
; CI-NEXT:    v_add_f32_e32 v1, v1, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_neg_fabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; VI-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v4
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_neg_fabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX9-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_neg_fabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %fabs.y = call <2 x half> @llvm.fabs.v2f16(<2 x half> %y)
  %select = select <2 x i1> %cmp, <2 x half> %fneg.x, <2 x half> %fabs.y
  %add = fadd <2 x half> %select, %z
  ret <2 x half> %add
}

define <2 x half> @add_select_fabs_neg_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; CI-LABEL: add_select_fabs_neg_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; CI-NEXT:    v_or_b32_e32 v4, v4, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_xor_b32_e32 v4, 0x80008000, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v7
; CI-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v7, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v6
; CI-NEXT:    v_add_f32_e32 v1, v1, v5
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_neg_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_xor_b32_e32 v3, 0x80008000, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; VI-NEXT:    v_add_f16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_add_f16_e32 v0, v0, v4
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_fabs_neg_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_xor_b32_e32 v3, 0x80008000, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_neg_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v3, 0x80008000, v3
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fneg.y = fneg <2 x half> %y
  %select = select <2 x i1> %cmp, <2 x half> %fabs.x, <2 x half> %fneg.y
  %add = fadd <2 x half> %select, %z
  ret <2 x half> %add
}

define <2 x half> @add_select_neg_negfabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; CI-LABEL: add_select_neg_negfabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e64 v5, |v5|
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e64 v4, |v4|
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v6, v0
; CI-NEXT:    v_sub_f32_e32 v1, v7, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_neg_negfabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v4, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_neg_negfabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v4, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_neg_negfabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v0, v4, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fneg.x = fneg <2 x half> %x
  %fabs.y = call <2 x half> @llvm.fabs.v2f16(<2 x half> %y)
  %fneg.fabs.y = fneg <2 x half> %fabs.y
  %select = select <2 x i1> %cmp, <2 x half> %fneg.x, <2 x half> %fneg.fabs.y
  %add = fadd <2 x half> %select, %z
  ret <2 x half> %add
}

define <2 x half> @add_select_negfabs_neg_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; CI-LABEL: add_select_negfabs_neg_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e64 v3, |v3|
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, v3, v5, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v6, v0
; CI-NEXT:    v_sub_f32_e32 v1, v7, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negfabs_neg_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_sub_f16_e32 v0, v4, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: add_select_negfabs_neg_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_add_f16 v0, v4, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negfabs_neg_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v6, v5, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_add_f16 v0, v4, v0 neg_lo:[0,1] neg_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fneg.fabs.x = fneg <2 x half> %fabs.x
  %fneg.y = fneg <2 x half> %y
  %select = select <2 x i1> %cmp, <2 x half> %fneg.y, <2 x half> %fneg.fabs.x
  %add = fadd <2 x half> %select, %z
  ret <2 x half> %add
}

define <2 x half> @mul_select_negfabs_posk_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: mul_select_negfabs_posk_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_or_b32_e32 v2, v2, v3
; CI-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v5
; CI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, 4.0, v5, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, 4.0, v2, vcc
; CI-NEXT:    v_mul_f32_e32 v0, v0, v4
; CI-NEXT:    v_mul_f32_e32 v1, v1, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: mul_select_negfabs_posk_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; VI-NEXT:    v_mov_b32_e32 v4, 0x4400
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; VI-NEXT:    v_mul_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_mul_f16_e32 v0, v0, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: mul_select_negfabs_posk_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; GFX9-NEXT:    v_mov_b32_e32 v4, 0x4400
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_mul_f16 v0, v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: mul_select_negfabs_posk_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x4400, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x4400, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_mul_f16 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fneg.fabs.x = fneg <2 x half> %fabs.x
  %select = select <2 x i1> %cmp, <2 x half> %fneg.fabs.x, <2 x half> <half 4.0, half 4.0>
  %add = fmul <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @mul_select_posk_negfabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: mul_select_posk_negfabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_or_b32_e32 v2, v2, v3
; CI-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v5
; CI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, 4.0, v5, vcc
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, 4.0, v2, vcc
; CI-NEXT:    v_mul_f32_e32 v0, v0, v4
; CI-NEXT:    v_mul_f32_e32 v1, v1, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: mul_select_posk_negfabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; VI-NEXT:    v_mov_b32_e32 v4, 0x4400
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; VI-NEXT:    v_mul_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_mul_f16_e32 v0, v0, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: mul_select_posk_negfabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; GFX9-NEXT:    v_mov_b32_e32 v4, 0x4400
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_mul_f16 v0, v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: mul_select_posk_negfabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x4400, v2, vcc_lo
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x4400, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_mul_f16 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fneg.fabs.x = fneg <2 x half> %fabs.x
  %select = select <2 x i1> %cmp, <2 x half> <half 4.0, half 4.0>, <2 x half> %fneg.fabs.x
  %add = fmul <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @mul_select_negfabs_negk_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: mul_select_negfabs_negk_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_or_b32_e32 v2, v2, v3
; CI-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v5
; CI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, -4.0, v5, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, -4.0, v2, vcc
; CI-NEXT:    v_mul_f32_e32 v0, v0, v4
; CI-NEXT:    v_mul_f32_e32 v1, v1, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: mul_select_negfabs_negk_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; VI-NEXT:    v_mov_b32_e32 v4, 0xc400
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; VI-NEXT:    v_mul_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_mul_f16_e32 v0, v0, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: mul_select_negfabs_negk_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xc400
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_mul_f16 v0, v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: mul_select_negfabs_negk_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xc400, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xc400, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_mul_f16 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fneg.fabs.x = fneg <2 x half> %fabs.x
  %select = select <2 x i1> %cmp, <2 x half> %fneg.fabs.x, <2 x half> <half -4.0, half -4.0>
  %add = fmul <2 x half> %select, %y
  ret <2 x half> %add
}

define <2 x half> @mul_select_negk_negfabs_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-LABEL: mul_select_negk_negfabs_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_or_b32_e32 v2, v2, v3
; CI-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v5
; CI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, -4.0, v5, vcc
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, -4.0, v2, vcc
; CI-NEXT:    v_mul_f32_e32 v0, v0, v4
; CI-NEXT:    v_mul_f32_e32 v1, v1, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: mul_select_negk_negfabs_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; VI-NEXT:    v_mov_b32_e32 v4, 0xc400
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; VI-NEXT:    v_mul_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_mul_f16_e32 v0, v0, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: mul_select_negk_negfabs_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xc400
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_pk_mul_f16 v0, v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: mul_select_negk_negfabs_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_or_b32_e32 v2, 0x80008000, v2
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xc400, v2, vcc_lo
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xc400, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    v_pk_mul_f16 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fabs.x = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fneg.fabs.x = fneg <2 x half> %fabs.x
  %select = select <2 x i1> %cmp, <2 x half> <half -4.0, half -4.0>, <2 x half> %fneg.fabs.x
  %add = fmul <2 x half> %select, %y
  ret <2 x half> %add
}

; --------------------------------------------------------------------------------
; Don't fold if fneg can fold into the source
; --------------------------------------------------------------------------------

define <2 x half> @select_fneg_posk_src_add_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %y) {
; CI-SAFE-LABEL: select_fneg_posk_src_add_v2f16:
; CI-SAFE:       ; %bb.0:
; CI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-SAFE-NEXT:    v_add_f32_e32 v3, 4.0, v3
; CI-SAFE-NEXT:    v_add_f32_e32 v2, 4.0, v2
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-SAFE-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-SAFE-NEXT:    v_or_b32_e32 v2, v2, v3
; CI-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; CI-SAFE-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-SAFE-NEXT:    v_cndmask_b32_e32 v0, 2.0, v3, vcc
; CI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-SAFE-NEXT:    v_cndmask_b32_e32 v1, 2.0, v2, vcc
; CI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: select_fneg_posk_src_add_v2f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_mov_b32_e32 v3, 0x4400
; VI-SAFE-NEXT:    v_add_f16_sdwa v3, v2, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SAFE-NEXT:    v_add_f16_e32 v2, 4.0, v2
; VI-SAFE-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; VI-SAFE-NEXT:    v_mov_b32_e32 v3, 0x4000
; VI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; VI-SAFE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VI-SAFE-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SAFE-LABEL: select_fneg_posk_src_add_v2f16:
; GFX9-SAFE:       ; %bb.0:
; GFX9-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SAFE-NEXT:    v_pk_add_f16 v2, v2, 4.0 op_sel_hi:[1,0]
; GFX9-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX9-SAFE-NEXT:    v_mov_b32_e32 v3, 0x4000
; GFX9-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SAFE-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-SAFE-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SAFE-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-SAFE-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-SAFE-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: select_fneg_posk_src_add_v2f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_pk_add_f16 v2, v2, 4.0 op_sel_hi:[1,0]
; GFX11-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-SAFE-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v2, vcc_lo
; GFX11-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v1, 0x4000, v3, vcc_lo
; GFX11-SAFE-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-NSZ-LABEL: select_fneg_posk_src_add_v2f16:
; CI-NSZ:       ; %bb.0:
; CI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NSZ-NEXT:    v_sub_f32_e32 v2, -4.0, v2
; CI-NSZ-NEXT:    v_sub_f32_e32 v3, -4.0, v3
; CI-NSZ-NEXT:    v_cndmask_b32_e32 v0, 2.0, v2, vcc
; CI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NSZ-NEXT:    v_cndmask_b32_e32 v1, 2.0, v3, vcc
; CI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: select_fneg_posk_src_add_v2f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_mov_b32_e32 v3, 0xc400
; VI-NSZ-NEXT:    v_sub_f16_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NSZ-NEXT:    v_sub_f16_e32 v2, -4.0, v2
; VI-NSZ-NEXT:    v_mov_b32_e32 v4, 0x4000
; VI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v1, v4, v3, vcc
; VI-NSZ-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VI-NSZ-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-NSZ-LABEL: select_fneg_posk_src_add_v2f16:
; GFX9-NSZ:       ; %bb.0:
; GFX9-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NSZ-NEXT:    v_pk_add_f16 v2, v2, -4.0 op_sel_hi:[1,0] neg_lo:[1,0] neg_hi:[1,0]
; GFX9-NSZ-NEXT:    v_mov_b32_e32 v3, 0x4000
; GFX9-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NSZ-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NSZ-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NSZ-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-NSZ-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NSZ-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: select_fneg_posk_src_add_v2f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_pk_add_f16 v2, v2, -4.0 op_sel_hi:[1,0] neg_lo:[1,0] neg_hi:[1,0]
; GFX11-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NSZ-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-NSZ-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v2, vcc_lo
; GFX11-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NSZ-NEXT:    v_cndmask_b32_e32 v1, 0x4000, v3, vcc_lo
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %add = fadd <2 x half> %x, <half 4.0, half 4.0>
  %fneg = fneg <2 x half> %add
  %select = select <2 x i1> %cmp, <2 x half> %fneg, <2 x half> <half 2.0, half 2.0>
  ret <2 x half> %select
}

define <2 x half> @select_fneg_posk_src_sub_v2f16(<2 x i32> %c, <2 x half> %x) {
; CI-SAFE-LABEL: select_fneg_posk_src_sub_v2f16:
; CI-SAFE:       ; %bb.0:
; CI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-SAFE-NEXT:    v_add_f32_e32 v3, -4.0, v3
; CI-SAFE-NEXT:    v_add_f32_e32 v2, -4.0, v2
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-SAFE-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-SAFE-NEXT:    v_or_b32_e32 v2, v2, v3
; CI-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; CI-SAFE-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-SAFE-NEXT:    v_cndmask_b32_e32 v0, 2.0, v3, vcc
; CI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-SAFE-NEXT:    v_cndmask_b32_e32 v1, 2.0, v2, vcc
; CI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: select_fneg_posk_src_sub_v2f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_mov_b32_e32 v3, 0xc400
; VI-SAFE-NEXT:    v_add_f16_sdwa v3, v2, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SAFE-NEXT:    v_add_f16_e32 v2, -4.0, v2
; VI-SAFE-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; VI-SAFE-NEXT:    v_mov_b32_e32 v3, 0x4000
; VI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; VI-SAFE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VI-SAFE-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SAFE-LABEL: select_fneg_posk_src_sub_v2f16:
; GFX9-SAFE:       ; %bb.0:
; GFX9-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SAFE-NEXT:    v_pk_add_f16 v2, v2, -4.0 op_sel_hi:[1,0]
; GFX9-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX9-SAFE-NEXT:    v_mov_b32_e32 v3, 0x4000
; GFX9-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SAFE-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-SAFE-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SAFE-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-SAFE-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-SAFE-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: select_fneg_posk_src_sub_v2f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_pk_add_f16 v2, v2, -4.0 op_sel_hi:[1,0]
; GFX11-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-SAFE-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v2, vcc_lo
; GFX11-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v1, 0x4000, v3, vcc_lo
; GFX11-SAFE-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-NSZ-LABEL: select_fneg_posk_src_sub_v2f16:
; CI-NSZ:       ; %bb.0:
; CI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NSZ-NEXT:    v_sub_f32_e32 v2, 4.0, v2
; CI-NSZ-NEXT:    v_sub_f32_e32 v3, 4.0, v3
; CI-NSZ-NEXT:    v_cndmask_b32_e32 v0, 2.0, v2, vcc
; CI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NSZ-NEXT:    v_cndmask_b32_e32 v1, 2.0, v3, vcc
; CI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: select_fneg_posk_src_sub_v2f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_mov_b32_e32 v3, 0x4400
; VI-NSZ-NEXT:    v_sub_f16_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NSZ-NEXT:    v_sub_f16_e32 v2, 4.0, v2
; VI-NSZ-NEXT:    v_mov_b32_e32 v4, 0x4000
; VI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v1, v4, v3, vcc
; VI-NSZ-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VI-NSZ-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-NSZ-LABEL: select_fneg_posk_src_sub_v2f16:
; GFX9-NSZ:       ; %bb.0:
; GFX9-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NSZ-NEXT:    v_pk_add_f16 v2, v2, 4.0 op_sel_hi:[1,0] neg_lo:[1,0] neg_hi:[1,0]
; GFX9-NSZ-NEXT:    v_mov_b32_e32 v3, 0x4000
; GFX9-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NSZ-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NSZ-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NSZ-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-NSZ-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NSZ-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: select_fneg_posk_src_sub_v2f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_pk_add_f16 v2, v2, 4.0 op_sel_hi:[1,0] neg_lo:[1,0] neg_hi:[1,0]
; GFX11-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NSZ-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-NSZ-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v2, vcc_lo
; GFX11-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NSZ-NEXT:    v_cndmask_b32_e32 v1, 0x4000, v3, vcc_lo
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %add = fsub <2 x half> %x, <half 4.0, half 4.0>
  %fneg = fneg <2 x half> %add
  %select = select <2 x i1> %cmp, <2 x half> %fneg, <2 x half> <half 2.0, half 2.0>
  ret <2 x half> %select
}

define <2 x half> @select_fneg_posk_src_mul_v2f16(<2 x i32> %c, <2 x half> %x) {
; CI-LABEL: select_fneg_posk_src_mul_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_mul_f32_e32 v2, -4.0, v2
; CI-NEXT:    v_mul_f32_e32 v3, -4.0, v3
; CI-NEXT:    v_cndmask_b32_e32 v0, 2.0, v2, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, 2.0, v3, vcc
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: select_fneg_posk_src_mul_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0xc400
; VI-NEXT:    v_mul_f16_sdwa v3, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_mul_f16_e32 v2, -4.0, v2
; VI-NEXT:    v_mov_b32_e32 v4, 0x4000
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v3, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: select_fneg_posk_src_mul_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_mul_f16 v2, v2, -4.0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_mov_b32_e32 v3, 0x4000
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: select_fneg_posk_src_mul_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_mul_f16 v2, v2, -4.0 op_sel_hi:[1,0]
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x4000, v3, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %mul = fmul <2 x half> %x, <half 4.0, half 4.0>
  %fneg = fneg <2 x half> %mul
  %select = select <2 x i1> %cmp, <2 x half> %fneg, <2 x half> <half 2.0, half 2.0>
  ret <2 x half> %select
}

define <2 x half> @select_fneg_posk_src_fma_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %z) {
; CI-LABEL: select_fneg_posk_src_fma_v2f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_fma_f32 v3, v3, 4.0, v5
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_fma_f32 v2, v2, 4.0, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_or_b32_e32 v2, v2, v3
; CI-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v2
; CI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, 2.0, v3, vcc
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NEXT:    v_cndmask_b32_e32 v1, 2.0, v2, vcc
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: select_fneg_posk_src_fma_v2f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; VI-SAFE-NEXT:    v_fma_f16 v4, v5, 4.0, v4
; VI-SAFE-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; VI-SAFE-NEXT:    v_fma_f16 v2, v2, 4.0, v3
; VI-SAFE-NEXT:    v_or_b32_e32 v2, v2, v4
; VI-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; VI-SAFE-NEXT:    v_mov_b32_e32 v3, 0x4000
; VI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; VI-SAFE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VI-SAFE-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SAFE-LABEL: select_fneg_posk_src_fma_v2f16:
; GFX9-SAFE:       ; %bb.0:
; GFX9-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SAFE-NEXT:    v_pk_fma_f16 v2, v2, 4.0, v3 op_sel_hi:[1,0,1]
; GFX9-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX9-SAFE-NEXT:    v_mov_b32_e32 v3, 0x4000
; GFX9-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SAFE-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-SAFE-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SAFE-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-SAFE-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-SAFE-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: select_fneg_posk_src_fma_v2f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_pk_fma_f16 v2, v2, 4.0, v3 op_sel_hi:[1,0,1]
; GFX11-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-SAFE-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v2, vcc_lo
; GFX11-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v1, 0x4000, v3, vcc_lo
; GFX11-SAFE-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: select_fneg_posk_src_fma_v2f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; VI-NSZ-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; VI-NSZ-NEXT:    v_fma_f16 v2, v2, -4.0, -v3
; VI-NSZ-NEXT:    v_mov_b32_e32 v3, 0x4000
; VI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NSZ-NEXT:    v_fma_f16 v4, v5, -4.0, -v4
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NSZ-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VI-NSZ-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-NSZ-LABEL: select_fneg_posk_src_fma_v2f16:
; GFX9-NSZ:       ; %bb.0:
; GFX9-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NSZ-NEXT:    v_pk_fma_f16 v2, v2, -4.0, v3 op_sel_hi:[1,0,1] neg_lo:[0,0,1] neg_hi:[0,0,1]
; GFX9-NSZ-NEXT:    v_mov_b32_e32 v3, 0x4000
; GFX9-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NSZ-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NSZ-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NSZ-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-NSZ-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NSZ-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: select_fneg_posk_src_fma_v2f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_pk_fma_f16 v2, v2, -4.0, v3 op_sel_hi:[1,0,1] neg_lo:[0,0,1] neg_hi:[0,0,1]
; GFX11-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NSZ-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-NSZ-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v2, vcc_lo
; GFX11-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NSZ-NEXT:    v_cndmask_b32_e32 v1, 0x4000, v3, vcc_lo
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fma = call <2 x half> @llvm.fma.v2f16(<2 x half> %x, <2 x half> <half 4.0, half 4.0>, <2 x half> %z)
  %fneg = fneg <2 x half> %fma
  %select = select <2 x i1> %cmp, <2 x half> %fneg, <2 x half> <half 2.0, half 2.0>
  ret <2 x half> %select
}

define <2 x half> @select_fneg_posk_src_fmad_v2f16(<2 x i32> %c, <2 x half> %x, <2 x half> %z) {
; CI-SAFE-LABEL: select_fneg_posk_src_fmad_v2f16:
; CI-SAFE:       ; %bb.0:
; CI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-SAFE-NEXT:    v_mul_f32_e32 v3, 4.0, v3
; CI-SAFE-NEXT:    v_add_f32_e32 v3, v3, v5
; CI-SAFE-NEXT:    v_mul_f32_e32 v2, 4.0, v2
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-SAFE-NEXT:    v_add_f32_e32 v2, v2, v4
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-SAFE-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-SAFE-NEXT:    v_or_b32_e32 v2, v2, v3
; CI-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; CI-SAFE-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-SAFE-NEXT:    v_cndmask_b32_e32 v0, 2.0, v3, vcc
; CI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-SAFE-NEXT:    v_cndmask_b32_e32 v1, 2.0, v2, vcc
; CI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: select_fneg_posk_src_fmad_v2f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; VI-SAFE-NEXT:    v_fma_f16 v4, v5, 4.0, v4
; VI-SAFE-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; VI-SAFE-NEXT:    v_fma_f16 v2, v2, 4.0, v3
; VI-SAFE-NEXT:    v_or_b32_e32 v2, v2, v4
; VI-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; VI-SAFE-NEXT:    v_mov_b32_e32 v3, 0x4000
; VI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-SAFE-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; VI-SAFE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VI-SAFE-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SAFE-LABEL: select_fneg_posk_src_fmad_v2f16:
; GFX9-SAFE:       ; %bb.0:
; GFX9-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SAFE-NEXT:    v_pk_fma_f16 v2, v2, 4.0, v3 op_sel_hi:[1,0,1]
; GFX9-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX9-SAFE-NEXT:    v_mov_b32_e32 v3, 0x4000
; GFX9-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SAFE-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-SAFE-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SAFE-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-SAFE-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-SAFE-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: select_fneg_posk_src_fmad_v2f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_pk_fma_f16 v2, v2, 4.0, v3 op_sel_hi:[1,0,1]
; GFX11-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-SAFE-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v2, vcc_lo
; GFX11-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v1, 0x4000, v3, vcc_lo
; GFX11-SAFE-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-NSZ-LABEL: select_fneg_posk_src_fmad_v2f16:
; CI-NSZ:       ; %bb.0:
; CI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v5, v5
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v5, v5
; CI-NSZ-NEXT:    v_mul_f32_e32 v2, -4.0, v2
; CI-NSZ-NEXT:    v_mul_f32_e32 v3, -4.0, v3
; CI-NSZ-NEXT:    v_sub_f32_e32 v2, v2, v4
; CI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NSZ-NEXT:    v_sub_f32_e32 v3, v3, v5
; CI-NSZ-NEXT:    v_cndmask_b32_e32 v0, 2.0, v2, vcc
; CI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; CI-NSZ-NEXT:    v_cndmask_b32_e32 v1, 2.0, v3, vcc
; CI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: select_fneg_posk_src_fmad_v2f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; VI-NSZ-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; VI-NSZ-NEXT:    v_fma_f16 v2, v2, -4.0, -v3
; VI-NSZ-NEXT:    v_mov_b32_e32 v3, 0x4000
; VI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NSZ-NEXT:    v_fma_f16 v4, v5, -4.0, -v4
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; VI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NSZ-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; VI-NSZ-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-NSZ-LABEL: select_fneg_posk_src_fmad_v2f16:
; GFX9-NSZ:       ; %bb.0:
; GFX9-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NSZ-NEXT:    v_pk_fma_f16 v2, v2, -4.0, v3 op_sel_hi:[1,0,1] neg_lo:[0,0,1] neg_hi:[0,0,1]
; GFX9-NSZ-NEXT:    v_mov_b32_e32 v3, 0x4000
; GFX9-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NSZ-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NSZ-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NSZ-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-NSZ-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NSZ-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: select_fneg_posk_src_fmad_v2f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_pk_fma_f16 v2, v2, -4.0, v3 op_sel_hi:[1,0,1] neg_lo:[0,0,1] neg_hi:[0,0,1]
; GFX11-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NSZ-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-NSZ-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v2, vcc_lo
; GFX11-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NSZ-NEXT:    v_cndmask_b32_e32 v1, 0x4000, v3, vcc_lo
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NSZ-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq <2 x i32> %c, zeroinitializer
  %fmad = call <2 x half> @llvm.fmuladd.v2f16(<2 x half> %x, <2 x half> <half 4.0, half 4.0>, <2 x half> %z)
  %fneg = fneg <2 x half> %fmad
  %select = select <2 x i1> %cmp, <2 x half> %fneg, <2 x half> <half 2.0, half 2.0>
  ret <2 x half> %select
}

declare <2 x half> @llvm.fabs.v2f16(<2 x half>) #0
declare <2 x half> @llvm.fma.v2f16(<2 x half>, <2 x half>, <2 x half>) #0
declare <2 x half> @llvm.fmuladd.v2f16(<2 x half>, <2 x half>, <2 x half>) #0

attributes #0 = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
