; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

; i8
define <4 x i8> @vls_sve_and_4xi8(<4 x i8> %b) nounwind {
; CHECK-LABEL: vls_sve_and_4xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI0_0
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI0_0]
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
 %c = and <4 x i8> %b, <i8 0, i8 255, i8 0, i8 255>
 ret <4 x i8> %c
}

define <8 x i8> @vls_sve_and_8xi8(<8 x i8> %b) nounwind {
; CHECK-LABEL: vls_sve_and_8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI1_0
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI1_0]
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
 %c = and <8 x i8> %b, <i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255>
 ret <8 x i8> %c
}

define <16 x i8> @vls_sve_and_16xi8(<16 x i8> %b) nounwind {
; CHECK-LABEL: vls_sve_and_16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI2_0
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI2_0]
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
 %c = and <16 x i8> %b, <i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255>
 ret <16 x i8> %c
}

define <32 x i8> @vls_sve_and_32xi8(<32 x i8> %ap) nounwind {
; CHECK-LABEL: vls_sve_and_32xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI3_0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ldr q2, [x8, :lo12:.LCPI3_0]
; CHECK-NEXT:    and z0.d, z0.d, z2.d
; CHECK-NEXT:    and z1.d, z1.d, z2.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
 %b = and <32 x i8> %ap, <i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255,
                         i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255>
 ret <32 x i8> %b
}

; i16
define <2 x i16> @vls_sve_and_2xi16(<2 x i16> %b) nounwind {
; CHECK-LABEL: vls_sve_and_2xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov z0.s, z0.s[1]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    stp wzr, w8, [sp, #8]
; CHECK-NEXT:    ldr d0, [sp, #8]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
 %c = and <2 x i16> %b, <i16 0, i16 65535>
 ret <2 x i16> %c
}

define <4 x i16> @vls_sve_and_4xi16(<4 x i16> %b) nounwind {
; CHECK-LABEL: vls_sve_and_4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI5_0
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI5_0]
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
 %c = and <4 x i16> %b, <i16 0, i16 65535, i16 0, i16 65535>
 ret <4 x i16> %c
}

define <8 x i16> @vls_sve_and_8xi16(<8 x i16> %b) nounwind {
; CHECK-LABEL: vls_sve_and_8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI6_0
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI6_0]
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
 %c = and <8 x i16> %b, <i16 0, i16 65535, i16 0, i16 65535, i16 0, i16 65535, i16 0, i16 65535>
 ret <8 x i16> %c
}

define <16 x i16> @vls_sve_and_16xi16(<16 x i16> %b) nounwind {
; CHECK-LABEL: vls_sve_and_16xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI7_0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ldr q2, [x8, :lo12:.LCPI7_0]
; CHECK-NEXT:    and z0.d, z0.d, z2.d
; CHECK-NEXT:    and z1.d, z1.d, z2.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
 %c = and <16 x i16> %b, <i16 0, i16 65535, i16 0, i16 65535, i16 0, i16 65535, i16 0, i16 65535, i16 0, i16 65535, i16 0, i16 65535, i16 0, i16 65535, i16 0, i16 65535>
 ret <16 x i16> %c
}

; i32
define <2 x i32> @vls_sve_and_2xi32(<2 x i32> %b) nounwind {
; CHECK-LABEL: vls_sve_and_2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    index z1.s, #0, #-1
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
 %c = and <2 x i32> %b, <i32 0, i32 4294967295>
 ret <2 x i32> %c
}

define <4 x i32> @vls_sve_and_4xi32(<4 x i32> %b) nounwind {
; CHECK-LABEL: vls_sve_and_4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI9_0
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI9_0]
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
 %c = and <4 x i32> %b, <i32 0, i32 4294967295, i32 0, i32 4294967295>
 ret <4 x i32> %c
}

define <8 x i32> @vls_sve_and_8xi32(<8 x i32> %b) nounwind {
; CHECK-LABEL: vls_sve_and_8xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI10_0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ldr q2, [x8, :lo12:.LCPI10_0]
; CHECK-NEXT:    and z0.d, z0.d, z2.d
; CHECK-NEXT:    and z1.d, z1.d, z2.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
 %c = and <8 x i32> %b, <i32 0, i32 4294967295, i32 0, i32 4294967295, i32 0, i32 4294967295, i32 0, i32 4294967295>
 ret <8 x i32> %c
}

; i64
define <2 x i64> @vls_sve_and_2xi64(<2 x i64> %b) nounwind {
; CHECK-LABEL: vls_sve_and_2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    index z1.d, #0, #-1
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
 %c = and <2 x i64> %b, <i64 0, i64 18446744073709551615>
 ret <2 x i64> %c
}

define <4 x i64> @vls_sve_and_4xi64(<4 x i64> %b) nounwind {
; CHECK-LABEL: vls_sve_and_4xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    index z2.d, #0, #-1
; CHECK-NEXT:    and z0.d, z0.d, z2.d
; CHECK-NEXT:    and z1.d, z1.d, z2.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
 %c = and <4 x i64> %b, <i64 0, i64 18446744073709551615, i64 0, i64 18446744073709551615>
 ret <4 x i64> %c
}
