/*
Copyright The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	scheme "kubevirt.io/client-go/generated/containerized-data-importer/clientset/versioned/scheme"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
)

// VolumeUploadSourcesGetter has a method to return a VolumeUploadSourceInterface.
// A group's client should implement this interface.
type VolumeUploadSourcesGetter interface {
	VolumeUploadSources(namespace string) VolumeUploadSourceInterface
}

// VolumeUploadSourceInterface has methods to work with VolumeUploadSource resources.
type VolumeUploadSourceInterface interface {
	Create(ctx context.Context, volumeUploadSource *v1beta1.VolumeUploadSource, opts v1.CreateOptions) (*v1beta1.VolumeUploadSource, error)
	Update(ctx context.Context, volumeUploadSource *v1beta1.VolumeUploadSource, opts v1.UpdateOptions) (*v1beta1.VolumeUploadSource, error)
	UpdateStatus(ctx context.Context, volumeUploadSource *v1beta1.VolumeUploadSource, opts v1.UpdateOptions) (*v1beta1.VolumeUploadSource, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.VolumeUploadSource, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.VolumeUploadSourceList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.VolumeUploadSource, err error)
	VolumeUploadSourceExpansion
}

// volumeUploadSources implements VolumeUploadSourceInterface
type volumeUploadSources struct {
	client rest.Interface
	ns     string
}

// newVolumeUploadSources returns a VolumeUploadSources
func newVolumeUploadSources(c *CdiV1beta1Client, namespace string) *volumeUploadSources {
	return &volumeUploadSources{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the volumeUploadSource, and returns the corresponding volumeUploadSource object, and an error if there is any.
func (c *volumeUploadSources) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.VolumeUploadSource, err error) {
	result = &v1beta1.VolumeUploadSource{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("volumeuploadsources").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of VolumeUploadSources that match those selectors.
func (c *volumeUploadSources) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.VolumeUploadSourceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.VolumeUploadSourceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("volumeuploadsources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested volumeUploadSources.
func (c *volumeUploadSources) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("volumeuploadsources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a volumeUploadSource and creates it.  Returns the server's representation of the volumeUploadSource, and an error, if there is any.
func (c *volumeUploadSources) Create(ctx context.Context, volumeUploadSource *v1beta1.VolumeUploadSource, opts v1.CreateOptions) (result *v1beta1.VolumeUploadSource, err error) {
	result = &v1beta1.VolumeUploadSource{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("volumeuploadsources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(volumeUploadSource).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a volumeUploadSource and updates it. Returns the server's representation of the volumeUploadSource, and an error, if there is any.
func (c *volumeUploadSources) Update(ctx context.Context, volumeUploadSource *v1beta1.VolumeUploadSource, opts v1.UpdateOptions) (result *v1beta1.VolumeUploadSource, err error) {
	result = &v1beta1.VolumeUploadSource{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("volumeuploadsources").
		Name(volumeUploadSource.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(volumeUploadSource).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *volumeUploadSources) UpdateStatus(ctx context.Context, volumeUploadSource *v1beta1.VolumeUploadSource, opts v1.UpdateOptions) (result *v1beta1.VolumeUploadSource, err error) {
	result = &v1beta1.VolumeUploadSource{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("volumeuploadsources").
		Name(volumeUploadSource.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(volumeUploadSource).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the volumeUploadSource and deletes it. Returns an error if one occurs.
func (c *volumeUploadSources) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("volumeuploadsources").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *volumeUploadSources) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("volumeuploadsources").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched volumeUploadSource.
func (c *volumeUploadSources) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.VolumeUploadSource, err error) {
	result = &v1beta1.VolumeUploadSource{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("volumeuploadsources").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
