---
nav_order: 2
parent: Usage
---

# Metadata attributes

Afterburn can consume cloud-specific metadata and serialize instance attributes into an environment file (e.g. `/run/metadata/afterburn`), which can then be consumed by systemd service units via `EnvironmentFile=`.

Usually, OS vendors which ship Afterburn do not enable it by default. Therefore, any service
which wants to make use of Afterburn metadata must explicitly pull it in using e.g.
`Requires=afterburn.service` and `After=afterburn.service`.

Cloud providers with supported metadata endpoints and their respective attributes are listed below.

* akamai
  - AFTERBURN_AKAMAI_INSTANCE_HOST_UUID
  - AFTERBURN_AKAMAI_INSTANCE_ID
  - AFTERBURN_AKAMAI_INSTANCE_LABEL
  - AFTERBURN_AKAMAI_INSTANCE_REGION
  - AFTERBURN_AKAMAI_INSTANCE_TAGS
  - AFTERBURN_AKAMAI_INSTANCE_TYPE
  - AFTERBURN_AKAMAI_IPV6_LINK_LOCAL
  - AFTERBURN_AKAMAI_IPV6_RANGE_0
  - AFTERBURN_AKAMAI_IPV6_SHARED_RANGE_0
  - AFTERBURN_AKAMAI_IPV6_SLAAC
  - AFTERBURN_AKAMAI_PRIVATE_IPV4_0
  - AFTERBURN_AKAMAI_PUBLIC_IPV4_0
  - AFTERBURN_AKAMAI_SHARED_IPV4_0
* aliyun
  - AFTERBURN_ALIYUN_EIPV4
  - AFTERBURN_ALIYUN_HOSTNAME
  - AFTERBURN_ALIYUN_IMAGE_ID
  - AFTERBURN_ALIYUN_INSTANCE_ID
  - AFTERBURN_ALIYUN_INSTANCE_TYPE
  - AFTERBURN_ALIYUN_IPV4_PRIVATE
  - AFTERBURN_ALIYUN_IPV4_PUBLIC
  - AFTERBURN_ALIYUN_REGION_ID
  - AFTERBURN_ALIYUN_VPC_ID
  - AFTERBURN_ALIYUN_ZONE_ID
* aws
  - AFTERBURN_AWS_HOSTNAME
  - AFTERBURN_AWS_PUBLIC_HOSTNAME
  - AFTERBURN_AWS_IPV4_LOCAL
  - AFTERBURN_AWS_IPV4_PUBLIC
  - AFTERBURN_AWS_IPV6
  - AFTERBURN_AWS_AVAILABILITY_ZONE
  - AFTERBURN_AWS_INSTANCE_ID
  - AFTERBURN_AWS_INSTANCE_TYPE
  - AFTERBURN_AWS_REGION
* azure
  - AFTERBURN_AZURE_IPV4_DYNAMIC
  - AFTERBURN_AZURE_IPV4_VIRTUAL
  - AFTERBURN_AZURE_VMSIZE
* cloudstack-configdrive
  - AFTERBURN_CLOUDSTACK_AVAILABILITY_ZONE
  - AFTERBURN_CLOUDSTACK_INSTANCE_ID
  - AFTERBURN_CLOUDSTACK_SERVICE_OFFERING
  - AFTERBURN_CLOUDSTACK_CLOUD_IDENTIFIER
  - AFTERBURN_CLOUDSTACK_LOCAL_HOSTNAME
  - AFTERBURN_CLOUDSTACK_VM_ID
* cloudstack-metadata
  - AFTERBURN_CLOUDSTACK_AVAILABILITY_ZONE
  - AFTERBURN_CLOUDSTACK_CLOUD_IDENTIFIER
  - AFTERBURN_CLOUDSTACK_HOSTNAME
  - AFTERBURN_CLOUDSTACK_INSTANCE_ID
  - AFTERBURN_CLOUDSTACK_IPV4_LOCAL
  - AFTERBURN_CLOUDSTACK_IPV4_PUBLIC
  - AFTERBURN_CLOUDSTACK_LOCAL_HOSTNAME
  - AFTERBURN_CLOUDSTACK_PUBLIC_HOSTNAME
  - AFTERBURN_CLOUDSTACK_SERVICE_OFFERING
  - AFTERBURN_CLOUDSTACK_VM_ID
* digitalocean
  - AFTERBURN_DIGITALOCEAN_HOSTNAME
  - AFTERBURN_DIGITALOCEAN_IPV4_ANCHOR_0
  - AFTERBURN_DIGITALOCEAN_IPV4_PUBLIC_0
  - AFTERBURN_DIGITALOCEAN_IPV4_PRIVATE_0
  - AFTERBURN_DIGITALOCEAN_IPV6_PUBLIC_0
  - AFTERBURN_DIGITALOCEAN_IPV6_PRIVATE_0
  - AFTERBURN_DIGITALOCEAN_REGION
* exoscale
  - AFTERBURN_EXOSCALE_AVAILABILITY_ZONE
  - AFTERBURN_EXOSCALE_CLOUD_IDENTIFIER
  - AFTERBURN_EXOSCALE_INSTANCE_ID
  - AFTERBURN_EXOSCALE_LOCAL_IPV4
  - AFTERBURN_EXOSCALE_PUBLIC_IPV4
  - AFTERBURN_EXOSCALE_LOCAL_HOSTNAME
  - AFTERBURN_EXOSCALE_PUBLIC_HOSTNAME
  - AFTERBURN_EXOSCALE_SERVICE_OFFERING
  - AFTERBURN_EXOSCALE_VM_ID
* gcp
  - AFTERBURN_GCP_HOSTNAME
  - AFTERBURN_GCP_IP_EXTERNAL_0
  - AFTERBURN_GCP_IP_LOCAL_0
  - AFTERBURN_GCP_MACHINE_TYPE
* hetzner
  - AFTERBURN_HETZNER_AVAILABILITY_ZONE
  - AFTERBURN_HETZNER_HOSTNAME
  - AFTERBURN_HETZNER_INSTANCE_ID
  - AFTERBURN_HETZNER_PUBLIC_IPV4
  - AFTERBURN_HETZNER_PRIVATE_IPV4_0
  - AFTERBURN_HETZNER_REGION
* ibmcloud
  - AFTERBURN_IBMCLOUD_INSTANCE_ID
  - AFTERBURN_IBMCLOUD_LOCAL_HOSTNAME
* ibmcloud-classic
  - AFTERBURN_IBMCLOUD_CLASSIC_INSTANCE_ID
  - AFTERBURN_IBMCLOUD_CLASSIC_LOCAL_HOSTNAME
* kubevirt
  - AFTERBURN_KUBEVIRT_HOSTNAME
  - AFTERBURN_KUBEVIRT_INSTANCE_ID
  - AFTERBURN_KUBEVIRT_INSTANCE_TYPE
* openstack
  - AFTERBURN_OPENSTACK_HOSTNAME
  - AFTERBURN_OPENSTACK_IPV4_LOCAL
  - AFTERBURN_OPENSTACK_IPV4_PUBLIC
  - AFTERBURN_OPENSTACK_INSTANCE_ID — EC2-style instance ID, not used in OpenStack API
  - AFTERBURN_OPENSTACK_INSTANCE_UUID — OpenStack instance UUID (Afterburn ≥ 5.5.0)
  - AFTERBURN_OPENSTACK_INSTANCE_TYPE
* openstack-metadata
  - AFTERBURN_OPENSTACK_HOSTNAME
  - AFTERBURN_OPENSTACK_IPV4_LOCAL
  - AFTERBURN_OPENSTACK_IPV4_PUBLIC
  - AFTERBURN_OPENSTACK_INSTANCE_ID — EC2-style instance ID, not used in OpenStack API
  - AFTERBURN_OPENSTACK_INSTANCE_UUID — OpenStack instance UUID (Afterburn ≥ 5.5.0)
  - AFTERBURN_OPENSTACK_INSTANCE_TYPE
* oraclecloud
  - AFTERBURN_ORACLECLOUD_AVAILABILITY_DOMAIN
  - AFTERBURN_ORACLECLOUD_COMPARTMENT_ID
  - AFTERBURN_ORACLECLOUD_FAULT_DOMAIN
  - AFTERBURN_ORACLECLOUD_HOSTNAME
  - AFTERBURN_ORACLECLOUD_INSTANCE_ID
  - AFTERBURN_ORACLECLOUD_INSTANCE_SHAPE
  - AFTERBURN_ORACLECLOUD_REGION_ID
* packet
  - AFTERBURN_PACKET_HOSTNAME
  - AFTERBURN_PACKET_PLAN
  - AFTERBURN_PACKET_IPV4_PUBLIC_0
  - AFTERBURN_PACKET_IPV4_PUBLIC_GATEWAY_0
  - AFTERBURN_PACKET_IPV4_PRIVATE_0
  - AFTERBURN_PACKET_IPV4_PRIVATE_GATEWAY_0
  - AFTERBURN_PACKET_IPV6_PUBLIC_0
  - AFTERBURN_PACKET_IPV6_PUBLIC_GATEWAY_0
* powervs
  - AFTERBURN_POWERVS_INSTANCE_ID
  - AFTERBURN_POWERVS_LOCAL_HOSTNAME
* proxmoxve
  - AFTERBURN_PROXMOXVE_HOSTNAME
  - AFTERBURN_PROXMOXVE_INSTANCE_ID
  - AFTERBURN_PROXMOXVE_IPV4
  - AFTERBURN_PROXMOXVE_IPV6
* scaleway
  - AFTERBURN_SCALEWAY_HOSTNAME
  - AFTERBURN_SCALEWAY_INSTANCE_ID
  - AFTERBURN_SCALEWAY_INSTANCE_TYPE
  - AFTERBURN_SCALEWAY_PRIVATE_IPV4
  - AFTERBURN_SCALEWAY_PUBLIC_IPV4
  - AFTERBURN_SCALEWAY_PUBLIC_IPV6
  - AFTERBURN_SCALEWAY_ZONE_ID
* upcloud
  - AFTERBURN_UPCLOUD_HOSTNAME
  - AFTERBURN_UPCLOUD_INSTANCE_ID
  - AFTERBURN_UPCLOUD_REGION
* vultr
  - AFTERBURN_VULTR_HOSTNAME
  - AFTERBURN_VULTR_INSTANCE_ID
  - AFTERBURN_VULTR_REGION_CODE

Additionally, some attribute names are reserved for custom metadata providers.
These can be safely used by external providers on platforms not supported by Afterburn:

* custom
  - AFTERBURN_CUSTOM_HOSTNAME
  - AFTERBURN_CUSTOM_PUBLIC_IPV4
  - AFTERBURN_CUSTOM_PRIVATE_IPV4
  - AFTERBURN_CUSTOM_PUBLIC_IPV6
  - AFTERBURN_CUSTOM_PRIVATE_IPV6
