// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX10,W32 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=-wavefrontsize32,+wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX10,W64 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32,-wavefrontsize64 %s 2>&1 | FileCheck --check-prefix=W32-ERR --implicit-check-not=error: %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=-wavefrontsize32,+wavefrontsize64 %s 2>&1 | FileCheck --check-prefix=W64-ERR --implicit-check-not=error: %s

//===----------------------------------------------------------------------===//
// ENC_VOP2.
//===----------------------------------------------------------------------===//

v_cndmask_b32_e32 v5, v1, v2, vcc
// W64: encoding: [0x01,0x05,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v255, v1, v2, vcc
// W64: encoding: [0x01,0x05,0xfe,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, v255, v2, vcc
// W64: encoding: [0xff,0x05,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, 0, v2, vcc
// W64: encoding: [0x80,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, -1, v2, vcc
// W64: encoding: [0xc1,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, 0.5, v2, vcc
// W64: encoding: [0xf0,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, -4.0, v2, vcc
// W64: encoding: [0xf7,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, |-4.0|, v2, vcc
// W64: encoding: [0xf6,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, v1, v255, vcc
// W64: encoding: [0x01,0xff,0x0b,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e64 v5, v1, v2, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v255, v1, v2, s[6:7]
// W64: encoding: [0xff,0x00,0x01,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v255, v2, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0xff,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, 0, v2, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x80,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, -1, v2, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0xc1,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, 0.5, v2, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0xf0,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, -4.0, v2, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0xf7,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, v255, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x01,0xff,0x1b,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, 0, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x01,0x01,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, -1, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x01,0x83,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, 0.5, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x01,0xe1,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, -4.0, s[6:7]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x01,0xef,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, v2, s[8:9]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x01,0x05,0x22,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, v2, s[100:101]
// W64: encoding: [0x05,0x00,0x01,0xd5,0x01,0x05,0x92,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, v2, vcc
// W64: encoding: [0x05,0x00,0x01,0xd5,0x01,0x05,0xaa,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, -v1, |v2|, vcc
// W64: encoding: [0x05,0x02,0x01,0xd5,0x01,0x05,0xaa,0x21]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, |v1|, -v2, vcc
// W64: encoding: [0x05,0x01,0x01,0xd5,0x01,0x05,0xaa,0x41]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_sdwa v5, -v1, |v2|, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x16,0x26]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_sdwa v5, |v1|, -v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x26,0x16]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_sdwa v5, |0.5|, -v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x02,0xf0,0x06,0xa6,0x16]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_dpp v5, -v1, |v2|, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// W64: encoding: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x98,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_dpp v5, |v1|, -v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// W64: encoding: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x68,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_dpp v5, -|v1|, -|v2|, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// W64: encoding: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0xf8,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, v1, v2, vcc_lo
// W32: encoding: [0x01,0x05,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v255, v1, v2, vcc_lo
// W32: encoding: [0x01,0x05,0xfe,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, v255, v2, vcc_lo
// W32: encoding: [0xff,0x05,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, 0, v2, vcc_lo
// W32: encoding: [0x80,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, -1, v2, vcc_lo
// W32: encoding: [0xc1,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, 0.5, v2, vcc_lo
// W32: encoding: [0xf0,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, -4.0, v2, vcc_lo
// W32: encoding: [0xf7,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, |-4.0|, v2, vcc_lo
// W32: encoding: [0xf6,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e32 v5, v1, v255, vcc_lo
// W32: encoding: [0x01,0xff,0x0b,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_e64 v5, v1, v2, s6
// W32: encoding: [0x05,0x00,0x01,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v255, v1, v2, s6
// W32: encoding: [0xff,0x00,0x01,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v255, v2, s6
// W32: encoding: [0x05,0x00,0x01,0xd5,0xff,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, 0, v2, s6
// W32: encoding: [0x05,0x00,0x01,0xd5,0x80,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, -1, v2, s6
// W32: encoding: [0x05,0x00,0x01,0xd5,0xc1,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, 0.5, v2, s6
// W32: encoding: [0x05,0x00,0x01,0xd5,0xf0,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, -4.0, v2, s6
// W32: encoding: [0x05,0x00,0x01,0xd5,0xf7,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, v255, s6
// W32: encoding: [0x05,0x00,0x01,0xd5,0x01,0xff,0x1b,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, 0, s6
// W32: encoding: [0x05,0x00,0x01,0xd5,0x01,0x01,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, -1, s6
// W32: encoding: [0x05,0x00,0x01,0xd5,0x01,0x83,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, 0.5, s6
// W32: encoding: [0x05,0x00,0x01,0xd5,0x01,0xe1,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, -4.0, s6
// W32: encoding: [0x05,0x00,0x01,0xd5,0x01,0xef,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, v2, s8
// W32: encoding: [0x05,0x00,0x01,0xd5,0x01,0x05,0x22,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, v2, s100
// W32: encoding: [0x05,0x00,0x01,0xd5,0x01,0x05,0x92,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, v1, v2, vcc_lo
// W32: encoding: [0x05,0x00,0x01,0xd5,0x01,0x05,0xaa,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, -v1, |v2|, vcc_lo
// W32: encoding: [0x05,0x02,0x01,0xd5,0x01,0x05,0xaa,0x21]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64 v5, |v1|, -v2, vcc_lo
// W32: encoding: [0x05,0x01,0x01,0xd5,0x01,0x05,0xaa,0x41]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_sdwa v5, -v1, |v2|, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x16,0x26]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_sdwa v5, |v1|, -v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x26,0x16]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_sdwa v5, |0.5|, -v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x02,0xf0,0x06,0xa6,0x16]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_sdwa v5, sext(v1), v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: not a valid operand
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: not a valid operand

v_cndmask_b32_sdwa v5, v1, sext(v2), vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: not a valid operand
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: not a valid operand

v_cndmask_b32_dpp v5, -v1, |v2|, vcc_lo quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// W32: encoding: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x98,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_dpp v5, |v1|, -v2, vcc_lo quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// W32: encoding: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x68,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32_dpp v5, -|v1|, -|v2|, vcc_lo quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// W32: encoding: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0xf8,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_f32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x06]

v_add_f32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x07]

v_add_f32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x06]

v_add_f32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x06]

v_add_f32_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x06]

v_add_f32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x06]

v_add_f32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x06]

v_add_f32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x06]

v_add_f32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x06]

v_add_f32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x06]

v_add_f32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x06]

v_add_f32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x06]

v_add_f32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x06]

v_add_f32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x06]

v_add_f32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x06,0x56,0x34,0x12,0xaf]

v_add_f32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x06,0x73,0x72,0x71,0x3f]

v_add_f32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x06]

v_add_f32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0x05,0x02,0x00]

v_add_f32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x03,0xd5,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0xff,0x05,0x02,0x00]

v_add_f32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0x04,0x02,0x00]

v_add_f32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x65,0x04,0x02,0x00]

v_add_f32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x6a,0x04,0x02,0x00]

v_add_f32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x6b,0x04,0x02,0x00]

v_add_f32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x7c,0x04,0x02,0x00]

v_add_f32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x7e,0x04,0x02,0x00]

v_add_f32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x7f,0x04,0x02,0x00]

v_add_f32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x80,0x04,0x02,0x00]

v_add_f32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0xc1,0x04,0x02,0x00]

v_add_f32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0xf0,0x04,0x02,0x00]

v_add_f32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0xf7,0x04,0x02,0x00]

v_add_f32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0xff,0x03,0x00]

v_add_f32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0x05,0x00,0x00]

v_add_f32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0xcb,0x00,0x00]

v_add_f32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0xd5,0x00,0x00]

v_add_f32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0xd7,0x00,0x00]

v_add_f32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0xf9,0x00,0x00]

v_add_f32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0xfd,0x00,0x00]

v_add_f32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0xff,0x00,0x00]

v_add_f32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0x01,0x01,0x00]

v_add_f32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0x83,0x01,0x00]

v_add_f32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0xe1,0x01,0x00]

v_add_f32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0xef,0x01,0x00]

v_add_f32_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0x05,0x02,0x20]

v_add_f32_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0x05,0x02,0x40]

v_add_f32_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0x05,0x02,0x60]

v_add_f32_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x03,0xd5,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x03,0xd5,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x03,0xd5,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x03,0xd5,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v1, v2 mul:2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0x05,0x02,0x08]

v_add_f32_e64 v5, v1, v2 mul:4
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0x05,0x02,0x10]

v_add_f32_e64 v5, v1, v2 div:2
// GFX10: encoding: [0x05,0x00,0x03,0xd5,0x01,0x05,0x02,0x18]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x06]

v_add_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x07,0x01,0x06,0x06,0x06]

v_add_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0xff,0x06,0x06,0x06]

v_add_f32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x86,0x06]

v_add_f32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x65,0x06,0x86,0x06]

v_add_f32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x6a,0x06,0x86,0x06]

v_add_f32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x6b,0x06,0x86,0x06]

v_add_f32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x7c,0x06,0x86,0x06]

v_add_f32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x7e,0x06,0x86,0x06]

v_add_f32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x7f,0x06,0x86,0x06]

v_add_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x06,0x01,0x06,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x26,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x46,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x86,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0xc6,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x00,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x01,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x02,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x03,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x04,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x05,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x0e,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x16,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x16,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x00,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x01,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x02,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x03,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x04,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x05,0x06]

v_add_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x16,0x06]

v_add_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x26,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x00]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x01]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x02]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x03]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x04]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x05]

v_add_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x16]

v_add_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x26]

v_add_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x00]

v_add_f32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x07,0x01,0xe4,0x00,0x00]

v_add_f32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0xff,0xe4,0x00,0x00]

v_add_f32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x06,0x01,0xe4,0x00,0x00]

v_add_f32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x1b,0x00,0x00]

v_add_f32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x40,0x01,0x00]

v_add_f32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x41,0x01,0x00]

v_add_f32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x01,0x01,0x00]

v_add_f32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x0f,0x01,0x00]

v_add_f32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x11,0x01,0x00]

v_add_f32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x1f,0x01,0x00]

v_add_f32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x21,0x01,0x00]

v_add_f32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x2f,0x01,0x00]

v_add_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x10]

v_add_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x30]

v_add_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0xf0]

v_add_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x01]

v_add_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x03]

v_add_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x0f]

v_add_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x08,0x00]

v_add_f32_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x10,0x00]

v_add_f32_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x20,0x00]

v_add_f32_dpp v5, v1, -v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x40,0x00]

v_add_f32_dpp v5, v1, |v2|  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x80,0x00]

v_add_f32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x51,0x01,0x00]

v_add_f32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x5f,0x01,0x00]

v_add_f32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x61,0x01,0x00]

v_add_f32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x06,0x01,0x6f,0x01,0x00]

v_sub_f32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x08]

v_sub_f32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x09]

v_sub_f32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x08]

v_sub_f32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x08]

v_sub_f32_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x08]

v_sub_f32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x08]

v_sub_f32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x08]

v_sub_f32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x08]

v_sub_f32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x08]

v_sub_f32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x08]

v_sub_f32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x08]

v_sub_f32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x08]

v_sub_f32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x08]

v_sub_f32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x08]

v_sub_f32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x08,0x56,0x34,0x12,0xaf]

v_sub_f32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x08,0x73,0x72,0x71,0x3f]

v_sub_f32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x08]

v_sub_f32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x04,0xd5,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0xff,0x05,0x02,0x00]

v_sub_f32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0x04,0x02,0x00]

v_sub_f32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x65,0x04,0x02,0x00]

v_sub_f32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x6a,0x04,0x02,0x00]

v_sub_f32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x6b,0x04,0x02,0x00]

v_sub_f32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x7c,0x04,0x02,0x00]

v_sub_f32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x7e,0x04,0x02,0x00]

v_sub_f32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x7f,0x04,0x02,0x00]

v_sub_f32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x80,0x04,0x02,0x00]

v_sub_f32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0xc1,0x04,0x02,0x00]

v_sub_f32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0xf0,0x04,0x02,0x00]

v_sub_f32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0xf7,0x04,0x02,0x00]

v_sub_f32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0xff,0x03,0x00]

v_sub_f32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0x05,0x00,0x00]

v_sub_f32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0xcb,0x00,0x00]

v_sub_f32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0xd5,0x00,0x00]

v_sub_f32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0xd7,0x00,0x00]

v_sub_f32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0xf9,0x00,0x00]

v_sub_f32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0xfd,0x00,0x00]

v_sub_f32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0xff,0x00,0x00]

v_sub_f32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0x01,0x01,0x00]

v_sub_f32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0x83,0x01,0x00]

v_sub_f32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0xe1,0x01,0x00]

v_sub_f32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0xef,0x01,0x00]

v_sub_f32_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0x05,0x02,0x20]

v_sub_f32_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0x05,0x02,0x40]

v_sub_f32_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0x05,0x02,0x60]

v_sub_f32_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x04,0xd5,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x04,0xd5,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x04,0xd5,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x04,0xd5,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v1, v2 mul:2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0x05,0x02,0x08]

v_sub_f32_e64 v5, v1, v2 mul:4
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0x05,0x02,0x10]

v_sub_f32_e64 v5, v1, v2 div:2
// GFX10: encoding: [0x05,0x00,0x04,0xd5,0x01,0x05,0x02,0x18]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x06]

v_sub_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x09,0x01,0x06,0x06,0x06]

v_sub_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0xff,0x06,0x06,0x06]

v_sub_f32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x86,0x06]

v_sub_f32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x65,0x06,0x86,0x06]

v_sub_f32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x6a,0x06,0x86,0x06]

v_sub_f32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x6b,0x06,0x86,0x06]

v_sub_f32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x7c,0x06,0x86,0x06]

v_sub_f32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x7e,0x06,0x86,0x06]

v_sub_f32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x7f,0x06,0x86,0x06]

v_sub_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x08,0x01,0x06,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x26,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x46,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x86,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0xc6,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x00,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x01,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x02,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x03,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x04,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x05,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x0e,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x16,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x16,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x00,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x01,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x02,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x03,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x04,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x05,0x06]

v_sub_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x16,0x06]

v_sub_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x26,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x00]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x01]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x02]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x03]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x04]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x05]

v_sub_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x16]

v_sub_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x26]

v_sub_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x00]

v_sub_f32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x09,0x01,0xe4,0x00,0x00]

v_sub_f32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0xff,0xe4,0x00,0x00]

v_sub_f32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x08,0x01,0xe4,0x00,0x00]

v_sub_f32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x1b,0x00,0x00]

v_sub_f32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x40,0x01,0x00]

v_sub_f32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x41,0x01,0x00]

v_sub_f32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x01,0x01,0x00]

v_sub_f32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x0f,0x01,0x00]

v_sub_f32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x11,0x01,0x00]

v_sub_f32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x1f,0x01,0x00]

v_sub_f32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x21,0x01,0x00]

v_sub_f32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x2f,0x01,0x00]

v_sub_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x10]

v_sub_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x30]

v_sub_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0xf0]

v_sub_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x01]

v_sub_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x03]

v_sub_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x0f]

v_sub_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x08,0x00]

v_sub_f32_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x10,0x00]

v_sub_f32_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x20,0x00]

v_sub_f32_dpp v5, v1, -v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x40,0x00]

v_sub_f32_dpp v5, v1, |v2|  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x80,0x00]

v_sub_f32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x51,0x01,0x00]

v_sub_f32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x5f,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x61,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x08,0x01,0x6f,0x01,0x00]

v_subrev_f32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x0a]

v_subrev_f32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x0b]

v_subrev_f32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x0a]

v_subrev_f32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x0a]

v_subrev_f32_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x0a]

v_subrev_f32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x0a]

v_subrev_f32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x0a]

v_subrev_f32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x0a]

v_subrev_f32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x0a]

v_subrev_f32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x0a]

v_subrev_f32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x0a]

v_subrev_f32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x0a]

v_subrev_f32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x0a]

v_subrev_f32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x0a]

v_subrev_f32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x0a,0x56,0x34,0x12,0xaf]

v_subrev_f32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x0a,0x73,0x72,0x71,0x3f]

v_subrev_f32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x0a]

v_subrev_f32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x05,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0xff,0x05,0x02,0x00]

v_subrev_f32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0x04,0x02,0x00]

v_subrev_f32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x65,0x04,0x02,0x00]

v_subrev_f32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x6a,0x04,0x02,0x00]

v_subrev_f32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x6b,0x04,0x02,0x00]

v_subrev_f32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x7c,0x04,0x02,0x00]

v_subrev_f32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x7e,0x04,0x02,0x00]

v_subrev_f32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x7f,0x04,0x02,0x00]

v_subrev_f32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x80,0x04,0x02,0x00]

v_subrev_f32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0xc1,0x04,0x02,0x00]

v_subrev_f32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0xf0,0x04,0x02,0x00]

v_subrev_f32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0xf7,0x04,0x02,0x00]

v_subrev_f32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0xff,0x03,0x00]

v_subrev_f32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0x05,0x00,0x00]

v_subrev_f32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0xcb,0x00,0x00]

v_subrev_f32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0xd5,0x00,0x00]

v_subrev_f32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0xd7,0x00,0x00]

v_subrev_f32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0xf9,0x00,0x00]

v_subrev_f32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0xfd,0x00,0x00]

v_subrev_f32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0xff,0x00,0x00]

v_subrev_f32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0x01,0x01,0x00]

v_subrev_f32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0x83,0x01,0x00]

v_subrev_f32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0xe1,0x01,0x00]

v_subrev_f32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0xef,0x01,0x00]

v_subrev_f32_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0x05,0x02,0x20]

v_subrev_f32_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0x05,0x02,0x40]

v_subrev_f32_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0x05,0x02,0x60]

v_subrev_f32_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x05,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x05,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x05,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x05,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v1, v2 mul:2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0x05,0x02,0x08]

v_subrev_f32_e64 v5, v1, v2 mul:4
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0x05,0x02,0x10]

v_subrev_f32_e64 v5, v1, v2 div:2
// GFX10: encoding: [0x05,0x00,0x05,0xd5,0x01,0x05,0x02,0x18]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x06]

v_subrev_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x0b,0x01,0x06,0x06,0x06]

v_subrev_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0xff,0x06,0x06,0x06]

v_subrev_f32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x86,0x06]

v_subrev_f32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x65,0x06,0x86,0x06]

v_subrev_f32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x6a,0x06,0x86,0x06]

v_subrev_f32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x6b,0x06,0x86,0x06]

v_subrev_f32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x7c,0x06,0x86,0x06]

v_subrev_f32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x7e,0x06,0x86,0x06]

v_subrev_f32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x7f,0x06,0x86,0x06]

v_subrev_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x0a,0x01,0x06,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x26,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x46,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x86,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0xc6,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x00,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x01,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x02,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x03,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x04,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x05,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x0e,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x16,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x16,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x00,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x01,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x02,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x03,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x04,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x05,0x06]

v_subrev_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x16,0x06]

v_subrev_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x26,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x00]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x01]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x02]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x03]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x04]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x05]

v_subrev_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x16]

v_subrev_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x26]

v_subrev_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x00]

v_subrev_f32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x0b,0x01,0xe4,0x00,0x00]

v_subrev_f32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0xff,0xe4,0x00,0x00]

v_subrev_f32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x0a,0x01,0xe4,0x00,0x00]

v_subrev_f32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x1b,0x00,0x00]

v_subrev_f32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x40,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x41,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x01,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x0f,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x11,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x1f,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x21,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x2f,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x10]

v_subrev_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x30]

v_subrev_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0xf0]

v_subrev_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x01]

v_subrev_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x03]

v_subrev_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x0f]

v_subrev_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x08,0x00]

v_subrev_f32_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x10,0x00]

v_subrev_f32_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x20,0x00]

v_subrev_f32_dpp v5, v1, -v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x40,0x00]

v_subrev_f32_dpp v5, v1, |v2|  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x80,0x00]

v_subrev_f32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x51,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x5f,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x61,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0a,0x01,0x6f,0x01,0x00]

v_mac_legacy_f32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x0c]

v_mac_legacy_f32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x0d]

v_mac_legacy_f32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x0c]

v_mac_legacy_f32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x0c,0x56,0x34,0x12,0xaf]

v_mac_legacy_f32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x0c,0x73,0x72,0x71,0x3f]

v_mac_legacy_f32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x0c]

v_mac_legacy_f32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x06,0xd5,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0xff,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x67,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x6a,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x6b,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x77,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x7c,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x7e,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x7f,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x80,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0xc1,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0xf0,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0xf7,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0xff,0x03,0x00]

v_mac_legacy_f32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0x05,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0xcf,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0xd5,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0xd7,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0xef,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0xf9,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0xfd,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0xff,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0x01,0x01,0x00]

v_mac_legacy_f32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0x83,0x01,0x00]

v_mac_legacy_f32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0xe1,0x01,0x00]

v_mac_legacy_f32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0xef,0x01,0x00]

v_mac_legacy_f32_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0x05,0x02,0x20]

v_mac_legacy_f32_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0x05,0x02,0x40]

v_mac_legacy_f32_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0x05,0x02,0x60]

v_mac_legacy_f32_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x06,0xd5,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x06,0xd5,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x06,0xd5,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x06,0xd5,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, v1, v2 mul:2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0x05,0x02,0x08]

v_mac_legacy_f32_e64 v5, v1, v2 mul:4
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0x05,0x02,0x10]

v_mac_legacy_f32_e64 v5, v1, v2 div:2
// GFX10: encoding: [0x05,0x00,0x06,0xd5,0x01,0x05,0x02,0x18]

v_mul_legacy_f32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x0e]

v_mul_legacy_f32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x0f]

v_mul_legacy_f32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x0e]

v_mul_legacy_f32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x0e]

v_mul_legacy_f32_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x0e]

v_mul_legacy_f32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x0e]

v_mul_legacy_f32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x0e]

v_mul_legacy_f32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x0e]

v_mul_legacy_f32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x0e]

v_mul_legacy_f32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x0e]

v_mul_legacy_f32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x0e]

v_mul_legacy_f32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x0e]

v_mul_legacy_f32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x0e]

v_mul_legacy_f32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x0e]

v_mul_legacy_f32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x0e,0x56,0x34,0x12,0xaf]

v_mul_legacy_f32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x0e,0x73,0x72,0x71,0x3f]

v_mul_legacy_f32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x0e]

v_mul_legacy_f32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x07,0xd5,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0xff,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x65,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x6a,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x6b,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x7c,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x7e,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x7f,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x80,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0xc1,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0xf0,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0xf7,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0xff,0x03,0x00]

v_mul_legacy_f32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0x05,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0xcb,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0xd5,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0xd7,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0xf9,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0xfd,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0xff,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0x01,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0x83,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0xe1,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0xef,0x01,0x00]

v_mul_legacy_f32_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0x05,0x02,0x20]

v_mul_legacy_f32_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0x05,0x02,0x40]

v_mul_legacy_f32_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0x05,0x02,0x60]

v_mul_legacy_f32_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x07,0xd5,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x07,0xd5,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x07,0xd5,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x07,0xd5,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, v2 mul:2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0x05,0x02,0x08]

v_mul_legacy_f32_e64 v5, v1, v2 mul:4
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0x05,0x02,0x10]

v_mul_legacy_f32_e64 v5, v1, v2 div:2
// GFX10: encoding: [0x05,0x00,0x07,0xd5,0x01,0x05,0x02,0x18]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x0f,0x01,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0xff,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x86,0x06]

v_mul_legacy_f32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x65,0x06,0x86,0x06]

v_mul_legacy_f32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x6a,0x06,0x86,0x06]

v_mul_legacy_f32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x6b,0x06,0x86,0x06]

v_mul_legacy_f32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x7c,0x06,0x86,0x06]

v_mul_legacy_f32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x7e,0x06,0x86,0x06]

v_mul_legacy_f32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x7f,0x06,0x86,0x06]

v_mul_legacy_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x0e,0x01,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x26,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x46,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x86,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0xc6,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x00,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x01,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x02,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x03,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x04,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x05,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x0e,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x16,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x16,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x00,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x01,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x02,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x03,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x04,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x05,0x06]

v_mul_legacy_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x16,0x06]

v_mul_legacy_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x26,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x00]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x01]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x02]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x03]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x04]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x05]

v_mul_legacy_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x16]

v_mul_legacy_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x26]

v_mul_legacy_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x00]

v_mul_legacy_f32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x0f,0x01,0xe4,0x00,0x00]

v_mul_legacy_f32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0xff,0xe4,0x00,0x00]

v_mul_legacy_f32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x0e,0x01,0xe4,0x00,0x00]

v_mul_legacy_f32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x1b,0x00,0x00]

v_mul_legacy_f32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x40,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x41,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x01,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x0f,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x11,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x1f,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x21,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x2f,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x10]

v_mul_legacy_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x30]

v_mul_legacy_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0xf0]

v_mul_legacy_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x01]

v_mul_legacy_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x03]

v_mul_legacy_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x0f]

v_mul_legacy_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x08,0x00]

v_mul_legacy_f32_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x10,0x00]

v_mul_legacy_f32_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x20,0x00]

v_mul_legacy_f32_dpp v5, v1, -v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x40,0x00]

v_mul_legacy_f32_dpp v5, v1, |v2|  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x80,0x00]

v_mul_legacy_f32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x51,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x5f,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x61,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x0e,0x01,0x6f,0x01,0x00]

v_mul_f32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x10]

v_mul_f32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x11]

v_mul_f32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x10]

v_mul_f32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x10]

v_mul_f32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x10]

v_mul_f32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x10]

v_mul_f32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x10]

v_mul_f32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x10]

v_mul_f32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x10]

v_mul_f32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x10]

v_mul_f32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x10]

v_mul_f32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x10]

v_mul_f32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x10]

v_mul_f32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x10]

v_mul_f32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x10]

v_mul_f32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x10,0x56,0x34,0x12,0xaf]

v_mul_f32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x10,0x73,0x72,0x71,0x3f]

v_mul_f32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x10]

v_mul_f32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x08,0xd5,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0xff,0x05,0x02,0x00]

v_mul_f32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0x04,0x02,0x00]

v_mul_f32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x65,0x04,0x02,0x00]

v_mul_f32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x6a,0x04,0x02,0x00]

v_mul_f32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x6b,0x04,0x02,0x00]

v_mul_f32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x7c,0x04,0x02,0x00]

v_mul_f32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x7e,0x04,0x02,0x00]

v_mul_f32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x7f,0x04,0x02,0x00]

v_mul_f32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x80,0x04,0x02,0x00]

v_mul_f32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0xc1,0x04,0x02,0x00]

v_mul_f32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0xf0,0x04,0x02,0x00]

v_mul_f32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0xf7,0x04,0x02,0x00]

v_mul_f32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0xff,0x03,0x00]

v_mul_f32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0x05,0x00,0x00]

v_mul_f32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0xcb,0x00,0x00]

v_mul_f32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0xd5,0x00,0x00]

v_mul_f32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0xd7,0x00,0x00]

v_mul_f32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0xf9,0x00,0x00]

v_mul_f32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0xfd,0x00,0x00]

v_mul_f32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0xff,0x00,0x00]

v_mul_f32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0x01,0x01,0x00]

v_mul_f32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0x83,0x01,0x00]

v_mul_f32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0xe1,0x01,0x00]

v_mul_f32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0xef,0x01,0x00]

v_mul_f32_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0x05,0x02,0x20]

v_mul_f32_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0x05,0x02,0x40]

v_mul_f32_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0x05,0x02,0x60]

v_mul_f32_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x08,0xd5,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x08,0xd5,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x08,0xd5,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x08,0xd5,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v1, v2 mul:2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0x05,0x02,0x08]

v_mul_f32_e64 v5, v1, v2 mul:4
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0x05,0x02,0x10]

v_mul_f32_e64 v5, v1, v2 div:2
// GFX10: encoding: [0x05,0x00,0x08,0xd5,0x01,0x05,0x02,0x18]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x06]

v_mul_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x11,0x01,0x06,0x06,0x06]

v_mul_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0xff,0x06,0x06,0x06]

v_mul_f32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x86,0x06]

v_mul_f32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x65,0x06,0x86,0x06]

v_mul_f32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x6a,0x06,0x86,0x06]

v_mul_f32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x6b,0x06,0x86,0x06]

v_mul_f32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x7c,0x06,0x86,0x06]

v_mul_f32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x7e,0x06,0x86,0x06]

v_mul_f32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x7f,0x06,0x86,0x06]

v_mul_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x10,0x01,0x06,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x26,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x46,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x86,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0xc6,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x00,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x01,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x02,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x03,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x04,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x05,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x0e,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x16,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x16,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x00,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x01,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x02,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x03,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x04,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x05,0x06]

v_mul_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x16,0x06]

v_mul_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x26,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x00]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x01]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x02]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x03]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x04]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x05]

v_mul_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x16]

v_mul_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x26]

v_mul_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x00]

v_mul_f32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x11,0x01,0xe4,0x00,0x00]

v_mul_f32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0xff,0xe4,0x00,0x00]

v_mul_f32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x10,0x01,0xe4,0x00,0x00]

v_mul_f32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x1b,0x00,0x00]

v_mul_f32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x40,0x01,0x00]

v_mul_f32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x41,0x01,0x00]

v_mul_f32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x01,0x01,0x00]

v_mul_f32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x0f,0x01,0x00]

v_mul_f32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x11,0x01,0x00]

v_mul_f32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x1f,0x01,0x00]

v_mul_f32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x21,0x01,0x00]

v_mul_f32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x2f,0x01,0x00]

v_mul_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x10]

v_mul_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x30]

v_mul_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0xf0]

v_mul_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x01]

v_mul_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x03]

v_mul_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x0f]

v_mul_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x08,0x00]

v_mul_f32_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x10,0x00]

v_mul_f32_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x20,0x00]

v_mul_f32_dpp v5, v1, -v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x40,0x00]

v_mul_f32_dpp v5, v1, |v2|  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x80,0x00]

v_mul_f32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x51,0x01,0x00]

v_mul_f32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x5f,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x61,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x10,0x01,0x6f,0x01,0x00]

v_mul_i32_i24_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x12]

v_mul_i32_i24_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x13]

v_mul_i32_i24_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x12]

v_mul_i32_i24_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x12]

v_mul_i32_i24_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x12]

v_mul_i32_i24_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x12]

v_mul_i32_i24_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x12]

v_mul_i32_i24_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x12]

v_mul_i32_i24_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x12]

v_mul_i32_i24_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x12]

v_mul_i32_i24_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x12]

v_mul_i32_i24_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x12]

v_mul_i32_i24_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x12]

v_mul_i32_i24_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x12]

v_mul_i32_i24_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x12]

v_mul_i32_i24_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x12,0x56,0x34,0x12,0xaf]

v_mul_i32_i24_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x12,0x73,0x72,0x71,0x3f]

v_mul_i32_i24_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x12]

v_mul_i32_i24_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0x05,0x02,0x00]

v_mul_i32_i24_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x09,0xd5,0x01,0x05,0x02,0x00]

v_mul_i32_i24_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0xff,0x05,0x02,0x00]

v_mul_i32_i24_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x65,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x6a,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x6b,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x7c,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x7e,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x7f,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x80,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0xc1,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0xf0,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0xf7,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0xff,0x03,0x00]

v_mul_i32_i24_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0x05,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0xcb,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0xd5,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0xd7,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0xf9,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0xfd,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0xff,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0x01,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0x83,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0xe1,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x09,0xd5,0x01,0xef,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, -4.0 clamp
// GFX10: encoding: [0x05,0x80,0x09,0xd5,0x01,0xef,0x01,0x00]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x13,0x01,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0xff,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x86,0x06]

v_mul_i32_i24_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x65,0x06,0x86,0x06]

v_mul_i32_i24_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x6a,0x06,0x86,0x06]

v_mul_i32_i24_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x6b,0x06,0x86,0x06]

v_mul_i32_i24_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x7c,0x06,0x86,0x06]

v_mul_i32_i24_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x7e,0x06,0x86,0x06]

v_mul_i32_i24_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x7f,0x06,0x86,0x06]

v_mul_i32_i24_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x12,0x01,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x26,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x00,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x01,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x02,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x03,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x04,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x05,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x0e,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x16,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x16,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x00,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x01,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x02,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x03,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x04,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x05,0x06]

v_mul_i32_i24_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x0e,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x00]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x01]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x02]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x03]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x04]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x05]

v_mul_i32_i24_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x0e]

v_mul_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x00]

v_mul_i32_i24_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x13,0x01,0xe4,0x00,0x00]

v_mul_i32_i24_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0xff,0xe4,0x00,0x00]

v_mul_i32_i24_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x12,0x01,0xe4,0x00,0x00]

v_mul_i32_i24_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x1b,0x00,0x00]

v_mul_i32_i24_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x40,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x41,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x01,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x0f,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x11,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x1f,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x21,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x2f,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x10]

v_mul_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x30]

v_mul_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0xf0]

v_mul_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x01]

v_mul_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x03]

v_mul_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x0f]

v_mul_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x08,0x00]

v_mul_i32_i24_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x51,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x5f,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x61,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x12,0x01,0x6f,0x01,0x00]

v_mul_hi_i32_i24_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x14]

v_mul_hi_i32_i24_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x15]

v_mul_hi_i32_i24_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x14]

v_mul_hi_i32_i24_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x14,0x56,0x34,0x12,0xaf]

v_mul_hi_i32_i24_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x14,0x73,0x72,0x71,0x3f]

v_mul_hi_i32_i24_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x14]

v_mul_hi_i32_i24_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x0a,0xd5,0x01,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0xff,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x65,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x6a,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x6b,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x7c,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x7e,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x7f,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x80,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0xc1,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0xf0,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0xf7,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0xff,0x03,0x00]

v_mul_hi_i32_i24_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0x05,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0xcb,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0xd5,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0xd7,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0xf9,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0xfd,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0xff,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0x01,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0x83,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0xe1,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x0a,0xd5,0x01,0xef,0x01,0x00]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x15,0x01,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0xff,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x86,0x06]

v_mul_hi_i32_i24_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x65,0x06,0x86,0x06]

v_mul_hi_i32_i24_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x6a,0x06,0x86,0x06]

v_mul_hi_i32_i24_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x6b,0x06,0x86,0x06]

v_mul_hi_i32_i24_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x7c,0x06,0x86,0x06]

v_mul_hi_i32_i24_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x7e,0x06,0x86,0x06]

v_mul_hi_i32_i24_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x7f,0x06,0x86,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x14,0x01,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x26,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x00,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x01,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x02,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x03,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x04,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x05,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x0e,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x16,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x16,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x00,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x01,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x02,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x03,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x04,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x05,0x06]

v_mul_hi_i32_i24_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x0e,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x00]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x01]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x02]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x03]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x04]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x05]

v_mul_hi_i32_i24_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x0e]

v_mul_hi_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x00]

v_mul_hi_i32_i24_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x15,0x01,0xe4,0x00,0x00]

v_mul_hi_i32_i24_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0xff,0xe4,0x00,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x14,0x01,0xe4,0x00,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x1b,0x00,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x40,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x41,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x01,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x0f,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x11,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x1f,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x21,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x2f,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x10]

v_mul_hi_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x30]

v_mul_hi_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0xf0]

v_mul_hi_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x01]

v_mul_hi_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x03]

v_mul_hi_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x0f]

v_mul_hi_i32_i24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x08,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x51,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x5f,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x61,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x14,0x01,0x6f,0x01,0x00]

v_mul_u32_u24_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x16]

v_mul_u32_u24_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x17]

v_mul_u32_u24_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x16]

v_mul_u32_u24_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x16]

v_mul_u32_u24_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x16]

v_mul_u32_u24_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x16]

v_mul_u32_u24_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x16]

v_mul_u32_u24_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x16]

v_mul_u32_u24_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x16]

v_mul_u32_u24_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x16]

v_mul_u32_u24_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x16]

v_mul_u32_u24_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x16]

v_mul_u32_u24_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x16]

v_mul_u32_u24_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x16]

v_mul_u32_u24_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x16]

v_mul_u32_u24_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x16,0x56,0x34,0x12,0xaf]

v_mul_u32_u24_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x16,0x73,0x72,0x71,0x3f]

v_mul_u32_u24_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x16]

v_mul_u32_u24_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0x05,0x02,0x00]

v_mul_u32_u24_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x0b,0xd5,0x01,0x05,0x02,0x00]

v_mul_u32_u24_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0xff,0x05,0x02,0x00]

v_mul_u32_u24_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x65,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x6a,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x6b,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x7c,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x7e,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x7f,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x80,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0xc1,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0xf0,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0xf7,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0xff,0x03,0x00]

v_mul_u32_u24_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0x05,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0xcb,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0xd5,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0xd7,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0xf9,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0xfd,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0xff,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0x01,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0x83,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0xe1,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x0b,0xd5,0x01,0xef,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, -4.0 clamp
// GFX10: encoding: [0x05,0x80,0x0b,0xd5,0x01,0xef,0x01,0x00]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x17,0x01,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0xff,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x86,0x06]

v_mul_u32_u24_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x65,0x06,0x86,0x06]

v_mul_u32_u24_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x6a,0x06,0x86,0x06]

v_mul_u32_u24_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x6b,0x06,0x86,0x06]

v_mul_u32_u24_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x7c,0x06,0x86,0x06]

v_mul_u32_u24_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x7e,0x06,0x86,0x06]

v_mul_u32_u24_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x7f,0x06,0x86,0x06]

v_mul_u32_u24_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x16,0x01,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x26,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x00,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x01,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x02,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x03,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x04,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x05,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x0e,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x16,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x16,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x00,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x01,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x02,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x03,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x04,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x05,0x06]

v_mul_u32_u24_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x0e,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x00]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x01]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x02]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x03]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x04]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x05]

v_mul_u32_u24_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x0e]

v_mul_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x00]

v_mul_u32_u24_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x17,0x01,0xe4,0x00,0x00]

v_mul_u32_u24_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0xff,0xe4,0x00,0x00]

v_mul_u32_u24_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x16,0x01,0xe4,0x00,0x00]

v_mul_u32_u24_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x1b,0x00,0x00]

v_mul_u32_u24_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x40,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x41,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x01,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x0f,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x11,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x1f,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x21,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x2f,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x10]

v_mul_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x30]

v_mul_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0xf0]

v_mul_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x01]

v_mul_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x03]

v_mul_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x0f]

v_mul_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x08,0x00]

v_mul_u32_u24_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x51,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x5f,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x61,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x16,0x01,0x6f,0x01,0x00]

v_mul_hi_u32_u24_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x18]

v_mul_hi_u32_u24_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x19]

v_mul_hi_u32_u24_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x18]

v_mul_hi_u32_u24_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x18,0x56,0x34,0x12,0xaf]

v_mul_hi_u32_u24_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x18,0x73,0x72,0x71,0x3f]

v_mul_hi_u32_u24_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x18]

v_mul_hi_u32_u24_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x0c,0xd5,0x01,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0xff,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x65,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x6a,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x6b,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x7c,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x7e,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x7f,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x80,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0xc1,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0xf0,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0xf7,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0xff,0x03,0x00]

v_mul_hi_u32_u24_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0x05,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0xcb,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0xd5,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0xd7,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0xf9,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0xfd,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0xff,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0x01,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0x83,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0xe1,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x0c,0xd5,0x01,0xef,0x01,0x00]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x19,0x01,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0xff,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x86,0x06]

v_mul_hi_u32_u24_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x65,0x06,0x86,0x06]

v_mul_hi_u32_u24_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x6a,0x06,0x86,0x06]

v_mul_hi_u32_u24_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x6b,0x06,0x86,0x06]

v_mul_hi_u32_u24_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x7c,0x06,0x86,0x06]

v_mul_hi_u32_u24_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x7e,0x06,0x86,0x06]

v_mul_hi_u32_u24_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x7f,0x06,0x86,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x18,0x01,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x26,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x00,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x01,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x02,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x03,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x04,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x05,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x0e,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x16,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x16,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x00,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x01,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x02,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x03,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x04,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x05,0x06]

v_mul_hi_u32_u24_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x0e,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x00]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x01]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x02]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x03]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x04]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x05]

v_mul_hi_u32_u24_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x0e]

v_mul_hi_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x00]

v_mul_hi_u32_u24_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x19,0x01,0xe4,0x00,0x00]

v_mul_hi_u32_u24_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0xff,0xe4,0x00,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x18,0x01,0xe4,0x00,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x1b,0x00,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x40,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x41,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x01,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x0f,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x11,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x1f,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x21,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x2f,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x10]

v_mul_hi_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x30]

v_mul_hi_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0xf0]

v_mul_hi_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x01]

v_mul_hi_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x03]

v_mul_hi_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x0f]

v_mul_hi_u32_u24_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x08,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x51,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x5f,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x61,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x18,0x01,0x6f,0x01,0x00]

v_min_f32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x1e]

v_min_f32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x1f]

v_min_f32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x1e]

v_min_f32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x1e]

v_min_f32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x1e]

v_min_f32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x1e]

v_min_f32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x1e]

v_min_f32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x1e]

v_min_f32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x1e]

v_min_f32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x1e]

v_min_f32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x1e]

v_min_f32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x1e]

v_min_f32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x1e]

v_min_f32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x1e]

v_min_f32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x1e]

v_min_f32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x1e,0x56,0x34,0x12,0xaf]

v_min_f32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x1e,0x73,0x72,0x71,0x3f]

v_min_f32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x1e]

v_min_f32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0x05,0x02,0x00]

v_min_f32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x0f,0xd5,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0xff,0x05,0x02,0x00]

v_min_f32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0x04,0x02,0x00]

v_min_f32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x65,0x04,0x02,0x00]

v_min_f32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x6a,0x04,0x02,0x00]

v_min_f32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x6b,0x04,0x02,0x00]

v_min_f32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x7c,0x04,0x02,0x00]

v_min_f32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x7e,0x04,0x02,0x00]

v_min_f32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x7f,0x04,0x02,0x00]

v_min_f32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x80,0x04,0x02,0x00]

v_min_f32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0xc1,0x04,0x02,0x00]

v_min_f32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0xf0,0x04,0x02,0x00]

v_min_f32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0xf7,0x04,0x02,0x00]

v_min_f32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0xff,0x03,0x00]

v_min_f32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0x05,0x00,0x00]

v_min_f32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0xcb,0x00,0x00]

v_min_f32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0xd5,0x00,0x00]

v_min_f32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0xd7,0x00,0x00]

v_min_f32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0xf9,0x00,0x00]

v_min_f32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0xfd,0x00,0x00]

v_min_f32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0xff,0x00,0x00]

v_min_f32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0x01,0x01,0x00]

v_min_f32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0x83,0x01,0x00]

v_min_f32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0xe1,0x01,0x00]

v_min_f32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0xef,0x01,0x00]

v_min_f32_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0x05,0x02,0x20]

v_min_f32_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0x05,0x02,0x40]

v_min_f32_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0x05,0x02,0x60]

v_min_f32_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x0f,0xd5,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x0f,0xd5,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x0f,0xd5,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x0f,0xd5,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v1, v2 mul:2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0x05,0x02,0x08]

v_min_f32_e64 v5, v1, v2 mul:4
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0x05,0x02,0x10]

v_min_f32_e64 v5, v1, v2 div:2
// GFX10: encoding: [0x05,0x00,0x0f,0xd5,0x01,0x05,0x02,0x18]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x06]

v_min_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x1f,0x01,0x06,0x06,0x06]

v_min_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0xff,0x06,0x06,0x06]

v_min_f32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x86,0x06]

v_min_f32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x65,0x06,0x86,0x06]

v_min_f32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x6a,0x06,0x86,0x06]

v_min_f32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x6b,0x06,0x86,0x06]

v_min_f32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x7c,0x06,0x86,0x06]

v_min_f32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x7e,0x06,0x86,0x06]

v_min_f32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x7f,0x06,0x86,0x06]

v_min_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x1e,0x01,0x06,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x26,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x46,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x86,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0xc6,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x00,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x01,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x02,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x03,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x04,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x05,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x0e,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x16,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x16,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x00,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x01,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x02,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x03,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x04,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x05,0x06]

v_min_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x16,0x06]

v_min_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x26,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x00]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x01]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x02]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x03]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x04]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x05]

v_min_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x16]

v_min_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x26]

v_min_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x00]

v_min_f32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x1f,0x01,0xe4,0x00,0x00]

v_min_f32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0xff,0xe4,0x00,0x00]

v_min_f32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x1e,0x01,0xe4,0x00,0x00]

v_min_f32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x1b,0x00,0x00]

v_min_f32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x40,0x01,0x00]

v_min_f32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x41,0x01,0x00]

v_min_f32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x01,0x01,0x00]

v_min_f32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x0f,0x01,0x00]

v_min_f32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x11,0x01,0x00]

v_min_f32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x1f,0x01,0x00]

v_min_f32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x21,0x01,0x00]

v_min_f32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x2f,0x01,0x00]

v_min_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x10]

v_min_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x30]

v_min_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0xf0]

v_min_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x01]

v_min_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x03]

v_min_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x0f]

v_min_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x08,0x00]

v_min_f32_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x10,0x00]

v_min_f32_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x20,0x00]

v_min_f32_dpp v5, v1, -v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x40,0x00]

v_min_f32_dpp v5, v1, |v2|  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x80,0x00]

v_min_f32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x51,0x01,0x00]

v_min_f32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x5f,0x01,0x00]

v_min_f32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x61,0x01,0x00]

v_min_f32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x1e,0x01,0x6f,0x01,0x00]

v_max_f32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x20]

v_max_f32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x21]

v_max_f32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x20]

v_max_f32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x20]

v_max_f32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x20]

v_max_f32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x20]

v_max_f32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x20]

v_max_f32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x20]

v_max_f32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x20]

v_max_f32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x20]

v_max_f32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x20]

v_max_f32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x20]

v_max_f32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x20]

v_max_f32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x20]

v_max_f32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x20]

v_max_f32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x20,0x56,0x34,0x12,0xaf]

v_max_f32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x20,0x73,0x72,0x71,0x3f]

v_max_f32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x20]

v_max_f32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0x05,0x02,0x00]

v_max_f32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x10,0xd5,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0xff,0x05,0x02,0x00]

v_max_f32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0x04,0x02,0x00]

v_max_f32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x65,0x04,0x02,0x00]

v_max_f32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x6a,0x04,0x02,0x00]

v_max_f32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x6b,0x04,0x02,0x00]

v_max_f32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x7c,0x04,0x02,0x00]

v_max_f32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x7e,0x04,0x02,0x00]

v_max_f32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x7f,0x04,0x02,0x00]

v_max_f32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x80,0x04,0x02,0x00]

v_max_f32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0xc1,0x04,0x02,0x00]

v_max_f32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0xf0,0x04,0x02,0x00]

v_max_f32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0xf7,0x04,0x02,0x00]

v_max_f32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0xff,0x03,0x00]

v_max_f32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0x05,0x00,0x00]

v_max_f32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0xcb,0x00,0x00]

v_max_f32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0xd5,0x00,0x00]

v_max_f32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0xd7,0x00,0x00]

v_max_f32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0xf9,0x00,0x00]

v_max_f32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0xfd,0x00,0x00]

v_max_f32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0xff,0x00,0x00]

v_max_f32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0x01,0x01,0x00]

v_max_f32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0x83,0x01,0x00]

v_max_f32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0xe1,0x01,0x00]

v_max_f32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0xef,0x01,0x00]

v_max_f32_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0x05,0x02,0x20]

v_max_f32_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0x05,0x02,0x40]

v_max_f32_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0x05,0x02,0x60]

v_max_f32_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x10,0xd5,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x10,0xd5,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x10,0xd5,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x10,0xd5,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v1, v2 mul:2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0x05,0x02,0x08]

v_max_f32_e64 v5, v1, v2 mul:4
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0x05,0x02,0x10]

v_max_f32_e64 v5, v1, v2 div:2
// GFX10: encoding: [0x05,0x00,0x10,0xd5,0x01,0x05,0x02,0x18]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x06]

v_max_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x21,0x01,0x06,0x06,0x06]

v_max_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0xff,0x06,0x06,0x06]

v_max_f32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x86,0x06]

v_max_f32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x65,0x06,0x86,0x06]

v_max_f32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x6a,0x06,0x86,0x06]

v_max_f32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x6b,0x06,0x86,0x06]

v_max_f32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x7c,0x06,0x86,0x06]

v_max_f32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x7e,0x06,0x86,0x06]

v_max_f32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x7f,0x06,0x86,0x06]

v_max_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x20,0x01,0x06,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x26,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x46,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x86,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0xc6,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x00,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x01,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x02,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x03,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x04,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x05,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x0e,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x16,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x16,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x00,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x01,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x02,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x03,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x04,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x05,0x06]

v_max_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x16,0x06]

v_max_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x26,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x00]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x01]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x02]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x03]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x04]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x05]

v_max_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x16]

v_max_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x26]

v_max_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x00]

v_max_f32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x21,0x01,0xe4,0x00,0x00]

v_max_f32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0xff,0xe4,0x00,0x00]

v_max_f32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x20,0x01,0xe4,0x00,0x00]

v_max_f32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x1b,0x00,0x00]

v_max_f32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x40,0x01,0x00]

v_max_f32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x41,0x01,0x00]

v_max_f32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x01,0x01,0x00]

v_max_f32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x0f,0x01,0x00]

v_max_f32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x11,0x01,0x00]

v_max_f32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x1f,0x01,0x00]

v_max_f32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x21,0x01,0x00]

v_max_f32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x2f,0x01,0x00]

v_max_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x10]

v_max_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x30]

v_max_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0xf0]

v_max_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x01]

v_max_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x03]

v_max_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x0f]

v_max_f32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x08,0x00]

v_max_f32_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x10,0x00]

v_max_f32_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x20,0x00]

v_max_f32_dpp v5, v1, -v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x40,0x00]

v_max_f32_dpp v5, v1, |v2|  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x80,0x00]

v_max_f32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x51,0x01,0x00]

v_max_f32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x5f,0x01,0x00]

v_max_f32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x61,0x01,0x00]

v_max_f32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x20,0x01,0x6f,0x01,0x00]

v_min_i32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x22]

v_min_i32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x23]

v_min_i32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x22]

v_min_i32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x22]

v_min_i32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x22]

v_min_i32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x22]

v_min_i32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x22]

v_min_i32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x22]

v_min_i32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x22]

v_min_i32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x22]

v_min_i32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x22]

v_min_i32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x22]

v_min_i32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x22]

v_min_i32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x22]

v_min_i32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x22]

v_min_i32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x22,0x56,0x34,0x12,0xaf]

v_min_i32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x22,0x73,0x72,0x71,0x3f]

v_min_i32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x22]

v_min_i32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0x05,0x02,0x00]

v_min_i32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x11,0xd5,0x01,0x05,0x02,0x00]

v_min_i32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0xff,0x05,0x02,0x00]

v_min_i32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0x04,0x02,0x00]

v_min_i32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x65,0x04,0x02,0x00]

v_min_i32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x6a,0x04,0x02,0x00]

v_min_i32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x6b,0x04,0x02,0x00]

v_min_i32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x7c,0x04,0x02,0x00]

v_min_i32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x7e,0x04,0x02,0x00]

v_min_i32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x7f,0x04,0x02,0x00]

v_min_i32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x80,0x04,0x02,0x00]

v_min_i32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0xc1,0x04,0x02,0x00]

v_min_i32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0xf0,0x04,0x02,0x00]

v_min_i32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0xf7,0x04,0x02,0x00]

v_min_i32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0xff,0x03,0x00]

v_min_i32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0x05,0x00,0x00]

v_min_i32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0xcb,0x00,0x00]

v_min_i32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0xd5,0x00,0x00]

v_min_i32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0xd7,0x00,0x00]

v_min_i32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0xf9,0x00,0x00]

v_min_i32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0xfd,0x00,0x00]

v_min_i32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0xff,0x00,0x00]

v_min_i32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0x01,0x01,0x00]

v_min_i32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0x83,0x01,0x00]

v_min_i32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0xe1,0x01,0x00]

v_min_i32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x11,0xd5,0x01,0xef,0x01,0x00]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x06]

v_min_i32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x23,0x01,0x06,0x06,0x06]

v_min_i32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0xff,0x06,0x06,0x06]

v_min_i32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x86,0x06]

v_min_i32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x65,0x06,0x86,0x06]

v_min_i32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x6a,0x06,0x86,0x06]

v_min_i32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x6b,0x06,0x86,0x06]

v_min_i32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x7c,0x06,0x86,0x06]

v_min_i32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x7e,0x06,0x86,0x06]

v_min_i32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x7f,0x06,0x86,0x06]

v_min_i32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x22,0x01,0x06,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x26,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x00,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x01,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x02,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x03,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x04,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x05,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x0e,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x16,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x16,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x00,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x01,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x02,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x03,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x04,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x05,0x06]

v_min_i32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x0e,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x00]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x01]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x02]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x03]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x04]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x05]

v_min_i32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x0e]

v_min_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x00]

v_min_i32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x23,0x01,0xe4,0x00,0x00]

v_min_i32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0xff,0xe4,0x00,0x00]

v_min_i32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x22,0x01,0xe4,0x00,0x00]

v_min_i32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x1b,0x00,0x00]

v_min_i32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x40,0x01,0x00]

v_min_i32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x41,0x01,0x00]

v_min_i32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x01,0x01,0x00]

v_min_i32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x0f,0x01,0x00]

v_min_i32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x11,0x01,0x00]

v_min_i32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x1f,0x01,0x00]

v_min_i32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x21,0x01,0x00]

v_min_i32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x2f,0x01,0x00]

v_min_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x10]

v_min_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x30]

v_min_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0xf0]

v_min_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x01]

v_min_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x03]

v_min_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x0f]

v_min_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x08,0x00]

v_min_i32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x51,0x01,0x00]

v_min_i32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x5f,0x01,0x00]

v_min_i32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x61,0x01,0x00]

v_min_i32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x22,0x01,0x6f,0x01,0x00]

v_max_i32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x24]

v_max_i32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x25]

v_max_i32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x24]

v_max_i32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x24]

v_max_i32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x24]

v_max_i32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x24]

v_max_i32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x24]

v_max_i32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x24]

v_max_i32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x24]

v_max_i32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x24]

v_max_i32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x24]

v_max_i32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x24]

v_max_i32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x24]

v_max_i32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x24]

v_max_i32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x24]

v_max_i32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x24,0x56,0x34,0x12,0xaf]

v_max_i32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x24,0x73,0x72,0x71,0x3f]

v_max_i32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x24]

v_max_i32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0x05,0x02,0x00]

v_max_i32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x12,0xd5,0x01,0x05,0x02,0x00]

v_max_i32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0xff,0x05,0x02,0x00]

v_max_i32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0x04,0x02,0x00]

v_max_i32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x65,0x04,0x02,0x00]

v_max_i32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x6a,0x04,0x02,0x00]

v_max_i32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x6b,0x04,0x02,0x00]

v_max_i32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x7c,0x04,0x02,0x00]

v_max_i32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x7e,0x04,0x02,0x00]

v_max_i32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x7f,0x04,0x02,0x00]

v_max_i32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x80,0x04,0x02,0x00]

v_max_i32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0xc1,0x04,0x02,0x00]

v_max_i32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0xf0,0x04,0x02,0x00]

v_max_i32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0xf7,0x04,0x02,0x00]

v_max_i32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0xff,0x03,0x00]

v_max_i32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0x05,0x00,0x00]

v_max_i32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0xcb,0x00,0x00]

v_max_i32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0xd5,0x00,0x00]

v_max_i32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0xd7,0x00,0x00]

v_max_i32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0xf9,0x00,0x00]

v_max_i32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0xfd,0x00,0x00]

v_max_i32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0xff,0x00,0x00]

v_max_i32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0x01,0x01,0x00]

v_max_i32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0x83,0x01,0x00]

v_max_i32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0xe1,0x01,0x00]

v_max_i32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x12,0xd5,0x01,0xef,0x01,0x00]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x06]

v_max_i32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x25,0x01,0x06,0x06,0x06]

v_max_i32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0xff,0x06,0x06,0x06]

v_max_i32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x86,0x06]

v_max_i32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x65,0x06,0x86,0x06]

v_max_i32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x6a,0x06,0x86,0x06]

v_max_i32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x6b,0x06,0x86,0x06]

v_max_i32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x7c,0x06,0x86,0x06]

v_max_i32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x7e,0x06,0x86,0x06]

v_max_i32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x7f,0x06,0x86,0x06]

v_max_i32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x24,0x01,0x06,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x26,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x00,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x01,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x02,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x03,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x04,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x05,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x0e,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x16,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x16,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x00,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x01,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x02,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x03,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x04,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x05,0x06]

v_max_i32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x0e,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x00]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x01]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x02]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x03]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x04]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x05]

v_max_i32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x0e]

v_max_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x00]

v_max_i32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x25,0x01,0xe4,0x00,0x00]

v_max_i32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0xff,0xe4,0x00,0x00]

v_max_i32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x24,0x01,0xe4,0x00,0x00]

v_max_i32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x1b,0x00,0x00]

v_max_i32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x40,0x01,0x00]

v_max_i32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x41,0x01,0x00]

v_max_i32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x01,0x01,0x00]

v_max_i32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x0f,0x01,0x00]

v_max_i32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x11,0x01,0x00]

v_max_i32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x1f,0x01,0x00]

v_max_i32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x21,0x01,0x00]

v_max_i32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x2f,0x01,0x00]

v_max_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x10]

v_max_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x30]

v_max_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0xf0]

v_max_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x01]

v_max_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x03]

v_max_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x0f]

v_max_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x08,0x00]

v_max_i32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x51,0x01,0x00]

v_max_i32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x5f,0x01,0x00]

v_max_i32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x61,0x01,0x00]

v_max_i32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x24,0x01,0x6f,0x01,0x00]

v_min_u32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x26]

v_min_u32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x27]

v_min_u32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x26]

v_min_u32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x26]

v_min_u32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x26]

v_min_u32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x26]

v_min_u32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x26]

v_min_u32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x26]

v_min_u32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x26]

v_min_u32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x26]

v_min_u32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x26]

v_min_u32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x26]

v_min_u32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x26]

v_min_u32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x26]

v_min_u32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x26]

v_min_u32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x26,0x56,0x34,0x12,0xaf]

v_min_u32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x26,0x73,0x72,0x71,0x3f]

v_min_u32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x26]

v_min_u32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0x05,0x02,0x00]

v_min_u32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x13,0xd5,0x01,0x05,0x02,0x00]

v_min_u32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0xff,0x05,0x02,0x00]

v_min_u32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0x04,0x02,0x00]

v_min_u32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x65,0x04,0x02,0x00]

v_min_u32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x6a,0x04,0x02,0x00]

v_min_u32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x6b,0x04,0x02,0x00]

v_min_u32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x7c,0x04,0x02,0x00]

v_min_u32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x7e,0x04,0x02,0x00]

v_min_u32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x7f,0x04,0x02,0x00]

v_min_u32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x80,0x04,0x02,0x00]

v_min_u32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0xc1,0x04,0x02,0x00]

v_min_u32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0xf0,0x04,0x02,0x00]

v_min_u32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0xf7,0x04,0x02,0x00]

v_min_u32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0xff,0x03,0x00]

v_min_u32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0x05,0x00,0x00]

v_min_u32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0xcb,0x00,0x00]

v_min_u32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0xd5,0x00,0x00]

v_min_u32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0xd7,0x00,0x00]

v_min_u32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0xf9,0x00,0x00]

v_min_u32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0xfd,0x00,0x00]

v_min_u32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0xff,0x00,0x00]

v_min_u32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0x01,0x01,0x00]

v_min_u32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0x83,0x01,0x00]

v_min_u32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0xe1,0x01,0x00]

v_min_u32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x13,0xd5,0x01,0xef,0x01,0x00]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x06]

v_min_u32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x27,0x01,0x06,0x06,0x06]

v_min_u32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0xff,0x06,0x06,0x06]

v_min_u32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x86,0x06]

v_min_u32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x65,0x06,0x86,0x06]

v_min_u32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x6a,0x06,0x86,0x06]

v_min_u32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x6b,0x06,0x86,0x06]

v_min_u32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x7c,0x06,0x86,0x06]

v_min_u32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x7e,0x06,0x86,0x06]

v_min_u32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x7f,0x06,0x86,0x06]

v_min_u32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x26,0x01,0x06,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x26,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x00,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x01,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x02,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x03,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x04,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x05,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x0e,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x16,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x16,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x00,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x01,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x02,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x03,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x04,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x05,0x06]

v_min_u32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x0e,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x00]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x01]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x02]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x03]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x04]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x05]

v_min_u32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x0e]

v_min_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x00]

v_min_u32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x27,0x01,0xe4,0x00,0x00]

v_min_u32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0xff,0xe4,0x00,0x00]

v_min_u32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x26,0x01,0xe4,0x00,0x00]

v_min_u32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x1b,0x00,0x00]

v_min_u32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x40,0x01,0x00]

v_min_u32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x41,0x01,0x00]

v_min_u32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x01,0x01,0x00]

v_min_u32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x0f,0x01,0x00]

v_min_u32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x11,0x01,0x00]

v_min_u32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x1f,0x01,0x00]

v_min_u32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x21,0x01,0x00]

v_min_u32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x2f,0x01,0x00]

v_min_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x10]

v_min_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x30]

v_min_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0xf0]

v_min_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x01]

v_min_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x03]

v_min_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x0f]

v_min_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x08,0x00]

v_min_u32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x51,0x01,0x00]

v_min_u32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x5f,0x01,0x00]

v_min_u32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x61,0x01,0x00]

v_min_u32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x26,0x01,0x6f,0x01,0x00]

v_max_u32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x28]

v_max_u32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x29]

v_max_u32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x28]

v_max_u32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x28]

v_max_u32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x28]

v_max_u32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x28]

v_max_u32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x28]

v_max_u32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x28]

v_max_u32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x28]

v_max_u32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x28]

v_max_u32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x28]

v_max_u32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x28]

v_max_u32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x28]

v_max_u32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x28]

v_max_u32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x28]

v_max_u32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x28,0x56,0x34,0x12,0xaf]

v_max_u32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x28,0x73,0x72,0x71,0x3f]

v_max_u32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x28]

v_max_u32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0x05,0x02,0x00]

v_max_u32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x14,0xd5,0x01,0x05,0x02,0x00]

v_max_u32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0xff,0x05,0x02,0x00]

v_max_u32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0x04,0x02,0x00]

v_max_u32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x65,0x04,0x02,0x00]

v_max_u32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x6a,0x04,0x02,0x00]

v_max_u32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x6b,0x04,0x02,0x00]

v_max_u32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x7c,0x04,0x02,0x00]

v_max_u32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x7e,0x04,0x02,0x00]

v_max_u32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x7f,0x04,0x02,0x00]

v_max_u32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x80,0x04,0x02,0x00]

v_max_u32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0xc1,0x04,0x02,0x00]

v_max_u32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0xf0,0x04,0x02,0x00]

v_max_u32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0xf7,0x04,0x02,0x00]

v_max_u32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0xff,0x03,0x00]

v_max_u32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0x05,0x00,0x00]

v_max_u32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0xcb,0x00,0x00]

v_max_u32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0xd5,0x00,0x00]

v_max_u32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0xd7,0x00,0x00]

v_max_u32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0xf9,0x00,0x00]

v_max_u32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0xfd,0x00,0x00]

v_max_u32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0xff,0x00,0x00]

v_max_u32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0x01,0x01,0x00]

v_max_u32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0x83,0x01,0x00]

v_max_u32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0xe1,0x01,0x00]

v_max_u32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x14,0xd5,0x01,0xef,0x01,0x00]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x06]

v_max_u32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x29,0x01,0x06,0x06,0x06]

v_max_u32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0xff,0x06,0x06,0x06]

v_max_u32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x86,0x06]

v_max_u32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x65,0x06,0x86,0x06]

v_max_u32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x6a,0x06,0x86,0x06]

v_max_u32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x6b,0x06,0x86,0x06]

v_max_u32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x7c,0x06,0x86,0x06]

v_max_u32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x7e,0x06,0x86,0x06]

v_max_u32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x7f,0x06,0x86,0x06]

v_max_u32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x28,0x01,0x06,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x26,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x00,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x01,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x02,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x03,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x04,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x05,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x0e,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x16,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x16,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x00,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x01,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x02,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x03,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x04,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x05,0x06]

v_max_u32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x0e,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x00]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x01]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x02]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x03]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x04]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x05]

v_max_u32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x0e]

v_max_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x00]

v_max_u32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x29,0x01,0xe4,0x00,0x00]

v_max_u32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0xff,0xe4,0x00,0x00]

v_max_u32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x28,0x01,0xe4,0x00,0x00]

v_max_u32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x1b,0x00,0x00]

v_max_u32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x40,0x01,0x00]

v_max_u32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x41,0x01,0x00]

v_max_u32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x01,0x01,0x00]

v_max_u32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x0f,0x01,0x00]

v_max_u32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x11,0x01,0x00]

v_max_u32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x1f,0x01,0x00]

v_max_u32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x21,0x01,0x00]

v_max_u32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x2f,0x01,0x00]

v_max_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x10]

v_max_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x30]

v_max_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0xf0]

v_max_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x01]

v_max_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x03]

v_max_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x0f]

v_max_u32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x08,0x00]

v_max_u32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x51,0x01,0x00]

v_max_u32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x5f,0x01,0x00]

v_max_u32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x61,0x01,0x00]

v_max_u32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x28,0x01,0x6f,0x01,0x00]

v_lshrrev_b32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x2c]

v_lshrrev_b32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x2d]

v_lshrrev_b32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x2c]

v_lshrrev_b32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x2c]

v_lshrrev_b32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x2c]

v_lshrrev_b32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x2c]

v_lshrrev_b32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x2c]

v_lshrrev_b32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x2c]

v_lshrrev_b32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x2c]

v_lshrrev_b32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x2c]

v_lshrrev_b32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x2c]

v_lshrrev_b32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x2c]

v_lshrrev_b32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x2c]

v_lshrrev_b32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x2c]

v_lshrrev_b32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x2c]

v_lshrrev_b32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x2c,0x56,0x34,0x12,0xaf]

v_lshrrev_b32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x2c,0x73,0x72,0x71,0x3f]

v_lshrrev_b32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x2c]

v_lshrrev_b32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0x05,0x02,0x00]

v_lshrrev_b32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x16,0xd5,0x01,0x05,0x02,0x00]

v_lshrrev_b32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0xff,0x05,0x02,0x00]

v_lshrrev_b32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x65,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x6a,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x6b,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x7c,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x7e,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x7f,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x80,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0xc1,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0xf0,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0xf7,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0xff,0x03,0x00]

v_lshrrev_b32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0x05,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0xcb,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0xd5,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0xd7,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0xf9,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0xfd,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0xff,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0x01,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0x83,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0xe1,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x16,0xd5,0x01,0xef,0x01,0x00]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x2d,0x01,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0xff,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x86,0x06]

v_lshrrev_b32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x65,0x06,0x86,0x06]

v_lshrrev_b32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x6a,0x06,0x86,0x06]

v_lshrrev_b32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x6b,0x06,0x86,0x06]

v_lshrrev_b32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x7c,0x06,0x86,0x06]

v_lshrrev_b32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x7e,0x06,0x86,0x06]

v_lshrrev_b32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x7f,0x06,0x86,0x06]

v_lshrrev_b32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x2c,0x01,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x00,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x01,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x02,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x03,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x04,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x05,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x0e,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x16,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x16,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x00,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x01,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x02,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x03,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x04,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x05,0x06]

v_lshrrev_b32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x0e,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x00]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x01]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x02]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x03]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x04]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x05]

v_lshrrev_b32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x0e]

v_lshrrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x00]

v_lshrrev_b32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x2d,0x01,0xe4,0x00,0x00]

v_lshrrev_b32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0xff,0xe4,0x00,0x00]

v_lshrrev_b32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x2c,0x01,0xe4,0x00,0x00]

v_lshrrev_b32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x1b,0x00,0x00]

v_lshrrev_b32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x40,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x41,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x01,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x0f,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x11,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x1f,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x21,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x2f,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x10]

v_lshrrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x30]

v_lshrrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0xf0]

v_lshrrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x01]

v_lshrrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x03]

v_lshrrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x0f]

v_lshrrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x08,0x00]

v_lshrrev_b32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x51,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x5f,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x61,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x6f,0x01,0x00]

v_ashrrev_i32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x30]

v_ashrrev_i32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x31]

v_ashrrev_i32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x30]

v_ashrrev_i32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x30]

v_ashrrev_i32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x30]

v_ashrrev_i32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x30]

v_ashrrev_i32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x30]

v_ashrrev_i32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x30]

v_ashrrev_i32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x30]

v_ashrrev_i32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x30]

v_ashrrev_i32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x30]

v_ashrrev_i32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x30]

v_ashrrev_i32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x30]

v_ashrrev_i32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x30]

v_ashrrev_i32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x30]

v_ashrrev_i32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x30,0x56,0x34,0x12,0xaf]

v_ashrrev_i32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x30,0x73,0x72,0x71,0x3f]

v_ashrrev_i32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x30]

v_ashrrev_i32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0x05,0x02,0x00]

v_ashrrev_i32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x18,0xd5,0x01,0x05,0x02,0x00]

v_ashrrev_i32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0xff,0x05,0x02,0x00]

v_ashrrev_i32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x65,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x6a,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x6b,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x7c,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x7e,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x7f,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x80,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0xc1,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0xf0,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0xf7,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0xff,0x03,0x00]

v_ashrrev_i32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0x05,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0xcb,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0xd5,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0xd7,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0xf9,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0xfd,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0xff,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0x01,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0x83,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0xe1,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x18,0xd5,0x01,0xef,0x01,0x00]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x31,0x01,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0xff,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x86,0x06]

v_ashrrev_i32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x65,0x06,0x86,0x06]

v_ashrrev_i32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x6a,0x06,0x86,0x06]

v_ashrrev_i32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x6b,0x06,0x86,0x06]

v_ashrrev_i32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x7c,0x06,0x86,0x06]

v_ashrrev_i32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x7e,0x06,0x86,0x06]

v_ashrrev_i32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x7f,0x06,0x86,0x06]

v_ashrrev_i32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x30,0x01,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x00,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x01,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x02,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x03,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x04,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x05,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x0e,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x16,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x16,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x00,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x01,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x02,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x03,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x04,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x05,0x06]

v_ashrrev_i32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x0e,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x06,0x00]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x06,0x01]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x06,0x02]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x06,0x03]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x06,0x04]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x06,0x05]

v_ashrrev_i32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x30,0x01,0x06,0x06,0x0e]

v_ashrrev_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0xe4,0x00,0x00]

v_ashrrev_i32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x31,0x01,0xe4,0x00,0x00]

v_ashrrev_i32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0xff,0xe4,0x00,0x00]

v_ashrrev_i32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x30,0x01,0xe4,0x00,0x00]

v_ashrrev_i32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x1b,0x00,0x00]

v_ashrrev_i32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x40,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x41,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x01,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x0f,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x11,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x1f,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x21,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x2f,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0xe4,0x00,0x10]

v_ashrrev_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0xe4,0x00,0x30]

v_ashrrev_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0xe4,0x00,0xf0]

v_ashrrev_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0xe4,0x00,0x01]

v_ashrrev_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0xe4,0x00,0x03]

v_ashrrev_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0xe4,0x00,0x0f]

v_ashrrev_i32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0xe4,0x08,0x00]

v_ashrrev_i32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x51,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x5f,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x61,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x30,0x01,0x6f,0x01,0x00]

v_lshlrev_b32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x34]

v_lshlrev_b32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x35]

v_lshlrev_b32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x34]

v_lshlrev_b32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x34]

v_lshlrev_b32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x34]

v_lshlrev_b32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x34]

v_lshlrev_b32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x34]

v_lshlrev_b32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x34]

v_lshlrev_b32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x34]

v_lshlrev_b32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x34]

v_lshlrev_b32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x34]

v_lshlrev_b32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x34]

v_lshlrev_b32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x34]

v_lshlrev_b32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x34]

v_lshlrev_b32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x34]

v_lshlrev_b32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x34,0x56,0x34,0x12,0xaf]

v_lshlrev_b32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x34,0x73,0x72,0x71,0x3f]

v_lshlrev_b32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x34]

v_lshlrev_b32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0x05,0x02,0x00]

v_lshlrev_b32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x1a,0xd5,0x01,0x05,0x02,0x00]

v_lshlrev_b32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0xff,0x05,0x02,0x00]

v_lshlrev_b32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x65,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x6a,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x6b,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x7c,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x7e,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x7f,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x80,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0xc1,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0xf0,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0xf7,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0xff,0x03,0x00]

v_lshlrev_b32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0x05,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0xcb,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0xd5,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0xd7,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0xf9,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0xfd,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0xff,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0x01,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0x83,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0xe1,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x1a,0xd5,0x01,0xef,0x01,0x00]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x35,0x01,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0xff,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x86,0x06]

v_lshlrev_b32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x65,0x06,0x86,0x06]

v_lshlrev_b32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x6a,0x06,0x86,0x06]

v_lshlrev_b32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x6b,0x06,0x86,0x06]

v_lshlrev_b32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x7c,0x06,0x86,0x06]

v_lshlrev_b32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x7e,0x06,0x86,0x06]

v_lshlrev_b32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x7f,0x06,0x86,0x06]

v_lshlrev_b32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x34,0x01,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x00,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x01,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x02,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x03,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x04,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x05,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x0e,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x16,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x16,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x00,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x01,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x02,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x03,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x04,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x05,0x06]

v_lshlrev_b32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x0e,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x00]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x01]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x02]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x03]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x04]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x05]

v_lshlrev_b32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x0e]

v_lshlrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x00]

v_lshlrev_b32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x35,0x01,0xe4,0x00,0x00]

v_lshlrev_b32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0xff,0xe4,0x00,0x00]

v_lshlrev_b32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x34,0x01,0xe4,0x00,0x00]

v_lshlrev_b32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x1b,0x00,0x00]

v_lshlrev_b32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x40,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x41,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x01,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x0f,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x11,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x1f,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x21,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x2f,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x10]

v_lshlrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x30]

v_lshlrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0xf0]

v_lshlrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x01]

v_lshlrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x03]

v_lshlrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x0f]

v_lshlrev_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x08,0x00]

v_lshlrev_b32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x51,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x5f,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x61,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x34,0x01,0x6f,0x01,0x00]

v_and_b32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x36]

v_and_b32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x37]

v_and_b32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x36]

v_and_b32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x36]

v_and_b32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x36]

v_and_b32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x36]

v_and_b32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x36]

v_and_b32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x36]

v_and_b32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x36]

v_and_b32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x36]

v_and_b32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x36]

v_and_b32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x36]

v_and_b32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x36]

v_and_b32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x36]

v_and_b32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x36]

v_and_b32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x36,0x56,0x34,0x12,0xaf]

v_and_b32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x36,0x73,0x72,0x71,0x3f]

v_and_b32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x36]

v_and_b32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0x05,0x02,0x00]

v_and_b32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x1b,0xd5,0x01,0x05,0x02,0x00]

v_and_b32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0xff,0x05,0x02,0x00]

v_and_b32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0x04,0x02,0x00]

v_and_b32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x65,0x04,0x02,0x00]

v_and_b32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x6a,0x04,0x02,0x00]

v_and_b32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x6b,0x04,0x02,0x00]

v_and_b32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x7c,0x04,0x02,0x00]

v_and_b32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x7e,0x04,0x02,0x00]

v_and_b32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x7f,0x04,0x02,0x00]

v_and_b32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x80,0x04,0x02,0x00]

v_and_b32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0xc1,0x04,0x02,0x00]

v_and_b32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0xf0,0x04,0x02,0x00]

v_and_b32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0xf7,0x04,0x02,0x00]

v_and_b32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0xff,0x03,0x00]

v_and_b32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0x05,0x00,0x00]

v_and_b32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0xcb,0x00,0x00]

v_and_b32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0xd5,0x00,0x00]

v_and_b32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0xd7,0x00,0x00]

v_and_b32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0xf9,0x00,0x00]

v_and_b32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0xfd,0x00,0x00]

v_and_b32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0xff,0x00,0x00]

v_and_b32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0x01,0x01,0x00]

v_and_b32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0x83,0x01,0x00]

v_and_b32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0xe1,0x01,0x00]

v_and_b32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x1b,0xd5,0x01,0xef,0x01,0x00]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x06]

v_and_b32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x37,0x01,0x06,0x06,0x06]

v_and_b32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0xff,0x06,0x06,0x06]

v_and_b32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x86,0x06]

v_and_b32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x65,0x06,0x86,0x06]

v_and_b32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x6a,0x06,0x86,0x06]

v_and_b32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x6b,0x06,0x86,0x06]

v_and_b32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x7c,0x06,0x86,0x06]

v_and_b32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x7e,0x06,0x86,0x06]

v_and_b32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x7f,0x06,0x86,0x06]

v_and_b32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x36,0x01,0x06,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x00,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x01,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x02,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x03,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x04,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x05,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x0e,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x16,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x16,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x00,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x01,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x02,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x03,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x04,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x05,0x06]

v_and_b32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x0e,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x00]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x01]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x02]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x03]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x04]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x05]

v_and_b32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x0e]

v_and_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x00]

v_and_b32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x37,0x01,0xe4,0x00,0x00]

v_and_b32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0xff,0xe4,0x00,0x00]

v_and_b32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x36,0x01,0xe4,0x00,0x00]

v_and_b32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x1b,0x00,0x00]

v_and_b32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x40,0x01,0x00]

v_and_b32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x41,0x01,0x00]

v_and_b32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x01,0x01,0x00]

v_and_b32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x0f,0x01,0x00]

v_and_b32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x11,0x01,0x00]

v_and_b32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x1f,0x01,0x00]

v_and_b32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x21,0x01,0x00]

v_and_b32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x2f,0x01,0x00]

v_and_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x10]

v_and_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x30]

v_and_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0xf0]

v_and_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x01]

v_and_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x03]

v_and_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x0f]

v_and_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x08,0x00]

v_and_b32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x51,0x01,0x00]

v_and_b32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x5f,0x01,0x00]

v_and_b32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x61,0x01,0x00]

v_and_b32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x36,0x01,0x6f,0x01,0x00]

v_or_b32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x38]

v_or_b32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x39]

v_or_b32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x38]

v_or_b32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x38]

v_or_b32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x38]

v_or_b32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x38]

v_or_b32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x38]

v_or_b32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x38]

v_or_b32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x38]

v_or_b32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x38]

v_or_b32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x38]

v_or_b32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x38]

v_or_b32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x38]

v_or_b32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x38]

v_or_b32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x38]

v_or_b32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x38,0x56,0x34,0x12,0xaf]

v_or_b32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x38,0x73,0x72,0x71,0x3f]

v_or_b32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x38]

v_or_b32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0x05,0x02,0x00]

v_or_b32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x1c,0xd5,0x01,0x05,0x02,0x00]

v_or_b32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0xff,0x05,0x02,0x00]

v_or_b32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0x04,0x02,0x00]

v_or_b32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x65,0x04,0x02,0x00]

v_or_b32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x6a,0x04,0x02,0x00]

v_or_b32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x6b,0x04,0x02,0x00]

v_or_b32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x7c,0x04,0x02,0x00]

v_or_b32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x7e,0x04,0x02,0x00]

v_or_b32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x7f,0x04,0x02,0x00]

v_or_b32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x80,0x04,0x02,0x00]

v_or_b32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0xc1,0x04,0x02,0x00]

v_or_b32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0xf0,0x04,0x02,0x00]

v_or_b32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0xf7,0x04,0x02,0x00]

v_or_b32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0xff,0x03,0x00]

v_or_b32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0x05,0x00,0x00]

v_or_b32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0xcb,0x00,0x00]

v_or_b32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0xd5,0x00,0x00]

v_or_b32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0xd7,0x00,0x00]

v_or_b32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0xf9,0x00,0x00]

v_or_b32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0xfd,0x00,0x00]

v_or_b32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0xff,0x00,0x00]

v_or_b32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0x01,0x01,0x00]

v_or_b32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0x83,0x01,0x00]

v_or_b32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0xe1,0x01,0x00]

v_or_b32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x1c,0xd5,0x01,0xef,0x01,0x00]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x06]

v_or_b32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x39,0x01,0x06,0x06,0x06]

v_or_b32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0xff,0x06,0x06,0x06]

v_or_b32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x86,0x06]

v_or_b32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x65,0x06,0x86,0x06]

v_or_b32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x6a,0x06,0x86,0x06]

v_or_b32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x6b,0x06,0x86,0x06]

v_or_b32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x7c,0x06,0x86,0x06]

v_or_b32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x7e,0x06,0x86,0x06]

v_or_b32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x7f,0x06,0x86,0x06]

v_or_b32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x38,0x01,0x06,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x00,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x01,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x02,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x03,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x04,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x05,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x0e,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x16,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x16,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x00,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x01,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x02,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x03,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x04,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x05,0x06]

v_or_b32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x0e,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x00]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x01]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x02]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x03]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x04]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x05]

v_or_b32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x0e]

v_or_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x00]

v_or_b32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x39,0x01,0xe4,0x00,0x00]

v_or_b32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0xff,0xe4,0x00,0x00]

v_or_b32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x38,0x01,0xe4,0x00,0x00]

v_or_b32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x1b,0x00,0x00]

v_or_b32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x40,0x01,0x00]

v_or_b32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x41,0x01,0x00]

v_or_b32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x01,0x01,0x00]

v_or_b32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x0f,0x01,0x00]

v_or_b32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x11,0x01,0x00]

v_or_b32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x1f,0x01,0x00]

v_or_b32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x21,0x01,0x00]

v_or_b32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x2f,0x01,0x00]

v_or_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x10]

v_or_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x30]

v_or_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0xf0]

v_or_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x01]

v_or_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x03]

v_or_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x0f]

v_or_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x08,0x00]

v_or_b32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x51,0x01,0x00]

v_or_b32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x5f,0x01,0x00]

v_or_b32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x61,0x01,0x00]

v_or_b32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x38,0x01,0x6f,0x01,0x00]

v_xor_b32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x3a]

v_xor_b32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x3b]

v_xor_b32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x3a]

v_xor_b32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x3a]

v_xor_b32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x3a]

v_xor_b32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x3a]

v_xor_b32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x3a]

v_xor_b32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x3a]

v_xor_b32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x3a]

v_xor_b32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x3a]

v_xor_b32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x3a]

v_xor_b32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x3a]

v_xor_b32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x3a]

v_xor_b32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x3a]

v_xor_b32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x3a]

v_xor_b32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x3a,0x56,0x34,0x12,0xaf]

v_xor_b32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x3a,0x73,0x72,0x71,0x3f]

v_xor_b32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x3a]

v_xor_b32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0x05,0x02,0x00]

v_xor_b32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x1d,0xd5,0x01,0x05,0x02,0x00]

v_xor_b32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0xff,0x05,0x02,0x00]

v_xor_b32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0x04,0x02,0x00]

v_xor_b32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x65,0x04,0x02,0x00]

v_xor_b32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x6a,0x04,0x02,0x00]

v_xor_b32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x6b,0x04,0x02,0x00]

v_xor_b32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x7c,0x04,0x02,0x00]

v_xor_b32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x7e,0x04,0x02,0x00]

v_xor_b32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x7f,0x04,0x02,0x00]

v_xor_b32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x80,0x04,0x02,0x00]

v_xor_b32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0xc1,0x04,0x02,0x00]

v_xor_b32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0xf0,0x04,0x02,0x00]

v_xor_b32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0xf7,0x04,0x02,0x00]

v_xor_b32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0xff,0x03,0x00]

v_xor_b32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0x05,0x00,0x00]

v_xor_b32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0xcb,0x00,0x00]

v_xor_b32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0xd5,0x00,0x00]

v_xor_b32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0xd7,0x00,0x00]

v_xor_b32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0xf9,0x00,0x00]

v_xor_b32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0xfd,0x00,0x00]

v_xor_b32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0xff,0x00,0x00]

v_xor_b32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0x01,0x01,0x00]

v_xor_b32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0x83,0x01,0x00]

v_xor_b32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0xe1,0x01,0x00]

v_xor_b32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x1d,0xd5,0x01,0xef,0x01,0x00]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x06]

v_xor_b32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x3b,0x01,0x06,0x06,0x06]

v_xor_b32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0xff,0x06,0x06,0x06]

v_xor_b32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x86,0x06]

v_xor_b32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x65,0x06,0x86,0x06]

v_xor_b32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x6a,0x06,0x86,0x06]

v_xor_b32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x6b,0x06,0x86,0x06]

v_xor_b32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x7c,0x06,0x86,0x06]

v_xor_b32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x7e,0x06,0x86,0x06]

v_xor_b32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x7f,0x06,0x86,0x06]

v_xor_b32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x3a,0x01,0x06,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x00,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x01,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x02,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x03,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x04,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x05,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x0e,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x16,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x16,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x00,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x01,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x02,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x03,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x04,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x05,0x06]

v_xor_b32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x0e,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x00]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x01]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x02]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x03]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x04]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x05]

v_xor_b32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x0e]

v_xor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x00]

v_xor_b32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x3b,0x01,0xe4,0x00,0x00]

v_xor_b32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0xff,0xe4,0x00,0x00]

v_xor_b32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x3a,0x01,0xe4,0x00,0x00]

v_xor_b32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x1b,0x00,0x00]

v_xor_b32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x40,0x01,0x00]

v_xor_b32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x41,0x01,0x00]

v_xor_b32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x01,0x01,0x00]

v_xor_b32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x0f,0x01,0x00]

v_xor_b32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x11,0x01,0x00]

v_xor_b32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x1f,0x01,0x00]

v_xor_b32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x21,0x01,0x00]

v_xor_b32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x2f,0x01,0x00]

v_xor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x10]

v_xor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x30]

v_xor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0xf0]

v_xor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x01]

v_xor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x03]

v_xor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x0f]

v_xor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x08,0x00]

v_xor_b32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x51,0x01,0x00]

v_xor_b32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x5f,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x61,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3a,0x01,0x6f,0x01,0x00]

v_xnor_b32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x3c]

v_xnor_b32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x3d]

v_xnor_b32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x3c]

v_xnor_b32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x3c]

v_xnor_b32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x3c]

v_xnor_b32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x3c]

v_xnor_b32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x3c]

v_xnor_b32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x3c]

v_xnor_b32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x3c]

v_xnor_b32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x3c]

v_xnor_b32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x3c]

v_xnor_b32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x3c]

v_xnor_b32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x3c]

v_xnor_b32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x3c]

v_xnor_b32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x3c]

v_xnor_b32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x3c,0x56,0x34,0x12,0xaf]

v_xnor_b32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x3c,0x73,0x72,0x71,0x3f]

v_xnor_b32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x3c]

v_xnor_b32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0x05,0x02,0x00]

v_xnor_b32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x1e,0xd5,0x01,0x05,0x02,0x00]

v_xnor_b32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0xff,0x05,0x02,0x00]

v_xnor_b32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0x04,0x02,0x00]

v_xnor_b32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x65,0x04,0x02,0x00]

v_xnor_b32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x6a,0x04,0x02,0x00]

v_xnor_b32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x6b,0x04,0x02,0x00]

v_xnor_b32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x7c,0x04,0x02,0x00]

v_xnor_b32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x7e,0x04,0x02,0x00]

v_xnor_b32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x7f,0x04,0x02,0x00]

v_xnor_b32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x80,0x04,0x02,0x00]

v_xnor_b32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0xc1,0x04,0x02,0x00]

v_xnor_b32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0xf0,0x04,0x02,0x00]

v_xnor_b32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0xf7,0x04,0x02,0x00]

v_xnor_b32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0xff,0x03,0x00]

v_xnor_b32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0x05,0x00,0x00]

v_xnor_b32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0xcb,0x00,0x00]

v_xnor_b32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0xd5,0x00,0x00]

v_xnor_b32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0xd7,0x00,0x00]

v_xnor_b32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0xf9,0x00,0x00]

v_xnor_b32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0xfd,0x00,0x00]

v_xnor_b32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0xff,0x00,0x00]

v_xnor_b32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0x01,0x01,0x00]

v_xnor_b32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0x83,0x01,0x00]

v_xnor_b32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0xe1,0x01,0x00]

v_xnor_b32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x1e,0xd5,0x01,0xef,0x01,0x00]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x06]

v_xnor_b32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x3d,0x01,0x06,0x06,0x06]

v_xnor_b32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0xff,0x06,0x06,0x06]

v_xnor_b32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x86,0x06]

v_xnor_b32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x65,0x06,0x86,0x06]

v_xnor_b32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x6a,0x06,0x86,0x06]

v_xnor_b32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x6b,0x06,0x86,0x06]

v_xnor_b32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x7c,0x06,0x86,0x06]

v_xnor_b32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x7e,0x06,0x86,0x06]

v_xnor_b32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x7f,0x06,0x86,0x06]

v_xnor_b32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x3c,0x01,0x06,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x00,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x01,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x02,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x03,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x04,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x05,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x0e,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x16,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x16,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x00,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x01,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x02,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x03,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x04,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x05,0x06]

v_xnor_b32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x0e,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x06]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x00]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x01]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x02]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x03]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x04]

v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x05]

v_xnor_b32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x0e]

v_xnor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x00]

v_xnor_b32_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x3d,0x01,0xe4,0x00,0x00]

v_xnor_b32_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0xff,0xe4,0x00,0x00]

v_xnor_b32_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x3c,0x01,0xe4,0x00,0x00]

v_xnor_b32_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x1b,0x00,0x00]

v_xnor_b32_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x40,0x01,0x00]

v_xnor_b32_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x41,0x01,0x00]

v_xnor_b32_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x01,0x01,0x00]

v_xnor_b32_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x0f,0x01,0x00]

v_xnor_b32_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x11,0x01,0x00]

v_xnor_b32_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x1f,0x01,0x00]

v_xnor_b32_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x21,0x01,0x00]

v_xnor_b32_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x2f,0x01,0x00]

v_xnor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x10]

v_xnor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x30]

v_xnor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0xf0]

v_xnor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x01]

v_xnor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x03]

v_xnor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x0f]

v_xnor_b32_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x08,0x00]

v_xnor_b32_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x51,0x01,0x00]

v_xnor_b32_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x5f,0x01,0x00]

v_xnor_b32_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x61,0x01,0x00]

v_xnor_b32_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x3c,0x01,0x6f,0x01,0x00]

v_mac_f32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x3e]

v_mac_f32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x3f]

v_mac_f32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x3e]

v_mac_f32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x3e]

v_mac_f32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x3e]

v_mac_f32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x3e]

v_mac_f32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x3e]

v_mac_f32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x3e]

v_mac_f32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x3e]

v_mac_f32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x3e]

v_mac_f32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x3e]

v_mac_f32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x3e]

v_mac_f32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x3e]

v_mac_f32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x3e]

v_mac_f32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x3e]

v_mac_f32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x3e,0x56,0x34,0x12,0xaf]

v_mac_f32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x3e,0x73,0x72,0x71,0x3f]

v_mac_f32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x3e]

v_mac_f32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x1f,0xd5,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0xff,0x05,0x02,0x00]

v_mac_f32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0x04,0x02,0x00]

v_mac_f32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x65,0x04,0x02,0x00]

v_mac_f32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x6a,0x04,0x02,0x00]

v_mac_f32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x6b,0x04,0x02,0x00]

v_mac_f32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x7c,0x04,0x02,0x00]

v_mac_f32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x7e,0x04,0x02,0x00]

v_mac_f32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x7f,0x04,0x02,0x00]

v_mac_f32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x80,0x04,0x02,0x00]

v_mac_f32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0xc1,0x04,0x02,0x00]

v_mac_f32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0xf0,0x04,0x02,0x00]

v_mac_f32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0xf7,0x04,0x02,0x00]

v_mac_f32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0xff,0x03,0x00]

v_mac_f32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0x05,0x00,0x00]

v_mac_f32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0xcb,0x00,0x00]

v_mac_f32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0xd5,0x00,0x00]

v_mac_f32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0xd7,0x00,0x00]

v_mac_f32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0xf9,0x00,0x00]

v_mac_f32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0xfd,0x00,0x00]

v_mac_f32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0xff,0x00,0x00]

v_mac_f32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0x01,0x01,0x00]

v_mac_f32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0x83,0x01,0x00]

v_mac_f32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0xe1,0x01,0x00]

v_mac_f32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0xef,0x01,0x00]

v_mac_f32_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0x05,0x02,0x20]

v_mac_f32_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0x05,0x02,0x40]

v_mac_f32_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0x05,0x02,0x60]

v_mac_f32_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x1f,0xd5,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x1f,0xd5,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x1f,0xd5,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x1f,0xd5,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v1, v2 mul:2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0x05,0x02,0x08]

v_mac_f32_e64 v5, v1, v2 mul:4
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0x05,0x02,0x10]

v_mac_f32_e64 v5, v1, v2 div:2
// GFX10: encoding: [0x05,0x00,0x1f,0xd5,0x01,0x05,0x02,0x18]

v_madmk_f32 v5, v1, 0x11213141, v3
// GFX10: encoding: [0x01,0x07,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v255, v1, 0x11213141, v3
// GFX10: encoding: [0x01,0x07,0xfe,0x41,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, v255, 0x11213141, v3
// GFX10: encoding: [0xff,0x07,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, 0, 0x11213141, v3
// GFX10: encoding: [0x80,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, -1, 0x11213141, v3
// GFX10: encoding: [0xc1,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, 0.5, 0x11213141, v3
// GFX10: encoding: [0xf0,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, -4.0, 0x11213141, v3
// GFX10: encoding: [0xf7,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, v1, 0xa1b1c1d1, v3
// GFX10: encoding: [0x01,0x07,0x0a,0x40,0xd1,0xc1,0xb1,0xa1]

v_madmk_f32 v5, v1, 0x11213141, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x40,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v1, v2, 0x11213141
// GFX10: encoding: [0x01,0x05,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v255, v1, v2, 0x11213141
// GFX10: encoding: [0x01,0x05,0xfe,0x43,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v255, v2, 0x11213141
// GFX10: encoding: [0xff,0x05,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, 0, v2, 0x11213141
// GFX10: encoding: [0x80,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, -1, v2, 0x11213141
// GFX10: encoding: [0xc1,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, 0.5, v2, 0x11213141
// GFX10: encoding: [0xf0,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, -4.0, v2, 0x11213141
// GFX10: encoding: [0xf7,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v1, v255, 0x11213141
// GFX10: encoding: [0x01,0xff,0x0b,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v1, v2, 0xa1b1c1d1
// GFX10: encoding: [0x01,0x05,0x0a,0x42,0xd1,0xc1,0xb1,0xa1]

v_add_nc_u32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x4a]

v_add_nc_u32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x4b]

v_add_nc_u32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x4a]

v_add_nc_u32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x4a]

v_add_nc_u32_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x4a]

v_add_nc_u32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x4a]

v_add_nc_u32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x4a]

v_add_nc_u32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x4a]

v_add_nc_u32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x4a]

v_add_nc_u32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x4a]

v_add_nc_u32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x4a]

v_add_nc_u32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x4a]

v_add_nc_u32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x4a]

v_add_nc_u32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x4a]

v_add_nc_u32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x4a,0x56,0x34,0x12,0xaf]

v_add_nc_u32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x4a,0x73,0x72,0x71,0x3f]

v_add_nc_u32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x4a]

v_add_nc_u32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0x05,0x02,0x00]

v_add_nc_u32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x25,0xd5,0x01,0x05,0x02,0x00]

v_add_nc_u32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0xff,0x05,0x02,0x00]

v_add_nc_u32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0x04,0x02,0x00]

v_add_nc_u32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x65,0x04,0x02,0x00]

v_add_nc_u32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x6a,0x04,0x02,0x00]

v_add_nc_u32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x6b,0x04,0x02,0x00]

v_add_nc_u32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x7c,0x04,0x02,0x00]

v_add_nc_u32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x7e,0x04,0x02,0x00]

v_add_nc_u32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x7f,0x04,0x02,0x00]

v_add_nc_u32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x80,0x04,0x02,0x00]

v_add_nc_u32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0xc1,0x04,0x02,0x00]

v_add_nc_u32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0xf0,0x04,0x02,0x00]

v_add_nc_u32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0xf7,0x04,0x02,0x00]

v_add_nc_u32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0xff,0x03,0x00]

v_add_nc_u32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0x05,0x00,0x00]

v_add_nc_u32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0xcb,0x00,0x00]

v_add_nc_u32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0xd5,0x00,0x00]

v_add_nc_u32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0xd7,0x00,0x00]

v_add_nc_u32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0xf9,0x00,0x00]

v_add_nc_u32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0xfd,0x00,0x00]

v_add_nc_u32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0xff,0x00,0x00]

v_add_nc_u32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0x01,0x01,0x00]

v_add_nc_u32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0x83,0x01,0x00]

v_add_nc_u32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0xe1,0x01,0x00]

v_add_nc_u32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x25,0xd5,0x01,0xef,0x01,0x00]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x06,0x06]

v_add_nc_u32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x4b,0x01,0x06,0x06,0x06]

v_add_nc_u32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0xff,0x06,0x06,0x06]

v_add_nc_u32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x86,0x06]

v_add_nc_u32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x65,0x06,0x86,0x06]

v_add_nc_u32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x6a,0x06,0x86,0x06]

v_add_nc_u32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x6b,0x06,0x86,0x06]

v_add_nc_u32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x7c,0x06,0x86,0x06]

v_add_nc_u32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x7e,0x06,0x86,0x06]

v_add_nc_u32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x7f,0x06,0x86,0x06]

v_add_nc_u32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x4a,0x01,0x06,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x26,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x00,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x01,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x02,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x03,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x04,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x05,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x0e,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x16,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x16,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x00,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x01,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x02,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x03,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x04,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x05,0x06]

v_add_nc_u32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x0e,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x06,0x06]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x06,0x00]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x06,0x01]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x06,0x02]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x06,0x03]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x06,0x04]

v_add_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x06,0x05]

v_add_nc_u32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4a,0x01,0x06,0x06,0x0e]

v_sub_nc_u32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x4c]

v_sub_nc_u32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x4d]

v_sub_nc_u32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x4c]

v_sub_nc_u32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x4c]

v_sub_nc_u32_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x4c]

v_sub_nc_u32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x4c]

v_sub_nc_u32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x4c]

v_sub_nc_u32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x4c]

v_sub_nc_u32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x4c]

v_sub_nc_u32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x4c]

v_sub_nc_u32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x4c]

v_sub_nc_u32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x4c]

v_sub_nc_u32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x4c]

v_sub_nc_u32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x4c]

v_sub_nc_u32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x4c,0x56,0x34,0x12,0xaf]

v_sub_nc_u32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x4c,0x73,0x72,0x71,0x3f]

v_sub_nc_u32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x4c]

v_sub_nc_u32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0x05,0x02,0x00]

v_sub_nc_u32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x26,0xd5,0x01,0x05,0x02,0x00]

v_sub_nc_u32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0xff,0x05,0x02,0x00]

v_sub_nc_u32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0x04,0x02,0x00]

v_sub_nc_u32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x65,0x04,0x02,0x00]

v_sub_nc_u32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x6a,0x04,0x02,0x00]

v_sub_nc_u32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x6b,0x04,0x02,0x00]

v_sub_nc_u32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x7c,0x04,0x02,0x00]

v_sub_nc_u32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x7e,0x04,0x02,0x00]

v_sub_nc_u32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x7f,0x04,0x02,0x00]

v_sub_nc_u32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x80,0x04,0x02,0x00]

v_sub_nc_u32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0xc1,0x04,0x02,0x00]

v_sub_nc_u32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0xf0,0x04,0x02,0x00]

v_sub_nc_u32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0xf7,0x04,0x02,0x00]

v_sub_nc_u32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0xff,0x03,0x00]

v_sub_nc_u32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0x05,0x00,0x00]

v_sub_nc_u32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0xcb,0x00,0x00]

v_sub_nc_u32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0xd5,0x00,0x00]

v_sub_nc_u32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0xd7,0x00,0x00]

v_sub_nc_u32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0xf9,0x00,0x00]

v_sub_nc_u32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0xfd,0x00,0x00]

v_sub_nc_u32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0xff,0x00,0x00]

v_sub_nc_u32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0x01,0x01,0x00]

v_sub_nc_u32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0x83,0x01,0x00]

v_sub_nc_u32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0xe1,0x01,0x00]

v_sub_nc_u32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x26,0xd5,0x01,0xef,0x01,0x00]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x06]

v_sub_nc_u32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x4d,0x01,0x06,0x06,0x06]

v_sub_nc_u32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0xff,0x06,0x06,0x06]

v_sub_nc_u32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x86,0x06]

v_sub_nc_u32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x65,0x06,0x86,0x06]

v_sub_nc_u32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x6a,0x06,0x86,0x06]

v_sub_nc_u32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x6b,0x06,0x86,0x06]

v_sub_nc_u32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x7c,0x06,0x86,0x06]

v_sub_nc_u32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x7e,0x06,0x86,0x06]

v_sub_nc_u32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x7f,0x06,0x86,0x06]

v_sub_nc_u32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x4c,0x01,0x06,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x26,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x00,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x01,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x02,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x03,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x04,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x05,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x0e,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x16,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x16,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x00,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x01,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x02,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x03,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x04,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x05,0x06]

v_sub_nc_u32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x0e,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x06]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x00]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x01]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x02]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x03]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x04]

v_sub_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x05]

v_sub_nc_u32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x0e]

v_subrev_nc_u32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x4e]

v_subrev_nc_u32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x4f]

v_subrev_nc_u32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x4e]

v_subrev_nc_u32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x4e]

v_subrev_nc_u32_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x4e]

v_subrev_nc_u32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x4e]

v_subrev_nc_u32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x4e]

v_subrev_nc_u32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x4e]

v_subrev_nc_u32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x4e]

v_subrev_nc_u32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x4e]

v_subrev_nc_u32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x4e]

v_subrev_nc_u32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x4e]

v_subrev_nc_u32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x4e]

v_subrev_nc_u32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x4e]

v_subrev_nc_u32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x4e,0x56,0x34,0x12,0xaf]

v_subrev_nc_u32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x4e,0x73,0x72,0x71,0x3f]

v_subrev_nc_u32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x4e]

v_subrev_nc_u32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0x05,0x02,0x00]

v_subrev_nc_u32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x27,0xd5,0x01,0x05,0x02,0x00]

v_subrev_nc_u32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0xff,0x05,0x02,0x00]

v_subrev_nc_u32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0x04,0x02,0x00]

v_subrev_nc_u32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x65,0x04,0x02,0x00]

v_subrev_nc_u32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x6a,0x04,0x02,0x00]

v_subrev_nc_u32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x6b,0x04,0x02,0x00]

v_subrev_nc_u32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x7c,0x04,0x02,0x00]

v_subrev_nc_u32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x7e,0x04,0x02,0x00]

v_subrev_nc_u32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x7f,0x04,0x02,0x00]

v_subrev_nc_u32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x80,0x04,0x02,0x00]

v_subrev_nc_u32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0xc1,0x04,0x02,0x00]

v_subrev_nc_u32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0xf0,0x04,0x02,0x00]

v_subrev_nc_u32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0xf7,0x04,0x02,0x00]

v_subrev_nc_u32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0xff,0x03,0x00]

v_subrev_nc_u32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0x05,0x00,0x00]

v_subrev_nc_u32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0xcb,0x00,0x00]

v_subrev_nc_u32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0xd5,0x00,0x00]

v_subrev_nc_u32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0xd7,0x00,0x00]

v_subrev_nc_u32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0xf9,0x00,0x00]

v_subrev_nc_u32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0xfd,0x00,0x00]

v_subrev_nc_u32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0xff,0x00,0x00]

v_subrev_nc_u32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0x01,0x01,0x00]

v_subrev_nc_u32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0x83,0x01,0x00]

v_subrev_nc_u32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0xe1,0x01,0x00]

v_subrev_nc_u32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x27,0xd5,0x01,0xef,0x01,0x00]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x06]

v_subrev_nc_u32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x4f,0x01,0x06,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0xff,0x06,0x06,0x06]

v_subrev_nc_u32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x86,0x06]

v_subrev_nc_u32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x65,0x06,0x86,0x06]

v_subrev_nc_u32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x6a,0x06,0x86,0x06]

v_subrev_nc_u32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x6b,0x06,0x86,0x06]

v_subrev_nc_u32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x7c,0x06,0x86,0x06]

v_subrev_nc_u32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x7e,0x06,0x86,0x06]

v_subrev_nc_u32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x7f,0x06,0x86,0x06]

v_subrev_nc_u32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x4e,0x01,0x06,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x26,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x00,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x01,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x02,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x03,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x04,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x05,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x0e,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x16,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x16,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x00,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x01,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x02,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x03,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x04,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x05,0x06]

v_subrev_nc_u32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x0e,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x06]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x00]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x01]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x02]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x03]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x04]

v_subrev_nc_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x05]

v_subrev_nc_u32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x0e]

v_add_co_ci_u32_e32 v5, vcc, v1, v2, vcc
// W64: encoding: [0x01,0x05,0x0a,0x50]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v255, vcc, v1, v2, vcc
// W64: encoding: [0x01,0x05,0xfe,0x51]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v5, vcc, v255, v2, vcc
// W64: encoding: [0xff,0x05,0x0a,0x50]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v5, vcc, 0, v2, vcc
// W64: encoding: [0x80,0x04,0x0a,0x50]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v5, vcc, -1, v2, vcc
// W64: encoding: [0xc1,0x04,0x0a,0x50]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v5, vcc, 0.5, v2, vcc
// W64: encoding: [0xf0,0x04,0x0a,0x50]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v5, vcc, -4.0, v2, vcc
// W64: encoding: [0xf7,0x04,0x0a,0x50]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v5, vcc, v1, v255, vcc
// W64: encoding: [0x01,0xff,0x0b,0x50]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e64 v5, s[12:13], v1, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v255, s[12:13], v1, v2, s[6:7]
// W64: encoding: [0xff,0x0c,0x28,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[14:15], v1, v2, s[6:7]
// W64: encoding: [0x05,0x0e,0x28,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[102:103], v1, v2, s[6:7]
// W64: encoding: [0x05,0x66,0x28,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, vcc, v1, v2, s[6:7]
// W64: encoding: [0x05,0x6a,0x28,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], v255, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0xff,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], 0, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0x80,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], -1, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0xc1,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], 0.5, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0xf0,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], -4.0, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0xf7,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], v1, v255, s[6:7]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0x01,0xff,0x1b,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], v1, 0, s[6:7]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0x01,0x01,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], v1, -1, s[6:7]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0x01,0x83,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], v1, 0.5, s[6:7]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0x01,0xe1,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], v1, -4.0, s[6:7]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0x01,0xef,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], v1, v2, s[8:9]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0x01,0x05,0x22,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], v1, v2, s[102:103]
// W64: encoding: [0x05,0x0c,0x28,0xd5,0x01,0x05,0x9a,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s[12:13], v1, v2, vcc
// W64: encoding: [0x05,0x0c,0x28,0xd5,0x01,0x05,0xaa,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e32 v5, vcc_lo, v1, v2, vcc_lo
// W32: encoding: [0x01,0x05,0x0a,0x50]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v255, vcc_lo, v1, v2, vcc_lo
// W32: encoding: [0x01,0x05,0xfe,0x51]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v5, vcc_lo, v255, v2, vcc_lo
// W32: encoding: [0xff,0x05,0x0a,0x50]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v5, vcc_lo, 0, v2, vcc_lo
// W32: encoding: [0x80,0x04,0x0a,0x50]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v5, vcc_lo, -1, v2, vcc_lo
// W32: encoding: [0xc1,0x04,0x0a,0x50]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v5, vcc_lo, 0.5, v2, vcc_lo
// W32: encoding: [0xf0,0x04,0x0a,0x50]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v5, vcc_lo, -4.0, v2, vcc_lo
// W32: encoding: [0xf7,0x04,0x0a,0x50]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e32 v5, vcc_lo, v1, v255, vcc_lo
// W32: encoding: [0x01,0xff,0x0b,0x50]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_e64 v5, s12, v1, v2, s6
// W32: encoding: [0x05,0x0c,0x28,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v255, s12, v1, v2, s6
// W32: encoding: [0xff,0x0c,0x28,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s14, v1, v2, s6
// W32: encoding: [0x05,0x0e,0x28,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s102, v1, v2, s6
// W32: encoding: [0x05,0x66,0x28,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, vcc_lo, v1, v2, s6
// W32: encoding: [0x05,0x6a,0x28,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, v255, v2, s6
// W32: encoding: [0x05,0x0c,0x28,0xd5,0xff,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, 0, v2, s6
// W32: encoding: [0x05,0x0c,0x28,0xd5,0x80,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, -1, v2, s6
// W32: encoding: [0x05,0x0c,0x28,0xd5,0xc1,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, 0.5, v2, s6
// W32: encoding: [0x05,0x0c,0x28,0xd5,0xf0,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, -4.0, v2, s6
// W32: encoding: [0x05,0x0c,0x28,0xd5,0xf7,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, v1, v255, s6
// W32: encoding: [0x05,0x0c,0x28,0xd5,0x01,0xff,0x1b,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, v1, 0, s6
// W32: encoding: [0x05,0x0c,0x28,0xd5,0x01,0x01,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, v1, -1, s6
// W32: encoding: [0x05,0x0c,0x28,0xd5,0x01,0x83,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, v1, 0.5, s6
// W32: encoding: [0x05,0x0c,0x28,0xd5,0x01,0xe1,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, v1, -4.0, s6
// W32: encoding: [0x05,0x0c,0x28,0xd5,0x01,0xef,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, v1, v2, s8
// W32: encoding: [0x05,0x0c,0x28,0xd5,0x01,0x05,0x22,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, v1, v2, s102
// W32: encoding: [0x05,0x0c,0x28,0xd5,0x01,0x05,0x9a,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64 v5, s12, v1, v2, vcc_lo
// W32: encoding: [0x05,0x0c,0x28,0xd5,0x01,0x05,0xaa,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v255, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0xfe,0x51,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v255, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0xff,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v255, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0xfe,0x0b,0x50,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x26,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x00,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x01,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x02,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x03,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x04,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x05,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x0e,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x16,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x16,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x00,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x01,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x02,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x03,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x04,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x05,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, sext(v1), v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x0e,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x05]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc, v1, sext(v2), vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x0e]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v255, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0xfe,0x51,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v255, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0xff,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v255, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0xfe,0x0b,0x50,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x26,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x00,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x01,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x02,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x03,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x04,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x05,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x0e,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x16,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x16,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x00,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x01,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x02,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x03,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x04,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x05,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, sext(v1), v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x0e,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x05]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32_sdwa v5, vcc_lo, v1, sext(v2), vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x0e]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc, v1, v2, vcc
// W64: encoding: [0x01,0x05,0x0a,0x52]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v255, vcc, v1, v2, vcc
// W64: encoding: [0x01,0x05,0xfe,0x53]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc, v255, v2, vcc
// W64: encoding: [0xff,0x05,0x0a,0x52]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc, 0, v2, vcc
// W64: encoding: [0x80,0x04,0x0a,0x52]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc, -1, v2, vcc
// W64: encoding: [0xc1,0x04,0x0a,0x52]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc, 0.5, v2, vcc
// W64: encoding: [0xf0,0x04,0x0a,0x52]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc, -4.0, v2, vcc
// W64: encoding: [0xf7,0x04,0x0a,0x52]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc, v1, v255, vcc
// W64: encoding: [0x01,0xff,0x0b,0x52]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e64 v5, s[12:13], v1, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v255, s[12:13], v1, v2, s[6:7]
// W64: encoding: [0xff,0x0c,0x29,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[14:15], v1, v2, s[6:7]
// W64: encoding: [0x05,0x0e,0x29,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[102:103], v1, v2, s[6:7]
// W64: encoding: [0x05,0x66,0x29,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, vcc, v1, v2, s[6:7]
// W64: encoding: [0x05,0x6a,0x29,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], v255, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0xff,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], 0, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0x80,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], -1, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0xc1,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], 0.5, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0xf0,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], -4.0, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0xf7,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], v1, v255, s[6:7]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0x01,0xff,0x1b,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], v1, 0, s[6:7]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0x01,0x01,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], v1, -1, s[6:7]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0x01,0x83,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], v1, 0.5, s[6:7]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0x01,0xe1,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], v1, -4.0, s[6:7]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0x01,0xef,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], v1, v2, s[8:9]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0x01,0x05,0x22,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], v1, v2, s[102:103]
// W64: encoding: [0x05,0x0c,0x29,0xd5,0x01,0x05,0x9a,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s[12:13], v1, v2, vcc
// W64: encoding: [0x05,0x0c,0x29,0xd5,0x01,0x05,0xaa,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e32 v5, vcc_lo, v1, v2, vcc_lo
// W32: encoding: [0x01,0x05,0x0a,0x52]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v255, vcc_lo, v1, v2, vcc_lo
// W32: encoding: [0x01,0x05,0xfe,0x53]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc_lo, v255, v2, vcc_lo
// W32: encoding: [0xff,0x05,0x0a,0x52]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc_lo, 0, v2, vcc_lo
// W32: encoding: [0x80,0x04,0x0a,0x52]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc_lo, -1, v2, vcc_lo
// W32: encoding: [0xc1,0x04,0x0a,0x52]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc_lo, 0.5, v2, vcc_lo
// W32: encoding: [0xf0,0x04,0x0a,0x52]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc_lo, -4.0, v2, vcc_lo
// W32: encoding: [0xf7,0x04,0x0a,0x52]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e32 v5, vcc_lo, v1, v255, vcc_lo
// W32: encoding: [0x01,0xff,0x0b,0x52]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_e64 v5, s12, v1, v2, s6
// W32: encoding: [0x05,0x0c,0x29,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v255, s12, v1, v2, s6
// W32: encoding: [0xff,0x0c,0x29,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s14, v1, v2, s6
// W32: encoding: [0x05,0x0e,0x29,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s102, v1, v2, s6
// W32: encoding: [0x05,0x66,0x29,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, vcc_lo, v1, v2, s6
// W32: encoding: [0x05,0x6a,0x29,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, v255, v2, s6
// W32: encoding: [0x05,0x0c,0x29,0xd5,0xff,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, 0, v2, s6
// W32: encoding: [0x05,0x0c,0x29,0xd5,0x80,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, -1, v2, s6
// W32: encoding: [0x05,0x0c,0x29,0xd5,0xc1,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, 0.5, v2, s6
// W32: encoding: [0x05,0x0c,0x29,0xd5,0xf0,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, -4.0, v2, s6
// W32: encoding: [0x05,0x0c,0x29,0xd5,0xf7,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, v1, v255, s6
// W32: encoding: [0x05,0x0c,0x29,0xd5,0x01,0xff,0x1b,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, v1, 0, s6
// W32: encoding: [0x05,0x0c,0x29,0xd5,0x01,0x01,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, v1, -1, s6
// W32: encoding: [0x05,0x0c,0x29,0xd5,0x01,0x83,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, v1, 0.5, s6
// W32: encoding: [0x05,0x0c,0x29,0xd5,0x01,0xe1,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, v1, -4.0, s6
// W32: encoding: [0x05,0x0c,0x29,0xd5,0x01,0xef,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, v1, v2, s8
// W32: encoding: [0x05,0x0c,0x29,0xd5,0x01,0x05,0x22,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, v1, v2, s102
// W32: encoding: [0x05,0x0c,0x29,0xd5,0x01,0x05,0x9a,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64 v5, s12, v1, v2, vcc_lo
// W32: encoding: [0x05,0x0c,0x29,0xd5,0x01,0x05,0xaa,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v255, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0xfe,0x53,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v255, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0xff,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v255, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0xfe,0x0b,0x52,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x26,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x00,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x01,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x02,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x03,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x04,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x05,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x0e,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x16,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x16,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x00,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x01,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x02,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x03,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x04,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x05,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, sext(v1), v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x0e,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x05]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc, v1, sext(v2), vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x0e]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v255, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0xfe,0x53,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v255, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0xff,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v255, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0xfe,0x0b,0x52,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x26,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x00,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x01,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x02,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x03,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x04,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x05,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x0e,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x16,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x16,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x00,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x01,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x02,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x03,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x04,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x05,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, sext(v1), v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x0e,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x05]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32_sdwa v5, vcc_lo, v1, sext(v2), vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x0e]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc, v1, v2, vcc
// W64: encoding: [0x01,0x05,0x0a,0x54]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v255, vcc, v1, v2, vcc
// W64: encoding: [0x01,0x05,0xfe,0x55]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc, v255, v2, vcc
// W64: encoding: [0xff,0x05,0x0a,0x54]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc, 0, v2, vcc
// W64: encoding: [0x80,0x04,0x0a,0x54]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc, -1, v2, vcc
// W64: encoding: [0xc1,0x04,0x0a,0x54]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc, 0.5, v2, vcc
// W64: encoding: [0xf0,0x04,0x0a,0x54]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc, -4.0, v2, vcc
// W64: encoding: [0xf7,0x04,0x0a,0x54]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc, v1, v255, vcc
// W64: encoding: [0x01,0xff,0x0b,0x54]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e64 v5, s[12:13], v1, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v255, s[12:13], v1, v2, s[6:7]
// W64: encoding: [0xff,0x0c,0x2a,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[14:15], v1, v2, s[6:7]
// W64: encoding: [0x05,0x0e,0x2a,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[102:103], v1, v2, s[6:7]
// W64: encoding: [0x05,0x66,0x2a,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, vcc, v1, v2, s[6:7]
// W64: encoding: [0x05,0x6a,0x2a,0xd5,0x01,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], v255, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0xff,0x05,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], 0, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0x80,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], -1, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0xc1,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], 0.5, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0xf0,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], -4.0, v2, s[6:7]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0xf7,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], v1, v255, s[6:7]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0xff,0x1b,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], v1, 0, s[6:7]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0x01,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], v1, -1, s[6:7]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0x83,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], v1, 0.5, s[6:7]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0xe1,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], v1, -4.0, s[6:7]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0xef,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], v1, v2, s[8:9]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0x05,0x22,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], v1, v2, s[102:103]
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0x05,0x9a,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s[12:13], v1, v2, vcc
// W64: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0x05,0xaa,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e32 v5, vcc_lo, v1, v2, vcc_lo
// W32: encoding: [0x01,0x05,0x0a,0x54]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v255, vcc_lo, v1, v2, vcc_lo
// W32: encoding: [0x01,0x05,0xfe,0x55]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc_lo, v255, v2, vcc_lo
// W32: encoding: [0xff,0x05,0x0a,0x54]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc_lo, 0, v2, vcc_lo
// W32: encoding: [0x80,0x04,0x0a,0x54]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc_lo, -1, v2, vcc_lo
// W32: encoding: [0xc1,0x04,0x0a,0x54]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc_lo, 0.5, v2, vcc_lo
// W32: encoding: [0xf0,0x04,0x0a,0x54]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc_lo, -4.0, v2, vcc_lo
// W32: encoding: [0xf7,0x04,0x0a,0x54]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e32 v5, vcc_lo, v1, v255, vcc_lo
// W32: encoding: [0x01,0xff,0x0b,0x54]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_e64 v5, s12, v1, v2, s6
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v255, s12, v1, v2, s6
// W32: encoding: [0xff,0x0c,0x2a,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s14, v1, v2, s6
// W32: encoding: [0x05,0x0e,0x2a,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s102, v1, v2, s6
// W32: encoding: [0x05,0x66,0x2a,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, vcc_lo, v1, v2, s6
// W32: encoding: [0x05,0x6a,0x2a,0xd5,0x01,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, v255, v2, s6
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0xff,0x05,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, 0, v2, s6
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0x80,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, -1, v2, s6
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0xc1,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, 0.5, v2, s6
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0xf0,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, -4.0, v2, s6
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0xf7,0x04,0x1a,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, v1, v255, s6
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0xff,0x1b,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, v1, 0, s6
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0x01,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, v1, -1, s6
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0x83,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, v1, 0.5, s6
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0xe1,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, v1, -4.0, s6
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0xef,0x19,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, v1, v2, s8
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0x05,0x22,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, v1, v2, s102
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0x05,0x9a,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64 v5, s12, v1, v2, vcc_lo
// W32: encoding: [0x05,0x0c,0x2a,0xd5,0x01,0x05,0xaa,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v255, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0xfe,0x55,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v255, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0xff,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v255, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0xfe,0x0b,0x54,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x26,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x00,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x01,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x02,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x03,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x04,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x05,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x0e,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x16,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x16,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x00,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x01,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x02,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x03,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x04,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x05,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, sext(v1), v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x0e,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x06]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x05]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc, v1, sext(v2), vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W64: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x0e]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v255, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0xfe,0x55,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v255, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0xff,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v255, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0xfe,0x0b,0x54,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x26,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x00,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x01,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x02,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x03,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x04,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x05,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x0e,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x16,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x16,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x00,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x01,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x02,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x03,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x04,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x05,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, sext(v1), v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x0e,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x06]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x05]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32_sdwa v5, vcc_lo, v1, sext(v2), vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// W32: encoding: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x0e]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_fmac_f32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x56]

v_fmac_f32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x57]

v_fmac_f32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x56]

v_fmac_f32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x56]

v_fmac_f32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x56]

v_fmac_f32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x56]

v_fmac_f32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x56]

v_fmac_f32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x56]

v_fmac_f32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x56]

v_fmac_f32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x56]

v_fmac_f32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x56]

v_fmac_f32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x56]

v_fmac_f32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x56]

v_fmac_f32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x56]

v_fmac_f32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x56]

v_fmac_f32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x56,0x56,0x34,0x12,0xaf]

v_fmac_f32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x56,0x73,0x72,0x71,0x3f]

v_fmac_f32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x56]

v_fmac_f32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x2b,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0xff,0x05,0x02,0x00]

v_fmac_f32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x04,0x02,0x00]

v_fmac_f32_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x65,0x04,0x02,0x00]

v_fmac_f32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x6a,0x04,0x02,0x00]

v_fmac_f32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x6b,0x04,0x02,0x00]

v_fmac_f32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x7c,0x04,0x02,0x00]

v_fmac_f32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x7e,0x04,0x02,0x00]

v_fmac_f32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x7f,0x04,0x02,0x00]

v_fmac_f32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x80,0x04,0x02,0x00]

v_fmac_f32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0xc1,0x04,0x02,0x00]

v_fmac_f32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0xf0,0x04,0x02,0x00]

v_fmac_f32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0xf7,0x04,0x02,0x00]

v_fmac_f32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0xff,0x03,0x00]

v_fmac_f32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x05,0x00,0x00]

v_fmac_f32_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0xcb,0x00,0x00]

v_fmac_f32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0xd5,0x00,0x00]

v_fmac_f32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0xd7,0x00,0x00]

v_fmac_f32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0xf9,0x00,0x00]

v_fmac_f32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0xfd,0x00,0x00]

v_fmac_f32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0xff,0x00,0x00]

v_fmac_f32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x01,0x01,0x00]

v_fmac_f32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x83,0x01,0x00]

v_fmac_f32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0xe1,0x01,0x00]

v_fmac_f32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0xef,0x01,0x00]

v_fmac_f32_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x05,0x02,0x20]

v_fmac_f32_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x05,0x02,0x40]

v_fmac_f32_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x05,0x02,0x60]

v_fmac_f32_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x2b,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f32_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x2b,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f32_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x2b,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f32_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x2b,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f32_e64 v5, v1, v2 mul:2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x05,0x02,0x08]

v_fmac_f32_e64 v5, v1, v2 mul:4
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x05,0x02,0x10]

v_fmac_f32_e64 v5, v1, v2 div:2
// GFX10: encoding: [0x05,0x00,0x2b,0xd5,0x01,0x05,0x02,0x18]

v_fmamk_f32 v5, v1, 0x11213141, v3
// GFX10: encoding: [0x01,0x07,0x0a,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v255, v1, 0x11213141, v3
// GFX10: encoding: [0x01,0x07,0xfe,0x59,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, v255, 0x11213141, v3
// GFX10: encoding: [0xff,0x07,0x0a,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, 0, 0x11213141, v3
// GFX10: encoding: [0x80,0x06,0x0a,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, -1, 0x11213141, v3
// GFX10: encoding: [0xc1,0x06,0x0a,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, 0.5, 0x11213141, v3
// GFX10: encoding: [0xf0,0x06,0x0a,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, -4.0, 0x11213141, v3
// GFX10: encoding: [0xf7,0x06,0x0a,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, v1, 0xa1b1c1d1, v3
// GFX10: encoding: [0x01,0x07,0x0a,0x58,0xd1,0xc1,0xb1,0xa1]

v_fmamk_f32 v5, v1, 0x11213141, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x58,0x41,0x31,0x21,0x11]

v_fmamk_f32 v5, 0x11213141, 0x11213141, v255
// GFX10: encoding: [0xff,0xfe,0x0b,0x58,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, v1, v2, 0x11213141
// GFX10: encoding: [0x01,0x05,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, 0x11213141, v2, 0x11213141
// GFX10: encoding: [0xff,0x04,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v255, v1, v2, 0x11213141
// GFX10: encoding: [0x01,0x05,0xfe,0x5b,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, v255, v2, 0x11213141
// GFX10: encoding: [0xff,0x05,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, 0, v2, 0x11213141
// GFX10: encoding: [0x80,0x04,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, -1, v2, 0x11213141
// GFX10: encoding: [0xc1,0x04,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, 0.5, v2, 0x11213141
// GFX10: encoding: [0xf0,0x04,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, -4.0, v2, 0x11213141
// GFX10: encoding: [0xf7,0x04,0x0a,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, v1, v255, 0x11213141
// GFX10: encoding: [0x01,0xff,0x0b,0x5a,0x41,0x31,0x21,0x11]

v_fmaak_f32 v5, v1, v2, 0xa1b1c1d1
// GFX10: encoding: [0x01,0x05,0x0a,0x5a,0xd1,0xc1,0xb1,0xa1]

v_fmaak_f32 v5, v1, v2, -1
// GFX10: encoding: [0x01,0x05,0x0a,0x5a,0xff,0xff,0xff,0xff]

v_cvt_pkrtz_f16_f32_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x5f]

v_cvt_pkrtz_f16_f32_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32_e32 v5, 0xaf123456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x5e,0x56,0x34,0x12,0xaf]

v_cvt_pkrtz_f16_f32_e32 v5, 0x3f717273, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x5e,0x73,0x72,0x71,0x3f]

v_cvt_pkrtz_f16_f32_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x5e]

v_cvt_pkrtz_f16_f32_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x2f,0xd5,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0xff,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, s103, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x67,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x6a,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x6b,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, ttmp11, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x77,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x7c,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x7e,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x7f,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x80,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0xc1,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0xf0,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0xf7,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0xff,0x03,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0x05,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, s103
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0xcf,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0xd5,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0xd7,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, ttmp11
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0xef,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0xf9,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0xfd,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0xff,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0x01,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0x83,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0xe1,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0xef,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0x05,0x02,0x20]

v_cvt_pkrtz_f16_f32_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0x05,0x02,0x40]

v_cvt_pkrtz_f16_f32_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x2f,0xd5,0x01,0x05,0x02,0x60]

v_cvt_pkrtz_f16_f32_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x2f,0xd5,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x2f,0xd5,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x2f,0xd5,0x01,0x05,0x02,0x00]

v_add_f16_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x64]

v_add_f16_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x65]

v_add_f16_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x64]

v_add_f16_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x64]

v_add_f16_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x64]

v_add_f16_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x64]

v_add_f16_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x64]

v_add_f16_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x64]

v_add_f16_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x64]

v_add_f16_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x64]

v_add_f16_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x64]

v_add_f16_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x64]

v_add_f16_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x64]

v_add_f16_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x64]

v_add_f16_e32 v5, 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x64,0x0b,0xfe,0x00,0x00]

v_add_f16_e32 v5, 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x64,0x56,0x34,0x00,0x00]

v_add_f16_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x64]

v_add_f16_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0x05,0x02,0x00]

v_add_f16_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x32,0xd5,0x01,0x05,0x02,0x00]

v_add_f16_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0xff,0x05,0x02,0x00]

v_add_f16_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0x04,0x02,0x00]

v_add_f16_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x65,0x04,0x02,0x00]

v_add_f16_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x6a,0x04,0x02,0x00]

v_add_f16_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x6b,0x04,0x02,0x00]

v_add_f16_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x7c,0x04,0x02,0x00]

v_add_f16_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x7e,0x04,0x02,0x00]

v_add_f16_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x7f,0x04,0x02,0x00]

v_add_f16_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x80,0x04,0x02,0x00]

v_add_f16_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0xc1,0x04,0x02,0x00]

v_add_f16_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0xf0,0x04,0x02,0x00]

v_add_f16_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0xf7,0x04,0x02,0x00]

v_add_f16_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0xff,0x03,0x00]

v_add_f16_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0x05,0x00,0x00]

v_add_f16_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0xcb,0x00,0x00]

v_add_f16_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0xd5,0x00,0x00]

v_add_f16_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0xd7,0x00,0x00]

v_add_f16_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0xf9,0x00,0x00]

v_add_f16_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0xfd,0x00,0x00]

v_add_f16_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0xff,0x00,0x00]

v_add_f16_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0x01,0x01,0x00]

v_add_f16_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0x83,0x01,0x00]

v_add_f16_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0xe1,0x01,0x00]

v_add_f16_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0xef,0x01,0x00]

v_add_f16_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0x05,0x02,0x20]

v_add_f16_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0x05,0x02,0x40]

v_add_f16_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x32,0xd5,0x01,0x05,0x02,0x60]

v_add_f16_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x32,0xd5,0x01,0x05,0x02,0x00]

v_add_f16_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x32,0xd5,0x01,0x05,0x02,0x00]

v_add_f16_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x32,0xd5,0x01,0x05,0x02,0x00]

v_add_f16_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x32,0xd5,0x01,0x05,0x02,0x00]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x06]

v_add_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x65,0x01,0x06,0x06,0x06]

v_add_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0xff,0x06,0x06,0x06]

v_add_f16_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x86,0x06]

v_add_f16_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x65,0x06,0x86,0x06]

v_add_f16_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x6a,0x06,0x86,0x06]

v_add_f16_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x6b,0x06,0x86,0x06]

v_add_f16_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x7c,0x06,0x86,0x06]

v_add_f16_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x7e,0x06,0x86,0x06]

v_add_f16_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x7f,0x06,0x86,0x06]

v_add_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x64,0x01,0x06,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x26,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x00,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x01,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x02,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x03,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x04,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x05,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x0e,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x16,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x16,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x00,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x01,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x02,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x03,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x04,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x05,0x06]

v_add_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x16,0x06]

v_add_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x26,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x00]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x01]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x02]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x03]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x04]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x05]

v_add_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x16]

v_add_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x26]

v_add_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x00]

v_add_f16_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x65,0x01,0xe4,0x00,0x00]

v_add_f16_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0xff,0xe4,0x00,0x00]

v_add_f16_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x64,0x01,0xe4,0x00,0x00]

v_add_f16_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x1b,0x00,0x00]

v_add_f16_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x40,0x01,0x00]

v_add_f16_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x41,0x01,0x00]

v_add_f16_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x01,0x01,0x00]

v_add_f16_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x0f,0x01,0x00]

v_add_f16_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x11,0x01,0x00]

v_add_f16_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x1f,0x01,0x00]

v_add_f16_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x21,0x01,0x00]

v_add_f16_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x2f,0x01,0x00]

v_add_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x10]

v_add_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x30]

v_add_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0xf0]

v_add_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x01]

v_add_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x03]

v_add_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x0f]

v_add_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x08,0x00]

v_add_f16_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x10,0x00]

v_add_f16_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x20,0x00]

v_add_f16_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x51,0x01,0x00]

v_add_f16_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x5f,0x01,0x00]

v_add_f16_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x61,0x01,0x00]

v_add_f16_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x64,0x01,0x6f,0x01,0x00]

v_sub_f16_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x66]

v_sub_f16_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x67]

v_sub_f16_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x66]

v_sub_f16_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x66]

v_sub_f16_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x66]

v_sub_f16_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x66]

v_sub_f16_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x66]

v_sub_f16_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x66]

v_sub_f16_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x66]

v_sub_f16_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x66]

v_sub_f16_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x66]

v_sub_f16_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x66]

v_sub_f16_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x66]

v_sub_f16_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x66]

v_sub_f16_e32 v5, 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x66,0x0b,0xfe,0x00,0x00]

v_sub_f16_e32 v5, 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x66,0x56,0x34,0x00,0x00]

v_sub_f16_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x66]

v_sub_f16_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0x05,0x02,0x00]

v_sub_f16_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x33,0xd5,0x01,0x05,0x02,0x00]

v_sub_f16_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0xff,0x05,0x02,0x00]

v_sub_f16_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0x04,0x02,0x00]

v_sub_f16_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x65,0x04,0x02,0x00]

v_sub_f16_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x6a,0x04,0x02,0x00]

v_sub_f16_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x6b,0x04,0x02,0x00]

v_sub_f16_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x7c,0x04,0x02,0x00]

v_sub_f16_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x7e,0x04,0x02,0x00]

v_sub_f16_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x7f,0x04,0x02,0x00]

v_sub_f16_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x80,0x04,0x02,0x00]

v_sub_f16_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0xc1,0x04,0x02,0x00]

v_sub_f16_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0xf0,0x04,0x02,0x00]

v_sub_f16_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0xf7,0x04,0x02,0x00]

v_sub_f16_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0xff,0x03,0x00]

v_sub_f16_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0x05,0x00,0x00]

v_sub_f16_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0xcb,0x00,0x00]

v_sub_f16_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0xd5,0x00,0x00]

v_sub_f16_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0xd7,0x00,0x00]

v_sub_f16_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0xf9,0x00,0x00]

v_sub_f16_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0xfd,0x00,0x00]

v_sub_f16_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0xff,0x00,0x00]

v_sub_f16_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0x01,0x01,0x00]

v_sub_f16_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0x83,0x01,0x00]

v_sub_f16_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0xe1,0x01,0x00]

v_sub_f16_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0xef,0x01,0x00]

v_sub_f16_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0x05,0x02,0x20]

v_sub_f16_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0x05,0x02,0x40]

v_sub_f16_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x33,0xd5,0x01,0x05,0x02,0x60]

v_sub_f16_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x33,0xd5,0x01,0x05,0x02,0x00]

v_sub_f16_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x33,0xd5,0x01,0x05,0x02,0x00]

v_sub_f16_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x33,0xd5,0x01,0x05,0x02,0x00]

v_sub_f16_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x33,0xd5,0x01,0x05,0x02,0x00]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x06]

v_sub_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x67,0x01,0x06,0x06,0x06]

v_sub_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0xff,0x06,0x06,0x06]

v_sub_f16_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x86,0x06]

v_sub_f16_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x65,0x06,0x86,0x06]

v_sub_f16_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x6a,0x06,0x86,0x06]

v_sub_f16_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x6b,0x06,0x86,0x06]

v_sub_f16_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x7c,0x06,0x86,0x06]

v_sub_f16_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x7e,0x06,0x86,0x06]

v_sub_f16_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x7f,0x06,0x86,0x06]

v_sub_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x66,0x01,0x06,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x26,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x00,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x01,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x02,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x03,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x04,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x05,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x0e,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x16,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x16,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x00,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x01,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x02,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x03,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x04,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x05,0x06]

v_sub_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x16,0x06]

v_sub_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x26,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x00]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x01]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x02]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x03]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x04]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x05]

v_sub_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x16]

v_sub_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x26]

v_sub_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x00]

v_sub_f16_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x67,0x01,0xe4,0x00,0x00]

v_sub_f16_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0xff,0xe4,0x00,0x00]

v_sub_f16_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x66,0x01,0xe4,0x00,0x00]

v_sub_f16_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x1b,0x00,0x00]

v_sub_f16_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x40,0x01,0x00]

v_sub_f16_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x41,0x01,0x00]

v_sub_f16_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x01,0x01,0x00]

v_sub_f16_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x0f,0x01,0x00]

v_sub_f16_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x11,0x01,0x00]

v_sub_f16_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x1f,0x01,0x00]

v_sub_f16_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x21,0x01,0x00]

v_sub_f16_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x2f,0x01,0x00]

v_sub_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x10]

v_sub_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x30]

v_sub_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0xf0]

v_sub_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x01]

v_sub_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x03]

v_sub_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x0f]

v_sub_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x08,0x00]

v_sub_f16_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x10,0x00]

v_sub_f16_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x20,0x00]

v_sub_f16_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x51,0x01,0x00]

v_sub_f16_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x5f,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x61,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x66,0x01,0x6f,0x01,0x00]

v_subrev_f16_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x68]

v_subrev_f16_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x69]

v_subrev_f16_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x68]

v_subrev_f16_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x68]

v_subrev_f16_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x68]

v_subrev_f16_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x68]

v_subrev_f16_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x68]

v_subrev_f16_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x68]

v_subrev_f16_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x68]

v_subrev_f16_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x68]

v_subrev_f16_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x68]

v_subrev_f16_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x68]

v_subrev_f16_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x68]

v_subrev_f16_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x68]

v_subrev_f16_e32 v5, 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x68,0x0b,0xfe,0x00,0x00]

v_subrev_f16_e32 v5, 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x68,0x56,0x34,0x00,0x00]

v_subrev_f16_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x68]

v_subrev_f16_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f16_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x34,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f16_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0xff,0x05,0x02,0x00]

v_subrev_f16_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0x04,0x02,0x00]

v_subrev_f16_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x65,0x04,0x02,0x00]

v_subrev_f16_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x6a,0x04,0x02,0x00]

v_subrev_f16_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x6b,0x04,0x02,0x00]

v_subrev_f16_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x7c,0x04,0x02,0x00]

v_subrev_f16_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x7e,0x04,0x02,0x00]

v_subrev_f16_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x7f,0x04,0x02,0x00]

v_subrev_f16_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x80,0x04,0x02,0x00]

v_subrev_f16_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0xc1,0x04,0x02,0x00]

v_subrev_f16_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0xf0,0x04,0x02,0x00]

v_subrev_f16_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0xf7,0x04,0x02,0x00]

v_subrev_f16_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0xff,0x03,0x00]

v_subrev_f16_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0x05,0x00,0x00]

v_subrev_f16_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0xcb,0x00,0x00]

v_subrev_f16_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0xd5,0x00,0x00]

v_subrev_f16_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0xd7,0x00,0x00]

v_subrev_f16_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0xf9,0x00,0x00]

v_subrev_f16_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0xfd,0x00,0x00]

v_subrev_f16_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0xff,0x00,0x00]

v_subrev_f16_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0x01,0x01,0x00]

v_subrev_f16_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0x83,0x01,0x00]

v_subrev_f16_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0xe1,0x01,0x00]

v_subrev_f16_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0xef,0x01,0x00]

v_subrev_f16_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0x05,0x02,0x20]

v_subrev_f16_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0x05,0x02,0x40]

v_subrev_f16_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x34,0xd5,0x01,0x05,0x02,0x60]

v_subrev_f16_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x34,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f16_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x34,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f16_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x34,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f16_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x34,0xd5,0x01,0x05,0x02,0x00]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x06,0x06]

v_subrev_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x69,0x01,0x06,0x06,0x06]

v_subrev_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0xff,0x06,0x06,0x06]

v_subrev_f16_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x86,0x06]

v_subrev_f16_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x65,0x06,0x86,0x06]

v_subrev_f16_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x6a,0x06,0x86,0x06]

v_subrev_f16_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x6b,0x06,0x86,0x06]

v_subrev_f16_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x7c,0x06,0x86,0x06]

v_subrev_f16_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x7e,0x06,0x86,0x06]

v_subrev_f16_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x7f,0x06,0x86,0x06]

v_subrev_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x68,0x01,0x06,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x26,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x00,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x01,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x02,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x03,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x04,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x05,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x0e,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x16,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x16,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x00,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x01,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x02,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x03,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x04,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x05,0x06]

v_subrev_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x16,0x06]

v_subrev_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x26,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x06,0x00]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x06,0x01]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x06,0x02]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x06,0x03]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x06,0x04]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x06,0x05]

v_subrev_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x06,0x16]

v_subrev_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x68,0x01,0x06,0x06,0x26]

v_subrev_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0xe4,0x00,0x00]

v_subrev_f16_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x69,0x01,0xe4,0x00,0x00]

v_subrev_f16_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0xff,0xe4,0x00,0x00]

v_subrev_f16_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x68,0x01,0xe4,0x00,0x00]

v_subrev_f16_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x1b,0x00,0x00]

v_subrev_f16_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x40,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x41,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x01,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x0f,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x11,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x1f,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x21,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x2f,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0xe4,0x00,0x10]

v_subrev_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0xe4,0x00,0x30]

v_subrev_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0xe4,0x00,0xf0]

v_subrev_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0xe4,0x00,0x01]

v_subrev_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0xe4,0x00,0x03]

v_subrev_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0xe4,0x00,0x0f]

v_subrev_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0xe4,0x08,0x00]

v_subrev_f16_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0xe4,0x10,0x00]

v_subrev_f16_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0xe4,0x20,0x00]

v_subrev_f16_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x51,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x5f,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x61,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x68,0x01,0x6f,0x01,0x00]

v_mul_f16_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x6a]

v_mul_f16_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x6b]

v_mul_f16_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x6a]

v_mul_f16_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x6a]

v_mul_f16_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x6a]

v_mul_f16_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x6a]

v_mul_f16_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x6a]

v_mul_f16_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x6a]

v_mul_f16_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x6a]

v_mul_f16_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x6a]

v_mul_f16_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x6a]

v_mul_f16_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x6a]

v_mul_f16_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x6a]

v_mul_f16_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x6a]

v_mul_f16_e32 v5, 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x6a,0x0b,0xfe,0x00,0x00]

v_mul_f16_e32 v5, 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x6a,0x56,0x34,0x00,0x00]

v_mul_f16_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x6a]

v_mul_f16_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0x05,0x02,0x00]

v_mul_f16_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x35,0xd5,0x01,0x05,0x02,0x00]

v_mul_f16_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0xff,0x05,0x02,0x00]

v_mul_f16_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0x04,0x02,0x00]

v_mul_f16_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x65,0x04,0x02,0x00]

v_mul_f16_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x6a,0x04,0x02,0x00]

v_mul_f16_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x6b,0x04,0x02,0x00]

v_mul_f16_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x7c,0x04,0x02,0x00]

v_mul_f16_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x7e,0x04,0x02,0x00]

v_mul_f16_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x7f,0x04,0x02,0x00]

v_mul_f16_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x80,0x04,0x02,0x00]

v_mul_f16_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0xc1,0x04,0x02,0x00]

v_mul_f16_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0xf0,0x04,0x02,0x00]

v_mul_f16_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0xf7,0x04,0x02,0x00]

v_mul_f16_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0xff,0x03,0x00]

v_mul_f16_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0x05,0x00,0x00]

v_mul_f16_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0xcb,0x00,0x00]

v_mul_f16_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0xd5,0x00,0x00]

v_mul_f16_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0xd7,0x00,0x00]

v_mul_f16_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0xf9,0x00,0x00]

v_mul_f16_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0xfd,0x00,0x00]

v_mul_f16_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0xff,0x00,0x00]

v_mul_f16_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0x01,0x01,0x00]

v_mul_f16_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0x83,0x01,0x00]

v_mul_f16_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0xe1,0x01,0x00]

v_mul_f16_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0xef,0x01,0x00]

v_mul_f16_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0x05,0x02,0x20]

v_mul_f16_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0x05,0x02,0x40]

v_mul_f16_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x35,0xd5,0x01,0x05,0x02,0x60]

v_mul_f16_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x35,0xd5,0x01,0x05,0x02,0x00]

v_mul_f16_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x35,0xd5,0x01,0x05,0x02,0x00]

v_mul_f16_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x35,0xd5,0x01,0x05,0x02,0x00]

v_mul_f16_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x35,0xd5,0x01,0x05,0x02,0x00]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x06,0x06]

v_mul_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x6b,0x01,0x06,0x06,0x06]

v_mul_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0xff,0x06,0x06,0x06]

v_mul_f16_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x86,0x06]

v_mul_f16_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x65,0x06,0x86,0x06]

v_mul_f16_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x6a,0x06,0x86,0x06]

v_mul_f16_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x6b,0x06,0x86,0x06]

v_mul_f16_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x7c,0x06,0x86,0x06]

v_mul_f16_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x7e,0x06,0x86,0x06]

v_mul_f16_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x7f,0x06,0x86,0x06]

v_mul_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x6a,0x01,0x06,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x26,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x00,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x01,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x02,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x03,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x04,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x05,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x0e,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x16,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x16,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x00,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x01,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x02,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x03,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x04,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x05,0x06]

v_mul_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x16,0x06]

v_mul_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x26,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x06,0x00]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x06,0x01]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x06,0x02]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x06,0x03]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x06,0x04]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x06,0x05]

v_mul_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x06,0x16]

v_mul_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x6a,0x01,0x06,0x06,0x26]

v_mul_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0xe4,0x00,0x00]

v_mul_f16_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x6b,0x01,0xe4,0x00,0x00]

v_mul_f16_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0xff,0xe4,0x00,0x00]

v_mul_f16_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x6a,0x01,0xe4,0x00,0x00]

v_mul_f16_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x1b,0x00,0x00]

v_mul_f16_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x40,0x01,0x00]

v_mul_f16_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x41,0x01,0x00]

v_mul_f16_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x01,0x01,0x00]

v_mul_f16_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x0f,0x01,0x00]

v_mul_f16_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x11,0x01,0x00]

v_mul_f16_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x1f,0x01,0x00]

v_mul_f16_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x21,0x01,0x00]

v_mul_f16_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x2f,0x01,0x00]

v_mul_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0xe4,0x00,0x10]

v_mul_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0xe4,0x00,0x30]

v_mul_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0xe4,0x00,0xf0]

v_mul_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0xe4,0x00,0x01]

v_mul_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0xe4,0x00,0x03]

v_mul_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0xe4,0x00,0x0f]

v_mul_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0xe4,0x08,0x00]

v_mul_f16_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0xe4,0x10,0x00]

v_mul_f16_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0xe4,0x20,0x00]

v_mul_f16_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x51,0x01,0x00]

v_mul_f16_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x5f,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x61,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x6a,0x01,0x6f,0x01,0x00]

v_fmac_f16_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x6c]

v_fmac_f16_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x6d]

v_fmac_f16_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x6c]

v_fmac_f16_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x6c]

v_fmac_f16_e32 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x6c]

v_fmac_f16_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x6c]

v_fmac_f16_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x6c]

v_fmac_f16_e32 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x6c]

v_fmac_f16_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x6c]

v_fmac_f16_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x6c]

v_fmac_f16_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x6c]

v_fmac_f16_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x6c]

v_fmac_f16_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x6c]

v_fmac_f16_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x6c]

v_fmac_f16_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x6c]

v_fmac_f16 v5, 0x1234, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x6c,0x34,0x12,0x00,0x00]

v_fmac_f16_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x6c]

v_fmac_f16_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f16_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x36,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f16_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0xff,0x05,0x02,0x00]

v_fmac_f16_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0x04,0x02,0x00]

v_fmac_f16_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x65,0x04,0x02,0x00]

v_fmac_f16_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x6a,0x04,0x02,0x00]

v_fmac_f16_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x6b,0x04,0x02,0x00]

v_fmac_f16_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x7c,0x04,0x02,0x00]

v_fmac_f16_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x7e,0x04,0x02,0x00]

v_fmac_f16_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x7f,0x04,0x02,0x00]

v_fmac_f16_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x80,0x04,0x02,0x00]

v_fmac_f16_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0xc1,0x04,0x02,0x00]

v_fmac_f16_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0xf0,0x04,0x02,0x00]

v_fmac_f16_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0xf7,0x04,0x02,0x00]

v_fmac_f16_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0xff,0x03,0x00]

v_fmac_f16_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0x05,0x00,0x00]

v_fmac_f16_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0xcb,0x00,0x00]

v_fmac_f16_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0xd5,0x00,0x00]

v_fmac_f16_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0xd7,0x00,0x00]

v_fmac_f16_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0xf9,0x00,0x00]

v_fmac_f16_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0xfd,0x00,0x00]

v_fmac_f16_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0xff,0x00,0x00]

v_fmac_f16_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0x01,0x01,0x00]

v_fmac_f16_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0x83,0x01,0x00]

v_fmac_f16_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0xe1,0x01,0x00]

v_fmac_f16_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0xef,0x01,0x00]

v_fmac_f16_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0x05,0x02,0x20]

v_fmac_f16_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0x05,0x02,0x40]

v_fmac_f16_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0x05,0x02,0x60]

v_fmac_f16_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x36,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f16_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x36,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f16_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x36,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f16_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x36,0xd5,0x01,0x05,0x02,0x00]

v_fmac_f16_e64 v5, v1, v2 mul:2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0x05,0x02,0x08]

v_fmac_f16_e64 v5, v1, v2 mul:4
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0x05,0x02,0x10]

v_fmac_f16_e64 v5, v1, v2 div:2
// GFX10: encoding: [0x05,0x00,0x36,0xd5,0x01,0x05,0x02,0x18]

v_fmamk_f16 v5, v1, 0x1121, v3
// GFX10: encoding: [0x01,0x07,0x0a,0x6e,0x21,0x11,0x00,0x00]

v_fmamk_f16 v255, v1, 0x1121, v3
// GFX10: encoding: [0x01,0x07,0xfe,0x6f,0x21,0x11,0x00,0x00]

v_fmamk_f16 v255, 0x1121, 0x1121, v3
// GFX10: encoding: [0xff,0x06,0xfe,0x6f,0x21,0x11,0x00,0x00]

v_fmamk_f16 v5, v255, 0x1121, v3
// GFX10: encoding: [0xff,0x07,0x0a,0x6e,0x21,0x11,0x00,0x00]

v_fmamk_f16 v5, 0, 0x1121, v3
// GFX10: encoding: [0x80,0x06,0x0a,0x6e,0x21,0x11,0x00,0x00]

v_fmamk_f16 v5, -1, 0x1121, v3
// GFX10: encoding: [0xc1,0x06,0x0a,0x6e,0x21,0x11,0x00,0x00]

v_fmamk_f16 v5, 0.5, 0x1121, v3
// GFX10: encoding: [0xf0,0x06,0x0a,0x6e,0x21,0x11,0x00,0x00]

v_fmamk_f16 v5, -4.0, 0x1121, v3
// GFX10: encoding: [0xf7,0x06,0x0a,0x6e,0x21,0x11,0x00,0x00]

v_fmamk_f16 v5, v1, 0xa1b1, v3
// GFX10: encoding: [0x01,0x07,0x0a,0x6e,0xb1,0xa1,0x00,0x00]

v_fmamk_f16 v5, v1, 0x1121, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x6e,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, v1, v2, 0x1121
// GFX10: encoding: [0x01,0x05,0x0a,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v255, v1, v2, 0x1121
// GFX10: encoding: [0x01,0x05,0xfe,0x71,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, v255, v2, 0x1121
// GFX10: encoding: [0xff,0x05,0x0a,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, 0, v2, 0x1121
// GFX10: encoding: [0x80,0x04,0x0a,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, -1, v2, 0x1121
// GFX10: encoding: [0xc1,0x04,0x0a,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, 0.5, v2, 0x1121
// GFX10: encoding: [0xf0,0x04,0x0a,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, -4.0, v2, 0x1121
// GFX10: encoding: [0xf7,0x04,0x0a,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, v1, v255, 0x1121
// GFX10: encoding: [0x01,0xff,0x0b,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, 0x1121, v255, 0x1121
// GFX10: encoding: [0xff,0xfe,0x0b,0x70,0x21,0x11,0x00,0x00]

v_fmaak_f16 v5, v1, v2, 0xa1b1
// GFX10: encoding: [0x01,0x05,0x0a,0x70,0xb1,0xa1,0x00,0x00]

v_max_f16_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x72]

v_max_f16_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x73]

v_max_f16_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x72]

v_max_f16_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x72]

v_max_f16_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x72]

v_max_f16_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x72]

v_max_f16_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x72]

v_max_f16_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x72]

v_max_f16_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x72]

v_max_f16_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x72]

v_max_f16_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x72]

v_max_f16_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x72]

v_max_f16_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x72]

v_max_f16_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x72]

v_max_f16_e32 v5, 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x72,0x0b,0xfe,0x00,0x00]

v_max_f16_e32 v5, 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x72,0x56,0x34,0x00,0x00]

v_max_f16_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x72]

v_max_f16_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0x05,0x02,0x00]

v_max_f16_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x39,0xd5,0x01,0x05,0x02,0x00]

v_max_f16_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0xff,0x05,0x02,0x00]

v_max_f16_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0x04,0x02,0x00]

v_max_f16_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x65,0x04,0x02,0x00]

v_max_f16_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x6a,0x04,0x02,0x00]

v_max_f16_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x6b,0x04,0x02,0x00]

v_max_f16_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x7c,0x04,0x02,0x00]

v_max_f16_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x7e,0x04,0x02,0x00]

v_max_f16_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x7f,0x04,0x02,0x00]

v_max_f16_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x80,0x04,0x02,0x00]

v_max_f16_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0xc1,0x04,0x02,0x00]

v_max_f16_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0xf0,0x04,0x02,0x00]

v_max_f16_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0xf7,0x04,0x02,0x00]

v_max_f16_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0xff,0x03,0x00]

v_max_f16_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0x05,0x00,0x00]

v_max_f16_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0xcb,0x00,0x00]

v_max_f16_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0xd5,0x00,0x00]

v_max_f16_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0xd7,0x00,0x00]

v_max_f16_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0xf9,0x00,0x00]

v_max_f16_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0xfd,0x00,0x00]

v_max_f16_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0xff,0x00,0x00]

v_max_f16_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0x01,0x01,0x00]

v_max_f16_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0x83,0x01,0x00]

v_max_f16_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0xe1,0x01,0x00]

v_max_f16_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0xef,0x01,0x00]

v_max_f16_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0x05,0x02,0x20]

v_max_f16_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0x05,0x02,0x40]

v_max_f16_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x39,0xd5,0x01,0x05,0x02,0x60]

v_max_f16_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x39,0xd5,0x01,0x05,0x02,0x00]

v_max_f16_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x39,0xd5,0x01,0x05,0x02,0x00]

v_max_f16_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x39,0xd5,0x01,0x05,0x02,0x00]

v_max_f16_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x39,0xd5,0x01,0x05,0x02,0x00]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x06,0x06]

v_max_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x73,0x01,0x06,0x06,0x06]

v_max_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0xff,0x06,0x06,0x06]

v_max_f16_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x86,0x06]

v_max_f16_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x65,0x06,0x86,0x06]

v_max_f16_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x6a,0x06,0x86,0x06]

v_max_f16_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x6b,0x06,0x86,0x06]

v_max_f16_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x7c,0x06,0x86,0x06]

v_max_f16_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x7e,0x06,0x86,0x06]

v_max_f16_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x7f,0x06,0x86,0x06]

v_max_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x72,0x01,0x06,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x26,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x00,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x01,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x02,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x03,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x04,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x05,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x0e,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x16,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x16,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x00,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x01,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x02,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x03,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x04,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x05,0x06]

v_max_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x16,0x06]

v_max_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x26,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x06,0x00]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x06,0x01]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x06,0x02]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x06,0x03]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x06,0x04]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x06,0x05]

v_max_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x06,0x16]

v_max_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x72,0x01,0x06,0x06,0x26]

v_max_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0xe4,0x00,0x00]

v_max_f16_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x73,0x01,0xe4,0x00,0x00]

v_max_f16_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0xff,0xe4,0x00,0x00]

v_max_f16_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x72,0x01,0xe4,0x00,0x00]

v_max_f16_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x1b,0x00,0x00]

v_max_f16_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x40,0x01,0x00]

v_max_f16_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x41,0x01,0x00]

v_max_f16_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x01,0x01,0x00]

v_max_f16_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x0f,0x01,0x00]

v_max_f16_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x11,0x01,0x00]

v_max_f16_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x1f,0x01,0x00]

v_max_f16_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x21,0x01,0x00]

v_max_f16_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x2f,0x01,0x00]

v_max_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0xe4,0x00,0x10]

v_max_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0xe4,0x00,0x30]

v_max_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0xe4,0x00,0xf0]

v_max_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0xe4,0x00,0x01]

v_max_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0xe4,0x00,0x03]

v_max_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0xe4,0x00,0x0f]

v_max_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0xe4,0x08,0x00]

v_max_f16_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0xe4,0x10,0x00]

v_max_f16_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0xe4,0x20,0x00]

v_max_f16_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x51,0x01,0x00]

v_max_f16_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x5f,0x01,0x00]

v_max_f16_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x61,0x01,0x00]

v_max_f16_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x72,0x01,0x6f,0x01,0x00]

v_min_f16_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x74]

v_min_f16_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x75]

v_min_f16_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x74]

v_min_f16_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x74]

v_min_f16_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x74]

v_min_f16_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x74]

v_min_f16_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x74]

v_min_f16_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x74]

v_min_f16_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x74]

v_min_f16_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x74]

v_min_f16_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x74]

v_min_f16_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x74]

v_min_f16_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x74]

v_min_f16_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x74]

v_min_f16_e32 v5, 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x74,0x0b,0xfe,0x00,0x00]

v_min_f16_e32 v5, 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x74,0x56,0x34,0x00,0x00]

v_min_f16_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x74]

v_min_f16_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0x05,0x02,0x00]

v_min_f16_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x3a,0xd5,0x01,0x05,0x02,0x00]

v_min_f16_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0xff,0x05,0x02,0x00]

v_min_f16_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0x04,0x02,0x00]

v_min_f16_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x65,0x04,0x02,0x00]

v_min_f16_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x6a,0x04,0x02,0x00]

v_min_f16_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x6b,0x04,0x02,0x00]

v_min_f16_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x7c,0x04,0x02,0x00]

v_min_f16_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x7e,0x04,0x02,0x00]

v_min_f16_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x7f,0x04,0x02,0x00]

v_min_f16_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x80,0x04,0x02,0x00]

v_min_f16_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0xc1,0x04,0x02,0x00]

v_min_f16_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0xf0,0x04,0x02,0x00]

v_min_f16_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0xf7,0x04,0x02,0x00]

v_min_f16_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0xff,0x03,0x00]

v_min_f16_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0x05,0x00,0x00]

v_min_f16_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0xcb,0x00,0x00]

v_min_f16_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0xd5,0x00,0x00]

v_min_f16_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0xd7,0x00,0x00]

v_min_f16_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0xf9,0x00,0x00]

v_min_f16_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0xfd,0x00,0x00]

v_min_f16_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0xff,0x00,0x00]

v_min_f16_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0x01,0x01,0x00]

v_min_f16_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0x83,0x01,0x00]

v_min_f16_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0xe1,0x01,0x00]

v_min_f16_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0xef,0x01,0x00]

v_min_f16_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0x05,0x02,0x20]

v_min_f16_e64 v5, v1, -v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0x05,0x02,0x40]

v_min_f16_e64 v5, -v1, -v2
// GFX10: encoding: [0x05,0x00,0x3a,0xd5,0x01,0x05,0x02,0x60]

v_min_f16_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x3a,0xd5,0x01,0x05,0x02,0x00]

v_min_f16_e64 v5, v1, |v2|
// GFX10: encoding: [0x05,0x02,0x3a,0xd5,0x01,0x05,0x02,0x00]

v_min_f16_e64 v5, |v1|, |v2|
// GFX10: encoding: [0x05,0x03,0x3a,0xd5,0x01,0x05,0x02,0x00]

v_min_f16_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x3a,0xd5,0x01,0x05,0x02,0x00]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x06,0x06]

v_min_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x75,0x01,0x06,0x06,0x06]

v_min_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0xff,0x06,0x06,0x06]

v_min_f16_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x86,0x06]

v_min_f16_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x65,0x06,0x86,0x06]

v_min_f16_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x6a,0x06,0x86,0x06]

v_min_f16_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x6b,0x06,0x86,0x06]

v_min_f16_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x7c,0x06,0x86,0x06]

v_min_f16_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x7e,0x06,0x86,0x06]

v_min_f16_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x7f,0x06,0x86,0x06]

v_min_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x74,0x01,0x06,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x26,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x00,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x01,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x02,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x03,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x04,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x05,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x0e,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x16,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x16,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x00,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x01,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x02,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x03,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x04,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x05,0x06]

v_min_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x16,0x06]

v_min_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x26,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x06,0x00]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x06,0x01]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x06,0x02]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x06,0x03]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x06,0x04]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x06,0x05]

v_min_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x06,0x16]

v_min_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x74,0x01,0x06,0x06,0x26]

v_min_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0xe4,0x00,0x00]

v_min_f16_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x75,0x01,0xe4,0x00,0x00]

v_min_f16_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0xff,0xe4,0x00,0x00]

v_min_f16_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x74,0x01,0xe4,0x00,0x00]

v_min_f16_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x1b,0x00,0x00]

v_min_f16_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x40,0x01,0x00]

v_min_f16_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x41,0x01,0x00]

v_min_f16_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x01,0x01,0x00]

v_min_f16_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x0f,0x01,0x00]

v_min_f16_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x11,0x01,0x00]

v_min_f16_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x1f,0x01,0x00]

v_min_f16_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x21,0x01,0x00]

v_min_f16_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x2f,0x01,0x00]

v_min_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0xe4,0x00,0x10]

v_min_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0xe4,0x00,0x30]

v_min_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0xe4,0x00,0xf0]

v_min_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0xe4,0x00,0x01]

v_min_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0xe4,0x00,0x03]

v_min_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0xe4,0x00,0x0f]

v_min_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0xe4,0x08,0x00]

v_min_f16_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0xe4,0x10,0x00]

v_min_f16_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0xe4,0x20,0x00]

v_min_f16_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x51,0x01,0x00]

v_min_f16_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x5f,0x01,0x00]

v_min_f16_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x61,0x01,0x00]

v_min_f16_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x74,0x01,0x6f,0x01,0x00]

v_ldexp_f16_e32 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x76]

v_ldexp_f16_e32 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x77]

v_ldexp_f16_e32 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x76]

v_ldexp_f16_e32 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x76]

v_ldexp_f16_e32 v5, s101, v2
// GFX10: encoding: [0x65,0x04,0x0a,0x76]

v_ldexp_f16_e32 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x76]

v_ldexp_f16_e32 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x76]

v_ldexp_f16_e32 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x76]

v_ldexp_f16_e32 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x76]

v_ldexp_f16_e32 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x76]

v_ldexp_f16_e32 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x76]

v_ldexp_f16_e32 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x76]

v_ldexp_f16_e32 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x76]

v_ldexp_f16_e32 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x76]

v_ldexp_f16_e32 v5, 0xfe0b, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x76,0x0b,0xfe,0x00,0x00]

v_ldexp_f16_e32 v5, 0x3456, v2
// GFX10: encoding: [0xff,0x04,0x0a,0x76,0x56,0x34,0x00,0x00]

v_ldexp_f16_e32 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x76]

v_ldexp_f16_e64 v5, v1, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0x05,0x02,0x00]

v_ldexp_f16_e64 v255, v1, v2
// GFX10: encoding: [0xff,0x00,0x3b,0xd5,0x01,0x05,0x02,0x00]

v_ldexp_f16_e64 v5, v255, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0xff,0x05,0x02,0x00]

v_ldexp_f16_e64 v5, s1, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, s101, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x65,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, vcc_lo, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x6a,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, vcc_hi, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x6b,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, m0, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x7c,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, exec_lo, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x7e,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, exec_hi, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x7f,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, 0, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x80,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, -1, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0xc1,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, 0.5, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0xf0,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, -4.0, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0xf7,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, v1, v255
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0xff,0x03,0x00]

v_ldexp_f16_e64 v5, v1, s2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0x05,0x00,0x00]

v_ldexp_f16_e64 v5, v1, s101
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0xcb,0x00,0x00]

v_ldexp_f16_e64 v5, v1, vcc_lo
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0xd5,0x00,0x00]

v_ldexp_f16_e64 v5, v1, vcc_hi
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0xd7,0x00,0x00]

v_ldexp_f16_e64 v5, v1, m0
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0xf9,0x00,0x00]

v_ldexp_f16_e64 v5, v1, exec_lo
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0xfd,0x00,0x00]

v_ldexp_f16_e64 v5, v1, exec_hi
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0xff,0x00,0x00]

v_ldexp_f16_e64 v5, v1, 0
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0x01,0x01,0x00]

v_ldexp_f16_e64 v5, v1, -1
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0x83,0x01,0x00]

v_ldexp_f16_e64 v5, v1, 0.5
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0xe1,0x01,0x00]

v_ldexp_f16_e64 v5, v1, -4.0
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0xef,0x01,0x00]

v_ldexp_f16_e64 v5, -v1, v2
// GFX10: encoding: [0x05,0x00,0x3b,0xd5,0x01,0x05,0x02,0x20]

v_ldexp_f16_e64 v5, |v1|, v2
// GFX10: encoding: [0x05,0x01,0x3b,0xd5,0x01,0x05,0x02,0x00]

v_ldexp_f16_e64 v5, v1, v2 clamp
// GFX10: encoding: [0x05,0x80,0x3b,0xd5,0x01,0x05,0x02,0x00]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x06,0x06]

v_ldexp_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0xfe,0x77,0x01,0x06,0x06,0x06]

v_ldexp_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0xff,0x06,0x06,0x06]

v_ldexp_f16_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x86,0x06]

v_ldexp_f16_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x65,0x06,0x86,0x06]

v_ldexp_f16_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x6a,0x06,0x86,0x06]

v_ldexp_f16_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x6b,0x06,0x86,0x06]

v_ldexp_f16_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x7c,0x06,0x86,0x06]

v_ldexp_f16_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x7e,0x06,0x86,0x06]

v_ldexp_f16_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x7f,0x06,0x86,0x06]

v_ldexp_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0xfe,0x0b,0x76,0x01,0x06,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x26,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x00,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x01,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x02,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x03,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x04,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x05,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x0e,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x16,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x16,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x00,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x01,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x02,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x03,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x04,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x05,0x06]

v_ldexp_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x16,0x06]

v_ldexp_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x26,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x06,0x00]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x06,0x01]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x06,0x02]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x06,0x03]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x06,0x04]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// GFX10: encoding: [0xf9,0x04,0x0a,0x76,0x01,0x06,0x06,0x05]

v_ldexp_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x00]

v_ldexp_f16_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0xfe,0x77,0x01,0xe4,0x00,0x00]

v_ldexp_f16_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0xff,0xe4,0x00,0x00]

v_ldexp_f16_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0xfe,0x0b,0x76,0x01,0xe4,0x00,0x00]

v_ldexp_f16_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x1b,0x00,0x00]

v_ldexp_f16_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x40,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x41,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x01,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x0f,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x11,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x1f,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x21,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x2f,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x10]

v_ldexp_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x30]

v_ldexp_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0xf0]

v_ldexp_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x01]

v_ldexp_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x03]

v_ldexp_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x0f]

v_ldexp_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x08,0x00]

v_ldexp_f16_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x10,0x00]

v_ldexp_f16_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x20,0x00]

v_ldexp_f16_dpp v5, v1, v2  row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x51,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2  row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x5f,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x61,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x6f,0x01,0x00]

v_pk_fmac_f16 v5, v1, v2
// GFX10: encoding: [0x01,0x05,0x0a,0x78]

v_pk_fmac_f16 v255, v1, v2
// GFX10: encoding: [0x01,0x05,0xfe,0x79]

v_pk_fmac_f16 v5, v255, v2
// GFX10: encoding: [0xff,0x05,0x0a,0x78]

v_pk_fmac_f16 v5, s1, v2
// GFX10: encoding: [0x01,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, s103, v2
// GFX10: encoding: [0x67,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, vcc_lo, v2
// GFX10: encoding: [0x6a,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, vcc_hi, v2
// GFX10: encoding: [0x6b,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, ttmp11, v2
// GFX10: encoding: [0x77,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, m0, v2
// GFX10: encoding: [0x7c,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, exec_lo, v2
// GFX10: encoding: [0x7e,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, exec_hi, v2
// GFX10: encoding: [0x7f,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, 0, v2
// GFX10: encoding: [0x80,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, -1, v2
// GFX10: encoding: [0xc1,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, 0.5, v2
// GFX10: encoding: [0xf0,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, -4.0, v2
// GFX10: encoding: [0xf7,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, v1, v255
// GFX10: encoding: [0x01,0xff,0x0b,0x78]
