/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/upload/v1beta1"
)

// FakeUploadTokenRequests implements UploadTokenRequestInterface
type FakeUploadTokenRequests struct {
	Fake *FakeUploadV1beta1
	ns   string
}

var uploadtokenrequestsResource = v1beta1.SchemeGroupVersion.WithResource("uploadtokenrequests")

var uploadtokenrequestsKind = v1beta1.SchemeGroupVersion.WithKind("UploadTokenRequest")

// Get takes name of the uploadTokenRequest, and returns the corresponding uploadTokenRequest object, and an error if there is any.
func (c *FakeUploadTokenRequests) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.UploadTokenRequest, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(uploadtokenrequestsResource, c.ns, name), &v1beta1.UploadTokenRequest{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.UploadTokenRequest), err
}

// List takes label and field selectors, and returns the list of UploadTokenRequests that match those selectors.
func (c *FakeUploadTokenRequests) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.UploadTokenRequestList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(uploadtokenrequestsResource, uploadtokenrequestsKind, c.ns, opts), &v1beta1.UploadTokenRequestList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.UploadTokenRequestList{ListMeta: obj.(*v1beta1.UploadTokenRequestList).ListMeta}
	for _, item := range obj.(*v1beta1.UploadTokenRequestList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested uploadTokenRequests.
func (c *FakeUploadTokenRequests) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(uploadtokenrequestsResource, c.ns, opts))

}

// Create takes the representation of a uploadTokenRequest and creates it.  Returns the server's representation of the uploadTokenRequest, and an error, if there is any.
func (c *FakeUploadTokenRequests) Create(ctx context.Context, uploadTokenRequest *v1beta1.UploadTokenRequest, opts v1.CreateOptions) (result *v1beta1.UploadTokenRequest, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(uploadtokenrequestsResource, c.ns, uploadTokenRequest), &v1beta1.UploadTokenRequest{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.UploadTokenRequest), err
}

// Update takes the representation of a uploadTokenRequest and updates it. Returns the server's representation of the uploadTokenRequest, and an error, if there is any.
func (c *FakeUploadTokenRequests) Update(ctx context.Context, uploadTokenRequest *v1beta1.UploadTokenRequest, opts v1.UpdateOptions) (result *v1beta1.UploadTokenRequest, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(uploadtokenrequestsResource, c.ns, uploadTokenRequest), &v1beta1.UploadTokenRequest{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.UploadTokenRequest), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeUploadTokenRequests) UpdateStatus(ctx context.Context, uploadTokenRequest *v1beta1.UploadTokenRequest, opts v1.UpdateOptions) (*v1beta1.UploadTokenRequest, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(uploadtokenrequestsResource, "status", c.ns, uploadTokenRequest), &v1beta1.UploadTokenRequest{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.UploadTokenRequest), err
}

// Delete takes name of the uploadTokenRequest and deletes it. Returns an error if one occurs.
func (c *FakeUploadTokenRequests) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(uploadtokenrequestsResource, c.ns, name, opts), &v1beta1.UploadTokenRequest{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeUploadTokenRequests) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(uploadtokenrequestsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.UploadTokenRequestList{})
	return err
}

// Patch applies the patch and returns the patched uploadTokenRequest.
func (c *FakeUploadTokenRequests) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.UploadTokenRequest, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(uploadtokenrequestsResource, c.ns, name, pt, data, subresources...), &v1beta1.UploadTokenRequest{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.UploadTokenRequest), err
}
