; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=fiji -verify-machineinstrs < %s | FileCheck --check-prefix=GFX8 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=hawaii -verify-machineinstrs < %s | FileCheck --check-prefix=GFX7 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX10 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX11 %s

define amdgpu_ps void @insertelement_s_v2i8_s_s(ptr addrspace(4) inreg %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v2i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    global_load_ushort v0, v0, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_load_ushort v0, off, s[0:3], 0
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v2i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s5, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, s5, 0
; GFX10-NEXT:    global_load_ushort v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v0, s4, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s4, s0
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    v_and_b32_sdwa v3, v1, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v2i8_s_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, s5, 1
; GFX11-NEXT:    global_load_u16 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v1, s4, s0
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, s5, 0
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, s4, s0
; GFX11-NEXT:    v_lshlrev_b16 v3, 8, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX11-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i8_s_s(ptr addrspace(1) %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v2i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_ushort v0, v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v2i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_ushort v0, v[0:1], off
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s3, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, s3, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v0, s2, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s2, s0
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    v_and_b32_sdwa v3, v1, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v2i8_s_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_u16 v0, v[0:1], off
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, s3, 1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v1, s2, s0
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, s3, 0
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, s2, s0
; GFX11-NEXT:    v_lshlrev_b16 v3, 8, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX11-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i8>, ptr addrspace(1 ) %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v2i8_v_s(ptr addrspace(4) inreg %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v2i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    flat_load_ushort v1, v[1:2]
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 0
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v2i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s4, 1
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s4, 0
; GFX10-NEXT:    v_and_b32_sdwa v2, v2, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v2i8_v_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s4, 1
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    global_load_u16 v1, v1, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s4, 0
; GFX11-NEXT:    v_dual_cndmask_b32 v0, v1, v0 :: v_dual_and_b32 v1, 0xff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX11-NEXT:    v_lshlrev_b16 v3, 8, v1
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX11-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v2i8_s_v(ptr addrspace(4) inreg %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v2i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 8, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v1, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    flat_load_ushort v1, v[1:2]
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 8, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v1, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 8, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v2i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, s4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_and_b32_sdwa v2, v2, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v1, s4, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v2i8_s_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    global_load_u16 v1, v1, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v2, s4, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v1, s4, vcc_lo
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX11-NEXT:    v_lshlrev_b16 v3, 8, v1
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX11-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v2i8_v_v(ptr addrspace(4) inreg %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v2i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_ushort v2, v2, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 8, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v3, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_load_ushort v2, v[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 8, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v3, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_load_ushort v2, off, s[0:3], 0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 8, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v2i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    global_load_ushort v2, v2, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 8, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_and_b32_sdwa v3, v3, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v2i8_v_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    global_load_u16 v2, v2, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 8, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v0, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_and_b32 v1, 0xff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshlrev_b16 v3, 8, v1
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX11-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i8_s_v(ptr addrspace(1) %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v2i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_ushort v0, v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v2i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_ushort v0, v[0:1], off
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v2
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_and_b32_sdwa v3, v1, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v0, s2, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v2i8_s_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_u16 v0, v[0:1], off
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v1, s2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, s2, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshlrev_b16 v3, 8, v1
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX11-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i8>, ptr addrspace(1) %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i8_v_s(ptr addrspace(1) %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v2i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_ushort v0, v[0:1], off
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v0, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v0, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v2i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_ushort v0, v[0:1], off
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 1
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 0
; GFX10-NEXT:    v_and_b32_sdwa v3, v1, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v0, v2, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v2i8_v_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_u16 v0, v[0:1], off
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-NEXT:    v_lshlrev_b16 v3, 8, v1
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX11-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i8>, ptr addrspace(1) %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i8_v_v(ptr addrspace(1) %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v2i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_ushort v0, v[0:1], off
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v0, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[0:3], 0 addr64
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v2i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_ushort v0, v[0:1], off
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v3
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_and_b32_sdwa v3, v1, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v0, v2, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v2i8_v_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_u16 v0, v[0:1], off
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v3
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-NEXT:    v_lshlrev_b16 v3, 8, v1
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX11-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i8>, ptr addrspace(1) %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, ptr addrspace(1) null
  ret void
}

; FIXME: 3 element load/store legalization
; define amdgpu_ps void @insertelement_s_v3i8_s_s(ptr addrspace(4) inreg %ptr, i8 inreg %val, i32 inreg %idx) {
;   %vec = load <3 x i8>, ptr addrspace(4) %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, ptr addrspace(1) null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i8_s_s(ptr addrspace(1) %ptr, i8 inreg %val, i32 inreg %idx) {
;   %vec = load <3 x i8>, ptr addrspace(1 ) %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, ptr addrspace(1) null
;   ret void
; }

; define amdgpu_ps void @insertelement_s_v3i8_v_s(ptr addrspace(4) inreg %ptr, i8 %val, i32 inreg %idx) {
;   %vec = load <3 x i8>, ptr addrspace(4) %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, ptr addrspace(1) null
;   ret void
; }

; define amdgpu_ps void @insertelement_s_v3i8_s_v(ptr addrspace(4) inreg %ptr, i8 inreg %val, i32 %idx) {
;   %vec = load <3 x i8>, ptr addrspace(4) %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, ptr addrspace(1) null
;   ret void
; }

; define amdgpu_ps void @insertelement_s_v3i8_v_v(ptr addrspace(4) inreg %ptr, i8 %val, i32 %idx) {
;   %vec = load <3 x i8>, ptr addrspace(4) %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, ptr addrspace(1) null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i8_s_v(ptr addrspace(1) %ptr, i8 inreg %val, i32 %idx) {
;   %vec = load <3 x i8>, ptr addrspace(1) %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, ptr addrspace(1) null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i8_v_s(ptr addrspace(1) %ptr, i8 %val, i32 inreg %idx) {
;   %vec = load <3 x i8>, ptr addrspace(1) %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, ptr addrspace(1) null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i8_v_v(ptr addrspace(1) %ptr, i8 %val, i32 %idx) {
;   %vec = load <3 x i8>, ptr addrspace(1) %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, ptr addrspace(1) null
;   ret void
; }

define amdgpu_ps void @insertelement_v_v4i8_s_s(ptr addrspace(1) %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v4i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v2, v[0:1], off
; GFX9-NEXT:    s_and_b32 s0, s3, 3
; GFX9-NEXT:    s_lshl_b32 s0, s0, 3
; GFX9-NEXT:    s_and_b32 s1, s2, 0xff
; GFX9-NEXT:    s_lshl_b32 s1, s1, s0
; GFX9-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX9-NEXT:    s_not_b32 s0, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v2, v2, s0, v3
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_and_b32 s0, s3, 3
; GFX8-NEXT:    s_and_b32 s1, s2, 0xff
; GFX8-NEXT:    s_lshl_b32 s0, s0, 3
; GFX8-NEXT:    s_lshl_b32 s1, s1, s0
; GFX8-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX8-NEXT:    s_not_b32 s0, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, s0, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, s1, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_and_b32 s0, s3, 3
; GFX7-NEXT:    s_and_b32 s1, s2, 0xff
; GFX7-NEXT:    s_lshl_b32 s0, s0, 3
; GFX7-NEXT:    s_lshl_b32 s1, s1, s0
; GFX7-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX7-NEXT:    s_not_b32 s0, s0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_or_b32_e32 v0, s1, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v4i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v2, v[0:1], off
; GFX10-NEXT:    s_and_b32 s0, s3, 3
; GFX10-NEXT:    s_and_b32 s1, s2, 0xff
; GFX10-NEXT:    s_lshl_b32 s0, s0, 3
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_lshl_b32 s2, 0xff, s0
; GFX10-NEXT:    s_lshl_b32 s0, s1, s0
; GFX10-NEXT:    s_not_b32 s1, s2
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_and_or_b32 v2, v2, s1, s0
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v4i8_s_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_b32 v2, v[0:1], off
; GFX11-NEXT:    s_and_b32 s0, s3, 3
; GFX11-NEXT:    s_and_b32 s1, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s0, s0, 3
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_lshl_b32 s2, 0xff, s0
; GFX11-NEXT:    s_lshl_b32 s0, s1, s0
; GFX11-NEXT:    s_not_b32 s1, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_and_or_b32 v2, v2, s1, s0
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <4 x i8>, ptr addrspace(1 ) %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v4i8_v_s(ptr addrspace(4) inreg %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v4i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    s_and_b32 s1, s4, 3
; GFX9-NEXT:    s_lshl_b32 s1, s1, 3
; GFX9-NEXT:    s_lshl_b32 s2, 0xff, s1
; GFX9-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_andn2_b32 s0, s0, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_lshl_or_b32 v2, v2, s1, v3
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v4i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    s_and_b32 s1, s4, 3
; GFX8-NEXT:    s_lshl_b32 s1, s1, 3
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_andn2_b32 s0, s0, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, s0, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v4i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    s_and_b32 s1, s4, 3
; GFX7-NEXT:    s_lshl_b32 s1, s1, 3
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s1, v0
; GFX7-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_andn2_b32 s0, s0, s1
; GFX7-NEXT:    v_or_b32_e32 v0, s0, v0
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v4i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_and_b32 s1, s4, 3
; GFX10-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX10-NEXT:    s_lshl_b32 s1, s1, 3
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_lshl_b32 s2, 0xff, s1
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_andn2_b32 s0, s0, s2
; GFX10-NEXT:    v_lshl_or_b32 v2, v2, s1, s0
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v4i8_v_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-NEXT:    s_and_b32 s1, s4, 3
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX11-NEXT:    s_lshl_b32 s1, s1, 3
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_lshl_b32 s2, 0xff, s1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_not1_b32 s0, s0, s2
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_lshl_or_b32 v2, v2, s1, s0
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <4 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v4i8_s_v(ptr addrspace(4) inreg %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v4i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_movk_i32 s1, 0xff
; GFX9-NEXT:    s_and_b32 s2, s4, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v0, s2
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s1
; GFX9-NEXT:    v_not_b32_e32 v3, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v2, s0, v3, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v4i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_movk_i32 s1, 0xff
; GFX8-NEXT:    s_and_b32 s2, s4, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v0, s2
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s1
; GFX8-NEXT:    v_not_b32_e32 v0, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, s0, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v4i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    s_and_b32 s1, s4, 0xff
; GFX7-NEXT:    v_lshl_b32_e32 v1, s1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_not_b32_e32 v0, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v4i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX10-NEXT:    s_and_b32 s1, s4, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_lshlrev_b32_e64 v1, v0, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v0, s1
; GFX10-NEXT:    v_not_b32_e32 v3, v1
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_and_or_b32 v2, s0, v3, v2
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v4i8_s_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX11-NEXT:    s_and_b32 s1, s4, 0xff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-NEXT:    v_lshlrev_b32_e64 v1, v0, 0xff
; GFX11-NEXT:    v_lshlrev_b32_e64 v2, v0, s1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_not_b32_e32 v3, v1
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_and_or_b32 v2, s0, v3, v2
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <4 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v4i8_v_v(ptr addrspace(4) inreg %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v4i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX9-NEXT:    s_movk_i32 s1, 0xff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v1, s1
; GFX9-NEXT:    v_not_b32_e32 v3, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v2, s0, v3, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v4i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    s_movk_i32 s1, 0xff
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v1, s1
; GFX8-NEXT:    v_not_b32_e32 v0, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, s0, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v4i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_not_b32_e32 v1, v1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v4i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xff
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_not_b32_e32 v2, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_and_or_b32 v2, s0, v2, v3
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v4i8_v_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX11-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_lshlrev_b32 v3, v1, v0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    v_not_b32_e32 v2, v2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v2, s0, v2, v3
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <4 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v4i8_s_v(ptr addrspace(1) %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v4i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v3, v[0:1], off
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NEXT:    s_and_b32 s1, s2, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v0, s1
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s0
; GFX9-NEXT:    v_not_b32_e32 v4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v2, v3, v4, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v2
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    s_and_b32 s1, s2, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v1, s1
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX8-NEXT:    v_not_b32_e32 v1, v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v2
; GFX7-NEXT:    s_and_b32 s0, s2, 0xff
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshl_b32_e32 v2, s0, v1
; GFX7-NEXT:    v_lshl_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_not_b32_e32 v1, v1
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v4i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v3, v[0:1], off
; GFX10-NEXT:    v_and_b32_e32 v0, 3, v2
; GFX10-NEXT:    s_and_b32 s0, s2, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_lshlrev_b32_e64 v1, v0, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v0, s0
; GFX10-NEXT:    v_not_b32_e32 v4, v1
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_and_or_b32 v2, v3, v4, v2
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v4i8_s_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off
; GFX11-NEXT:    v_and_b32_e32 v0, 3, v2
; GFX11-NEXT:    s_and_b32 s0, s2, 0xff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-NEXT:    v_lshlrev_b32_e64 v1, v0, 0xff
; GFX11-NEXT:    v_lshlrev_b32_e64 v2, v0, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_not_b32_e32 v4, v1
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_and_or_b32 v2, v3, v4, v2
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <4 x i8>, ptr addrspace(1) %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v4i8_v_s(ptr addrspace(1) %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v4i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v3, v[0:1], off
; GFX9-NEXT:    s_and_b32 s0, s2, 3
; GFX9-NEXT:    s_lshl_b32 s0, s0, 3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX9-NEXT:    s_not_b32 s0, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v2, v3, s0, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_and_b32 s0, s2, 3
; GFX8-NEXT:    s_lshl_b32 s0, s0, 3
; GFX8-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX8-NEXT:    s_not_b32 s0, s0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, s0, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_and_b32 s0, s2, 3
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    s_lshl_b32 s0, s0, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, s0, v1
; GFX7-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX7-NEXT:    s_not_b32 s0, s0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v4i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v3, v[0:1], off
; GFX10-NEXT:    s_and_b32 s0, s2, 3
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_lshl_b32 s0, s0, 3
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX10-NEXT:    s_not_b32 s0, s0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_and_or_b32 v2, v3, s0, v2
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v4i8_v_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff, v2
; GFX11-NEXT:    s_and_b32 s0, s2, 3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_lshl_b32 s0, s0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, s0, v0
; GFX11-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_not_b32 s0, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_and_or_b32 v2, v3, s0, v2
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <4 x i8>, ptr addrspace(1) %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v4i8_v_v(ptr addrspace(1) %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v4i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v4, v[0:1], off
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s0
; GFX9-NEXT:    v_not_b32_e32 v3, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v3
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX8-NEXT:    v_not_b32_e32 v1, v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[0:3], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v1, v2
; GFX7-NEXT:    v_lshl_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_not_b32_e32 v1, v1
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v4i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v4, v[0:1], off
; GFX10-NEXT:    v_and_b32_e32 v0, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_lshlrev_b32_e64 v1, v0, 0xff
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_not_b32_e32 v3, v1
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_and_or_b32 v2, v4, v3, v2
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v4i8_v_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off
; GFX11-NEXT:    v_and_b32_e32 v0, 3, v3
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-NEXT:    v_lshlrev_b32_e64 v2, v0, 0xff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_lshlrev_b32 v3, v0, v1
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    v_not_b32_e32 v2, v2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v2, v4, v2, v3
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <4 x i8>, ptr addrspace(1) %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i8_s_s(ptr addrspace(4) inreg %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v8i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    s_lshr_b32 s2, s5, 2
; GFX9-NEXT:    s_cmp_eq_u32 s2, 1
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cselect_b32 s3, s1, s0
; GFX9-NEXT:    s_and_b32 s5, s5, 3
; GFX9-NEXT:    s_lshl_b32 s5, s5, 3
; GFX9-NEXT:    s_and_b32 s4, s4, 0xff
; GFX9-NEXT:    s_lshl_b32 s4, s4, s5
; GFX9-NEXT:    s_lshl_b32 s5, 0xff, s5
; GFX9-NEXT:    s_andn2_b32 s3, s3, s5
; GFX9-NEXT:    s_or_b32 s3, s3, s4
; GFX9-NEXT:    s_cmp_eq_u32 s2, 0
; GFX9-NEXT:    s_cselect_b32 s0, s3, s0
; GFX9-NEXT:    s_cmp_eq_u32 s2, 1
; GFX9-NEXT:    s_cselect_b32 s1, s3, s1
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    s_lshr_b32 s2, s5, 2
; GFX8-NEXT:    s_cmp_eq_u32 s2, 1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cselect_b32 s3, s1, s0
; GFX8-NEXT:    s_and_b32 s5, s5, 3
; GFX8-NEXT:    s_lshl_b32 s5, s5, 3
; GFX8-NEXT:    s_and_b32 s4, s4, 0xff
; GFX8-NEXT:    s_lshl_b32 s4, s4, s5
; GFX8-NEXT:    s_lshl_b32 s5, 0xff, s5
; GFX8-NEXT:    s_andn2_b32 s3, s3, s5
; GFX8-NEXT:    s_or_b32 s3, s3, s4
; GFX8-NEXT:    s_cmp_eq_u32 s2, 0
; GFX8-NEXT:    s_cselect_b32 s0, s3, s0
; GFX8-NEXT:    s_cmp_eq_u32 s2, 1
; GFX8-NEXT:    s_cselect_b32 s1, s3, s1
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    s_lshr_b32 s3, s5, 2
; GFX7-NEXT:    s_cmp_eq_u32 s3, 1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_cselect_b32 s2, s1, s0
; GFX7-NEXT:    s_and_b32 s5, s5, 3
; GFX7-NEXT:    s_lshl_b32 s5, s5, 3
; GFX7-NEXT:    s_and_b32 s4, s4, 0xff
; GFX7-NEXT:    s_lshl_b32 s4, s4, s5
; GFX7-NEXT:    s_lshl_b32 s5, 0xff, s5
; GFX7-NEXT:    s_andn2_b32 s2, s2, s5
; GFX7-NEXT:    s_or_b32 s4, s2, s4
; GFX7-NEXT:    s_cmp_eq_u32 s3, 0
; GFX7-NEXT:    s_cselect_b32 s2, s4, s0
; GFX7-NEXT:    s_cmp_eq_u32 s3, 1
; GFX7-NEXT:    s_cselect_b32 s3, s4, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v8i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_lshr_b32 s2, s5, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_cmp_eq_u32 s2, 1
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cselect_b32 s3, s1, s0
; GFX10-NEXT:    s_and_b32 s5, s5, 3
; GFX10-NEXT:    s_and_b32 s4, s4, 0xff
; GFX10-NEXT:    s_lshl_b32 s5, s5, 3
; GFX10-NEXT:    s_lshl_b32 s6, 0xff, s5
; GFX10-NEXT:    s_lshl_b32 s4, s4, s5
; GFX10-NEXT:    s_andn2_b32 s3, s3, s6
; GFX10-NEXT:    s_or_b32 s3, s3, s4
; GFX10-NEXT:    s_cmp_eq_u32 s2, 0
; GFX10-NEXT:    s_cselect_b32 s0, s3, s0
; GFX10-NEXT:    s_cmp_eq_u32 s2, 1
; GFX10-NEXT:    s_cselect_b32 s1, s3, s1
; GFX10-NEXT:    v_mov_b32_e32 v3, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s0
; GFX10-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v8i8_s_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    s_lshr_b32 s2, s5, 2
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_cmp_eq_u32 s2, 1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_cselect_b32 s3, s1, s0
; GFX11-NEXT:    s_and_b32 s5, s5, 3
; GFX11-NEXT:    s_and_b32 s4, s4, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_lshl_b32 s6, 0xff, s5
; GFX11-NEXT:    s_lshl_b32 s4, s4, s5
; GFX11-NEXT:    s_and_not1_b32 s3, s3, s6
; GFX11-NEXT:    s_or_b32 s3, s3, s4
; GFX11-NEXT:    s_cmp_eq_u32 s2, 0
; GFX11-NEXT:    s_cselect_b32 s0, s3, s0
; GFX11-NEXT:    s_cmp_eq_u32 s2, 1
; GFX11-NEXT:    s_cselect_b32 s1, s3, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v3, s1
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s0
; GFX11-NEXT:    global_store_b64 v[0:1], v[2:3], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <8 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i8_s_s(ptr addrspace(1) %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v8i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_and_b32 s1, s3, 3
; GFX9-NEXT:    s_lshr_b32 s0, s3, 2
; GFX9-NEXT:    s_and_b32 s2, s2, 0xff
; GFX9-NEXT:    s_lshl_b32 s1, s1, 3
; GFX9-NEXT:    s_lshl_b32 s2, s2, s1
; GFX9-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX9-NEXT:    s_not_b32 s1, s1
; GFX9-NEXT:    v_mov_b32_e32 v4, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v4, v5, s1, v4
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s0, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_and_b32 s1, s3, 3
; GFX8-NEXT:    s_lshr_b32 s0, s3, 2
; GFX8-NEXT:    s_and_b32 s2, s2, 0xff
; GFX8-NEXT:    s_lshl_b32 s1, s1, 3
; GFX8-NEXT:    s_lshl_b32 s2, s2, s1
; GFX8-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX8-NEXT:    s_not_b32 s1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v4, s1, v4
; GFX8-NEXT:    v_or_b32_e32 v4, s2, v4
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s0, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_and_b32 s1, s3, 3
; GFX7-NEXT:    s_lshr_b32 s0, s3, 2
; GFX7-NEXT:    s_and_b32 s2, s2, 0xff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 3
; GFX7-NEXT:    s_lshl_b32 s2, s2, s1
; GFX7-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX7-NEXT:    s_not_b32 s1, s1
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v2, s1, v2
; GFX7-NEXT:    v_or_b32_e32 v2, s2, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s0, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v8i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_lshr_b32 s0, s3, 2
; GFX10-NEXT:    s_and_b32 s1, s3, 3
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 1
; GFX10-NEXT:    s_lshl_b32 s1, s1, 3
; GFX10-NEXT:    s_and_b32 s2, s2, 0xff
; GFX10-NEXT:    s_lshl_b32 s3, 0xff, s1
; GFX10-NEXT:    s_lshl_b32 s1, s2, s1
; GFX10-NEXT:    s_not_b32 s2, s3
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s0, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc_lo
; GFX10-NEXT:    v_and_or_b32 v4, v2, s2, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v8i8_s_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_b64 v[0:1], v[0:1], off
; GFX11-NEXT:    s_lshr_b32 s0, s3, 2
; GFX11-NEXT:    s_and_b32 s1, s3, 3
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 1
; GFX11-NEXT:    s_lshl_b32 s1, s1, 3
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, 0xff, s1
; GFX11-NEXT:    s_lshl_b32 s1, s2, s1
; GFX11-NEXT:    s_not_b32 s2, s3
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, s0, 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_or_b32 v4, v2, s2, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX11-NEXT:    global_store_b64 v[2:3], v[0:1], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <8 x i8>, ptr addrspace(1 ) %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i8_v_s(ptr addrspace(4) inreg %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v8i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    s_lshr_b32 s2, s4, 2
; GFX9-NEXT:    s_cmp_eq_u32 s2, 1
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cselect_b32 s3, s1, s0
; GFX9-NEXT:    s_and_b32 s4, s4, 3
; GFX9-NEXT:    s_lshl_b32 s4, s4, 3
; GFX9-NEXT:    s_lshl_b32 s5, 0xff, s4
; GFX9-NEXT:    s_andn2_b32 s3, s3, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_lshl_or_b32 v4, v0, s4, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    s_lshr_b32 s2, s4, 2
; GFX8-NEXT:    s_cmp_eq_u32 s2, 1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cselect_b32 s3, s1, s0
; GFX8-NEXT:    s_and_b32 s4, s4, 3
; GFX8-NEXT:    s_lshl_b32 s4, s4, 3
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    s_lshl_b32 s4, 0xff, s4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_andn2_b32 s3, s3, s4
; GFX8-NEXT:    v_or_b32_e32 v4, s3, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    s_lshr_b32 s2, s4, 2
; GFX7-NEXT:    s_cmp_eq_u32 s2, 1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_cselect_b32 s3, s1, s0
; GFX7-NEXT:    s_and_b32 s4, s4, 3
; GFX7-NEXT:    s_lshl_b32 s4, s4, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_lshl_b32 s4, 0xff, s4
; GFX7-NEXT:    s_andn2_b32 s3, s3, s4
; GFX7-NEXT:    v_or_b32_e32 v2, s3, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v8i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_lshr_b32 s2, s4, 2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX10-NEXT:    s_cmp_eq_u32 s2, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cselect_b32 s3, s1, s0
; GFX10-NEXT:    s_and_b32 s4, s4, 3
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    s_lshl_b32 s4, s4, 3
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    s_lshl_b32 s5, 0xff, s4
; GFX10-NEXT:    s_andn2_b32 s3, s3, s5
; GFX10-NEXT:    v_lshl_or_b32 v4, v2, s4, s3
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v8i8_v_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    s_lshr_b32 s2, s4, 2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX11-NEXT:    s_cmp_eq_u32 s2, 1
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_cselect_b32 s3, s1, s0
; GFX11-NEXT:    s_and_b32 s4, s4, 3
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    s_lshl_b32 s4, s4, 3
; GFX11-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-NEXT:    s_lshl_b32 s5, 0xff, s4
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 s3, s3, s5
; GFX11-NEXT:    v_lshl_or_b32 v4, v2, s4, s3
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_cndmask_b32 v0, v0, v4
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX11-NEXT:    global_store_b64 v[2:3], v[0:1], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <8 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i8_s_v(ptr addrspace(4) inreg %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v8i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 2, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    s_movk_i32 s2, 0xff
; GFX9-NEXT:    s_and_b32 s3, s4, 0xff
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_lshlrev_b32_e64 v3, v0, s3
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s2
; GFX9-NEXT:    v_not_b32_e32 v0, v0
; GFX9-NEXT:    v_and_or_b32 v4, v1, v0, v3
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    s_movk_i32 s2, 0xff
; GFX8-NEXT:    s_and_b32 s3, s4, 0xff
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v0, s3
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s2
; GFX8-NEXT:    v_not_b32_e32 v0, v0
; GFX8-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_or_b32_e32 v4, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 2, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    s_and_b32 s2, s4, 0xff
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX7-NEXT:    v_lshl_b32_e32 v3, s2, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_not_b32_e32 v0, v0
; GFX7-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_or_b32_e32 v3, v0, v3
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v8i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v1, 3, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX10-NEXT:    s_and_b32 s2, s4, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v1, s2
; GFX10-NEXT:    v_not_b32_e32 v2, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s1
; GFX10-NEXT:    v_cndmask_b32_e32 v5, s0, v0, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v4
; GFX10-NEXT:    v_and_or_b32 v5, v5, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v8i8_s_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v1, 3, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX11-NEXT:    s_and_b32 s2, s4, 0xff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v4
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s1 :: v_dual_lshlrev_b32 v1, 3, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v5, s0, v0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xff
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v1, s2
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 0, v4
; GFX11-NEXT:    v_not_b32_e32 v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_or_b32 v5, v5, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX11-NEXT:    global_store_b64 v[2:3], v[0:1], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <8 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i8_v_v(ptr addrspace(4) inreg %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v8i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 2, v1
; GFX9-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX9-NEXT:    s_movk_i32 s2, 0xff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, s0
; GFX9-NEXT:    v_mov_b32_e32 v4, s1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX9-NEXT:    v_not_b32_e32 v1, v1
; GFX9-NEXT:    v_and_or_b32 v4, v3, v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 2, v1
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    s_movk_i32 s2, 0xff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NEXT:    v_mov_b32_e32 v4, s1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s2
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX8-NEXT:    v_not_b32_e32 v1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX8-NEXT:    v_or_b32_e32 v4, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 2, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v3, s0
; GFX7-NEXT:    v_mov_b32_e32 v4, s1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX7-NEXT:    v_not_b32_e32 v1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX7-NEXT:    v_or_b32_e32 v3, v1, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v8i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v2, 3, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 2, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v2, 0xff
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_not_b32_e32 v3, v3
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_cndmask_b32_e32 v5, s0, v1, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v4
; GFX10-NEXT:    v_and_or_b32 v5, v5, v3, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v8i8_v_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v2, 3, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 2, v1
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v4
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, s1 :: v_dual_lshlrev_b32 v2, 3, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v5, s0, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v2, 0xff
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v2, v0
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 0, v4
; GFX11-NEXT:    v_not_b32_e32 v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_or_b32 v5, v5, v3, v2
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX11-NEXT:    global_store_b64 v[2:3], v[0:1], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <8 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i8_s_v(ptr addrspace(1) %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v8i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 2, v2
; GFX9-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX9-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NEXT:    s_and_b32 s1, s2, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX9-NEXT:    v_lshlrev_b32_e64 v6, v2, s1
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v2, s0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v5
; GFX9-NEXT:    v_not_b32_e32 v2, v2
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v5
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v2, v7, v2, v6
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    global_store_dwordx2 v[3:4], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 2, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    s_and_b32 s1, s2, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX8-NEXT:    v_lshlrev_b32_e64 v6, v2, s1
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v2, s0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v5
; GFX8-NEXT:    v_not_b32_e32 v2, v2
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v5
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v2, v7, v2
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v6
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[3:4], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 2, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX7-NEXT:    s_and_b32 s0, s2, 0xff
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX7-NEXT:    v_lshl_b32_e32 v4, s0, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX7-NEXT:    v_not_b32_e32 v2, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v3
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v2, v5, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v8i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 2, v2
; GFX10-NEXT:    s_and_b32 s0, s2, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v5
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v3, s0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v5
; GFX10-NEXT:    v_not_b32_e32 v3, v4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc_lo
; GFX10-NEXT:    v_and_or_b32 v4, v4, v3, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v8i8_s_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_b64 v[0:1], v[0:1], off
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 2, v2
; GFX11-NEXT:    s_and_b32 s0, s2, 0xff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v5
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xff
; GFX11-NEXT:    v_lshlrev_b32_e64 v2, v3, s0
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 0, v5
; GFX11-NEXT:    v_not_b32_e32 v3, v4
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_or_b32 v4, v4, v3, v2
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX11-NEXT:    global_store_b64 v[2:3], v[0:1], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <8 x i8>, ptr addrspace(1) %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i8_v_s(ptr addrspace(1) %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v8i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_and_b32 s1, s2, 3
; GFX9-NEXT:    s_lshr_b32 s0, s2, 2
; GFX9-NEXT:    s_lshl_b32 s1, s1, 3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX9-NEXT:    s_not_b32 s1, s1
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v2, v5, s1, v2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s0, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    global_store_dwordx2 v[3:4], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_and_b32 s1, s2, 3
; GFX8-NEXT:    s_lshr_b32 s0, s2, 2
; GFX8-NEXT:    s_lshl_b32 s1, s1, 3
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_not_b32 s1, s1
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v5, s1, v5
; GFX8-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s0, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[3:4], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_and_b32 s1, s2, 3
; GFX7-NEXT:    s_lshr_b32 s0, s2, 2
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    s_lshl_b32 s1, s1, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, s1, v2
; GFX7-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX7-NEXT:    s_not_b32 s1, s1
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v3, s1, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s0, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v8i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_lshr_b32 s1, s2, 2
; GFX10-NEXT:    s_and_b32 s0, s2, 3
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s1, 1
; GFX10-NEXT:    s_lshl_b32 s0, s0, 3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX10-NEXT:    s_not_b32 s0, s0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc_lo
; GFX10-NEXT:    v_and_or_b32 v4, v3, s0, v2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v8i8_v_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_b64 v[0:1], v[0:1], off
; GFX11-NEXT:    s_lshr_b32 s1, s2, 2
; GFX11-NEXT:    s_and_b32 s0, s2, 3
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s1, 1
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-NEXT:    s_lshl_b32 s0, s0, 3
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_cndmask_b32 v3, v0, v1 :: v_dual_lshlrev_b32 v2, s0, v2
; GFX11-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX11-NEXT:    s_not_b32 s0, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_and_or_b32 v4, v3, s0, v2
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, s1, 0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX11-NEXT:    global_store_b64 v[2:3], v[0:1], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <8 x i8>, ptr addrspace(1) %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i8_v_v(ptr addrspace(1) %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v8i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 2, v3
; GFX9-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX9-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v3, v3, s0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v6
; GFX9-NEXT:    v_not_b32_e32 v3, v3
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v6
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v2, v7, v3, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    global_store_dwordx2 v[4:5], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 2, v3
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v3, s0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v6
; GFX8-NEXT:    v_not_b32_e32 v3, v3
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v6
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v3, v7, v3
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 2, v3
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_lshl_b32_e32 v3, 0xff, v3
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX7-NEXT:    v_not_b32_e32 v3, v3
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v4
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v3, v5, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v8i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    v_and_b32_e32 v4, 3, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 2, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v6
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v6
; GFX10-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xff
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_not_b32_e32 v3, v5
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc_lo
; GFX10-NEXT:    v_and_or_b32 v4, v4, v3, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v8i8_v_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_b64 v[0:1], v[0:1], off
; GFX11-NEXT:    v_and_b32_e32 v4, 3, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 2, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v6
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 0, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xff
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v3, v5
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc_lo
; GFX11-NEXT:    v_and_or_b32 v4, v4, v3, v2
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s0
; GFX11-NEXT:    global_store_b64 v[2:3], v[0:1], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <8 x i8>, ptr addrspace(1) %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i8_s_s(ptr addrspace(4) inreg %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v16i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX9-NEXT:    s_lshr_b32 s6, s5, 2
; GFX9-NEXT:    s_cmp_eq_u32 s6, 1
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cselect_b32 s7, s1, s0
; GFX9-NEXT:    s_cmp_eq_u32 s6, 2
; GFX9-NEXT:    s_cselect_b32 s7, s2, s7
; GFX9-NEXT:    s_cmp_eq_u32 s6, 3
; GFX9-NEXT:    s_cselect_b32 s7, s3, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 3
; GFX9-NEXT:    s_lshl_b32 s5, s5, 3
; GFX9-NEXT:    s_and_b32 s4, s4, 0xff
; GFX9-NEXT:    s_lshl_b32 s4, s4, s5
; GFX9-NEXT:    s_lshl_b32 s5, 0xff, s5
; GFX9-NEXT:    s_andn2_b32 s5, s7, s5
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_cmp_eq_u32 s6, 0
; GFX9-NEXT:    s_cselect_b32 s0, s4, s0
; GFX9-NEXT:    s_cmp_eq_u32 s6, 1
; GFX9-NEXT:    s_cselect_b32 s1, s4, s1
; GFX9-NEXT:    s_cmp_eq_u32 s6, 2
; GFX9-NEXT:    s_cselect_b32 s2, s4, s2
; GFX9-NEXT:    s_cmp_eq_u32 s6, 3
; GFX9-NEXT:    s_cselect_b32 s3, s4, s3
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX8-NEXT:    s_lshr_b32 s6, s5, 2
; GFX8-NEXT:    s_cmp_eq_u32 s6, 1
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cselect_b32 s7, s1, s0
; GFX8-NEXT:    s_cmp_eq_u32 s6, 2
; GFX8-NEXT:    s_cselect_b32 s7, s2, s7
; GFX8-NEXT:    s_cmp_eq_u32 s6, 3
; GFX8-NEXT:    s_cselect_b32 s7, s3, s7
; GFX8-NEXT:    s_and_b32 s5, s5, 3
; GFX8-NEXT:    s_lshl_b32 s5, s5, 3
; GFX8-NEXT:    s_and_b32 s4, s4, 0xff
; GFX8-NEXT:    s_lshl_b32 s4, s4, s5
; GFX8-NEXT:    s_lshl_b32 s5, 0xff, s5
; GFX8-NEXT:    s_andn2_b32 s5, s7, s5
; GFX8-NEXT:    s_or_b32 s4, s5, s4
; GFX8-NEXT:    s_cmp_eq_u32 s6, 0
; GFX8-NEXT:    s_cselect_b32 s0, s4, s0
; GFX8-NEXT:    s_cmp_eq_u32 s6, 1
; GFX8-NEXT:    s_cselect_b32 s1, s4, s1
; GFX8-NEXT:    s_cmp_eq_u32 s6, 2
; GFX8-NEXT:    s_cselect_b32 s2, s4, s2
; GFX8-NEXT:    s_cmp_eq_u32 s6, 3
; GFX8-NEXT:    s_cselect_b32 s3, s4, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX7-NEXT:    s_lshr_b32 s6, s5, 2
; GFX7-NEXT:    s_cmp_eq_u32 s6, 1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_cselect_b32 s7, s1, s0
; GFX7-NEXT:    s_cmp_eq_u32 s6, 2
; GFX7-NEXT:    s_cselect_b32 s7, s2, s7
; GFX7-NEXT:    s_cmp_eq_u32 s6, 3
; GFX7-NEXT:    s_cselect_b32 s7, s3, s7
; GFX7-NEXT:    s_and_b32 s5, s5, 3
; GFX7-NEXT:    s_lshl_b32 s5, s5, 3
; GFX7-NEXT:    s_and_b32 s4, s4, 0xff
; GFX7-NEXT:    s_lshl_b32 s4, s4, s5
; GFX7-NEXT:    s_lshl_b32 s5, 0xff, s5
; GFX7-NEXT:    s_andn2_b32 s5, s7, s5
; GFX7-NEXT:    s_or_b32 s4, s5, s4
; GFX7-NEXT:    s_cmp_eq_u32 s6, 0
; GFX7-NEXT:    s_cselect_b32 s0, s4, s0
; GFX7-NEXT:    s_cmp_eq_u32 s6, 1
; GFX7-NEXT:    s_cselect_b32 s1, s4, s1
; GFX7-NEXT:    s_cmp_eq_u32 s6, 2
; GFX7-NEXT:    s_cselect_b32 s2, s4, s2
; GFX7-NEXT:    s_cmp_eq_u32 s6, 3
; GFX7-NEXT:    s_cselect_b32 s3, s4, s3
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v16i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX10-NEXT:    s_lshr_b32 s6, s5, 2
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    s_cmp_eq_u32 s6, 1
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cselect_b32 s7, s1, s0
; GFX10-NEXT:    s_cmp_eq_u32 s6, 2
; GFX10-NEXT:    s_cselect_b32 s7, s2, s7
; GFX10-NEXT:    s_cmp_eq_u32 s6, 3
; GFX10-NEXT:    s_cselect_b32 s7, s3, s7
; GFX10-NEXT:    s_and_b32 s5, s5, 3
; GFX10-NEXT:    s_and_b32 s4, s4, 0xff
; GFX10-NEXT:    s_lshl_b32 s5, s5, 3
; GFX10-NEXT:    s_lshl_b32 s8, 0xff, s5
; GFX10-NEXT:    s_lshl_b32 s4, s4, s5
; GFX10-NEXT:    s_andn2_b32 s5, s7, s8
; GFX10-NEXT:    s_or_b32 s4, s5, s4
; GFX10-NEXT:    s_cmp_eq_u32 s6, 0
; GFX10-NEXT:    s_cselect_b32 s0, s4, s0
; GFX10-NEXT:    s_cmp_eq_u32 s6, 1
; GFX10-NEXT:    s_cselect_b32 s1, s4, s1
; GFX10-NEXT:    s_cmp_eq_u32 s6, 2
; GFX10-NEXT:    s_cselect_b32 s2, s4, s2
; GFX10-NEXT:    s_cmp_eq_u32 s6, 3
; GFX10-NEXT:    s_cselect_b32 s3, s4, s3
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v16i8_s_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    s_lshr_b32 s6, s5, 2
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_cmp_eq_u32 s6, 1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_cselect_b32 s7, s1, s0
; GFX11-NEXT:    s_cmp_eq_u32 s6, 2
; GFX11-NEXT:    s_cselect_b32 s7, s2, s7
; GFX11-NEXT:    s_cmp_eq_u32 s6, 3
; GFX11-NEXT:    s_cselect_b32 s7, s3, s7
; GFX11-NEXT:    s_and_b32 s5, s5, 3
; GFX11-NEXT:    s_and_b32 s4, s4, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_lshl_b32 s8, 0xff, s5
; GFX11-NEXT:    s_lshl_b32 s4, s4, s5
; GFX11-NEXT:    s_and_not1_b32 s5, s7, s8
; GFX11-NEXT:    s_or_b32 s4, s5, s4
; GFX11-NEXT:    s_cmp_eq_u32 s6, 0
; GFX11-NEXT:    s_cselect_b32 s0, s4, s0
; GFX11-NEXT:    s_cmp_eq_u32 s6, 1
; GFX11-NEXT:    s_cselect_b32 s1, s4, s1
; GFX11-NEXT:    s_cmp_eq_u32 s6, 2
; GFX11-NEXT:    s_cselect_b32 s2, s4, s2
; GFX11-NEXT:    s_cmp_eq_u32 s6, 3
; GFX11-NEXT:    s_cselect_b32 s3, s4, s3
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    v_dual_mov_b32 v5, 0 :: v_dual_mov_b32 v0, s0
; GFX11-NEXT:    v_dual_mov_b32 v1, s1 :: v_dual_mov_b32 v2, s2
; GFX11-NEXT:    v_mov_b32_e32 v3, s3
; GFX11-NEXT:    global_store_b128 v[4:5], v[0:3], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <16 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i8_s_s(ptr addrspace(1) %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v16i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_and_b32 s0, s3, 3
; GFX9-NEXT:    s_lshr_b32 s4, s3, 2
; GFX9-NEXT:    s_and_b32 s1, s2, 0xff
; GFX9-NEXT:    s_lshl_b32 s0, s0, 3
; GFX9-NEXT:    s_lshl_b32 s1, s1, s0
; GFX9-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    s_not_b32 s5, s0
; GFX9-NEXT:    v_mov_b32_e32 v6, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v7, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v7, v3, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v6, v7, s5, v6
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_and_b32 s0, s3, 3
; GFX8-NEXT:    s_lshr_b32 s4, s3, 2
; GFX8-NEXT:    s_and_b32 s1, s2, 0xff
; GFX8-NEXT:    s_lshl_b32 s0, s0, 3
; GFX8-NEXT:    s_lshl_b32 s5, s1, s0
; GFX8-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX8-NEXT:    s_not_b32 s6, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v0, v1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v3, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v6, s6, v6
; GFX8-NEXT:    v_or_b32_e32 v6, s5, v6
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_and_b32 s0, s3, 3
; GFX7-NEXT:    s_lshr_b32 s4, s3, 2
; GFX7-NEXT:    s_and_b32 s1, s2, 0xff
; GFX7-NEXT:    s_lshl_b32 s0, s0, 3
; GFX7-NEXT:    s_lshl_b32 s5, s1, s0
; GFX7-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX7-NEXT:    s_not_b32 s6, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v3, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v4
; GFX7-NEXT:    v_or_b32_e32 v4, s5, v4
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v4, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[2:3]
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v16i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_lshr_b32 s4, s3, 2
; GFX10-NEXT:    s_and_b32 s1, s3, 3
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s4, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s4, 2
; GFX10-NEXT:    s_lshl_b32 s3, s1, 3
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, s4, 3
; GFX10-NEXT:    s_and_b32 s2, s2, 0xff
; GFX10-NEXT:    s_lshl_b32 s5, 0xff, s3
; GFX10-NEXT:    s_lshl_b32 s2, s2, s3
; GFX10-NEXT:    s_not_b32 s3, s5
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v4, v2, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v4, v3, s1
; GFX10-NEXT:    v_and_or_b32 v6, v4, s3, s2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, s4, 0
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s1
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v16i8_s_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_b128 v[0:3], v[0:1], off
; GFX11-NEXT:    s_lshr_b32 s4, s3, 2
; GFX11-NEXT:    s_and_b32 s1, s3, 3
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s4, 1
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, s4, 2
; GFX11-NEXT:    s_lshl_b32 s3, s1, 3
; GFX11-NEXT:    v_cmp_eq_u32_e64 s1, s4, 3
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, 0xff, s3
; GFX11-NEXT:    s_lshl_b32 s2, s2, s3
; GFX11-NEXT:    s_not_b32 s3, s5
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v4, v4, v2, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v4, v4, v3, s1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_and_or_b32 v6, v4, s3, s2
; GFX11-NEXT:    v_cmp_eq_u32_e64 s2, s4, 0
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    v_mov_b32_e32 v5, 0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s1
; GFX11-NEXT:    global_store_b128 v[4:5], v[0:3], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <16 x i8>, ptr addrspace(1 ) %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i8_v_s(ptr addrspace(4) inreg %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v16i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX9-NEXT:    s_lshr_b32 s5, s4, 2
; GFX9-NEXT:    s_cmp_eq_u32 s5, 1
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cselect_b32 s6, s1, s0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 2
; GFX9-NEXT:    s_cselect_b32 s6, s2, s6
; GFX9-NEXT:    s_cmp_eq_u32 s5, 3
; GFX9-NEXT:    s_cselect_b32 s6, s3, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 3
; GFX9-NEXT:    s_lshl_b32 s4, s4, 3
; GFX9-NEXT:    s_lshl_b32 s7, 0xff, s4
; GFX9-NEXT:    s_andn2_b32 s6, s6, s7
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    v_lshl_or_b32 v6, v0, s4, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 3
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v3, v6, vcc
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX8-NEXT:    s_lshr_b32 s5, s4, 2
; GFX8-NEXT:    s_cmp_eq_u32 s5, 1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cselect_b32 s6, s1, s0
; GFX8-NEXT:    s_cmp_eq_u32 s5, 2
; GFX8-NEXT:    s_cselect_b32 s6, s2, s6
; GFX8-NEXT:    s_cmp_eq_u32 s5, 3
; GFX8-NEXT:    s_cselect_b32 s6, s3, s6
; GFX8-NEXT:    s_and_b32 s4, s4, 3
; GFX8-NEXT:    s_lshl_b32 s4, s4, 3
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    s_lshl_b32 s4, 0xff, s4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_andn2_b32 s4, s6, s4
; GFX8-NEXT:    v_or_b32_e32 v6, s4, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 3
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v6, vcc
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX7-NEXT:    s_lshr_b32 s5, s4, 2
; GFX7-NEXT:    s_cmp_eq_u32 s5, 1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_cselect_b32 s6, s1, s0
; GFX7-NEXT:    s_cmp_eq_u32 s5, 2
; GFX7-NEXT:    s_cselect_b32 s6, s2, s6
; GFX7-NEXT:    s_cmp_eq_u32 s5, 3
; GFX7-NEXT:    s_cselect_b32 s6, s3, s6
; GFX7-NEXT:    s_and_b32 s4, s4, 3
; GFX7-NEXT:    s_lshl_b32 s4, s4, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_lshl_b32 s4, 0xff, s4
; GFX7-NEXT:    s_andn2_b32 s4, s6, s4
; GFX7-NEXT:    v_or_b32_e32 v4, s4, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 3
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v16i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX10-NEXT:    s_lshr_b32 s5, s4, 2
; GFX10-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX10-NEXT:    s_cmp_eq_u32 s5, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s5, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cselect_b32 s6, s1, s0
; GFX10-NEXT:    s_cmp_eq_u32 s5, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    s_cselect_b32 s6, s2, s6
; GFX10-NEXT:    s_cmp_eq_u32 s5, 3
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    s_cselect_b32 s6, s3, s6
; GFX10-NEXT:    s_and_b32 s4, s4, 3
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    s_lshl_b32 s4, s4, 3
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    s_lshl_b32 s7, 0xff, s4
; GFX10-NEXT:    s_andn2_b32 s6, s6, s7
; GFX10-NEXT:    v_lshl_or_b32 v6, v4, s4, s6
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s5, 1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s5, 2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s5, 3
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v6, vcc_lo
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v16i8_v_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    s_lshr_b32 s5, s4, 2
; GFX11-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX11-NEXT:    s_cmp_eq_u32 s5, 1
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s5, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_cselect_b32 s6, s1, s0
; GFX11-NEXT:    s_cmp_eq_u32 s5, 2
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_cselect_b32 s6, s2, s6
; GFX11-NEXT:    s_cmp_eq_u32 s5, 3
; GFX11-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-NEXT:    s_cselect_b32 s6, s3, s6
; GFX11-NEXT:    s_and_b32 s4, s4, 3
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_lshl_b32 s4, s4, 3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_lshl_b32 s7, 0xff, s4
; GFX11-NEXT:    s_and_not1_b32 s6, s6, s7
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshl_or_b32 v6, v4, s4, s6
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s5, 1
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    v_mov_b32_e32 v5, 0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s5, 2
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s5, 3
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v6, vcc_lo
; GFX11-NEXT:    global_store_b128 v[4:5], v[0:3], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <16 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i8_s_v(ptr addrspace(4) inreg %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v16i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    v_mov_b32_e32 v2, s9
; GFX9-NEXT:    v_mov_b32_e32 v3, s10
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_movk_i32 s5, 0xff
; GFX9-NEXT:    s_and_b32 s4, s4, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s5
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX9-NEXT:    v_not_b32_e32 v0, v0
; GFX9-NEXT:    v_and_or_b32 v6, v1, v0, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    v_mov_b32_e32 v3, s11
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX8-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s8
; GFX8-NEXT:    v_mov_b32_e32 v2, s9
; GFX8-NEXT:    v_mov_b32_e32 v3, s10
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_movk_i32 s5, 0xff
; GFX8-NEXT:    s_and_b32 s4, s4, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s5
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX8-NEXT:    v_not_b32_e32 v0, v0
; GFX8-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_or_b32_e32 v6, v0, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NEXT:    v_mov_b32_e32 v2, s10
; GFX8-NEXT:    v_mov_b32_e32 v3, s11
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX7-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s8
; GFX7-NEXT:    v_mov_b32_e32 v2, s9
; GFX7-NEXT:    v_mov_b32_e32 v3, s10
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    s_and_b32 s4, s4, 0xff
; GFX7-NEXT:    v_mov_b32_e32 v5, s11
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v2, s4, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX7-NEXT:    v_not_b32_e32 v0, v0
; GFX7-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_or_b32_e32 v5, v0, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-NEXT:    v_mov_b32_e32 v1, s9
; GFX7-NEXT:    v_mov_b32_e32 v2, s10
; GFX7-NEXT:    v_mov_b32_e32 v3, s11
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v16i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x0
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 2, v0
; GFX10-NEXT:    v_and_b32_e32 v1, 3, v0
; GFX10-NEXT:    s_and_b32 s1, s4, 0xff
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v6
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 0, v6
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v1, s1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v6
; GFX10-NEXT:    v_not_b32_e32 v5, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s9
; GFX10-NEXT:    v_cndmask_b32_e32 v0, s8, v0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, s10, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v0, s11, s1
; GFX10-NEXT:    v_mov_b32_e32 v0, s8
; GFX10-NEXT:    v_mov_b32_e32 v1, s9
; GFX10-NEXT:    v_mov_b32_e32 v2, s10
; GFX10-NEXT:    v_mov_b32_e32 v3, s11
; GFX10-NEXT:    v_and_or_b32 v7, v7, v5, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v7, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v7, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v7, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s1
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v16i8_s_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[8:11], s[2:3], 0x0
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 2, v0
; GFX11-NEXT:    v_and_b32_e32 v1, 3, v0
; GFX11-NEXT:    s_and_b32 s1, s4, 0xff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v6
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 2, v6
; GFX11-NEXT:    v_cmp_eq_u32_e64 s2, 0, v6
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s9 :: v_dual_lshlrev_b32 v1, 3, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v0, s8, v0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xff
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v1, s1
; GFX11-NEXT:    v_cmp_eq_u32_e64 s1, 3, v6
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, s10, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_not_b32_e32 v5, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v7, v0, s11, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s8 :: v_dual_mov_b32 v1, s9
; GFX11-NEXT:    v_dual_mov_b32 v2, s10 :: v_dual_mov_b32 v3, s11
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_or_b32 v7, v7, v5, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    v_mov_b32_e32 v5, 0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v7, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, v7, s2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v2, v7, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s1
; GFX11-NEXT:    global_store_b128 v[4:5], v[0:3], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <16 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i8_v_v(ptr addrspace(4) inreg %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v16i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 2, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX9-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:    v_mov_b32_e32 v5, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX9-NEXT:    s_movk_i32 s8, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v6, s7
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s8
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[2:3]
; GFX9-NEXT:    v_not_b32_e32 v1, v1
; GFX9-NEXT:    v_and_or_b32 v6, v2, v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 2, v1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    v_mov_b32_e32 v5, s6
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    s_movk_i32 s8, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v6, s7
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s8
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[2:3]
; GFX8-NEXT:    v_not_b32_e32 v1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX8-NEXT:    v_or_b32_e32 v6, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 2, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    v_mov_b32_e32 v5, s6
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_mov_b32_e32 v6, s7
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[2:3]
; GFX7-NEXT:    v_not_b32_e32 v1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_or_b32_e32 v5, v1, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v16i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 2, v1
; GFX10-NEXT:    v_and_b32_e32 v2, 3, v1
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v6
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v6
; GFX10-NEXT:    s_mov_b32 null, 0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 0, v6
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v2, 0xff
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_not_b32_e32 v5, v3
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-NEXT:    v_cndmask_b32_e32 v1, s4, v1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s6, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v1, s7, s1
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-NEXT:    v_mov_b32_e32 v2, s6
; GFX10-NEXT:    v_mov_b32_e32 v3, s7
; GFX10-NEXT:    v_and_or_b32 v7, v7, v5, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v7, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v7, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v7, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s1
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_s_v16i8_v_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 2, v1
; GFX11-NEXT:    v_and_b32_e32 v2, 3, v1
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v6
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 2, v6
; GFX11-NEXT:    v_cmp_eq_u32_e64 s1, 3, v6
; GFX11-NEXT:    v_cmp_eq_u32_e64 s2, 0, v6
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, s5 :: v_dual_lshlrev_b32 v2, 3, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, s4, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v2, 0xff
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, v2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v1, s6, s0
; GFX11-NEXT:    v_not_b32_e32 v5, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v7, v1, s7, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    v_mov_b32_e32 v3, s7
; GFX11-NEXT:    v_and_or_b32 v7, v7, v5, v4
; GFX11-NEXT:    v_mov_b32_e32 v2, s6
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    v_mov_b32_e32 v5, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v7, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, v7, s2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v2, v7, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s1
; GFX11-NEXT:    global_store_b128 v[4:5], v[0:3], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <16 x i8>, ptr addrspace(4) %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i8_s_v(ptr addrspace(1) %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v16i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 2, v2
; GFX9-NEXT:    v_and_b32_e32 v1, 3, v2
; GFX9-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NEXT:    s_and_b32 s1, s2, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v1, s1
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX9-NEXT:    v_not_b32_e32 v1, v1
; GFX9-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v3, v4, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v5, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v6, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v9, v9, v1, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s[2:3]
; GFX9-NEXT:    global_store_dwordx4 v[7:8], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[3:6], v[0:1]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 2, v2
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v2
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    s_and_b32 s1, s2, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v1, s1
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX8-NEXT:    v_not_b32_e32 v1, v1
; GFX8-NEXT:    v_mov_b32_e32 v7, 0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v3, v4, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v9, v9, v5, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v9, v9, v6, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v1, v9, v1
; GFX8-NEXT:    v_or_b32_e32 v9, v1, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s[2:3]
; GFX8-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[3:6], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 2, v2
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v2
; GFX7-NEXT:    s_and_b32 s0, s2, 0xff
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v2, s0, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX7-NEXT:    v_lshl_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX7-NEXT:    v_not_b32_e32 v1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v7, v3, v4, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v7, v7, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v7, v7, v6, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v1, v7, v1
; GFX7-NEXT:    v_or_b32_e32 v7, v1, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v3, v7, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v4, v7, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v5, v7, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v6, v7, s[2:3]
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v16i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 2, v2
; GFX10-NEXT:    v_and_b32_e32 v0, 3, v2
; GFX10-NEXT:    s_and_b32 s1, s2, 0xff
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 0, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v7, v0, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e64 v0, v0, s1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v1
; GFX10-NEXT:    v_not_b32_e32 v7, v7
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s1
; GFX10-NEXT:    v_and_or_b32 v9, v2, v7, v0
; GFX10-NEXT:    v_mov_b32_e32 v7, 0
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s1
; GFX10-NEXT:    global_store_dwordx4 v[7:8], v[0:3], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v16i8_s_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_b128 v[3:6], v[0:1], off
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 2, v2
; GFX11-NEXT:    v_and_b32_e32 v0, 3, v2
; GFX11-NEXT:    s_and_b32 s1, s2, 0xff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 2, v1
; GFX11-NEXT:    v_cmp_eq_u32_e64 s2, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshlrev_b32_e64 v7, v0, 0xff
; GFX11-NEXT:    v_lshlrev_b32_e64 v0, v0, s1
; GFX11-NEXT:    v_cmp_eq_u32_e64 s1, 3, v1
; GFX11-NEXT:    v_not_b32_e32 v7, v7
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_and_or_b32 v9, v2, v7, v0
; GFX11-NEXT:    v_mov_b32_e32 v7, 0
; GFX11-NEXT:    v_dual_mov_b32 v8, 0 :: v_dual_cndmask_b32 v1, v4, v9
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s1
; GFX11-NEXT:    global_store_b128 v[7:8], v[0:3], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <16 x i8>, ptr addrspace(1) %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i8_v_s(ptr addrspace(1) %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v16i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX9-NEXT:    s_and_b32 s0, s2, 3
; GFX9-NEXT:    s_lshr_b32 s4, s2, 2
; GFX9-NEXT:    s_lshl_b32 s0, s0, 3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, s0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    s_not_b32 s5, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX9-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v9, v1, s5, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s[2:3]
; GFX9-NEXT:    global_store_dwordx4 v[7:8], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[3:6], v[0:1]
; GFX8-NEXT:    s_and_b32 s0, s2, 3
; GFX8-NEXT:    s_lshr_b32 s4, s2, 2
; GFX8-NEXT:    s_lshl_b32 s0, s0, 3
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX8-NEXT:    s_not_b32 s5, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_mov_b32_e32 v7, 0
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v1, s5, v1
; GFX8-NEXT:    v_or_b32_e32 v9, v1, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s[2:3]
; GFX8-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[3:6], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_and_b32 s0, s2, 3
; GFX7-NEXT:    s_lshr_b32 s4, s2, 2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v2
; GFX7-NEXT:    s_lshl_b32 s0, s0, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s0, v0
; GFX7-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX7-NEXT:    s_not_b32 s5, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v1, s5, v1
; GFX7-NEXT:    v_or_b32_e32 v7, v1, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v3, v7, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v4, v7, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v5, v7, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v6, v7, s[2:3]
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v16i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX10-NEXT:    s_lshr_b32 s3, s2, 2
; GFX10-NEXT:    s_and_b32 s1, s2, 3
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s3, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s3, 2
; GFX10-NEXT:    s_lshl_b32 s2, s1, 3
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, s3, 3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    s_lshl_b32 s2, 0xff, s2
; GFX10-NEXT:    v_mov_b32_e32 v7, 0
; GFX10-NEXT:    s_not_b32 s2, s2
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s1
; GFX10-NEXT:    v_and_or_b32 v9, v0, s2, v1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, s3, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s1
; GFX10-NEXT:    global_store_dwordx4 v[7:8], v[0:3], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v16i8_v_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_b128 v[3:6], v[0:1], off
; GFX11-NEXT:    s_lshr_b32 s3, s2, 2
; GFX11-NEXT:    s_and_b32 s1, s2, 3
; GFX11-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s3, 1
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, s3, 2
; GFX11-NEXT:    s_lshl_b32 s2, s1, 3
; GFX11-NEXT:    v_cmp_eq_u32_e64 s1, s3, 3
; GFX11-NEXT:    v_mov_b32_e32 v7, 0
; GFX11-NEXT:    v_dual_mov_b32 v8, 0 :: v_dual_and_b32 v1, 0xff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, s2, v1
; GFX11-NEXT:    s_lshl_b32 s2, 0xff, s2
; GFX11-NEXT:    s_not_b32 s2, s2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_and_or_b32 v9, v0, s2, v1
; GFX11-NEXT:    v_cmp_eq_u32_e64 s2, s3, 0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v4, v9, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v3, v9, s2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v5, v9, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v6, v9, s1
; GFX11-NEXT:    global_store_b128 v[7:8], v[0:3], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <16 x i8>, ptr addrspace(1) %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, ptr addrspace(1) null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i8_v_v(ptr addrspace(1) %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v16i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[4:7], v[0:1], off
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 2, v3
; GFX9-NEXT:    v_and_b32_e32 v1, 3, v3
; GFX9-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX9-NEXT:    v_not_b32_e32 v1, v1
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v3, v3, v1, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v4, v3, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v6, v3, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s[2:3]
; GFX9-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[4:7], v[0:1]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 2, v3
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v3
; GFX8-NEXT:    s_movk_i32 s0, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX8-NEXT:    v_not_b32_e32 v1, v1
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX8-NEXT:    v_mov_b32_e32 v9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX8-NEXT:    v_or_b32_e32 v3, v1, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v4, v3, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v6, v3, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s[2:3]
; GFX8-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[4:7], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 2, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v3
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v1, v2
; GFX7-NEXT:    v_lshl_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v0
; GFX7-NEXT:    v_not_b32_e32 v1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX7-NEXT:    v_or_b32_e32 v3, v1, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v4, v3, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v6, v3, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s[2:3]
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v16i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[4:7], v[0:1], off
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 2, v3
; GFX10-NEXT:    v_and_b32_e32 v0, 3, v3
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 0, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v8, v0, 0xff
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_not_b32_e32 v2, v8
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_mov_b32_e32 v9, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s1
; GFX10-NEXT:    v_and_or_b32 v3, v3, v2, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v4, v3, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v6, v3, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s1
; GFX10-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: insertelement_v_v16i8_v_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_load_b128 v[4:7], v[0:1], off
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 2, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-NEXT:    v_and_b32_e32 v0, 3, v3
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 2, v1
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-NEXT:    v_cmp_eq_u32_e64 s1, 3, v1
; GFX11-NEXT:    v_cmp_eq_u32_e64 s2, 0, v1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_dual_cndmask_b32 v3, v4, v5 :: v_dual_lshlrev_b32 v0, 3, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s0
; GFX11-NEXT:    v_lshlrev_b32_e64 v8, v0, 0xff
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v3, v7, s1
; GFX11-NEXT:    v_not_b32_e32 v2, v8
; GFX11-NEXT:    v_mov_b32_e32 v8, 0
; GFX11-NEXT:    v_mov_b32_e32 v9, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v3, v3, v2, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v4, v3, s2
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v6, v3, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s1
; GFX11-NEXT:    global_store_b128 v[8:9], v[0:3], off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <16 x i8>, ptr addrspace(1) %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, ptr addrspace(1) null
  ret void
}
