; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1010 -verify-machineinstrs %s -o - | FileCheck -check-prefix=GCN %s

define amdgpu_cs float @div_sqrt(float inreg %arg1) {
; GCN-LABEL: div_sqrt:
; GCN:       ; %bb.0: ; %.entry
; GCN-NEXT:    v_rsq_f32_e32 v0, s0
; GCN-NEXT:    ; return to shader part epilog
.entry:
  %a = call float @llvm.sqrt.f32(float %arg1)
  %b = fdiv afn float 1.000000e+00, %a
  ret float %b
}

define amdgpu_cs float @sqrt_div(float inreg %arg1) {
; GCN-LABEL: sqrt_div:
; GCN:       ; %bb.0: ; %.entry
; GCN-NEXT:    v_rsq_f32_e32 v0, s0
; GCN-NEXT:    ; return to shader part epilog
.entry:
  %a = fdiv afn float 1.000000e+00, %arg1
  %b = call float @llvm.sqrt.f32(float %a)
  ret float %b
}

define amdgpu_cs float @rcp_sqrt(float inreg %arg1) {
; GCN-LABEL: rcp_sqrt:
; GCN:       ; %bb.0: ; %.entry
; GCN-NEXT:    v_rsq_f32_e32 v0, s0
; GCN-NEXT:    ; return to shader part epilog
.entry:
  %a = call float @llvm.sqrt.f32(float %arg1)
  %b = call float @llvm.amdgcn.rcp.f32(float %a)
  ret float %b
}

define amdgpu_cs float @sqrt_rcp(float inreg %arg1) {
; GCN-LABEL: sqrt_rcp:
; GCN:       ; %bb.0: ; %.entry
; GCN-NEXT:    v_rsq_f32_e32 v0, s0
; GCN-NEXT:    ; return to shader part epilog
.entry:
  %a = call float @llvm.amdgcn.rcp.f32(float %arg1)
  %b = call float @llvm.sqrt.f32(float %a)
  ret float %b
}


declare float @llvm.sqrt.f32(float)
declare float @llvm.amdgcn.rcp.f32(float)
