; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu                               -verify-machineinstrs < %s | FileCheck %s --check-prefix=CHECK
; RUN: llc -mtriple=aarch64-linux-gnu -fast-isel -fast-isel-abort=1 -verify-machineinstrs < %s | FileCheck %s --check-prefix=CHECK

define i32 @sdiv_i32_exact(i32 %a) {
; CHECK-LABEL: sdiv_i32_exact:
; CHECK:       // %bb.0:
; CHECK-NEXT:    asr w0, w0, #3
; CHECK-NEXT:    ret
  %1 = sdiv exact i32 %a, 8
  ret i32 %1
}

define i32 @sdiv_i32_pos(i32 %a) {
; CHECK-LABEL: sdiv_i32_pos:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w8, w0, #7
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    csel w8, w8, w0, lt
; CHECK-NEXT:    asr w0, w8, #3
; CHECK-NEXT:    ret
  %1 = sdiv i32 %a, 8
  ret i32 %1
}

define i32 @sdiv_i32_neg(i32 %a) {
; CHECK-LABEL: sdiv_i32_neg:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w8, w0, #7
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    csel w8, w8, w0, lt
; CHECK-NEXT:    neg w0, w8, asr #3
; CHECK-NEXT:    ret
  %1 = sdiv i32 %a, -8
  ret i32 %1
}

define i64 @sdiv_i64_exact(i64 %a) {
; CHECK-LABEL: sdiv_i64_exact:
; CHECK:       // %bb.0:
; CHECK-NEXT:    asr x0, x0, #4
; CHECK-NEXT:    ret
  %1 = sdiv exact i64 %a, 16
  ret i64 %1
}

define i64 @sdiv_i64_pos(i64 %a) {
; CHECK-LABEL: sdiv_i64_pos:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x8, x0, #15
; CHECK-NEXT:    cmp x0, #0
; CHECK-NEXT:    csel x8, x8, x0, lt
; CHECK-NEXT:    asr x0, x8, #4
; CHECK-NEXT:    ret
  %1 = sdiv i64 %a, 16
  ret i64 %1
}

define i64 @sdiv_i64_neg(i64 %a) {
; CHECK-LABEL: sdiv_i64_neg:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x8, x0, #15
; CHECK-NEXT:    cmp x0, #0
; CHECK-NEXT:    csel x8, x8, x0, lt
; CHECK-NEXT:    neg x0, x8, asr #4
; CHECK-NEXT:    ret
  %1 = sdiv i64 %a, -16
  ret i64 %1
}
