/*
 * livepatch_bsc1234854
 *
 * Fix for CVE-2024-53146, bsc#1234854
 *
 *  Upstream commit:
 *  7f33b92e5b18 ("NFSD: Prevent a potential integer overflow")
 *
 *  SLE12-SP5 commit:
 *  c43d88d67d495240f84924886b800256c3d4d76c
 *
 *  SLE15-SP3 commit:
 *  eb512aa271c4678624e81a7d019f1e1407f4ca00
 *
 *  SLE15-SP4 and -SP5 commit:
 *  79b751c0d4af68e96a0d96b7afed040fecbaa158
 *
 *  SLE15-SP6 commit:
 *  1b6cbfa2fe3204a6fe4079e078f915ae0ed40e74
 *
 *  SLE MICRO-6-0 commit:
 *  1b6cbfa2fe3204a6fe4079e078f915ae0ed40e74
 *
 *  Copyright (c) 2025 SUSE
 *  Author: Ali Abdallah <ali.abdallah@suse.de>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

/* klp-ccp: from fs/nfsd/nfs4callback.c */
#include <linux/sunrpc/clnt.h>
#include <linux/sunrpc/xprt.h>

/* klp-ccp: from include/linux/sunrpc/svc_xprt.h */
#define SUNRPC_SVC_XPRT_H

/* klp-ccp: from include/linux/sunrpc/svc.h */
#define SUNRPC_SVC_H

/* klp-ccp: from include/linux/sunrpc/cache.h */
#define _LINUX_SUNRPC_CACHE_H_

/* klp-ccp: from fs/nfsd/nfs4callback.c */
#include <linux/slab.h>

/* klp-ccp: from fs/nfsd/nfsd.h */
#include <linux/types.h>
#include <linux/mount.h>

/* klp-ccp: from include/linux/nfs.h */
#define _LINUX_NFS_H

/* klp-ccp: from include/linux/crc32.h */
#define _LINUX_CRC32_H

/* klp-ccp: from include/uapi/linux/nfs.h */
#define _UAPI_LINUX_NFS_H

/* klp-ccp: from include/linux/nfs4.h */
#define _LINUX_NFS4_H

/* klp-ccp: from fs/nfsd/nfsd.h */
#include <linux/sunrpc/svc.h>
#include <linux/sunrpc/svc_xprt.h>
#include <linux/sunrpc/msg_prot.h>

#include <uapi/linux/nfsd/debug.h>

/* klp-ccp: from fs/nfsd/netns.h */
#include <net/net_namespace.h>

#include <linux/percpu_counter.h>
#include <linux/siphash.h>

/* klp-ccp: from fs/nfsd/export.h */
#include <linux/sunrpc/cache.h>
#include <linux/percpu_counter.h>
#include <uapi/linux/nfsd/export.h>
#include <linux/nfs4.h>

/* klp-ccp: from fs/nfsd/stats.h */
#include <uapi/linux/nfsd/stats.h>
#include <linux/percpu_counter.h>

/* klp-ccp: from fs/nfsd/state.h */
#include <linux/idr.h>
#include <linux/refcount.h>
#include <linux/sunrpc/svc_xprt.h>

/* klp-ccp: from fs/nfsd/nfsfh.h */
#include <linux/crc32.h>
#include <linux/sunrpc/svc.h>

#include <linux/nfs4.h>

/* klp-ccp: from fs/nfsd/trace.h */
#if !defined(_NFSD_TRACE_H) || defined(TRACE_HEADER_MULTI_READ)

#include <linux/sunrpc/xprt.h>

/* klp-ccp: from fs/nfsd/vfs.h */
#include <linux/fs.h>

/* klp-ccp: from fs/nfsd/cache.h */
#include <linux/sunrpc/svc.h>

#else
#error "klp-ccp: a preceeding branch should have been taken"
/* klp-ccp: from fs/nfsd/trace.h */
#endif /* _NFSD_TRACE_H */

/* klp-ccp: from fs/nfsd/nfs4callback.c */
struct nfs4_cb_compound_hdr {
	/* args */
	u32		ident;	/* minorversion 0 only */
	u32		nops;
	__be32		*nops_p;
	u32		minorversion;
	/* res */
	int		status;
};

int klpp_decode_cb_compound4res(struct xdr_stream *xdr,
				struct nfs4_cb_compound_hdr *hdr)
{
	u32 length;
	__be32 *p;

	p = xdr_inline_decode(xdr, XDR_UNIT);
	if (unlikely(p == NULL))
		goto out_overflow;
	hdr->status = be32_to_cpup(p);
	/* Ignore the tag */
	if (xdr_stream_decode_u32(xdr, &length) < 0)
		goto out_overflow;
	if (xdr_inline_decode(xdr, length) == NULL)
		goto out_overflow;
	if (xdr_stream_decode_u32(xdr, &hdr->nops) < 0)
		goto out_overflow;
	return 0;
out_overflow:
	return -EIO;
}


#include "livepatch_bsc1234854.h"

#include <linux/livepatch.h>

extern typeof(xdr_inline_decode) xdr_inline_decode
	 KLP_RELOC_SYMBOL(nfsd, sunrpc, xdr_inline_decode);
