//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by openapi-gen. DO NOT EDIT.

// This file was autogenerated by openapi-gen. Do not edit it manually!

package v1beta1

import (
	common "k8s.io/kube-openapi/pkg/common"
	spec "k8s.io/kube-openapi/pkg/validation/spec"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		"sigs.k8s.io/cluster-api/api/v1beta1.APIEndpoint":                              schema_sigsk8sio_cluster_api_api_v1beta1_APIEndpoint(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.Bootstrap":                                schema_sigsk8sio_cluster_api_api_v1beta1_Bootstrap(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.Cluster":                                  schema_sigsk8sio_cluster_api_api_v1beta1_Cluster(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterClass":                             schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClass(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassList":                         schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassList(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassPatch":                        schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassPatch(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassSpec":                         schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassSpec(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassStatus":                       schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassStatus(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassStatusVariable":               schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassStatusVariable(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassStatusVariableDefinition":     schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassStatusVariableDefinition(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassVariable":                     schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassVariable(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterList":                              schema_sigsk8sio_cluster_api_api_v1beta1_ClusterList(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterNetwork":                           schema_sigsk8sio_cluster_api_api_v1beta1_ClusterNetwork(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterSpec":                              schema_sigsk8sio_cluster_api_api_v1beta1_ClusterSpec(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterStatus":                            schema_sigsk8sio_cluster_api_api_v1beta1_ClusterStatus(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ClusterVariable":                          schema_sigsk8sio_cluster_api_api_v1beta1_ClusterVariable(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.Condition":                                schema_sigsk8sio_cluster_api_api_v1beta1_Condition(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ControlPlaneClass":                        schema_sigsk8sio_cluster_api_api_v1beta1_ControlPlaneClass(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ControlPlaneClassNamingStrategy":          schema_sigsk8sio_cluster_api_api_v1beta1_ControlPlaneClassNamingStrategy(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ControlPlaneTopology":                     schema_sigsk8sio_cluster_api_api_v1beta1_ControlPlaneTopology(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ExternalPatchDefinition":                  schema_sigsk8sio_cluster_api_api_v1beta1_ExternalPatchDefinition(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.FailureDomainSpec":                        schema_sigsk8sio_cluster_api_api_v1beta1_FailureDomainSpec(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.JSONPatch":                                schema_sigsk8sio_cluster_api_api_v1beta1_JSONPatch(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.JSONPatchValue":                           schema_sigsk8sio_cluster_api_api_v1beta1_JSONPatchValue(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.JSONSchemaProps":                          schema_sigsk8sio_cluster_api_api_v1beta1_JSONSchemaProps(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.LocalObjectTemplate":                      schema_sigsk8sio_cluster_api_api_v1beta1_LocalObjectTemplate(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.Machine":                                  schema_sigsk8sio_cluster_api_api_v1beta1_Machine(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineAddress":                           schema_sigsk8sio_cluster_api_api_v1beta1_MachineAddress(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineDeployment":                        schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeployment(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentClass":                   schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentClass(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentClassNamingStrategy":     schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentClassNamingStrategy(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentClassTemplate":           schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentClassTemplate(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentList":                    schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentList(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentSpec":                    schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentSpec(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentStatus":                  schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentStatus(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentStrategy":                schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentStrategy(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentTopology":                schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentTopology(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentVariables":               schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentVariables(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheck":                       schema_sigsk8sio_cluster_api_api_v1beta1_MachineHealthCheck(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckClass":                  schema_sigsk8sio_cluster_api_api_v1beta1_MachineHealthCheckClass(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckList":                   schema_sigsk8sio_cluster_api_api_v1beta1_MachineHealthCheckList(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckSpec":                   schema_sigsk8sio_cluster_api_api_v1beta1_MachineHealthCheckSpec(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckStatus":                 schema_sigsk8sio_cluster_api_api_v1beta1_MachineHealthCheckStatus(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckTopology":               schema_sigsk8sio_cluster_api_api_v1beta1_MachineHealthCheckTopology(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineList":                              schema_sigsk8sio_cluster_api_api_v1beta1_MachineList(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolClass":                         schema_sigsk8sio_cluster_api_api_v1beta1_MachinePoolClass(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolClassNamingStrategy":           schema_sigsk8sio_cluster_api_api_v1beta1_MachinePoolClassNamingStrategy(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolClassTemplate":                 schema_sigsk8sio_cluster_api_api_v1beta1_MachinePoolClassTemplate(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolTopology":                      schema_sigsk8sio_cluster_api_api_v1beta1_MachinePoolTopology(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolVariables":                     schema_sigsk8sio_cluster_api_api_v1beta1_MachinePoolVariables(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineRollingUpdateDeployment":           schema_sigsk8sio_cluster_api_api_v1beta1_MachineRollingUpdateDeployment(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineSet":                               schema_sigsk8sio_cluster_api_api_v1beta1_MachineSet(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineSetList":                           schema_sigsk8sio_cluster_api_api_v1beta1_MachineSetList(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineSetSpec":                           schema_sigsk8sio_cluster_api_api_v1beta1_MachineSetSpec(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineSetStatus":                         schema_sigsk8sio_cluster_api_api_v1beta1_MachineSetStatus(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineSpec":                              schema_sigsk8sio_cluster_api_api_v1beta1_MachineSpec(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineStatus":                            schema_sigsk8sio_cluster_api_api_v1beta1_MachineStatus(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.MachineTemplateSpec":                      schema_sigsk8sio_cluster_api_api_v1beta1_MachineTemplateSpec(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.NetworkRanges":                            schema_sigsk8sio_cluster_api_api_v1beta1_NetworkRanges(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta":                               schema_sigsk8sio_cluster_api_api_v1beta1_ObjectMeta(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.PatchDefinition":                          schema_sigsk8sio_cluster_api_api_v1beta1_PatchDefinition(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.PatchSelector":                            schema_sigsk8sio_cluster_api_api_v1beta1_PatchSelector(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.PatchSelectorMatch":                       schema_sigsk8sio_cluster_api_api_v1beta1_PatchSelectorMatch(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.PatchSelectorMatchMachineDeploymentClass": schema_sigsk8sio_cluster_api_api_v1beta1_PatchSelectorMatchMachineDeploymentClass(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.PatchSelectorMatchMachinePoolClass":       schema_sigsk8sio_cluster_api_api_v1beta1_PatchSelectorMatchMachinePoolClass(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.Topology":                                 schema_sigsk8sio_cluster_api_api_v1beta1_Topology(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.UnhealthyCondition":                       schema_sigsk8sio_cluster_api_api_v1beta1_UnhealthyCondition(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.VariableSchema":                           schema_sigsk8sio_cluster_api_api_v1beta1_VariableSchema(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.WorkersClass":                             schema_sigsk8sio_cluster_api_api_v1beta1_WorkersClass(ref),
		"sigs.k8s.io/cluster-api/api/v1beta1.WorkersTopology":                          schema_sigsk8sio_cluster_api_api_v1beta1_WorkersTopology(ref),
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_APIEndpoint(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIEndpoint represents a reachable Kubernetes API endpoint.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"host": {
						SchemaProps: spec.SchemaProps{
							Description: "The hostname on which the API server is serving.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "The port on which the API server is serving.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"host", "port"},
			},
		},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_Bootstrap(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Bootstrap encapsulates fields to configure the Machine’s bootstrapping mechanism.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"configRef": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfigRef is a reference to a bootstrap provider-specific resource that holds configuration details. The reference is optional to allow users/operators to specify Bootstrap.DataSecretName without the need of a controller.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
					"dataSecretName": {
						SchemaProps: spec.SchemaProps{
							Description: "DataSecretName is the name of the secret that stores the bootstrap data script. If nil, the Machine should remain in the Pending state.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_Cluster(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Cluster is the Schema for the clusters API.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "sigs.k8s.io/cluster-api/api/v1beta1.ClusterSpec", "sigs.k8s.io/cluster-api/api/v1beta1.ClusterStatus"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClass(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterClass is a template which can be used to create managed topologies.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassSpec", "sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassStatus"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterClassList contains a list of Cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterClass"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "sigs.k8s.io/cluster-api/api/v1beta1.ClusterClass"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassPatch(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterClassPatch defines a patch which is applied to customize the referenced templates.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the patch.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "Description is a human-readable description of this patch.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"enabledIf": {
						SchemaProps: spec.SchemaProps{
							Description: "EnabledIf is a Go template to be used to calculate if a patch should be enabled. It can reference variables defined in .spec.variables and builtin variables. The patch will be enabled if the template evaluates to `true`, otherwise it will be disabled. If EnabledIf is not set, the patch will be enabled per default.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"definitions": {
						SchemaProps: spec.SchemaProps{
							Description: "Definitions define inline patches. Note: Patches will be applied in the order of the array. Note: Exactly one of Definitions or External must be set.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.PatchDefinition"),
									},
								},
							},
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "External defines an external patch. Note: Exactly one of Definitions or External must be set.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.ExternalPatchDefinition"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.ExternalPatchDefinition", "sigs.k8s.io/cluster-api/api/v1beta1.PatchDefinition"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterClassSpec describes the desired state of the ClusterClass.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"infrastructure": {
						SchemaProps: spec.SchemaProps{
							Description: "Infrastructure is a reference to a provider-specific template that holds the details for provisioning infrastructure specific cluster for the underlying provider. The underlying provider is responsible for the implementation of the template to an infrastructure cluster.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.LocalObjectTemplate"),
						},
					},
					"controlPlane": {
						SchemaProps: spec.SchemaProps{
							Description: "ControlPlane is a reference to a local struct that holds the details for provisioning the Control Plane for the Cluster.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.ControlPlaneClass"),
						},
					},
					"workers": {
						SchemaProps: spec.SchemaProps{
							Description: "Workers describes the worker nodes for the cluster. It is a collection of node types which can be used to create the worker nodes of the cluster.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.WorkersClass"),
						},
					},
					"variables": {
						SchemaProps: spec.SchemaProps{
							Description: "Variables defines the variables which can be configured in the Cluster topology and are then used in patches.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassVariable"),
									},
								},
							},
						},
					},
					"patches": {
						SchemaProps: spec.SchemaProps{
							Description: "Patches defines the patches which are applied to customize referenced templates of a ClusterClass. Note: Patches will be applied in the order of the array.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassPatch"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassPatch", "sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassVariable", "sigs.k8s.io/cluster-api/api/v1beta1.ControlPlaneClass", "sigs.k8s.io/cluster-api/api/v1beta1.LocalObjectTemplate", "sigs.k8s.io/cluster-api/api/v1beta1.WorkersClass"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterClassStatus defines the observed state of the ClusterClass.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"variables": {
						SchemaProps: spec.SchemaProps{
							Description: "Variables is a list of ClusterClassStatusVariable that are defined for the ClusterClass.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassStatusVariable"),
									},
								},
							},
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions defines current observed state of the ClusterClass.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.Condition"),
									},
								},
							},
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the latest generation observed by the controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassStatusVariable", "sigs.k8s.io/cluster-api/api/v1beta1.Condition"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassStatusVariable(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterClassStatusVariable defines a variable which appears in the status of a ClusterClass.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the variable.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"definitionsConflict": {
						SchemaProps: spec.SchemaProps{
							Description: "DefinitionsConflict specifies whether or not there are conflicting definitions for a single variable name.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"definitions": {
						SchemaProps: spec.SchemaProps{
							Description: "Definitions is a list of definitions for a variable.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassStatusVariableDefinition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "definitions"},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.ClusterClassStatusVariableDefinition"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassStatusVariableDefinition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterClassStatusVariableDefinition defines a variable which appears in the status of a ClusterClass.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"from": {
						SchemaProps: spec.SchemaProps{
							Description: "From specifies the origin of the variable definition. This will be `inline` for variables defined in the ClusterClass or the name of a patch defined in the ClusterClass for variables discovered from a DiscoverVariables runtime extensions.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"required": {
						SchemaProps: spec.SchemaProps{
							Description: "Required specifies if the variable is required. Note: this applies to the variable as a whole and thus the top-level object defined in the schema. If nested fields are required, this will be specified inside the schema.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"schema": {
						SchemaProps: spec.SchemaProps{
							Description: "Schema defines the schema of the variable.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.VariableSchema"),
						},
					},
				},
				Required: []string{"from", "required", "schema"},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.VariableSchema"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterClassVariable(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterClassVariable defines a variable which can be configured in the Cluster topology and used in patches.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the variable.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"required": {
						SchemaProps: spec.SchemaProps{
							Description: "Required specifies if the variable is required. Note: this applies to the variable as a whole and thus the top-level object defined in the schema. If nested fields are required, this will be specified inside the schema.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"schema": {
						SchemaProps: spec.SchemaProps{
							Description: "Schema defines the schema of the variable.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.VariableSchema"),
						},
					},
				},
				Required: []string{"name", "required", "schema"},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.VariableSchema"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterList contains a list of Cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.Cluster"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "sigs.k8s.io/cluster-api/api/v1beta1.Cluster"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterNetwork(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterNetwork specifies the different networking parameters for a cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiServerPort": {
						SchemaProps: spec.SchemaProps{
							Description: "APIServerPort specifies the port the API Server should bind to. Defaults to 6443.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"services": {
						SchemaProps: spec.SchemaProps{
							Description: "The network ranges from which service VIPs are allocated.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.NetworkRanges"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "The network ranges from which Pod networks are allocated.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.NetworkRanges"),
						},
					},
					"serviceDomain": {
						SchemaProps: spec.SchemaProps{
							Description: "Domain name for services.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.NetworkRanges"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterSpec defines the desired state of Cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"paused": {
						SchemaProps: spec.SchemaProps{
							Description: "Paused can be used to prevent controllers from processing the Cluster and all its associated objects.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"clusterNetwork": {
						SchemaProps: spec.SchemaProps{
							Description: "Cluster network configuration.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterNetwork"),
						},
					},
					"controlPlaneEndpoint": {
						SchemaProps: spec.SchemaProps{
							Description: "ControlPlaneEndpoint represents the endpoint used to communicate with the control plane.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.APIEndpoint"),
						},
					},
					"controlPlaneRef": {
						SchemaProps: spec.SchemaProps{
							Description: "ControlPlaneRef is an optional reference to a provider-specific resource that holds the details for provisioning the Control Plane for a Cluster.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
					"infrastructureRef": {
						SchemaProps: spec.SchemaProps{
							Description: "InfrastructureRef is a reference to a provider-specific resource that holds the details for provisioning infrastructure for a cluster in said provider.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
					"topology": {
						SchemaProps: spec.SchemaProps{
							Description: "This encapsulates the topology for the cluster. NOTE: It is required to enable the ClusterTopology feature gate flag to activate managed topologies support; this feature is highly experimental, and parts of it might still be not implemented.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.Topology"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference", "sigs.k8s.io/cluster-api/api/v1beta1.APIEndpoint", "sigs.k8s.io/cluster-api/api/v1beta1.ClusterNetwork", "sigs.k8s.io/cluster-api/api/v1beta1.Topology"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterStatus defines the observed state of Cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"failureDomains": {
						SchemaProps: spec.SchemaProps{
							Description: "FailureDomains is a slice of failure domain objects synced from the infrastructure provider.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.FailureDomainSpec"),
									},
								},
							},
						},
					},
					"failureReason": {
						SchemaProps: spec.SchemaProps{
							Description: "FailureReason indicates that there is a fatal problem reconciling the state, and will be set to a token value suitable for programmatic interpretation.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"failureMessage": {
						SchemaProps: spec.SchemaProps{
							Description: "FailureMessage indicates that there is a fatal problem reconciling the state, and will be set to a descriptive error message.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"infrastructureReady": {
						SchemaProps: spec.SchemaProps{
							Description: "InfrastructureReady is the state of the infrastructure provider.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"controlPlaneReady": {
						SchemaProps: spec.SchemaProps{
							Description: "ControlPlaneReady defines if the control plane is ready.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions defines current service state of the cluster.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.Condition"),
									},
								},
							},
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the latest generation observed by the controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.Condition", "sigs.k8s.io/cluster-api/api/v1beta1.FailureDomainSpec"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ClusterVariable(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterVariable can be used to customize the Cluster through patches. Each ClusterVariable is associated with a Variable definition in the ClusterClass `status` variables.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the variable.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"definitionFrom": {
						SchemaProps: spec.SchemaProps{
							Description: "DefinitionFrom specifies where the definition of this Variable is from. DefinitionFrom is `inline` when the definition is from the ClusterClass `.spec.variables` or the name of a patch defined in the ClusterClass `.spec.patches` where the patch is external and provides external variables. This field is mandatory if the variable has `DefinitionsConflict: true` in ClusterClass `status.variables[]`",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Value of the variable. Note: the value will be validated against the schema of the corresponding ClusterClassVariable from the ClusterClass. Note: We have to use apiextensionsv1.JSON instead of a custom JSON type, because controller-tools has a hard-coded schema for apiextensionsv1.JSON which cannot be produced by another type via controller-tools, i.e. it is not possible to have no type field. Ref: https://github.com/kubernetes-sigs/controller-tools/blob/d0e03a142d0ecdd5491593e941ee1d6b5d91dba6/pkg/crd/known_types.go#L106-L111",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSON"),
						},
					},
				},
				Required: []string{"name", "value"},
			},
		},
		Dependencies: []string{
			"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSON"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_Condition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Condition defines an observation of a Cluster API resource operational state.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of condition in CamelCase or in foo.example.com/CamelCase. Many .condition.type values are consistent across resources like Available, but because arbitrary conditions can be useful (see .node.status.conditions), the ability to deconflict is important.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"severity": {
						SchemaProps: spec.SchemaProps{
							Description: "Severity provides an explicit classification of Reason code, so the users or machines can immediately understand the current situation and act accordingly. The Severity field MUST be set only when Status=False.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another. This should be when the underlying condition changed. If that is not known, then using the time when the API field changed is acceptable.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition in CamelCase. The specific API may choose whether or not this field is considered a guaranteed API. This field may not be empty.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition. This field may be empty.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status", "lastTransitionTime"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ControlPlaneClass(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControlPlaneClass defines the class for the control plane.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Metadata is the metadata applied to the ControlPlane and the Machines of the ControlPlane if the ControlPlaneTemplate referenced is machine based. If not, it is applied only to the ControlPlane. At runtime this metadata is merged with the corresponding metadata from the topology.\n\nThis field is supported if and only if the control plane provider template referenced is Machine based.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"),
						},
					},
					"ref": {
						SchemaProps: spec.SchemaProps{
							Description: "Ref is a required reference to a custom resource offered by a provider.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
					"machineInfrastructure": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineInfrastructure defines the metadata and infrastructure information for control plane machines.\n\nThis field is supported if and only if the control plane provider template referenced above is Machine based and supports setting replicas.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.LocalObjectTemplate"),
						},
					},
					"machineHealthCheck": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineHealthCheck defines a MachineHealthCheck for this ControlPlaneClass. This field is supported if and only if the ControlPlane provider template referenced above is Machine based and supports setting replicas.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckClass"),
						},
					},
					"namingStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "NamingStrategy allows changing the naming pattern used when creating the control plane provider object.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.ControlPlaneClassNamingStrategy"),
						},
					},
					"nodeDrainTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDrainTimeout is the total amount of time that the controller will spend on draining a node. The default value is 0, meaning that the node can be drained without any time limitations. NOTE: NodeDrainTimeout is different from `kubectl drain --timeout` NOTE: This value can be overridden while defining a Cluster.Topology.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeVolumeDetachTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeVolumeDetachTimeout is the total amount of time that the controller will spend on waiting for all volumes to be detached. The default value is 0, meaning that the volumes can be detached without any time limitations. NOTE: This value can be overridden while defining a Cluster.Topology.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeDeletionTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDeletionTimeout defines how long the controller will attempt to delete the Node that the Machine hosts after the Machine is marked for deletion. A duration of 0 will retry deletion indefinitely. Defaults to 10 seconds. NOTE: This value can be overridden while defining a Cluster.Topology.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
				Required: []string{"ref"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference", "k8s.io/apimachinery/pkg/apis/meta/v1.Duration", "sigs.k8s.io/cluster-api/api/v1beta1.ControlPlaneClassNamingStrategy", "sigs.k8s.io/cluster-api/api/v1beta1.LocalObjectTemplate", "sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckClass", "sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ControlPlaneClassNamingStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControlPlaneClassNamingStrategy defines the naming strategy for control plane objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template defines the template to use for generating the name of the ControlPlane object. If not defined, it will fallback to `{{ .cluster.name }}-{{ .random }}`. If the templated string exceeds 63 characters, it will be trimmed to 58 characters and will get concatenated with a random suffix of length 5. The templating mechanism provides the following arguments: * `.cluster.name`: The name of the cluster object. * `.random`: A random alphanumeric string, without vowels, of length 5.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ControlPlaneTopology(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControlPlaneTopology specifies the parameters for the control plane nodes in the cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Metadata is the metadata applied to the ControlPlane and the Machines of the ControlPlane if the ControlPlaneTemplate referenced by the ClusterClass is machine based. If not, it is applied only to the ControlPlane. At runtime this metadata is merged with the corresponding metadata from the ClusterClass.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"),
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of control plane nodes. If the value is nil, the ControlPlane object is created without the number of Replicas and it's assumed that the control plane controller does not implement support for this field. When specified against a control plane provider that lacks support for this field, this value will be ignored.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"machineHealthCheck": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineHealthCheck allows to enable, disable and override the MachineHealthCheck configuration in the ClusterClass for this control plane.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckTopology"),
						},
					},
					"nodeDrainTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDrainTimeout is the total amount of time that the controller will spend on draining a node. The default value is 0, meaning that the node can be drained without any time limitations. NOTE: NodeDrainTimeout is different from `kubectl drain --timeout`",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeVolumeDetachTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeVolumeDetachTimeout is the total amount of time that the controller will spend on waiting for all volumes to be detached. The default value is 0, meaning that the volumes can be detached without any time limitations.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeDeletionTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDeletionTimeout defines how long the controller will attempt to delete the Node that the Machine hosts after the Machine is marked for deletion. A duration of 0 will retry deletion indefinitely. Defaults to 10 seconds.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration", "sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckTopology", "sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ExternalPatchDefinition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalPatchDefinition defines an external patch. Note: At least one of GenerateExtension or ValidateExtension must be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"generateExtension": {
						SchemaProps: spec.SchemaProps{
							Description: "GenerateExtension references an extension which is called to generate patches.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"validateExtension": {
						SchemaProps: spec.SchemaProps{
							Description: "ValidateExtension references an extension which is called to validate the topology.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"discoverVariablesExtension": {
						SchemaProps: spec.SchemaProps{
							Description: "DiscoverVariablesExtension references an extension which is called to discover variables.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"settings": {
						SchemaProps: spec.SchemaProps{
							Description: "Settings defines key value pairs to be passed to the extensions. Values defined here take precedence over the values defined in the corresponding ExtensionConfig.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_FailureDomainSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FailureDomainSpec is the Schema for Cluster API failure domains. It allows controllers to understand how many failure domains a cluster can optionally span across.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"controlPlane": {
						SchemaProps: spec.SchemaProps{
							Description: "ControlPlane determines if this failure domain is suitable for use by control plane machines.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"attributes": {
						SchemaProps: spec.SchemaProps{
							Description: "Attributes is a free form map of attributes an infrastructure provider might use or require.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_JSONPatch(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JSONPatch defines a JSON patch.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"op": {
						SchemaProps: spec.SchemaProps{
							Description: "Op defines the operation of the patch. Note: Only `add`, `replace` and `remove` are supported.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path defines the path of the patch. Note: Only the spec of a template can be patched, thus the path has to start with /spec/. Note: For now the only allowed array modifications are `append` and `prepend`, i.e.: * for op: `add`: only index 0 (prepend) and - (append) are allowed * for op: `replace` or `remove`: no indexes are allowed",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Value defines the value of the patch. Note: Either Value or ValueFrom is required for add and replace operations. Only one of them is allowed to be set at the same time. Note: We have to use apiextensionsv1.JSON instead of our JSON type, because controller-tools has a hard-coded schema for apiextensionsv1.JSON which cannot be produced by another type (unset type field). Ref: https://github.com/kubernetes-sigs/controller-tools/blob/d0e03a142d0ecdd5491593e941ee1d6b5d91dba6/pkg/crd/known_types.go#L106-L111",
							Ref:         ref("k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSON"),
						},
					},
					"valueFrom": {
						SchemaProps: spec.SchemaProps{
							Description: "ValueFrom defines the value of the patch. Note: Either Value or ValueFrom is required for add and replace operations. Only one of them is allowed to be set at the same time.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.JSONPatchValue"),
						},
					},
				},
				Required: []string{"op", "path"},
			},
		},
		Dependencies: []string{
			"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSON", "sigs.k8s.io/cluster-api/api/v1beta1.JSONPatchValue"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_JSONPatchValue(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JSONPatchValue defines the value of a patch. Note: Only one of the fields is allowed to be set at the same time.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"variable": {
						SchemaProps: spec.SchemaProps{
							Description: "Variable is the variable to be used as value. Variable can be one of the variables defined in .spec.variables or a builtin variable.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the Go template to be used to calculate the value. A template can reference variables defined in .spec.variables and builtin variables. Note: The template must evaluate to a valid YAML or JSON value.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_JSONSchemaProps(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/). This struct has been initially copied from apiextensionsv1.JSONSchemaProps, but all fields which are not supported in CAPI have been removed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "Description is a human-readable description of this variable.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"example": {
						SchemaProps: spec.SchemaProps{
							Description: "Example is an example for this variable.",
							Ref:         ref("k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSON"),
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the variable. Valid values are: object, array, string, integer, number or boolean.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"properties": {
						SchemaProps: spec.SchemaProps{
							Description: "Properties specifies fields of an object. NOTE: Can only be set if type is object. NOTE: Properties is mutually exclusive with AdditionalProperties. NOTE: This field uses PreserveUnknownFields and Schemaless, because recursive validation is not possible.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.JSONSchemaProps"),
									},
								},
							},
						},
					},
					"additionalProperties": {
						SchemaProps: spec.SchemaProps{
							Description: "AdditionalProperties specifies the schema of values in a map (keys are always strings). NOTE: Can only be set if type is object. NOTE: AdditionalProperties is mutually exclusive with Properties. NOTE: This field uses PreserveUnknownFields and Schemaless, because recursive validation is not possible.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.JSONSchemaProps"),
						},
					},
					"required": {
						SchemaProps: spec.SchemaProps{
							Description: "Required specifies which fields of an object are required. NOTE: Can only be set if type is object.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items specifies fields of an array. NOTE: Can only be set if type is array. NOTE: This field uses PreserveUnknownFields and Schemaless, because recursive validation is not possible.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.JSONSchemaProps"),
						},
					},
					"maxItems": {
						SchemaProps: spec.SchemaProps{
							Description: "MaxItems is the max length of an array variable. NOTE: Can only be set if type is array.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"minItems": {
						SchemaProps: spec.SchemaProps{
							Description: "MinItems is the min length of an array variable. NOTE: Can only be set if type is array.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"uniqueItems": {
						SchemaProps: spec.SchemaProps{
							Description: "UniqueItems specifies if items in an array must be unique. NOTE: Can only be set if type is array.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"format": {
						SchemaProps: spec.SchemaProps{
							Description: "Format is an OpenAPI v3 format string. Unknown formats are ignored. For a list of supported formats please see: (of the k8s.io/apiextensions-apiserver version we're currently using) https://github.com/kubernetes/apiextensions-apiserver/blob/master/pkg/apiserver/validation/formats.go NOTE: Can only be set if type is string.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"maxLength": {
						SchemaProps: spec.SchemaProps{
							Description: "MaxLength is the max length of a string variable. NOTE: Can only be set if type is string.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"minLength": {
						SchemaProps: spec.SchemaProps{
							Description: "MinLength is the min length of a string variable. NOTE: Can only be set if type is string.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"pattern": {
						SchemaProps: spec.SchemaProps{
							Description: "Pattern is the regex which a string variable must match. NOTE: Can only be set if type is string.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"maximum": {
						SchemaProps: spec.SchemaProps{
							Description: "Maximum is the maximum of an integer or number variable. If ExclusiveMaximum is false, the variable is valid if it is lower than, or equal to, the value of Maximum. If ExclusiveMaximum is true, the variable is valid if it is strictly lower than the value of Maximum. NOTE: Can only be set if type is integer or number.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"exclusiveMaximum": {
						SchemaProps: spec.SchemaProps{
							Description: "ExclusiveMaximum specifies if the Maximum is exclusive. NOTE: Can only be set if type is integer or number.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"minimum": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum is the minimum of an integer or number variable. If ExclusiveMinimum is false, the variable is valid if it is greater than, or equal to, the value of Minimum. If ExclusiveMinimum is true, the variable is valid if it is strictly greater than the value of Minimum. NOTE: Can only be set if type is integer or number.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"exclusiveMinimum": {
						SchemaProps: spec.SchemaProps{
							Description: "ExclusiveMinimum specifies if the Minimum is exclusive. NOTE: Can only be set if type is integer or number.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"x-kubernetes-preserve-unknown-fields": {
						SchemaProps: spec.SchemaProps{
							Description: "XPreserveUnknownFields allows setting fields in a variable object which are not defined in the variable schema. This affects fields recursively, except if nested properties or additionalProperties are specified in the schema.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"enum": {
						SchemaProps: spec.SchemaProps{
							Description: "Enum is the list of valid values of the variable. NOTE: Can be set for all types.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSON"),
									},
								},
							},
						},
					},
					"default": {
						SchemaProps: spec.SchemaProps{
							Description: "Default is the default value of the variable. NOTE: Can be set for all types.",
							Ref:         ref("k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSON"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSON", "sigs.k8s.io/cluster-api/api/v1beta1.JSONSchemaProps"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_LocalObjectTemplate(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LocalObjectTemplate defines a template for a topology Class.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ref": {
						SchemaProps: spec.SchemaProps{
							Description: "Ref is a required reference to a custom resource offered by a provider.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
				Required: []string{"ref"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_Machine(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Machine is the Schema for the machines API.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "sigs.k8s.io/cluster-api/api/v1beta1.MachineSpec", "sigs.k8s.io/cluster-api/api/v1beta1.MachineStatus"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineAddress(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineAddress contains information for the node's address.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Machine address type, one of Hostname, ExternalIP, InternalIP, ExternalDNS or InternalDNS.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"address": {
						SchemaProps: spec.SchemaProps{
							Description: "The machine address.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "address"},
			},
		},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineDeployment is the Schema for the machinedeployments API.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentSpec", "sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentStatus"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentClass(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineDeploymentClass serves as a template to define a set of worker nodes of the cluster provisioned using the `ClusterClass`.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"class": {
						SchemaProps: spec.SchemaProps{
							Description: "Class denotes a type of worker node present in the cluster, this name MUST be unique within a ClusterClass and can be referenced in the Cluster to create a managed MachineDeployment.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is a local struct containing a collection of templates for creation of MachineDeployment objects representing a set of worker nodes.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentClassTemplate"),
						},
					},
					"machineHealthCheck": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineHealthCheck defines a MachineHealthCheck for this MachineDeploymentClass.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckClass"),
						},
					},
					"failureDomain": {
						SchemaProps: spec.SchemaProps{
							Description: "FailureDomain is the failure domain the machines will be created in. Must match a key in the FailureDomains map stored on the cluster object. NOTE: This value can be overridden while defining a Cluster.Topology using this MachineDeploymentClass.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namingStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "NamingStrategy allows changing the naming pattern used when creating the MachineDeployment.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentClassNamingStrategy"),
						},
					},
					"nodeDrainTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDrainTimeout is the total amount of time that the controller will spend on draining a node. The default value is 0, meaning that the node can be drained without any time limitations. NOTE: NodeDrainTimeout is different from `kubectl drain --timeout` NOTE: This value can be overridden while defining a Cluster.Topology using this MachineDeploymentClass.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeVolumeDetachTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeVolumeDetachTimeout is the total amount of time that the controller will spend on waiting for all volumes to be detached. The default value is 0, meaning that the volumes can be detached without any time limitations. NOTE: This value can be overridden while defining a Cluster.Topology using this MachineDeploymentClass.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeDeletionTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDeletionTimeout defines how long the controller will attempt to delete the Node that the Machine hosts after the Machine is marked for deletion. A duration of 0 will retry deletion indefinitely. Defaults to 10 seconds. NOTE: This value can be overridden while defining a Cluster.Topology using this MachineDeploymentClass.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created machine should be ready. Defaults to 0 (machine will be considered available as soon as it is ready) NOTE: This value can be overridden while defining a Cluster.Topology using this MachineDeploymentClass.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"strategy": {
						SchemaProps: spec.SchemaProps{
							Description: "The deployment strategy to use to replace existing machines with new ones. NOTE: This value can be overridden while defining a Cluster.Topology using this MachineDeploymentClass.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentStrategy"),
						},
					},
				},
				Required: []string{"class", "template"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration", "sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentClassNamingStrategy", "sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentClassTemplate", "sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentStrategy", "sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckClass"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentClassNamingStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineDeploymentClassNamingStrategy defines the naming strategy for machine deployment objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template defines the template to use for generating the name of the MachineDeployment object. If not defined, it will fallback to `{{ .cluster.name }}-{{ .machineDeployment.topologyName }}-{{ .random }}`. If the templated string exceeds 63 characters, it will be trimmed to 58 characters and will get concatenated with a random suffix of length 5. The templating mechanism provides the following arguments: * `.cluster.name`: The name of the cluster object. * `.random`: A random alphanumeric string, without vowels, of length 5. * `.machineDeployment.topologyName`: The name of the MachineDeployment topology (Cluster.spec.topology.workers.machineDeployments[].name).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentClassTemplate(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineDeploymentClassTemplate defines how a MachineDeployment generated from a MachineDeploymentClass should look like.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Metadata is the metadata applied to the MachineDeployment and the machines of the MachineDeployment. At runtime this metadata is merged with the corresponding metadata from the topology.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"),
						},
					},
					"bootstrap": {
						SchemaProps: spec.SchemaProps{
							Description: "Bootstrap contains the bootstrap template reference to be used for the creation of worker Machines.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.LocalObjectTemplate"),
						},
					},
					"infrastructure": {
						SchemaProps: spec.SchemaProps{
							Description: "Infrastructure contains the infrastructure template reference to be used for the creation of worker Machines.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.LocalObjectTemplate"),
						},
					},
				},
				Required: []string{"bootstrap", "infrastructure"},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.LocalObjectTemplate", "sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineDeploymentList contains a list of MachineDeployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineDeployment"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "sigs.k8s.io/cluster-api/api/v1beta1.MachineDeployment"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineDeploymentSpec defines the desired state of MachineDeployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"clusterName": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterName is the name of the Cluster this object belongs to.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of desired machines. This is a pointer to distinguish between explicit zero and not specified.\n\nDefaults to: * if the Kubernetes autoscaler min size and max size annotations are set:\n  - if it's a new MachineDeployment, use min size\n  - if the replicas field of the old MachineDeployment is < min size, use min size\n  - if the replicas field of the old MachineDeployment is > max size, use max size\n  - if the replicas field of the old MachineDeployment is in the (min size, max size) range, keep the value from the oldMD\n* otherwise use 1 Note: Defaulting will be run whenever the replicas field is not set: * A new MachineDeployment is created with replicas not set. * On an existing MachineDeployment the replicas field was first set and is now unset. Those cases are especially relevant for the following Kubernetes autoscaler use cases: * A new MachineDeployment is created and replicas should be managed by the autoscaler * An existing MachineDeployment which initially wasn't controlled by the autoscaler\n  should be later controlled by the autoscaler",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"rolloutAfter": {
						SchemaProps: spec.SchemaProps{
							Description: "RolloutAfter is a field to indicate a rollout should be performed after the specified time even if no changes have been made to the MachineDeployment. Example: In the YAML the time can be specified in the RFC3339 format. To specify the rolloutAfter target as March 9, 2023, at 9 am UTC use \"2023-03-09T09:00:00Z\".",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Label selector for machines. Existing MachineSets whose machines are selected by this will be the ones affected by this deployment. It must match the machine template's labels.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template describes the machines that will be created.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineTemplateSpec"),
						},
					},
					"strategy": {
						SchemaProps: spec.SchemaProps{
							Description: "The deployment strategy to use to replace existing machines with new ones.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentStrategy"),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "MinReadySeconds is the minimum number of seconds for which a Node for a newly created machine should be ready before considering the replica available. Defaults to 0 (machine will be considered available as soon as the Node is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of old MachineSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"paused": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates that the deployment is paused.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"progressDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"clusterName", "selector", "template"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector", "k8s.io/apimachinery/pkg/apis/meta/v1.Time", "sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentStrategy", "sigs.k8s.io/cluster-api/api/v1beta1.MachineTemplateSpec"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineDeploymentStatus defines the observed state of MachineDeployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the deployment controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is the same as the label selector but in the string format to avoid introspection by clients. The string will be in the same format as the query-param syntax. More info about label selectors: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminated machines targeted by this deployment (their labels match the selector).",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminated machines targeted by this deployment that have the desired template spec.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of ready machines targeted by this deployment.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available machines (ready for at least minReadySeconds) targeted by this deployment.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"unavailableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of unavailable machines targeted by this deployment. This is the total number of machines that are still required for the deployment to have 100% available capacity. They may either be machines that are running but not yet available or machines that still have not been created.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase represents the current phase of a MachineDeployment (ScalingUp, ScalingDown, Running, Failed, or Unknown).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions defines current service state of the MachineDeployment.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.Condition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.Condition"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineDeploymentStrategy describes how to replace existing machines with new ones.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment. Allowed values are RollingUpdate and OnDelete. The default is RollingUpdate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if MachineDeploymentStrategyType = RollingUpdate.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineRollingUpdateDeployment"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.MachineRollingUpdateDeployment"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentTopology(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineDeploymentTopology specifies the different parameters for a set of worker nodes in the topology. This set of nodes is managed by a MachineDeployment object whose lifecycle is managed by the Cluster controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Metadata is the metadata applied to the MachineDeployment and the machines of the MachineDeployment. At runtime this metadata is merged with the corresponding metadata from the ClusterClass.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"),
						},
					},
					"class": {
						SchemaProps: spec.SchemaProps{
							Description: "Class is the name of the MachineDeploymentClass used to create the set of worker nodes. This should match one of the deployment classes defined in the ClusterClass object mentioned in the `Cluster.Spec.Class` field.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the unique identifier for this MachineDeploymentTopology. The value is used with other unique identifiers to create a MachineDeployment's Name (e.g. cluster's name, etc). In case the name is greater than the allowed maximum length, the values are hashed together.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"failureDomain": {
						SchemaProps: spec.SchemaProps{
							Description: "FailureDomain is the failure domain the machines will be created in. Must match a key in the FailureDomains map stored on the cluster object.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of worker nodes belonging to this set. If the value is nil, the MachineDeployment is created without the number of Replicas (defaulting to 1) and it's assumed that an external entity (like cluster autoscaler) is responsible for the management of this value.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"machineHealthCheck": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineHealthCheck allows to enable, disable and override the MachineHealthCheck configuration in the ClusterClass for this MachineDeployment.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckTopology"),
						},
					},
					"nodeDrainTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDrainTimeout is the total amount of time that the controller will spend on draining a node. The default value is 0, meaning that the node can be drained without any time limitations. NOTE: NodeDrainTimeout is different from `kubectl drain --timeout`",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeVolumeDetachTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeVolumeDetachTimeout is the total amount of time that the controller will spend on waiting for all volumes to be detached. The default value is 0, meaning that the volumes can be detached without any time limitations.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeDeletionTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDeletionTimeout defines how long the controller will attempt to delete the Node that the Machine hosts after the Machine is marked for deletion. A duration of 0 will retry deletion indefinitely. Defaults to 10 seconds.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created machine should be ready. Defaults to 0 (machine will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"strategy": {
						SchemaProps: spec.SchemaProps{
							Description: "The deployment strategy to use to replace existing machines with new ones.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentStrategy"),
						},
					},
					"variables": {
						SchemaProps: spec.SchemaProps{
							Description: "Variables can be used to customize the MachineDeployment through patches.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentVariables"),
						},
					},
				},
				Required: []string{"class", "name"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration", "sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentStrategy", "sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentVariables", "sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckTopology", "sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineDeploymentVariables(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineDeploymentVariables can be used to provide variables for a specific MachineDeployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"overrides": {
						SchemaProps: spec.SchemaProps{
							Description: "Overrides can be used to override Cluster level variables.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterVariable"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.ClusterVariable"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineHealthCheck(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineHealthCheck is the Schema for the machinehealthchecks API.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of machine health check policy",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of MachineHealthCheck resource",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckSpec", "sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheckStatus"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineHealthCheckClass(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineHealthCheckClass defines a MachineHealthCheck for a group of Machines.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"unhealthyConditions": {
						SchemaProps: spec.SchemaProps{
							Description: "UnhealthyConditions contains a list of the conditions that determine whether a node is considered unhealthy. The conditions are combined in a logical OR, i.e. if any of the conditions is met, the node is unhealthy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.UnhealthyCondition"),
									},
								},
							},
						},
					},
					"maxUnhealthy": {
						SchemaProps: spec.SchemaProps{
							Description: "Any further remediation is only allowed if at most \"MaxUnhealthy\" machines selected by \"selector\" are not healthy.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"unhealthyRange": {
						SchemaProps: spec.SchemaProps{
							Description: "Any further remediation is only allowed if the number of machines selected by \"selector\" as not healthy is within the range of \"UnhealthyRange\". Takes precedence over MaxUnhealthy. Eg. \"[3-5]\" - This means that remediation will be allowed only when: (a) there are at least 3 unhealthy machines (and) (b) there are at most 5 unhealthy machines",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeStartupTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "Machines older than this duration without a node will be considered to have failed and will be remediated. If you wish to disable this feature, set the value explicitly to 0.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"remediationTemplate": {
						SchemaProps: spec.SchemaProps{
							Description: "RemediationTemplate is a reference to a remediation template provided by an infrastructure provider.\n\nThis field is completely optional, when filled, the MachineHealthCheck controller creates a new object from the template referenced and hands off remediation of the machine to a controller that lives outside of Cluster API.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference", "k8s.io/apimachinery/pkg/apis/meta/v1.Duration", "k8s.io/apimachinery/pkg/util/intstr.IntOrString", "sigs.k8s.io/cluster-api/api/v1beta1.UnhealthyCondition"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineHealthCheckList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineHealthCheckList contains a list of MachineHealthCheck.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheck"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "sigs.k8s.io/cluster-api/api/v1beta1.MachineHealthCheck"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineHealthCheckSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineHealthCheckSpec defines the desired state of MachineHealthCheck.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"clusterName": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterName is the name of the Cluster this object belongs to.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Label selector to match machines whose health will be exercised",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"unhealthyConditions": {
						SchemaProps: spec.SchemaProps{
							Description: "UnhealthyConditions contains a list of the conditions that determine whether a node is considered unhealthy.  The conditions are combined in a logical OR, i.e. if any of the conditions is met, the node is unhealthy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.UnhealthyCondition"),
									},
								},
							},
						},
					},
					"maxUnhealthy": {
						SchemaProps: spec.SchemaProps{
							Description: "Any further remediation is only allowed if at most \"MaxUnhealthy\" machines selected by \"selector\" are not healthy.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"unhealthyRange": {
						SchemaProps: spec.SchemaProps{
							Description: "Any further remediation is only allowed if the number of machines selected by \"selector\" as not healthy is within the range of \"UnhealthyRange\". Takes precedence over MaxUnhealthy. Eg. \"[3-5]\" - This means that remediation will be allowed only when: (a) there are at least 3 unhealthy machines (and) (b) there are at most 5 unhealthy machines",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeStartupTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "Machines older than this duration without a node will be considered to have failed and will be remediated. If not set, this value is defaulted to 10 minutes. If you wish to disable this feature, set the value explicitly to 0.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"remediationTemplate": {
						SchemaProps: spec.SchemaProps{
							Description: "RemediationTemplate is a reference to a remediation template provided by an infrastructure provider.\n\nThis field is completely optional, when filled, the MachineHealthCheck controller creates a new object from the template referenced and hands off remediation of the machine to a controller that lives outside of Cluster API.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
				Required: []string{"clusterName", "selector", "unhealthyConditions"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference", "k8s.io/apimachinery/pkg/apis/meta/v1.Duration", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector", "k8s.io/apimachinery/pkg/util/intstr.IntOrString", "sigs.k8s.io/cluster-api/api/v1beta1.UnhealthyCondition"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineHealthCheckStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineHealthCheckStatus defines the observed state of MachineHealthCheck.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expectedMachines": {
						SchemaProps: spec.SchemaProps{
							Description: "total number of machines counted by this machine health check",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentHealthy": {
						SchemaProps: spec.SchemaProps{
							Description: "total number of healthy machines counted by this machine health check",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"remediationsAllowed": {
						SchemaProps: spec.SchemaProps{
							Description: "RemediationsAllowed is the number of further remediations allowed by this machine health check before maxUnhealthy short circuiting will be applied",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the latest generation observed by the controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"targets": {
						SchemaProps: spec.SchemaProps{
							Description: "Targets shows the current list of machines the machine health check is watching",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions defines current service state of the MachineHealthCheck.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.Condition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.Condition"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineHealthCheckTopology(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineHealthCheckTopology defines a MachineHealthCheck for a group of machines.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enable": {
						SchemaProps: spec.SchemaProps{
							Description: "Enable controls if a MachineHealthCheck should be created for the target machines.\n\nIf false: No MachineHealthCheck will be created.\n\nIf not set(default): A MachineHealthCheck will be created if it is defined here or\n in the associated ClusterClass. If no MachineHealthCheck is defined then none will be created.\n\nIf true: A MachineHealthCheck is guaranteed to be created. Cluster validation will block if `enable` is true and no MachineHealthCheck definition is available.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"unhealthyConditions": {
						SchemaProps: spec.SchemaProps{
							Description: "UnhealthyConditions contains a list of the conditions that determine whether a node is considered unhealthy. The conditions are combined in a logical OR, i.e. if any of the conditions is met, the node is unhealthy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.UnhealthyCondition"),
									},
								},
							},
						},
					},
					"maxUnhealthy": {
						SchemaProps: spec.SchemaProps{
							Description: "Any further remediation is only allowed if at most \"MaxUnhealthy\" machines selected by \"selector\" are not healthy.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"unhealthyRange": {
						SchemaProps: spec.SchemaProps{
							Description: "Any further remediation is only allowed if the number of machines selected by \"selector\" as not healthy is within the range of \"UnhealthyRange\". Takes precedence over MaxUnhealthy. Eg. \"[3-5]\" - This means that remediation will be allowed only when: (a) there are at least 3 unhealthy machines (and) (b) there are at most 5 unhealthy machines",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeStartupTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "Machines older than this duration without a node will be considered to have failed and will be remediated. If you wish to disable this feature, set the value explicitly to 0.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"remediationTemplate": {
						SchemaProps: spec.SchemaProps{
							Description: "RemediationTemplate is a reference to a remediation template provided by an infrastructure provider.\n\nThis field is completely optional, when filled, the MachineHealthCheck controller creates a new object from the template referenced and hands off remediation of the machine to a controller that lives outside of Cluster API.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference", "k8s.io/apimachinery/pkg/apis/meta/v1.Duration", "k8s.io/apimachinery/pkg/util/intstr.IntOrString", "sigs.k8s.io/cluster-api/api/v1beta1.UnhealthyCondition"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineList contains a list of Machine.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.Machine"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "sigs.k8s.io/cluster-api/api/v1beta1.Machine"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachinePoolClass(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachinePoolClass serves as a template to define a pool of worker nodes of the cluster provisioned using `ClusterClass`.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"class": {
						SchemaProps: spec.SchemaProps{
							Description: "Class denotes a type of machine pool present in the cluster, this name MUST be unique within a ClusterClass and can be referenced in the Cluster to create a managed MachinePool.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is a local struct containing a collection of templates for creation of MachinePools objects representing a pool of worker nodes.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolClassTemplate"),
						},
					},
					"failureDomains": {
						SchemaProps: spec.SchemaProps{
							Description: "FailureDomains is the list of failure domains the MachinePool should be attached to. Must match a key in the FailureDomains map stored on the cluster object. NOTE: This value can be overridden while defining a Cluster.Topology using this MachinePoolClass.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"namingStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "NamingStrategy allows changing the naming pattern used when creating the MachinePool.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolClassNamingStrategy"),
						},
					},
					"nodeDrainTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDrainTimeout is the total amount of time that the controller will spend on draining a node. The default value is 0, meaning that the node can be drained without any time limitations. NOTE: NodeDrainTimeout is different from `kubectl drain --timeout` NOTE: This value can be overridden while defining a Cluster.Topology using this MachinePoolClass.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeVolumeDetachTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeVolumeDetachTimeout is the total amount of time that the controller will spend on waiting for all volumes to be detached. The default value is 0, meaning that the volumes can be detached without any time limitations. NOTE: This value can be overridden while defining a Cluster.Topology using this MachinePoolClass.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeDeletionTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDeletionTimeout defines how long the controller will attempt to delete the Node that the Machine hosts after the Machine Pool is marked for deletion. A duration of 0 will retry deletion indefinitely. Defaults to 10 seconds. NOTE: This value can be overridden while defining a Cluster.Topology using this MachinePoolClass.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created machine pool should be ready. Defaults to 0 (machine will be considered available as soon as it is ready) NOTE: This value can be overridden while defining a Cluster.Topology using this MachinePoolClass.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"class", "template"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration", "sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolClassNamingStrategy", "sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolClassTemplate"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachinePoolClassNamingStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachinePoolClassNamingStrategy defines the naming strategy for machine pool objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template defines the template to use for generating the name of the MachinePool object. If not defined, it will fallback to `{{ .cluster.name }}-{{ .machinePool.topologyName }}-{{ .random }}`. If the templated string exceeds 63 characters, it will be trimmed to 58 characters and will get concatenated with a random suffix of length 5. The templating mechanism provides the following arguments: * `.cluster.name`: The name of the cluster object. * `.random`: A random alphanumeric string, without vowels, of length 5. * `.machinePool.topologyName`: The name of the MachinePool topology (Cluster.spec.topology.workers.machinePools[].name).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachinePoolClassTemplate(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachinePoolClassTemplate defines how a MachinePool generated from a MachinePoolClass should look like.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Metadata is the metadata applied to the MachinePool. At runtime this metadata is merged with the corresponding metadata from the topology.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"),
						},
					},
					"bootstrap": {
						SchemaProps: spec.SchemaProps{
							Description: "Bootstrap contains the bootstrap template reference to be used for the creation of the Machines in the MachinePool.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.LocalObjectTemplate"),
						},
					},
					"infrastructure": {
						SchemaProps: spec.SchemaProps{
							Description: "Infrastructure contains the infrastructure template reference to be used for the creation of the MachinePool.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.LocalObjectTemplate"),
						},
					},
				},
				Required: []string{"bootstrap", "infrastructure"},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.LocalObjectTemplate", "sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachinePoolTopology(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachinePoolTopology specifies the different parameters for a pool of worker nodes in the topology. This pool of nodes is managed by a MachinePool object whose lifecycle is managed by the Cluster controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Metadata is the metadata applied to the MachinePool. At runtime this metadata is merged with the corresponding metadata from the ClusterClass.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"),
						},
					},
					"class": {
						SchemaProps: spec.SchemaProps{
							Description: "Class is the name of the MachinePoolClass used to create the pool of worker nodes. This should match one of the deployment classes defined in the ClusterClass object mentioned in the `Cluster.Spec.Class` field.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the unique identifier for this MachinePoolTopology. The value is used with other unique identifiers to create a MachinePool's Name (e.g. cluster's name, etc). In case the name is greater than the allowed maximum length, the values are hashed together.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"failureDomains": {
						SchemaProps: spec.SchemaProps{
							Description: "FailureDomains is the list of failure domains the machine pool will be created in. Must match a key in the FailureDomains map stored on the cluster object.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"nodeDrainTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDrainTimeout is the total amount of time that the controller will spend on draining a node. The default value is 0, meaning that the node can be drained without any time limitations. NOTE: NodeDrainTimeout is different from `kubectl drain --timeout`",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeVolumeDetachTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeVolumeDetachTimeout is the total amount of time that the controller will spend on waiting for all volumes to be detached. The default value is 0, meaning that the volumes can be detached without any time limitations.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeDeletionTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDeletionTimeout defines how long the controller will attempt to delete the Node that the MachinePool hosts after the MachinePool is marked for deletion. A duration of 0 will retry deletion indefinitely. Defaults to 10 seconds.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created machine pool should be ready. Defaults to 0 (machine will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of nodes belonging to this pool. If the value is nil, the MachinePool is created without the number of Replicas (defaulting to 1) and it's assumed that an external entity (like cluster autoscaler) is responsible for the management of this value.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"variables": {
						SchemaProps: spec.SchemaProps{
							Description: "Variables can be used to customize the MachinePool through patches.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolVariables"),
						},
					},
				},
				Required: []string{"class", "name"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration", "sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolVariables", "sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachinePoolVariables(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachinePoolVariables can be used to provide variables for a specific MachinePool.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"overrides": {
						SchemaProps: spec.SchemaProps{
							Description: "Overrides can be used to override Cluster level variables.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterVariable"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.ClusterVariable"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineRollingUpdateDeployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineRollingUpdateDeployment is used to control the desired behavior of rolling update.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of machines that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired machines (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 0. Example: when this is set to 30%, the old MachineSet can be scaled down to 70% of desired machines immediately when the rolling update starts. Once new machines are ready, old MachineSet can be scaled down further, followed by scaling up the new MachineSet, ensuring that the total number of machines available at all times during the update is at least 70% of desired machines.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of machines that can be scheduled above the desired number of machines. Value can be an absolute number (ex: 5) or a percentage of desired machines (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 1. Example: when this is set to 30%, the new MachineSet can be scaled up immediately when the rolling update starts, such that the total number of old and new machines do not exceed 130% of desired machines. Once old machines have been killed, new MachineSet can be scaled up further, ensuring that total number of machines running at any time during the update is at most 130% of desired machines.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"deletePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "DeletePolicy defines the policy used by the MachineDeployment to identify nodes to delete when downscaling. Valid values are \"Random, \"Newest\", \"Oldest\" When no value is supplied, the default DeletePolicy of MachineSet is used",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineSet is the Schema for the machinesets API.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "sigs.k8s.io/cluster-api/api/v1beta1.MachineSetSpec", "sigs.k8s.io/cluster-api/api/v1beta1.MachineSetStatus"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineSetList contains a list of MachineSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "sigs.k8s.io/cluster-api/api/v1beta1.MachineSet"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineSetSpec defines the desired state of MachineSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"clusterName": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterName is the name of the Cluster this object belongs to.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "MinReadySeconds is the minimum number of seconds for which a Node for a newly created machine should be ready before considering the replica available. Defaults to 0 (machine will be considered available as soon as the Node is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"deletePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "DeletePolicy defines the policy used to identify nodes to delete when downscaling. Defaults to \"Random\".  Valid values are \"Random, \"Newest\", \"Oldest\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over machines that should match the replica count. Label keys and values that must match in order to be controlled by this MachineSet. It must match the machine template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the machine that will be created if insufficient replicas are detected. Object references to custom resources are treated as templates.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineTemplateSpec"),
						},
					},
				},
				Required: []string{"clusterName", "selector"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector", "sigs.k8s.io/cluster-api/api/v1beta1.MachineTemplateSpec"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineSetStatus defines the observed state of MachineSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is the same as the label selector but in the string format to avoid introspection by clients. The string will be in the same format as the query-param syntax. More info about label selectors: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the most recently observed number of replicas.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"fullyLabeledReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of replicas that have labels matching the labels of the machine template of the MachineSet.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of ready replicas for this MachineSet. A machine is considered ready when the node has been created and is \"Ready\".",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of available replicas (ready for at least minReadySeconds) for this MachineSet.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration reflects the generation of the most recently observed MachineSet.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"failureReason": {
						SchemaProps: spec.SchemaProps{
							Description: "In the event that there is a terminal problem reconciling the replicas, both FailureReason and FailureMessage will be set. FailureReason will be populated with a succinct value suitable for machine interpretation, while FailureMessage will contain a more verbose string suitable for logging and human consumption.\n\nThese fields should not be set for transitive errors that a controller faces that are expected to be fixed automatically over time (like service outages), but instead indicate that something is fundamentally wrong with the MachineTemplate's spec or the configuration of the machine controller, and that manual intervention is required. Examples of terminal errors would be invalid combinations of settings in the spec, values that are unsupported by the machine controller, or the responsible machine controller itself being critically misconfigured.\n\nAny transient errors that occur during the reconciliation of Machines can be added as events to the MachineSet object and/or logged in the controller's output.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"failureMessage": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions defines current service state of the MachineSet.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.Condition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.Condition"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineSpec defines the desired state of Machine.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"clusterName": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterName is the name of the Cluster this object belongs to.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"bootstrap": {
						SchemaProps: spec.SchemaProps{
							Description: "Bootstrap is a reference to a local struct which encapsulates fields to configure the Machine’s bootstrapping mechanism.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.Bootstrap"),
						},
					},
					"infrastructureRef": {
						SchemaProps: spec.SchemaProps{
							Description: "InfrastructureRef is a required reference to a custom resource offered by an infrastructure provider.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version defines the desired Kubernetes version. This field is meant to be optionally used by bootstrap providers.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerID": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderID is the identification ID of the machine provided by the provider. This field must match the provider ID as seen on the node object corresponding to this machine. This field is required by higher level consumers of cluster-api. Example use case is cluster autoscaler with cluster-api as provider. Clean-up logic in the autoscaler compares machines to nodes to find out machines at provider which could not get registered as Kubernetes nodes. With cluster-api as a generic out-of-tree provider for autoscaler, this field is required by autoscaler to be able to have a provider view of the list of machines. Another list of nodes is queried from the k8s apiserver and then a comparison is done to find out unregistered machines and are marked for delete. This field will be set by the actuators and consumed by higher level entities like autoscaler that will be interfacing with cluster-api as generic provider.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"failureDomain": {
						SchemaProps: spec.SchemaProps{
							Description: "FailureDomain is the failure domain the machine will be created in. Must match a key in the FailureDomains map stored on the cluster object.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeDrainTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDrainTimeout is the total amount of time that the controller will spend on draining a node. The default value is 0, meaning that the node can be drained without any time limitations. NOTE: NodeDrainTimeout is different from `kubectl drain --timeout`",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeVolumeDetachTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeVolumeDetachTimeout is the total amount of time that the controller will spend on waiting for all volumes to be detached. The default value is 0, meaning that the volumes can be detached without any time limitations.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeDeletionTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeDeletionTimeout defines how long the controller will attempt to delete the Node that the Machine hosts after the Machine is marked for deletion. A duration of 0 will retry deletion indefinitely. Defaults to 10 seconds.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
				Required: []string{"clusterName", "bootstrap", "infrastructureRef"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference", "k8s.io/apimachinery/pkg/apis/meta/v1.Duration", "sigs.k8s.io/cluster-api/api/v1beta1.Bootstrap"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineStatus defines the observed state of Machine.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"nodeRef": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeRef will point to the corresponding Node if it exists.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
					"nodeInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeInfo is a set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#info",
							Ref:         ref("k8s.io/api/core/v1.NodeSystemInfo"),
						},
					},
					"lastUpdated": {
						SchemaProps: spec.SchemaProps{
							Description: "LastUpdated identifies when the phase of the Machine last transitioned.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"failureReason": {
						SchemaProps: spec.SchemaProps{
							Description: "FailureReason will be set in the event that there is a terminal problem reconciling the Machine and will contain a succinct value suitable for machine interpretation.\n\nThis field should not be set for transitive errors that a controller faces that are expected to be fixed automatically over time (like service outages), but instead indicate that something is fundamentally wrong with the Machine's spec or the configuration of the controller, and that manual intervention is required. Examples of terminal errors would be invalid combinations of settings in the spec, values that are unsupported by the controller, or the responsible controller itself being critically misconfigured.\n\nAny transient errors that occur during the reconciliation of Machines can be added as events to the Machine object and/or logged in the controller's output.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"failureMessage": {
						SchemaProps: spec.SchemaProps{
							Description: "FailureMessage will be set in the event that there is a terminal problem reconciling the Machine and will contain a more verbose string suitable for logging and human consumption.\n\nThis field should not be set for transitive errors that a controller faces that are expected to be fixed automatically over time (like service outages), but instead indicate that something is fundamentally wrong with the Machine's spec or the configuration of the controller, and that manual intervention is required. Examples of terminal errors would be invalid combinations of settings in the spec, values that are unsupported by the controller, or the responsible controller itself being critically misconfigured.\n\nAny transient errors that occur during the reconciliation of Machines can be added as events to the Machine object and/or logged in the controller's output.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"addresses": {
						SchemaProps: spec.SchemaProps{
							Description: "Addresses is a list of addresses assigned to the machine. This field is copied from the infrastructure provider reference.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineAddress"),
									},
								},
							},
						},
					},
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase represents the current phase of machine actuation. E.g. Pending, Running, Terminating, Failed etc.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"certificatesExpiryDate": {
						SchemaProps: spec.SchemaProps{
							Description: "CertificatesExpiryDate is the expiry date of the machine certificates. This value is only set for control plane machines.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"bootstrapReady": {
						SchemaProps: spec.SchemaProps{
							Description: "BootstrapReady is the state of the bootstrap provider.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"infrastructureReady": {
						SchemaProps: spec.SchemaProps{
							Description: "InfrastructureReady is the state of the infrastructure provider.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the latest generation observed by the controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions defines current service state of the Machine.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.Condition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.NodeSystemInfo", "k8s.io/api/core/v1.ObjectReference", "k8s.io/apimachinery/pkg/apis/meta/v1.Time", "sigs.k8s.io/cluster-api/api/v1beta1.Condition", "sigs.k8s.io/cluster-api/api/v1beta1.MachineAddress"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_MachineTemplateSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineTemplateSpec describes the data needed to create a Machine from a template.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the machine. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.MachineSpec", "sigs.k8s.io/cluster-api/api/v1beta1.ObjectMeta"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_NetworkRanges(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NetworkRanges represents ranges of network addresses.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"cidrBlocks": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"cidrBlocks"},
			},
		},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_ObjectMeta(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create. This is a copy of customizable fields from metav1.ObjectMeta.\n\nObjectMeta is embedded in `Machine.Spec`, `MachineDeployment.Template` and `MachineSet.Template`, which are not top-level Kubernetes objects. Given that metav1.ObjectMeta has lots of special cases and read-only fields which end up in the generated CRD validation, having it as a subset simplifies the API and some issues that can impact user experience.\n\nDuring the [upgrade to controller-tools@v2](https://github.com/kubernetes-sigs/cluster-api/pull/1054) for v1alpha2, we noticed a failure would occur running Cluster API test suite against the new CRDs, specifically `spec.metadata.creationTimestamp in body must be of type string: \"null\"`. The investigation showed that `controller-tools@v2` behaves differently than its previous version when handling types from [metav1](k8s.io/apimachinery/pkg/apis/meta/v1) package.\n\nIn more details, we found that embedded (non-top level) types that embedded `metav1.ObjectMeta` had validation properties, including for `creationTimestamp` (metav1.Time). The `metav1.Time` type specifies a custom json marshaller that, when IsZero() is true, returns `null` which breaks validation because the field isn't marked as nullable.\n\nIn future versions, controller-tools@v2 might allow overriding the type and validation for embedded types. When that happens, this hack should be revisited.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"annotations": {
						SchemaProps: spec.SchemaProps{
							Description: "Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_PatchDefinition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PatchDefinition defines a patch which is applied to customize the referenced templates.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector defines on which templates the patch should be applied.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.PatchSelector"),
						},
					},
					"jsonPatches": {
						SchemaProps: spec.SchemaProps{
							Description: "JSONPatches defines the patches which should be applied on the templates matching the selector. Note: Patches will be applied in the order of the array.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.JSONPatch"),
									},
								},
							},
						},
					},
				},
				Required: []string{"selector", "jsonPatches"},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.JSONPatch", "sigs.k8s.io/cluster-api/api/v1beta1.PatchSelector"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_PatchSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PatchSelector defines on which templates the patch should be applied. Note: Matching on APIVersion and Kind is mandatory, to enforce that the patches are written for the correct version. The version of the references in the ClusterClass may be automatically updated during reconciliation if there is a newer version for the same contract. Note: The results of selection based on the individual fields are ANDed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion filters templates by apiVersion.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind filters templates by kind.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"matchResources": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchResources selects templates based on where they are referenced.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.PatchSelectorMatch"),
						},
					},
				},
				Required: []string{"apiVersion", "kind", "matchResources"},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.PatchSelectorMatch"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_PatchSelectorMatch(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PatchSelectorMatch selects templates based on where they are referenced. Note: The selector must match at least one template. Note: The results of selection based on the individual fields are ORed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"controlPlane": {
						SchemaProps: spec.SchemaProps{
							Description: "ControlPlane selects templates referenced in .spec.ControlPlane. Note: this will match the controlPlane and also the controlPlane machineInfrastructure (depending on the kind and apiVersion).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"infrastructureCluster": {
						SchemaProps: spec.SchemaProps{
							Description: "InfrastructureCluster selects templates referenced in .spec.infrastructure.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"machineDeploymentClass": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineDeploymentClass selects templates referenced in specific MachineDeploymentClasses in .spec.workers.machineDeployments.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.PatchSelectorMatchMachineDeploymentClass"),
						},
					},
					"machinePoolClass": {
						SchemaProps: spec.SchemaProps{
							Description: "MachinePoolClass selects templates referenced in specific MachinePoolClasses in .spec.workers.machinePools.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.PatchSelectorMatchMachinePoolClass"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.PatchSelectorMatchMachineDeploymentClass", "sigs.k8s.io/cluster-api/api/v1beta1.PatchSelectorMatchMachinePoolClass"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_PatchSelectorMatchMachineDeploymentClass(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PatchSelectorMatchMachineDeploymentClass selects templates referenced in specific MachineDeploymentClasses in .spec.workers.machineDeployments.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"names": {
						SchemaProps: spec.SchemaProps{
							Description: "Names selects templates by class names.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_PatchSelectorMatchMachinePoolClass(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PatchSelectorMatchMachinePoolClass selects templates referenced in specific MachinePoolClasses in .spec.workers.machinePools.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"names": {
						SchemaProps: spec.SchemaProps{
							Description: "Names selects templates by class names.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_Topology(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Topology encapsulates the information of the managed resources.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"class": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the ClusterClass object to create the topology.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "The Kubernetes version of the cluster.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rolloutAfter": {
						SchemaProps: spec.SchemaProps{
							Description: "RolloutAfter performs a rollout of the entire cluster one component at a time, control plane first and then machine deployments.\n\nDeprecated: This field has no function and is going to be removed in the next apiVersion.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"controlPlane": {
						SchemaProps: spec.SchemaProps{
							Description: "ControlPlane describes the cluster control plane.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.ControlPlaneTopology"),
						},
					},
					"workers": {
						SchemaProps: spec.SchemaProps{
							Description: "Workers encapsulates the different constructs that form the worker nodes for the cluster.",
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.WorkersTopology"),
						},
					},
					"variables": {
						SchemaProps: spec.SchemaProps{
							Description: "Variables can be used to customize the Cluster through patches. They must comply to the corresponding VariableClasses defined in the ClusterClass.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.ClusterVariable"),
									},
								},
							},
						},
					},
				},
				Required: []string{"class", "version"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time", "sigs.k8s.io/cluster-api/api/v1beta1.ClusterVariable", "sigs.k8s.io/cluster-api/api/v1beta1.ControlPlaneTopology", "sigs.k8s.io/cluster-api/api/v1beta1.WorkersTopology"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_UnhealthyCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UnhealthyCondition represents a Node condition type and value with a timeout specified as a duration.  When the named condition has been in the given status for at least the timeout value, a node is considered unhealthy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"timeout": {
						SchemaProps: spec.SchemaProps{
							Default: 0,
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
				Required: []string{"type", "status", "timeout"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_VariableSchema(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VariableSchema defines the schema of a variable.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"openAPIV3Schema": {
						SchemaProps: spec.SchemaProps{
							Description: "OpenAPIV3Schema defines the schema of a variable via OpenAPI v3 schema. The schema is a subset of the schema used in Kubernetes CRDs.",
							Default:     map[string]interface{}{},
							Ref:         ref("sigs.k8s.io/cluster-api/api/v1beta1.JSONSchemaProps"),
						},
					},
				},
				Required: []string{"openAPIV3Schema"},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.JSONSchemaProps"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_WorkersClass(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WorkersClass is a collection of deployment classes.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"machineDeployments": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineDeployments is a list of machine deployment classes that can be used to create a set of worker nodes.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentClass"),
									},
								},
							},
						},
					},
					"machinePools": {
						SchemaProps: spec.SchemaProps{
							Description: "MachinePools is a list of machine pool classes that can be used to create a set of worker nodes.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolClass"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentClass", "sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolClass"},
	}
}

func schema_sigsk8sio_cluster_api_api_v1beta1_WorkersTopology(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WorkersTopology represents the different sets of worker nodes in the cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"machineDeployments": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineDeployments is a list of machine deployments in the cluster.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentTopology"),
									},
								},
							},
						},
					},
					"machinePools": {
						SchemaProps: spec.SchemaProps{
							Description: "MachinePools is a list of machine pools in the cluster.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolTopology"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"sigs.k8s.io/cluster-api/api/v1beta1.MachineDeploymentTopology", "sigs.k8s.io/cluster-api/api/v1beta1.MachinePoolTopology"},
	}
}
