/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * DRA7xx CM1 instance offset macros
 *
 * Copyright (C) 2013 Texas Instruments Incorporated - https://www.ti.com
 *
 * Generated by code originally written by:
 * Paul Walmsley (paul@pwsan.com)
 * Rajendra Nayak (rnayak@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_CM1_7XX_H
#define __ARCH_ARM_MACH_OMAP2_CM1_7XX_H

/* CM1 base address */
#define DRA7XX_CM_CORE_AON_BASE		0x4a005000

#define DRA7XX_CM_CORE_AON_REGADDR(inst, reg)				\
	OMAP2_L4_IO_ADDRESS(DRA7XX_CM_CORE_AON_BASE + (inst) + (reg))

/* CM_CORE_AON instances */
#define DRA7XX_CM_CORE_AON_OCP_SOCKET_INST	0x0000
#define DRA7XX_CM_CORE_AON_CKGEN_INST		0x0100
#define DRA7XX_CM_CORE_AON_MPU_INST		0x0300
#define DRA7XX_CM_CORE_AON_DSP1_INST		0x0400
#define DRA7XX_CM_CORE_AON_IPU_INST		0x0500
#define DRA7XX_CM_CORE_AON_DSP2_INST		0x0600
#define DRA7XX_CM_CORE_AON_EVE1_INST		0x0640
#define DRA7XX_CM_CORE_AON_EVE2_INST		0x0680
#define DRA7XX_CM_CORE_AON_EVE3_INST		0x06c0
#define DRA7XX_CM_CORE_AON_EVE4_INST		0x0700
#define DRA7XX_CM_CORE_AON_RTC_INST		0x0740
#define DRA7XX_CM_CORE_AON_VPE_INST		0x0760

/* CM_CORE_AON clockdomain register offsets (from instance start) */
#define DRA7XX_CM_CORE_AON_MPU_MPU_CDOFFS	0x0000
#define DRA7XX_CM_CORE_AON_DSP1_DSP1_CDOFFS	0x0000
#define DRA7XX_CM_CORE_AON_IPU_IPU1_CDOFFS	0x0000
#define DRA7XX_CM_CORE_AON_IPU_IPU_CDOFFS	0x0040
#define DRA7XX_CM_CORE_AON_DSP2_DSP2_CDOFFS	0x0000
#define DRA7XX_CM_CORE_AON_EVE1_EVE1_CDOFFS	0x0000
#define DRA7XX_CM_CORE_AON_EVE2_EVE2_CDOFFS	0x0000
#define DRA7XX_CM_CORE_AON_EVE3_EVE3_CDOFFS	0x0000
#define DRA7XX_CM_CORE_AON_EVE4_EVE4_CDOFFS	0x0000
#define DRA7XX_CM_CORE_AON_RTC_RTC_CDOFFS	0x0000
#define DRA7XX_CM_CORE_AON_VPE_VPE_CDOFFS	0x0000

#endif
